--
-- PostgreSQL database dump
--

\restrict usH0vAniNhFn1A504zooisfE67UZTioGygVmlBNcTD7BpG2rrIwvfHI3q4GV8gg

-- Dumped from database version 14.19 (Ubuntu 14.19-0ubuntu0.22.04.1)
-- Dumped by pg_dump version 14.19 (Ubuntu 14.19-0ubuntu0.22.04.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: dapodik; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA dapodik;


ALTER SCHEMA dapodik OWNER TO postgres;

--
-- Name: ref; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ref;


ALTER SCHEMA ref OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: matev_rapor; Type: TABLE; Schema: dapodik; Owner: postgres
--

CREATE TABLE dapodik.matev_rapor (
    id_evaluasi uuid NOT NULL,
    nm_mata_evaluasi character varying(50) NOT NULL,
    a_dari_template numeric(1,0) NOT NULL,
    no_urut numeric(3,0) NOT NULL,
    kkm_kognitif numeric(5,2),
    kkm_psikomotorik numeric(5,2),
    rombongan_belajar_id uuid NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    pembelajaran_id uuid,
    create_date timestamp(0) without time zone NOT NULL,
    last_update timestamp(0) without time zone NOT NULL,
    soft_delete numeric(1,0) NOT NULL,
    last_sync timestamp(0) without time zone NOT NULL,
    updater_id uuid NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE dapodik.matev_rapor OWNER TO postgres;

--
-- Name: absensi; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.absensi (
    absensi_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    sakit integer,
    izin integer,
    alpa integer,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.absensi OWNER TO postgres;

--
-- Name: absensi_pkl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.absensi_pkl (
    absensi_pkl_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    pkl_id uuid NOT NULL,
    sakit smallint,
    izin smallint,
    alpa smallint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.absensi_pkl OWNER TO postgres;

--
-- Name: akt_pd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.akt_pd (
    akt_pd_id uuid NOT NULL,
    akt_pd_id_dapodik uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    mou_id uuid NOT NULL,
    id_jns_akt_pd numeric(3,0) NOT NULL,
    judul_akt_pd character varying(500) NOT NULL,
    sk_tugas character varying(80) NOT NULL,
    tgl_sk_tugas date,
    ket_akt text,
    a_komunal numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.akt_pd OWNER TO postgres;

--
-- Name: anggota_akt_pd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.anggota_akt_pd (
    anggota_akt_pd_id uuid NOT NULL,
    id_ang_akt_pd uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    akt_pd_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nm_pd character varying(100) NOT NULL,
    nipd character varying(24) NOT NULL,
    jns_peran_pd character varying(255) DEFAULT '3'::character varying NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.anggota_akt_pd OWNER TO postgres;

--
-- Name: anggota_kewirausahaan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.anggota_kewirausahaan (
    anggota_kewirausahaan_id uuid NOT NULL,
    kewirausahaan_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.anggota_kewirausahaan OWNER TO postgres;

--
-- Name: anggota_rombel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.anggota_rombel (
    anggota_rombel_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    anggota_rombel_id_dapodik uuid NOT NULL,
    anggota_rombel_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.anggota_rombel OWNER TO postgres;

--
-- Name: asesor; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.asesor (
    asesor_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    dudi_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.asesor OWNER TO postgres;

--
-- Name: aspek_budaya_kerja; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.aspek_budaya_kerja (
    aspek_budaya_kerja_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rencana_budaya_kerja_id uuid NOT NULL,
    budaya_kerja_id smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    elemen_id smallint
);


ALTER TABLE public.aspek_budaya_kerja OWNER TO postgres;

--
-- Name: bimbing_pd; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bimbing_pd (
    bimbing_pd_id uuid NOT NULL,
    id_bimb_pd uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    akt_pd_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    ptk_id uuid NOT NULL,
    urutan_pembimbing numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.bimbing_pd OWNER TO postgres;

--
-- Name: bobot_keterampilan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bobot_keterampilan (
    bobot_keterampilan_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    metode_id uuid NOT NULL,
    bobot integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.bobot_keterampilan OWNER TO postgres;

--
-- Name: cache; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cache (
    key character varying(255) NOT NULL,
    value text NOT NULL,
    expiration integer NOT NULL
);


ALTER TABLE public.cache OWNER TO postgres;

--
-- Name: cache_locks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cache_locks (
    key character varying(255) NOT NULL,
    owner character varying(255) NOT NULL,
    expiration integer NOT NULL
);


ALTER TABLE public.cache_locks OWNER TO postgres;

--
-- Name: catatan_budaya_kerja; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.catatan_budaya_kerja (
    catatan_budaya_kerja_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    catatan text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    budaya_kerja_id smallint,
    rencana_budaya_kerja_id uuid
);


ALTER TABLE public.catatan_budaya_kerja OWNER TO postgres;

--
-- Name: catatan_ppk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.catatan_ppk (
    catatan_ppk_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    capaian text NOT NULL,
    catatan_ppk_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.catatan_ppk OWNER TO postgres;

--
-- Name: catatan_wali; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.catatan_wali (
    catatan_wali_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    uraian_deskripsi text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    type character varying(20) DEFAULT 'catatan_walas'::character varying
);


ALTER TABLE public.catatan_wali OWNER TO postgres;

--
-- Name: deskripsi_mata_pelajaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.deskripsi_mata_pelajaran (
    deskripsi_mata_pelajaran_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    deskripsi_pengetahuan text,
    deskripsi_keterampilan text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    kompetensi_dasar_id uuid,
    asal numeric(1,0) DEFAULT '0'::numeric
);


ALTER TABLE public.deskripsi_mata_pelajaran OWNER TO postgres;

--
-- Name: deskripsi_sikap; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.deskripsi_sikap (
    deskripsi_sikap_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    uraian_deskripsi_spiritual text,
    uraian_deskripsi_sosial text,
    predikat_spiritual character varying(3),
    predikat_sosial character varying(3),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.deskripsi_sikap OWNER TO postgres;

--
-- Name: dudi; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dudi (
    dudi_id uuid NOT NULL,
    dudi_id_dapodik uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    nama character varying(100) NOT NULL,
    bidang_usaha_id character varying(10) NOT NULL,
    nama_bidang_usaha character varying(40) NOT NULL,
    alamat_jalan character varying(80) NOT NULL,
    rt numeric(2,0),
    rw numeric(2,0),
    nama_dusun character varying(60),
    desa_kelurahan character varying(60) NOT NULL,
    kode_wilayah character varying(8) NOT NULL,
    kode_pos character varying(5),
    lintang numeric(18,12),
    bujur numeric(18,12),
    nomor_telepon character varying(20),
    nomor_fax character varying(20),
    email character varying(60),
    website character varying(100),
    npwp character varying(15),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.dudi OWNER TO postgres;

--
-- Name: ekstrakurikuler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ekstrakurikuler (
    ekstrakurikuler_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    guru_id uuid NOT NULL,
    nama_ekskul character varying(255) NOT NULL,
    nama_ketua character varying(255),
    nomor_kontak character varying(255),
    alamat_ekskul character varying(255),
    is_dapodik character varying(255) DEFAULT '0'::character varying,
    id_kelas_ekskul uuid,
    rombongan_belajar_id uuid NOT NULL,
    ekstrakurikuler_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.ekstrakurikuler OWNER TO postgres;

--
-- Name: gelar_ptk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.gelar_ptk (
    gelar_ptk_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    gelar_akademik_id integer NOT NULL,
    guru_id uuid NOT NULL,
    ptk_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    no_urut smallint
);


ALTER TABLE public.gelar_ptk OWNER TO postgres;

--
-- Name: kd_nilai; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kd_nilai (
    kd_nilai_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rencana_penilaian_id uuid,
    kompetensi_dasar_id uuid NOT NULL,
    id_kompetensi character varying(255) NOT NULL,
    kd_nilai_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    anggota_rombel_id uuid,
    kompeten numeric(1,0)
);


ALTER TABLE public.kd_nilai OWNER TO postgres;

--
-- Name: nilai; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai (
    nilai_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    kd_nilai_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    kompetensi_id integer NOT NULL,
    nilai integer NOT NULL,
    rerata character varying(10) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai OWNER TO postgres;

--
-- Name: rencana_penilaian; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rencana_penilaian (
    rencana_penilaian_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    kompetensi_id integer NOT NULL,
    nama_penilaian character varying(255) NOT NULL,
    metode_id uuid NOT NULL,
    bobot integer NOT NULL,
    keterangan character varying(255),
    rencana_penilaian_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.rencana_penilaian OWNER TO postgres;

--
-- Name: get_nilai_keterampilan_siswa_by_kd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.get_nilai_keterampilan_siswa_by_kd AS
 SELECT a.kompetensi_id,
    a.anggota_rombel_id,
    b.kompetensi_dasar_id,
    c.pembelajaran_id,
    b.id_kompetensi,
    max(c.bobot) AS bobot,
    ((max(a.nilai))::numeric * (max(c.bobot))::numeric) AS nilai_kd_keterampilan
   FROM ((public.nilai a
     JOIN public.kd_nilai b ON ((b.kd_nilai_id = a.kd_nilai_id)))
     JOIN public.rencana_penilaian c ON ((c.rencana_penilaian_id = b.rencana_penilaian_id)))
  WHERE ((a.deleted_at IS NULL) AND (b.deleted_at IS NULL) AND (c.deleted_at IS NULL))
  GROUP BY a.kompetensi_id, a.anggota_rombel_id, b.kompetensi_dasar_id, c.pembelajaran_id, b.id_kompetensi;


ALTER TABLE public.get_nilai_keterampilan_siswa_by_kd OWNER TO postgres;

--
-- Name: nilai_tp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_tp (
    nilai_tp_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    tp_nilai_id uuid,
    anggota_rombel_id uuid NOT NULL,
    nilai integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    pembelajaran_id uuid,
    tp_id uuid
);


ALTER TABLE public.nilai_tp OWNER TO postgres;

--
-- Name: tp_nilai; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tp_nilai (
    tp_nilai_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rencana_penilaian_id uuid,
    anggota_rombel_id uuid,
    cp_id bigint,
    tp_id uuid,
    kompeten numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    kd_id uuid
);


ALTER TABLE public.tp_nilai OWNER TO postgres;

--
-- Name: get_nilai_kurmer_siswa_by_kd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.get_nilai_kurmer_siswa_by_kd AS
 SELECT a.nilai,
    a.tp_nilai_id,
    a.anggota_rombel_id,
    b.tp_id,
    c.pembelajaran_id,
    c.rencana_penilaian_id,
    round((a.nilai)::numeric) AS nilai_kurmer
   FROM ((public.nilai_tp a
     JOIN public.tp_nilai b ON ((b.tp_nilai_id = a.tp_nilai_id)))
     JOIN public.rencana_penilaian c ON ((c.rencana_penilaian_id = b.rencana_penilaian_id)))
  WHERE (c.deleted_at IS NULL)
  GROUP BY a.nilai, a.tp_nilai_id, a.anggota_rombel_id, b.tp_id, c.pembelajaran_id, c.rencana_penilaian_id;


ALTER TABLE public.get_nilai_kurmer_siswa_by_kd OWNER TO postgres;

--
-- Name: get_nilai_pengetahuan_siswa_by_kd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.get_nilai_pengetahuan_siswa_by_kd AS
 SELECT a.nilai,
    c.bobot,
    a.kompetensi_id,
    a.anggota_rombel_id,
    b.kompetensi_dasar_id,
    c.pembelajaran_id,
    b.id_kompetensi,
    c.rencana_penilaian_id,
    round(((a.nilai)::numeric * (c.bobot)::numeric), 0) AS nilai_kd_pengetahuan
   FROM ((public.nilai a
     JOIN public.kd_nilai b ON ((b.kd_nilai_id = a.kd_nilai_id)))
     JOIN public.rencana_penilaian c ON ((c.rencana_penilaian_id = b.rencana_penilaian_id)))
  WHERE ((a.deleted_at IS NULL) AND (b.deleted_at IS NULL) AND (c.deleted_at IS NULL))
  GROUP BY a.nilai, c.bobot, a.kompetensi_id, a.anggota_rombel_id, b.kompetensi_dasar_id, c.pembelajaran_id, b.id_kompetensi, c.rencana_penilaian_id;


ALTER TABLE public.get_nilai_pengetahuan_siswa_by_kd OWNER TO postgres;

--
-- Name: get_nilai_pk_siswa_by_kd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.get_nilai_pk_siswa_by_kd AS
 SELECT a.nilai,
    c.bobot,
    a.kompetensi_id,
    a.anggota_rombel_id,
    b.kompetensi_dasar_id,
    c.pembelajaran_id,
    b.id_kompetensi,
    c.rencana_penilaian_id,
    round(((a.nilai)::numeric * (c.bobot)::numeric), 0) AS nilai_kd_pk
   FROM ((public.nilai a
     JOIN public.kd_nilai b ON ((b.kd_nilai_id = a.kd_nilai_id)))
     JOIN public.rencana_penilaian c ON ((c.rencana_penilaian_id = b.rencana_penilaian_id)))
  WHERE ((a.deleted_at IS NULL) AND (b.deleted_at IS NULL) AND (c.deleted_at IS NULL))
  GROUP BY a.nilai, c.bobot, a.kompetensi_id, a.anggota_rombel_id, b.kompetensi_dasar_id, c.pembelajaran_id, b.id_kompetensi, c.rencana_penilaian_id;


ALTER TABLE public.get_nilai_pk_siswa_by_kd OWNER TO postgres;

--
-- Name: guru; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.guru (
    guru_id uuid NOT NULL,
    guru_id_dapodik uuid,
    sekolah_id uuid NOT NULL,
    nama character varying(255) NOT NULL,
    nuptk character varying(255),
    nip character varying(255),
    jenis_kelamin character varying(255) NOT NULL,
    tempat_lahir character varying(255) NOT NULL,
    tanggal_lahir date NOT NULL,
    nik character varying(16),
    jenis_ptk_id integer NOT NULL,
    agama_id integer NOT NULL,
    status_kepegawaian_id integer NOT NULL,
    alamat character varying(255),
    rt character varying(255),
    rw character varying(255),
    desa_kelurahan character varying(255),
    kecamatan character varying(255),
    kode_wilayah character varying(255) NOT NULL,
    kode_pos character varying(255),
    no_hp character varying(255),
    email character varying(255),
    photo character varying(255),
    guru_id_erapor integer,
    is_dapodik integer DEFAULT 0 NOT NULL,
    guru_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    jabatan_ptk_id numeric(5,0),
    gelar_depan character varying(255),
    gelar_belakang character varying(255)
);


ALTER TABLE public.guru OWNER TO postgres;

--
-- Name: jurusan_sp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jurusan_sp (
    jurusan_sp_id uuid NOT NULL,
    jurusan_sp_id_dapodik uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    jurusan_id character varying(255) NOT NULL,
    nama_jurusan_sp character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.jurusan_sp OWNER TO postgres;

--
-- Name: kasek; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kasek (
    kasek_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.kasek OWNER TO postgres;

--
-- Name: kenaikan_kelas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kenaikan_kelas (
    kenaikan_kelas_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    status integer DEFAULT 2 NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    nama_kelas character varying(255)
);


ALTER TABLE public.kenaikan_kelas OWNER TO postgres;

--
-- Name: kewirausahaan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kewirausahaan (
    kewirausahaan_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid,
    pola character varying(10) NOT NULL,
    jenis character varying(10) NOT NULL,
    nama_produk character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.kewirausahaan OWNER TO postgres;

--
-- Name: migrasi; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrasi (
    nama_table character varying(255) NOT NULL,
    jumlah_asal integer NOT NULL,
    jumlah_masuk integer NOT NULL
);


ALTER TABLE public.migrasi OWNER TO postgres;

--
-- Name: migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrations (
    id integer NOT NULL,
    migration character varying(255) NOT NULL,
    batch integer NOT NULL
);


ALTER TABLE public.migrations OWNER TO postgres;

--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.migrations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO postgres;

--
-- Name: migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.migrations_id_seq OWNED BY public.migrations.id;


--
-- Name: mou; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mou (
    mou_id uuid NOT NULL,
    mou_id_dapodik uuid NOT NULL,
    id_jns_ks numeric(6,0) NOT NULL,
    dudi_id uuid NOT NULL,
    dudi_id_dapodik uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    nomor_mou character varying(80) NOT NULL,
    judul_mou character varying(80) NOT NULL,
    tanggal_mulai date NOT NULL,
    tanggal_selesai date NOT NULL,
    nama_dudi character varying(100) NOT NULL,
    npwp_dudi character varying(15),
    nama_bidang_usaha character varying(40) NOT NULL,
    telp_kantor character varying(20),
    fax character varying(20),
    contact_person character varying(100),
    telp_cp character varying(20),
    jabatan_cp character varying(40),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.mou OWNER TO postgres;

--
-- Name: nilai_akhir; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_akhir (
    nilai_akhir_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    kompetensi_id integer NOT NULL,
    nilai integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_akhir OWNER TO postgres;

--
-- Name: nilai_budaya_kerja; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_budaya_kerja (
    nilai_budaya_kerja_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    aspek_budaya_kerja_id uuid,
    elemen_id smallint NOT NULL,
    opsi_id smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    guru_id uuid,
    budaya_kerja_id smallint,
    tanggal date,
    deskripsi text
);


ALTER TABLE public.nilai_budaya_kerja OWNER TO postgres;

--
-- Name: nilai_ekstrakurikuler; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_ekstrakurikuler (
    nilai_ekstrakurikuler_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    ekstrakurikuler_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai integer,
    deskripsi_ekskul text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_ekstrakurikuler OWNER TO postgres;

--
-- Name: nilai_karakter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_karakter (
    nilai_karakter_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    catatan_ppk_id uuid NOT NULL,
    sikap_id integer NOT NULL,
    deskripsi text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_karakter OWNER TO postgres;

--
-- Name: nilai_pkl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_pkl (
    nilai_pkl_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    pkl_id uuid NOT NULL,
    tp_id uuid NOT NULL,
    nilai smallint NOT NULL,
    deskripsi text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.nilai_pkl OWNER TO postgres;

--
-- Name: nilai_pts; Type: TABLE; Schema: public; Owner: kurikulum
--

CREATE TABLE public.nilai_pts (
    nilai_pts_id uuid NOT NULL,
    rapor_pts_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai smallint NOT NULL,
    deskripsi text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.nilai_pts OWNER TO kurikulum;

--
-- Name: nilai_rapor; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_rapor (
    nilai_rapor_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai_p integer DEFAULT 0,
    nilai_k integer DEFAULT 0,
    rasio_p integer DEFAULT 0,
    rasio_k integer DEFAULT 0,
    total_nilai integer,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_rapor OWNER TO postgres;

--
-- Name: nilai_remedial; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_remedial (
    nilai_remedial_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    kompetensi_id integer NOT NULL,
    nilai text NOT NULL,
    rerata_akhir integer NOT NULL,
    rerata_remedial integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_remedial OWNER TO postgres;

--
-- Name: nilai_sikap; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_sikap (
    nilai_sikap_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    tanggal_sikap date NOT NULL,
    sikap_id integer NOT NULL,
    opsi_sikap integer NOT NULL,
    uraian_sikap text NOT NULL,
    nilai_sikap_id_erapor integer,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_sikap OWNER TO postgres;

--
-- Name: nilai_sumatif; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_sumatif (
    nilai_sumatif_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    jenis character varying(10)
);


ALTER TABLE public.nilai_sumatif OWNER TO postgres;

--
-- Name: nilai_ukk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_ukk (
    nilai_ukk_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rencana_ukk_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    nilai integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_ukk OWNER TO postgres;

--
-- Name: nilai_un; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_un (
    nilai_un_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai integer DEFAULT 0,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_un OWNER TO postgres;

--
-- Name: nilai_us; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.nilai_us (
    nilai_us_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    nilai integer DEFAULT 0,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.nilai_us OWNER TO postgres;

--
-- Name: password_resets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.password_resets (
    email character varying(255) NOT NULL,
    token character varying(255) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO postgres;

--
-- Name: pd_keluar; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pd_keluar (
    pd_keluar_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.pd_keluar OWNER TO postgres;

--
-- Name: pd_pkl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pd_pkl (
    pd_pkl_id uuid NOT NULL,
    peserta_didik_id uuid NOT NULL,
    pkl_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    catatan text
);


ALTER TABLE public.pd_pkl OWNER TO postgres;

--
-- Name: pembelajaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pembelajaran (
    pembelajaran_id uuid NOT NULL,
    pembelajaran_id_dapodik uuid,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    guru_id uuid,
    guru_pengajar_id uuid,
    mata_pelajaran_id integer NOT NULL,
    nama_mata_pelajaran character varying(255) NOT NULL,
    kelompok_id integer,
    no_urut integer,
    kkm integer,
    is_dapodik integer,
    rasio_p integer,
    rasio_k integer,
    pembelajaran_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    induk_pembelajaran_id uuid,
    bobot_sumatif_materi smallint DEFAULT '1'::smallint,
    bobot_sumatif_akhir smallint DEFAULT '1'::smallint
);


ALTER TABLE public.pembelajaran OWNER TO postgres;

--
-- Name: permission_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permission_role (
    permission_id integer NOT NULL,
    role_id integer NOT NULL
);


ALTER TABLE public.permission_role OWNER TO postgres;

--
-- Name: permission_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permission_user (
    permission_id bigint NOT NULL,
    user_id uuid NOT NULL,
    user_type character varying(255) NOT NULL,
    team_id bigint
);


ALTER TABLE public.permission_user OWNER TO postgres;

--
-- Name: permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permissions (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    display_name character varying(255),
    description character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.permissions OWNER TO postgres;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permissions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO postgres;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: personal_access_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personal_access_tokens (
    id bigint NOT NULL,
    tokenable_type character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    token character varying(64) NOT NULL,
    abilities text,
    last_used_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    tokenable_id uuid,
    expires_at timestamp(0) without time zone
);


ALTER TABLE public.personal_access_tokens OWNER TO postgres;

--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personal_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.personal_access_tokens_id_seq OWNER TO postgres;

--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.personal_access_tokens_id_seq OWNED BY public.personal_access_tokens.id;


--
-- Name: peserta_didik; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.peserta_didik (
    peserta_didik_id uuid NOT NULL,
    peserta_didik_id_dapodik uuid,
    sekolah_id uuid NOT NULL,
    nama character varying(255) NOT NULL,
    no_induk character varying(255) NOT NULL,
    nisn character varying(255),
    nik character varying(16),
    jenis_kelamin character varying(255) NOT NULL,
    tempat_lahir character varying(255) NOT NULL,
    tanggal_lahir date NOT NULL,
    agama_id integer NOT NULL,
    status character varying(255) NOT NULL,
    anak_ke integer NOT NULL,
    alamat character varying(255),
    rt character varying(255),
    rw character varying(255),
    desa_kelurahan character varying(255),
    kecamatan character varying(255),
    kode_pos character varying(255),
    no_telp character varying(255),
    sekolah_asal character varying(255),
    diterima_kelas character varying(255),
    diterima date,
    kode_wilayah character varying(8) NOT NULL,
    email character varying(255),
    nama_ayah character varying(255),
    nama_ibu character varying(255),
    kerja_ayah integer,
    kerja_ibu integer,
    nama_wali character varying(255),
    alamat_wali character varying(255),
    telp_wali character varying(255),
    kerja_wali integer,
    photo character varying(255),
    active numeric(1,0) DEFAULT '1'::numeric,
    peserta_didik_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    no_hp character varying(20)
);


ALTER TABLE public.peserta_didik OWNER TO postgres;

--
-- Name: prakerin; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.prakerin (
    prakerin_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    mitra_prakerin character varying(255),
    lokasi_prakerin character varying(255),
    lama_prakerin character varying(255),
    keterangan_prakerin text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    bidang_usaha character varying(100),
    skala integer DEFAULT 0
);


ALTER TABLE public.prakerin OWNER TO postgres;

--
-- Name: praktik_kerja_lapangan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.praktik_kerja_lapangan (
    pkl_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    akt_pd_id uuid NOT NULL,
    tanggal_mulai date NOT NULL,
    tanggal_selesai date NOT NULL,
    semester_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL,
    instruktur character varying(255),
    nip character varying(100)
);


ALTER TABLE public.praktik_kerja_lapangan OWNER TO postgres;

--
-- Name: prestasi; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.prestasi (
    prestasi_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    anggota_rombel_id uuid NOT NULL,
    jenis_prestasi character varying(255),
    keterangan_prestasi text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.prestasi OWNER TO postgres;

--
-- Name: ptk_keluar; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ptk_keluar (
    ptk_keluar_id uuid NOT NULL,
    guru_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.ptk_keluar OWNER TO postgres;

--
-- Name: rapor_pts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rapor_pts (
    rapor_pts_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    rencana_penilaian_id uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.rapor_pts OWNER TO postgres;

--
-- Name: rencana_budaya_kerja; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rencana_budaya_kerja (
    rencana_budaya_kerja_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    rombongan_belajar_id uuid NOT NULL,
    nama character varying(255) NOT NULL,
    deskripsi text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    pembelajaran_id uuid,
    no_urut smallint DEFAULT '0'::smallint
);


ALTER TABLE public.rencana_budaya_kerja OWNER TO postgres;

--
-- Name: rencana_ukk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rencana_ukk (
    rencana_ukk_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    paket_ukk_id uuid NOT NULL,
    internal uuid NOT NULL,
    eksternal uuid NOT NULL,
    tanggal_sertifikat date NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.rencana_ukk OWNER TO postgres;

--
-- Name: role_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role_user (
    role_id bigint NOT NULL,
    user_id uuid NOT NULL,
    user_type character varying(255) NOT NULL,
    team_id bigint
);


ALTER TABLE public.role_user OWNER TO postgres;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.roles (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    display_name character varying(255),
    description character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.roles OWNER TO postgres;

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roles_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO postgres;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: rombel_4_tahun; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rombel_4_tahun (
    rombongan_belajar_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.rombel_4_tahun OWNER TO postgres;

--
-- Name: rombongan_belajar; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rombongan_belajar (
    rombongan_belajar_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    jurusan_id character varying(25),
    jurusan_sp_id uuid,
    kurikulum_id integer NOT NULL,
    nama character varying(255) NOT NULL,
    guru_id uuid NOT NULL,
    ptk_id uuid,
    tingkat integer NOT NULL,
    jenis_rombel numeric(2,0) NOT NULL,
    rombel_id_dapodik uuid NOT NULL,
    kunci_nilai integer DEFAULT 0 NOT NULL,
    rombongan_belajar_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.rombongan_belajar OWNER TO postgres;

--
-- Name: sekolah; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sekolah (
    sekolah_id uuid NOT NULL,
    npsn character varying(255) NOT NULL,
    nama character varying(255) NOT NULL,
    nss character varying(255),
    alamat character varying(255),
    desa_kelurahan character varying(255),
    kecamatan character varying(255),
    kode_wilayah character varying(255),
    kabupaten character varying(255),
    provinsi character varying(255),
    kode_pos character varying(255),
    lintang character varying(255),
    bujur character varying(255),
    no_telp character varying(255),
    no_fax character varying(255),
    email character varying(255),
    website character varying(255),
    guru_id uuid,
    status_sekolah integer NOT NULL,
    sinkron integer DEFAULT 0 NOT NULL,
    logo_sekolah character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    bentuk_pendidikan_id smallint
);


ALTER TABLE public.sekolah OWNER TO postgres;

--
-- Name: sessions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sessions (
    id character varying(255) NOT NULL,
    user_id uuid,
    ip_address character varying(45),
    user_agent text,
    payload text NOT NULL,
    last_activity integer NOT NULL
);


ALTER TABLE public.sessions OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    key character varying(255) NOT NULL,
    value text NOT NULL,
    sekolah_id uuid,
    semester_id character varying(5),
    id integer NOT NULL
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settings_id_seq OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.settings_id_seq OWNED BY public.settings.id;


--
-- Name: status_penilaian; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.status_penilaian (
    status_penilaian_id uuid NOT NULL,
    sekolah_id uuid NOT NULL,
    semester_id character varying(5) NOT NULL,
    status numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.status_penilaian OWNER TO postgres;

--
-- Name: sync_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sync_log (
    id uuid NOT NULL,
    user_id uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sync_log OWNER TO postgres;

--
-- Name: teams; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.teams (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    display_name character varying(255),
    description character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teams OWNER TO postgres;

--
-- Name: teams_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.teams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teams_id_seq OWNER TO postgres;

--
-- Name: teams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.teams_id_seq OWNED BY public.teams.id;


--
-- Name: teknik_penilaian; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.teknik_penilaian (
    teknik_penilaian_id uuid NOT NULL,
    sekolah_id uuid,
    kompetensi_id integer NOT NULL,
    nama character varying(255) NOT NULL,
    bobot integer,
    teknik_penilaian_id_migrasi uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE public.teknik_penilaian OWNER TO postgres;

--
-- Name: tp_mapel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tp_mapel (
    tp_mapel_id uuid NOT NULL,
    tp_id uuid NOT NULL,
    pembelajaran_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.tp_mapel OWNER TO postgres;

--
-- Name: tp_pkl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tp_pkl (
    tp_pkl_id uuid NOT NULL,
    tp_id uuid NOT NULL,
    pkl_id uuid NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone DEFAULT '1901-01-01 00:00:00'::timestamp without time zone NOT NULL
);


ALTER TABLE public.tp_pkl OWNER TO postgres;

--
-- Name: tujuan_pembelajaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tujuan_pembelajaran (
    tp_id uuid NOT NULL,
    cp_id bigint,
    deskripsi text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    kd_id uuid
);


ALTER TABLE public.tujuan_pembelajaran OWNER TO postgres;

--
-- Name: unit_ukk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.unit_ukk (
    unit_ukk_id uuid NOT NULL,
    sekolah_id uuid,
    paket_ukk_id uuid NOT NULL,
    kode_unit character varying(255) NOT NULL,
    nama_unit_id character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    nama_unit_en character varying(255)
);


ALTER TABLE public.unit_ukk OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    user_id uuid NOT NULL,
    sekolah_id uuid,
    name character varying(255) NOT NULL,
    nisn character varying(255),
    nuptk character varying(255),
    email character varying(255) NOT NULL,
    password character varying(255) NOT NULL,
    password_dapo character varying(255),
    remember_token character varying(100),
    last_login_at timestamp(0) without time zone,
    last_login_ip character varying(255),
    profile_photo_path character varying(255),
    active integer DEFAULT 1 NOT NULL,
    peserta_didik_id uuid,
    guru_id uuid,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    periode_aktif character varying(5),
    default_password character varying(255),
    two_factor_secret text,
    two_factor_recovery_codes text
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: view_nilai_keterampilan_perkd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_keterampilan_perkd AS
 SELECT get_nilai_keterampilan_siswa_by_kd.kompetensi_id,
    get_nilai_keterampilan_siswa_by_kd.anggota_rombel_id,
    get_nilai_keterampilan_siswa_by_kd.pembelajaran_id,
    get_nilai_keterampilan_siswa_by_kd.kompetensi_dasar_id,
    round((sum(get_nilai_keterampilan_siswa_by_kd.nilai_kd_keterampilan) / (sum(get_nilai_keterampilan_siswa_by_kd.bobot))::numeric), 0) AS nilai_kd
   FROM public.get_nilai_keterampilan_siswa_by_kd
  GROUP BY get_nilai_keterampilan_siswa_by_kd.kompetensi_id, get_nilai_keterampilan_siswa_by_kd.anggota_rombel_id, get_nilai_keterampilan_siswa_by_kd.pembelajaran_id, get_nilai_keterampilan_siswa_by_kd.kompetensi_dasar_id;


ALTER TABLE public.view_nilai_keterampilan_perkd OWNER TO postgres;

--
-- Name: view_nilai_akhir_keterampilan; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_akhir_keterampilan AS
 SELECT view_nilai_keterampilan_perkd.kompetensi_id,
    view_nilai_keterampilan_perkd.anggota_rombel_id,
    view_nilai_keterampilan_perkd.pembelajaran_id,
    round(avg(view_nilai_keterampilan_perkd.nilai_kd), 0) AS nilai_akhir
   FROM public.view_nilai_keterampilan_perkd
  GROUP BY view_nilai_keterampilan_perkd.kompetensi_id, view_nilai_keterampilan_perkd.anggota_rombel_id, view_nilai_keterampilan_perkd.pembelajaran_id;


ALTER TABLE public.view_nilai_akhir_keterampilan OWNER TO postgres;

--
-- Name: view_nilai_kurmer_pertp; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_kurmer_pertp AS
 SELECT get_nilai_kurmer_siswa_by_kd.pembelajaran_id,
    get_nilai_kurmer_siswa_by_kd.anggota_rombel_id,
    get_nilai_kurmer_siswa_by_kd.tp_id,
    sum(get_nilai_kurmer_siswa_by_kd.nilai) AS nilai_tp
   FROM public.get_nilai_kurmer_siswa_by_kd
  GROUP BY get_nilai_kurmer_siswa_by_kd.pembelajaran_id, get_nilai_kurmer_siswa_by_kd.anggota_rombel_id, get_nilai_kurmer_siswa_by_kd.tp_id;


ALTER TABLE public.view_nilai_kurmer_pertp OWNER TO postgres;

--
-- Name: view_nilai_akhir_kurmer; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_akhir_kurmer AS
 SELECT view_nilai_kurmer_pertp.pembelajaran_id,
    view_nilai_kurmer_pertp.anggota_rombel_id,
    round(avg(view_nilai_kurmer_pertp.nilai_tp), 0) AS nilai_akhir
   FROM public.view_nilai_kurmer_pertp
  GROUP BY view_nilai_kurmer_pertp.pembelajaran_id, view_nilai_kurmer_pertp.anggota_rombel_id;


ALTER TABLE public.view_nilai_akhir_kurmer OWNER TO postgres;

--
-- Name: view_nilai_pengetahuan_perkd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_pengetahuan_perkd AS
 SELECT get_nilai_pengetahuan_siswa_by_kd.pembelajaran_id,
    get_nilai_pengetahuan_siswa_by_kd.anggota_rombel_id,
    get_nilai_pengetahuan_siswa_by_kd.kompetensi_id,
    get_nilai_pengetahuan_siswa_by_kd.kompetensi_dasar_id,
    sum(get_nilai_pengetahuan_siswa_by_kd.bobot) AS bobot,
    sum(get_nilai_pengetahuan_siswa_by_kd.nilai) AS jml_nilai,
    round((sum(get_nilai_pengetahuan_siswa_by_kd.nilai_kd_pengetahuan) / (sum(get_nilai_pengetahuan_siswa_by_kd.bobot))::numeric), 0) AS nilai_kd
   FROM public.get_nilai_pengetahuan_siswa_by_kd
  GROUP BY get_nilai_pengetahuan_siswa_by_kd.pembelajaran_id, get_nilai_pengetahuan_siswa_by_kd.anggota_rombel_id, get_nilai_pengetahuan_siswa_by_kd.kompetensi_id, get_nilai_pengetahuan_siswa_by_kd.kompetensi_dasar_id;


ALTER TABLE public.view_nilai_pengetahuan_perkd OWNER TO postgres;

--
-- Name: view_nilai_akhir_pengetahuan; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_akhir_pengetahuan AS
 SELECT view_nilai_pengetahuan_perkd.pembelajaran_id,
    view_nilai_pengetahuan_perkd.anggota_rombel_id,
    view_nilai_pengetahuan_perkd.kompetensi_id,
    round(avg(view_nilai_pengetahuan_perkd.nilai_kd), 0) AS nilai_akhir
   FROM public.view_nilai_pengetahuan_perkd
  GROUP BY view_nilai_pengetahuan_perkd.pembelajaran_id, view_nilai_pengetahuan_perkd.anggota_rombel_id, view_nilai_pengetahuan_perkd.kompetensi_id;


ALTER TABLE public.view_nilai_akhir_pengetahuan OWNER TO postgres;

--
-- Name: view_nilai_pk_perkd; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_pk_perkd AS
 SELECT get_nilai_pk_siswa_by_kd.pembelajaran_id,
    get_nilai_pk_siswa_by_kd.anggota_rombel_id,
    get_nilai_pk_siswa_by_kd.kompetensi_id,
    get_nilai_pk_siswa_by_kd.kompetensi_dasar_id,
    sum(get_nilai_pk_siswa_by_kd.bobot) AS bobot,
    sum(get_nilai_pk_siswa_by_kd.nilai) AS jml_nilai,
    round((sum(get_nilai_pk_siswa_by_kd.nilai_kd_pk) / (sum(get_nilai_pk_siswa_by_kd.bobot))::numeric), 0) AS nilai_kd
   FROM public.get_nilai_pk_siswa_by_kd
  GROUP BY get_nilai_pk_siswa_by_kd.pembelajaran_id, get_nilai_pk_siswa_by_kd.anggota_rombel_id, get_nilai_pk_siswa_by_kd.kompetensi_id, get_nilai_pk_siswa_by_kd.kompetensi_dasar_id;


ALTER TABLE public.view_nilai_pk_perkd OWNER TO postgres;

--
-- Name: view_nilai_akhir_pk; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.view_nilai_akhir_pk AS
 SELECT view_nilai_pk_perkd.pembelajaran_id,
    view_nilai_pk_perkd.anggota_rombel_id,
    view_nilai_pk_perkd.kompetensi_id,
    round(avg(view_nilai_pk_perkd.nilai_kd), 0) AS nilai_akhir
   FROM public.view_nilai_pk_perkd
  GROUP BY view_nilai_pk_perkd.pembelajaran_id, view_nilai_pk_perkd.anggota_rombel_id, view_nilai_pk_perkd.kompetensi_id;


ALTER TABLE public.view_nilai_akhir_pk OWNER TO postgres;

--
-- Name: agama; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.agama (
    agama_id integer NOT NULL,
    nama character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.agama OWNER TO postgres;

--
-- Name: agama_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.agama_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.agama_id_seq OWNER TO postgres;

--
-- Name: agama_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.agama_id_seq OWNED BY ref.agama.agama_id;


--
-- Name: budaya_kerja; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.budaya_kerja (
    budaya_kerja_id smallint NOT NULL,
    aspek character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.budaya_kerja OWNER TO postgres;

--
-- Name: capaian_pembelajaran; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.capaian_pembelajaran (
    cp_id bigint NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    fase character varying(5) NOT NULL,
    elemen text NOT NULL,
    deskripsi text NOT NULL,
    aktif integer DEFAULT '1'::numeric NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    is_dir integer DEFAULT '0'::numeric
);


ALTER TABLE ref.capaian_pembelajaran OWNER TO postgres;

--
-- Name: elemen_budaya_kerja; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.elemen_budaya_kerja (
    elemen_id smallint NOT NULL,
    budaya_kerja_id smallint NOT NULL,
    elemen character varying(255) NOT NULL,
    deskripsi text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.elemen_budaya_kerja OWNER TO postgres;

--
-- Name: gelar_akademik; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.gelar_akademik (
    gelar_akademik_id bigint NOT NULL,
    kode character varying(10) NOT NULL,
    nama character varying(40) NOT NULL,
    posisi_gelar numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.gelar_akademik OWNER TO postgres;

--
-- Name: gelar_akademik_gelar_akademik_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.gelar_akademik_gelar_akademik_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.gelar_akademik_gelar_akademik_id_seq OWNER TO postgres;

--
-- Name: gelar_akademik_gelar_akademik_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.gelar_akademik_gelar_akademik_id_seq OWNED BY ref.gelar_akademik.gelar_akademik_id;


--
-- Name: jabatan_ptk; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.jabatan_ptk (
    jabatan_ptk_id numeric(5,0) NOT NULL,
    nama character varying(50) NOT NULL,
    jabatan_utama numeric(1,0) NOT NULL,
    tugas_tambahan_guru numeric(1,0) NOT NULL,
    jumlah_jam_diakui numeric(2,0),
    harus_refer_unit_org numeric(1,0) DEFAULT '0'::numeric NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.jabatan_ptk OWNER TO postgres;

--
-- Name: jenis_ptk; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.jenis_ptk (
    jenis_ptk_id numeric(2,0) NOT NULL,
    jenis_ptk character varying(30) NOT NULL,
    guru_kelas numeric(1,0) NOT NULL,
    guru_matpel numeric(1,0) NOT NULL,
    guru_bk numeric(1,0) NOT NULL,
    guru_inklusi numeric(1,0) NOT NULL,
    pengawas_satdik numeric(1,0) NOT NULL,
    pengawas_plb numeric(1,0) NOT NULL,
    pengawas_matpel numeric(1,0) NOT NULL,
    pengawas_bidang numeric(1,0) NOT NULL,
    tas numeric(1,0) NOT NULL,
    formal numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.jenis_ptk OWNER TO postgres;

--
-- Name: jurusan; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.jurusan (
    jurusan_id character varying(25) NOT NULL,
    nama_jurusan character varying(100) NOT NULL,
    nama_jurusan_en character varying(100),
    untuk_sma numeric(1,0) NOT NULL,
    untuk_smk numeric(1,0) NOT NULL,
    untuk_pt numeric(1,0) NOT NULL,
    untuk_slb numeric(1,0) NOT NULL,
    untuk_smklb numeric(1,0) NOT NULL,
    jenjang_pendidikan_id numeric(2,0),
    jurusan_induk character varying(25),
    level_bidang_id character varying(5) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.jurusan OWNER TO postgres;

--
-- Name: kelompok; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.kelompok (
    kelompok_id integer NOT NULL,
    nama_kelompok character varying(255) NOT NULL,
    kurikulum integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL,
    kkm smallint
);


ALTER TABLE ref.kelompok OWNER TO postgres;

--
-- Name: kelompok_kelompok_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.kelompok_kelompok_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.kelompok_kelompok_id_seq OWNER TO postgres;

--
-- Name: kelompok_kelompok_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.kelompok_kelompok_id_seq OWNED BY ref.kelompok.kelompok_id;


--
-- Name: kompetensi_dasar; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.kompetensi_dasar (
    kompetensi_dasar_id uuid NOT NULL,
    id_kompetensi text NOT NULL,
    kompetensi_id integer NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    kelas_10 integer,
    kelas_11 integer,
    kelas_12 integer,
    kelas_13 integer,
    id_kompetensi_nas character varying(11),
    kompetensi_dasar text NOT NULL,
    kompetensi_dasar_alias text,
    user_id uuid,
    aktif integer DEFAULT 1 NOT NULL,
    kurikulum integer DEFAULT 0,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.kompetensi_dasar OWNER TO postgres;

--
-- Name: kurikulum; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.kurikulum (
    kurikulum_id smallint NOT NULL,
    nama_kurikulum character varying(120) NOT NULL,
    mulai_berlaku date NOT NULL,
    sistem_sks numeric(1,0) NOT NULL,
    total_sks numeric(3,0) NOT NULL,
    jenjang_pendidikan_id numeric(2,0) NOT NULL,
    jurusan_id character varying(25),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.kurikulum OWNER TO postgres;

--
-- Name: level_wilayah; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.level_wilayah (
    id_level_wilayah smallint NOT NULL,
    level_wilayah character varying(15) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.level_wilayah OWNER TO postgres;

--
-- Name: mata_pelajaran; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.mata_pelajaran (
    mata_pelajaran_id integer NOT NULL,
    nama character varying(255) NOT NULL,
    pilihan_sekolah numeric(1,0) NOT NULL,
    pilihan_buku numeric(1,0) NOT NULL,
    pilihan_kepengawasan numeric(1,0) NOT NULL,
    pilihan_evaluasi numeric(1,0) NOT NULL,
    jurusan_id character varying(25),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.mata_pelajaran OWNER TO postgres;

--
-- Name: mata_pelajaran_kurikulum; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.mata_pelajaran_kurikulum (
    kurikulum_id smallint NOT NULL,
    mata_pelajaran_id integer NOT NULL,
    tingkat_pendidikan_id numeric(2,0) NOT NULL,
    jumlah_jam numeric(2,0) NOT NULL,
    jumlah_jam_maksimum numeric(2,0) NOT NULL,
    wajib numeric(1,0) NOT NULL,
    sks numeric(2,0) NOT NULL,
    a_peminatan numeric(1,0) NOT NULL,
    area_kompetensi character varying(1) NOT NULL,
    gmp_id character varying(36),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.mata_pelajaran_kurikulum OWNER TO postgres;

--
-- Name: mst_wilayah; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.mst_wilayah (
    kode_wilayah character varying(8) NOT NULL,
    nama character varying(60) NOT NULL,
    id_level_wilayah smallint NOT NULL,
    mst_kode_wilayah character varying(8),
    negara_id character varying(2) NOT NULL,
    asal_wilayah character varying(8),
    kode_bps character varying(7),
    kode_dagri character varying(10),
    kode_keu character varying(10),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.mst_wilayah OWNER TO postgres;

--
-- Name: negara; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.negara (
    negara_id character varying(2) NOT NULL,
    nama character varying(45) NOT NULL,
    luar_negeri numeric(1,0) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.negara OWNER TO postgres;

--
-- Name: opsi_budaya_kerja; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.opsi_budaya_kerja (
    opsi_id smallint NOT NULL,
    kode character varying(10) NOT NULL,
    nama character varying(100) NOT NULL,
    deskripsi character varying(255) NOT NULL,
    warna character varying(10) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.opsi_budaya_kerja OWNER TO postgres;

--
-- Name: paket_ukk; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.paket_ukk (
    paket_ukk_id uuid NOT NULL,
    sekolah_id uuid,
    jurusan_id character varying(25) NOT NULL,
    kurikulum_id integer NOT NULL,
    kode_kompetensi integer,
    nomor_paket character varying(255),
    nama_paket_id character varying(255),
    nama_paket_en character varying(255),
    status integer DEFAULT 1 NOT NULL,
    jenis_data integer DEFAULT 1 NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.paket_ukk OWNER TO postgres;

--
-- Name: pekerjaan; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.pekerjaan (
    pekerjaan_id integer NOT NULL,
    nama character varying(25) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.pekerjaan OWNER TO postgres;

--
-- Name: pekerjaan_pekerjaan_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.pekerjaan_pekerjaan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.pekerjaan_pekerjaan_id_seq OWNER TO postgres;

--
-- Name: pekerjaan_pekerjaan_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.pekerjaan_pekerjaan_id_seq OWNED BY ref.pekerjaan.pekerjaan_id;


--
-- Name: semester; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.semester (
    semester_id character varying(5) NOT NULL,
    tahun_ajaran_id numeric(4,0) NOT NULL,
    nama character varying(255) NOT NULL,
    semester numeric(1,0) NOT NULL,
    periode_aktif numeric(1,0) NOT NULL,
    tanggal_mulai date NOT NULL,
    tanggal_selesai date NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.semester OWNER TO postgres;

--
-- Name: sikap; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.sikap (
    sikap_id integer NOT NULL,
    butir_sikap character varying(255) NOT NULL,
    sikap_induk integer,
    sikap_id_migrasi integer,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.sikap OWNER TO postgres;

--
-- Name: sikap_sikap_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.sikap_sikap_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.sikap_sikap_id_seq OWNER TO postgres;

--
-- Name: sikap_sikap_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.sikap_sikap_id_seq OWNED BY ref.sikap.sikap_id;


--
-- Name: status_kepegawaian; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.status_kepegawaian (
    status_kepegawaian_id smallint NOT NULL,
    nama character varying(30) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.status_kepegawaian OWNER TO postgres;

--
-- Name: tahun_ajaran; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.tahun_ajaran (
    tahun_ajaran_id numeric(4,0) NOT NULL,
    nama character varying(10) NOT NULL,
    periode_aktif numeric(1,0) NOT NULL,
    tanggal_mulai date NOT NULL,
    tanggal_selesai date NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    last_sync timestamp(0) without time zone NOT NULL
);


ALTER TABLE ref.tahun_ajaran OWNER TO postgres;

--
-- Name: migrations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations ALTER COLUMN id SET DEFAULT nextval('public.migrations_id_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: personal_access_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.personal_access_tokens_id_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings ALTER COLUMN id SET DEFAULT nextval('public.settings_id_seq'::regclass);


--
-- Name: teams id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.teams ALTER COLUMN id SET DEFAULT nextval('public.teams_id_seq'::regclass);


--
-- Name: agama agama_id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.agama ALTER COLUMN agama_id SET DEFAULT nextval('ref.agama_id_seq'::regclass);


--
-- Name: gelar_akademik gelar_akademik_id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.gelar_akademik ALTER COLUMN gelar_akademik_id SET DEFAULT nextval('ref.gelar_akademik_gelar_akademik_id_seq'::regclass);


--
-- Name: kelompok kelompok_id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.kelompok ALTER COLUMN kelompok_id SET DEFAULT nextval('ref.kelompok_kelompok_id_seq'::regclass);


--
-- Name: pekerjaan pekerjaan_id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.pekerjaan ALTER COLUMN pekerjaan_id SET DEFAULT nextval('ref.pekerjaan_pekerjaan_id_seq'::regclass);


--
-- Name: sikap sikap_id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.sikap ALTER COLUMN sikap_id SET DEFAULT nextval('ref.sikap_sikap_id_seq'::regclass);


--
-- Data for Name: matev_rapor; Type: TABLE DATA; Schema: dapodik; Owner: postgres
--

COPY dapodik.matev_rapor (id_evaluasi, nm_mata_evaluasi, a_dari_template, no_urut, kkm_kognitif, kkm_psikomotorik, rombongan_belajar_id, mata_pelajaran_id, pembelajaran_id, create_date, last_update, soft_delete, last_sync, updater_id, status) FROM stdin;
\.


--
-- Data for Name: absensi; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.absensi (absensi_id, sekolah_id, anggota_rombel_id, sakit, izin, alpa, created_at, updated_at, deleted_at, last_sync) FROM stdin;
36866461-74d5-483d-b4a9-217c85cc1a9d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9298e2d6-6a30-4fc9-b645-c502c57c9e72	\N	\N	18	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
79586bb9-5b7e-4ec0-a4d8-8902f87b0638	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1aa6d3ea-f63c-4cf4-a177-47ad9092524d	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
9281af8e-45b0-44af-b4fb-4a48d8557f19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	852cd2ec-5ca1-4e20-84df-251f337ed79e	\N	\N	\N	2019-12-11 22:04:16	2019-12-11 22:04:16	\N	2019-12-11 22:04:16
900512e7-8d9c-4383-85e9-2f3b146b55a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6dbdd7c1-888e-4da9-87e3-62c6982aa30c	\N	\N	2	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
3eb52769-e66d-49b1-91b1-3ba27efe4337	39f5eb74-4722-4aaf-a6af-2c6e972e5885	74c7c8d9-a0e1-4590-a2d5-e7b4176964e9	\N	\N	\N	2019-12-16 23:03:19	2019-12-16 23:03:19	\N	2019-12-16 23:03:19
c06a0fa8-2f15-4a97-8f73-495ba01cdd32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f5cd5f5e-fec9-4fc4-9a01-211aafa2ddc5	\N	\N	\N	2019-12-11 22:04:16	2019-12-16 23:03:19	\N	2019-12-16 23:03:19
1a2c34ee-a18e-456b-b741-f0a533d683ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6dd87627-e8f5-4700-859a-ede51c04edbe	\N	\N	\N	2019-12-11 22:04:16	2019-12-16 23:03:19	\N	2019-12-16 23:03:19
25d7270b-995a-4e25-a9ce-2e43dbe40cee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	07ae4ed8-b62b-4238-9c0a-a6cdaae961b9	\N	\N	\N	2019-12-11 22:04:16	2019-12-16 23:03:19	\N	2019-12-16 23:03:19
edcf0732-55ae-4363-8b73-bdf6bb46c5ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6cc22625-f12c-4f39-82a5-cbf11bdf4999	\N	\N	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
a67b24c2-1104-45eb-91ff-6e92936451aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1b49f20a-b7e5-47e5-ac3b-591ebc423743	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
71591161-72bb-432e-ad2b-e158e6fdb61f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	de7c7a43-a68d-41f7-9f53-47dabc6607c8	\N	1	20	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
6f1d5503-85bf-46af-bf23-745c8a0da2bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	550b881e-d654-4689-96f1-f1eff6b94723	\N	16	4	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
3f56d9c9-6340-4e95-ba73-6ce23b8895ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f451195f-d245-4ee9-8a74-2aa2e8e89685	\N	\N	2	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
f003add3-be91-448b-b82d-c6a7947caf17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	079496be-d351-4994-b6f7-46576d100d96	\N	2	3	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
0d387197-0926-4cd5-8e23-8e36123abeee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26b38017-c0db-4009-b7de-645759f1c10c	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
2ffc38c7-a6d3-4249-8fe0-a2ce4da62219	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a84bad28-891f-4517-bb3f-a6cf56d2c60c	\N	\N	2	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
cd8a9b4f-563d-450a-b988-5e5fd96575ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	efdf7266-b83d-4e0a-9d08-219bda648986	\N	3	2	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
14ce16df-1c77-4cbb-b10f-fa1d46a1511d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3130d754-b397-4b9c-b7e2-132b2898442b	2	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
11933c4a-16ab-40c4-9521-3719881f9df9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	11958a32-1073-426b-98d9-ac2a42bfb28f	2	1	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
d756e083-cbff-489e-a614-07065d766d16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	447b651c-84ba-4d20-b77b-2d2a76aef9d3	\N	\N	12	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
ebaa2082-e3ee-4db5-baa3-5d8e99f4ba35	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e72f9ae4-5a75-4cf0-a93e-b21e75d9b885	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
215348f6-c561-4b24-a904-9260eeee42c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b2685592-a50c-4d9a-b181-f7801d0b13c4	1	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
4db09455-8e94-43e3-a174-ad6e945c84d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c1a99b89-6227-403e-b8bf-bddde71cf971	\N	2	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
ec99ffb8-fa30-4aa8-91a4-255d6cdbc3a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05d33a41-9a41-45dc-b777-893fe4f87b45	1	1	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
945127e3-a590-4cb6-8313-d4bb10679cf5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3eb7b50d-e1bb-4ef4-b6b8-c9370f955db0	52	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
d93d31e1-a7a3-4138-b0f3-5c1715aacb16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2814ed5a-b75e-4f49-ba3d-d0a1d30200b6	\N	1	2	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
c91642d4-8887-44b4-b763-c4b9e648214b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d356d865-6ed1-4e84-8c33-cff0756ca3a9	\N	\N	19	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
b12edbbc-16c3-4ea1-ac74-8aa6fd6da8ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7e65dd5e-4d52-4f37-a169-6379b9277064	\N	1	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
f6ef91f7-babd-4508-a764-5c44c9cde0ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b83728a-b5dd-43da-814b-8417ebf44928	\N	3	13	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
a93f199a-ca7a-4185-a494-cc705768d10c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4547523e-7c51-422f-9cc1-c0fcf70726f2	\N	1	2	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
4aaf86cb-3323-41ce-837c-7ce496b0d008	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9906248f-bdfe-474a-afa4-ba477d9caf55	1	0	5	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
0832f217-cf8e-4b59-a808-19b6992d9970	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7e3e56b5-e30f-446b-aaf9-f6dfdbf74118	\N	\N	22	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
0096d703-5b43-4bc9-8b1d-216c7e31e66f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e580840e-d130-4735-bf89-221cc3c37b08	\N	\N	2	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
9ac89561-59c2-4440-9dbb-53b363653832	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d49ae207-f0b1-4982-abe4-0cf3fe192867	\N	1	6	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
0c2f5a2d-105e-41d7-89ec-617452c706e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5118452e-cff4-4edf-a511-60137e091d22	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
c086ca62-e62d-4b41-b343-246a0f022f5f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9616a30d-ae34-4902-9a7a-b022eb5a9926	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
2b67e4a1-26bd-471b-9064-32759fb3071d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a2dde135-8ac4-4502-af13-4e52099547d6	\N	\N	\N	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
d59d2902-3ce9-4e7b-a277-18b7c89772e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bfb49e3e-a048-4947-b593-56e2f08d7747	2	2	2	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
40043026-4b67-4898-bb11-c31d3e2725c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e7f377f3-660c-474a-aeb4-e6063630f0fa	\N	\N	18	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
724850eb-7416-409c-b33b-d1ac8785c049	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1a6fbc43-43eb-424d-874d-51bce4a52df9	2	2	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
f374c452-c2ba-4979-b24e-2f5d9f153f58	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce40c0ca-30d5-4648-876f-1f1fa560e7a2	\N	\N	3	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
b655d3eb-d6d3-411a-a400-f5dd88335b01	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e046c0d-357e-4536-ada5-9ee0c9f09f4d	\N	\N	3	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
046124a5-2af6-4387-ae69-edddfc6d45f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c9184d83-e822-415c-9f65-bdca354f6619	2	\N	10	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
d5a6c742-bbc6-4b4c-a4cc-b8fd45188b42	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37bcb729-2e24-4d1f-bdfe-142ade2fa5d0	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
f7f013f7-dc50-4375-909e-ead9a2f572c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5a6402be-0fd3-422a-ae38-a2c928c2f36c	\N	\N	14	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
46c6a4a7-a5f2-4a41-ac80-8077b52be138	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4a1e647c-e024-40bb-8d30-1c110832cac8	\N	2	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
1e9c6d4f-c535-4210-a609-5b5982b100db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	998b17bf-39c7-4744-a211-9d4178a79cf0	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
38f5d0de-e9ac-493e-a1ca-bf55fa8856e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd2dc834-752e-4291-9ad9-9caa0f524ee3	\N	\N	\N	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
a969586c-686e-4508-a9e3-75e4142d8e65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	046a16e4-c461-49a3-964d-3a69034e4b30	0	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
a2d1e2a7-8100-49af-9dd4-d9e8c7b7e69f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d8e30acc-b389-4139-85f0-28d60da560fd	1	\N	4	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
7a7fd6a1-51e0-49b8-9138-1f55de0a70d2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e601f33-3603-4c28-bf77-7730ee207547	\N	20	6	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
c9114b9c-0944-4858-8a50-d42c48fa9046	39f5eb74-4722-4aaf-a6af-2c6e972e5885	67cbeff6-04ad-49a3-8446-abc22efb88d1	1	\N	4	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
dee5f8ac-4803-4c1b-8293-7f544d207b7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	84c025ab-d0d0-442b-97cc-eb477fb22c7f	\N	\N	2	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
2e478ae0-8ac8-4f44-a892-2d4f22f7fb5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a2a50d96-1294-470b-9eef-b9d0b1c9cb7e	2	\N	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
917ebff0-64b6-4169-81f8-6867302c14ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b6e1fada-7ff0-45bf-8cc0-cb996f530c45	\N	1	3	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
63e5f699-0241-4be3-958d-ed054898a476	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6070389c-2126-4ec7-af52-f76cb818644f	\N	\N	13	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
dc669e2f-340f-4f96-997c-10a9b7bd6aca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c74b533d-f0e6-499a-aa54-051e436ff4ed	2	2	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
9b5af57d-16aa-4b74-a0d7-84b1415c737e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2b3cf88c-2889-4a72-bdda-9e484b866535	\N	\N	1	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
bf3468bf-5bb5-4f3d-9960-2ea87dd89ec5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	450956c4-e487-4229-a1d2-140bf0f2fc72	\N	\N	30	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
c29c4b18-238f-470b-8eb6-cd1cd3c87190	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a6e5f763-587c-49bd-9ecb-a688f2fa4ebd	\N	23	4	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
0276cb37-5842-4603-9116-b19cd565c996	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a048ad63-8e70-4412-a822-aa7e2e644393	\N	\N	4	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
c156e27e-0b12-4858-adc4-ee4f0c6722d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1e7c7ed3-a9cf-4a97-b4ab-019e3b8d8dae	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
81897991-311d-4598-83ab-dab7a31c6814	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ab9baf3-097b-48c5-95af-f238ce3e88b6	\N	1	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
e31ab42f-e654-4744-a350-f06d721ea190	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3f9e45bd-7268-40a1-b992-379aa9dd1e87	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
e974704c-0feb-4831-94c0-3b4de4e4ea8a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	937dfb46-b74e-4a0b-8fbd-a1e6c3efc788	\N	1	30	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
5f44cfc2-3a8d-473b-99e2-8b79c26f30a5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1dcc73d8-45a8-4cef-bfb4-45f513d9bebe	\N	\N	17	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
2195e4a7-3276-460d-8a2d-84dbc7f03da3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	69adf20d-af1d-4349-af5b-c91841970999	1	1	\N	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
09f23c5f-9f4c-42ad-8f64-b4b67f07b2f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	845772ad-8c90-462b-be4d-8534b0814468	\N	\N	8	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
7de2fad9-95b5-4622-b800-79fe0f865d0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f0950a9-1df9-469c-8314-e48e19bbf03d	0	0	3	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
6a3a66da-f82c-4bf8-9670-622ee482c318	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f06f7b6-570b-41c7-ba40-6f37a229079f	1	0	4	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
e834cdce-8144-4516-b0e8-8bbc04dcf1be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	64bdf2ba-cf04-4d7c-a3c8-1e1592738b82	0	0	16	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
0c7226b1-26df-4bdd-a4c7-1def5d86f526	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14c5c8b6-0897-4e66-92f2-8bc0042e566f	\N	\N	\N	2019-12-10 16:48:34	2019-12-19 12:14:56	\N	2019-12-19 12:14:56
3bb1bf50-b72a-4e78-a708-ae94c1d5cb1f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f15caf59-b821-4860-9242-9d49d9a97c52	\N	\N	27	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
7f166771-b47c-4dee-b886-89fe57117fb0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e0236c59-486b-448f-88fd-24bde16eaa80	\N	\N	32	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
c57a2667-b7f2-4c5a-8975-ed602c0e00c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	424384b7-e626-42c6-a495-bf1d5c9e0a09	\N	\N	\N	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
ce4e94c5-1820-4b6d-86b8-f2420c4783e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6dc1a98b-9f19-4a63-8167-de593cc25acb	3	3	0	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
6f37b997-6002-43f4-b1d6-d7b18d162f58	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0fe246e8-04b1-40fc-a6ce-aa23445ab6c4	\N	\N	\N	2019-12-19 08:19:22	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
73adf738-1108-4701-977b-c29628311e97	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ee04d52c-cf12-49d1-a85d-6020a059987d	0	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
23ff9f90-3def-48e8-ac61-49e3580c9892	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d671772c-b3b1-4f33-827b-5baee4353b37	1	1	10	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
f528e11f-8828-4694-9525-c46db198cba0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b1959232-ad54-45ac-9c6e-5ac26ecb54cf	0	0	16	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
a83fc60f-0295-4fd3-a85c-3bc679a3b67c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85d1cf70-b04a-4080-85d8-c18fa8caacd8	\N	\N	\N	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
b34fc9b0-d25f-44eb-9ad4-ca0283550133	39f5eb74-4722-4aaf-a6af-2c6e972e5885	243e8963-8e55-4b7e-9c03-cc874a10980c	0	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
36dd81f7-eb56-4e6a-90f0-aa84db2a318d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	\N	\N	2019-12-19 08:19:22	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
68b43616-74fb-4482-91d4-694540be09bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe67884f-c50c-446b-be14-f00813155576	\N	\N	1	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
bb5cd518-8fab-4ea5-88b6-a723912e5d7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a2ea727e-cc99-49f3-90f8-39ce7519ad91	0	2	6	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
9e2b8ce3-a50c-4a25-8ad9-6dbdb7821211	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f34be181-5bf8-4016-b736-b1cd3d7f3f04	\N	1	30	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
ddcdf9b6-3f96-4a80-8574-afd7a6403593	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dbe06bb5-f24f-4fef-b7c8-d20d8c2adfe5	0	0	3	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
d4ad6a88-16b1-4d52-9d79-0b716694ccae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	72c38ff7-dc28-4065-bb8e-ec8f47a271fc	\N	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
64f73a59-5f6a-4289-95a4-be6051f5dfb9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fb93bc97-91e9-4cc9-bfee-252e0e4ca94e	0	0	2	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
2a735266-9c7e-49c4-8ef3-42c987901be0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e5f48d0-408d-4a35-8bd0-ab66cd071668	0	0	32	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
6da1532a-dbc8-45df-b476-2e40d8936595	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4fa2bd71-5f78-4c68-8679-ae8bb711c2f0	1	1	1	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
f808f51d-d7aa-4ec9-aa4f-57d358b9ef55	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5f58c9b7-80c5-453a-bf98-aea9dad5d2de	0	0	33	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
7384acd3-d323-43a5-adbb-e32204f10ebd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4daafaba-7af0-4ebf-8bbc-17edd827fd26	\N	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
12c89ba2-d59a-4e13-8f4d-2249dd99a1ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a78fefce-0563-47e7-ae90-e5dd82528c4b	5	\N	15	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
eea18ffa-216e-455d-8281-bc4cddb5aa95	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f9e073d5-9aa3-455d-9492-6272d7d8b0f1	\N	1	2	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
8a154870-a7fb-44e6-ac39-99ec6517cfb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	030ca252-5156-409f-957d-69a3e0040708	\N	\N	1	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
d0d78414-32ac-4096-8553-dc3fce5e69f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9ae7fea5-3657-4e8c-bf8b-b686c321e855	0	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
3c33c5ea-371b-485b-9fb7-78ea6811bb87	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7632d02a-a796-45cb-b1a3-6d8870a015b1	\N	1	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
6d5b8ca1-140a-4221-be3a-0ebeedc9c33f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ae6a8696-22fb-4219-aac1-183deffcb4c9	0	0	4	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
2cd0de54-05d2-41fa-a12b-7e6dd02a7486	39f5eb74-4722-4aaf-a6af-2c6e972e5885	89a7482e-1eab-463c-8b14-10c0e9b127c7	6	0	6	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
e5e3d934-d5dc-4a60-be4a-4bf773df1536	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7f8e20d4-3d56-4b95-a364-cf7de3c45cb9	1	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
377851b5-6976-47d0-a87c-350ce4c036c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b0116c38-9e9f-47bb-a887-5477e5e53d98	0	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
25e25065-f269-477e-bfe8-f80a0dd06140	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6c7a57ab-ad7a-473b-99e5-67145320a4f4	0	0	16	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
c2125aba-1596-413f-bcb1-845c953a6a2b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0abf8bd9-51f3-4d0d-8048-e9af113c17f4	0	0	4	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
1c769eb4-b9fc-48cc-87f9-ed6e5aa48b93	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fc56fd81-b6da-414c-ad8f-0e2d600c2111	\N	\N	4	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
a5632653-23d2-444f-88db-d9fab70e9c4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aa9d3f7f-140e-4ca4-b5cf-47378a8106c9	2	0	5	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
a77cd5b6-c7d1-4847-9cba-2d0a5ff84bd4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48f4484b-1120-4cb4-baf2-dde0a4a53a93	1	\N	1	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
2ee2dc30-1229-4599-a023-767585ee61f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3b3b014e-f880-4bbb-9309-b771f70d21ee	\N	\N	3	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
4581304c-807f-464a-b579-84188646527b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	de207fb2-2fb6-4e49-85b2-cc7f7b124a6a	0	0	5	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
df7328c8-46eb-4b20-9f89-c9bdcb07851e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9150933-404e-40a5-997d-6027e0254744	0	0	3	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
0dd8109b-b298-4b0f-bc40-6e02de6699a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ea80938e-b892-4cad-8845-7ea4ff6355b4	0	0	10	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
eb213684-4151-407f-89e8-3db3f1d8dca5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d28fc4b3-bce6-44d5-8583-3a6436a1b8b3	\N	\N	\N	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
6e1bd58a-7673-498e-8449-5680cb735dac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	776f0750-86a6-49a4-b0cf-63694ec6bb23	0	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
7023804f-f254-41e8-a2e9-9e16b0494478	39f5eb74-4722-4aaf-a6af-2c6e972e5885	41a068ab-9860-4986-9dd9-3e6fcacc1683	3	\N	9	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
675844a9-1ef6-48bb-9c5d-c3f650f52564	39f5eb74-4722-4aaf-a6af-2c6e972e5885	906c4609-1edc-4fe0-b885-f4348299890d	-1	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
1d148187-7d76-4f82-af03-7ad102199b2a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e06b6f07-a131-4f03-ad16-68e3bed3670d	1	\N	8	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
4fbc317d-b266-47e8-8308-e34dea46ee0f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	91b0f9f3-1124-4395-b7f6-5110f2637fe2	\N	\N	2	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
972a4fb3-fac1-4782-8681-c4a0d87d74e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	99b24366-f09f-4dd2-bed3-283ebe514772	1	\N	13	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
b4e07cb2-f93c-4618-9d46-cea716120b9c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4ae4ca9c-01f7-4cd6-bc5f-51f71fe7ddfd	0	1	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
37b07897-5532-4cf6-b382-910e1cf1437b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1886d81b-ba50-4ce9-9694-12fc5c63170b	\N	\N	\N	2019-12-19 08:19:22	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
49fb131b-1426-4b10-9240-59f238dafccc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9f01c0d4-2898-48d2-b0f6-328b440d00b4	\N	2	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
3fc7351d-1020-46d1-b0c4-693faa07c933	39f5eb74-4722-4aaf-a6af-2c6e972e5885	40b5a628-cdd2-451c-89b3-54b654a2a3f1	1	1	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
ae608e92-66e7-46b6-ad89-f9d9278b259a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8c52b2d3-1ea4-4a2f-86e4-3e08d088f9f4	1	\N	10	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
fd3cb343-de5c-46f9-b174-2909c0786ba8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e5593289-ad2d-4638-bf92-f88f46795e30	0	0	10	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
ca7e8e9c-ef2d-4e64-a49c-755e807e2de3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	16a496e0-ee6e-49aa-a311-d0531c2fdfdd	3	\N	3	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
8b647666-b17d-4408-bae5-d65acae62132	39f5eb74-4722-4aaf-a6af-2c6e972e5885	585140fe-d243-4bec-989a-6f41963f269e	1	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
3fd81b00-9ebe-409b-903d-011ad50fb81a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f923d050-f862-4957-9b0b-09a074f4c7b3	1	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
1ad2380d-367b-4a7b-9119-b7405ffa5e33	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cdb20348-0d11-49ab-b670-06246117cab5	1	0	1	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
df398ead-ec04-4c5d-8908-83a7c707ffc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d2fe074f-cff6-4a2c-a567-b4a2ef6a724e	6	\N	8	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
ef378f7b-a14e-4d68-adce-e9af3a2af40e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b7455933-2830-475a-956d-04bd2ba1b301	1	\N	\N	2019-12-18 10:35:32	2019-12-18 10:35:32	\N	2019-12-18 10:35:32
d7c991bd-ec19-4be4-a40f-846165775b89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	265d7c35-d15f-4a83-908b-8c1161b6289f	0	0	10	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
8a436bec-002e-4fcc-bb28-7b79fe2b3b3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37574861-bbb9-409c-bdfd-38c4f3048653	\N	\N	\N	2019-12-19 08:19:22	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
b9b966e8-ae8b-4475-9618-fa33d7887466	39f5eb74-4722-4aaf-a6af-2c6e972e5885	32dd39dc-4beb-4b6f-ad88-3dc5b7252dab	0	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
cff7f5e0-97d3-479d-9df3-933619ed9d5c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4624b566-6341-4e71-bcc8-8d1d18a27580	0	0	0	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
8484396c-dc4e-4785-b087-f14ae60b578d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3afcd78e-edd5-4723-9a97-43075e563663	2	0	6	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
faf46d28-af71-430f-b7eb-ddae9c0574d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b26a48ac-a485-43a2-bd1b-839fd1216ab0	0	2	2	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
b2fa9722-e369-4d27-b434-843d670459a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1e01fbc4-66c0-436e-a83d-d66361021bc2	0	4	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
19cb23ed-656f-4369-aa18-a5647ee40f9a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37a6204a-4e02-488c-9d88-b1f48e020e32	0	2	2	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
418e83c1-9492-4c1c-9a59-a139da0d96c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1e671faa-0bc9-47fc-9be4-158e58287e92	0	1	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
e0211899-d23d-452a-835f-bcbbcb824409	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d2b2bcd6-c4da-4584-b914-d0cc6eab942a	0	1	1	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
afaff45b-e9c7-4cb7-a6f6-1ca32a6804bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c2dba60c-dcdb-4d52-bdfc-510134d07a1e	\N	19	1	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
25f549ea-c883-4b23-a6bc-e263a2daae48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4a919f90-f674-422f-bff8-bb584fccb69a	1	1	6	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
f09c8f1a-569d-459b-b00e-a48d337a6331	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7df41429-d5ab-4526-be57-bea6f40e408a	\N	\N	\N	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
5b6b50c1-ca40-4c54-b477-0cd02c1055bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77c10b58-7832-46a1-874d-b69e473a8c59	1	5	20	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
2290de02-26d8-4997-9d34-aa7b50a09781	39f5eb74-4722-4aaf-a6af-2c6e972e5885	945bb4d6-64d7-4d09-8e71-054f138a6c3a	0	1	19	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
06ce3b9e-d523-4d85-affb-6eee5a3b35ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	100fea3b-0973-446b-95c6-c53ef7e05254	\N	\N	40	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
ff9af3cf-0eab-4205-8c86-05167307cc50	39f5eb74-4722-4aaf-a6af-2c6e972e5885	15f71897-3df3-495b-bb1a-6cda95677f05	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
50971338-ada5-4bf1-a34d-36e852e8662d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fb1e2f6b-3834-41f5-a0aa-cf3df2c3b046	0	2	2	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
ff16ee84-be7a-44da-8a17-11eaa2b0c9d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e1474f9a-b4c2-4c6d-90cd-3d597759e86c	0	0	8	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
83203a25-3985-43f0-b580-0b863f9b1d5f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c236dc45-69d7-49a9-9ab5-53e8cb5a5788	\N	\N	10	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
906d0476-2c47-4513-a5ee-5a27e7b39c3b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0f9dce63-c5c7-4e1a-a9a4-4eaf15dbe449	\N	\N	33	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
9f158e75-72f5-4045-b334-106b7aae4709	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1574f4ca-228b-46e8-9db7-25b070ba2a9b	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
a8502052-1c14-415a-93bd-c377eb99d3e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3a5857d2-20ed-4661-88dc-e7f74dfa8e0a	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
0a3f567c-820b-40be-8877-d49cf37df55f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	483e2989-283b-41ab-80fd-7edb010ced07	0	2	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
556e03a2-bc3d-41f4-8c61-f4397d23372a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b57982de-3d7a-4425-81d0-dcb06f848d15	\N	2	5	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
e51a1a17-b136-4886-928f-6e4b45262f5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8c764576-a7ca-4a52-a0dd-a7663a74a5cd	\N	3	1	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
084a095e-477b-4b73-87e1-ce7a78bf3c17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f12387c5-2182-485c-80be-33cc03395422	3	\N	4	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
ede1ba7c-7431-4aef-84ea-0f60fbe6eaf8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	94d5e521-28cf-49a0-8e03-4bbb691464ea	\N	\N	\N	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
aa9e2cc1-52be-45ce-a371-63742f4d20c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7636a330-ced8-4baa-b1d4-f449b55aa31e	2	1	36	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
29e25ae1-c213-48df-bb62-dd59ef2071be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a63e87f5-6751-4b0c-a0ae-313b9028b351	2	1	2	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
0dacd07b-2e28-4b1f-8ac8-26f99f22e64b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0484a289-8342-4804-aad1-a8092c166030	\N	\N	11	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
e09a39bf-bbab-4bca-858d-7f1341044820	39f5eb74-4722-4aaf-a6af-2c6e972e5885	41cddece-8368-4dff-86b7-737e006360fd	\N	\N	2	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
51c9aeea-5c77-4936-b2ff-64d0a960c3ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5a4691d3-f3bb-4352-a31d-8938f9f56a75	\N	19	2	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
f0e8022f-b0d6-4433-8a39-c8cdc4e44666	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4b918f7e-ee56-4988-820c-4384029c093b	2	4	18	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
8ae43d3d-f860-4a02-aada-6c277958dca9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3275a2b8-ff8e-4d3b-a7a0-fa3658dcd88c	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
29ed0ffa-43b9-4109-82f5-df2f96af5374	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90166183-7aa0-4a6d-ab18-f9a8ea3f8a01	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
29ae6626-2f4a-4ab9-9cab-a0aac31a533a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	452f06ee-047c-4a3f-94a3-532f6596fa98	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
1cfc9aad-282c-4ef6-a899-3f729ffa8db3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0883a50a-b3d7-47a1-8d53-6c4d9f8115d6	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
d1a2fb25-bce4-4a68-b28d-566bce733fc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ebf5aadb-5150-46ee-9754-8db8f3b62643	2	4	20	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
0f32f336-6c23-4ed4-ba29-169087631a10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8093c4c-6a51-400c-b136-41055738a4e7	2	\N	2	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
77bdca41-6427-4c8e-bb8b-db19333a237d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34c1ffb1-d7b6-45ee-a0cd-f4d1dd72b5e9	\N	\N	6	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
0a72ffbc-a81a-43da-bd77-6563190f3a04	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a070156a-ab83-4618-a79c-9b966604318c	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
2b240148-fa8b-4afa-8acd-e2fc676578a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a10c0e87-818e-4dff-b98c-133c40351505	\N	\N	10	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
fdef9ed3-17dc-43f1-84df-493e73a0cfd1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	485e7536-ac00-4dd7-90a6-1593cbae3076	3	2	16	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
01eb56f5-238a-41ea-8650-56555be57040	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34a0f0bb-9803-47cc-b6d2-a8d607404bc0	\N	\N	\N	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
66f460a8-dd26-4a2c-9e9c-902132fb73cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1071e889-9d30-4a60-8523-d04ad88bb4a2	0	0	11	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
8f1ef4c9-302c-4295-9e4a-fb949b184b07	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d9b1d17d-c3ed-4ac1-b7d1-374d5d6f864b	\N	1	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
a20b57b2-e583-4ae6-903b-9d785baa28c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e4a93761-c59e-46a4-bf9a-dc9b77935bf1	0	1	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
dfe4ea52-2a5f-484c-8d58-d35a494f46a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a955a456-18a1-41aa-ad66-a198c66c8d96	3	3	19	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
5699ba19-1031-4f26-87dc-60d58ba9b31e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	38a01725-6964-4d5b-84ab-6787fbcb0058	1	\N	16	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
53e816b3-d9ec-43d3-9ddd-8b61e2df42d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e37e60eb-e850-47cf-8962-c2c16aca8212	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
0eeb344c-6a01-4419-8d87-d8f12f2db434	39f5eb74-4722-4aaf-a6af-2c6e972e5885	16d982f6-f666-4801-bf28-bd01224c0b9f	2	2	19	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
60f00ebe-aa21-4d78-bc3a-64256a96d23a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9ced9acc-342d-4c75-9a7a-2ab23ebbe519	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
2c499cb5-2358-4c83-8117-510dd5f44f8d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cd1681b2-bd6c-4596-8992-a24fe716db2f	\N	\N	2	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
626b333b-a375-4b4d-afc3-f1218865ad31	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f1acd6e-50e0-444d-b56b-0a098cc49119	0	0	0	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
6fa1ec7d-a2b8-4820-99b7-c1fed09be787	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d47981fb-64a4-44a3-be5e-352e8834829b	1	\N	4	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
5d180395-36f4-4459-bc9c-7d9890b5ff34	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a07d871-c4e6-436a-8fde-9a484d151340	0	6	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
7220f37c-9bd7-4723-aa7c-93b70174633f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fa1b7cd2-0049-4376-bb52-a89998ebf387	0	0	2	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
a975fb4e-3f46-430d-bb73-88d12737a2ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	70b6c110-e1f7-4117-90e2-5ecb1a6c471c	1	6	1	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
234d9e77-a7bd-4fa7-923e-a6f5ba71c810	39f5eb74-4722-4aaf-a6af-2c6e972e5885	02f74d00-140b-4d31-93ba-40048812f570	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
c1b3465d-b9ed-4d10-b67d-acaa711685c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	29bdce04-8166-4191-b519-f09e1482c696	0	1	0	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
5cc63b4a-66b7-479b-a0a0-eea3edc88a0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	91252030-f154-4009-a72f-f22c362299bc	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
01e37990-0ca9-4b19-9e43-381307627064	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0ddd1bb7-e9fa-48ac-bc31-027692683d41	3	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
4ad766cf-d455-4a08-886c-f995cb6f9ad1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1d2a9c5d-8417-45dc-be58-b1e50c9d87ab	\N	\N	\N	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
a1664998-ca1a-4c62-aa3c-1781e29eefef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	57205b17-a363-49e7-b123-6641f53814a2	1	4	28	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
6b9cd08f-d6e8-4ced-972e-da9cc35047d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ccd69987-2620-4283-bc3f-ef1a02da2f00	\N	\N	26	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
838a1a8f-d524-466b-8a9c-84fb73d8ab3b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	61c6ab9f-b858-4ab5-825d-f47a56e8d195	0	2	6	2019-12-20 05:48:04	2019-12-20 05:48:04	\N	2019-12-20 05:48:04
7e7ee356-06b3-474e-9b98-bf9106bfdcaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f5811be0-6d20-4c4a-953d-d7a2db8e2971	3	\N	10	2019-12-19 21:36:45	2019-12-19 22:30:45	\N	2019-12-19 22:30:45
4da2fbba-360f-499a-a00a-1e7205d51aff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e8d7082-009f-47eb-a435-4790a0a45ea5	0	1	30	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
1235ef3b-deaf-4f19-a751-3fc08beaefdd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	733ef222-92c0-4aad-8534-b9383c9ec96a	0	0	17	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
c3986dd3-8839-4f9a-a5b6-54c90009d97d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	240e56d1-9eba-469e-955e-9e937948afe5	0	0	7	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
1bcb1812-d035-450f-a2a8-7aec1f4ec4fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d68ba4d-4b8c-4763-bd7f-581b744f229e	0	1	3	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
83d67459-323d-4fdc-b709-53c9816380df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b7321133-c2f8-499e-a462-d485d06b3f5d	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
2c825351-8a48-4c05-8962-72695306a9f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2cae2791-4792-475c-aada-02e0726800dd	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
5111a909-aa6f-44e4-b12c-b56903ed623e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6ddcfe00-83ef-4eba-b4a2-54806be4a89a	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
0776a723-54fc-4c3e-a4cd-fb3ea9d4d6e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e35c1db4-079c-41a8-9553-0731c2078c9c	0	7	8	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
23456bdd-4e26-450b-b718-6eaa4022fc4c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	92f530f3-b5a1-45b5-8b43-c1fa5f5b0b0a	0	0	3	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
26f2982e-8d79-4bca-8e78-b0674c27e90c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7f41d88e-5168-4b3d-a34c-94453a126dd7	1	1	3	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
cede4071-2ab0-4f69-a5d2-d6970f2c39d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1aded10b-e5f9-4e09-8350-d5d2ef424320	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
33262b67-7a82-42c3-a07f-36535f357ca3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	32d62d92-0233-4e24-af9a-a6d35ca0d892	0	0	2	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
4cbc577d-d286-4faa-9150-39d4d9917810	39f5eb74-4722-4aaf-a6af-2c6e972e5885	39712509-e8bc-4617-a660-7fe3f4a82a08	0	2	1	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
58cabb76-9898-4b46-8159-3c751af309fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec5bd1d8-da94-4770-a795-700de9f07fe3	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
04b97603-8fba-47d3-9a1b-ef6f2a635e4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	254b4845-a832-40a3-8dca-b486f7eae938	0	0	0	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
92e4f8f6-f6e7-4f15-93de-1581188554c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	635eca1e-feec-47f8-8595-fa7522c3742b	0	2	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
8faf4577-9434-4d42-bf0b-d6ac30497b96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8b3aa4bf-cd46-4f4d-9cf5-61876304ca0c	0	3	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
16e498b7-5866-407a-8971-f5c457806427	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cd10e329-57f0-486b-9ef1-5cbd64277bad	0	0	2	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
9fb972a3-c90d-4c56-8f5f-9d9991575145	39f5eb74-4722-4aaf-a6af-2c6e972e5885	448d13bd-e65a-42dc-af65-f56900ef25bd	0	0	5	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
661e7232-e500-4d2e-882b-ef333fbc61a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4918e433-998e-417f-b553-b7a3b9a55a38	0	0	25	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
3aa4b709-8072-4adf-b4c0-69226f81b608	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e17360ad-2a9c-45db-9dec-8609a3a01e72	0	0	6	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
3249a532-3584-4d05-bfe9-f0dd49c3f2d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	07d82fb7-5e2a-4f2a-a906-206ff3e13661	0	0	5	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
744f7989-b201-4612-b360-00c29ba7a128	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ddf6414b-79c3-4772-8729-1c26f70cda96	0	0	0	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
10b94a34-404e-4e2b-b9c1-c5d57e63506f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d07a868-4bb0-491f-8804-f451924e5aa3	0	1	10	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
ab259bb3-d2cf-4f66-89ae-1587ba61e5c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e6632a50-680d-487e-b7c3-27adec23ca72	0	0	2	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
5a402bab-ad44-4fc5-822f-066fdb694412	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d97c149d-f149-4d0c-9eae-b879134b8016	5	1	1	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
28004c51-97e2-45bf-8ccf-a82e89a617a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	04bd404b-e5d3-466b-80b0-633750798501	0	0	12	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
97e26a41-3b6e-4424-9255-e2f92f11d5fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8272c55a-caf3-4e9e-a721-2bb34ae3e369	0	1	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
37e6c832-ca93-48d8-b9e1-c941ddb0706b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fdd1a684-ff3c-431f-aaa7-5dc82e378027	0	0	6	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
8effa36a-1b59-4a61-b4e3-3811e51db1a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eb0f1741-4db9-4c4e-be3f-8a57cfdc9a88	0	0	8	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
d3bf0d0c-245f-4025-9dbb-64d706e83bc4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d50ddede-66b9-4477-b9a6-513d9a1b9b80	0	7	18	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
39337a67-8c66-480b-bb1d-a410aa44ab20	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f012a6a8-f107-4b72-b03b-273d8009943a	0	2	1	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
94209b79-5280-4ed3-b2f4-5a1347139e78	39f5eb74-4722-4aaf-a6af-2c6e972e5885	61a6e8d7-0b58-4311-986a-c981eab451dd	0	0	0	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
262e246e-28b5-44b8-b97a-b48bb2eb2aff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	758d2347-9e38-47e0-870e-07dd9747ccdd	1	2	9	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
0134b40f-04d8-4fe3-ba44-7b509eef251e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	97e28aaa-a13b-4bf7-a3db-691c8a3c9176	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
61fd440f-5d0a-497c-b5d4-a033e3d1c039	39f5eb74-4722-4aaf-a6af-2c6e972e5885	547071c0-a968-444f-a613-37945a72d166	0	0	7	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
f837317a-bbd2-468c-8101-20f18e8e0419	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0bfebd85-0aa4-4030-97be-d14f7be1d828	0	1	6	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
f2dfdf7a-b736-4051-a643-63dbcb891dd0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e69344ea-86b3-4b3d-bdba-9896b5780c04	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
f62d2c92-d03b-48d7-be90-ea2be10bffbe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bac1ac53-bf22-41c6-94de-f13910d038c2	0	2	21	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
4eee03bc-a06b-41ad-ada0-b7eedac20d73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1689d0ea-0530-44b5-af3f-c4680c12c9c9	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
8ca587cb-fb7f-46a7-b4d8-4994751909bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2d1c00ea-2b79-4219-8711-c459ce48e816	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
b9259f4e-8bda-499d-ab35-ceda68ae3c6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a6a5f91a-9ae7-4a82-abd7-ca9fea646e8e	0	0	14	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
dc797040-8f00-4207-9a5e-de3e828d81c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c05c93c8-b024-47dc-bf32-67943ab05057	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
34f5cac2-bdb9-49f5-8a3c-9bee1d7704c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	472ac69b-7383-4252-b82d-d24b834a7d37	0	0	7	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
f78f1f66-3ed9-4ac8-9032-891bce4eada3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78ffc917-ec8a-49c3-9faf-0346ebda3887	0	1	11	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
7dc8e29e-96fa-469c-b845-2c6a2d61b7d2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	090c3ebd-d18b-474c-b5d5-b051c6bd3556	0	0	4	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
0e151ea7-a8f8-4c03-938a-7abe33cdff94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fd72b359-ea7d-4866-a507-54e51ba48d47	0	0	1	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
fba7bddf-9239-47a5-815e-07ff7c05b08f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1359a8f6-4a1f-4676-90ed-989ddf4a74dd	0	0	11	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
b6efe836-0393-44e6-a892-0d6e020e33ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f76e6bc0-7ab1-436d-adc9-bfdc1a623f74	3	1	5	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
7eb737fb-064b-4690-9a07-03789531fa52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b5618c20-3ffe-4153-9d80-479fe3a409f1	0	0	0	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
c0d1c657-e6d1-42d2-ac5a-f62d1e09269e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a0990a00-ca01-4838-9b85-d2713f90223b	0	3	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
60290e62-6366-4a3d-87a2-72716450beaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	097ff6dc-ff65-49d7-a657-ad7888c2fb28	0	0	3	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
32f0608e-3786-498e-9882-256ea24b9506	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9c85d5e5-ac31-4546-bf4e-a4c83490296b	0	0	3	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
968a84f6-bfb8-4136-a446-d2cd56a81874	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c161f035-e875-45d1-aca5-a4c73e99fab1	0	1	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
7c664bff-a08e-484d-a388-eb286a6791f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9a9d516c-a106-447a-ba9e-948c3044dc3f	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
dd0934bf-5d25-4a97-9aea-e132f06b2cc1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b6f0faf-9b91-42ea-a613-d0b097696ed1	5	0	7	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
e0e0fbb1-ab83-4483-b8f1-2718d30ebcc8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bff9e421-bc3c-4b1a-b87b-56b5b2f5f48b	0	0	21	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
173e4299-578f-498e-a0a3-7b3898e96f94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3b6a90ec-8a07-4975-8c43-47eeebc29c32	0	0	0	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
a2ab602b-d18c-44ea-a944-004381783d3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4371c459-b2a8-4b80-9d0f-15add171a8a0	0	2	4	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
9e4ee604-b617-401c-a54c-7e29901d15f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf3b8a76-692a-444e-985a-2c1139b2ffbc	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
c1a7f5c3-802c-4e55-9706-514c818a48bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f2619e22-8cb9-414e-aaa0-a9448e44835a	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
ed7b5aec-76e0-4c12-9c16-2b0674fc77d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4cbb298c-97db-482a-8341-d02f736034ed	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
484f8d75-8714-44f6-b911-c4632cd040dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a32c11a2-794b-4aef-af50-621b63fce0ca	0	0	6	2020-12-16 08:05:17	2020-12-16 08:05:17	\N	2020-12-16 08:05:17
62f1feb7-de7c-456b-82f2-c0703c82c925	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b78f1d3e-dee5-4e07-8666-fb7f026880bb	0	0	0	2020-06-18 10:12:19	2020-06-18 10:12:19	\N	2020-06-18 10:12:19
1b60d277-03bf-41a6-8988-c06af3667a88	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d8aeeb73-373c-4d30-abef-cff0d5abbb24	1	0	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
f3fef872-dc9b-4de4-a5c2-d81650cc269d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4b91eb40-1625-435a-bae1-4540f341f938	1	2	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
738c171a-3f3d-4a5f-bbce-61eee66dea3c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1dcd091d-2dba-4513-b01f-9de7412c2a6c	0	0	8	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
3ac96c1c-8fef-4264-adcf-3d908d4f1244	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9cef0bc4-5303-49e7-a36b-079194a44def	3	1	6	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
7ad9ce29-ae2b-43e5-9c58-76fd8643470a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6edea0ba-058e-404e-868c-9193dc5d0d92	0	0	2	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
e5255eef-e31c-42c8-8507-798588c7494d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f85343ff-1e4d-44fa-97fd-abd692a5dd12	0	0	18	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
fa5fdf36-4e99-4e3e-b84f-e52f2c3bc46f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d09da4-eb61-4092-a1f0-e10f01d2f066	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
751b00d8-64b1-4bbc-ab3f-572423944bb2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	af22a6cd-9a35-4f41-a919-bd6dd5230d85	0	0	6	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
ba4680ec-8f4e-4005-ae7d-01e7072d1b8e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	93b136ff-6fc7-4aad-ac92-b45251701803	0	0	6	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
48779426-4640-44fc-b974-e18616d1dd73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	da17f152-fbee-4841-b4e4-b02aa8cea7e8	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
1c369bbc-1aa5-4068-b1c1-ce6e7a48b04b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d03eff6c-0f33-4387-966f-bfaabb9b3b92	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
24cb3d7a-a827-4ce9-bee9-65f24b9f5696	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f00755a-0d1e-40ba-8fcd-659a38d51ddd	0	0	4	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
46d6b0b3-da05-4e5f-bf97-e12f261ef51f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20a0e769-8529-4d3f-a353-55b9a33b6b9e	0	0	2	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
7b2d63e5-cdaa-4cc1-8e44-1feba375e884	39f5eb74-4722-4aaf-a6af-2c6e972e5885	962e31f2-3248-45aa-9d55-3d6af6ad8cc7	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
557030f4-dc91-4d9c-bb36-c5250a531dea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5ca5f03b-275c-463a-acdd-e6c7c0b842a3	0	1	16	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
da34b948-8168-4d2b-937a-f2e65c544cdc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d69ce18f-b1c9-455b-a34b-6de894af9fd1	0	0	17	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
169dcc1b-3f5a-4dd4-8ba8-f91e670a0f0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7db73651-2bf5-4c84-b567-3e794e5b29b3	0	1	8	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
2a53b112-388b-4738-9d6e-b62a289bb134	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b85ca89f-eeff-4e57-9cf6-7a5a50949b8f	0	0	2	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
e6666b5c-767b-4bed-9600-cfa6d89969fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4448529a-5e04-4713-8422-2acab1b87f3c	0	0	2	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
33e86db0-8fc0-40e5-976d-fc6009d6a2ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0144d00d-9b39-4f7d-866f-cc520f4e54d1	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
3f695ade-c04e-4dd2-ac47-0a4858df3e9a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	279c153a-87e3-4696-b084-e8b1ad160279	0	1	10	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
8d76dd00-3433-4c28-9bda-5c76a3bf0043	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b0df2283-ea2a-47ef-a781-08eca2de1bf0	0	0	32	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
a6e4a616-d6f7-4df3-b16f-bfe03dd0b34c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	272a2dd3-7745-489c-829c-53728977fedb	0	0	3	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
52f9044a-bb9b-478f-a45a-f7beac8a3454	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e97838dd-d780-4af9-8a6c-4f5554a78952	0	1	2	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
21d89d88-1997-4af2-a9c4-9e15748cbe2f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc2a9b23-815b-4e82-a9ff-3bbc70ec7d0f	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
535129ae-daa6-48da-852e-d438f7e16b30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	97df4bb0-4fe1-4dd5-ac7d-067855eae24c	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
8961dc8f-4ff9-44a4-b707-142331292665	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6cb96df8-e977-4adf-b36f-2d0658f1df9f	0	0	10	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
5c7a9daa-cc38-48e8-92e8-966fa47c94f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe46f127-dd46-4470-a57a-1fba7de136df	0	2	5	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
e5ab7c39-ad29-4d69-bb26-68eb5f505d92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9bb0c82d-c6c9-4af0-b020-f9f019f4dd63	0	0	3	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
ffc43f24-8fa0-4648-bf33-b19d4fb7333d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d06823eb-0bf0-47da-81c4-cea99e302ba3	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
1779c65f-cacd-429a-a063-4b9c2857834d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f145e265-46de-4517-9e05-745a2038a808	0	0	10	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
431ae464-d146-4712-84d4-65ef72ad0426	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5fe41b97-5412-4cae-9ee1-fce416b7194f	0	0	11	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
1d04d2a4-c7ac-4f67-8865-f9299d36f1ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6cf4630d-5f54-4033-b1b8-85a2811f20f7	0	0	5	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
643999e6-c0c0-4336-abfc-ca3bbfabdd2a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9368a1f8-aa60-490a-9dbb-474271d698e9	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
74984c1e-be19-49f4-b85f-c0ec7d09b663	39f5eb74-4722-4aaf-a6af-2c6e972e5885	466d0765-6a6d-4c16-a6c0-fffa37b7f8c4	0	0	1	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
b32c8087-c783-4836-998c-819b85835f72	39f5eb74-4722-4aaf-a6af-2c6e972e5885	943c02d7-9cd1-43ee-acbe-f2a6eb814009	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
387bfc3f-2c85-4f9d-af72-704059bb8a1c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	51368e0f-243f-4424-a100-eaf419fee59d	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
01e13d1f-38ca-4425-8f69-831e6fc200a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e01051b-c002-4fd4-b245-ef25e2be04c3	0	1	2	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
e6ea9536-692e-49f0-8346-45197c9f40b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1508ce84-d0b1-4416-ab02-5df906142dad	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
d953f730-b2b4-43fb-8ab5-329e98860c94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c0ebd54e-9c58-4054-8ac1-d70478876955	0	0	9	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
21a0bc21-9640-49de-b04b-5a581cbb77a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6780aa54-81e4-4a58-98fb-6aa1a280c6b4	0	0	2	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
a35c1037-d50e-43d1-b09a-5c383255658a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	03835434-88e3-47d4-9eed-328ec65492bf	0	0	6	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
6b9bd64d-aecb-403d-8db9-bbe6e2529938	39f5eb74-4722-4aaf-a6af-2c6e972e5885	82a74345-f3cf-4bce-ba57-c59536a44db0	0	0	11	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
dd98f7f3-fbe6-44a5-8c92-2f9b68ca529a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47092d4b-e4bc-4ea1-846b-103451b98bca	0	1	2	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
5d32446b-10cf-40c4-a0b6-9c3dbd13a4ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	043185a5-987b-49fc-a409-3847a7e25476	1	0	2	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
743cd88f-f07b-4a7b-9270-ed378e73905f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0bd1ebc8-db2f-48f4-b069-8b96c3982f90	0	0	6	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
1eb93aad-b520-436d-8d42-c918c5918c5f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14265bb6-e5a5-462e-b5f7-028f16fd1420	0	0	7	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
2aaac6ec-5d28-4b33-b975-2242fb31b0ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	681d22da-2534-4012-a8be-da7231d0f082	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
12f4b136-f6bf-487e-bc39-17bc3a2c10b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f6784b5f-4083-42c9-80d7-61b2e72d4783	0	0	15	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
abc05149-3c7a-4116-8f75-99276a7552b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ab96986b-593e-470b-99a7-f24d4a465242	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
3203eba7-f035-4bf0-b902-17b25e4fdbf3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	102c9d5f-aa15-4b76-80fc-fe9db06f4791	0	0	0	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
36e7775f-2d09-4598-873a-d0939767d0bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6798ecf0-86ce-45ad-bbe3-b17eed17f37a	0	0	1	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
3dbdb975-c200-4ef8-b0b9-330a8b98a20f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90e6da58-dd52-4d84-8dc8-9e00a08e4742	0	0	0	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
331fd851-2faa-43bf-97b2-3185af1f95ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	81fb1ffe-1d8f-4319-ae90-bb3fcf776cb8	0	0	1	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
9438423d-e229-4d19-a483-28d16438b67d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1fbcb6b-08d7-480b-b538-1ba10021b66c	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
fd3c0293-b341-48f7-93f7-5887a9ee49a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6fa4362f-206a-44d8-b795-697b740bf6f0	0	1	2	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
0a5f6795-7c26-4931-84a9-18bbda36d52a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	39e6e8aa-7b1a-4e78-8300-261552f4514f	0	0	3	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
0ba70063-5c0b-4ddb-a81a-81288c75f6f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8319eab1-63f4-49c7-aecc-bfef92d1870b	0	0	4	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
488fbfa7-13d7-4b88-86c0-13dbcc8a20a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6fdfa414-ab24-4c25-ab91-de7778c331d1	1	0	4	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
c1da1e41-9057-46df-9b8c-6aa46f0a5916	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e6f062a3-f44d-4689-a2e0-9869230db156	1	2	6	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
768d9ed9-1958-4ea8-b360-85fd71156f0c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	91c5272d-82e6-4f16-a83d-041088cb6c58	0	0	5	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
98b4b236-0e74-4ad0-be96-158ea446064e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3a5d2efd-33f8-4153-b719-9e231578640d	0	0	5	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
eb92bbf2-c285-4a28-83bf-bb1e23ae23a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fa462966-aa11-4031-8f2e-a1ea2eac02bb	0	5	2	2020-12-17 08:15:29	2020-12-17 11:48:48	\N	2020-12-17 11:48:48
b46983b5-62a5-41a3-afed-a726944677e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d91ffad-be49-4ee6-a2a4-611d2e489755	0	0	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
dd21948c-77d6-4376-b525-68c67bdb473b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	961a92c7-ca4b-4bf6-bc06-687cd5eb9c7d	3	3	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
e3fe3f9d-00ca-4583-a50f-8ba700ae24e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	17d4a529-e819-4988-ba4a-4649f70c023f	2	0	20	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
bb3d9c56-2f02-4ade-9354-015dc61a44f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f6c34644-93d6-44df-8ccb-4e42a92c5a9d	3	4	16	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
0e54ef04-34a6-4c19-89dc-138486f0839a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	341dc2ea-8bc9-457e-94cc-bd6818b36ffe	0	0	7	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
e2b8c2fa-7ad4-439d-83e3-d4f1b842df73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2a71eb38-b151-4fb5-bb1f-cf3e62d43f1d	0	0	8	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
0c911107-cdc4-48fb-9275-37e9c8dc3f0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3a72bd49-6285-418b-ba71-1150e596c6d1	0	1	2	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
bba0532d-40db-4c3f-a939-9e59f77f1a17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe132f1c-983d-492c-b593-066056feb9e5	0	0	0	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
2f15601b-4998-455c-aff6-b546a03ca349	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b4b28ddc-a39c-4da7-b931-b1bcd01df36f	3	2	7	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
624f28b3-c425-4e69-a2ad-761635c9a720	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e6ab1490-6ffd-44cf-8663-fdae50d1a67a	0	3	3	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
672ed985-f129-4cbc-a9eb-1434733ef54b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	718ac70c-2fe9-416b-ab3e-7805c7b9d62a	0	0	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
f52bb64d-ce1e-469d-a961-95cd959f976c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9b86315e-8e9f-4858-9527-ede2961ac4b9	0	0	17	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
cee67afc-2d82-4c1a-9103-273dda5ed03e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2af72b11-5333-437e-8d93-610fd385d6bc	0	0	0	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
6f98dc9e-0590-40a0-ae4f-b04555e15141	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c2dad4b5-b786-4e7d-aca9-cda09e3c17ae	0	0	7	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
4041e046-5b36-4948-a795-f1a71755ec14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77c6ceec-8781-4525-8753-e83589d8a014	0	0	35	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
90e8c724-d69d-4367-ad7d-233ce4be2b9c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	97436b81-0d1e-43be-a71e-b79a66356bee	0	1	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
7e2a95f3-6802-4c84-810b-1bb14c304036	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1c90b9e-0b71-4e7d-9c1f-603967b621cc	0	0	0	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
49200a07-3792-43d9-9538-33c4768bcbe6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e56b60e8-eae4-4c33-b0e3-7fe0c3c4c7b4	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
0a7bfc77-7246-4e85-aed0-d91cf96605bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9d8a10b0-5eee-46c9-bb32-cc7f4aaa142d	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
d2622995-b387-4df1-9eda-9f93a4a80dd9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9e4c84ed-c944-4227-8c82-836bd1acceb6	1	0	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
8dd36a3e-81b2-4d96-98d1-475aad407ce3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b50e46c2-713e-4021-8709-a5bc67cff79c	0	0	6	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
bb91760c-0e7e-4918-90d7-1f15dee7152c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	224b61d3-6f8a-4fa3-bf0c-20f650316505	0	0	0	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
a16d4d46-b035-432f-aa8f-3b9a6866baae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d3426298-f7b4-4e62-9078-c7b90067ebdb	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
05536aef-6afa-4463-b81e-358605788fa7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	af12a8b6-4a15-44dd-8d8f-180d29136e6c	0	0	0	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
3836c24c-984a-4ebb-80ec-c1a16d38879b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	17a8738d-4120-4a20-bf66-dc7e06e664a0	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
aa6ed98e-6c33-48d9-b8b2-a516f5109232	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6966643e-d49d-435c-92ae-ad102e408088	0	0	12	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
822026e0-8cda-40fa-8b93-91f5ee10a47f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ef1fe8c1-5b9b-43d9-bdd7-2826af8c7e4d	1	1	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
b424a719-2986-44b2-8e1d-0327f737c947	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6232c70d-87a6-4fbb-87af-44ddd4015529	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
44f20040-0cfd-46bd-8d58-621487864f6e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9e1fb770-bbc3-44e8-a7f6-3817d352fdd7	0	0	3	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
1f6be437-5f09-4a26-bbe5-826f997008e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0b101d1c-b0cf-42a6-bcc0-b5f9056f9442	0	0	5	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
31168455-ce6e-4d08-916a-ecb1805044ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4ae77377-8b5f-4cc7-8933-118212cdf3c2	0	4	11	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
c63bae0b-6632-44aa-a3f0-eca0af9e052b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f7418480-ba79-434e-823b-83eb2fcb375a	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
cedb93bc-711d-4b74-bb05-e2f02e24ccea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	773d02f2-d8a4-4005-8702-12142c26bf71	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
9f53ada6-9784-40aa-98d2-18fb82cc8e9b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2359c802-f1f8-48f4-9c75-0a87d1dfb562	0	0	9	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
07edc98b-fa60-4b73-8bcc-b00321a621b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e7602cc-8819-454d-9b1e-14313d6c5641	0	0	8	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
a31cbe3f-a0da-4a15-af92-3bc28ac8effc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f308588d-5d59-4923-84e0-36eb88f1e090	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
dca373cf-4a8b-47d2-a76d-7d2711c57fc3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1cac9867-1b93-4258-b7f0-2bdd9f230a7d	0	2	4	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
78654037-4ed5-4d59-a2ce-38a045c88aae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c46e764d-147e-45ad-ae5c-d50caf75b7f3	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
032a9a69-a714-48fb-920c-a6829e88eb85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d4befe46-e182-42be-94e5-43def498ba92	0	2	16	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
da99aff4-692d-43d7-85b2-893f7177a8cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d505599-fb83-4fb2-ac98-ce989a504a7b	0	0	2	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
718e8560-bcd0-48a7-a081-b2b13e9da320	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1a3b32bc-cc44-491a-b196-456d452bcb08	0	0	0	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
22e5de90-ce9d-4d25-8032-82069f3bd732	39f5eb74-4722-4aaf-a6af-2c6e972e5885	10eae6d9-0340-4161-8ff9-3ff2561bfbc6	1	1	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
5dc32cd0-f7ad-4232-bbad-fd8688e9f0b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9d76282a-14e9-4231-b8e7-004fd5a594ca	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
5ce708af-b7d9-4048-8290-df9b7dedafae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	335fe412-afb8-4e5d-b6af-a6a41e842111	0	0	10	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
35e3fe31-735a-42a7-a070-1523b61f60ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3f5eafc8-2697-401f-b795-a3412d0c38f5	0	0	0	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
a16ee4f0-b514-40c2-9530-bbc489b05b50	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a28fe10d-ccf0-4d45-9a2a-4e0174467b48	0	1	8	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
0ccd10ba-4662-4a0e-9569-7e732a30b4d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	59223f41-1b47-42f9-bf8e-77cb026a1dfa	0	0	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
e3f2d89a-a3ad-4f0d-90ed-b3ebcb639725	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ee12181b-b2fe-4725-bd46-714eb647fdb2	0	1	9	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
0554cfe8-101b-49e2-9c8d-01a14815166e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bfc4e1bf-3b53-4c4d-8b6b-461a7c46fea1	0	0	1	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
f0844b02-9c3b-430f-9531-9168455c32b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9857e936-2f87-453b-baef-7508b97c15b0	0	0	0	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
23d97795-74d3-436b-924c-0e687e2abd1d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4833c306-75c3-4592-bae7-0f9e114d6245	0	1	18	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
a6988290-4958-4c10-8a80-44b739d9ea6e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a2820310-369e-44b2-9507-e230c6f45007	2	1	14	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
adde89dd-e01b-4cd0-bdf7-f651567d3181	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1174586a-9511-4235-a501-df7bf4c5530d	1	0	4	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
58fb1274-1b10-45ad-8c50-bea100270052	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b6ae27a8-a9b2-4cba-b9aa-676deefe5773	0	0	0	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
aae93de5-ed3c-4d6b-a5f7-df3dd076499b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1f8c5ddf-d4d2-42eb-b54c-b8bc1bf59d3f	1	2	2	2021-04-26 09:36:43	2021-04-26 09:38:31	\N	2021-04-26 09:38:31
ff41a556-9cc7-4340-9769-047e06a8913f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	180e74bf-0159-46f9-8942-a83f81fab93c	0	0	0	2020-12-17 10:11:29	2020-12-17 10:11:29	\N	2020-12-17 10:11:29
d7d0a557-207b-4f1b-b657-6e3eff15db49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ed9cd7b5-4f6f-49df-8b39-a0176cdf15ae	0	0	0	2021-06-02 12:21:28	2021-06-02 12:21:28	\N	2021-06-02 12:21:28
ada0bd27-f25e-4c7a-aac2-03e83a98c8f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8981e975-ba5f-4e1a-a945-a83ce0f84668	0	0	4	2021-06-02 12:21:29	2021-06-02 12:21:29	\N	2021-06-02 12:21:29
551a1022-f528-4933-b69e-68ee2a51a5ea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c01851d1-9b45-4900-a556-97349fa2b1d9	1	1	2	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
c40443f6-9caf-4bcb-9ae6-081d21a05be7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	45b5e4af-15f4-47f6-bd02-ed45b675fd4c	0	0	22	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
9bc44105-113b-45d7-a280-681b4725cdc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5881f698-7fe3-496f-abd1-bc742df14a38	0	0	49	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
0f61f80b-c822-46b8-bd76-73416d2c04f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c3bda365-58cf-4496-80ba-b7b8b83ef16c	0	0	12	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
46d0c5e9-69c0-417b-b9f5-3e6e6e22eb6f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f4000f99-92b5-4eb3-8503-9ac8049ed6bb	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
0b17a569-f954-406d-a04a-af0b4b2e0b63	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8126bec3-6792-462c-8746-7ec93c26bccb	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
b819be9d-0af8-4127-a897-670d349860d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1e692d52-4abe-455a-a07a-fc82c06217d9	0	1	3	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
4ce3b361-df10-4fc3-b5d2-071de47bbf93	39f5eb74-4722-4aaf-a6af-2c6e972e5885	13cb8e65-4d9b-4774-81bf-e7da3df1316d	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
943ce8f3-8aa9-4a68-b2d8-5f36c33c3db7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	81b2c090-376c-4171-9060-f22bbc1451d0	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
f8db0c88-095c-4c88-ba21-3780274e08b5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	821da089-12f0-4049-a9d0-d08cc8027297	0	0	0	2021-06-16 10:52:08	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
a4ea5c37-7b6d-4f4c-91b5-d67f57d1c4ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9f67a8f8-bb7e-44f1-9f54-095f71aa5516	0	0	2	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
74425dc6-5c05-40f6-a1bb-968b45a0506c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	435ef1b6-b895-4412-b6b6-db6a2e9a57fc	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
b70d27f8-313f-4fa8-a9df-073cbf328531	39f5eb74-4722-4aaf-a6af-2c6e972e5885	76bc4800-5696-453a-8d1f-abbc0904221d	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
797d21f3-05de-48b1-a792-c42743ce9602	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ea3a6a60-795e-49a8-8457-1016e185950b	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
bf67fd5c-0cef-4239-b3f4-22d2416b20ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b88d815-dfb4-4b03-ae25-a0421201935e	0	0	45	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
15ecbd2a-9987-4e35-9efe-0e54fc1bb999	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b595eadf-c983-42f4-b220-2d8141a4e5da	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
ccd4ec6d-3634-4237-8a75-0e734e88c5e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7986b0d7-f34f-4889-947d-d6aabf22c025	3	2	12	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
d4c50f89-cbaa-4553-bdc4-13172b3a6dc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c334e6ec-2732-42a9-887b-2b7b05068916	0	0	15	2021-06-16 10:52:08	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
ec95a093-75b7-45ec-968a-8640f486e712	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f3df02f9-068a-4aa7-b42c-49ffb29dc25a	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
fda4a210-61ec-447b-9559-ecf0a5de13e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	827f175d-0ca2-4959-b236-4bb944838353	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
4a6f326b-3c87-4cd1-8f17-a40fa5591c09	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4f6858bd-e0db-4495-878e-82e5c998275b	3	1	8	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
d996beee-e2a9-45dc-932e-0ab91a5d8aba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ca589217-2960-4e5e-8413-5dcde37884ba	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
677c6d0f-1582-42d0-8f78-96b4caf42d10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6c556cec-65d3-49a2-a221-28a95fdbe01b	0	7	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
76d14a9b-d378-4542-b18e-2f354dbe482e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d55b9eb7-3253-4f16-96a0-4195a5e4a17d	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
d9dcd915-6660-4310-9589-e8b0b985dbad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ee2be826-0fc4-44d9-8538-b60989982c67	1	1	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
b1c0aa13-21ab-493f-b6bf-11f5ef0df11e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b0552e3-f7b8-44a7-a805-1bb460cf11db	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
bd71e692-46e6-4bbc-a78d-1bbb3d9ab69d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0d32b76e-b3e9-491e-b67c-ac5b68371c0e	0	0	0	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
07f369c6-ae7a-4d92-8814-fab1f4ba0398	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f7dcc53d-f458-4ee6-b2db-0a1d4256a197	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
e495873d-1aa3-42db-8fe8-0ce888a800a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8aa7edad-a7d2-40ef-850d-fdb1e0c2cf35	0	0	1	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
e5278a03-54fc-4873-b33b-2dd7383d1c08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	febc107a-2436-46f6-9472-f8e6635fd4f4	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
c0a4a623-a602-4fd7-8840-84478ea4a0c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	059e4eee-f596-4c7c-84ab-6261e32d0fdc	0	3	15	2021-06-16 18:18:41	2021-06-16 18:18:41	\N	2021-06-16 18:18:41
88e53b6b-76d8-429f-a6ed-ff4b7b22c5f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b339b760-2355-40c6-aa44-86c7138fd7f7	0	0	18	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
d441dc9b-0bd1-456d-86b2-95b4f6715ada	39f5eb74-4722-4aaf-a6af-2c6e972e5885	56149761-9c17-4956-9557-a33d8bca828b	2	1	6	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
62868e87-2c22-4057-8cef-1ab20221b71b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	de984c96-eb9e-4771-8fea-a2c1d53fc5fb	1	0	22	2021-06-16 10:52:08	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
d7fce8e6-f7e7-47ea-8cdf-386e037cb0aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5a69d764-248b-4d43-b019-8a95c06529d9	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
78693366-3cb6-4410-ac50-a03d3ce9116a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9bf05962-b687-4be6-9d8e-ebd0df63b32e	0	7	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
d6f68d89-81e8-420a-8278-f77d7a65b148	39f5eb74-4722-4aaf-a6af-2c6e972e5885	939966e4-d879-46cf-9e3c-9c974bfa4826	0	3	19	2021-06-16 10:52:08	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
82d7595e-261c-4fc4-9b8a-149caa95bbf4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	995b0264-1bee-4f0f-8425-3a64ea7a9012	0	1	25	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
3607c350-bdbe-4e7d-88d4-8cc8ff00d3fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0d8e3d3c-229b-4706-88d6-815ab78d7853	1	1	2	2021-06-16 18:18:41	2021-06-16 18:18:41	\N	2021-06-16 18:18:41
a8a2a96b-bd1e-4347-80bc-39605294fe32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7cd0be52-bcbc-494c-9a38-54d2678c6512	0	0	50	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
4e68ec67-a0cb-4bef-9368-02999e856e58	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4b3421ff-d3c6-44cb-8060-3acb3c9e4d81	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
b7810182-d873-47a0-84df-3d0448871dd8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	890f7574-f25f-498f-8a0e-33d28499cefe	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
d48445aa-98b1-491a-9239-e245ef6a5b94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	df31236c-bde5-4e94-96dd-e6ea78f70c22	0	3	29	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
1f8dedb3-2546-492a-b73d-c3a350388b2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ed41dd5f-a8ac-4f6f-9e77-0fcf2f46765c	0	3	12	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
01a9f5fe-5de0-4194-a958-cde22d0a07a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	67c80011-1231-4e0f-8b58-4f9e88ef4c91	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
1df6ee38-670c-4359-b55f-c9cb559960a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ff15bba3-ea20-4058-953f-6d2b96c85167	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
06bb75f7-5b99-4c30-a4db-d94d95bd8168	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3efd2487-eaf9-49f1-bf4a-c4759ddc1d09	0	2	4	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
c6646e17-3558-41b1-9de3-41bc7068bfa5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1636bf6-2304-46de-be36-b4844ea009c1	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
926588c8-09e5-4f9b-a2ad-a46480537e8a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19aa96c0-1405-4c23-871c-34497aa4f978	2	0	3	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
a0fa8131-372d-4ed5-9c9a-5b631fe2df54	39f5eb74-4722-4aaf-a6af-2c6e972e5885	44bf6b90-6222-4cab-a609-58387bb46680	0	3	3	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
27cd6dc7-0285-4a02-af73-fda96c6e7692	39f5eb74-4722-4aaf-a6af-2c6e972e5885	be99e2c1-6202-4481-bc14-1b26ba4e8ff2	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
618a9353-4c40-4c0f-a506-93d7d5c5d667	39f5eb74-4722-4aaf-a6af-2c6e972e5885	30373932-fa49-4847-94bb-ba972206eed7	0	1	12	2021-06-16 18:18:41	2021-06-16 18:18:41	\N	2021-06-16 18:18:41
fcf86736-6bc9-4a50-b93d-e331815e3400	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cfb80aac-509d-4af9-8ff5-5a4878ddf3e6	0	2	3	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
66d1ad31-024d-4257-9015-248bf71bbb1b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	889b017a-d94f-418b-9c06-035906af1fab	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
627f4809-52d7-4a65-aac3-7648983fddb2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3d26991e-4743-4767-8d99-3e69182da319	0	0	1	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
bc5e539c-ce06-4aa2-a128-720efb09e2e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e55be11-f523-4560-b1a3-38dfd6b08078	0	2	1	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
af32ee8c-7802-49e9-b671-82d7735b09fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d633cd39-d975-4064-a253-95632e90c8ba	1	4	10	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
02aabb76-c226-4cc9-81c4-c03c9acd5a4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d8faf67-c189-49d5-ad71-8d70aed4a092	0	4	1	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
79c004fe-c33b-4c40-a4ec-932d39f7dd38	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2ff612ac-a995-49bd-8e8c-85880ec5458b	0	0	0	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
39310efd-f041-4183-a0b9-95ad34b793bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8d13d8bf-35a1-4d76-8d76-f26b7c0f19b7	0	0	2	2021-06-17 07:42:59	2021-06-17 07:42:59	\N	2021-06-17 07:42:59
54e818fc-ef02-4c4a-a07f-6a3ff38f4678	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b1eabe64-c1ea-4d86-8447-32a967ede3c1	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
035513fc-d9df-43f4-aff4-849d2250f2d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3b33edf5-da17-4e47-aff5-2a136d13aff5	0	0	0	2021-06-16 18:18:42	2021-06-16 18:18:42	\N	2021-06-16 18:18:42
5e98cb99-3c93-491a-a61a-27530884244e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0441a4b9-5bde-4c74-a541-ea5a9991eb89	1	0	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
7afbb3ac-2947-48df-b84f-2e7623190f69	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a559819a-7496-4e43-89a3-19ed73881f30	2	0	0	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
afd84f4c-1d96-442a-8e81-2b89b75d4d42	39f5eb74-4722-4aaf-a6af-2c6e972e5885	252c3715-fc9d-4800-adca-cfaf1f1588f0	0	2	11	2023-01-11 13:23:49	2023-01-11 13:23:49	\N	2023-01-11 13:23:49
a32d6405-e372-49c2-83f0-77374c64d547	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e87881ef-f7dd-4094-aa64-01faff675204	0	0	10	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
85b0660d-0d04-4e23-994a-bb0d984435b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6d61544f-6e12-4a05-9e04-1f9b8a994aea	1	1	11	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
03a94e52-1e2a-4020-b731-c443e47704cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d98e27b9-c4b6-4603-9a3f-63040af46422	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
853e7e1c-1934-4d96-b716-bd81b7f42ee2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1187408e-8342-4b58-8e88-d2d749f4d2be	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
19ced344-a417-4f7a-87a3-e2ab1a3428a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f080ad7-ac17-4604-9191-ba1c82b24ad1	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
e12ab3c4-7602-4682-8e43-afa8ff493e6f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d68d2519-c936-47f5-9ad5-56ba71fc5a53	1	1	2	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
55d6f69b-6f8f-4566-9783-2bd00ecec6e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e960d04c-2510-4557-a02e-323ab0c67d64	2	2	0	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
b9ae92cf-8842-4630-b99b-251805a78961	39f5eb74-4722-4aaf-a6af-2c6e972e5885	52fcefd9-1058-45e4-9110-ea9762091c7e	0	0	34	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
4eb3fdfa-886a-4b03-aa27-71229dbc7fdd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c38369d8-9ce2-42d8-b013-90b1643b1851	2	3	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
360c009a-aff0-45f9-973d-145dcf688d21	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c86d4a9a-2c16-4638-9cde-26be87dd9e41	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
0b8026e5-7041-4f02-ba6a-748b91a7dcee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0f4a352b-7bd4-412a-86fa-cb4a475967f3	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
ccbb347a-7395-44d9-b032-8964b2502b26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bbfa2a5e-09a9-46c2-9101-ff77d093ac37	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
1960be97-294e-425c-a254-73d6d28dfe90	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe2d14f1-ff6c-4e49-98cc-b3f73fd7004b	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
798970ac-5163-4a83-9ae9-7c745ae91f27	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b76c7555-78da-4c4b-a4fc-5bf9c61f21af	0	0	2	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
877854d5-5c23-489d-a97d-883bf4266619	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2cc36ace-d655-4576-a4d4-4c56d7445984	0	0	15	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
2dea0d4a-42f2-42b4-9fce-61e1825c5133	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b2fa80f4-3bf5-4f68-ba09-ebb7b3731180	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
372c8c2a-9460-4fa6-ac6f-156151f13c61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9f8d0afb-2189-4562-b8a9-7df32885cb5d	0	0	2	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
41c14078-72f5-4a93-a4a2-d2098acc5fc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0b7c0779-057e-4a0b-8827-07e6df589129	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
5add15cf-fccb-42cd-943a-4fd3d73768e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a90e4380-86b2-46a4-987d-d620c6999145	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
0795bbaa-61da-4994-b78b-fc99a323361b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85e40b2d-d7cc-4b0c-8ba0-030bf043be16	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
f925e9eb-ad49-4274-9bc4-655cc695b853	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5a9c2be3-35ee-419d-860f-659b8371335e	0	0	1	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
d5be88d6-7644-4944-938d-437407871658	39f5eb74-4722-4aaf-a6af-2c6e972e5885	674e5b4a-68b8-4cd3-bbe1-784f92279448	0	0	5	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
94fba069-c5d7-4073-897b-19126eea9b0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aa1d58c1-1040-42e9-bf2c-a6eeef257ab7	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
fadaf538-3ce8-47c1-b44a-b8de0d79390d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7137bb22-2db9-4bf3-be72-59518fa2962e	5	5	82	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
52a1b569-ae70-40c0-a962-3a1ebf2a8a53	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fd449804-3d6b-44e8-bd16-3afbdbcec766	1	0	5	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
a8a2a6ed-00c0-41b3-bb39-f2da08502141	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3bfaa153-5bb7-49ec-9e2e-0e94c2d516c7	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
536a5dcf-31d1-4877-aa8c-c2874ddd2001	39f5eb74-4722-4aaf-a6af-2c6e972e5885	98e6f4a1-4cf7-4081-b9d0-999cd136ed8f	0	0	2	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
2c0ea699-82a6-4337-80b3-dbced8b9b9b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a40ce63b-c791-4c8b-b4af-7c1bb9ad550d	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
1c8d96a7-87e6-4169-a569-7c01ff2de009	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e4b4203-3cc0-4bea-abe0-64bdf02faff7	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
795a8757-6500-4b4f-b106-2099138d803e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	160bef2a-e720-4bc9-92c8-4e63e87c7389	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
bdb1bb85-a182-4537-997e-87a4b06c7683	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dfc5573d-1601-42dc-b13e-7cc2f05cd471	0	0	1	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
9b8f2a79-5290-4dd5-8793-fe50c9a91b66	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b5c01b2-7805-40c6-918e-cb37dc329a1d	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
692d260b-0671-449a-a63e-b9161bb5f660	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd1b1c74-5f8d-4b5a-bcdd-cf55235ec956	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
0ba8196b-ed2a-4277-82bb-5fe69e70018b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e8cdf38-7a0a-4154-9189-be42e70d5151	0	0	1	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
3a841547-8d26-4285-83f2-9300af2a334d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d85e43d6-48b5-435a-8556-49ccd234f417	0	2	0	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
216ee9f8-0bc6-4aec-8c9b-ece951725f3c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	17b79464-dec3-4377-aa77-8776647dfbaa	1	1	2	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
6deba192-8324-4b13-b3f7-574767d5045c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4214b8ac-44f6-4bd3-889a-db4d79211b3f	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
4c4e633e-9f9f-4d44-9b3a-67b498b8da7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0c45afe3-b460-4873-a85c-fc0f5fffbc57	0	0	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
fe85d07c-3d8e-482f-b30b-fc10f263fbb9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	74f5622d-a21d-41b7-9702-55d1d1b04ba2	0	0	3	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
1643d9be-27ae-4a83-b9c4-e6b90f3d068d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	69489d8a-07e8-40e3-8cfd-01ebf1ef6c50	1	0	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
0e34543c-165e-47c8-8a65-cbf32061de74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4416b4dd-65ea-4861-8c9d-7aba4b271cf5	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
f16181e9-c9db-448d-8e56-6a74453b7210	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dd28ec66-2a03-42b8-ab04-90ca40ecc2fe	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
8635e401-952e-461d-8afd-cb4a8103cbd3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d6c052-b20c-450b-a58c-0c300de27b56	1	2	2	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
19fe1fda-26c7-466e-bb1c-5c7ad2966af9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f7a2dcb4-ffda-4fb2-8aa9-bc82857f16bc	0	0	1	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
ab6ca43a-60ae-4d3b-8bcd-6082941350ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a547527b-08e4-44ee-8276-51c72877befa	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
314e2c0d-4d56-4118-aa46-e98034a9312b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0b5dc5ff-adae-488c-91f3-82010b2d32c3	1	1	1	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
4b1ebe58-5f0b-491e-8af2-0747a8b3a40f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	09e5b72c-c28f-4155-baee-710b161d4a24	0	0	0	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
55b09be7-59db-4b80-a6cb-847d4e3bf6e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b2cb751d-219f-430e-9371-bced7eb336d1	0	0	0	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
03ed6ce8-f1a4-419e-a732-6e5ff5725729	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77d7ebfb-fd7a-4a3e-bd5d-f83cf6b8cfc7	0	0	2	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
6da53aab-c6eb-4cd6-9227-be0d48410b61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7db3608f-3323-4680-8545-0e2f3abd17e1	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
3e38e49a-22de-4f29-86ba-caa40b6a0302	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b6adaafb-ed36-438b-9011-e3135021b7a8	2	1	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
8d63aeb2-5a64-4d2d-8b21-af9c0d3b5380	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fb00578e-fbc1-4ca2-8a6b-25e3dec690f5	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
5baf3cda-67ed-4d17-a7bb-cc3c2317658c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	485877ac-5738-4275-966c-8ded3ebcf939	0	1	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
46da1cf9-04ef-4e35-8330-f985ca3d9121	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3e428298-cc14-4f04-9243-6dca85c93993	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
d06ab71e-1218-47bc-b6a7-5e408d16e3c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9298899a-8115-4e5b-a097-8ff5f868cc87	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
9f9443d8-fcea-4f9d-83a9-f14d726499b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6a3e33c1-5bb4-4f3e-8bb8-80ad1ad717ed	0	0	0	2022-06-12 17:59:55	2022-06-12 18:00:37	\N	2022-06-12 18:00:37
4e8f239d-5f83-45cc-83e3-cdac18a6e9e3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8f76f8ae-78e5-48ce-8b1c-c9e36dd103c7	0	0	2	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
2e802153-bd2d-40a4-9c31-6024f16d579a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc9eff9c-34c9-4c5e-85de-9770c1350f7f	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
babbdf96-6758-4db2-aca0-a2bb89538194	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fce993dd-588f-44a9-924b-a13819d8ec50	3	5	80	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
7594cb02-0c20-4564-a8d5-089fac3daece	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d7041842-dde2-4602-a7b0-5f37c406b5a3	0	0	20	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
89056864-fc48-42a2-a604-4a11a7b4df7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	207b29aa-8b1e-4674-b824-fe49c8985d5c	0	1	1	2022-06-09 10:43:05	2022-06-16 14:03:47	\N	2022-06-16 14:03:47
a842c446-3509-4312-ad36-7a9dcd8e2ac3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8470e127-d55d-438e-b8d7-78a9cdc29c26	2	0	3	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
a0a884bf-5105-43e4-b0da-0d7b473a6fac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a428044-9622-4c87-9497-568ac9cbf565	0	0	3	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
a8befe9f-4786-4c81-ab28-4b4b11efc939	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37753380-b27c-4fc8-be6c-be42879ef1c9	2	0	0	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
74256f46-69e4-4dcc-b03d-34e8a1f0b889	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a6a751ea-848e-4541-9d6b-c3c38d27cc23	0	0	1	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
356a6d12-ca98-40bd-81ac-c7467d5283f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	39e34332-975a-4039-8f6a-e4db6f095ce8	0	0	1	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
83635da7-a590-49e3-85af-5c1a345e5fef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	01310d24-c3c1-45a6-ba68-27ae157f000b	0	0	0	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
955bd9fe-8e97-4d5c-bfb3-0573c01fc071	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e334e8cf-a4df-4d91-a666-3647b9fef268	0	0	0	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
c06ed7a2-7a79-4188-91fb-943c1b515a82	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c030b28-6f0d-457e-97e5-6876621aa485	0	0	1	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
0acaa4a5-522a-417e-b218-b18d31297c16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	832d85ca-aaab-4918-9b6d-03a672698c44	0	0	0	2023-01-07 20:13:20	2023-01-07 20:13:20	\N	2023-01-07 20:13:20
72db5f9c-5a47-48dd-9a77-3985f47b04e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3b73adad-ddd5-484c-941f-4a453799f666	0	0	0	2023-01-07 20:13:21	2023-01-07 20:13:21	\N	2023-01-07 20:13:21
f24e4c4a-6154-4c1f-8e55-c902d45608c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5d8572b2-942a-4840-9995-30efa0922b03	1	0	1	2023-01-07 20:13:21	2023-01-07 20:13:21	\N	2023-01-07 20:13:21
d34b6a33-00da-4e5a-bc2f-299ca850c743	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9404c9c4-19cb-4a15-9e7d-76c29eb131ec	0	0	0	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
e66e3318-b159-45f6-a687-3ad24b701e5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	552b2c74-5286-411a-8180-d48fb4dddc52	0	2	1	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
7228c3b0-350a-494a-bb72-6bc01dde87e7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12023e2a-2e5f-40f3-b3a7-233dbd7dc8b3	0	1	14	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
429a3e94-05a8-4a2b-a1ae-07eaeece85e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0602b171-ac03-41a7-97bc-458b3b3f6a7b	0	1	1	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
9bce89f2-92c4-4d1d-9170-0f23ff9c7eed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	be9be5b8-6e65-4812-a729-acf380ce3180	1	0	10	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
4bfa0e3b-f7e5-4e09-b8a9-e1594ead866d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b0b60f50-44b5-472f-850b-13a35cf38a37	3	1	1	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
a3eedf5e-8875-4eff-b6e5-4a4219e516fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e7b05037-4bcb-4535-82c9-01e08ff5cb6b	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
d1b7578d-f76f-471c-b766-08efa55e4cc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34756945-6a3c-4ad2-84bb-b86b3150fa48	1	4	4	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
1c7dc067-449e-4de1-9cbf-735cd72e953a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c9fdc04-cdf1-4add-95bf-3d80af4acc16	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
abcb61e6-9d51-45e0-ab53-909267f594e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3f327f4a-b682-4d70-811a-48af85482f73	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
6884e638-8fc0-45c1-922c-3f30388f1200	39f5eb74-4722-4aaf-a6af-2c6e972e5885	51ff75da-1b41-4b6b-8784-12db967da98a	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
a4388fa8-51ee-42b5-a800-79193f60f780	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f240d34d-717b-4519-ada6-142ed8575231	0	1	21	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
5920cb58-0739-41c0-a4e2-6d49c26ff862	39f5eb74-4722-4aaf-a6af-2c6e972e5885	311b3fde-d8b3-4397-aee3-46d54c2d984a	2	3	3	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
6cc16e4d-aab6-412d-87bc-7464dda9d8b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce9b0f6a-1aec-491e-af84-8d21f9da6b10	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
183f111b-2f50-4ada-9fd0-0a4e6e34fba2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b3b47a6e-b3c6-4b3f-b4ea-a2af04f8cba7	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
a41d9491-a6cc-4f87-8c19-a2e6126cac5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cbc0b360-a22c-4266-897d-ce5f6031a574	1	0	3	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
3be39176-e937-444d-b2b1-8689eb6d0223	39f5eb74-4722-4aaf-a6af-2c6e972e5885	58481cd2-6f2a-40bf-a09b-a21a876684fd	0	2	1	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
4354ffb9-632f-4734-9e3d-491b4d78d8d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c0889567-42a3-4ac3-8060-eb760b079e24	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:01	\N	2022-06-19 11:52:01
768285b9-963f-4c8b-b6f2-8973c39aefc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	844e753a-3616-4c43-ae75-c3b55a68a164	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
311e7a6c-6d10-4a1f-bb01-d303538de481	39f5eb74-4722-4aaf-a6af-2c6e972e5885	71b17c0c-7f51-4d03-819c-5b5fd0880b50	1	0	2	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
6633b79a-3f0d-4065-966e-34855a3d6425	39f5eb74-4722-4aaf-a6af-2c6e972e5885	27f884f4-9362-4a40-975b-e43fbbf4e130	1	1	3	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
b3326b70-d507-4223-9a79-b152459b3a2f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	747451cb-f5e8-475d-98e1-8b1b30aef0a8	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
3222cccc-72e6-4537-aa87-04857c113110	39f5eb74-4722-4aaf-a6af-2c6e972e5885	005e79c5-9bca-4db3-be2b-9d9742932c83	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
96bbe07a-a0e7-41cd-8afa-b8ab95eefb21	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1a23c925-7f24-40b9-af5c-6c6a4bddbc66	0	0	3	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
b9ad591c-c426-4769-8638-2be51549ee84	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1cf092da-9c8f-4493-90de-dcb8da146a5f	0	0	0	2022-06-17 07:23:10	2022-06-17 07:26:18	\N	2022-06-17 07:26:18
405d3fda-d24a-4884-8b54-adcc2fad782b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	442d22a8-263a-41f3-a3d2-a39d9390a58a	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
08ffa581-0c30-462f-9e07-b1e2fb96ab68	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f22d79d3-8a12-4f69-8c34-247ce46a548a	1	3	3	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
57b78b19-8988-433a-b591-b58f4443258c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	31654838-701c-4274-8f7e-679f1a124ec7	0	2	47	2022-06-17 07:23:10	2022-06-17 07:26:18	\N	2022-06-17 07:26:18
1810c668-901e-4cc3-9f15-28555c791058	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8e24a225-e8f9-462e-90b7-dc99431b9824	1	0	16	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
e379d1b6-6fb7-49dc-afbb-147834901e6b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	75f6f869-5f72-4360-8953-26aa085fad39	0	2	4	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
0f5c45d4-6b05-4957-b7b7-86a537741d8b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	396157f6-f56e-4cdf-a50f-1f4af5fd3934	3	5	18	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
2914e44e-dcc6-4e5e-83eb-7d4f2a002583	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e8053c7-7358-452e-9a74-0926709b109b	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
850e7d0b-8e73-4144-9223-c003498c381a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	35a50e2b-1e59-4b17-a523-ebce5be31944	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
fd136671-7807-47f7-b9ac-dfc6becfe487	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8b1bbbf-354c-47b2-a03b-4da27bc93392	2	2	5	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
230b87c9-9695-445c-b694-7b97125dc38d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b2420782-b86c-412b-b868-882aeb8b6024	0	0	4	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
8d064e43-9f1f-4792-8a16-0f7eacf1c830	39f5eb74-4722-4aaf-a6af-2c6e972e5885	de92d9be-769c-4baf-81cf-cfa40b22b44f	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
b2de695d-7423-431e-a8e2-3a46966c1600	39f5eb74-4722-4aaf-a6af-2c6e972e5885	be120bfc-9f35-48bd-9fd3-740252ac02b5	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
8b1bbec3-e4da-4ba6-920b-783658425b2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	64c543f0-3bdb-4984-8b9c-0b848a8ba314	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
7c56e8a9-b0ad-483a-902b-98afb42fb0dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ca9c039c-a385-4820-8990-98e9ad174d67	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
9796519c-7599-410b-8f4a-aae7a04c94c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3e3dafd4-0d17-496a-b1e2-eaa3d7a37aad	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
b2c8321d-7c1e-4dca-98ee-268d1561e689	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef63be5-0b63-4e1a-b75b-6fe562b75d2c	0	0	3	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
c7d52601-208a-46ea-9a1c-67928c72d4e2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	494b784e-289b-4b50-860d-77407fd7af7f	0	4	12	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
5505f126-61fa-4b2b-ac3b-ba4d96998df8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	03931321-5110-4608-bad5-1ffd9f74e6f0	0	2	11	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
38e1a401-0295-4239-b860-586e21bcb31a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8b76536a-bf06-4f2b-84ac-d2c5b8e705b0	1	2	13	2022-06-17 07:23:10	2022-06-17 07:26:18	\N	2022-06-17 07:26:18
ee4f2647-a00d-498c-a99e-b74a68cd093b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8f444be5-6df7-48cf-9cda-734cb3add744	3	0	22	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
828650ee-243a-4d2e-ac8d-67484b9b8918	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8c7123d5-d0a9-4d6f-aa8c-c7bdb376daa1	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:01	\N	2022-06-19 11:52:01
0567bad8-d39a-4cec-ae03-e02d8bad8fa8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	529081fc-18e8-4232-b56f-412b7c32b665	1	0	1	2022-06-17 07:23:10	2022-06-17 07:26:19	\N	2022-06-17 07:26:19
fbb1ad5e-cd58-43b7-b38a-46dba863ccb5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	406a91f6-87fe-4144-8971-89d303a575e6	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
cfc44ef0-671c-4f92-9b90-842ec440c960	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aab90fbd-616b-4706-b24a-4673edcf1109	2	2	3	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
ac63f3e4-a20b-404c-9851-15c1c0255c3e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e5d67e74-0476-405a-afc9-6d9403245bfa	1	0	5	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
d1abfa5a-1617-4d72-aa64-92a20db90086	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e9a69df-72a0-468d-9612-8926cf565f50	0	0	0	2022-06-17 06:18:29	2022-06-17 08:27:47	\N	2022-06-17 08:27:47
e4ff735a-87e4-4055-b99e-57c2c126cdee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b91f11fc-d124-4589-92d0-590251bb2ccd	2	3	5	2022-06-19 10:41:55	2022-06-19 11:52:00	\N	2022-06-19 11:52:00
c8bcfc12-c48b-49eb-b555-81d0862addc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b0767b0-c5f0-44f6-9c5f-2948223c3cbd	0	0	0	2022-06-17 08:20:09	2022-06-17 08:20:09	\N	2022-06-17 08:20:09
c038a8a3-294a-431d-8cb4-3ac178355eb5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	01ca3a51-8af7-4b67-97ee-49b5575ed5bd	2	0	4	2022-12-14 11:31:19	2023-01-10 07:51:04	\N	2023-01-10 07:51:04
86ea2c9f-f8cf-4b13-80c9-2cf7fd7501f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aa509d1d-4d07-4d79-82f9-b50c5cb3646e	1	0	1	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
c1167f68-8240-4574-bfca-6c14020d7242	39f5eb74-4722-4aaf-a6af-2c6e972e5885	745003b4-cf24-4d60-a517-414ddc0deba8	0	2	25	2023-01-11 13:23:50	2023-01-11 13:23:50	\N	2023-01-11 13:23:50
65fe70b5-d9d8-404d-8f6c-158ab4ece0f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6cccc5be-bab5-43f4-87d5-6afc989da0f8	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:01	\N	2022-06-19 11:52:01
6604556b-9157-4d73-a453-211aac1195eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	785eacf9-a154-4633-8ff3-b228e71051cc	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
7369c8fa-5e2c-44f1-8489-b56e681c23b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1dd226c4-f81f-41fb-9940-266e9b41fbd0	\N	\N	\N	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
44a9ffd0-4f47-49f3-8b25-9fd604bfd738	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d8a3a74b-9199-4e4b-bd50-4a2a35d0aa44	\N	\N	14	2019-12-17 16:00:44	2019-12-17 16:00:50	\N	2019-12-17 16:00:50
360cbd12-93f2-4238-9060-c593e15ab0ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fb837793-29f3-43e0-b111-03a417d37db6	0	0	0	2019-12-17 16:10:44	2019-12-17 16:10:44	\N	2019-12-17 16:10:44
9a999851-0ce1-4a13-9efe-47d432b42215	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1a48ff81-25b2-4ff1-8aa5-d334a827fbe6	0	0	0	2020-06-17 20:15:29	2020-06-17 20:16:59	\N	2020-06-17 20:16:59
9e690b35-3a80-48cd-a656-ae1fe90b42b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	714e743d-f585-47a5-a1b2-a43a342d8bf9	0	1	40	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
65c15e35-1e3a-487c-9455-e0f3679d6e91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	55b6dd8a-5fef-446b-b99a-33eb13512214	\N	\N	5	2019-12-11 09:25:41	2019-12-12 07:43:11	\N	2019-12-12 07:43:11
80d97d51-9816-4ea3-8167-175e48c50e99	39f5eb74-4722-4aaf-a6af-2c6e972e5885	53b37163-6a2c-41f5-8e89-a026c32f9de7	0	4	5	2020-04-18 13:16:36	2020-04-18 13:16:36	\N	2020-04-18 13:16:36
473dd951-11fd-474a-9366-402f3b83b8c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c129d5c-69c5-4178-94f2-3cc7cd84ae7d	\N	\N	22	2019-12-19 19:24:01	2019-12-19 19:24:14	\N	2019-12-19 19:24:14
2c7a2208-7663-41e0-b9f7-28a0e4c78449	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec0581bd-ba50-4265-bd52-cc429d972b3d	0	0	1	2020-12-16 16:14:53	2020-12-16 16:14:53	\N	2020-12-16 16:14:53
4d01ee33-9252-43cb-8b15-307c1d86eb2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4799c1df-671f-41e0-a0cd-a5b5102f2460	3	2	36	2021-06-16 10:52:07	2021-06-16 10:53:40	\N	2021-06-16 10:53:40
6c78f27b-5bd1-4f53-8526-1fdf1c7deafc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	30126e6c-db8c-4627-acdf-f3b81fc28b62	1	5	25	2019-12-11 22:04:16	2019-12-19 08:19:22	\N	2019-12-19 08:19:22
9e5af20d-afa1-4c43-8a40-35e22ca0fa2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec9aa008-09be-4e25-a826-20620bcbbb88	\N	\N	1	2019-12-20 07:09:52	2019-12-20 07:10:11	\N	2019-12-20 07:10:11
1b0b9ff6-3125-4195-9641-7ab5b002e997	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c419fff8-5f7b-419a-8993-a4d2fe97f7a2	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:01	\N	2022-06-19 11:52:01
03ee1685-5d1f-4fdd-bb51-56adc4df52e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	172bf722-db9e-42c1-be5b-375eecdd247d	0	0	0	2019-12-19 10:43:07	2019-12-19 10:43:20	\N	2019-12-19 10:43:20
d1c09dc3-65e9-4dcc-a50d-899afffc7928	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fbd7f422-c418-4baa-a449-6be48a428eaa	0	0	0	2022-06-19 10:41:55	2022-06-19 11:52:01	\N	2022-06-19 11:52:01
761243b9-dff4-4bab-9688-dfa72b09e994	39f5eb74-4722-4aaf-a6af-2c6e972e5885	02c4d453-9623-4cd0-938a-f18b12d8620a	0	0	0	2022-04-07 08:25:37	2022-04-07 08:25:37	\N	2022-04-07 08:25:37
1f98cf72-9d3b-440e-87c0-4cfb7ade0c28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4ec953a1-9761-4d30-96f6-ccecb456afca	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
59ddcd6e-2367-490d-8288-ee64d67edbec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b2e0b1d0-b419-4986-a09c-703ba7a0357f	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
ab1b53d2-728c-4783-bf3c-e895bb80847d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	419e9254-2d1e-456e-a2a6-6b8bb76f21ec	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
dbc573ac-16fd-447e-a5be-e2046ef93db4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	642bb575-cc30-479f-bc16-1b869d2bbfac	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
60679f3a-63a7-4844-b0ea-80011a0660b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	330d3c93-b8c1-42a1-b90e-5699a593fc44	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
6d3a7ac5-96cb-4a6e-858a-895e2b823b77	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a266556a-6980-4c3e-b223-6dfce9f13315	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
b5f29535-0fa4-4ec3-acd3-def99dfb7925	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8b412381-8cf6-4c03-ac56-5ad7ab95a84b	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
597568a7-a847-4170-87f1-2dd88802c3b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9fa13caa-8fc1-4d7d-a590-4a3b7a59ef2e	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
e2930ac8-54cf-42f6-a5ba-b58dd4e5d902	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eb569d15-8d04-40e6-bb4e-ea6ef5349b26	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
c2ba7783-419b-4bb0-bcf3-b40adf105dc2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7c1177d4-5e53-41f6-8c26-bda8dbff9a6c	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
4bcdbbd3-991c-486e-9ea9-f427cab6273f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ff3fee62-67f5-4599-812f-df612f432832	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
f4643202-50a8-418e-bdb1-10248592de56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c6f8e325-4737-4dcd-a4fe-4ac3d97a9d0f	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
6c2c7a05-532d-498a-92ca-a9bbe531b215	39f5eb74-4722-4aaf-a6af-2c6e972e5885	223b480b-3e00-463f-ab02-2596f407036e	0	0	0	2023-01-11 19:44:15	2023-01-11 19:44:15	\N	2023-01-11 19:44:15
54a00fb0-bc7f-4163-9141-7c423c7a43da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d47d3026-f14a-4184-8efb-1f2766857cae	0	0	1	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
06f92f97-18df-4b6c-852b-284933e1737d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6541fbb0-8a41-431c-86df-86e394a59703	0	0	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
a71309aa-57a1-4f4a-be44-6bd570175ddf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6ec799ca-0d85-4ef5-9a51-e8cee73c7cbe	1	2	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
4cfb8ef1-fea8-4e0b-8f60-55f7ce0986cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	177f9999-cbcb-4d16-8dfb-f13c9275191b	0	3	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
b7296cff-c3e8-40fb-af47-e929a2c7ab29	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f632994a-f0f6-442b-bc07-cb6debf112ff	1	3	6	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
108dcaed-763f-4b66-b663-1b9e6650cc2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	df89fefc-69d5-4c88-bf62-c4c83c13a331	3	0	23	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
ce4aaa89-8325-440c-ac5b-9e54048fe4c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ea101f87-6fa9-425c-9256-206ad5253d40	0	0	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
ab111b0b-63cc-4cff-98a1-5e7d7e3dfef0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	af8d5f45-ff7f-4a77-8111-cb9be2798a9a	0	0	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
ef66afe2-508b-431d-92c0-b0451a108e4f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9e204e5d-432e-4486-8dca-49899646c07d	1	1	14	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
e778f4bd-2627-40f2-a449-72987e5ff48d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f158cb18-af47-46c3-a180-e3f2d18eade1	0	1	10	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
b718ee6d-f953-4ba0-a80b-3a0c748e61f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	534a1cf4-c57a-4235-8d7b-e126877d306a	2	0	2	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
06d9fe87-77c0-46d8-8584-e0a7a730bdaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	438cf0a0-1b7c-4057-8692-8566bda05858	0	0	1	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
3225fd7f-6641-47ef-b09e-5fa966861922	39f5eb74-4722-4aaf-a6af-2c6e972e5885	89c5cb92-06fd-435d-9ffb-6f703ae1bfe1	0	4	48	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
f2303a2d-5806-4599-b6c4-d1f5d15e7aa6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c546f8c8-005a-4dd5-a15b-8fce68a75abb	2	2	6	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
a7d31c92-9508-4df9-a146-47b9770c0b3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8d75985c-fef8-4f23-b8b3-49e0b6e3ba6c	1	4	14	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
ca8d5702-164c-49e6-a6d3-e2c0364222b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8a4eaec0-143d-4abe-9ee2-d4b7bfb4420f	2	3	5	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
e203f3c3-9fb0-4a1c-8e48-59f14bab7f5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8712ad61-d2b1-4ef9-b491-bc8045c00410	0	4	42	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
472f3cf4-8beb-4849-a393-6cbe9cc3b3e2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	79932047-80eb-4dad-aa87-9c6b9e8a9beb	1	3	0	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
16770646-44f2-4f9a-ac79-ec6d8cfca896	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4d6000b7-18a9-4bd0-b34b-b9054770daf8	3	0	1	2023-01-11 20:38:25	2023-01-11 20:38:25	\N	2023-01-11 20:38:25
e63edebd-3848-4a66-b046-c51820f5bebc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1634074d-c41e-46db-97bc-70d0216b2604	0	0	1	2023-01-12 07:34:15	2023-01-12 07:34:15	\N	2023-01-12 07:34:15
375a278b-58df-48df-b747-2df1fddd5c89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1375aff-6437-4985-a869-555c5cf2fafd	0	0	3	2023-01-12 07:34:15	2023-01-12 07:34:15	\N	2023-01-12 07:34:15
d5f7ac73-5733-4bee-8553-153f9dbbccde	39f5eb74-4722-4aaf-a6af-2c6e972e5885	52b63f30-799a-430f-a3d7-1580b41b9503	0	3	2	2023-01-12 07:34:15	2023-01-12 07:34:15	\N	2023-01-12 07:34:15
c0da955f-7794-42db-a06a-0e28209fd072	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fffcb05f-baa4-4999-a8ec-8298e7425bd2	0	0	2	2023-01-12 07:34:15	2023-01-12 07:34:15	\N	2023-01-12 07:34:15
3c43df52-67ab-4ef0-b42c-496f4d5ed80b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e56eb682-9fd5-42a4-bae5-ed2850574f22	0	0	1	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
74fc12e2-cb39-4e73-90f7-47526259fa1f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	46048ab5-9b85-4764-9e87-65ce497d03d2	0	0	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
23021802-efb3-4941-9665-def59c1f75be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a595eaad-995a-413a-8ab0-746de49a62c0	0	0	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
ca2783dd-b006-4b1a-8b67-ca00adc1d880	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0a7145e2-8e42-4958-967a-666e6081c612	0	0	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
f4427b30-cea1-40fb-a9fa-46d2b4a31b58	39f5eb74-4722-4aaf-a6af-2c6e972e5885	efb5792f-0790-4a52-bf2c-30a0c4a7e3a8	0	0	0	2023-01-12 10:18:15	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
61e53764-7f6e-466a-8c53-e189ef4e9a33	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1edf6aa6-f2c7-4a4a-a573-b479d4c0675b	0	4	10	2023-01-12 10:18:15	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
61547a01-7a25-4d4d-8fd9-56e4e9a8fedb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e053fec6-57a9-41c5-8dc4-3f7416996ede	0	0	9	2023-01-12 10:18:15	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
9abcadf2-8160-4806-bf69-87a42a02fc08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e88e82ba-6fc1-4634-93a9-c411a7c77d76	9	2	0	2023-01-13 14:11:19	2023-01-16 11:11:50	\N	2023-01-16 11:11:50
50a3e9a8-056f-48a2-9739-1ba68c6b1bbb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2d9cce28-3181-4f0f-9986-325a396454b9	3	1	0	2023-01-13 14:11:19	2023-01-16 11:11:50	\N	2023-01-16 11:11:50
30098279-0918-4b9e-aee4-fff363d77270	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37e29a1a-df99-40aa-ba43-8782f68e0eec	7	0	0	2023-01-13 14:11:19	2023-01-16 11:11:50	\N	2023-01-16 11:11:50
ef066dd6-4379-4f3a-b208-6b8e484984a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34065438-900b-4690-9a82-7fd4000b0a10	3	0	0	2023-01-13 14:11:19	2023-01-16 11:11:50	\N	2023-01-16 11:11:50
0dd30be8-8b46-45fd-97c7-e72c31d6a3a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	65b51730-cf4c-4621-a7bb-69844eb0d25f	1	3	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
ecb4e338-bffe-4c6e-acea-dc11a170caf3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8c1d77b-858e-4ccd-a206-89dcdc718347	2	2	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
10ba8a29-f91a-49be-ab9f-e1dd420a66d2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f19e00d3-5957-41f6-9601-64ffc7177ac8	1	6	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
746ad92d-909c-4b9f-99d7-9de76a79b566	39f5eb74-4722-4aaf-a6af-2c6e972e5885	369bf026-cadc-4179-9189-6ef5603aed34	2	0	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
60b8fb29-11ed-4a0f-854f-77a2f27cc439	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cd89f14a-86de-4eda-99ec-605f5c748836	1	0	13	2023-01-12 10:18:15	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
9bd60a71-d21f-4fd7-9fe5-f48cf7df1d70	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3167b032-149e-401c-acea-562caccfe870	0	1	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
cc7fd706-9c62-4bdc-b9d8-f901218404a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	46761e53-8456-4047-a99f-5c135ef3290c	0	0	11	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
6e571901-a86e-486d-9a66-9030a152898f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eb4331bd-96e1-4952-89c4-19c14be74bc7	0	1	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
84bde860-acad-4305-94d8-95d1d4950a80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0ad71217-aafa-47b7-abdb-8d43965c5b85	0	0	2	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
63f58cd6-391a-499a-a9d4-b739d3290b2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ba126572-b716-4e6e-a619-7ae7f0d9e6f2	0	0	0	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
19027a63-e061-46c3-866f-c622ae3e7a3b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	617e2b65-1c86-4031-bac0-e12663e3cf7c	0	0	5	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
6aa80b8d-ad30-40e9-9001-ca498dcd5d6e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	39633cee-231a-4305-afa6-056f0e9dc796	0	0	11	2023-01-12 10:18:16	2023-01-12 11:21:51	\N	2023-01-12 11:21:51
a8e6a206-ce24-40c7-a091-8dbf43f24556	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d4ca1870-6a58-4793-bf62-e7f7ceaaa48a	0	0	18	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
56f999fb-c76e-4db4-b1bb-e913b87d6417	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f7fca9b1-3fd3-4418-b5c8-975e1eae163f	1	5	24	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
796523a0-171c-4e04-8ec9-ad7f96a4d452	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8556547f-ffda-4f25-88ca-4cdc9737b180	2	0	2	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
5d9373b8-49b3-49f7-aaf9-9a094c7c7e69	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6365d031-ba95-4bd8-a878-b831e5164eeb	0	0	0	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
9bfaa19b-19ff-4411-af7e-e0f0620d9e86	39f5eb74-4722-4aaf-a6af-2c6e972e5885	63ef8577-c88e-4e93-b0cb-ae1cf5aaeead	0	0	0	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
1306e2c7-0190-414a-85f0-2dc3588c71f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bdb8e92b-2aa2-495f-8b2a-af809eefc996	0	2	0	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
f68adefa-37df-4738-81cb-48034d23bfb5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b28c8bfa-b6aa-4492-9918-24afb12fadd5	0	0	18	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
7b09cfe0-639f-427b-8713-8cd4e2b674a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	869aa4c9-a49e-443e-9651-5dc78daa7596	0	0	0	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
677bfd4d-2f06-429e-8fa5-ba05c8817122	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c0607767-2788-4dc3-954d-1738e7cb94e8	0	1	0	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
fa03f0eb-f0c1-48d3-af8f-34910a4ed7a5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3b85c640-0251-4b34-ae59-4b997daf6354	2	1	26	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
1c20dd9d-9519-4c59-a3ff-16fa2d1e1b79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0d8aa366-d1a3-4c02-9856-f3fd9bcd2a5a	0	1	23	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
4f841fd0-e338-4a39-9916-b941aa4d1db8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33fcb1e9-39f7-4baa-bbe6-556ecc1ff536	1	2	21	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
ef631596-1c7a-4237-bbd2-6b3be21ced67	39f5eb74-4722-4aaf-a6af-2c6e972e5885	53cf5186-95ab-488c-bd47-6da98cbf342b	0	0	1	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
fdf38490-ff36-4e7b-831c-db04c8cfe55d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8518abcd-909b-4ecd-a022-c815597a4924	2	0	3	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
ed44ece6-0e2b-4c7f-b53d-18666f4d3339	39f5eb74-4722-4aaf-a6af-2c6e972e5885	88f781f2-8832-4232-a87a-234bd770aee4	0	1	26	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
ef19c131-a564-410d-9923-07775609136e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2dae4b04-de03-45c3-b1d7-8376d65886b2	0	0	49	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
ca0bfbb9-30bb-41e0-a274-83656052c4da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24e61328-e776-4c05-aff6-80c77b2bda2c	0	0	24	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
e8c5fe05-8c06-412d-ba24-4a8942238cf9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	479c567e-d8ad-4ac5-9b85-b30207508fef	0	0	6	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
56937ab3-2e7d-4e9d-b3a0-3297e64ce00a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1840b4f3-7b46-4939-a438-0dcd47b05306	1	3	12	2023-01-12 16:28:11	2023-01-12 16:28:11	\N	2023-01-12 16:28:11
887ace9e-9307-434d-b675-573a6bfbe81a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3f298a13-0ab5-4572-82f7-0fa1b2691f07	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
ce7b6a63-c2af-4f75-af50-69f3c0a4cf83	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aad1f448-4080-4067-b4b6-ccb36d8b2fb3	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
136024f0-2d3b-457c-95af-32918e16db31	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85094bdd-e4fc-4284-9342-9495446502e3	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
fb594334-2d22-4cc5-8957-268968f11dda	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ee7c13e7-8f5d-4389-96f4-435ab5ad9dae	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
e457dfbd-4423-4570-ac5b-ad7c5f642f62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	82db6ea1-8882-47f9-8dad-8ba8c694db86	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
1b73d5c8-99ef-4a87-a18d-7e89decfe554	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f2d6bcda-bc2d-411c-b599-6a79381c5214	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
a1a6424e-c054-4656-9c6b-8a3756eea655	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a7772058-1bcc-42d6-a058-98fc4c206856	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
607c0a3e-2a55-4b27-a49e-9ed976da54ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	952eced5-4e55-4c91-9e72-998e5fe8b1a4	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
fa5a1f83-d8e6-49b8-8190-b519e2a43cb7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e78fb3db-53d0-4e71-be84-1ebbc449cdcf	0	0	3	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
4d242656-5e84-4423-954e-400bd05241b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	72e82ec3-5579-4e99-bbb7-a636ce28f6f1	0	0	3	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
b9be5615-a8f9-47a3-b097-6b6e8cec7102	39f5eb74-4722-4aaf-a6af-2c6e972e5885	28746849-5ae3-4eee-88ee-c66b78162f12	1	1	21	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
c9064365-abf6-4ad5-ac3b-5ca61514b21d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	227beda3-7639-435d-b9e2-8b924ff8fbe3	0	1	5	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
1d391afa-594e-41fb-964c-94250b622939	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e064cfd4-b0f2-41ff-95a7-4e006606d93f	0	3	1	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
c94996d4-6693-4201-b5c8-5e42cb39da07	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2429f5c6-b2bc-4628-b00c-0694044d79fd	1	6	2	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
c46e5994-59c7-4126-9839-db03ad34aacc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19c251f4-0d10-4eb1-8b7e-c74654bc97c8	1	0	4	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
e6c2a062-4350-4f2e-b7d0-0d8909c03c42	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8ce4b6f2-1f65-4d2f-8696-5dd3d45c3fac	0	1	3	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
0c9b4c53-e0c7-4581-aa1a-48093fe3a652	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6fd91ef6-32f2-42dd-893f-6a56a098fec7	0	5	0	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
d0c67875-bf48-4052-a466-47114515f0a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f19a7cef-c3b0-41e1-8e68-f4d215ab2493	0	2	4	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
5303f653-7f21-41e3-bf2b-289c1b388d1a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cba5dc56-c8e7-4347-9ee5-2dd16a223201	2	4	11	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
96a85cd8-abf1-4079-b568-d543664bc33c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	97eaef97-2290-43e0-a00a-06bfee86e858	0	3	2	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
18248d3e-2c2c-45de-bae4-48327c5b3435	39f5eb74-4722-4aaf-a6af-2c6e972e5885	67ed0dd2-3052-41d1-a1ca-82a80e255362	3	3	3	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
e2385376-5cd0-40e8-a5e1-d0bafada66a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d5886e27-b17b-4f69-ae8f-d195c6753b0e	0	1	1	2023-05-04 13:57:20	2023-05-04 13:57:20	\N	2023-05-04 13:57:20
b2c45e9e-65d4-4ea1-b32d-79134d3127d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f6093cd9-5e50-42ae-ad3f-adc88339c19f	0	1	4	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
3d505cd3-24b8-4ba5-a9cb-bfe351b77aca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	160fff65-5686-4414-99c6-d0f50e4a09ad	0	1	1	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
7ec750c3-9247-4d80-bb21-a59a9e5f9a38	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8bfaa9a7-024b-413c-9aee-b1ad436612ee	0	0	1	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
4ffdcb4e-630b-4ee0-a4b0-a736722f66ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5cf5ca1f-29ca-4780-80fe-93c8f97e887b	0	0	2	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
8d1acaa2-0226-46fb-b6b1-823b43f43e7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	302f9937-91fd-4cd4-bc6d-3246de32bf62	0	0	4	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
50a358ea-24fd-4c27-9e89-1eeeb39fe8a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	45bfd013-b8ca-447f-a756-c1bbfe4783fe	0	0	2	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
bdc95234-5e0c-41fe-b182-c5f2b9f65a00	39f5eb74-4722-4aaf-a6af-2c6e972e5885	158bec49-30f2-40a4-9559-1d83b5279ed3	4	2	2	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
5d711294-c101-496b-9977-dcdc6aa3584b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7eed2d76-ebcc-49ea-a54f-7c2f3a1dbb06	4	0	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
d9d60b5a-a446-436c-b26d-6427e81507ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0eb90868-fa3d-4405-8dbc-30222c7e1319	7	1	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
419052c1-947b-4781-9b84-7b7779f87b65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8c8fec38-b6b4-4fae-a437-ddf5a67174fe	2	1	0	2023-01-13 14:11:19	2023-01-16 11:11:51	\N	2023-01-16 11:11:51
d2c8f771-264b-4288-b921-d8ffb8f5479c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4414f5ae-c1f5-479f-954e-503f4ec66dd2	0	0	5	2023-04-27 09:21:19	2023-04-27 09:21:19	\N	2023-04-27 09:21:19
dbc738a3-07bf-4025-92bb-f3f0a7c322f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9ea111fe-8d20-4025-9b8e-bdcc4b7d0930	0	0	6	2023-04-27 09:21:19	2023-04-27 09:21:19	\N	2023-04-27 09:21:19
1393128a-add7-4b9c-a10f-88e89148bce6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	80d9b4c3-269e-4364-8d3c-78d602f39465	0	0	4	2023-04-27 09:21:19	2023-04-27 09:21:19	\N	2023-04-27 09:21:19
1cc089b4-509f-482b-a2cf-ec3fb13028e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b660bca8-177f-4eed-8e16-d155b0dac82e	5	0	3	2023-04-27 09:21:19	2023-04-27 09:21:19	\N	2023-04-27 09:21:19
04b51f7a-04dc-45d6-85f7-0526cdc3d622	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eefc87c9-1e1b-4f51-8ea3-b586d5fd81c0	0	0	3	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
be5ad6f1-4e09-47c6-a1e4-1fc9d3f83751	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d6e7894e-bac9-4040-8afb-2bb8c2360dc0	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
c54b54e9-d8ca-43ed-92d8-8d2a03291eca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d4f12650-1d26-4283-8cbe-535f9a163b1e	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
81f185f1-53ee-42d4-9e31-469c04eaf45d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e983984d-3d5c-4e04-aa69-3c02478b0973	0	0	3	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
212f293c-2c57-4211-baf7-af946b952fc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	607dd6f2-26e9-40a5-a91a-51e4237aa8c7	0	0	0	2023-05-04 13:34:26	2023-05-04 13:36:17	\N	2023-05-04 13:36:17
7365bcac-bc69-43c7-849e-49906ae13794	39f5eb74-4722-4aaf-a6af-2c6e972e5885	acdc9e7b-32a8-4ff0-bdf5-c72a10155834	0	0	1	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
fa452e1a-06f2-4745-9427-6b1b4c4dd281	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e3d5e54-b781-411a-a37b-bfc26112186f	0	0	4	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
a4770013-a586-41f1-b498-ab1befe40fb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6ab0ce25-9b02-4f7b-ae76-666c21d18341	0	0	4	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
0e2e15c2-a79d-4f38-8452-dc511b832cda	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0030ee27-cfbd-445c-99a2-1eab37cd703d	0	0	0	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
79b79339-cabe-4cb3-a8f4-f4df865227de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f26856c1-eb2d-4ad9-8f1e-8f9a5f9e52a2	0	0	1	2023-06-14 22:46:30	2023-06-14 22:46:30	\N	2023-06-14 22:46:30
d590188f-0918-4aac-84f8-977094f6edbb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	31723438-4678-464e-ba0d-2f6c91fb5a1d	2	4	25	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
1f930617-42a6-46a4-8790-42fd13ac75ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8276cac1-c661-4935-97a0-3aa4fd70a57b	3	0	24	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
004f25ff-7ea5-49d1-970e-72158b8c2f19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78766ea7-87e1-4e4c-8653-62ba5dbe85c2	0	0	12	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
13219cee-dd3d-4119-876f-0b5322ad207a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	54c0c1b2-d622-4c33-9577-7236702ed389	2	1	14	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
70c22def-d571-4e04-8aa9-e31c4b00010e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e445bcad-ead6-42f8-b3c6-8fb448194d80	0	0	8	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
f143da78-08b1-4655-9a9e-19e8dd2fc472	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cd0e283-5578-4430-8cc1-ef975322b86f	2	1	18	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
ca77f9fc-33c6-4b2e-b20a-ef10bb807789	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6035f294-0755-4c50-bb87-3d709dd2a328	2	3	24	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
174cb667-61a6-411b-a73b-6768359cd1e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce6673cf-2030-4b41-b936-9ac8b6fb5e46	0	0	25	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
16b9ca2b-97c0-4c4b-b200-15205e5e8c60	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f349a56a-fb24-4603-81e1-a73e205f9a49	1	1	21	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
a2811568-ab13-4232-827b-2deaa6fa0873	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ecde80f-fee9-45fa-899a-c0c3bc7b8d96	4	0	12	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
b0b4b767-440a-4cea-a20c-c0f6097858ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a6b110f8-8267-4ca2-80c0-b3a3985ec75d	1	0	11	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
0bdf8770-010f-480b-9e69-c5a1f4363540	39f5eb74-4722-4aaf-a6af-2c6e972e5885	df8caa2b-0de9-4a80-883d-011d945c412d	4	2	28	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
f65dda9a-61ff-43e3-9414-903b0d8bbcb7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2f0abed1-20b6-4d62-8891-4853e1fec2dc	0	0	13	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
ad3c3c87-1f93-4ccf-bbd7-05edcab954a7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ff74f02b-5076-40b5-b3a2-8c660eb11093	0	0	32	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
9efda752-4d31-46b4-ab10-201fbb7bcec7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12633227-6b19-4c6c-9db1-fb275053b5eb	2	1	21	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
2214741f-4146-4763-b2b0-63058a371ad3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eee8c62b-3808-4b30-9720-dccb8335c75d	1	1	17	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
f60529cf-56e2-49de-a27b-838e75fa91b1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bdb8f02e-a173-44f6-8446-084472c0415a	3	3	36	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
d54e24ce-a066-42e6-b640-e168a26796dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9d9b4ee5-9025-4532-a1a0-0a503a6e739c	1	0	23	2023-06-16 08:04:04	2023-06-16 08:04:22	\N	2023-06-16 08:04:22
9c5e68f6-85c9-4181-85c3-6e9e62bf51c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	826345a5-b1d8-4fff-8e73-0676d4ecf2d1	1	0	5	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
d014a33d-19ac-4d69-bf66-fd26c6086b0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9dd4dfaf-14ec-417e-adc7-f033e0742fc2	1	0	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
643f382c-c919-4417-9465-80433596a20a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	488fdb06-2e3f-4119-a51d-a367d909ea52	3	0	7	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
f0299882-a971-4e08-b2f2-18d0ec4f8e7e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d880f96c-6719-4fbb-ad3a-a6546a510f49	0	1	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
570d4afd-dec1-425f-844c-2f904124191d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	288da187-ad92-4e0f-bc89-32f8922eaf06	1	0	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
3a05ec0f-0fe1-4d8f-bef9-835df09ad504	39f5eb74-4722-4aaf-a6af-2c6e972e5885	421ab3f5-8b77-4133-b86d-ee68aaa9edcc	0	0	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
07283077-d61f-4907-87cb-234d509fb86e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12625b52-7bfb-487d-8cbb-897410e4179a	2	0	3	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
c14ec6dc-f82f-4685-a85e-86924ece6c55	39f5eb74-4722-4aaf-a6af-2c6e972e5885	acae61d9-9697-4f8a-b026-d4655e596610	5	0	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
6d724e27-e0f3-4005-a4af-046bf6b18b19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	df95e5b4-c761-4d15-ac42-3849a4613c98	2	0	3	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
7de65dcf-d3ad-40a0-9133-13950f1f283f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	53699f03-e8ed-4322-bfb1-811001436b70	5	0	5	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
6c170379-afae-4f3e-a749-4070fa4134a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	94567c79-c8c7-4caf-8fb7-a080ffb6bb5e	1	0	2	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
cca44adb-97c5-46e3-b1c3-3cbdf6969987	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47fd761b-6bdc-4044-b625-52282eb29656	1	0	1	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
233e824b-d570-4b2f-a555-fda735a5d5f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	164df781-30cb-4309-a8a3-3002cda445fc	1	0	2	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
03b5d4ed-048f-46f1-997e-a6570e95d976	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cda39757-e153-40be-8207-9d8b9e4e462b	1	0	2	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
0863a9f1-1f58-49b5-8b0b-73449ac76537	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1b640fa9-adb5-4957-b837-a4df764b4514	0	0	2	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
68b8a69e-09a5-4e92-93e0-a9a6348bdf43	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb9986c6-75af-41ee-bfd8-e9514cfa99a4	0	0	0	2023-06-17 11:26:37	2023-06-17 11:35:56	\N	2023-06-17 11:35:56
337c8ca3-4459-424e-8a3b-37942603dbca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85ee6930-1353-4602-a02a-50e12139915e	0	6	3	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
a0406a4e-2e6b-4e9f-ac81-6ace14d81076	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fa5a1802-5963-499b-b589-40016be3049d	1	4	3	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
88a3443d-4a44-4b91-bd3e-5014660713e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34528e36-910e-4d56-81cd-bbc3808042b8	0	0	3	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
f35ce33f-1adf-4981-9900-5c16d93eafd6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	07cb21da-e231-4491-b38b-43b05d542145	0	0	0	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
05cbe7da-3de7-4dd4-9019-0cb9dcf54d15	39f5eb74-4722-4aaf-a6af-2c6e972e5885	45c5b3e3-a994-4273-9a95-cc9266a1ec4b	0	0	13	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
c47d0fea-de4f-439a-9224-7acc23fb733d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e2b3004-ebcc-41a9-8070-0789c40d256d	0	0	0	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
b198265e-e460-464c-844e-459d3d5bde5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	730dc7db-54ab-4068-be95-5076e9dfb9cb	0	0	0	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
6eea743e-97f6-439d-a49a-fc865af41947	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b252ba82-8127-43f2-977e-a8ef1a30c169	0	0	0	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
3e19bf42-e0c9-4747-903e-27f089dc6c6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	98c524cb-d7ce-4413-82c6-22cb888d45fc	1	7	10	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
60282564-8fd0-46f4-9240-f347acb2bca5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	121f5a9e-a3c4-4411-a068-9a1c32f48544	0	0	0	2023-12-15 10:05:44	2023-12-15 10:05:44	\N	2023-12-15 10:05:44
5bda9496-b6a7-4b66-9cea-00def84275e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	febe6a77-80e1-4d83-b5be-04f844f97120	4	1	4	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
8649c7b1-cceb-494b-9dba-89fe3df94f10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ed42238b-f71e-42bb-be77-d0ec9e69f75b	0	4	0	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
d912b73a-541d-4ca0-9532-e6da4d9f7a2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9c9207f3-55e2-4e59-82bb-af7a6b37c911	2	2	0	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
080e0d68-e6be-454e-9a64-b8d0687aee03	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fda0df58-5104-4817-a7ce-752d6d884904	3	1	4	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
8f7e226c-79ee-4886-ab08-74f29cba1361	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4907cd60-4fe6-43fb-a1b4-fd5f9cc8e2ae	0	1	3	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
52427632-786d-48da-9b04-6e8f79dbc14c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e497c017-84ce-4dab-8495-bb5c6aeab564	3	7	4	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
23773a18-41fa-4687-b620-a0db8369d25d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05b0908f-464d-40ed-a92e-021f9d6a56b4	5	3	11	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
2406fbc7-3a16-4bcd-98f2-3d43992e0371	39f5eb74-4722-4aaf-a6af-2c6e972e5885	101507eb-172a-4d70-a84f-51fbb89fab1e	1	6	5	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
8d56df40-71db-448d-af6a-50d807b3eba6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	422061b2-064b-4e7e-8022-fa66bcae4154	4	1	7	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
1749f37b-2269-4c3a-b3ef-e29a1b3ce36e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9e4e829b-2195-4bba-993e-4c1911a55417	4	2	0	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
fd44fd2c-eddc-450a-86f5-2f028a6a75d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e52617bf-3760-459c-a704-1ea8c4974775	0	0	0	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
bf306403-a99d-4499-ae92-d3c136ead372	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26b21597-327c-4192-b5d9-d3d160c9a4fd	1	5	3	2024-01-09 08:39:55	2024-01-09 08:39:55	\N	2024-01-09 08:39:55
348bdfbb-43e4-4e6a-b3b2-aa2ffe2be5ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5f934a02-315d-408d-bdab-90a4eeb56901	0	0	0	2024-01-11 08:03:31	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
5e3c07b2-b032-4fa9-8ec2-630f04523bde	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8971dbcc-ff27-4b32-bf2c-b7ecf1dd50c5	0	3	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
02dd58a8-ed51-4dc8-a27c-aa395a270802	39f5eb74-4722-4aaf-a6af-2c6e972e5885	66275238-d149-4672-9368-06027cfab941	1	2	1	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
dbadfea6-71e6-4c23-b882-c7024ee9ddcb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fd3b9ca2-0819-48b9-b561-ab54c877add6	0	1	1	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
0788695c-38cc-466f-a74b-59efe3393bdc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2d364171-8b21-4182-a201-a277ba58168e	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
c9073024-9c24-4feb-a557-d72f565c677c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e55dc9e-0d89-4a88-9a61-082a89b42661	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
b70676af-0e37-4b47-8e07-66b78f5598c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8b3fc16e-28ab-4cb7-ad1a-b8f765d9bcd4	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
e78f66cd-a0ca-4fcc-b110-c81c60795dc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1227f9d-b15d-40a5-a318-3747d4ac4068	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
53cfb08c-9d48-4e86-aa01-384d3d902d66	39f5eb74-4722-4aaf-a6af-2c6e972e5885	00f30eee-60f6-46b0-8cfb-cc20195b068e	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
501c29e1-a814-4c51-8444-14d3339e1ca3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fbfb9d5e-2343-4bf3-90e8-4f0b422d01cd	0	0	0	2024-01-11 08:09:52	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
be7ac003-21bf-4e5e-bb9b-8e718064f08f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	083cf564-c3ee-43d7-b124-aaa9e48d16af	3	0	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
bfddb24c-ee5c-49db-b8f9-f17e0cc730a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b5ecded5-192d-4817-8a0f-b46ec7efa98b	1	1	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
b3f7df8a-20c8-4778-9bbe-af2064d00fb0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	25f45dce-046e-4962-bab9-7da17734c5d3	0	3	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
9f778e5c-04fd-4347-b459-1a6fb0c9e3bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9a7dc621-8f82-4eee-a1ef-cce00ba5ad2f	0	2	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
c4f4de86-26d7-441f-9a21-fd4293ffbdcd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c6e3030d-956f-4158-99fc-720e8914685d	2	0	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
7b5974b9-4fed-44c0-abff-940ae7b22698	39f5eb74-4722-4aaf-a6af-2c6e972e5885	488c48e8-2536-450b-900c-05972ca2e6e3	0	0	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
8018a496-b661-490f-900b-10cdbffd97b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f85b326f-90ae-42ff-be24-b0bbba7c3692	1	1	0	2024-01-11 08:09:53	2024-01-11 08:10:21	\N	2024-01-11 08:10:21
571eaeb8-83d3-4ff7-bbea-58c593592e62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5279d0a2-4ef6-4463-b503-d0e80bf3393e	0	0	1	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
2b229066-0b4f-4e97-877d-e447a29f6f28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0708dcf0-be50-4a60-90a5-919a60ec9a56	0	0	0	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
4bcb1924-8cc1-4048-aec3-f60d79895272	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e011b73e-ac5d-40e1-af40-82a7a828e88d	1	0	3	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
4c204416-26ed-46a1-84bc-8bed4f89ea3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1273b8f7-a4e2-455c-b0a5-6e586b4076f1	0	0	1	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
42f580cf-f3e6-472e-a72d-15f586dfd0b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8f91be44-986a-42cf-9536-7ad553f5c78f	2	0	17	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
19d5c6ff-bae4-4383-8535-0d96fe0bf80f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	610f2464-197d-4e8c-a6c7-e525a6564579	2	0	1	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
cac6b248-50b4-4dda-8448-388ce65cb250	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e5a5e4d-8845-4e03-9ad0-e08616152701	6	0	19	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
22195102-8d85-4701-a642-26ea90e81eaa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5f4fef0e-8234-485a-be02-7fcfa621652b	1	0	15	2024-01-11 08:21:19	2024-01-11 08:25:47	\N	2024-01-11 08:25:47
4af257e7-f0fb-43a1-8f5d-e61ced620823	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2a2b8542-d609-4ed3-aab6-b15137ddf5b8	0	12	1	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
a0c29d71-b597-4fcc-a308-dccd9888ebe2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0a0701e1-84f5-4f16-826c-62eecd9110b4	0	0	4	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
0fab2d1e-4533-4d4d-a6ab-106b4c005754	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a85de84a-0454-4a60-9182-134c25c44eba	1	1	3	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
4b7b9009-8108-4362-8f8a-68a578156db1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4ea813ea-6604-48b0-bf01-5fa55c9f2b8b	0	7	4	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
6ec07aca-c74a-47a9-92cd-c81f702bc0a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f3b7919c-be45-48a5-bf12-0bff5e901692	0	0	0	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
17cf4bd8-ed58-4a02-bc98-3a93adf20ae7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6eba6869-ad38-4794-89cc-d51bb209ee7e	0	0	0	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
4b71933a-ba48-4512-8f08-7b1c6bec14fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26f77946-b224-45da-92f2-7e8ad0e1d1e1	0	0	0	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
e07d8c85-7450-44cd-b6ee-6e29b7ec8511	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6fe35a70-c37b-4d3e-b796-cc40be61f102	0	0	0	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
bae7c999-14a0-4dc3-84cd-cb75b6bcb8da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	580538b3-236f-4cd6-9c55-2104b8f8c4ae	0	0	0	2024-01-12 06:08:36	2024-01-12 06:08:36	\N	2024-01-12 06:08:36
c214c6ea-db98-4eca-96b3-f7895fab38a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	029ba572-69a7-481f-954c-b7a8fec19f92	0	0	0	2024-01-13 16:46:41	2024-01-13 16:46:41	\N	2024-01-13 16:46:41
78eddfd9-68b2-41fb-ad05-a6f8c7e0ab28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c871be4f-7f0b-410c-bd02-e75b85036ac0	0	0	0	2024-01-13 16:46:41	2024-01-13 16:46:41	\N	2024-01-13 16:46:41
8ecb4c35-9340-4682-b7ee-806e65812d30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	716c8b78-d17b-42af-9254-2d5d89271182	0	0	0	2024-01-13 16:46:41	2024-01-13 16:46:41	\N	2024-01-13 16:46:41
48c604ac-7763-46f0-b6a8-d53bde9fc83a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d2aa8e59-fa11-47cb-bb4f-40165179509b	0	0	0	2024-01-13 16:46:41	2024-01-13 16:46:41	\N	2024-01-13 16:46:41
7d0d899d-5016-48a1-9017-5def851c91ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	61481835-26bc-413a-a003-8b3810995830	4	3	4	2024-01-13 16:46:41	2024-01-13 16:46:41	\N	2024-01-13 16:46:41
26543265-c20d-4472-9307-cc25bf68618b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ab2bbad8-d5ae-4234-8ac6-c673f4992dc5	0	0	4	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
6dfdfdc6-9b36-4767-94c0-db19c95f42ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90c34806-f884-4831-9511-e6fa5778b6af	0	0	0	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
b7f4c771-1d97-46db-9080-8436f00bfe65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	03569bf6-5a98-40b0-95e1-c12108ce3eba	0	0	0	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
b9e615f6-120b-46d2-8871-ebee4e5c3a85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7197d8e8-7041-4797-ae75-95c85da1666e	0	0	1	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
2e504391-1497-40ed-af1e-c614a04a175e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2f1dbc9a-9c60-4c7d-9339-9d34805e9afe	0	0	4	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
59c433be-3be9-4b38-b713-62ae7bf18523	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05e2ea43-b250-4e17-b4b1-f9c871461149	0	0	3	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
34622c22-92e2-4316-9f99-e0ba4174aea5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77dc1fa6-6723-4756-aa52-9a91f97ab8c5	0	0	0	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
c8fe0e59-b949-4d05-8ca6-f1258041116c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0a39c997-4fa1-431c-b215-a3bac0319c03	0	0	4	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
47c4d790-82e4-4eb2-b714-f95c56b55b67	39f5eb74-4722-4aaf-a6af-2c6e972e5885	071a27be-0a92-4731-804b-320927e7eea9	0	0	4	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
bc9e744c-8624-4363-80c6-a70db8e3e2d6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1279c3fa-393c-4bcf-b5f4-f5bbb222eb0a	0	0	0	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
91352099-4d5a-439d-817f-4dc8b1b64d7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c0fa63b0-b8f4-48f6-8f74-63a691aaef1d	0	0	0	2024-05-07 21:38:20	2024-05-07 21:38:20	\N	2024-05-07 21:38:20
ffd7fa93-b786-41b3-8ecf-3f9080ab44d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	318de301-e2f8-49bb-b2ba-0b7492f03119	1	2	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
013118e4-3862-4175-9f3c-bdb19ad124c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	be465df5-62f9-42b2-8eda-21c3a2277047	1	2	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
8114f770-b70b-4862-9dc6-53ef6e011725	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d9b677fa-ef26-42f8-9989-6b709a71b252	1	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
63c5e36d-2abc-4a03-b483-c7836f4661c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6262e488-3d64-48b1-a6b2-8d77994e85a5	1	0	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
5e59b909-9103-48e0-9e28-28501e2e42e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e2661527-c130-4111-84d1-d2b7ea7929c5	0	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
416abc89-8ab6-4db0-86b3-afdc7f79039c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	29b11582-9e4a-4a66-8ebe-4763424b22d9	0	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
5f689cea-9957-4eba-a2bd-0c0f8c982863	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b8e8cf7-c281-4ac4-80ee-64a1aab77141	0	2	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
a91771b7-638a-4a6f-bd4a-fb8694f5895e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b6a9e0cb-2719-449b-8bb1-71b7955bdee8	1	2	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
83c992d0-90ba-48ce-b30d-70dba1462a09	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fccd8aab-4065-407e-879d-865d0f97b6d1	1	1	4	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
4c5a0e84-938a-4085-9876-7dd45a3511d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	22b6b609-d82d-4a5c-9037-c6a14f5ee4cb	1	2	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
d536c05c-8d60-4f9d-b84f-0bc812dc7f76	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6fe672a1-44e3-4e23-9314-5f7e1a2c2f2f	1	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
dcbf195c-48fb-4329-951f-b4ecb180455b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d4eba952-41a3-4b3d-b288-181952ac096f	1	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
2505ac20-663a-4c49-8e7f-9923040bb585	39f5eb74-4722-4aaf-a6af-2c6e972e5885	daba9540-8e31-4248-968b-50ef415257d0	1	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
4b9da310-2743-489f-90e4-5added265c56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b598517-f1a8-4052-befd-ee482cdddc35	1	1	1	2024-05-13 09:11:06	2024-05-13 09:11:06	\N	2024-05-13 09:11:06
ec86b73c-3600-410b-a4de-d5cd792a921e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e5ffe92-0dcb-445c-9c81-f0787e0f3064	2	0	2	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
e8b803f4-4f62-4479-ba70-c45824dd091b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8423bd5b-bb24-409f-b953-69635cb0a902	0	0	2	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
2a23c12f-50df-4285-8882-17f3271cd913	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0c407dbe-a9c1-4748-9556-85830011bf2c	0	0	3	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
afca6426-248c-4cd4-95fb-31b16932cdd7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	eaa63dba-5927-4491-8b8c-55eecd6f1219	0	0	0	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
29a95ca8-8f7e-4753-a818-cf924892f1d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	194a9cb2-a79a-46bd-b359-a3c50adeae2a	0	3	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
1080a1a4-cfd7-4bf3-a55a-7656d204ffec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec7237e9-13fc-42f6-b9cb-6f7058abd137	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
2cbac46b-a637-48fc-906d-2028d19ef13a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bc499e4e-1b39-4b04-b38d-dd6970c6ed52	3	2	9	2024-06-11 11:56:10	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
18f1a875-1edd-4615-a702-bc0b4a269386	39f5eb74-4722-4aaf-a6af-2c6e972e5885	102f8d16-287e-44fc-b3ca-d6aead28aed9	0	2	24	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
02ca6745-2473-4efb-97f7-b519fee5094c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8fef1e89-12c2-43dc-890d-2f5da1d37df4	1	3	15	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
1828b60c-ce68-4c46-89fd-f5dec768d031	39f5eb74-4722-4aaf-a6af-2c6e972e5885	776844ce-cd73-429b-9592-0c2dba5474d3	0	3	3	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
f687e771-d6ad-494c-b45a-1cd40682e424	39f5eb74-4722-4aaf-a6af-2c6e972e5885	643d246a-925e-419e-a3c0-435fe8d307ee	0	3	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
2164060e-116d-4e66-8062-fadb755930aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	356efdb7-0e04-4395-8b48-16a972a03374	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
21ce28f1-7f1b-44f1-b3f4-3e57a9622a1b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5247bf40-d2ef-483a-b704-74cdb27a789e	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
839cf912-7452-4a25-91d9-2e743c7ba0ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4501c400-062f-446d-8476-dcc24fafb094	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
f469c9b1-4eee-4dc5-b396-5ecf8b1f6a2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b3253ac2-3a2d-4466-9be2-1d6d724c1757	0	0	2	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
d26e0021-06ae-476c-ad41-569fc6ae5ccc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c96b2c7f-620a-4c81-a88f-658ffbf21957	0	3	3	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
63ebba5e-2ebf-4078-9e7b-c5e0efe143b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	57b642d1-aba3-41e1-9246-e0a87ada89bc	0	3	5	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
c6a1a1b1-e653-4b77-b8f2-28bfa4cdb7be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a1e448ef-7005-4830-a0a6-ace451cc765d	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
d917a148-e6b2-47a5-8e52-6d50fd561c56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4c1b5e66-daf5-4ad0-aeaf-4a2927ef837f	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
f2981a24-6fa1-4ff0-bae8-dc2fb83cb0b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2f1a943d-bbfe-440f-bb9c-1d6b852d0fc3	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
fda478ac-5054-4e8d-b61d-7719d3644985	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bee0e2d8-5fa4-4153-9b0d-e871cc2cb020	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
084e947c-7f26-41ec-827a-1a9df430817f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0419f8e7-64a6-427a-8f2a-c615022950a5	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
db5e44c1-fb41-4bcb-a1f4-2fcaa4cd5530	39f5eb74-4722-4aaf-a6af-2c6e972e5885	13c6ad62-cf31-42d8-8923-d5d52dac9228	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
e6678352-a862-488a-9049-5fcf1cbc5a0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77463b5c-9fa1-4443-87e8-e11369bc554c	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
4d80adae-504d-4555-a7ba-5bc2cd4dbf48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6592c9f6-71eb-4378-8881-ccca8d9fc696	2	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
894ec80c-23d3-4659-aabd-d66c417e8587	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0e538c7a-8850-4013-980a-b2208af37643	0	0	0	2024-06-13 08:36:19	2024-06-13 08:36:19	\N	2024-06-13 08:36:19
2bdccd0a-03eb-45b2-83c1-a160471b7aec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6f0950ef-3179-403a-863b-d4a400d4567e	0	0	0	2024-06-12 15:07:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
5c63a96c-72c6-45a7-9704-7f43a6c5174b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b29aa250-1f1f-4d4c-b489-43d60eaf4c80	0	0	0	2024-06-12 15:07:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
6eee60a9-df58-412b-8426-48f1ccfc84e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6822d7b8-bc00-4197-bbd2-5d47b84d2d0a	0	0	0	2024-06-12 15:07:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
d496afd0-70f1-4c2e-a3c5-d74fcb19ba60	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a87edcc0-e048-44ce-a21d-d138ad876f3b	0	0	0	2024-06-12 15:07:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
ee86638b-8301-4df1-b946-b45e14af0a59	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fd57921c-cff2-40a8-955f-7d5787276e0d	2	3	2	2024-06-12 15:07:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
beed33c4-a560-4f5a-a659-bc37d5069616	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8abe3044-4fe0-4898-8443-4534f684a888	0	0	0	2024-06-15 12:35:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
001cea84-9aa1-40fb-ac95-ea3a442b266b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8515ba37-7fa4-45c6-8ea4-f263f8b5e136	2	3	2	2024-06-15 12:35:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
084e60bb-b9e7-4635-8fa4-c542483a997e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3a157f3c-f901-4a7c-9298-7f74466a954f	0	0	0	2024-06-15 12:35:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
5dc6a052-da60-4d9c-b869-4b0ef9b367da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	63c6b28f-51a2-4b67-b57b-5779cd19732a	5	3	2	2024-06-15 12:35:45	2024-06-15 12:35:45	\N	2024-06-15 12:35:45
9d331c98-d6de-454b-bd09-581617f2019c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c5d495d2-1ae4-494a-a83f-d3f89f3e80a6	0	0	0	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
2b48b722-4c5d-491b-9352-8de227b66f16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	18c0330a-7c2d-4329-b1c4-e4db512660df	0	0	0	2024-06-10 15:42:04	2024-06-19 06:44:44	\N	2024-06-19 06:44:44
81c24059-daf3-4e9c-8297-93dd90085ed7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5527a33f-75f3-41cf-a14f-e669356e7859	1	0	8	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
a8b5f2ec-2a29-4ced-ac95-2159fbfb9a54	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26c958aa-49e7-4a2f-a35b-66b699c78ef7	0	0	11	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
f51ac9f1-01e1-48c3-a87f-08cf6c2ac000	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f1f34f31-1efc-47b6-8563-e9d8c7d3dc7a	0	0	6	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
25e2f886-407c-4ae8-a8ab-082a7b519033	39f5eb74-4722-4aaf-a6af-2c6e972e5885	98a517eb-655b-4b42-9e7c-458a614ac680	0	0	7	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
3c9dfc22-b9f9-4757-90ba-83949b0dfadc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ba82dbff-8075-41ea-af77-9d6dc5bb29b6	0	0	18	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
58296ec1-c2f2-483f-aacd-5de96a077007	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd645496-7a5a-4d4c-afe2-8f66dbfb90d4	2	0	5	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
f164fc46-0c83-45e0-8b76-0981bed53597	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3557f54d-e526-47c6-89ef-392ac706a505	0	0	9	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
c090d377-b9fa-403f-918e-1b2d7cad2f45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9f185380-2704-4175-9fea-0f5fe5ae25da	3	0	6	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
452df9e4-5807-4f6b-b4db-92766f9eaedb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dab7d3d5-313e-48d2-a6b0-f9b45424fa18	0	0	4	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
aa4ae70c-a0bc-4a62-baa2-09b6b3cba522	39f5eb74-4722-4aaf-a6af-2c6e972e5885	95a70f7f-ae19-4df7-b80f-0ea32a789afb	0	0	16	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
d994e24e-9213-42b4-8199-e845f47b1b38	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a16be7eb-8617-4122-8723-4a73f1a2f778	4	0	20	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
fc15c256-97f2-4d09-ac34-b372ca7df889	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2d7dedce-848d-4620-9e32-57ee18df7d3e	0	0	5	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
b3952294-a7b8-4a67-9949-405952c7b565	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f4652732-3410-4fa8-8ae7-fd6f3ee94b61	0	0	7	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
52097bf0-40bb-4b09-bb76-fa6ec0559572	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f4517304-6095-4096-9113-b7352f19e0c0	0	0	8	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
becab8d8-7512-43f8-946e-6fdbf499dc22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a792b73a-209e-42b6-b523-adff49abf30d	0	0	6	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
1fac0ddf-556c-43f3-967b-24c0a7d55c57	39f5eb74-4722-4aaf-a6af-2c6e972e5885	45193985-d043-4d8d-9f93-b5d346d3f3c3	0	0	0	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
8a516617-0cc7-4aee-b663-3ad5af404238	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc793eeb-ff3d-440a-9392-2d5ae5330f4a	0	0	5	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
2c6d181f-f943-4cd9-8d3d-72ee4d7dd048	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a6f3773f-d756-4dfb-8d52-d4827e1e424a	0	0	0	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
b59e0c48-b617-449b-95a9-69434eb30e88	39f5eb74-4722-4aaf-a6af-2c6e972e5885	71522c80-15f4-4b04-9cf7-026e26cb4cbb	0	0	4	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
843c288a-fee9-4734-9cbe-6b11fb791c04	39f5eb74-4722-4aaf-a6af-2c6e972e5885	32be3c80-e4d9-442d-b213-9c02064309f2	0	0	10	2024-06-19 14:20:56	2024-06-19 14:20:56	\N	2024-06-19 14:20:56
58349b3b-046d-464e-80e0-93bae4863755	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a090c043-5f01-4aad-afd0-5cdd916594f1	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
563921d9-fd53-47a2-8ab5-1409b8811201	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7f1dce35-2f1e-49d9-abdd-f131015dd031	0	0	0	2024-06-19 19:58:14	2024-06-19 19:58:14	\N	2024-06-19 19:58:14
aa585a29-cd8e-4242-b59a-82b789407615	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1b5319a0-27a6-45da-90ff-478baab928dc	6	1	18	2024-06-11 11:56:10	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
2341b009-2284-426b-a126-8c0625fc9a72	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ff4baa4c-783a-4da2-bf84-d5bec57da6c9	1	2	6	2024-06-11 11:56:10	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
0b4abe84-5adb-4d15-a106-ffa873a8593a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	95876363-40d7-424f-a341-2e165c6a02c6	2	2	2	2024-06-11 11:56:10	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
d57ee9c1-e1f2-4531-8bad-8cc17b46b213	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ca758ed5-fb21-44cd-ae52-ca306931222e	1	2	15	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
f2c455bf-8c70-49b7-843a-8c984963902e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b4bccee9-df4b-457f-aa72-5dc4961e4519	0	2	20	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
6a6fd39d-f457-4151-ac7c-8e3b9685e44b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b64aa7ba-4826-4616-9ce3-369fee99844b	2	2	22	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
48b5374d-eac3-4345-9b1b-fc932bc76b3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e3a798f8-0d0c-43f5-9140-a2ab5f2de9ef	2	2	8	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
fd609d60-fff7-4e96-8bb0-abfbecc9dca0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b3285585-10e7-46d6-9e05-f5905852d77f	0	0	0	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
90eee315-f2b0-4ff8-af98-9f30fb4bd0e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	921b248e-7e00-437f-9ff3-430db9e9644f	4	1	10	2024-08-07 10:05:56	2024-08-07 10:05:56	\N	2024-08-07 10:05:56
64216f76-1938-4b2d-974c-1054b4f8e457	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2f2295d9-e2d3-48f7-a21b-1d1ff75f6832	7	12	11	2025-01-08 15:26:05	2025-01-08 15:26:05	\N	2025-01-08 15:26:05
937aa176-4bef-47b2-b005-4ba3bcc2ecbe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	99af0ac6-5a20-4558-b417-63a05e324cf8	1	2	2	2025-01-08 15:26:05	2025-01-08 15:26:05	\N	2025-01-08 15:26:05
b0a252fd-3922-4619-ad24-441d2317bfad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26a359d3-fdb4-4010-9838-a5ba45e2a8b1	8	11	13	2025-01-08 15:26:06	2025-01-08 15:26:06	\N	2025-01-08 15:26:06
bdc34619-312e-464f-b22d-cab3369695d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec51fb04-9116-4995-b94c-a3cecf51d565	0	1	2	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
4405568b-6414-45b4-bd29-a56be9bae369	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ec0a4e6-b211-4090-9c9d-fb4a51922165	0	1	2	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
65ed81ea-b7a4-4d98-a2b6-800abf7bb776	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85dbb274-caa6-4576-b868-3aee7e5bb709	0	0	0	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
29369774-31ad-4bfc-9503-f4f09a0c7723	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4fe94c56-f4ca-4a0b-8950-8ba18bc30488	0	0	0	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
2a2fdbd9-0a14-404d-9a34-694b520bae5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fdf8cf12-06bd-4484-a506-95b3b763b41c	0	2	2	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
b6721495-dccb-419c-b036-1e11bae10cc3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e177861f-dfb9-46a0-943e-0f4cc5a33f7e	0	2	3	2025-01-08 21:26:06	2025-01-08 21:26:06	\N	2025-01-08 21:26:06
60ec555d-65ca-4faf-90da-ec9372631473	39f5eb74-4722-4aaf-a6af-2c6e972e5885	98f71607-fb29-4ccc-b4a3-d10e64857e04	2	5	0	2025-01-09 05:02:55	2025-01-09 05:02:59	\N	2025-01-09 05:02:59
78872733-b5c7-48de-9546-6db2beb4840f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a81aa659-3835-49c2-9d03-8569b9143eb3	2	5	0	2025-01-09 05:02:55	2025-01-09 05:02:59	\N	2025-01-09 05:02:59
f6883636-858a-48ce-ac27-7c3140dc3431	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a765369e-0d5f-4164-a8c8-f25fbfb154a2	0	6	5	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
6fbf90c1-f90a-47e5-95ee-0bd1a9f8b118	39f5eb74-4722-4aaf-a6af-2c6e972e5885	95d016d1-f37e-4c0e-a242-4e33c8854250	0	0	9	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
e7384908-21fa-4561-a815-407149a8201d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0db69743-40d6-4854-8c44-f26c45b35351	0	0	0	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
47060783-d32a-48f1-beb3-a6a9b29a2192	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7f19ab02-4274-47cb-bf71-9d58bff3ca13	1	2	4	2025-01-08 18:24:15	2025-01-09 08:27:42	\N	2025-01-09 08:27:42
fde3a538-c1ed-4640-99a4-a31904681c11	39f5eb74-4722-4aaf-a6af-2c6e972e5885	84ab52cf-1ea8-45ca-8e4b-575f9fbd2e2b	0	0	0	2025-01-08 18:24:15	2025-01-09 08:27:42	\N	2025-01-09 08:27:42
6a3c3ea6-b6ad-46ba-8e89-6d7f3598048e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	911d12a3-08d4-4c55-9c10-e49a3ee21aa8	0	4	5	2025-01-08 18:24:15	2025-01-09 08:27:42	\N	2025-01-09 08:27:42
1e4749c7-c736-4b35-805e-45a818bfa51f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	120dc409-1963-496a-b50b-d3930be6bb55	0	0	11	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
083bf60a-9dda-48be-94a3-16d102612813	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b0cad535-6b06-4d4f-a9d5-3b95ae9f9abf	0	0	3	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
a1159b1e-3171-4a64-8697-730f0b8b9496	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f0ff8d23-06fa-4581-b116-2019e3de6e34	0	5	0	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
1b450a20-f25d-492c-bcce-9bb3571b44e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	841f2666-807e-483f-a1bc-1bec5783ff75	6	0	1	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
150e8629-1cdd-474c-91d8-93986060654c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	925728c4-fe27-49b1-ac9c-dbe5388536e6	0	1	0	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
7e46dbcf-1422-483e-b382-af79b4ca8117	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e231555e-25f6-4dd6-9e22-70f5498740b3	0	0	0	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
1bb4b69e-dad6-476c-a855-24d23a59ac41	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5cbd1a7c-4922-4f1e-adb1-4c8ac297e7d4	0	0	2	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
d2b1f6c1-25cb-495b-873c-8e6435f38e11	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d74b7fdd-f350-42b6-8e77-14bea81fd409	0	5	1	2025-01-09 07:55:13	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
96409d36-b232-4e24-b546-6a0ac4f86001	39f5eb74-4722-4aaf-a6af-2c6e972e5885	156118df-2fd5-4f1f-8783-aa9c7150f24c	3	2	0	2025-01-09 07:55:14	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
ed690479-5552-4db8-8eb6-74c1cae8f437	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33567e12-56db-4ed8-a960-226822d86617	0	0	2	2025-01-09 07:55:14	2025-01-09 07:55:23	\N	2025-01-09 07:55:23
745e9af6-80e9-4f69-8a26-2063ae2719c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0824602a-5357-42d4-b004-6dbc385450b5	2	5	3	2025-06-19 05:07:57	2025-06-19 05:08:01	\N	2025-06-19 05:08:01
36ced839-b27e-45ca-a0c1-b926caebfd5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19471e25-67cf-4418-97fd-72bd6893d3dd	2	5	3	2025-06-19 05:07:57	2025-06-19 05:08:01	\N	2025-06-19 05:08:01
f3d279e4-aa71-46fa-9f9c-edd7eef854f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	09607f3b-8e57-4d2a-a909-1d4f862782d7	0	33	19	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
e97b42b9-8e4d-40f0-b57a-135fecf230c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	34573e61-ac11-4387-a9d9-7d28350e2a53	0	0	8	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
5bf9a058-b8ae-40bc-9e45-4dbcba38f50a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fa46dc78-4268-4e5e-bc5b-a3d5613f2fcd	0	0	37	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
b0bf7397-4adc-42d0-b140-49c916c547ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7dfb3bf9-ca7b-4b22-b31c-f5fef39bd63d	0	0	0	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
37bacbb1-ca50-43f0-abe9-bdcc22ec66f6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	500ad60f-59e2-405b-ae46-39dfba803259	0	0	0	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
749d0555-578e-4fc3-88f9-3811af3dbbec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f523f5ae-346b-40e0-b273-8097bc08ad15	0	0	0	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
77f98573-031b-45c0-8a9f-fc4f7da87ce5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c1cfa1b5-7dcb-4d37-b4b4-d5821f146c16	1	3	13	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
6e05a8c3-e518-45c6-b08d-020a1f2e8498	39f5eb74-4722-4aaf-a6af-2c6e972e5885	916cef57-524f-4497-bb53-bf97873e283b	0	0	5	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
e8320bdc-5062-4223-88c9-62ff58793caf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bf6feb32-9263-4fd6-b0e3-d188bd50e28e	0	0	11	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
b7506249-9293-4ebf-95a4-ea8facff6d87	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ff526e44-4bd0-4351-a117-8ee7f356e3ca	0	0	0	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
291f7524-1594-42ff-9a03-cd8f3cc01dfe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2445739f-7cfb-4dcc-811a-2a4caa2f31c5	0	0	9	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
0ac71718-362c-4a2d-9f68-9916d6c56724	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7bb4a957-552d-4326-80bf-d177ee2083d6	0	0	15	2025-06-19 07:03:44	2025-06-19 07:03:54	\N	2025-06-19 07:03:54
80585366-4d4e-4ebc-b016-d2077a5e5b85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d376c7f4-e327-48a1-88db-f2796318f5c9	0	1	1	2025-06-19 12:03:14	2025-06-19 12:03:14	\N	2025-06-19 12:03:14
25fc1fe8-7dcc-441e-8117-67df4c5534d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e812a5c-125c-458e-9eef-6e9cddbdc415	0	1	1	2025-06-19 12:03:14	2025-06-19 12:03:14	\N	2025-06-19 12:03:14
7b905716-398d-4615-8baf-bc26bc54a5f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f82e9bea-54d2-4177-b994-6e6efe854b5c	0	2	3	2025-06-19 12:03:15	2025-06-19 12:03:15	\N	2025-06-19 12:03:15
3cc3c9dc-17d3-4e0e-b8df-c2a8c29d6d73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0edd663f-d5e1-46de-a14f-80e1e8bdd7d1	0	1	1	2025-06-19 12:03:15	2025-06-19 12:03:15	\N	2025-06-19 12:03:15
909e64b2-fdc3-40fa-8c49-1fc60c70cfaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d5a8f1ef-729c-446a-a9e6-0730d7fd944f	4	1	3	2025-06-19 09:36:17	2025-06-19 10:42:09	\N	2025-06-19 10:42:09
b0f3a0a4-c515-4820-a43e-befaee7a2b48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	448dca1b-69e1-4995-a105-8ee7e1c4805b	3	7	8	2025-06-19 09:36:17	2025-06-19 10:42:09	\N	2025-06-19 10:42:09
d3bf6b09-fba8-4093-b7fa-749f1943d5ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f40350fb-72ea-48f9-94ad-0a0433bc6f41	1	0	3	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
68c465b9-43cf-40bd-a82a-38c404265467	39f5eb74-4722-4aaf-a6af-2c6e972e5885	234b9c37-639e-435d-bf2b-77aa3a28d3ea	0	2	2	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
97928da6-ac29-4927-bb7e-4e2a560cd448	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c5248f7f-74cd-4f2d-b644-2300dd5e5cbb	0	0	0	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
68b48de6-3073-4274-b782-2b6ab06e6eff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e1fedce6-ad16-4e26-9ded-0e5627ebcd58	0	0	0	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
83459332-0728-4cbd-9b5e-5344a2296e99	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7e71405a-56e8-4603-93b7-5651ce4a8d58	0	0	4	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
6314ff26-d283-442c-8f88-74d56e14d826	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a235f0ea-4814-4647-91cc-14fb4ddbf593	0	0	3	2025-06-19 11:15:41	2025-06-19 11:15:41	\N	2025-06-19 11:15:41
3900f455-ee48-49fe-81b0-32784e03cb3f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	63126d8c-40fd-4946-8d18-b72e96feff17	0	0	0	2025-06-19 12:03:15	2025-06-19 12:03:15	\N	2025-06-19 12:03:15
73a24e89-7a79-4f8a-a0b7-5dacb268acb1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6b462f13-38cb-47ec-9ec4-8f4797db6b94	0	2	2	2025-06-19 12:03:15	2025-06-19 12:03:15	\N	2025-06-19 12:03:15
dd14db39-04b0-4cb0-b398-f2198260e8f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a0577b3c-c920-4f15-b9a1-bdd09b17fb8f	2	2	8	2025-06-20 07:45:50	2025-06-20 07:46:13	\N	2025-06-20 07:46:13
c41e00c5-ba4f-4e72-a28d-89e664cd6a19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	646d710a-487d-458a-a6dc-d9cb0902c22a	1	1	2	2025-06-20 07:45:50	2025-06-20 07:46:13	\N	2025-06-20 07:46:13
12acf2a1-44fd-4e63-a5ec-e606ed343ab0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	01ae71db-e9b1-4334-b005-ce70adec974d	2	2	6	2025-06-20 07:45:50	2025-06-20 07:46:13	\N	2025-06-20 07:46:13
\.


--
-- Data for Name: absensi_pkl; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.absensi_pkl (absensi_pkl_id, peserta_didik_id, pkl_id, sakit, izin, alpa, created_at, updated_at, last_sync) FROM stdin;
\.


--
-- Data for Name: akt_pd; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.akt_pd (akt_pd_id, akt_pd_id_dapodik, sekolah_id, mou_id, id_jns_akt_pd, judul_akt_pd, sk_tugas, tgl_sk_tugas, ket_akt, a_komunal, created_at, updated_at, deleted_at, last_sync) FROM stdin;
42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	429dd201-f9d8-4377-b881-2e4cb88762ed	1	Prakerin Multimedia	422/SMKN1TTYN/PRK/211/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:56	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
29e9d84a-2d0f-463b-9cb1-4a32e193eed8	29e9d84a-2d0f-463b-9cb1-4a32e193eed8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c8464075-73fe-4681-b568-3926c5908e4c	1	Prakerin Perhotelan 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
725bfbe9-b10c-4654-933b-90c5987c9aa3	725bfbe9-b10c-4654-933b-90c5987c9aa3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a98bda0f-b566-4f6f-81d1-4e32b2828f26	1	Prakerin Perhotelan 2021	DIKDA/17.14/SMKN1TTYN/225.A/XI/2021	2021-06-15	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a98bda0f-b566-4f6f-81d1-4e32b2828f26	1	Prakerin Perhotelan 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-20	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a98bda0f-b566-4f6f-81d1-4e32b2828f26	1	Prakerin Perhotelan Covid 2020	DIKDA/17.14/SMKN1TTYN/224.A/XI/2020	2020-11-14	\N	0	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	caea6cf2-718c-4a70-83ad-5bb157cc31f8	1	PRAKERIN TKJ	420/SMKN1TTYN/PRK/211/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f2ccd427-0f68-40f0-8210-2eb5a0e97ee8	f2ccd427-0f68-40f0-8210-2eb5a0e97ee8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f285a71b-37bb-4782-a2f3-6462a9b7dabc	1	PRAKERIN XII AKOMODASI PERHOTELAN	DIKDA/SMKN1TTYN/PKR/01/II/2018	2018-02-02	PRAKERIN	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
5b523a5c-56fb-4d35-9225-59e406eb0e97	5b523a5c-56fb-4d35-9225-59e406eb0e97	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f285a71b-37bb-4782-a2f3-6462a9b7dabc	1	Prakerin Perhotelan 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
14042a19-7bf2-496e-8888-e9c191d38053	14042a19-7bf2-496e-8888-e9c191d38053	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe120edb-71ef-4ad6-978b-6be2642545dc	1	Prakerin TKJ	422/SMKN1TTYN/PRK/211/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
151c09af-f196-4abc-a754-59f110b57f13	151c09af-f196-4abc-a754-59f110b57f13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c3e554f3-1e3f-46d3-9c8b-7316b01586b3	1	Prakerin Kesehatan	DIKDA/SMKN1TTYN/ /II/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
114ad756-3691-44c4-baf8-54f70d900b6f	114ad756-3691-44c4-baf8-54f70d900b6f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8e4a511b-8cf9-408d-b30a-75cd31696157	1	Prakerin Multi Media 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f0229080-90d0-4b7a-8753-d3dc35032ced	f0229080-90d0-4b7a-8753-d3dc35032ced	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8e4a511b-8cf9-408d-b30a-75cd31696157	1	PRAKERIN MULTIMEDIA	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
dc96c570-1818-4dff-b7cc-880a5de10070	dc96c570-1818-4dff-b7cc-880a5de10070	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77be9ac7-99a3-4ec6-8d14-770216730354	1	PRAKERIN PERHOTELAN	DIKDA/SMKN1TTYN/PKR/ V/I/2021	2021-06-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
e59881b2-2ca9-4f3a-ab09-01a862a8b77b	e59881b2-2ca9-4f3a-ab09-01a862a8b77b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c1c6a17e-fecb-41f6-b4d8-8c4af67d7c9b	1	PRAKERIN MULTIMEDIA	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
cf55e85b-d07e-4ec2-9519-d2dbb887840e	cf55e85b-d07e-4ec2-9519-d2dbb887840e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ea739ef8-f77f-4628-906e-8e32afe5f5bd	1	Prakerin Multimedia	422/SMKN1TTYN/PRK/12/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
e15f58e6-2ab3-4723-b751-754a4df20efe	e15f58e6-2ab3-4723-b751-754a4df20efe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	706e044f-4e3d-45cf-be86-a4471d8cc6f6	1	Prakerin TKJ	422/smkn1ttyn/prk/211/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6c1609f1-43fd-44c7-8d5f-a5aa697f841e	1	Prakerin TKJ	422/SMKN1TTYN/PRK/211/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
72b3a090-53e3-4c69-a917-13c239b38f59	72b3a090-53e3-4c69-a917-13c239b38f59	39f5eb74-4722-4aaf-a6af-2c6e972e5885	420eed64-def6-4340-979c-a5f1ec75f2d4	1	Prakerin TKI (TKJ)	DIKDA/17.14/SMKN1TTYN/226.A/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f902d4ab-3fe5-4d70-a5bf-52743be59fd9	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	420eed64-def6-4340-979c-a5f1ec75f2d4	1	Prakerin TKJ 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
6bb8cb39-f8a5-4773-98dc-919ee1daf77d	6bb8cb39-f8a5-4773-98dc-919ee1daf77d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	420eed64-def6-4340-979c-a5f1ec75f2d4	1	Prakerin Multimedia	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
47665a9d-da96-4f59-8aeb-9e7c131e6219	47665a9d-da96-4f59-8aeb-9e7c131e6219	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9e5036d-558e-4f01-a942-ab5af728a3ab	1	PRAKERIN	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
703b4319-b639-4758-b0d5-d70855c9d3b2	703b4319-b639-4758-b0d5-d70855c9d3b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9e5036d-558e-4f01-a942-ab5af728a3ab	1	Prakerin Multi Media 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
bb2fd68a-be9c-4064-b8b7-8c37627cc282	bb2fd68a-be9c-4064-b8b7-8c37627cc282	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0d4d6039-c934-4c87-a22b-c3d1865eba1f	1	Prakerin TKJ 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
86e3e8ee-58ce-4a0a-907e-f93ad8fa34bb	86e3e8ee-58ce-4a0a-907e-f93ad8fa34bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0d4d6039-c934-4c87-a22b-c3d1865eba1f	1	PRAKERIN MULTIMEDIA	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2017	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
2e95354f-cfbb-4e4f-a8f8-85de1df1118a	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90e3b927-8d90-48bc-bdc5-ca5cdd354a2b	1	Prakerin TKJ 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
05f15623-c39e-40aa-83f4-a73f4dcf96ad	05f15623-c39e-40aa-83f4-a73f4dcf96ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90e3b927-8d90-48bc-bdc5-ca5cdd354a2b	1	Prakerin TKJ 2021	DIKDA/17.14/SMKN1TTYN/226.A/XI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
694dbea4-61bc-45ed-baff-dd895fc010bb	694dbea4-61bc-45ed-baff-dd895fc010bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90e3b927-8d90-48bc-bdc5-ca5cdd354a2b	1	Prakerin TKJ Covid 2020	DIKDA/17.14/SMKN1TTYN/225.A/XI/2020	2020-11-14	\N	0	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e0e2316-1f20-48f7-994e-d1003b38070b	1	Prakerin Kesehatan 2021 Puskes Modayag	162/MoU/SMKN1TTYN/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
c12085c2-4603-44c5-a1f0-9abe4f19f9de	c12085c2-4603-44c5-a1f0-9abe4f19f9de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fff1e840-be1a-42e3-aed9-d27cca8256f0	1	Prakerin Multimedia	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2018	2018-02-02	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
bd00c421-6c17-4499-9304-b6a1b954c97d	bd00c421-6c17-4499-9304-b6a1b954c97d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fff1e840-be1a-42e3-aed9-d27cca8256f0	1	Prakerin Multi Media 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a0898e0-b378-4047-b55c-d8b5888d5dbc	1	Prakerin Asisten Keperawatan 2021	162/MoU/SMKN1TTYN/XI/2021	2021-06-01	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
47b6caa2-713f-4131-aa37-8b889233f355	47b6caa2-713f-4131-aa37-8b889233f355	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a0898e0-b378-4047-b55c-d8b5888d5dbc	1	Prakerin Kesehatan 2019 Puskes Kotabunan	162/MoU/SMKN1TTYN/XI/2019	2019-07-15	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a3e784c4-7659-4d18-a910-d371e6f8de3a	a3e784c4-7659-4d18-a910-d371e6f8de3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a0898e0-b378-4047-b55c-d8b5888d5dbc	1	Prakerin Asisten keperawatan Covid 2020	162/MoU/SMKN1TTYN/XI/2020	2020-11-14	\N	0	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
08d51f0c-cf8e-4111-9c52-b1adaf85863c	08d51f0c-cf8e-4111-9c52-b1adaf85863c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	88a53e24-1988-4c0d-91c8-f48765740fb0	1	Prakerin Perhotelan 2019	DIKDA/17.14/SMKN1TTYN/224.A/VI/2019	2019-06-21	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
36ac62de-03c6-4486-b311-4abf5df566a8	36ac62de-03c6-4486-b311-4abf5df566a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	db1abe2c-fb5e-4ce9-a01a-f1b9bc828694	1	PRAKERIN MULTIMEDIA	DIKDA/17.14/SMKN1TTYN/211.A/VIII/2017	2018-02-02	\N	0	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
a431941b-0f77-4479-b019-664a1fffd1e6	a431941b-0f77-4479-b019-664a1fffd1e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dae9b6a9-2c6c-4afa-b601-089913e9e721	1	PRAKERIN TKJ	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
d48856fb-ab4b-442d-b8bf-9d3a342e22df	d48856fb-ab4b-442d-b8bf-9d3a342e22df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12097ad0-c631-4283-a151-09c73c67c58e	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
d60144a2-508e-44d2-91ab-906e5e0c636b	d60144a2-508e-44d2-91ab-906e5e0c636b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7dd8ef0c-3431-4c6f-8802-0027b466d34b	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ce400727-0d66-458e-811d-1beb471ab239	ce400727-0d66-458e-811d-1beb471ab239	39f5eb74-4722-4aaf-a6af-2c6e972e5885	acdf163a-6553-40cf-a603-1d02440717cd	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
12e60bf2-fd26-4336-b45a-11afbe3a8193	12e60bf2-fd26-4336-b45a-11afbe3a8193	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7d130b10-8a5f-42fb-b90c-2ba5f9fad9e2	1	Prakerin Multimedia	420/SMKN1TTYN/PRK/VI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
48805a93-a029-4ef0-9c90-94844b3a2af8	48805a93-a029-4ef0-9c90-94844b3a2af8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9e5036d-558e-4f01-a942-ab5af728a3ab	1	Prakerin TKI (Multimedia)	DIKDA/17.14/SMKN1TTYN/226.A/XI/2021	2021-06-23	\N	0	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b650cc24-3f5f-4a61-8cb5-efac77bbed48	b650cc24-3f5f-4a61-8cb5-efac77bbed48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9e5036d-558e-4f01-a942-ab5af728a3ab	1	Prakerin Multimedia Covid 2020	DIKDA/17.14/SMKN1TTYN/224.A/XI/2020	2020-11-14	\N	0	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
33d132e0-b8ad-477e-b46b-a300af544e5b	33d132e0-b8ad-477e-b46b-a300af544e5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e0e2316-1f20-48f7-994e-d1003b38070b	1	Prakerin Kesehatan 2019 Puskes Modayag	162/MoU/SMKN1TTYN/XI/2019	2019-06-10	\N	0	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2bf91fd6-c730-4c6e-9268-761cf11ea097	2bf91fd6-c730-4c6e-9268-761cf11ea097	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8b39cf9-c701-4e71-bff3-a53f1417d358	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0310f43c-3e8f-404d-be3c-816746a737e0	0310f43c-3e8f-404d-be3c-816746a737e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fe120edb-71ef-4ad6-978b-6be2642545dc	1	Prakerin TKJ	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
aba8225c-0761-4ca2-a185-4cc938f27ef1	aba8225c-0761-4ca2-a185-4cc938f27ef1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0398632a-5783-41e1-ac80-62cbd4f46c0a	1	PKL Asisten Keperawatan 2022	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
f8beba62-1e88-4daf-a251-5372eaf2a6fd	f8beba62-1e88-4daf-a251-5372eaf2a6fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0398632a-5783-41e1-ac80-62cbd4f46c0a	1	PKL Asisten Keperawatan 2022	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
3dfebd13-2a41-44dc-89e6-e354354c43cb	3dfebd13-2a41-44dc-89e6-e354354c43cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	706e044f-4e3d-45cf-be86-a4471d8cc6f6	1	Prakerin TKJ	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
1c413294-97a9-4966-ab50-3ca30ad7e3b0	1c413294-97a9-4966-ab50-3ca30ad7e3b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	429dd201-f9d8-4377-b881-2e4cb88762ed	1	PRAKERIN TKJ	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
a60210af-b48d-4105-aadf-ec685007dc91	a60210af-b48d-4105-aadf-ec685007dc91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	90e3b927-8d90-48bc-bdc5-ca5cdd354a2b	1	Prakerin TKJ 2022	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
4872fa65-f563-4f6a-a971-5be74caf5b14	4872fa65-f563-4f6a-a971-5be74caf5b14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ea739ef8-f77f-4628-906e-8e32afe5f5bd	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
19213871-6df1-4c31-a68f-5eefcac5a982	19213871-6df1-4c31-a68f-5eefcac5a982	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a0898e0-b378-4047-b55c-d8b5888d5dbc	1	PKL Asisten Keperawatan 2022	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a0898e0-b378-4047-b55c-d8b5888d5dbc	1	PKL Asisten Keperawatan 2022	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
8fcd23ba-a9ad-4801-9bfa-06b7f1057b5d	8fcd23ba-a9ad-4801-9bfa-06b7f1057b5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b9e5036d-558e-4f01-a942-ab5af728a3ab	1	PKL Multimedia	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
e8487724-fe1a-4b7c-b7b5-9aa959c83e41	e8487724-fe1a-4b7c-b7b5-9aa959c83e41	39f5eb74-4722-4aaf-a6af-2c6e972e5885	77be9ac7-99a3-4ec6-8d14-770216730354	1	PKL Perhotelan	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
3adcc08e-b7b6-4486-8723-1c080458c8e2	3adcc08e-b7b6-4486-8723-1c080458c8e2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	caea6cf2-718c-4a70-83ad-5bb157cc31f8	1	PRAKERIN TKJ	420/SMKN1TTYN/356/VII/2022	2022-07-04	\N	0	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
73a11bc8-da3d-47d4-84c5-5fca52a696fd	73a11bc8-da3d-47d4-84c5-5fca52a696fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a274b465-8ccc-46be-8c11-df8aeff7f1b2	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:26
46c8c32f-379b-4a36-a819-363a4313bd05	46c8c32f-379b-4a36-a819-363a4313bd05	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7d130b10-8a5f-42fb-b90c-2ba5f9fad9e2	1	Prakerin Multimedia 2024	420/SMKN1TTYN/50/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
85379c23-b0f5-43e1-90a2-79e7e27688b9	85379c23-b0f5-43e1-90a2-79e7e27688b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	37d43dde-8f48-45e5-b326-0e69b7323f2b	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
a835b622-88d5-4b82-a187-afbe5e3e0585	a835b622-88d5-4b82-a187-afbe5e3e0585	39f5eb74-4722-4aaf-a6af-2c6e972e5885	047dbf85-c5c6-46e8-8c91-b41af1e65ad0	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
5f83a1d4-13c3-4f8d-90e6-a2a2d78f97ac	5f83a1d4-13c3-4f8d-90e6-a2a2d78f97ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ed3c86c7-9081-46ea-9149-322b755f3250	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
78b5f6a3-506e-45b9-9233-e72b179ea8af	78b5f6a3-506e-45b9-9233-e72b179ea8af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9912b4f6-7b7b-468c-b65c-321dee9bf68e	1	Prakerin Perawat 2024	420/SMKN1TTYN/51/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
ec89a489-7764-4644-932a-a67f80adf37d	ec89a489-7764-4644-932a-a67f80adf37d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f88bfc07-a588-4ba7-a897-eb488c7a0d03	1	Prakerin Multimedia 2024	420/SMKN1TTYN/50/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
dca8c625-66fa-40f4-9c90-7fe6a4e7031d	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ebc6be3-b907-443d-aa53-610fda95ad86	1	Prakerin Perawat 2024	420/SMKN1TTYN/52/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
a3a560b6-dfcf-4af5-9240-fa47d7b34046	a3a560b6-dfcf-4af5-9240-fa47d7b34046	39f5eb74-4722-4aaf-a6af-2c6e972e5885	26b6c502-ef15-4daa-92a5-19fc3be0457c	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
6e3a734a-1f55-451b-b20c-638af8269223	6e3a734a-1f55-451b-b20c-638af8269223	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cba9720-ff64-40e0-9b44-e50b5ccad2df	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
9c45e986-84ac-4879-82ba-60668a077d7c	9c45e986-84ac-4879-82ba-60668a077d7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	452c2121-1b8a-4f21-a672-3341c0e0a711	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-08-05	\N	0	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
9ffd4937-1e2b-45b3-a7bd-e01cf211c28f	9ffd4937-1e2b-45b3-a7bd-e01cf211c28f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f481b481-37b6-4e4b-b091-c257c220fb87	1	Prakerin Hotel 2024	420/SMKN1TTYN/51/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
2dbffb72-3a68-4c7a-b27b-11ba4ee9ec9e	2dbffb72-3a68-4c7a-b27b-11ba4ee9ec9e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fff21c78-7966-4ca8-848a-e008ab94ef24	1	Prakerin Hotel 2024	420/SMKN1TTYN/51/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
36460622-2c36-492c-8f2d-ee2df61b152b	36460622-2c36-492c-8f2d-ee2df61b152b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b8852fd4-ce35-4644-9487-0522f2011c5f	1	Prakerin TKJ 2024	420/SMKN1TTYN/030/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
5269f06a-f43d-4d95-b523-871217a2ee97	5269f06a-f43d-4d95-b523-871217a2ee97	39f5eb74-4722-4aaf-a6af-2c6e972e5885	acdf163a-6553-40cf-a603-1d02440717cd	1	Prakerin Multimedia 2024	420/SMKN1TTYN/50/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
4723fdb8-3c56-4bb1-8e80-c3c68bce03b2	4723fdb8-3c56-4bb1-8e80-c3c68bce03b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c4f9b2f2-b0e0-4fb1-85d1-07ace6e034a3	1	Prakerin Multimedia 2024	420/SMKN1TTYN/50/VII/2024	2024-07-03	\N	0	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
144c6e28-4266-4a66-a2b6-5f288e4fd102	144c6e28-4266-4a66-a2b6-5f288e4fd102	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a274b465-8ccc-46be-8c11-df8aeff7f1b2	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:31	2025-12-01 23:17:31	\N	2025-11-01 23:17:31
1424a3b7-b04e-443e-9c09-b61c2a95fa6d	1424a3b7-b04e-443e-9c09-b61c2a95fa6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	23607991-c35c-46a8-a12b-a87c9f8d741e	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
0b6a3f38-5d20-4d20-8ded-bb2a74ac7ceb	0b6a3f38-5d20-4d20-8ded-bb2a74ac7ceb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9350338d-b1dd-4a78-814d-3492fd0e7e62	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
25975caf-971b-4b6c-adc5-5d42feabd4bd	25975caf-971b-4b6c-adc5-5d42feabd4bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ebc6be3-b907-443d-aa53-610fda95ad86	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
38fb97f3-92fc-4e46-8383-f8c1c8d82ff0	38fb97f3-92fc-4e46-8383-f8c1c8d82ff0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cba9720-ff64-40e0-9b44-e50b5ccad2df	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
e49a2a39-7cf5-47b9-985e-aa727abda876	e49a2a39-7cf5-47b9-985e-aa727abda876	39f5eb74-4722-4aaf-a6af-2c6e972e5885	52f68053-8483-40e9-8f95-a98b3c3e98bd	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
fc713781-29c1-4c5f-aa27-f7f7fcfe59d1	fc713781-29c1-4c5f-aa27-f7f7fcfe59d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	71a838e5-7ef7-42e9-bc59-7972b2822eb6	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
7a9ddb78-3848-4531-899f-faa7a20394e8	7a9ddb78-3848-4531-899f-faa7a20394e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7c905d36-bbdd-485d-9981-7349d68ad532	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
32b89df4-3f72-4bf8-8647-475387b081ab	32b89df4-3f72-4bf8-8647-475387b081ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f481b481-37b6-4e4b-b091-c257c220fb87	1	PKL 2025	420/SMKN1TTYN/51/VII/2024	2025-07-14	\N	0	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
424267e7-80dd-4f47-a77d-a3558df2481d	424267e7-80dd-4f47-a77d-a3558df2481d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b8852fd4-ce35-4644-9487-0522f2011c5f	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
60d021cb-f0c8-4552-8ba3-d7d69a0b5f24	60d021cb-f0c8-4552-8ba3-d7d69a0b5f24	39f5eb74-4722-4aaf-a6af-2c6e972e5885	c4f9b2f2-b0e0-4fb1-85d1-07ace6e034a3	1	PKL 2025	420/SMKN1TTYN/015/VII/2025	2025-07-14	\N	0	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
\.


--
-- Data for Name: anggota_akt_pd; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.anggota_akt_pd (anggota_akt_pd_id, id_ang_akt_pd, sekolah_id, akt_pd_id, peserta_didik_id, nm_pd, nipd, jns_peran_pd, created_at, updated_at, deleted_at, last_sync) FROM stdin;
a9d354bb-6b1a-4b92-9b27-0860564a3f5a	a9d354bb-6b1a-4b92-9b27-0860564a3f5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	Rissya Raihan Makalunsenge	0481	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f89354cb-deb4-4578-8d92-5678a97610a9	f89354cb-deb4-4578-8d92-5678a97610a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	d6276643-bada-4ca6-a7d6-27f02efbd2c2	Septi Wahyu Dasinangon	0362	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
70908abd-609f-492a-b943-1305c972cee9	70908abd-609f-492a-b943-1305c972cee9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	c795df6e-a22f-478f-9005-76d13d30bab4	Renaldi Solangka	0373	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
9ffde77e-332e-496a-99bb-f1b8b4f0c5f6	9ffde77e-332e-496a-99bb-f1b8b4f0c5f6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b523a5c-56fb-4d35-9225-59e406eb0e97	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	Christia Tandayu	0443	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
73bf8db2-81ae-4735-a1fd-c28f08cf23d5	73bf8db2-81ae-4735-a1fd-c28f08cf23d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b523a5c-56fb-4d35-9225-59e406eb0e97	1d64c4a6-b263-441e-82e2-763c790c3c05	Yusril Mokodompit	0325	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
988ffc39-03f0-4089-8f71-0a29aff1e337	988ffc39-03f0-4089-8f71-0a29aff1e337	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5b523a5c-56fb-4d35-9225-59e406eb0e97	501e0d46-a3a8-4538-9bd0-33892dbc8140	Tanti Wulandari Suwarno	0369	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
2e42a1bf-0187-49c8-b36a-970330f02c81	2e42a1bf-0187-49c8-b36a-970330f02c81	39f5eb74-4722-4aaf-a6af-2c6e972e5885	114ad756-3691-44c4-baf8-54f70d900b6f	1a68049f-e368-4766-8709-c7b9920f5e90	Sridiva Lakodi	0349	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
70aa6d8a-b7c2-4c46-8f3a-39e9ee2e9efd	70aa6d8a-b7c2-4c46-8f3a-39e9ee2e9efd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	4c42f155-3a8b-4690-b9c4-f92f8d413990	Rolin Kolopita	0426	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
be04930c-9de1-4b4f-9f20-20b1f3776fd0	be04930c-9de1-4b4f-9f20-20b1f3776fd0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	22278151-6aec-4b87-bfab-3bf8d1810468	Sri Wayuni Abdjul	0427	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f4a308b7-3b1d-4c36-8945-08d6ae79c30c	f4a308b7-3b1d-4c36-8945-08d6ae79c30c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	d90d0294-59e6-4283-a821-c9b6aaae536b	Parli Lapadjawa	0404	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
76b829d3-9263-4edf-a612-fde9155370eb	76b829d3-9263-4edf-a612-fde9155370eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	Priti Sambali	0358	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
33bb01ab-a294-425c-b3d8-e75881a62eff	33bb01ab-a294-425c-b3d8-e75881a62eff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f902d4ab-3fe5-4d70-a5bf-52743be59fd9	5899f113-d963-4965-9245-1f6222f5bbc1	Sealtiel Tempone	0398	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
4cfa3184-b6c8-454e-b7f4-990405dd6258	4cfa3184-b6c8-454e-b7f4-990405dd6258	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	02c9180a-0b24-4ac4-b544-24d968340f61	Risal Paputungan	0392	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
d4bd0666-7f22-4b6a-a8d4-8e29dcd381e6	d4bd0666-7f22-4b6a-a8d4-8e29dcd381e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	f159319f-2b97-4744-95ff-edb8466a656f	Nurmila Kadengkang	0352	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ff20e4cd-65da-4e70-b7ef-84014fd92db3	ff20e4cd-65da-4e70-b7ef-84014fd92db3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	43995feb-8d7d-4f37-9a8b-b2ab3ff70ac2	Putri Dian Permata Mokoagow	0340	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
29762201-3716-4506-b786-2f258c084a7e	29762201-3716-4506-b786-2f258c084a7e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	7ab0ba14-a17f-4ecd-8201-a673cc87846c	Nadia Mokodompit	0344	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
c9cc3b4e-8947-4b70-8662-280409a0a718	c9cc3b4e-8947-4b70-8662-280409a0a718	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	Wahyu Damopoli	0339	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
29447692-9040-40b5-84ea-04bd6d355bcf	29447692-9040-40b5-84ea-04bd6d355bcf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	2d18bbb3-fd39-46c5-98e0-19c1a9a240db	Nigestria Firnata Mokodompit	0387	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
d9c06515-60dc-4561-861a-e7a8df3c8853	d9c06515-60dc-4561-861a-e7a8df3c8853	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	7661d6a5-1907-41fd-8c82-a5fea385fef8	Muhamad Reiza Gumalangit	0423	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f0172f78-ca88-4a0b-8f34-e4a76c87736e	f0172f78-ca88-4a0b-8f34-e4a76c87736e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	010a4695-214e-4efb-a13b-83ab9a7e5a9a	Najamudin Bokingo	0345	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
03f2f49d-c2fa-45b3-9dd3-1867a95687f4	03f2f49d-c2fa-45b3-9dd3-1867a95687f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	Pingkan Aulia Mokodompit	0390	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
20fdea87-b7c2-4581-bc05-5f8810d3466e	20fdea87-b7c2-4581-bc05-5f8810d3466e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	Rizaldi Narazuri Mokoagow	0317	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
455846d0-7e76-4244-b966-985e996eb3dd	455846d0-7e76-4244-b966-985e996eb3dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	36aa6f27-73dc-4d6c-98e8-cb7a01d1f686	Nur Inayahsari Umar	0396	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
ef712fa6-1d98-449e-af5b-6fe01b08a184	ef712fa6-1d98-449e-af5b-6fe01b08a184	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	c8ee9713-6348-4525-ac7a-27b373d312df	Fitrah Hilalia Muhsin	0380	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
0398d570-3e9f-42b8-af3e-2ddb496fb469	0398d570-3e9f-42b8-af3e-2ddb496fb469	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	568a2d30-3a78-43fd-81ea-2c98ec3d3865	Nurul Hidayah Mokoagow	0393	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
e5e0f5d2-b432-4995-b3f3-2a6ba95b9edd	e5e0f5d2-b432-4995-b3f3-2a6ba95b9edd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	7a426c49-48eb-473c-9779-47a65a92d954	Martenci Kalawasi	0400	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
212c5cd3-3b60-4db1-9369-f8a94b809daf	212c5cd3-3b60-4db1-9369-f8a94b809daf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd00c421-6c17-4499-9304-b6a1b954c97d	cc30617c-14a9-478b-83d4-b0e836aa69c0	Dela Astri Tampi	0335	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
3ce75e1d-a6f9-4068-85d2-159f0b49fde9	3ce75e1d-a6f9-4068-85d2-159f0b49fde9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	e3549675-96bb-4c36-9d4e-b034c5de4b80	Jimmy Richardo Salendu	0342	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
b662a8a6-c2d3-4285-acd6-f5efd13e0e8e	b662a8a6-c2d3-4285-acd6-f5efd13e0e8e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	e131badd-15c9-4911-8c81-1d30249b7d73	FIRNA KIRANA MODEONG	0483	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
b105b1c8-77a6-4ef3-94d2-87bf31c285f0	b105b1c8-77a6-4ef3-94d2-87bf31c285f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	fa092490-4b74-11e5-a33d-db9868dda03f	Fazri Makalalag	0477	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
ff2fb78e-3d1e-4321-99df-c16366a4c32c	ff2fb78e-3d1e-4321-99df-c16366a4c32c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	da2e3e30-22ee-11e4-90f6-53330a5cd670	Fiqih Ade Saputra Wakari	0479	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
e3e4e44b-fe32-46f1-8604-26fe5d106b77	e3e4e44b-fe32-46f1-8604-26fe5d106b77	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	f9496132-3b0c-11e5-a92d-b7a7850016b8	Erlangga Luminu	0472	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
b7171c8a-8f0b-45e2-be0c-e23174870ae9	b7171c8a-8f0b-45e2-be0c-e23174870ae9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	703b4319-b639-4758-b0d5-d70855c9d3b2	1f87026c-1601-4eb9-9b82-64289bded8ed	Wahyudi Mokodompit	0357	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
e0657c69-289e-4506-9bc6-2bf7bb65f19e	e0657c69-289e-4506-9bc6-2bf7bb65f19e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	607b1b72-46d2-11e5-ba50-1375139e8458	Ibnu Azif Mokodompit	0490	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
27835624-364d-45c5-9b46-360041590075	27835624-364d-45c5-9b46-360041590075	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	b255e348-4b76-11e5-8241-13af4f7fae26	Gery Sulaeman	0505	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
a67259e2-77b2-481f-b0c7-a2eb70591125	a67259e2-77b2-481f-b0c7-a2eb70591125	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a431941b-0f77-4479-b019-664a1fffd1e6	56fbd12f-009d-4448-b9ce-76e42ea92a41	SRIFADILA MOKODOMPIT	0680	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
1b94e5bb-7be1-4c54-a26e-1c5255d800f7	1b94e5bb-7be1-4c54-a26e-1c5255d800f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a431941b-0f77-4479-b019-664a1fffd1e6	d861e66d-279b-41ba-9f4b-f32031a86a79	Baso Fadil Muhammad	0662	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
7be60eb8-b497-40fb-a3bd-eeec408cd4e8	7be60eb8-b497-40fb-a3bd-eeec408cd4e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d48856fb-ab4b-442d-b8bf-9d3a342e22df	fc887591-cc90-441b-ab14-7f04d4488c3b	Eko Londa	0631	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
15c330aa-d432-4efb-be21-5948d3529080	15c330aa-d432-4efb-be21-5948d3529080	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d48856fb-ab4b-442d-b8bf-9d3a342e22df	d17acbd0-7f5c-4fb0-9fa7-bd34886d0788	Riklan Gelu	0625	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
3b6ed878-7a18-40be-a408-3e45abf1af7d	3b6ed878-7a18-40be-a408-3e45abf1af7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d60144a2-508e-44d2-91ab-906e5e0c636b	1c94fedd-9703-e211-b291-0143ed05e022	Krisfan Hardo Makawimbang	0626	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0e72d592-dac9-4ef3-a011-e406e6415ae7	0e72d592-dac9-4ef3-a011-e406e6415ae7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d60144a2-508e-44d2-91ab-906e5e0c636b	6ef941cd-f503-e211-a8c9-8de20f7d3878	Melki Rapar	0639	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
132aef6d-f148-47fa-b1d9-6c05d5957d24	132aef6d-f148-47fa-b1d9-6c05d5957d24	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d60144a2-508e-44d2-91ab-906e5e0c636b	a162a212-58ef-41b2-b66d-93490bd5fafc	Gempa Saputra Ismail	0632	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0b0f5409-6727-40c0-b71b-9f5a42fc3d13	0b0f5409-6727-40c0-b71b-9f5a42fc3d13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d60144a2-508e-44d2-91ab-906e5e0c636b	bfc8b844-394c-48b0-b8a5-27643ae71c6f	RINDILIA MODEONG	0635	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
6dc0f7ca-7ce3-4efb-8320-efa1df6cc39e	6dc0f7ca-7ce3-4efb-8320-efa1df6cc39e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce400727-0d66-458e-811d-1beb471ab239	6df32bef-552b-4207-aa57-7d7bada64586	Jois B. Minggu	0702	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
9ebe0fd4-2940-43f4-ae48-b65398b8d663	9ebe0fd4-2940-43f4-ae48-b65398b8d663	39f5eb74-4722-4aaf-a6af-2c6e972e5885	29e9d84a-2d0f-463b-9cb1-4a32e193eed8	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	Dini Angraini Manongko	0370	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
8bdd556a-b892-4ce6-8a4e-20d7f8a91b06	8bdd556a-b892-4ce6-8a4e-20d7f8a91b06	39f5eb74-4722-4aaf-a6af-2c6e972e5885	29e9d84a-2d0f-463b-9cb1-4a32e193eed8	b35c01a3-37d8-4b9c-921d-65a382a1ca70	Joel Marky Ngantung	0367	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
dd9b254e-68af-4bec-bc6f-f73fa3295401	dd9b254e-68af-4bec-bc6f-f73fa3295401	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3cdfa40f-f3f8-4f33-a2da-9c26eec0d493	72d18334-3b06-11e4-a3a4-13507c2a0677	Mochamad Fathur Mamonto	0488	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b783da42-e7ce-4908-8f46-0c1b4b891e3e	b783da42-e7ce-4908-8f46-0c1b4b891e3e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	11558ce2-46ca-11e5-8ba3-b7381d40fb27	Meilati Mandagi	0486	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
a4acb8a5-5f0f-4ae3-b67e-4abe8f175910	a4acb8a5-5f0f-4ae3-b67e-4abe8f175910	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3adcc08e-b7b6-4486-8723-1c080458c8e2	5e200dc4-4b76-483f-8e7f-e26c92431c3e	Ersa Somsombera	0658	1	2023-02-14 08:52:36	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
14adf783-ebec-483a-8944-1d854275c002	14adf783-ebec-483a-8944-1d854275c002	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	PRITI SAMBALI	0358	1	2020-02-17 14:01:20	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
1fae597f-3268-43e6-9646-920491bd8f40	1fae597f-3268-43e6-9646-920491bd8f40	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	8b4ea31e-4aa0-427e-a65f-928b232d7f14	Oktafiani Tinangon	0382	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a86bc41a-99cf-4856-b152-5763a5d94b21	a86bc41a-99cf-4856-b152-5763a5d94b21	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	da2e3e30-22ee-11e4-90f6-53330a5cd670	FIQIH ADE SAPUTRA WAKARI	0479	1	2020-02-17 14:01:20	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2a801314-6878-4c65-b666-4034d50202c9	2a801314-6878-4c65-b666-4034d50202c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2e95354f-cfbb-4e4f-a8f8-85de1df1118a	9b057256-628e-4516-a951-a78bd3651d4b	BASO ASRAF SAPUTRA MARALA	0428	1	2020-02-17 14:01:20	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
953b859e-baf1-4bf5-bfa6-a1a013c9d515	953b859e-baf1-4bf5-bfa6-a1a013c9d515	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	6a26772d-e188-455a-8bd8-9c8d729a618e	Izmiranda Octavianty Mantik	0384	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2d564b73-789f-4df9-8800-9f4798b993c4	2d564b73-789f-4df9-8800-9f4798b993c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	d313aa86-3092-4ceb-8e53-fabcecc2a37a	Andreyansah Pratama Putra Pertama Sarundayang	0354	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
43e9dd9c-a5b7-45ab-a724-cd7882757421	43e9dd9c-a5b7-45ab-a724-cd7882757421	39f5eb74-4722-4aaf-a6af-2c6e972e5885	33d132e0-b8ad-477e-b46b-a300af544e5b	37dd7c39-5a77-4fb3-8bf4-31fe5f545da1	Siti Hardiyanti Putri Mamonto	0332	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
ea7fd47c-f9f0-4d11-b345-5938bb208b84	ea7fd47c-f9f0-4d11-b345-5938bb208b84	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd00c421-6c17-4499-9304-b6a1b954c97d	81ed9f12-dc17-4947-aeaa-5105be4af095	Depi Mokoagow	0374	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
7bd5d926-e4cb-40d2-b00f-9c50fcb30ba8	7bd5d926-e4cb-40d2-b00f-9c50fcb30ba8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd00c421-6c17-4499-9304-b6a1b954c97d	9c4c0c10-b8da-414e-8da3-ea55711fb000	Awliya Mamonto	0371	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
3cf4ba81-0164-4779-84ae-961fa6ab79bb	3cf4ba81-0164-4779-84ae-961fa6ab79bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd00c421-6c17-4499-9304-b6a1b954c97d	1f6639a7-562e-44f9-b1c8-a98935a9193c	Afandi Molongio	0440	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
6a7cb8df-cecc-4637-911a-1c255dcea65a	6a7cb8df-cecc-4637-911a-1c255dcea65a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bd00c421-6c17-4499-9304-b6a1b954c97d	26daca7f-056a-4e55-a49a-4469004944ec	Deli Astuti Tampi	0350	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
6af717f2-7767-45f4-a826-84a5bffcc1c4	6af717f2-7767-45f4-a826-84a5bffcc1c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	31d87dba-8af0-48a5-a609-901bda9031d3	Nick Diaz Rafli Bororing	0439	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
8d7d3795-fea6-40fd-997c-7ee493e6e5f3	8d7d3795-fea6-40fd-997c-7ee493e6e5f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	54894cf6-ecf9-44c5-87e8-b87e6bf62120	Estevania Tasya Rumondor	0376	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
47a1a6f0-41d9-4536-a06d-6aa76ce01ee3	47a1a6f0-41d9-4536-a06d-6aa76ce01ee3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	5b61121a-264f-490f-86b1-551372be86d1	Dhify Bonita Pade	0389	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
5cb2ec6b-afb0-474d-82e0-3a801d6958c6	5cb2ec6b-afb0-474d-82e0-3a801d6958c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	Magfira Mamonto	0334	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
da63a715-ba10-4438-bb32-d534d5a3d71b	da63a715-ba10-4438-bb32-d534d5a3d71b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	cf3761de-7aae-48d8-aec8-088c3e87e8ed	Safa Tasya Camila Paputungan	0441	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
55305064-1566-4844-bca4-bf6d13a46bba	55305064-1566-4844-bca4-bf6d13a46bba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	4e27de9b-f65a-489f-8db8-7a6cb724fa6f	Reihana Putri Badhar	0407	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
9437050a-e3f0-4a54-8c2c-9a9ec0b43fdf	9437050a-e3f0-4a54-8c2c-9a9ec0b43fdf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	47b6caa2-713f-4131-aa37-8b889233f355	2a0784f4-94ee-435b-8fb3-8c798d15d817	Richardo Delvasten Maramis	0330	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
55184b24-6035-4fa0-801f-7671601d0dd4	55184b24-6035-4fa0-801f-7671601d0dd4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	ac0343f2-09a5-4b95-b38f-cd379433d96c	YULANDI SYAHPUTRA MANDAGI	0529	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
15a912cf-1948-478a-988a-cbc5aafae452	15a912cf-1948-478a-988a-cbc5aafae452	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	c7a20e10-51e9-11e5-9503-af6d1e3f4589	Siti Hadijah Tahib	0532	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
37228b9a-200b-4e67-8dcf-5e87831ab5e5	37228b9a-200b-4e67-8dcf-5e87831ab5e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	540161f2-51dc-11e5-ada1-57cb00fd65d6	Lastri Paputungan	0612	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2a9289c1-2d5d-46ef-ae68-37c14acd5878	2a9289c1-2d5d-46ef-ae68-37c14acd5878	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	ad705d8a-429e-11e5-a989-af44a02d940a	Asi Cia Tiara Toly	0455	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
1daeb274-2cdd-4ccb-a129-a690664fd484	1daeb274-2cdd-4ccb-a129-a690664fd484	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	6402418c-54f9-11e5-9e54-5397b782050d	Livianti Hamja	0497	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
83b08fdb-027e-4a18-9dcd-dc7ae26fa439	83b08fdb-027e-4a18-9dcd-dc7ae26fa439	39f5eb74-4722-4aaf-a6af-2c6e972e5885	08d51f0c-cf8e-4111-9c52-b1adaf85863c	67390022-7626-4bf5-a07f-1f5dd137f72e	Andika Malehati	0432	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
94ad9ae2-8bff-424b-94ca-720478d37056	94ad9ae2-8bff-424b-94ca-720478d37056	39f5eb74-4722-4aaf-a6af-2c6e972e5885	08d51f0c-cf8e-4111-9c52-b1adaf85863c	06555036-10af-41b8-b767-260f6d366218	Adinda Meilina Kobandaha	0377	1	2019-12-11 14:13:29	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
b9039043-e048-42dc-93f2-45d8edfb00cf	b9039043-e048-42dc-93f2-45d8edfb00cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	08d51f0c-cf8e-4111-9c52-b1adaf85863c	3e20af19-c84c-4fb4-9326-a47a5a8087c1	Indirahmawati Mamonto	0337	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
36f23a7f-3abe-4f74-82f2-aad7442fa004	36f23a7f-3abe-4f74-82f2-aad7442fa004	39f5eb74-4722-4aaf-a6af-2c6e972e5885	08d51f0c-cf8e-4111-9c52-b1adaf85863c	fd2e81be-ca4c-4320-9549-82c37f311556	Julita Elsavira Suak	0442	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
b187f223-a45a-4be6-854d-b17f4bbabc4b	b187f223-a45a-4be6-854d-b17f4bbabc4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aba8225c-0761-4ca2-a185-4cc938f27ef1	074f93b5-b14c-43a4-9b32-ffa1f94d5238	Febrinia Gloria Wongkar	0629	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
7a7baef6-3b82-4c9b-bdf6-54a836462c17	7a7baef6-3b82-4c9b-bdf6-54a836462c17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aba8225c-0761-4ca2-a185-4cc938f27ef1	7df870be-f674-4ed1-bf50-340cbfdc845a	Fahrial Ginto	0688	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
734bf883-f7ad-4db3-bfba-468b202a44ab	734bf883-f7ad-4db3-bfba-468b202a44ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c413294-97a9-4966-ab50-3ca30ad7e3b0	542df659-4377-411d-9fa8-1f5ce8878479	CANDRA FEBRIAN MOKOAGOW	0589	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
99dcc358-4769-477b-8878-01d50f6811c5	99dcc358-4769-477b-8878-01d50f6811c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c413294-97a9-4966-ab50-3ca30ad7e3b0	17e8de1b-c527-e211-963e-ffbc9c164446	FIZRA MAMONTO	0657	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
758f6f40-e828-4410-ae37-311897c24f9b	758f6f40-e828-4410-ae37-311897c24f9b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1c413294-97a9-4966-ab50-3ca30ad7e3b0	374d54fa-9d39-4cec-99c8-b405824d8696	MUHAMAD RAMDANI MANYO	0660	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
e0a7846d-9528-4a4a-9b81-0014b84792d7	e0a7846d-9528-4a4a-9b81-0014b84792d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3adcc08e-b7b6-4486-8723-1c080458c8e2	0ed24a94-592d-11e5-8142-4f45aea730e6	NIKEN MARSELINA DALUGHU	0669	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
c0231b26-c643-44f6-98a6-6faa5b2d50ff	c0231b26-c643-44f6-98a6-6faa5b2d50ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3adcc08e-b7b6-4486-8723-1c080458c8e2	14f34d04-bb92-4cf1-bb11-5e424fa98ae7	ZAKIRA BULUDA	0665	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
89bc5ea7-bb5a-4124-86ca-69fef07ba30e	89bc5ea7-bb5a-4124-86ca-69fef07ba30e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3adcc08e-b7b6-4486-8723-1c080458c8e2	210fde58-74aa-4ea9-a4e4-ab32b37448b1	Rahib Idris	0655	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
854aad5d-203a-4ba6-8538-43ed8433ea29	854aad5d-203a-4ba6-8538-43ed8433ea29	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce400727-0d66-458e-811d-1beb471ab239	7bd0404c-9603-e211-b291-0143ed05e022	Julio Josua Lombok	0623	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
306903cd-e544-4879-b877-0a77432fe558	306903cd-e544-4879-b877-0a77432fe558	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ce400727-0d66-458e-811d-1beb471ab239	7c15fbb2-33c9-4ba2-93a4-b9d988e939b4	VALINA ANGGRAINI MALETENG	0687	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
9be08f0d-905d-4938-9db5-1f92b4a6d9a1	9be08f0d-905d-4938-9db5-1f92b4a6d9a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	b32063b6-462b-11e5-9585-133f160aafbb	WAHIDA SANTURIA WIDIAWATI MOKOAGOW	0527	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
5fa5194f-011d-4254-a171-cbc8fd52a1dc	5fa5194f-011d-4254-a171-cbc8fd52a1dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	b5b764d4-4c3f-11e5-9257-b3688b89f32b	YUNIARTI MOKOGINTA	0528	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
5d4479d7-f205-424f-a446-189fdf3e9e52	5d4479d7-f205-424f-a446-189fdf3e9e52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	edbf1ed9-b137-4d28-8af1-a22ab23be53b	RANDI HARI	0508	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f978d787-1080-4da5-930f-c8228c5dea89	f978d787-1080-4da5-930f-c8228c5dea89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	e131badd-15c9-4911-8c81-1d30249b7d73	FIRNA KIRANA MODEONG	0483	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
9800c58f-be2d-48eb-9632-aa125c2ea7d7	9800c58f-be2d-48eb-9632-aa125c2ea7d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	54976902-8866-4627-a970-0abcb6abb6f9	MARSELI MAMONTO	0391	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a2d99acf-4e88-4f9e-bcbc-8b73719dacc6	a2d99acf-4e88-4f9e-bcbc-8b73719dacc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	079a34b8-4b76-11e5-814d-b3ab2368e254	ANDIKA MAKALALAG	0452	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
7573c8c3-6975-4358-aff2-339852f23584	7573c8c3-6975-4358-aff2-339852f23584	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	1f87026c-1601-4eb9-9b82-64289bded8ed	WAHYUDI MOKODOMPIT	0357	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
c632bb65-bfde-419c-a36d-1f73b42fb40a	c632bb65-bfde-419c-a36d-1f73b42fb40a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	7661d6a5-1907-41fd-8c82-a5fea385fef8	MUHAMAD REIZA GUMALANGIT	0423	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2beec7a0-d056-4d8d-98c5-0c93b0cc9d7c	2beec7a0-d056-4d8d-98c5-0c93b0cc9d7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	607b1b72-46d2-11e5-ba50-1375139e8458	IBNU AZIF MOKODOMPIT	0490	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
8afe0364-f3e0-4230-beff-111c15938280	8afe0364-f3e0-4230-beff-111c15938280	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	TIARA FITRA MAKALALAG	0520	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
f4b786ee-45ed-4dc8-b008-70d2568a7c65	f4b786ee-45ed-4dc8-b008-70d2568a7c65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	dff2a0f4-5123-11e5-8831-73515c7ac634	Fitri Tegela	0613	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
e2deffee-bc52-4172-8c40-e21bc9ab256d	e2deffee-bc52-4172-8c40-e21bc9ab256d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	93853854-479a-11e5-8f29-97b6ab3d09e1	YOVNI YOLINA HARI	0531	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
fa5ceef7-f7bb-4012-b45e-6a042d5bf608	fa5ceef7-f7bb-4012-b45e-6a042d5bf608	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	DENNA BANGKIL	0464	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
61dfdc41-102e-4b4b-99bc-65cafb34d2ca	61dfdc41-102e-4b4b-99bc-65cafb34d2ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	91317e32-9ec9-468c-bf5b-ef891856d180	Febiyola Aknes Narsiso Tine	0609	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
e76f0697-2a49-4d23-8bed-3b68339ed0d2	e76f0697-2a49-4d23-8bed-3b68339ed0d2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	9833a660-4b73-11e5-934e-37a2f6ed830d	FADILA PALOHON	0474	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
8b5719d3-a090-496e-ab6a-1e47fd139415	8b5719d3-a090-496e-ab6a-1e47fd139415	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	TIARA PAPUTUNGAN	0522	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
887bdf1b-f07b-42ed-af8a-116c798cd40f	887bdf1b-f07b-42ed-af8a-116c798cd40f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	2e534eee-4290-11e5-9525-d72625153a3d	TARISSA MAMONTO	0519	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
d65222e5-0853-4513-9013-0d8c66da01ad	d65222e5-0853-4513-9013-0d8c66da01ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	88c6acc3-882c-418e-b96e-f83ccccd7f79	NIRA DIANA BULUHARI	0501	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
046537b7-554f-497b-8538-90a963b36863	046537b7-554f-497b-8538-90a963b36863	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	NETA PAPUTUNGAN	0500	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
488157fc-b2da-4ee2-9349-07dddd4eedca	488157fc-b2da-4ee2-9349-07dddd4eedca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	08d51f0c-cf8e-4111-9c52-b1adaf85863c	3ad03a6a-9caa-40e4-a060-62e1680cd17b	Loviana Hamjah	0364	1	2019-10-29 19:28:18	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
d380c4e1-1573-44a9-b01c-7a0628ce4463	d380c4e1-1573-44a9-b01c-7a0628ce4463	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2bf91fd6-c730-4c6e-9268-761cf11ea097	0e3ca3aa-8e03-e211-8560-17962475f905	Frisilia Meysi Lumintang	0624	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
51319b72-2662-4ab3-b49f-fd0d1f0b6cd1	51319b72-2662-4ab3-b49f-fd0d1f0b6cd1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0310f43c-3e8f-404d-be3c-816746a737e0	edf2c1a4-2d1f-471d-8e72-eb63959b5b64	ALFIRA DALERO	0670	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0196767d-1ee1-43a7-9fda-665b3b589e0a	0196767d-1ee1-43a7-9fda-665b3b589e0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aba8225c-0761-4ca2-a185-4cc938f27ef1	7a13c707-8f03-e211-8560-17962475f905	Teisya Yulingkan Yeye Oroh	0642	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
01ba5098-4172-48e2-9896-7a25a6252143	01ba5098-4172-48e2-9896-7a25a6252143	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aba8225c-0761-4ca2-a185-4cc938f27ef1	9433b08e-fac0-4a20-9d42-684e7aced3c6	Sriwulan Palengkahu	0641	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
af9a307d-a501-4447-b00d-9cd906f8cf35	af9a307d-a501-4447-b00d-9cd906f8cf35	39f5eb74-4722-4aaf-a6af-2c6e972e5885	aba8225c-0761-4ca2-a185-4cc938f27ef1	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	FORLIN LUMISANG	0684	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ce80348b-6cff-42f5-8f7a-49e45e515245	ce80348b-6cff-42f5-8f7a-49e45e515245	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	ba02677d-8acd-e211-b8a5-d12bb761bc4d	Nazra Baswan	0676	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
b85a51b3-6933-419a-9580-34020edb6c9e	b85a51b3-6933-419a-9580-34020edb6c9e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	bed2e326-06e7-4698-94d5-d46efc825014	Mohamad Furqan Mokodompit	0647	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
76ba795a-e236-4599-a00b-96bb72230281	76ba795a-e236-4599-a00b-96bb72230281	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	eb492e22-77fd-e111-8da8-f1648fe48442	NANDITA ARBI	0653	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
351b0ae6-d285-4fba-86f0-bf50835def7e	351b0ae6-d285-4fba-86f0-bf50835def7e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	d6da0950-f65b-47d2-9965-579b90b08ffd	Wahyu Hidayat Paputungan	0643	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
2dabb775-44f8-4c3f-9ea0-03098fd20535	2dabb775-44f8-4c3f-9ea0-03098fd20535	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	a80be64e-5393-49df-a6f7-8a18736444a1	Sakina Damopolii	0644	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
fcaf29b0-2bb1-40db-baef-44ac8f5be656	fcaf29b0-2bb1-40db-baef-44ac8f5be656	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	Nabila Rezqika Potabuga	0648	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
c8e0e2f1-9cd4-4d0a-a598-fd70b0909c46	c8e0e2f1-9cd4-4d0a-a598-fd70b0909c46	39f5eb74-4722-4aaf-a6af-2c6e972e5885	f8beba62-1e88-4daf-a251-5372eaf2a6fd	a091930a-1616-468a-861e-0a2e079f2b58	MIRANDA RINU	0651	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
f4973a55-a4de-45bc-a272-bf71b00c1065	f4973a55-a4de-45bc-a272-bf71b00c1065	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3dfebd13-2a41-44dc-89e6-e354354c43cb	ffa42521-4f5a-4d0a-8efd-f4dc24fe7f45	Baso Adrian	0663	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0db6a468-c2e7-4d96-9226-0f71d4275e2a	0db6a468-c2e7-4d96-9226-0f71d4275e2a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3dfebd13-2a41-44dc-89e6-e354354c43cb	f530a57f-1b10-e211-9570-4d846480b264	Dilfan Samuel	0671	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
316bf782-6423-423a-ae01-634f7e3698db	316bf782-6423-423a-ae01-634f7e3698db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a60210af-b48d-4105-aadf-ec685007dc91	46b37dc1-e927-e211-86f9-79cd2fac9006	ZLATAN I KOBANDAHA	0666	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ae3bbb64-4ebd-4081-b2ac-3275f8cbaf97	ae3bbb64-4ebd-4081-b2ac-3275f8cbaf97	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a60210af-b48d-4105-aadf-ec685007dc91	e98a52c9-013b-4a3d-aeaa-a3738ed9ec63	Sukarti Tilaar	0659	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ed14d445-8650-454f-a2ee-32b2fb46ae5d	ed14d445-8650-454f-a2ee-32b2fb46ae5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4872fa65-f563-4f6a-a971-5be74caf5b14	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	GABRIELA VIRGINIA MICHELLE MANSALEO	0638	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
efed0e70-3750-44f2-9584-9624cd534318	efed0e70-3750-44f2-9584-9624cd534318	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4872fa65-f563-4f6a-a971-5be74caf5b14	ae2a025b-c727-e211-963e-ffbc9c164446	Sarmila Luminu	0620	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
4cc0bc96-6467-47b3-8a2c-5c9eb3683b6d	4cc0bc96-6467-47b3-8a2c-5c9eb3683b6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8fcd23ba-a9ad-4801-9bfa-06b7f1057b5d	667a149e-7929-e211-ab63-417b9cc965f1	Revalina Ukkas	0618	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
34ec0096-ab8b-4b18-8df4-f1e94dc75efe	34ec0096-ab8b-4b18-8df4-f1e94dc75efe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8fcd23ba-a9ad-4801-9bfa-06b7f1057b5d	b0c37ebb-2fd5-4fc2-883e-267cdb7c8942	WIDYAWATI MAMONTO	0656	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
32e7a217-dff0-4def-b3ac-cc4635664313	32e7a217-dff0-4def-b3ac-cc4635664313	39f5eb74-4722-4aaf-a6af-2c6e972e5885	8fcd23ba-a9ad-4801-9bfa-06b7f1057b5d	3b0b4884-726c-4551-9f8c-3db4d502c5f4	Nanda Makalunsenge	0650	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
e8d6c0d7-0fa2-4e9b-a6ca-90b49a8d6647	e8d6c0d7-0fa2-4e9b-a6ca-90b49a8d6647	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e8487724-fe1a-4b7c-b7b5-9aa959c83e41	f4dc7769-10f3-474c-9bad-a7f651d71321	RABILFA MOKODOMPIT	0678	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
9216572e-7a80-4bac-b602-cd2c2b6b7123	9216572e-7a80-4bac-b602-cd2c2b6b7123	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e8487724-fe1a-4b7c-b7b5-9aa959c83e41	ea745b98-c427-e211-963e-ffbc9c164446	Widia Mokodongan	0681	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
0b6b7a60-1958-4160-84c8-2ae4fef15d25	0b6b7a60-1958-4160-84c8-2ae4fef15d25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e8487724-fe1a-4b7c-b7b5-9aa959c83e41	b7636c46-2593-4792-968d-5432f3f28fa7	MARGARETHA AGU	0674	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ba44ea67-963a-4837-a776-68629387e03a	ba44ea67-963a-4837-a776-68629387e03a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e8487724-fe1a-4b7c-b7b5-9aa959c83e41	73c986dd-4bfe-4a05-844b-00d385e21864	Afdal olii	0617	1	2023-02-14 08:52:36	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
dbc86518-79d0-4ed0-a63b-041c4aa4d6ed	dbc86518-79d0-4ed0-a63b-041c4aa4d6ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	b7b48546-4541-11e5-b9f9-e7e850efd101	MUHAMAD JUHRI SOMSOMBERA	0496	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
8b87733c-971e-4a98-8434-e6e3bb7e28b7	8b87733c-971e-4a98-8434-e6e3bb7e28b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	FALDY RENALDI MOKODOMPIT	0475	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7fe78533-1552-41d2-b934-568c8e3f5f96	7fe78533-1552-41d2-b934-568c8e3f5f96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	a16778e6-fe58-40af-a29b-6c47664d4064	MEGA RUNTURAMBI	0561	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
1b145f9c-9889-4f08-b4a1-46ffe21c4607	1b145f9c-9889-4f08-b4a1-46ffe21c4607	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	4e3a22a4-98e9-4024-a519-7a05be9167c8	MEILINDA KUNONNDO	0562	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
fab60dce-6e58-4c80-aac7-5f0004e6bace	fab60dce-6e58-4c80-aac7-5f0004e6bace	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	bd3a2d69-e9b5-4462-9057-eb4b035b297d	Sahril Tewuh	0608	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7a7e0d40-c987-48ab-aa9e-4077d36e9485	7a7e0d40-c987-48ab-aa9e-4077d36e9485	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	Apriansyah Laoh	0573	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
0880654f-0790-4dc6-b29d-cbaeee4affef	0880654f-0790-4dc6-b29d-cbaeee4affef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	906376c2-1463-4361-897e-a7ef5a19239d	FIZINIA MANDOLFO	0578	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
bea910c4-80c9-460e-88dc-6ebdd40503a9	bea910c4-80c9-460e-88dc-6ebdd40503a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	7dbbb577-7b93-48ef-b139-db84e9163597	GIAN ANANTHA LUTHER RONDONUWU	0579	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
59096f40-3e4a-4a7d-9ebc-579412084053	59096f40-3e4a-4a7d-9ebc-579412084053	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	645aba46-378c-11e4-a83f-afbd60abf5c3	Willyanto Fernando Dawid	0586	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
32cf1c32-9ad4-4d0e-8fc2-1b28afa4141f	32cf1c32-9ad4-4d0e-8fc2-1b28afa4141f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	MEILANI GARA	0582	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b5d47a2f-7977-46a8-a2e0-ab298985af24	b5d47a2f-7977-46a8-a2e0-ab298985af24	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14042a19-7bf2-496e-8888-e9c191d38053	11aea642-466b-11e5-886c-1b8856809555	NUR AZISAH AZIS	0611	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
c4717798-071d-4358-8847-756a7d4f5eaf	c4717798-071d-4358-8847-756a7d4f5eaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14042a19-7bf2-496e-8888-e9c191d38053	e9cef568-2ada-4e64-b69f-00c23c5d8604	Iswandi Mokodompit	0595	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
960d4132-7fda-49dd-84b3-e05ad6625915	960d4132-7fda-49dd-84b3-e05ad6625915	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf55e85b-d07e-4ec2-9519-d2dbb887840e	d1de7680-727c-4931-a9c8-1cc3a384a7c5	SINTIA SESILIA KUMESAN	0570	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
0d5da581-227b-4433-8b29-b0d82ac31655	0d5da581-227b-4433-8b29-b0d82ac31655	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf55e85b-d07e-4ec2-9519-d2dbb887840e	ea363a5f-9119-468b-8fea-9187ba92c13e	MEYJIRA MAKALALAG	0563	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
5e1a46ab-a264-40ad-8562-919a9ea9322a	5e1a46ab-a264-40ad-8562-919a9ea9322a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf55e85b-d07e-4ec2-9519-d2dbb887840e	3ee043f8-9893-11e5-911a-5f12b6406080	INDRA MAMONTO	0492	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7fb50761-620a-470b-b6d9-1e65dcd372fc	7fb50761-620a-470b-b6d9-1e65dcd372fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf55e85b-d07e-4ec2-9519-d2dbb887840e	8e480efa-b4ae-4ecb-8b21-1ad77d82eb6d	HAPIPA TAHIR	0489	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
875da19a-9c2c-40ae-95a9-f0b7bd617445	875da19a-9c2c-40ae-95a9-f0b7bd617445	39f5eb74-4722-4aaf-a6af-2c6e972e5885	cf55e85b-d07e-4ec2-9519-d2dbb887840e	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	Anisa Abas	0556	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
42224f0f-1936-4b1b-be15-52d0445f5302	42224f0f-1936-4b1b-be15-52d0445f5302	39f5eb74-4722-4aaf-a6af-2c6e972e5885	72b3a090-53e3-4c69-a917-13c239b38f59	2344b81a-f727-41d0-bdcf-b4fbc2557e5b	Revansa Kadengkang	0602	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
24e336ee-a3bd-43e6-980e-3503e1c83245	24e336ee-a3bd-43e6-980e-3503e1c83245	39f5eb74-4722-4aaf-a6af-2c6e972e5885	72b3a090-53e3-4c69-a917-13c239b38f59	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	Novandri Gaghiwu	0599	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
c0072260-46f3-4677-8544-fd611c1bc5c2	c0072260-46f3-4677-8544-fd611c1bc5c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05f15623-c39e-40aa-83f4-a73f4dcf96ad	0494c011-fd20-411c-b6f3-022d10cfb1b4	Adrian Tumelap	0587	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
600159c5-1934-49db-8036-c1eb13e2d202	600159c5-1934-49db-8036-c1eb13e2d202	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05f15623-c39e-40aa-83f4-a73f4dcf96ad	d28672c2-c5a5-4238-a802-fd30f1f8341d	Witari Simbala	0606	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
7d55cb25-b9f6-433f-a62f-8855bd731c9b	7d55cb25-b9f6-433f-a62f-8855bd731c9b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	05f15623-c39e-40aa-83f4-a73f4dcf96ad	8e10391f-07fe-41b9-84c7-106974b83db3	REVANSA PANGALIMA	0603	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
ccbe2d99-1a80-462e-b614-f0bdd96b77be	ccbe2d99-1a80-462e-b614-f0bdd96b77be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	EKA FAJARANTI MODEONG	0467	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
f47a964a-aacc-4598-a695-e1af898c30e4	f47a964a-aacc-4598-a695-e1af898c30e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	REYGI MOKOGINTA	0509	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
f6be1de9-8acf-451b-87d7-dd73a3373a32	f6be1de9-8acf-451b-87d7-dd73a3373a32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	808f4853-72f6-44e9-8555-4e07f494c8cf	RUSDIN KARLOS	0614	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
c4b14611-788b-4cf6-a03c-91e4e88580a2	c4b14611-788b-4cf6-a03c-91e4e88580a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	FAUJI SONDAK	0537	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
efaf45b1-49c4-4268-9dfe-9b9efd6ac328	efaf45b1-49c4-4268-9dfe-9b9efd6ac328	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	8462527e-862e-4b54-b09b-a9c99a9f276d	MARTSYANDA AMELIA LAHIJUN	0544	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
ac1483a7-a064-464e-be0d-6a69231c5547	ac1483a7-a064-464e-be0d-6a69231c5547	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	304a3c38-bda8-4b1f-b2ef-087817e35993	NOVIA LAMBEY	0547	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a4aa6172-6aca-4936-be42-17c070ec5763	a4aa6172-6aca-4936-be42-17c070ec5763	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	994e91c4-854b-4fe0-946c-0133e4582398	MEILANY CHRISTILIA LOHO	0545	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
fe99c2c4-b0cd-42d0-a7f8-02815b7e1f1d	fe99c2c4-b0cd-42d0-a7f8-02815b7e1f1d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	Serlita Patriayani Bahansubu	0555	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
61c99a55-1a98-41aa-bb44-d0edb6cb22e1	61c99a55-1a98-41aa-bb44-d0edb6cb22e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	7033d6a0-a087-4922-a949-32763edc8bc4	NURMILA PAPUTUNGAN	0550	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
5c9875da-15e4-4309-a49a-b4948dca4b92	5c9875da-15e4-4309-a49a-b4948dca4b92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	4dbcf03d-8516-4f9c-a25f-679ac14e766f	JOVITA MANONGKO	0540	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
70ab891f-9d8b-41e9-8f25-b64a77ebbc89	70ab891f-9d8b-41e9-8f25-b64a77ebbc89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	78027dc1-f7e5-434a-b0c3-767f331840bb	Nurfanisya Mokoagow	0549	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
da38aa7f-32d0-427a-ac8e-35dd68459ad2	da38aa7f-32d0-427a-ac8e-35dd68459ad2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	2f627335-3b69-4db3-94e3-0a43968e23e9	REIVAN KAMBEY	0551	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
3adf501a-4ab6-4fb2-a156-f01f80deddc0	3adf501a-4ab6-4fb2-a156-f01f80deddc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	cae987c8-810a-4d95-a5fb-27e3108961de	APRILIA PINGKAN LOLOWANG	0534	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a6e23500-4ff3-4865-9e40-0b66d163eb6d	a6e23500-4ff3-4865-9e40-0b66d163eb6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	efadf950-9060-45d1-a065-ddd9c87cd53f	SUTRI MOKODONGAN	0518	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
f946aa16-c51f-4ff7-a4e2-c0ba0a6253a1	f946aa16-c51f-4ff7-a4e2-c0ba0a6253a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14042a19-7bf2-496e-8888-e9c191d38053	5d16430e-fc2c-4850-bbd6-dda5bfdae36f	FIRGIANTO KARTOREJO	0592	1	2021-10-26 09:36:57	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
4eeeef9d-6003-46da-8a20-b7e0f47c65ee	4eeeef9d-6003-46da-8a20-b7e0f47c65ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	b7d6d3f4-77ae-41df-8c21-56e8731513a1	LYRA VINA PANTOW	0560	1	2021-10-26 09:36:57	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
76c67e89-5852-46d8-b2bc-ad83210db34b	76c67e89-5852-46d8-b2bc-ad83210db34b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	14042a19-7bf2-496e-8888-e9c191d38053	39d012b6-b00a-4aaa-b389-0e15e420ad3a	ALIF LIGAWA	0588	1	2021-10-26 09:36:57	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
edad9224-6617-4914-a893-91592c4a8c62	edad9224-6617-4914-a893-91592c4a8c62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	ba02677d-8acd-e211-b8a5-d12bb761bc4d	Nazra Baswan	0676	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
2bd4155f-1d62-4074-926e-86382b62f8c5	2bd4155f-1d62-4074-926e-86382b62f8c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	eb492e22-77fd-e111-8da8-f1648fe48442	NANDITA ARBI	0653	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
fc216d37-fc22-44fb-a750-7c7a83f7a6a9	fc216d37-fc22-44fb-a750-7c7a83f7a6a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	Nabila Rezqika Potabuga	0648	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
a469c9de-ab56-4b33-8d28-ff1d20301f52	a469c9de-ab56-4b33-8d28-ff1d20301f52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	a091930a-1616-468a-861e-0a2e079f2b58	MIRANDA RINU	0651	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
6b9356ac-4638-4a45-aa6f-8fd37cf6921f	6b9356ac-4638-4a45-aa6f-8fd37cf6921f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	1438adc2-38fc-11e4-b641-3f0b3de385b4	Selawati Paputungan	0513	1	2021-10-26 09:36:56	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
03442b5c-263c-4312-9c98-3a94db245ac8	03442b5c-263c-4312-9c98-3a94db245ac8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	a5f73eaf-350d-41c0-8c11-6cba998499e3	MIRA HARIKAIA	0564	1	2021-10-26 09:36:56	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
56ac658c-9ce1-4051-b8c9-6759e626aa51	56ac658c-9ce1-4051-b8c9-6759e626aa51	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	2c1847a5-ae44-40e2-836e-cc566e0ed984	NOBEL YEREMIA RANTUNG	0598	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
003fc21d-a112-4d3d-be5c-8b89eb27f530	003fc21d-a112-4d3d-be5c-8b89eb27f530	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	0312c3d7-fde1-47cf-96ce-1f87a4228787	JEHAN SUGEHA	0596	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
cc315f54-893c-4fb4-803e-c75222a76221	cc315f54-893c-4fb4-803e-c75222a76221	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	MILKRI ANDEAS TANDAYU	0597	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ecfedc69-da89-4dcb-aa75-357976a4723d	ecfedc69-da89-4dcb-aa75-357976a4723d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	1e02ae8a-1e69-4e9c-a8c2-084b208eb8fb	Frendhy Sandro Saputra Pelealu	0615	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7e65e8f1-282e-49fc-8e1c-4eafc2dd04ef	7e65e8f1-282e-49fc-8e1c-4eafc2dd04ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	24bc9d5b-a4a1-42c9-b3eb-1f4f2114ea5a	afab5d0b-c4da-455e-bd0a-8644da49ab0f	MOHAMAD REZA MATOKA	0494	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
3bc3807d-b011-4630-aeae-3510d7c6a9fe	3bc3807d-b011-4630-aeae-3510d7c6a9fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	d993ad11-d98a-4803-85a4-a446d7b9d4c7	FAZRI BACHMID	0576	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
a9cdbc02-9f32-416b-bc8d-28e9ea1a1565	a9cdbc02-9f32-416b-bc8d-28e9ea1a1565	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	WALRIS POTABUGA	0585	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
a28fa229-b3ef-4e64-a80a-16fca1c6006a	a28fa229-b3ef-4e64-a80a-16fca1c6006a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	22160fc9-321a-40b5-849f-f8db354b9185	GUNAWAN ATUE	0580	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f3316f30-3204-415c-a74e-f43833b1285d	f3316f30-3204-415c-a74e-f43833b1285d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	Dimas Arlitahrizi Potabuga	0575	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
2dfe1a99-7d9b-4e4c-9a9e-c40ce1d8d13c	2dfe1a99-7d9b-4e4c-9a9e-c40ce1d8d13c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	06b71793-3a86-4c6b-9000-717dca267295	SURYADI PAPUTUNGAN	0584	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
59c02561-f3b7-4f8f-9c7e-b44ef843572c	59c02561-f3b7-4f8f-9c7e-b44ef843572c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	99f38034-4a28-11e5-a3b9-ff498a91b449	Diki Mamuko	0462	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ec2a9fa8-d477-467d-9ab5-ea65e521fd64	ec2a9fa8-d477-467d-9ab5-ea65e521fd64	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e15f58e6-2ab3-4723-b751-754a4df20efe	243b6119-e39f-4849-8fd0-218155575c5a	REVA DINDA CARLOS	0601	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
17f9df1f-60c0-498e-b29e-cf6805f6dcf8	17f9df1f-60c0-498e-b29e-cf6805f6dcf8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e15f58e6-2ab3-4723-b751-754a4df20efe	6ba43a51-d4b8-4b42-a964-915453deb56a	RADIT PUNUSINGON	0600	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
32277c00-62c4-464c-a2b5-4b2ea24a504b	32277c00-62c4-464c-a2b5-4b2ea24a504b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e15f58e6-2ab3-4723-b751-754a4df20efe	a968b612-4bac-11e5-bce0-9f0e431a474f	RIFALDI MOKODOMPIT	0511	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
17eb69f1-0007-43be-8f72-3c1918ae3ee4	17eb69f1-0007-43be-8f72-3c1918ae3ee4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e15f58e6-2ab3-4723-b751-754a4df20efe	d0dca4af-4472-4232-af75-aaabf7ca88e7	Wira Yuda Mokoagow	0605	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b289b582-7d32-44dd-8674-b0efad860f03	b289b582-7d32-44dd-8674-b0efad860f03	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	0ea06995-f218-4530-9b63-0b499a11b034	FERDI TANDAYU	0591	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ed40a86d-f364-415a-8807-c38577a716ee	ed40a86d-f364-415a-8807-c38577a716ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	6b90c3af-7174-47eb-8f5b-8f5500ccdefa	Naya Jeniper Rumengan	0701	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b41da15a-2953-4f63-8342-f6b8e3a04de4	b41da15a-2953-4f63-8342-f6b8e3a04de4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	6e12f9fd-e106-472d-8364-ce7da552e702	YULIANI PAPUTUNGAN	0607	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ca9136c6-91e6-45ad-9643-d3715c5c7548	ca9136c6-91e6-45ad-9643-d3715c5c7548	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	Donni Mokodompit	0590	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
30b1e9c5-1871-4492-8b05-9590e1b7132e	30b1e9c5-1871-4492-8b05-9590e1b7132e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	72b3a090-53e3-4c69-a917-13c239b38f59	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	Ibnu Sabil Katili	0594	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b8cbbc2e-3416-4edc-a2bf-331145acaaa8	b8cbbc2e-3416-4edc-a2bf-331145acaaa8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48805a93-a029-4ef0-9c90-94844b3a2af8	f80b678d-bb43-4915-9ef0-22b1d2320638	NURFATIN PAPUTUNGAN	0565	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
30ac694b-db37-455f-a358-28d64c31855a	30ac694b-db37-455f-a358-28d64c31855a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48805a93-a029-4ef0-9c90-94844b3a2af8	8cf66883-ebc1-473e-a01c-37925b2b2150	Randika Mokodongan	0566	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
725690f8-d9ac-41e1-b8d6-acb7ef4e2048	725690f8-d9ac-41e1-b8d6-acb7ef4e2048	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48805a93-a029-4ef0-9c90-94844b3a2af8	5132bbaa-b74f-4719-86b7-5cfe82b86531	JUNITA MANENGKE	0559	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b576bf10-9841-4ca2-96af-99106883547d	b576bf10-9841-4ca2-96af-99106883547d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48805a93-a029-4ef0-9c90-94844b3a2af8	7363a404-46e9-11e5-8413-7fabf05ee1fd	ANISA MAKALALAG	0453	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ba12ea67-d9f0-457c-81ec-837d58829962	ba12ea67-d9f0-457c-81ec-837d58829962	39f5eb74-4722-4aaf-a6af-2c6e972e5885	48805a93-a029-4ef0-9c90-94844b3a2af8	d57f4561-8cb1-42ae-940e-7943cdae287b	TEGUH PRAYOKO MOKODOMPIT	0572	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
716b254f-d606-445f-8bbc-3e32b977334e	716b254f-d606-445f-8bbc-3e32b977334e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	5fb28ec2-45dd-45c4-8021-0e597172c690	NADIA PUTRI PAPUTUNGAN	0546	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
fee2588d-232b-4ffc-acd4-b0e9cac72f7f	fee2588d-232b-4ffc-acd4-b0e9cac72f7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	1d2b0b00-23c4-4c1b-a956-a85ff7deb40b	Renata Patra	0552	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
e617c6e4-0903-46e5-8a7c-a938a48f2624	e617c6e4-0903-46e5-8a7c-a938a48f2624	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	097f5676-e6b8-4033-9b17-43eb6a4145bf	ARYA SARFUNIN	0535	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
24d05165-2c65-4583-b512-438de95d4fb8	24d05165-2c65-4583-b512-438de95d4fb8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	d5b3a578-1613-474e-865b-0a47f3a64167	Novita Gugul	0548	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
c393a19d-87a6-434e-83ff-17c673151932	c393a19d-87a6-434e-83ff-17c673151932	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	f59b1bb2-1e58-4760-b504-5ee5de14aba7	FATHURRAHMAN LASABUDA	0536	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
26d7bb5e-e2f0-4542-ae59-16e448d5f868	26d7bb5e-e2f0-4542-ae59-16e448d5f868	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	c60e92a2-99c2-4394-a48b-251540c8b96f	ADISTI MAMONTO	0533	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
120a6c40-4958-42b6-bfc0-0283dddcdef4	120a6c40-4958-42b6-bfc0-0283dddcdef4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	daa07555-dd3d-44da-856b-28f08ecd474e	REVALINA MATONENG	0553	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a1638ba5-5455-445e-adbb-f2bc68ccc50d	a1638ba5-5455-445e-adbb-f2bc68ccc50d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7ef4fd2f-b6e3-4cf4-b739-732ef1ec83e6	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	Juliana Radjak	0541	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
837e7844-d3d9-42c2-a54c-b535a65c772a	837e7844-d3d9-42c2-a54c-b535a65c772a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3e784c4-7659-4d18-a910-d371e6f8de3a	021d11bc-3d8a-11e5-b1d1-733403640dea	ALMA RIZKI YANI SITIAMANG	0450	1	2020-12-16 07:53:21	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
b3eb27f9-8fb3-465e-99a9-6ecfcf5e5e4c	b3eb27f9-8fb3-465e-99a9-6ecfcf5e5e4c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0aea6a66-9b4c-4a54-80ed-5b1a01b459b6	6207cf97-0d01-4dd6-ad87-d4327e455902	Wahyudi Abarang	0530	1	2021-10-26 09:36:57	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
6211bc83-c2da-4dc3-abea-3cd17e254699	6211bc83-c2da-4dc3-abea-3cd17e254699	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dc96c570-1818-4dff-b7cc-880a5de10070	625f5a62-03e6-4066-8186-2fd7a0189797	Ariski Mokoagow	0574	1	2021-10-26 09:36:57	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
66ab1074-2db2-473c-a3d0-c669d3ed024f	66ab1074-2db2-473c-a3d0-c669d3ed024f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	bed2e326-06e7-4698-94d5-d46efc825014	Mohamad Furqan Mokodompit	0647	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
3d9402f8-8bd9-4df3-b08f-128c5d2842d0	3d9402f8-8bd9-4df3-b08f-128c5d2842d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	d6da0950-f65b-47d2-9965-579b90b08ffd	Wahyu Hidayat Paputungan	0643	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
ff175c3a-159d-4b18-b696-52691ac67c4e	ff175c3a-159d-4b18-b696-52691ac67c4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	19213871-6df1-4c31-a68f-5eefcac5a982	a80be64e-5393-49df-a6f7-8a18736444a1	Sakina Damopolii	0644	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
c72a8f2a-3c56-4d4b-bfc9-5729a8af38a3	c72a8f2a-3c56-4d4b-bfc9-5729a8af38a3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	FORLIN LUMISANG	0684	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
4a46f692-4949-4ea4-a26a-77399fa8c7f9	4a46f692-4949-4ea4-a26a-77399fa8c7f9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	074f93b5-b14c-43a4-9b32-ffa1f94d5238	Febrinia Gloria Wongkar	0629	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
9fe48a47-df4c-47b0-b731-b05ffea6a8f6	9fe48a47-df4c-47b0-b731-b05ffea6a8f6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	7df870be-f674-4ed1-bf50-340cbfdc845a	Fahrial Ginto	0688	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
43a1ff1f-2ed9-42ab-9ce0-ca4ad67045e8	43a1ff1f-2ed9-42ab-9ce0-ca4ad67045e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	12e60bf2-fd26-4336-b45a-11afbe3a8193	14fba9a1-6ca4-4937-84e7-2a845d02897a	SINTIA SARI BINOL	0569	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b0758e3f-460d-41f1-b950-10bf77359ffe	b0758e3f-460d-41f1-b950-10bf77359ffe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	PINGKI PUILI	0507	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
62bb1ce4-be71-4e88-a576-c1f26cf26fe6	62bb1ce4-be71-4e88-a576-c1f26cf26fe6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	725bfbe9-b10c-4654-933b-90c5987c9aa3	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	NAZRA SIMBALA	0583	1	2021-10-26 09:36:57	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
755533cd-b0dd-495f-b804-bd5a4fc45ee6	755533cd-b0dd-495f-b804-bd5a4fc45ee6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	7b6763fc-6f9f-11e3-b017-03efaa0c94af	MOHAMAD DODI BISNUN	0491	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
56e735e4-6012-4f19-8ac0-c0a6d18b7af9	56e735e4-6012-4f19-8ac0-c0a6d18b7af9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	Virginia Vhonix Gloria Gaspar	0526	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
724f1085-6f21-4abd-b6df-f3eac157864c	724f1085-6f21-4abd-b6df-f3eac157864c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	bd4085a1-82ec-450b-9507-7924581dc0fc	MUHAMMAD RADIANSYA PAPUTUNGAN	0499	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ff9350c8-4c16-4eab-94c4-f6dccc54eaf5	ff9350c8-4c16-4eab-94c4-f6dccc54eaf5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	52ae8172-5750-4387-badd-79b17d2081aa	NURUL SALSABILA MOKODOMPIT	0503	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7d0cad6e-8aab-4fd9-a5d4-aeb1768c6e88	7d0cad6e-8aab-4fd9-a5d4-aeb1768c6e88	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	2704f9d0-22fc-11e4-859d-e78b145c39c9	RHOFIQ AMBARAK	0510	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
47fabb21-7dfe-43d1-a7f0-8a4108cda524	47fabb21-7dfe-43d1-a7f0-8a4108cda524	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	60c2ff20-4b6c-11e5-958c-b39420b5676f	DEYSI NATALIA PAPUTUNGAN	0461	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
851fcf7c-acf1-49a3-8c59-7b00bc8b0df0	851fcf7c-acf1-49a3-8c59-7b00bc8b0df0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	e7692714-42a9-11e5-a70e-2322869c051b	Marsela Mamuno	0498	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
841dee90-2d7f-4ce7-bf0a-33e007523dc0	841dee90-2d7f-4ce7-bf0a-33e007523dc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	26925a68-aab1-11e5-bde5-bb0a0689b68c	DANDI SINALAAN	0459	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
090e714f-c2fa-4a13-9d1e-24f82fdc94ab	090e714f-c2fa-4a13-9d1e-24f82fdc94ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	DELVENA MANANGKODA	0460	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
985e5e5d-d926-428e-98b7-232048db1899	985e5e5d-d926-428e-98b7-232048db1899	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	c593fef2-46d2-11e5-b14e-8fa23f386b5a	BELLINDA DANIELLA MANGADIL	0457	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ad1d0c6a-76e0-4d95-a302-22ad50777536	ad1d0c6a-76e0-4d95-a302-22ad50777536	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	6b031760-aef5-4dbb-b520-01e6685a54d1	LIDIA HANA MAMANGKEY	0495	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
baa9b402-a644-46b2-828a-1849f5241198	baa9b402-a644-46b2-828a-1849f5241198	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	0c57cc9c-4c32-11e5-858c-afbc5904667e	TIRSA MODEONG	0524	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
83697c25-42e5-4a67-99eb-a2a8ffc5d8ec	83697c25-42e5-4a67-99eb-a2a8ffc5d8ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	472d73e3-2d2f-488f-8e2f-cd3d22418632	SULKIFLI	0435	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
01568e69-b562-415a-992b-cda9ec82f68c	01568e69-b562-415a-992b-cda9ec82f68c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	a83c363b-c56d-49b3-9d37-61d51488daab	GABRIELA DONDO	0484	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
5f4c7111-04e6-4794-965e-c0afe428cee7	5f4c7111-04e6-4794-965e-c0afe428cee7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2c1a4eb5-a151-4f91-b353-eaf2c2ec98c5	04a45a78-7f1b-4cad-a70f-732efa5f7985	TIARA TILAAR	0523	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
df495c69-59eb-483b-9c80-904f43ff3ed8	df495c69-59eb-483b-9c80-904f43ff3ed8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	114ad756-3691-44c4-baf8-54f70d900b6f	698259da-b323-4524-92e3-706ec09179bd	Sindi Bolung	0348	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ae7dfa8c-d47c-4f78-ba5d-71967903c265	ae7dfa8c-d47c-4f78-ba5d-71967903c265	39f5eb74-4722-4aaf-a6af-2c6e972e5885	114ad756-3691-44c4-baf8-54f70d900b6f	42d0f133-d66c-4ae9-a769-9547b1482539	Tirawati Mamonto	0368	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
a93b2848-0ea4-4ba0-9046-0e644f69668a	a93b2848-0ea4-4ba0-9046-0e644f69668a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	114ad756-3691-44c4-baf8-54f70d900b6f	e0e38c52-da5a-44a8-ac92-411718cd6332	Sahrani Mokodompit	0346	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
da4e82d8-0611-49d1-9c4e-0acb8c78ce3d	da4e82d8-0611-49d1-9c4e-0acb8c78ce3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	WAHYU DAMOPOLI	0339	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
e2208cec-d296-4caf-8bf4-f73870f9ec04	e2208cec-d296-4caf-8bf4-f73870f9ec04	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	OVELIA FRISILIA LUMINTANG	0504	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b56fd87b-adc7-442f-a20b-e5c1975f65f9	b56fd87b-adc7-442f-a20b-e5c1975f65f9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	Dwi Resky Sally Nabila	0466	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
6f653fbc-88e5-46fa-9635-cb064bd62d6a	6f653fbc-88e5-46fa-9635-cb064bd62d6a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	IRANDU MOKODONGAN	0493	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
374ad046-c005-4ff1-9368-c01b6d318b4b	374ad046-c005-4ff1-9368-c01b6d318b4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	NOVITA CUT NYA DIEN TARONTONG	0502	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
443facc0-feda-485e-bfb6-ba876120fa65	443facc0-feda-485e-bfb6-ba876120fa65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	52d5486a-4544-11e5-b3ea-131ef06916b5	DINI LUMANAW	0465	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
d3a940fd-2410-41fa-8c1e-b5db4675e1f6	d3a940fd-2410-41fa-8c1e-b5db4675e1f6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	ff732935-72e5-4865-bb47-f3e0cb79d9fa	GERARDUS LARITEMBUN	0485	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
4981d86d-b500-4167-a477-78b701556068	4981d86d-b500-4167-a477-78b701556068	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	74b1c647-0142-4355-a2af-d5a15f1d2358	Aditiya Mongilong	0448	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
75df2e1d-99aa-42f3-b7b8-6e09f54abe6e	75df2e1d-99aa-42f3-b7b8-6e09f54abe6e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	5ae837e8-4a02-11e5-9a00-2bca72a8469e	Enjelita Angkobos	0470	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
212b30f0-ec02-436f-9361-523317601f18	212b30f0-ec02-436f-9361-523317601f18	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	ENJELINA KANTOR	0469	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
a11507c9-335d-4b64-9f1e-410f75d92db7	a11507c9-335d-4b64-9f1e-410f75d92db7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	d85e860f-35a9-4406-8bc6-0e4051153600	FEBRIYANTI PATRA	0478	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
85ba087b-3a59-41bb-8985-3347a9fbf987	85ba087b-3a59-41bb-8985-3347a9fbf987	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	ff07bc11-35f4-4ff1-a749-78e30f56e52c	PAT SYAFAR ISINI	0506	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
bd6bc717-e89b-41d3-bca0-9b20a17a251e	bd6bc717-e89b-41d3-bca0-9b20a17a251e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	679c6691-5977-4188-b9cb-15090b3fb85f	MUHAJIRIN MARALA	0347	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
8ec2e9c4-480a-4d1d-8cb6-2d71a26d69a1	8ec2e9c4-480a-4d1d-8cb6-2d71a26d69a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	Faradila Mustafa	0476	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
fb92faeb-f995-47ab-9200-dc9b6b4c8421	fb92faeb-f995-47ab-9200-dc9b6b4c8421	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	8a5395ea-c758-4eb7-b436-571f527789a2	Fajar Katili	0381	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
c19a3c11-dadb-4c50-b84c-6051b9238314	c19a3c11-dadb-4c50-b84c-6051b9238314	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	9b057256-628e-4516-a951-a78bd3651d4b	Baso Asraf Saputra Marala	0428	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ea6841cd-a899-4286-9b3c-3b5c5e6417d5	ea6841cd-a899-4286-9b3c-3b5c5e6417d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	9e8380ef-47fb-4968-add6-6aaebdebb939	Andini Mokoagow	0356	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
f18f5f16-7542-4d75-a8dd-25e1956e9bbf	f18f5f16-7542-4d75-a8dd-25e1956e9bbf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	a6fed8b4-950c-4621-9932-ba8a45b84935	Dea Fatinah Limpele	0359	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
ecad7310-f8b3-47c5-83c2-8fb376fd647b	ecad7310-f8b3-47c5-83c2-8fb376fd647b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	ARSYI SALSABILA SIMBALA	0454	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
610f21aa-e4c9-4c89-b9e9-859c035a5a2c	610f21aa-e4c9-4c89-b9e9-859c035a5a2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	fa092490-4b74-11e5-a33d-db9868dda03f	FAZRI MAKALALAG	0477	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
2863699d-1aba-43fd-8938-73d857a1568d	2863699d-1aba-43fd-8938-73d857a1568d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	9cebf2d1-99f6-4b81-a7e7-d3fd26767c59	SESILAWATI MOKODOMPIT	0568	1	2021-10-26 09:36:56	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
303878c1-91fc-421e-a2cd-f7ac4d267c0c	303878c1-91fc-421e-a2cd-f7ac4d267c0c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	079a34b8-4b76-11e5-814d-b3ab2368e254	ANDIKA MAKALALAG	0452	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
025d5a88-bd0b-47bb-b79f-3fbc4cb83d22	025d5a88-bd0b-47bb-b79f-3fbc4cb83d22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	7a13c707-8f03-e211-8560-17962475f905	Teisya Yulingkan Yeye Oroh	0642	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
31003a7d-fa11-4446-94ac-d5cde52fde2d	31003a7d-fa11-4446-94ac-d5cde52fde2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	42d7fe00-da2b-43ec-abf4-4cefb5d8c3d9	14fba9a1-6ca4-4937-84e7-2a845d02897a	SINTIA SARI BINOL	0569	1	2021-10-26 09:36:56	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
7952b991-47d8-4625-9478-429bca50da74	7952b991-47d8-4625-9478-429bca50da74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	114ad756-3691-44c4-baf8-54f70d900b6f	8e47faed-6b87-4baf-8d94-d778345455f3	SURIANSYAH KOROMPOT	0517	1	2019-10-29 19:28:18	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
b06ada70-a0c6-4172-83a5-81f43c4a0722	b06ada70-a0c6-4172-83a5-81f43c4a0722	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	695dda2d-4408-e211-b6ed-d1aec8947609	Shallin Pandey	0616	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
665f1e37-9ef6-4390-a223-15da40d52202	665f1e37-9ef6-4390-a223-15da40d52202	39f5eb74-4722-4aaf-a6af-2c6e972e5885	b650cc24-3f5f-4a61-8cb5-efac77bbed48	4f8e0696-ebb4-406b-a15d-10ddcaa85487	GIBRAN DINAYAH LIMBANADI	0487	1	2020-12-16 07:53:21	2023-02-14 08:52:36	\N	2023-02-14 08:52:36
8c3a91a4-7b31-4b42-9308-7fda79658918	8c3a91a4-7b31-4b42-9308-7fda79658918	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	ANGGRA FADILA MOKOGINTA	0463	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
63e81763-f211-48ef-8b95-8191d7970a7c	63e81763-f211-48ef-8b95-8191d7970a7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	8c54af21-d3fa-4eba-b89f-b628ab9fa013	Sri Rani Mewengkang	0514	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
c6c51771-88ad-42d1-8720-cb8466799d83	c6c51771-88ad-42d1-8720-cb8466799d83	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	b255e348-4b76-11e5-8241-13af4f7fae26	GERY SULAEMAN	0505	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
cdd95316-8a43-4a3b-b156-bed544ae035d	cdd95316-8a43-4a3b-b156-bed544ae035d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	8e47faed-6b87-4baf-8d94-d778345455f3	SURIANSYAH KOROMPOT	0517	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
e1ecc998-25ef-4595-a646-b8eacb10db14	e1ecc998-25ef-4595-a646-b8eacb10db14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	RIFKI ZAKY ATMAJAYA KUNRADE	0512	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
541b67d3-697c-4f7f-8554-65e1bf4bdcb4	541b67d3-697c-4f7f-8554-65e1bf4bdcb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	900ffa20-46cc-11e5-8abe-0337176d8d23	SRI RIZKIA WAHYUNI MANOPPO	0515	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
76ee1eef-293a-4123-86d8-3e30a35829e4	76ee1eef-293a-4123-86d8-3e30a35829e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	694dbea4-61bc-45ed-baff-dd895fc010bb	f9496132-3b0c-11e5-a92d-b7a7850016b8	ERLANGGA LUMINU	0472	1	2021-03-30 13:02:00	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a820d16d-e809-49df-88bc-cb8641959baf	a820d16d-e809-49df-88bc-cb8641959baf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	d70b85ae-ad9b-424b-9a8b-15f06aeddc0d	e69398c4-8a47-4d33-aa9e-c992acd5ec31	AUSYE SYALOMITA PUTRI ROTIKAN	0690	1	2021-10-26 09:36:57	2023-02-14 08:52:37	\N	2023-02-14 08:52:37
a26d1f86-9c75-4ef1-8254-41049ee8e082	a26d1f86-9c75-4ef1-8254-41049ee8e082	39f5eb74-4722-4aaf-a6af-2c6e972e5885	bb2fd68a-be9c-4064-b8b7-8c37627cc282	c1b9c50b-2f0c-4cd5-a664-0bfa77156728	Feronica Frisilya Moningka	0482	1	2019-10-29 19:28:18	2022-12-01 10:22:45	\N	2023-02-14 09:02:54
c956ebcf-c249-4380-bf23-188791462b96	c956ebcf-c249-4380-bf23-188791462b96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	3fe30cf9-6fd9-497b-b2ce-8b5cbe5543b3	9433b08e-fac0-4a20-9d42-684e7aced3c6	Sriwulan Palengkahu	0641	1	2023-02-14 08:52:37	2023-04-18 17:45:52	\N	2023-04-18 17:45:52
4243083f-33f4-4192-ad9c-28ae14580dbd	4243083f-33f4-4192-ad9c-28ae14580dbd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	73a11bc8-da3d-47d4-84c5-5fca52a696fd	89a07b97-5c4f-4984-82d1-1254eb1c86af	MARCEL MANDAGI	0812	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
4513dea0-c864-44c4-bbb1-e5c6a8656f25	4513dea0-c864-44c4-bbb1-e5c6a8656f25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	73a11bc8-da3d-47d4-84c5-5fca52a696fd	2e383874-7f7e-11e3-b87c-131c0087c0c4	Sakila Bakari	0838	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
b1a88b63-7558-4c52-a641-78a22e97f7fb	b1a88b63-7558-4c52-a641-78a22e97f7fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	46c8c32f-379b-4a36-a819-363a4313bd05	ef8b39a6-5b64-11e3-b441-f77bcf353f34	Hijra Mamonto	0804	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
5336aff0-ef53-457c-904b-fd654ce5001d	5336aff0-ef53-457c-904b-fd654ce5001d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	46c8c32f-379b-4a36-a819-363a4313bd05	94440896-8c99-11e3-ac3f-a3e636726f74	LEVINA HAMZA	0811	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
6d76ed36-9517-43f7-a4d2-7ea928b43827	6d76ed36-9517-43f7-a4d2-7ea928b43827	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85379c23-b0f5-43e1-90a2-79e7e27688b9	3d9a3222-1539-4af6-bc16-54a57990650c	Farqa Faizah Dinanti Dhani	0797	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
5d989a55-255e-403c-876f-2140e4a267f2	5d989a55-255e-403c-876f-2140e4a267f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	85379c23-b0f5-43e1-90a2-79e7e27688b9	a990755d-db89-48e1-9e88-fbff0e01d35c	Nisa Usman	0823	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
e4d7997f-4d10-4ea5-9557-f6279d98a79f	e4d7997f-4d10-4ea5-9557-f6279d98a79f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a835b622-88d5-4b82-a187-afbe5e3e0585	9373c4ae-71e3-11e3-8d00-a3618c7b2ae5	Rafi Faisal Limbanadi	0831	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
cb4f8adc-7399-4992-8af4-909d5c5c500e	cb4f8adc-7399-4992-8af4-909d5c5c500e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a835b622-88d5-4b82-a187-afbe5e3e0585	d22b4808-88b2-11e3-8cc6-27bf35192807	Fatima Simbala	0798	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
ec744c43-f14f-42cf-b1dd-c913a00e3c62	ec744c43-f14f-42cf-b1dd-c913a00e3c62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a835b622-88d5-4b82-a187-afbe5e3e0585	6ec00c9f-1bf3-4a69-b131-8401a0fbe519	JOSUA MAWERE	0809	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
3e144fa7-c0e1-472b-b7f1-474b55ae3b2c	3e144fa7-c0e1-472b-b7f1-474b55ae3b2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5f83a1d4-13c3-4f8d-90e6-a2a2d78f97ac	7c4b00f2-9516-11e3-bed6-135f4d27544f	Ihksan Mayo	0806	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
e51d4773-7148-4a0d-8109-b09470986dc1	e51d4773-7148-4a0d-8109-b09470986dc1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5f83a1d4-13c3-4f8d-90e6-a2a2d78f97ac	bede3706-7809-11e3-acc7-b7cb53fe2add	NADYA MOKODOMPIT	0819	1	2025-04-24 09:56:27	2025-04-24 09:56:27	\N	2025-03-25 09:56:27
2798f5af-9b7f-4781-99c7-28c95e9729c1	2798f5af-9b7f-4781-99c7-28c95e9729c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78b5f6a3-506e-45b9-9233-e72b179ea8af	b1e79070-5e22-11e3-9c6d-233c893822c5	Azmia Bin Ali	0787	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
977fe945-1ab7-4c54-8a58-ab64e02fc38d	977fe945-1ab7-4c54-8a58-ab64e02fc38d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78b5f6a3-506e-45b9-9233-e72b179ea8af	a8fda9da-6d1e-11e3-970c-93ebf835240a	Cahaya Olola	0789	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
9b31e83b-338f-474f-bb86-3d1e6fda43c7	9b31e83b-338f-474f-bb86-3d1e6fda43c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78b5f6a3-506e-45b9-9233-e72b179ea8af	617d0298-7806-11e3-a360-3b79dafbb6d8	Nabila Wartabone	0818	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
ac7182d0-9582-40e0-9178-18e5b9bfa7a3	ac7182d0-9582-40e0-9178-18e5b9bfa7a3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78b5f6a3-506e-45b9-9233-e72b179ea8af	539c2dbe-5e22-11e3-97a4-6b60c900259e	Yesika Kristi Agow	0845	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
082e8b18-c175-4cb9-a892-c75dc7cff327	082e8b18-c175-4cb9-a892-c75dc7cff327	39f5eb74-4722-4aaf-a6af-2c6e972e5885	78b5f6a3-506e-45b9-9233-e72b179ea8af	0769190c-5d64-11e3-8b30-dffbe206ec8a	Asiasvilani Sakul	0786	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
a4fbdac7-cd1e-4971-8d81-c405753568cb	a4fbdac7-cd1e-4971-8d81-c405753568cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	ec89a489-7764-4644-932a-a67f80adf37d	2fb17dee-c9a5-4e06-873d-d0441f792754	Hizbullah Gelu	0853	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
82749570-e5da-4af3-9ebb-02634d7a7d84	82749570-e5da-4af3-9ebb-02634d7a7d84	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	480ab734-94d9-11e3-af34-afde42cffeec	Sakinah Dasinangon	0839	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
6ffb71e8-b128-447f-b3cb-c3c6994e7a3b	6ffb71e8-b128-447f-b3cb-c3c6994e7a3b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	7bc4be4e-94d9-11e3-bb8e-af0feebc548b	Nabila Bakari	0817	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
a184a308-22d1-4054-b3b9-266f33de9117	a184a308-22d1-4054-b3b9-266f33de9117	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	accdf25c-06f9-4e7b-9678-a1acd1331088	NAZWA MAMONTO	0821	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
6c058e60-f05a-421e-8bdb-7088d425374f	6c058e60-f05a-421e-8bdb-7088d425374f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	1efebede-0f12-4c19-ab53-2090b7359148	Zity Nuraini Fhisya Mokoagow	0847	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
33f51fd9-bac9-4bf2-b5f0-e724ff3c8ce5	33f51fd9-bac9-4bf2-b5f0-e724ff3c8ce5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	1043eb6a-a5c9-4e29-92ec-e5a3eea29247	ANDINI MAMONTO	0855	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
cc0d0a9a-ef6c-4cce-a8e8-eeca2b9b8e7c	cc0d0a9a-ef6c-4cce-a8e8-eeca2b9b8e7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	dca8c625-66fa-40f4-9c90-7fe6a4e7031d	a5197a21-450c-4b9d-a2b7-5e5f76982fd2	PIDIA EDU	0826	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
bd50dd70-447d-4c2f-b4a3-833c3fdfe237	bd50dd70-447d-4c2f-b4a3-833c3fdfe237	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3a560b6-dfcf-4af5-9240-fa47d7b34046	6149e37c-57ea-11e3-8a63-0bad90edf22e	Yogi Pratama Paputungan	0846	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
4eed8c14-9fc3-4b55-9a50-443f33b94943	4eed8c14-9fc3-4b55-9a50-443f33b94943	39f5eb74-4722-4aaf-a6af-2c6e972e5885	a3a560b6-dfcf-4af5-9240-fa47d7b34046	62bf4771-c092-434d-8e93-0260891de1ff	Rifaldi Sukarno	0848	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
54c97ab2-71bd-410b-b876-84946833c22a	54c97ab2-71bd-410b-b876-84946833c22a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e3a734a-1f55-451b-b20c-638af8269223	00d9161a-94d6-11e3-8e07-6bfd6236e395	Pasha Mokodompit	0825	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
e142f11b-bb6f-4690-a7ad-cd698f6bd5c9	e142f11b-bb6f-4690-a7ad-cd698f6bd5c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	6e3a734a-1f55-451b-b20c-638af8269223	6bcf1e8c-6f7f-11e3-8895-3357dd36639d	Neyra Surapati	0822	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
af526e74-ca91-4106-86d0-cf6bbd7928c4	af526e74-ca91-4106-86d0-cf6bbd7928c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9c45e986-84ac-4879-82ba-60668a077d7c	3c1ceee8-8105-11e3-833a-9bdba6d1ca50	Andri Bakari	0783	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
1fae59fa-6aaf-49e1-925e-d3dd75eee7bc	1fae59fa-6aaf-49e1-925e-d3dd75eee7bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9c45e986-84ac-4879-82ba-60668a077d7c	84f52c40-b361-11e4-97f5-07149f66330b	Anggun Daeng Mangawi	0784	1	2025-04-24 09:56:28	2025-04-24 09:56:28	\N	2025-03-25 09:56:28
d442fa3f-355e-4adc-be11-cea0bcaa4f29	d442fa3f-355e-4adc-be11-cea0bcaa4f29	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9ffd4937-1e2b-45b3-a7bd-e01cf211c28f	b9b3e453-5f83-4976-91c2-cb4c8b272a0c	FRILY FRICILIYA LARUNG	0802	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
2254499b-3a76-4789-93e1-8fde4f6030b5	2254499b-3a76-4789-93e1-8fde4f6030b5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	9ffd4937-1e2b-45b3-a7bd-e01cf211c28f	e4cf82c4-67df-11e3-a0f5-c792454ff412	Citra Paputungan	0790	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
762adf9a-ed16-4ea0-b58f-e5554f3d4882	762adf9a-ed16-4ea0-b58f-e5554f3d4882	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2dbffb72-3a68-4c7a-b27b-11ba4ee9ec9e	7adea11a-561c-11e5-900a-eb2673a1373b	Devid Tarontong	0794	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
3a3450b8-eb0a-407d-b58e-e686227b7ce5	3a3450b8-eb0a-407d-b58e-e686227b7ce5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	2dbffb72-3a68-4c7a-b27b-11ba4ee9ec9e	483046d6-87b2-4164-9247-49c073789a31	Junia Ligawa	0810	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
53967fd4-7b77-40b1-9f26-471c76750dfd	53967fd4-7b77-40b1-9f26-471c76750dfd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	36460622-2c36-492c-8f2d-ee2df61b152b	912be006-94d8-11e3-9fbf-ef2adf253ed7	Cantika Prisilia Dewi Mokoginta	0854	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
7bda4969-a649-4655-9787-c8b1e1c83b13	7bda4969-a649-4655-9787-c8b1e1c83b13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	36460622-2c36-492c-8f2d-ee2df61b152b	de4c9890-94d7-11e3-87b3-bf380a55277f	Frian Mamonto	0801	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
b6c2f34b-dc4d-42a1-8850-bb3f59682fd3	b6c2f34b-dc4d-42a1-8850-bb3f59682fd3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	36460622-2c36-492c-8f2d-ee2df61b152b	71e270b7-10e5-40cd-af79-1b5d07c2d9ab	ALBANI MOHA	0781	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
3e58a48b-1800-495e-9444-ff3a38a1c5f5	3e58a48b-1800-495e-9444-ff3a38a1c5f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	36460622-2c36-492c-8f2d-ee2df61b152b	4f34ea70-781e-11e3-af88-8738a490246c	Fika Usman	0799	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
60202d1c-ca9b-41ec-b3a6-5beeb010dffe	60202d1c-ca9b-41ec-b3a6-5beeb010dffe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5269f06a-f43d-4d95-b523-871217a2ee97	11273a50-662d-11e4-a36e-136788f6ba2a	Herawati Paputungan	0803	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
b48edbab-78cd-4280-a08b-5408c227dd02	b48edbab-78cd-4280-a08b-5408c227dd02	39f5eb74-4722-4aaf-a6af-2c6e972e5885	5269f06a-f43d-4d95-b523-871217a2ee97	49b646f0-5bb5-11e3-a96d-e7586c796b63	SWIE MAI SANDRA FLOREN JEKLIN TAMPONGANGOY	0841	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
501ef935-ff4b-4a21-9fa3-6a6f7e85d24c	501ef935-ff4b-4a21-9fa3-6a6f7e85d24c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	4723fdb8-3c56-4bb1-8e80-c3c68bce03b2	67ee6efb-ca29-e211-82ed-4bf89d6bb6ec	Reza Fabian Bano	0834	1	2025-04-24 09:56:29	2025-04-24 09:56:29	\N	2025-03-25 09:56:29
57c23e86-8fe3-40a1-b159-e1415b455fc3	57c23e86-8fe3-40a1-b159-e1415b455fc3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	144c6e28-4266-4a66-a2b6-5f288e4fd102	5dd3beda-a90a-11e4-8be4-878764d69847	Bahtiar Paputungan	0864	1	2025-12-01 23:17:31	2025-12-01 23:17:31	\N	2025-11-01 23:17:31
37672438-3fd4-4d52-a03b-ac8bc6d676c6	37672438-3fd4-4d52-a03b-ac8bc6d676c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	144c6e28-4266-4a66-a2b6-5f288e4fd102	82258dfe-8bf9-11e5-ad93-37d367e86351	AMNAISILA BARAMISE	0862	1	2025-12-01 23:17:31	2025-12-01 23:17:31	\N	2025-11-01 23:17:31
7f1b0567-4d24-47bb-ab03-652da109add9	7f1b0567-4d24-47bb-ab03-652da109add9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	1424a3b7-b04e-443e-9c09-b61c2a95fa6d	36ba84d6-3584-11e4-b8e4-c7661f15c542	Moh Fadhli Andu	0885	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
551c57a9-1464-4f8b-9b68-b517a48fac28	551c57a9-1464-4f8b-9b68-b517a48fac28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	0b6a3f38-5d20-4d20-8ded-bb2a74ac7ceb	d8e37a78-4935-11e4-8211-6bd4672775fd	NUR ASARI MOKODOMPIT	0875	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
24af2b57-a836-4557-86cd-f92f127d7b61	24af2b57-a836-4557-86cd-f92f127d7b61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	25975caf-971b-4b6c-adc5-5d42feabd4bd	0b4ceeec-3c96-11e4-84b3-ab002f41a8b8	Nadira Lantemona	0873	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
0e51ff30-a979-4132-b581-ceec812c52a6	0e51ff30-a979-4132-b581-ceec812c52a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	25975caf-971b-4b6c-adc5-5d42feabd4bd	3e7374e8-2bf3-11e4-af70-f7c93647854e	Arini Yakomina Talu	0863	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
f8f6e84b-0f35-4d52-9193-38432f8a34b7	f8f6e84b-0f35-4d52-9193-38432f8a34b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	38fb97f3-92fc-4e46-8383-f8c1c8d82ff0	38babd1a-3be1-11e4-9cff-7b0d7994cf0b	ALINSKI MAMELE	0860	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
045b469f-7cd5-4ed2-a9d3-140d2a186c45	045b469f-7cd5-4ed2-a9d3-140d2a186c45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	38fb97f3-92fc-4e46-8383-f8c1c8d82ff0	3d2787cc-f76b-4ce2-a350-cffecfc2216a	TEGUH NATHANIO MODEONG	0878	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
43be493e-9875-4bc5-884c-60f6b7f55a7b	43be493e-9875-4bc5-884c-60f6b7f55a7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	e49a2a39-7cf5-47b9-985e-aa727abda876	6405cba1-076f-44ab-bd89-cc50f34589e6	GRESITA PAPUTUNGAN	0868	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
b57cc712-6b9a-4020-8649-989cb88b48a9	b57cc712-6b9a-4020-8649-989cb88b48a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	fc713781-29c1-4c5f-aa27-f7f7fcfe59d1	47673f22-4934-11e4-a28b-fb997fc27d8d	IKRAM MOKODOMPIT	0869	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
33654cab-ce8b-42c9-b742-15a8c9b1da0d	33654cab-ce8b-42c9-b742-15a8c9b1da0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a9ddb78-3848-4531-899f-faa7a20394e8	3ebfbdc0-4be2-11e5-9342-930322c83a67	Daniel Ruben Lantu	0865	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
c8e77552-e630-4df4-87f4-6e155b133155	c8e77552-e630-4df4-87f4-6e155b133155	39f5eb74-4722-4aaf-a6af-2c6e972e5885	7a9ddb78-3848-4531-899f-faa7a20394e8	a77bbee8-3fba-11e4-9190-c7120430447f	ZAHRA PUTRI LALUYAN	0880	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
f5ee06d8-adce-466a-9eab-13f234adb90e	f5ee06d8-adce-466a-9eab-13f234adb90e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	32b89df4-3f72-4bf8-8647-475387b081ab	00892e3c-bf90-412d-a2dd-b1615ea2c6f2	Sasri Murliana Korompot	0882	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
25b1d366-94c8-4b17-bfd3-7ba72acc6147	25b1d366-94c8-4b17-bfd3-7ba72acc6147	39f5eb74-4722-4aaf-a6af-2c6e972e5885	32b89df4-3f72-4bf8-8647-475387b081ab	fcca450f-19a5-4ec2-9745-bb2f2602c517	MIRACLE KAWILARANG	0883	1	2025-12-01 23:17:32	2025-12-01 23:17:32	\N	2025-11-01 23:17:32
8d09dfd0-287a-4c59-ba3d-69ac4151a27a	8d09dfd0-287a-4c59-ba3d-69ac4151a27a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	424267e7-80dd-4f47-a77d-a3558df2481d	840ff838-4001-11e4-bf78-07281b97a7c6	RIVANIA ABRAM	0877	1	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
42485c1d-b690-4a2f-b50f-21c4a579ef43	42485c1d-b690-4a2f-b50f-21c4a579ef43	39f5eb74-4722-4aaf-a6af-2c6e972e5885	424267e7-80dd-4f47-a77d-a3558df2481d	8ff0ed33-b9f4-4f73-a77a-4cf388f1a3cb	Nesa Mamonto	0881	1	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
57a3aaff-a11c-4af9-baf8-0ca4a0b72911	57a3aaff-a11c-4af9-baf8-0ca4a0b72911	39f5eb74-4722-4aaf-a6af-2c6e972e5885	424267e7-80dd-4f47-a77d-a3558df2481d	85c76db0-48a7-11e4-8146-178a618d3874	Afgan Hasan	0859	1	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
464b7cc8-1bee-4de2-a488-68429c9487ad	464b7cc8-1bee-4de2-a488-68429c9487ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	424267e7-80dd-4f47-a77d-a3558df2481d	12ecc34e-3240-11e4-88e5-f39ce92a334f	Rasti Makalalag	0884	1	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
28ab0ed3-66b0-42f1-a69a-a4111b3a891f	28ab0ed3-66b0-42f1-a69a-a4111b3a891f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	60d021cb-f0c8-4552-8ba3-d7d69a0b5f24	9a7aee38-4089-11e4-838c-77f18ad3941b	Kevin Dityaputra Rugian	0871	1	2025-12-01 23:17:33	2025-12-01 23:17:33	\N	2025-11-01 23:17:33
\.


--
-- Data for Name: anggota_kewirausahaan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.anggota_kewirausahaan (anggota_kewirausahaan_id, kewirausahaan_id, anggota_rombel_id, created_at, updated_at, last_sync) FROM stdin;
\.


--
-- Data for Name: anggota_rombel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.anggota_rombel (anggota_rombel_id, sekolah_id, semester_id, rombongan_belajar_id, peserta_didik_id, anggota_rombel_id_dapodik, anggota_rombel_id_migrasi, created_at, updated_at, deleted_at, last_sync) FROM stdin;
26b38017-c0db-4009-b7de-645759f1c10c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	0312c3d7-fde1-47cf-96ce-1f87a4228787	26b38017-c0db-4009-b7de-645759f1c10c	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:24
b1959232-ad54-45ac-9c6e-5ac26ecb54cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	99f38034-4a28-11e5-a3b9-ff498a91b449	b1959232-ad54-45ac-9c6e-5ac26ecb54cf	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:24
efdf7266-b83d-4e0a-9d08-219bda648986	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	8a5395ea-c758-4eb7-b436-571f527789a2	efdf7266-b83d-4e0a-9d08-219bda648986	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:24
feec8b52-fb8d-451a-a4c4-d6d7c0c17e71	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	7a426c49-48eb-473c-9779-47a65a92d954	feec8b52-fb8d-451a-a4c4-d6d7c0c17e71	\N	2019-12-06 16:14:40	2022-12-01 10:22:53	\N	2020-03-07 18:38:32
20811e09-d65e-497e-94af-64b2bbfc01d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	4e3a22a4-98e9-4024-a519-7a05be9167c8	20811e09-d65e-497e-94af-64b2bbfc01d5	\N	2019-12-06 16:14:39	2022-12-01 10:22:53	\N	2020-03-07 18:38:31
3130d754-b397-4b9c-b7e2-132b2898442b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	26daca7f-056a-4e55-a49a-4469004944ec	3130d754-b397-4b9c-b7e2-132b2898442b	\N	2019-10-29 19:26:22	2022-12-01 10:22:54	\N	2019-12-19 08:08:24
447b651c-84ba-4d20-b77b-2d2a76aef9d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	fa092490-4b74-11e5-a33d-db9868dda03f	447b651c-84ba-4d20-b77b-2d2a76aef9d3	\N	2019-10-29 19:26:22	2022-12-01 10:22:54	\N	2019-12-19 08:08:24
f34be181-5bf8-4016-b736-b1cd3d7f3f04	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	f34be181-5bf8-4016-b736-b1cd3d7f3f04	\N	2019-10-29 19:26:22	2022-12-01 10:22:54	\N	2019-12-19 08:08:24
72c38ff7-dc28-4065-bb8e-ec8f47a271fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	54894cf6-ecf9-44c5-87e8-b87e6bf62120	72c38ff7-dc28-4065-bb8e-ec8f47a271fc	\N	2019-10-29 19:26:22	2022-12-01 10:22:56	\N	2019-12-19 08:08:24
e72f9ae4-5a75-4cf0-a93e-b21e75d9b885	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	0494c011-fd20-411c-b6f3-022d10cfb1b4	e72f9ae4-5a75-4cf0-a93e-b21e75d9b885	\N	2019-10-29 19:26:22	2022-12-01 10:22:56	\N	2019-12-19 08:08:23
b2685592-a50c-4d9a-b181-f7801d0b13c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	cc30617c-14a9-478b-83d4-b0e836aa69c0	b2685592-a50c-4d9a-b181-f7801d0b13c4	\N	2019-10-29 19:26:22	2022-12-01 10:22:56	\N	2019-12-19 08:08:24
3eb7b50d-e1bb-4ef4-b6b8-c9370f955db0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	9c4c0c10-b8da-414e-8da3-ea55711fb000	3eb7b50d-e1bb-4ef4-b6b8-c9370f955db0	\N	2019-10-29 19:26:22	2022-12-01 10:22:57	\N	2019-12-19 08:08:24
712c57ac-f8a8-412f-ad16-23778a1dca76	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	c60e92a2-99c2-4394-a48b-251540c8b96f	712c57ac-f8a8-412f-ad16-23778a1dca76	\N	2019-10-29 19:26:22	2022-12-01 10:23:00	\N	2019-12-19 08:08:23
7636a330-ced8-4baa-b1d4-f449b55aa31e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	c593fef2-46d2-11e5-b14e-8fa23f386b5a	7636a330-ced8-4baa-b1d4-f449b55aa31e	\N	2019-10-29 19:26:22	2022-12-01 10:23:00	\N	2019-12-19 08:08:24
5b83728a-b5dd-43da-814b-8417ebf44928	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	5b83728a-b5dd-43da-814b-8417ebf44928	\N	2019-10-29 19:26:22	2022-12-01 10:23:00	\N	2019-12-19 08:08:24
030ca252-5156-409f-957d-69a3e0040708	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	e3549675-96bb-4c36-9d4e-b034c5de4b80	030ca252-5156-409f-957d-69a3e0040708	\N	2019-10-29 19:26:22	2022-12-01 10:23:01	\N	2019-12-19 08:08:24
9906248f-bdfe-474a-afa4-ba477d9caf55	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	1f6639a7-562e-44f9-b1c8-a98935a9193c	9906248f-bdfe-474a-afa4-ba477d9caf55	\N	2019-10-29 19:26:22	2022-12-01 10:23:01	\N	2019-12-19 08:08:23
9ae7fea5-3657-4e8c-bf8b-b686c321e855	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	d993ad11-d98a-4803-85a4-a446d7b9d4c7	9ae7fea5-3657-4e8c-bf8b-b686c321e855	\N	2019-10-29 19:26:22	2022-12-01 10:23:01	\N	2019-12-19 08:08:24
5118452e-cff4-4edf-a511-60137e091d22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	542df659-4377-411d-9fa8-1f5ce8878479	5118452e-cff4-4edf-a511-60137e091d22	\N	2019-10-29 19:26:22	2022-12-01 10:23:05	\N	2019-12-19 08:08:24
bfb49e3e-a048-4947-b593-56e2f08d7747	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	bfb49e3e-a048-4947-b593-56e2f08d7747	\N	2019-10-29 19:26:22	2022-12-01 10:23:06	\N	2019-12-19 08:08:23
ebf5aadb-5150-46ee-9754-8db8f3b62643	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	ebf5aadb-5150-46ee-9754-8db8f3b62643	\N	2019-10-29 19:26:22	2022-12-01 10:23:07	\N	2019-12-19 08:08:24
1a6fbc43-43eb-424d-874d-51bce4a52df9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	1a6fbc43-43eb-424d-874d-51bce4a52df9	\N	2019-10-29 19:26:22	2022-12-01 10:23:08	\N	2019-12-19 08:08:24
db0cc1a7-28d1-4fef-ac09-95f196838978	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	db0cc1a7-28d1-4fef-ac09-95f196838978	\N	2019-10-29 19:26:22	2022-12-01 10:23:08	\N	2019-12-19 08:08:24
ce40c0ca-30d5-4648-876f-1f1fa560e7a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	a6fed8b4-950c-4621-9932-ba8a45b84935	ce40c0ca-30d5-4648-876f-1f1fa560e7a2	\N	2019-10-29 19:26:22	2022-12-01 10:23:09	\N	2019-12-19 08:08:24
0d5fcfa1-4142-45e7-a0e4-4c971ae60e6b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	097f5676-e6b8-4033-9b17-43eb6a4145bf	0d5fcfa1-4142-45e7-a0e4-4c971ae60e6b	\N	2019-10-29 19:26:22	2022-12-01 10:23:10	\N	2019-12-19 08:08:24
bd2dc834-752e-4291-9ad9-9caa0f524ee3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	9e8380ef-47fb-4968-add6-6aaebdebb939	bd2dc834-752e-4291-9ad9-9caa0f524ee3	\N	2019-10-29 19:26:22	2022-12-01 10:23:11	\N	2019-12-19 08:08:23
046a16e4-c461-49a3-964d-3a69034e4b30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	81ed9f12-dc17-4947-aeaa-5105be4af095	046a16e4-c461-49a3-964d-3a69034e4b30	\N	2019-10-29 19:26:22	2022-12-01 10:23:11	\N	2019-12-19 08:08:24
34a0f0bb-9803-47cc-b6d2-a8d607404bc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	7363a404-46e9-11e5-8413-7fabf05ee1fd	34a0f0bb-9803-47cc-b6d2-a8d607404bc0	\N	2019-10-29 19:26:22	2022-12-01 10:23:11	\N	2019-12-19 08:08:23
a955a456-18a1-41aa-ad66-a198c66c8d96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	52d5486a-4544-11e5-b3ea-131ef06916b5	a955a456-18a1-41aa-ad66-a198c66c8d96	\N	2019-10-29 19:26:22	2022-12-01 10:23:13	\N	2019-12-19 08:08:24
906c4609-1edc-4fe0-b885-f4348299890d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	906c4609-1edc-4fe0-b885-f4348299890d	\N	2019-10-29 19:26:22	2022-12-01 10:23:13	\N	2019-12-19 08:08:24
38a01725-6964-4d5b-84ab-6787fbcb0058	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	5ae837e8-4a02-11e5-9a00-2bca72a8469e	38a01725-6964-4d5b-84ab-6787fbcb0058	\N	2019-10-29 19:26:22	2022-12-01 10:23:13	\N	2019-12-19 08:08:24
5b4083ee-8ad1-41b2-91f9-a1e97e592ed7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	cae987c8-810a-4d95-a5fb-27e3108961de	5b4083ee-8ad1-41b2-91f9-a1e97e592ed7	\N	2019-10-29 19:26:22	2022-12-01 10:23:15	\N	2019-12-19 08:08:24
91b0f9f3-1124-4395-b7f6-5110f2637fe2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	91b0f9f3-1124-4395-b7f6-5110f2637fe2	\N	2019-10-29 19:26:22	2022-12-01 10:23:15	\N	2019-12-19 08:08:24
67cbeff6-04ad-49a3-8446-abc22efb88d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	67390022-7626-4bf5-a07f-1f5dd137f72e	67cbeff6-04ad-49a3-8446-abc22efb88d1	\N	2019-10-29 19:26:22	2022-12-01 10:23:16	\N	2019-12-19 08:08:23
9ced9acc-342d-4c75-9a7a-2ab23ebbe519	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	9ced9acc-342d-4c75-9a7a-2ab23ebbe519	\N	2019-10-29 19:26:22	2022-12-01 10:23:17	\N	2019-12-19 08:08:24
40b5a628-cdd2-451c-89b3-54b654a2a3f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	5b61121a-264f-490f-86b1-551372be86d1	40b5a628-cdd2-451c-89b3-54b654a2a3f1	\N	2019-10-29 19:26:22	2022-12-01 10:23:19	\N	2019-12-19 08:08:24
c74b533d-f0e6-499a-aa54-051e436ff4ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	c74b533d-f0e6-499a-aa54-051e436ff4ed	\N	2019-10-29 19:26:22	2022-12-01 10:23:19	\N	2019-12-19 08:08:24
6f1acd6e-50e0-444d-b56b-0a098cc49119	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	6f1acd6e-50e0-444d-b56b-0a098cc49119	\N	2019-10-29 19:26:22	2022-12-01 10:23:19	\N	2019-12-19 08:08:24
fa1b7cd2-0049-4376-bb52-a89998ebf387	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	60c2ff20-4b6c-11e5-958c-b39420b5676f	fa1b7cd2-0049-4376-bb52-a89998ebf387	\N	2019-10-29 19:26:22	2022-12-01 10:23:21	\N	2019-12-19 08:08:24
16a496e0-ee6e-49aa-a311-d0531c2fdfdd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	16a496e0-ee6e-49aa-a311-d0531c2fdfdd	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:23
426906b6-81bf-4f83-959c-0ea0dfa96413	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	f59b1bb2-1e58-4760-b504-5ee5de14aba7	426906b6-81bf-4f83-959c-0ea0dfa96413	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:24
a6e5f763-587c-49bd-9ecb-a688f2fa4ebd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	a6e5f763-587c-49bd-9ecb-a688f2fa4ebd	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:24
cdb20348-0d11-49ab-b670-06246117cab5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	d313aa86-3092-4ceb-8e53-fabcecc2a37a	cdb20348-0d11-49ab-b670-06246117cab5	\N	2019-10-29 19:26:22	2022-12-01 10:23:24	\N	2019-12-19 08:08:23
1e7c7ed3-a9cf-4a97-b4ab-019e3b8d8dae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	1e7c7ed3-a9cf-4a97-b4ab-019e3b8d8dae	\N	2019-10-29 19:26:22	2022-12-01 10:23:24	\N	2019-12-19 08:08:24
172bf722-db9e-42c1-be5b-375eecdd247d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	172bf722-db9e-42c1-be5b-375eecdd247d	\N	2019-10-29 19:26:22	2022-12-01 10:23:25	\N	2019-12-19 08:08:24
91252030-f154-4009-a72f-f22c362299bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	91252030-f154-4009-a72f-f22c362299bc	\N	2019-10-29 19:26:22	2022-12-01 10:23:25	\N	2019-12-19 08:08:24
57205b17-a363-49e7-b123-6641f53814a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	26925a68-aab1-11e5-bde5-bb0a0689b68c	57205b17-a363-49e7-b123-6641f53814a2	\N	2019-10-29 19:26:22	2022-12-01 10:23:29	\N	2019-12-19 08:08:24
1634074d-c41e-46db-97bc-70d0216b2604	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	bf5484e0-8d85-4fb7-a34b-fd3b105e481e	73c986dd-4bfe-4a05-844b-00d385e21864	1634074d-c41e-46db-97bc-70d0216b2604	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
c1d4a80d-af2d-48cc-b8f9-6e553c0a6e23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	cd0efc86-2a0e-11e4-bc41-7bdce17446f2	c1d4a80d-af2d-48cc-b8f9-6e553c0a6e23	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
9c6e8ebf-a57d-49a3-af1e-65bf71c9afcd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	82a96812-204b-40c7-ba1b-9df405e70465	7ff0a433-25db-4d32-8bfb-64ffad30c8ab	\N	2019-10-29 19:26:22	2019-12-18 19:09:03	2019-12-18 19:09:03	2019-12-11 22:37:08
f451195f-d245-4ee9-8a74-2aa2e8e89685	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	9b057256-628e-4516-a951-a78bd3651d4b	f451195f-d245-4ee9-8a74-2aa2e8e89685	\N	2019-10-29 19:26:22	2022-12-01 10:22:51	\N	2019-12-19 08:08:24
7e1b1e5e-4eb9-4db0-98fd-42ea69fa4c7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	4dbcf03d-8516-4f9c-a25f-679ac14e766f	7e1b1e5e-4eb9-4db0-98fd-42ea69fa4c7d	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:24
85d1cf70-b04a-4080-85d8-c18fa8caacd8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	a16778e6-fe58-40af-a29b-6c47664d4064	85d1cf70-b04a-4080-85d8-c18fa8caacd8	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:25
11958a32-1073-426b-98d9-ac2a42bfb28f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	fd2e81be-ca4c-4320-9549-82c37f311556	11958a32-1073-426b-98d9-ac2a42bfb28f	\N	2019-10-29 19:26:22	2022-12-01 10:22:54	\N	2019-12-19 08:08:24
1574f4ca-228b-46e8-9db7-25b070ba2a9b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	d85e860f-35a9-4406-8bc6-0e4051153600	1574f4ca-228b-46e8-9db7-25b070ba2a9b	\N	2019-10-29 19:26:22	2022-12-01 10:22:55	\N	2019-12-19 08:08:24
3a5857d2-20ed-4661-88dc-e7f74dfa8e0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	f4241e37-70b6-4e48-91c1-08dcd7996be0	6402418c-54f9-11e5-9e54-5397b782050d	3a5857d2-20ed-4661-88dc-e7f74dfa8e0a	\N	2019-10-29 19:26:22	2022-12-01 10:22:56	\N	2019-12-19 08:08:24
fb93bc97-91e9-4cc9-bfee-252e0e4ca94e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	fb93bc97-91e9-4cc9-bfee-252e0e4ca94e	\N	2019-10-29 19:26:22	2022-12-01 10:22:57	\N	2019-12-19 08:08:24
05d33a41-9a41-45dc-b777-893fe4f87b45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	3e20af19-c84c-4fb4-9326-a47a5a8087c1	05d33a41-9a41-45dc-b777-893fe4f87b45	\N	2019-10-29 19:26:22	2022-12-01 10:22:57	\N	2019-12-19 08:08:24
4fa2bd71-5f78-4c68-8679-ae8bb711c2f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	7a426c49-48eb-473c-9779-47a65a92d954	4fa2bd71-5f78-4c68-8679-ae8bb711c2f0	\N	2019-10-29 19:26:22	2022-12-01 10:22:58	\N	2019-12-19 08:08:24
5f58c9b7-80c5-453a-bf98-aea9dad5d2de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	11558ce2-46ca-11e5-8ba3-b7381d40fb27	5f58c9b7-80c5-453a-bf98-aea9dad5d2de	\N	2019-10-29 19:26:22	2022-12-01 10:22:58	\N	2019-12-19 08:08:25
4daafaba-7af0-4ebf-8bbc-17edd827fd26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	4daafaba-7af0-4ebf-8bbc-17edd827fd26	\N	2019-10-29 19:26:23	2022-12-01 10:22:59	\N	2019-12-19 08:08:25
08ba80e7-e951-450f-a02a-6b036409d9e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	994e91c4-854b-4fe0-946c-0133e4582398	08ba80e7-e951-450f-a02a-6b036409d9e9	\N	2019-10-29 19:26:22	2022-12-01 10:23:00	\N	2019-12-19 08:08:25
a63e87f5-6751-4b0c-a0ae-313b9028b351	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	ff732935-72e5-4865-bb47-f3e0cb79d9fa	a63e87f5-6751-4b0c-a0ae-313b9028b351	\N	2019-10-29 19:26:22	2022-12-01 10:23:01	\N	2019-12-19 08:08:24
7e3e56b5-e30f-446b-aaf9-f6dfdbf74118	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	0ea06995-f218-4530-9b63-0b499a11b034	7e3e56b5-e30f-446b-aaf9-f6dfdbf74118	\N	2019-10-29 19:26:22	2022-12-01 10:23:01	\N	2019-12-19 08:08:24
6c7a57ab-ad7a-473b-99e5-67145320a4f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	2819b86b-4d06-499d-a0c9-af1a3e711ecf	6c7a57ab-ad7a-473b-99e5-67145320a4f4	\N	2019-10-29 19:26:22	2022-12-01 10:23:07	\N	2019-12-19 08:08:24
30126e6c-db8c-4627-acdf-f3b81fc28b62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	b255e348-4b76-11e5-8241-13af4f7fae26	30126e6c-db8c-4627-acdf-f3b81fc28b62	\N	2019-10-29 19:26:22	2022-12-01 10:23:08	\N	2019-12-19 08:08:24
d1ea8c2f-64b4-45c0-a69f-daeec8b39679	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	162955a4-43dc-4ee3-85f2-b4b602c72400	d1ea8c2f-64b4-45c0-a69f-daeec8b39679	\N	2019-10-29 19:26:22	2022-12-01 10:23:09	\N	2019-12-19 08:08:24
5a6402be-0fd3-422a-ae38-a2c928c2f36c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	eb76ddaa-0c43-46c8-95da-50b0a7ab8108	5a6402be-0fd3-422a-ae38-a2c928c2f36c	\N	2019-10-29 19:26:22	2022-12-01 10:23:10	\N	2019-12-19 08:08:24
998b17bf-39c7-4744-a211-9d4178a79cf0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	998b17bf-39c7-4744-a211-9d4178a79cf0	\N	2019-10-29 19:26:22	2022-12-01 10:23:10	\N	2019-12-19 08:08:25
48f4484b-1120-4cb4-baf2-dde0a4a53a93	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	6a26772d-e188-455a-8bd8-9c8d729a618e	48f4484b-1120-4cb4-baf2-dde0a4a53a93	\N	2019-10-29 19:26:22	2022-12-01 10:23:11	\N	2019-12-19 08:08:24
d28fc4b3-bce6-44d5-8583-3a6436a1b8b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	8e480efa-b4ae-4ecb-8b21-1ad77d82eb6d	d28fc4b3-bce6-44d5-8583-3a6436a1b8b3	\N	2019-10-29 19:26:22	2022-12-01 10:23:12	\N	2019-12-19 08:08:24
41a068ab-9860-4986-9dd9-3e6fcacc1683	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	4e3a22a4-98e9-4024-a519-7a05be9167c8	41a068ab-9860-4986-9dd9-3e6fcacc1683	\N	2019-10-29 19:26:22	2022-12-01 10:23:13	\N	2019-12-19 08:08:25
e06b6f07-a131-4f03-ad16-68e3bed3670d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	ea363a5f-9119-468b-8fea-9187ba92c13e	e06b6f07-a131-4f03-ad16-68e3bed3670d	\N	2019-10-29 19:26:22	2022-12-01 10:23:13	\N	2019-12-19 08:08:25
ca45e144-06a1-40e7-b8f5-0fa3b9045489	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	ca45e144-06a1-40e7-b8f5-0fa3b9045489	\N	2019-10-29 19:26:22	2022-12-01 10:23:14	\N	2019-12-19 08:08:24
47a16445-f84e-40ad-84dc-8fbc72ce9334	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	29d04843-7d39-48d9-9720-ea6c03d77e52	47a16445-f84e-40ad-84dc-8fbc72ce9334	\N	2019-10-29 19:26:22	2022-12-01 10:23:16	\N	2019-12-19 08:08:24
16d982f6-f666-4801-bf28-bd01224c0b9f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	16d982f6-f666-4801-bf28-bd01224c0b9f	\N	2019-10-29 19:26:22	2022-12-01 10:23:16	\N	2019-12-19 08:08:24
a2a50d96-1294-470b-9eef-b9d0b1c9cb7e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	72d18334-3b06-11e4-a3a4-13507c2a0677	a2a50d96-1294-470b-9eef-b9d0b1c9cb7e	\N	2019-10-29 19:26:22	2022-12-01 10:23:17	\N	2019-12-19 08:08:25
b6e1fada-7ff0-45bf-8cc0-cb996f530c45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	8b4ea31e-4aa0-427e-a65f-928b232d7f14	b6e1fada-7ff0-45bf-8cc0-cb996f530c45	\N	2019-10-29 19:26:23	2022-12-01 10:23:17	\N	2019-12-19 08:08:25
6070389c-2126-4ec7-af52-f76cb818644f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	6070389c-2126-4ec7-af52-f76cb818644f	\N	2019-10-29 19:26:22	2022-12-01 10:23:18	\N	2019-12-19 08:08:24
d47981fb-64a4-44a3-be5e-352e8834829b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	d47981fb-64a4-44a3-be5e-352e8834829b	\N	2019-10-29 19:26:23	2022-12-01 10:23:19	\N	2019-12-19 08:08:25
2b3cf88c-2889-4a72-bdda-9e484b866535	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	2b3cf88c-2889-4a72-bdda-9e484b866535	\N	2019-10-29 19:26:23	2022-12-01 10:23:21	\N	2019-12-19 08:08:25
e5593289-ad2d-4638-bf92-f88f46795e30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	e7692714-42a9-11e5-a70e-2322869c051b	e5593289-ad2d-4638-bf92-f88f46795e30	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:24
70b6c110-e1f7-4117-90e2-5ecb1a6c471c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	a83c363b-c56d-49b3-9d37-61d51488daab	70b6c110-e1f7-4117-90e2-5ecb1a6c471c	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:24
585140fe-d243-4bec-989a-6f41963f269e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	c8ee9713-6348-4525-ac7a-27b373d312df	585140fe-d243-4bec-989a-6f41963f269e	\N	2019-10-29 19:26:22	2022-12-01 10:23:22	\N	2019-12-19 08:08:24
d2fe074f-cff6-4a2c-a567-b4a2ef6a724e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	5132bbaa-b74f-4719-86b7-5cfe82b86531	d2fe074f-cff6-4a2c-a567-b4a2ef6a724e	\N	2019-10-29 19:26:22	2022-12-01 10:23:25	\N	2019-12-19 08:08:24
3f9e45bd-7268-40a1-b992-379aa9dd1e87	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	e9cef568-2ada-4e64-b69f-00c23c5d8604	3f9e45bd-7268-40a1-b992-379aa9dd1e87	\N	2019-10-29 19:26:22	2022-12-01 10:23:26	\N	2019-12-19 08:08:24
ccd69987-2620-4283-bc3f-ef1a02da2f00	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	a5f73eaf-350d-41c0-8c11-6cba998499e3	ccd69987-2620-4283-bc3f-ef1a02da2f00	\N	2019-10-29 19:26:22	2022-12-01 10:23:29	\N	2019-12-19 08:08:25
f5811be0-6d20-4c4a-953d-d7a2db8e2971	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	4f8e0696-ebb4-406b-a15d-10ddcaa85487	f5811be0-6d20-4c4a-953d-d7a2db8e2971	\N	2019-10-29 19:26:22	2022-12-01 10:23:29	\N	2019-12-19 08:08:24
89e06175-2616-4a0e-8e1e-484149d4f5a3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	71e270b7-10e5-40cd-af79-1b5d07c2d9ab	89e06175-2616-4a0e-8e1e-484149d4f5a3	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
785eacf9-a154-4633-8ff3-b228e71051cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	edf2c1a4-2d1f-471d-8e72-eb63959b5b64	785eacf9-a154-4633-8ff3-b228e71051cc	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
077827b3-3d3d-4d01-ac44-e485e61c227d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	b8597d0a-533b-11e5-af98-8f68bbe85388	077827b3-3d3d-4d01-ac44-e485e61c227d	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
eb7f8744-7f73-4a18-a65f-dd6969a7349d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	80b4667d-8acd-e211-b89c-d12bb761bc4d	eb7f8744-7f73-4a18-a65f-dd6969a7349d	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
341dc2ea-8bc9-457e-94cc-bd6818b36ffe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	b4745045-5baf-416a-9da6-ec039566537b	341dc2ea-8bc9-457e-94cc-bd6818b36ffe	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
dbd86521-6aff-49f8-9c3e-044eb03b1bd4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	6c136cf3-8b03-e211-8560-17962475f905	dbd86521-6aff-49f8-9c3e-044eb03b1bd4	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
bf89c975-6d9c-4bb0-abff-6097aba726e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	ae5c71e9-252b-4467-8805-fadddbaf89c4	83f19b66-6034-4ee8-a979-83b216cf6efd	\N	2019-10-29 19:26:22	2020-02-20 15:02:16	2020-02-20 15:02:16	2019-12-19 08:08:24
640e9db1-cd9e-4c33-a7be-580289550a33	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	c1b9c50b-2f0c-4cd5-a664-0bfa77156728	d2e06add-b2cc-4d4a-94b1-8cb9f8f61af0	\N	2019-10-29 19:26:22	2019-11-12 21:19:18	2019-11-12 21:19:18	2019-10-31 17:53:06
6cc22625-f12c-4f39-82a5-cbf11bdf4999	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	b35c01a3-37d8-4b9c-921d-65a382a1ca70	ca63c2e9-c361-4f1d-9bb5-6014e77fe37b	\N	2019-10-29 19:26:22	2019-12-19 08:08:24	\N	2019-12-19 08:08:24
6dbdd7c1-888e-4da9-87e3-62c6982aa30c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	607b1b72-46d2-11e5-ba50-1375139e8458	2c396e76-973c-4b61-9bea-0344c57dfb0f	\N	2019-10-29 19:26:22	2019-12-19 08:08:24	\N	2019-12-19 08:08:24
ed212e12-039c-4264-ada5-ae7eb94a5e4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	54976902-8866-4627-a970-0abcb6abb6f9	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	2019-10-29 19:26:22	2019-12-10 11:00:53	2019-12-10 11:00:53	2019-12-10 08:23:16
d8a3a74b-9199-4e4b-bd50-4a2a35d0aa44	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	3ad03a6a-9caa-40e4-a060-62e1680cd17b	d8a3a74b-9199-4e4b-bd50-4a2a35d0aa44	\N	2019-10-29 19:26:22	2022-12-01 10:22:48	\N	2019-12-19 08:08:24
4a919f90-f674-422f-bff8-bb584fccb69a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	6b031760-aef5-4dbb-b520-01e6685a54d1	4a919f90-f674-422f-bff8-bb584fccb69a	\N	2019-10-29 19:26:22	2022-12-01 10:22:51	\N	2019-12-19 08:08:24
079496be-d351-4994-b6f7-46576d100d96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	da2e3e30-22ee-11e4-90f6-53330a5cd670	079496be-d351-4994-b6f7-46576d100d96	\N	2019-10-29 19:26:22	2022-12-01 10:22:52	\N	2019-12-19 08:08:24
1c129d5c-69c5-4178-94f2-3cc7cd84ae7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	b7b48546-4541-11e5-b9f9-e7e850efd101	1c129d5c-69c5-4178-94f2-3cc7cd84ae7d	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:25
10b0339f-e89c-4140-b2b1-a08b22b8f289	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	d5b3a578-1613-474e-865b-0a47f3a64167	10b0339f-e89c-4140-b2b1-a08b22b8f289	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:25
b57982de-3d7a-4425-81d0-dcb06f848d15	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	b57982de-3d7a-4425-81d0-dcb06f848d15	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:25
279a21ce-d1d9-45ea-a19e-5e5b92bf655c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	78027dc1-f7e5-434a-b0c3-767f331840bb	279a21ce-d1d9-45ea-a19e-5e5b92bf655c	\N	2019-10-29 19:26:23	2022-12-01 10:22:58	\N	2019-12-19 08:08:25
94d5e521-28cf-49a0-8e03-4bbb691464ea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	2704f9d0-22fc-11e4-859d-e78b145c39c9	94d5e521-28cf-49a0-8e03-4bbb691464ea	\N	2019-10-29 19:26:23	2022-12-01 10:22:59	\N	2019-12-19 08:08:25
a78fefce-0563-47e7-ae90-e5dd82528c4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	8cf66883-ebc1-473e-a01c-37925b2b2150	a78fefce-0563-47e7-ae90-e5dd82528c4b	\N	2019-10-29 19:26:23	2022-12-01 10:23:00	\N	2019-12-19 08:08:25
f9e073d5-9aa3-455d-9492-6272d7d8b0f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	31d87dba-8af0-48a5-a609-901bda9031d3	f9e073d5-9aa3-455d-9492-6272d7d8b0f1	\N	2019-10-29 19:26:23	2022-12-01 10:23:00	\N	2019-12-19 08:08:25
7632d02a-a796-45cb-b1a3-6d8870a015b1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	4e27de9b-f65a-489f-8db8-7a6cb724fa6f	7632d02a-a796-45cb-b1a3-6d8870a015b1	\N	2019-10-29 19:26:23	2022-12-01 10:23:02	\N	2019-12-19 08:08:25
d49ae207-f0b1-4982-abe4-0cf3fe192867	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	6ba43a51-d4b8-4b42-a964-915453deb56a	d49ae207-f0b1-4982-abe4-0cf3fe192867	\N	2019-10-29 19:26:23	2022-12-01 10:23:04	\N	2019-12-19 08:08:25
d30e50fc-b4b6-4e2b-96e7-cac6e3e5655a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	304a3c38-bda8-4b1f-b2ef-087817e35993	d30e50fc-b4b6-4e2b-96e7-cac6e3e5655a	\N	2019-10-29 19:26:23	2022-12-01 10:23:04	\N	2019-12-19 08:08:25
452f06ee-047c-4a3f-94a3-532f6596fa98	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	679c6691-5977-4188-b9cb-15090b3fb85f	452f06ee-047c-4a3f-94a3-532f6596fa98	\N	2019-10-29 19:26:22	2022-12-01 10:23:06	\N	2019-12-19 08:08:25
0abf8bd9-51f3-4d0d-8048-e9af113c17f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	0abf8bd9-51f3-4d0d-8048-e9af113c17f4	\N	2019-10-29 19:26:22	2022-12-01 10:23:07	\N	2019-12-19 08:08:25
fc56fd81-b6da-414c-ad8f-0e2d600c2111	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	f80b678d-bb43-4915-9ef0-22b1d2320638	fc56fd81-b6da-414c-ad8f-0e2d600c2111	\N	2019-10-29 19:26:23	2022-12-01 10:23:07	\N	2019-12-19 08:08:25
c9184d83-e822-415c-9f65-bdca354f6619	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	8e10391f-07fe-41b9-84c7-106974b83db3	c9184d83-e822-415c-9f65-bdca354f6619	\N	2019-10-29 19:26:23	2022-12-01 10:23:10	\N	2019-12-19 08:08:25
37bcb729-2e24-4d1f-bdfe-142ade2fa5d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	a968b612-4bac-11e5-bce0-9f0e431a474f	37bcb729-2e24-4d1f-bdfe-142ade2fa5d0	\N	2019-10-29 19:26:23	2022-12-01 10:23:10	\N	2019-12-19 08:08:25
4a1e647c-e024-40bb-8d30-1c110832cac8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	c795df6e-a22f-478f-9005-76d13d30bab4	4a1e647c-e024-40bb-8d30-1c110832cac8	\N	2019-10-29 19:26:23	2022-12-01 10:23:10	\N	2019-12-19 08:08:25
3b3b014e-f880-4bbb-9309-b771f70d21ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	2a0784f4-94ee-435b-8fb3-8c798d15d817	3b3b014e-f880-4bbb-9309-b771f70d21ee	\N	2019-10-29 19:26:23	2022-12-01 10:23:11	\N	2019-12-19 08:08:25
485e7536-ac00-4dd7-90a6-1593cbae3076	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	d57f4561-8cb1-42ae-940e-7943cdae287b	485e7536-ac00-4dd7-90a6-1593cbae3076	\N	2019-10-29 19:26:23	2022-12-01 10:23:11	\N	2019-12-19 08:08:26
b9150933-404e-40a5-997d-6027e0254744	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	010a4695-214e-4efb-a13b-83ab9a7e5a9a	b9150933-404e-40a5-997d-6027e0254744	\N	2019-10-29 19:26:22	2022-12-01 10:23:11	\N	2019-12-19 08:08:25
776f0750-86a6-49a4-b0cf-63694ec6bb23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	02c9180a-0b24-4ac4-b544-24d968340f61	776f0750-86a6-49a4-b0cf-63694ec6bb23	\N	2019-10-29 19:26:23	2022-12-01 10:23:12	\N	2019-12-19 08:08:25
e37e60eb-e850-47cf-8962-c2c16aca8212	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	edbf1ed9-b137-4d28-8af1-a22ab23be53b	e37e60eb-e850-47cf-8962-c2c16aca8212	\N	2019-10-29 19:26:23	2022-12-01 10:23:13	\N	2019-12-19 08:08:25
d8e30acc-b389-4139-85f0-28d60da560fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	2c1847a5-ae44-40e2-836e-cc566e0ed984	d8e30acc-b389-4139-85f0-28d60da560fd	\N	2019-10-29 19:26:23	2022-12-01 10:23:13	\N	2019-12-19 08:08:25
3bc69c1c-7d88-4fe8-bb28-3a2b09b3d533	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	daa07555-dd3d-44da-856b-28f08ecd474e	3bc69c1c-7d88-4fe8-bb28-3a2b09b3d533	\N	2019-10-29 19:26:23	2022-12-01 10:23:16	\N	2019-12-19 08:08:25
9f01c0d4-2898-48d2-b0f6-328b440d00b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	36aa6f27-73dc-4d6c-98e8-cb7a01d1f686	9f01c0d4-2898-48d2-b0f6-328b440d00b4	\N	2019-10-29 19:26:23	2022-12-01 10:23:17	\N	2019-12-19 08:08:25
efa92150-b37e-48c5-8ef4-f0e11c86b6cd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	2f627335-3b69-4db3-94e3-0a43968e23e9	efa92150-b37e-48c5-8ef4-f0e11c86b6cd	\N	2019-10-29 19:26:23	2022-12-01 10:23:24	\N	2019-12-19 08:08:25
82717e43-1ae2-44b2-a9cf-a3b70f2e7209	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	7033d6a0-a087-4922-a949-32763edc8bc4	82717e43-1ae2-44b2-a9cf-a3b70f2e7209	\N	2019-10-29 19:26:23	2022-12-01 10:23:24	\N	2019-12-19 08:08:25
0ddd1bb7-e9fa-48ac-bc31-027692683d41	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	f4241e37-70b6-4e48-91c1-08dcd7996be0	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	0ddd1bb7-e9fa-48ac-bc31-027692683d41	\N	2019-10-29 19:26:23	2022-12-01 10:23:26	\N	2019-12-19 08:08:25
b7455933-2830-475a-956d-04bd2ba1b301	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	568a2d30-3a78-43fd-81ea-2c98ec3d3865	b7455933-2830-475a-956d-04bd2ba1b301	\N	2019-10-29 19:26:23	2022-12-01 10:23:26	\N	2019-12-19 08:08:25
1dcc73d8-45a8-4cef-bfb4-45f513d9bebe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	243b6119-e39f-4849-8fd0-218155575c5a	1dcc73d8-45a8-4cef-bfb4-45f513d9bebe	\N	2019-10-29 19:26:23	2022-12-01 10:23:26	\N	2019-12-19 08:08:25
69adf20d-af1d-4349-af5b-c91841970999	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	69adf20d-af1d-4349-af5b-c91841970999	\N	2019-10-29 19:26:23	2022-12-01 10:23:29	\N	2019-12-19 08:08:25
af54fd6f-7f79-41aa-8bf5-eaa80b3b5d20	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	5d81ded5-cf07-e211-9482-ab4b6567f9f7	af54fd6f-7f79-41aa-8bf5-eaa80b3b5d20	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
dca2e4e0-533d-4618-9ec7-08b0b53369bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	2bfe543e-2a1f-11e4-bc2d-cb05e5722fa8	dca2e4e0-533d-4618-9ec7-08b0b53369bb	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
d47d3026-f14a-4184-8efb-1f2766857cae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	1043eb6a-a5c9-4e29-92ec-e5a3eea29247	d47d3026-f14a-4184-8efb-1f2766857cae	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
2e184d13-0080-4ba8-b5e3-c1a8cb259b53	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	3c1ceee8-8105-11e3-833a-9bdba6d1ca50	2e184d13-0080-4ba8-b5e3-c1a8cb259b53	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
95cf17c4-d536-43fe-8cf1-bf997485db0b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	84f52c40-b361-11e4-97f5-07149f66330b	95cf17c4-d536-43fe-8cf1-bf997485db0b	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
d7a72d4e-cc09-486c-a6ca-ecff7566dcbb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	809cc787-3fd3-432e-a2ff-60869b73270a	dfa5a722-6f17-4fb5-aa1d-5e21e7c788f2	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
efd2c519-fe73-491e-9805-0a755405a1ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	ba4c4be1-11c9-4977-b20e-2b612e3b9122	2e234a8e-ce9d-480f-97c8-4f2eede93714	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
beca55f9-d01e-41b8-9a60-69a1b198b74f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	2ce2d78d-c08f-4bc0-ad14-5839f5e3e971	e2ceda21-318a-4462-be49-65f93502942b	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
47b65f94-3de4-486a-be3e-371c0ca42d67	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	6cc259bc-9b9f-4b5c-89a3-58da901c76ca	c76d8fb9-d352-445b-aee3-ba47ec914117	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
fbfbf45b-20af-43e1-ae66-6479b958bf2f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	afa9b1c8-3472-415f-84f9-ebf2e77d296b	965a1782-cd52-47be-a0fa-fa919675a613	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
1ef52484-cba0-4562-bb22-8317f771e11c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	904839e9-4121-49ea-9a54-036853ea01a4	62225ed3-4dac-4496-b20b-68071b7b8033	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
fb436594-8122-41c9-9eca-1c54b2005591	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	49c42d50-e89b-41f5-a357-7b9cd0b2e218	9c31cbf1-7afb-4b09-adb3-0845ff799a34	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
e0236c59-486b-448f-88fd-24bde16eaa80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	dd2adab5-bbce-4c7d-8cbd-01a872b3d516	6c70afa4-3e19-4263-89f3-874d8fb14507	\N	2019-10-29 19:26:23	2021-10-26 09:36:52	2021-10-26 09:36:52	2019-12-19 08:08:25
5cb1d422-7b02-41cc-a88c-ee3b411d1e6a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	0fe246e8-04b1-40fc-a6ce-aa23445ab6c4	\N	2019-10-29 19:26:23	2019-12-10 11:01:16	2019-12-10 11:01:16	2019-12-10 08:23:16
79f0b87b-49a0-4464-88c8-7d5fd63ec2b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	7661d6a5-1907-41fd-8c82-a5fea385fef8	1886d81b-ba50-4ce9-9694-12fc5c63170b	\N	2019-10-29 19:26:22	2019-12-10 11:01:09	2019-12-10 11:01:09	2019-12-10 08:23:16
6dc1a98b-9f19-4a63-8167-de593cc25acb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	7b6763fc-6f9f-11e3-b017-03efaa0c94af	1478689a-db4d-4473-bf45-e4b717e75960	\N	2019-10-29 19:26:22	2019-12-19 08:08:25	\N	2019-12-19 08:08:25
c6afe634-f701-4a0e-ba72-22e9bab449c8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	37574861-bbb9-409c-bdfd-38c4f3048653	\N	2019-10-29 19:26:23	2019-12-10 11:01:32	2019-12-10 11:01:32	2019-12-10 08:23:16
fb837793-29f3-43e0-b111-03a417d37db6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	43995feb-8d7d-4f37-9a8b-b2ab3ff70ac2	fb837793-29f3-43e0-b111-03a417d37db6	\N	2019-10-29 19:26:23	2022-12-01 10:22:48	\N	2019-12-19 08:08:25
1b49f20a-b7e5-47e5-ac3b-591ebc423743	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	afab5d0b-c4da-455e-bd0a-8644da49ab0f	1b49f20a-b7e5-47e5-ac3b-591ebc423743	\N	2019-10-29 19:26:22	2022-12-01 10:22:50	\N	2019-12-19 08:08:25
d671772c-b3b1-4f33-827b-5baee4353b37	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	bd4085a1-82ec-450b-9507-7924581dc0fc	d671772c-b3b1-4f33-827b-5baee4353b37	\N	2019-10-29 19:26:22	2022-12-01 10:22:50	\N	2019-12-19 08:08:25
100fea3b-0973-446b-95c6-c53ef7e05254	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	00e6f0c6-c214-4588-90c0-4a271deaa2c9	100fea3b-0973-446b-95c6-c53ef7e05254	\N	2019-10-29 19:26:23	2022-12-01 10:22:51	\N	2019-12-19 08:08:26
55b6dd8a-5fef-446b-b99a-33eb13512214	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	4c42f155-3a8b-4690-b9c4-f92f8d413990	55b6dd8a-5fef-446b-b99a-33eb13512214	\N	2019-10-29 19:26:23	2022-12-01 10:22:53	\N	2019-12-19 08:08:25
0f9dce63-c5c7-4e1a-a9a4-4eaf15dbe449	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	d1de7680-727c-4931-a9c8-1cc3a384a7c5	0f9dce63-c5c7-4e1a-a9a4-4eaf15dbe449	\N	2019-10-29 19:26:23	2022-12-01 10:22:54	\N	2019-12-19 08:08:25
fe67884f-c50c-446b-be14-f00813155576	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	fe67884f-c50c-446b-be14-f00813155576	\N	2019-10-29 19:26:23	2022-12-01 10:22:54	\N	2019-12-19 08:08:25
c1a99b89-6227-403e-b8bf-bddde71cf971	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	d6276643-bada-4ca6-a7d6-27f02efbd2c2	c1a99b89-6227-403e-b8bf-bddde71cf971	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:25
2e335787-fcb4-4fe8-ad58-26e4cba6f336	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	2e335787-fcb4-4fe8-ad58-26e4cba6f336	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:25
0e5f48d0-408d-4a35-8bd0-ab66cd071668	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	06b71793-3a86-4c6b-9000-717dca267295	0e5f48d0-408d-4a35-8bd0-ab66cd071668	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:26
2814ed5a-b75e-4f49-ba3d-d0a1d30200b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	8c54af21-d3fa-4eba-b89f-b628ab9fa013	2814ed5a-b75e-4f49-ba3d-d0a1d30200b6	\N	2019-10-29 19:26:23	2022-12-01 10:22:57	\N	2019-12-19 08:08:25
8c764576-a7ca-4a52-a0dd-a7663a74a5cd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	bd3a2d69-e9b5-4462-9057-eb4b035b297d	8c764576-a7ca-4a52-a0dd-a7663a74a5cd	\N	2019-10-29 19:26:23	2022-12-01 10:22:58	\N	2019-12-19 08:08:25
f12387c5-2182-485c-80be-33cc03395422	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	14fba9a1-6ca4-4937-84e7-2a845d02897a	f12387c5-2182-485c-80be-33cc03395422	\N	2019-10-29 19:26:23	2022-12-01 10:22:58	\N	2019-12-19 08:08:25
4547523e-7c51-422f-9cc1-c0fcf70726f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	5899f113-d963-4965-9245-1f6222f5bbc1	4547523e-7c51-422f-9cc1-c0fcf70726f2	\N	2019-10-29 19:26:23	2022-12-01 10:23:01	\N	2019-12-19 08:08:25
e580840e-d130-4735-bf89-221cc3c37b08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	1f87026c-1601-4eb9-9b82-64289bded8ed	e580840e-d130-4735-bf89-221cc3c37b08	\N	2019-10-29 19:26:23	2022-12-01 10:23:02	\N	2019-12-19 08:08:26
41cddece-8368-4dff-86b7-737e006360fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	b5b764d4-4c3f-11e5-9257-b3688b89f32b	41cddece-8368-4dff-86b7-737e006360fd	\N	2019-10-29 19:26:23	2022-12-01 10:23:04	\N	2019-12-19 08:08:26
4b918f7e-ee56-4988-820c-4384029c093b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	4b918f7e-ee56-4988-820c-4384029c093b	\N	2019-10-29 19:26:23	2022-12-01 10:23:04	\N	2019-12-19 08:08:26
7f8e20d4-3d56-4b95-a364-cf7de3c45cb9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	37dd7c39-5a77-4fb3-8bf4-31fe5f545da1	7f8e20d4-3d56-4b95-a364-cf7de3c45cb9	\N	2019-10-29 19:26:23	2022-12-01 10:23:05	\N	2019-12-19 08:08:25
b0116c38-9e9f-47bb-a887-5477e5e53d98	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	b0116c38-9e9f-47bb-a887-5477e5e53d98	\N	2019-10-29 19:26:23	2022-12-01 10:23:05	\N	2019-12-19 08:08:26
e7f377f3-660c-474a-aeb4-e6063630f0fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	d28672c2-c5a5-4238-a802-fd30f1f8341d	e7f377f3-660c-474a-aeb4-e6063630f0fa	\N	2019-10-29 19:26:23	2022-12-01 10:23:06	\N	2019-12-19 08:08:26
aa9d3f7f-140e-4ca4-b5cf-47378a8106c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	42d0f133-d66c-4ae9-a769-9547b1482539	aa9d3f7f-140e-4ca4-b5cf-47378a8106c9	\N	2019-10-29 19:26:23	2022-12-01 10:23:08	\N	2019-12-19 08:08:26
34c1ffb1-d7b6-45ee-a0cd-f4d1dd72b5e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	1438adc2-38fc-11e4-b641-3f0b3de385b4	34c1ffb1-d7b6-45ee-a0cd-f4d1dd72b5e9	\N	2019-10-29 19:26:23	2022-12-01 10:23:08	\N	2019-12-19 08:08:25
a10c0e87-818e-4dff-b98c-133c40351505	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	f4241e37-70b6-4e48-91c1-08dcd7996be0	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	a10c0e87-818e-4dff-b98c-133c40351505	\N	2019-10-29 19:26:23	2022-12-01 10:23:10	\N	2019-12-19 08:08:26
1071e889-9d30-4a60-8523-d04ad88bb4a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	04a45a78-7f1b-4cad-a70f-732efa5f7985	1071e889-9d30-4a60-8523-d04ad88bb4a2	\N	2019-10-29 19:26:23	2022-12-01 10:23:11	\N	2019-12-19 08:08:26
4ae4ca9c-01f7-4cd6-bc5f-51f71fe7ddfd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	698259da-b323-4524-92e3-706ec09179bd	4ae4ca9c-01f7-4cd6-bc5f-51f71fe7ddfd	\N	2019-10-29 19:26:23	2022-12-01 10:23:16	\N	2019-12-19 08:08:25
84c025ab-d0d0-442b-97cc-eb477fb22c7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	8e47faed-6b87-4baf-8d94-d778345455f3	84c025ab-d0d0-442b-97cc-eb477fb22c7f	\N	2019-10-29 19:26:23	2022-12-01 10:23:17	\N	2019-12-19 08:08:26
450956c4-e487-4229-a1d2-140bf0f2fc72	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	6e12f9fd-e106-472d-8364-ce7da552e702	450956c4-e487-4229-a1d2-140bf0f2fc72	\N	2019-10-29 19:26:23	2022-12-01 10:23:22	\N	2019-12-19 08:08:26
f923d050-f862-4957-9b0b-09a074f4c7b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	cf3761de-7aae-48d8-aec8-088c3e87e8ed	f923d050-f862-4957-9b0b-09a074f4c7b3	\N	2019-10-29 19:26:23	2022-12-01 10:23:23	\N	2019-12-19 08:08:25
a048ad63-8e70-4412-a822-aa7e2e644393	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	22278151-6aec-4b87-bfab-3bf8d1810468	a048ad63-8e70-4412-a822-aa7e2e644393	\N	2019-10-29 19:26:23	2022-12-01 10:23:24	\N	2019-12-19 08:08:26
7ab9baf3-097b-48c5-95af-f238ce3e88b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	1d64c4a6-b263-441e-82e2-763c790c3c05	7ab9baf3-097b-48c5-95af-f238ce3e88b6	\N	2019-10-29 19:26:23	2022-12-01 10:23:25	\N	2019-12-19 08:08:26
1d2a9c5d-8417-45dc-be58-b1e50c9d87ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	1d2a9c5d-8417-45dc-be58-b1e50c9d87ab	\N	2019-10-29 19:26:23	2022-12-01 10:23:26	\N	2019-12-19 08:08:26
845772ad-8c90-462b-be4d-8534b0814468	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	d0dca4af-4472-4232-af75-aaabf7ca88e7	845772ad-8c90-462b-be4d-8534b0814468	\N	2019-10-29 19:26:23	2022-12-01 10:23:29	\N	2019-12-19 08:08:26
61c6ab9f-b858-4ab5-825d-f47a56e8d195	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	472d73e3-2d2f-488f-8e2f-cd3d22418632	61c6ab9f-b858-4ab5-825d-f47a56e8d195	\N	2019-10-29 19:26:23	2022-12-01 10:23:29	\N	2019-12-19 08:08:26
32dd39dc-4beb-4b6f-ad88-3dc5b7252dab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	1a68049f-e368-4766-8709-c7b9920f5e90	32dd39dc-4beb-4b6f-ad88-3dc5b7252dab	\N	2019-10-29 19:26:23	2022-12-01 10:23:29	\N	2019-12-19 08:08:25
6541fbb0-8a41-431c-86df-86e394a59703	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	1f59f4f2-9003-e211-8560-17962475f905	6541fbb0-8a41-431c-86df-86e394a59703	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
6ec799ca-0d85-4ef5-9a51-e8cee73c7cbe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	0769190c-5d64-11e3-8b30-dffbe206ec8a	6ec799ca-0d85-4ef5-9a51-e8cee73c7cbe	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
fe132f1c-983d-492c-b593-066056feb9e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	4e3df8d9-0602-e211-8442-77d6f35b44ad	fe132f1c-983d-492c-b593-066056feb9e5	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
177f9999-cbcb-4d16-8dfb-f13c9275191b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	b1e79070-5e22-11e3-9c6d-233c893822c5	177f9999-cbcb-4d16-8dfb-f13c9275191b	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
4ec953a1-9761-4d30-96f6-ccecb456afca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	ffa42521-4f5a-4d0a-8efd-f4dc24fe7f45	4ec953a1-9761-4d30-96f6-ccecb456afca	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
937ee5e0-98a1-4852-88fc-28e7bf9659af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	94e3a835-6bcd-4974-8ed6-280f6f6ab49c	27983e04-7c07-4ba6-a044-5e10c51791d3	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
7c3c79d4-6ca0-4a9e-807d-5ef5902804a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	657848d6-1163-4c5a-ab34-202293061d49	c8e65a55-da0c-44b0-9355-86ead429257a	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
191f40b2-9371-4121-aacb-7c118b94540b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	1ca43a09-807b-41b4-be2a-c46027be07fc	784d14eb-3c08-45a7-8bb7-90d653238a50	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
1aa6d3ea-f63c-4cf4-a177-47ad9092524d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	6207cf97-0d01-4dd6-ad87-d4327e455902	c9fdce89-d1c8-4ce0-89fe-ce1487804dc2	\N	2019-10-29 19:26:23	2021-12-15 08:21:07	2021-12-15 08:21:07	2019-12-19 08:08:26
4760d859-234c-4067-87d7-ccb536d7d188	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	1ad5d1b9-7243-4d6d-b1b8-7d52534ad3d9	c4ab938a-f282-4356-8a10-c9a21bd81eb3	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
5c7b95b8-451e-4685-a5ea-7c3527e61647	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	8ab6bd00-6969-4219-a22c-185039306f49	f54d24cb-6d68-4166-909d-3ad2f509318f	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
a3008503-82ca-48df-8dad-2f73ea092024	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	899e5af5-16c9-454d-aa58-49dfc3ad62a3	cbcce98a-9a01-4b19-ae97-29b590d5a074	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
53496817-a77f-451e-adb3-01607d8d657c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	b7817d76-5e53-4e4c-9210-6bbd77b73030	fd5d4fbc-2b63-45aa-8c14-23eabd89b9ca	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
b824f4f3-664f-4df1-9e12-9fcad23c9148	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	5ccc30ba-c3f3-43b8-9027-03c3d296f87e	8d2efc25-0b65-4b55-944c-60ac7de7d6cc	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
dbea4a91-cc33-4b4a-a93c-4c7c7b5b5ee6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	c64da501-02cf-4a9c-94fa-6e9e385cb880	1330c620-3828-4f83-ad78-b75db60226d9	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
cf290c17-f7c3-472e-a181-47be98b89596	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	5c283125-f9ea-4b50-9220-1ae80eddbf7c	18e9b1be-7824-4b74-a56d-6444ad06011e	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
6f06f7b6-570b-41c7-ba40-6f37a229079f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	e0e38c52-da5a-44a8-ac92-411718cd6332	b75b7bfd-c2a5-43dd-aac7-f30ef45ebb13	\N	2019-10-29 19:26:23	2019-12-19 08:08:25	\N	2019-12-19 08:08:25
ee04d52c-cf12-49d1-a85d-6020a059987d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	40e0b4f9-4d59-42c3-8cbf-b19fa370276c	645aba46-378c-11e4-a83f-afbd60abf5c3	ee04d52c-cf12-49d1-a85d-6020a059987d	\N	2019-10-29 19:26:23	2022-12-01 10:22:50	\N	2019-12-19 08:08:26
de7c7a43-a68d-41f7-9f53-47dabc6607c8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	900ffa20-46cc-11e5-8abe-0337176d8d23	de7c7a43-a68d-41f7-9f53-47dabc6607c8	\N	2019-10-29 19:26:23	2022-12-01 10:22:50	\N	2019-12-19 08:08:25
77c10b58-7832-46a1-874d-b69e473a8c59	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	b32063b6-462b-11e5-9585-133f160aafbb	77c10b58-7832-46a1-874d-b69e473a8c59	\N	2019-10-29 19:26:23	2022-12-01 10:22:51	\N	2019-12-19 08:08:26
945bb4d6-64d7-4d09-8e71-054f138a6c3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	0c57cc9c-4c32-11e5-858c-afbc5904667e	945bb4d6-64d7-4d09-8e71-054f138a6c3a	\N	2019-10-29 19:26:23	2022-12-01 10:22:51	\N	2019-12-19 08:08:26
a84bad28-891f-4517-bb3f-a6cf56d2c60c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	d90d0294-59e6-4283-a821-c9b6aaae536b	a84bad28-891f-4517-bb3f-a6cf56d2c60c	\N	2019-10-29 19:26:23	2022-12-01 10:22:53	\N	2019-12-19 08:08:25
a4a4fb48-51aa-48c8-af3b-5265fcb4cc25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	5fb28ec2-45dd-45c4-8021-0e597172c690	a4a4fb48-51aa-48c8-af3b-5265fcb4cc25	\N	2019-10-29 19:26:22	2022-12-01 10:22:53	\N	2019-12-19 08:08:25
d356d865-6ed1-4e84-8c33-cff0756ca3a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	beb52866-067c-4257-aa11-ac304217924c	d356d865-6ed1-4e84-8c33-cff0756ca3a9	\N	2019-11-12 21:19:16	2022-12-01 10:22:59	\N	2019-12-19 08:08:26
18411bdd-3df5-42cc-abdc-00cfc173574f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	d57f4561-8cb1-42ae-940e-7943cdae287b	18411bdd-3df5-42cc-abdc-00cfc173574f	\N	2019-12-06 16:14:39	2022-12-01 10:23:01	\N	2020-03-07 18:38:29
9616a30d-ae34-4902-9a7a-b022eb5a9926	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	11aea642-466b-11e5-886c-1b8856809555	9616a30d-ae34-4902-9a7a-b022eb5a9926	\N	2019-11-28 09:29:09	2022-12-01 10:23:05	\N	2019-12-19 08:08:25
a2dde135-8ac4-4502-af13-4e52099547d6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	e131badd-15c9-4911-8c81-1d30249b7d73	a2dde135-8ac4-4502-af13-4e52099547d6	\N	2019-10-29 19:26:22	2022-12-01 10:23:05	\N	2019-12-19 08:08:24
6e046c0d-357e-4536-ada5-9ee0c9f09f4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	2344b81a-f727-41d0-bdcf-b4fbc2557e5b	6e046c0d-357e-4536-ada5-9ee0c9f09f4d	\N	2019-10-29 19:26:23	2022-12-01 10:23:10	\N	2019-12-19 08:08:25
d4ca1870-6a58-4793-bf62-e7f7ceaaa48a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	4110f12e-94d8-11e3-9d19-577073295bc5	d4ca1870-6a58-4793-bf62-e7f7ceaaa48a	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
f632994a-f0f6-442b-bc07-cb6debf112ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	a8fda9da-6d1e-11e3-970c-93ebf835240a	f632994a-f0f6-442b-bc07-cb6debf112ff	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
419e9254-2d1e-456e-a2a6-6b8bb76f21ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	542df659-4377-411d-9fa8-1f5ce8878479	419e9254-2d1e-456e-a2a6-6b8bb76f21ec	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
fe775471-4966-40c5-b9f2-1728482aecfb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	912be006-94d8-11e3-9fbf-ef2adf253ed7	fe775471-4966-40c5-b9f2-1728482aecfb	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
b4b28ddc-a39c-4da7-b931-b1bcd01df36f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	6a459348-f991-4498-b483-82078efe1e29	b4b28ddc-a39c-4da7-b931-b1bcd01df36f	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
8470e127-d55d-438e-b8d7-78a9cdc29c26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	f5599d4e-2520-e211-ac85-4fdce694eced	8470e127-d55d-438e-b8d7-78a9cdc29c26	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
0441a4b9-5bde-4c74-a541-ea5a9991eb89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	e4cf82c4-67df-11e3-a0f5-c792454ff412	0441a4b9-5bde-4c74-a541-ea5a9991eb89	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
f7fca9b1-3fd3-4418-b5c8-975e1eae163f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	475ba4bd-cedf-4ba4-976b-d7a2ef695594	f7fca9b1-3fd3-4418-b5c8-975e1eae163f	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
df89fefc-69d5-4c88-bf62-c4c83c13a331	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	d29324b0-6ef3-11e3-a4d4-23ef5f321119	df89fefc-69d5-4c88-bf62-c4c83c13a331	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
8556547f-ffda-4f25-88ca-4cdc9737b180	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	185763fc-94d9-11e3-86ab-4b04feeb706c	8556547f-ffda-4f25-88ca-4cdc9737b180	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
a559819a-7496-4e43-89a3-19ed73881f30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	7adea11a-561c-11e5-900a-eb2673a1373b	a559819a-7496-4e43-89a3-19ed73881f30	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
642bb575-cc30-479f-bc16-1b869d2bbfac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	f530a57f-1b10-e211-9570-4d846480b264	642bb575-cc30-479f-bc16-1b869d2bbfac	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
71e174d0-4dcb-4b07-abbd-f0384fc50b25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	d06848d7-c129-e211-82ed-4bf89d6bb6ec	71e174d0-4dcb-4b07-abbd-f0384fc50b25	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
031f0db8-7771-4eeb-8a9a-35790d196efd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	217aabe8-662e-11e4-8763-376fcef79753	031f0db8-7771-4eeb-8a9a-35790d196efd	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
e28a7d1c-9af7-4a36-bdba-1783333ba397	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	724ef4b0-3f1e-e211-ad21-a3a026533b4a	e28a7d1c-9af7-4a36-bdba-1783333ba397	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
6365d031-ba95-4bd8-a878-b831e5164eeb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	a4195ffe-991a-e211-978e-3b930968aceb	6365d031-ba95-4bd8-a878-b831e5164eeb	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
cd89f14a-86de-4eda-99ec-605f5c748836	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	fc887591-cc90-441b-ab14-7f04d4488c3b	cd89f14a-86de-4eda-99ec-605f5c748836	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
33ac31a3-eba1-4e56-af06-68d4627e6acf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	1c7228a9-1f68-445a-8984-2d1e5562c07e	1dae0abf-d65c-40f2-85f6-1428c6734eab	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
f957efe7-223d-4507-83d6-f4d9cf27ecda	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	133e3c9e-3ea0-4f1b-9f0c-4deeb55151f5	270dfa0b-5ed3-415e-b27e-c2e1b7ca454e	95d503f1-0371-4448-9f3c-5056b35a53a3	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
6e9a16e8-9802-4408-9b85-6a1d77e3e701	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	370cd1cb-3ca6-45f3-a6f9-41054b7b00ce	f20c7b7b-a5e8-43aa-92a2-cfa5017fca78	\N	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31	2019-10-29 19:26:31
9aec7218-dd8b-49b1-bead-c4b0445acc98	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	abd3dc01-b4a5-482a-83cd-e59414b755e3	f72301a0-b0e3-4bf3-b60b-6e7d2a7dec86	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
6061ff0e-721e-42d4-a70c-2d114e1bfcf7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	72a82433-c205-4737-b5db-98caef0e0f28	16af35c3-d85d-4eff-8dd1-42a1512b5f98	e1731158-4cd7-452b-83d0-78769475a07c	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
24a287fe-6435-4352-bd23-87b176c71673	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	dc528254-f614-4b59-8d60-f2873723def0	854b5756-dd3d-4430-a2d2-1341c340a1e3	b6984e06-24b4-4041-8443-fee879afed68	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
f9a9b56e-f35a-4b16-9e2a-91132ad79ab8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	3e4a24a8-e3ee-4490-bf7d-95b78da12418	d25f477b-8d03-4110-bea3-6082ff171b02	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
e6cd4e7f-115c-4481-8a27-b80b7c9dae25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	b763c7ff-1a60-46f2-9e0b-df3e8b3ff8b7	87b7ad70-06dc-4896-b7da-40046617608d	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
d3391467-41b7-4da8-91eb-dbe905aef672	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	c718b28e-fce5-45ab-aaf6-7dd7f603fb2a	ef28bece-59bc-42f3-b7fb-3b7e1fdc36e1	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
16f64c1b-ef89-48ac-ac90-2a71766bbba7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	fcbc357e-e236-44fd-91d3-e6396ef77880	2c8dba30-6c5e-4b08-8fe0-d10d2a3283cf	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
5bc45be3-5ad0-4d0a-8996-efcde981b857	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	0209bbd7-f72f-4c6a-b9b4-3ad1bededa01	688ced08-5167-4660-b289-19761aa3a952	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
d92fd31c-e6c6-421e-b23a-4e065f12ce6f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	7cbcc334-1dd3-4eaf-a779-f80bb217876e	1d4878a6-67f3-415d-bc19-1f76ef8c471b	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
4c7d434a-ca8d-456a-a8fd-abab58bafb23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9e630f4f-3566-4aca-a98d-d8de065c4f3f	7505ac56-204e-4e39-8840-bc272100eb8f	44fa7f61-0a8b-4e38-b188-55c7b1cbbc28	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
69d88b3d-5e44-4dd0-b95b-3051407d4679	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	f953b955-181c-45a2-9b12-025939a5b928	89f33052-fb49-41bc-bd54-b4c58f8c2923	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
987f6d2b-81d5-4805-ae79-d0e43921e944	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	10f92f00-ce52-467a-a9e0-df2775338f42	a75746a7-5b44-41d0-a756-d131133a5029	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
610f0479-73fd-4601-991f-c55319813f61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	7cd24fd3-6a9f-4562-9f20-9b06947a78b8	a1bf2962-6cc7-4f9f-bf3d-3e818341f7e2	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
81fd8fac-d963-41c2-8dee-cd388447f4cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	c2ccd165-0d65-4ce3-b466-a4ea2ce232d8	cff9390f-f63c-4a3f-9189-6f340fd6a823	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
c7aeb2c4-b827-4bfc-9519-66b2cca9ea67	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	9fd24f1b-1ad4-485e-b31c-96de0e2f84cf	f0981b27-c959-4d54-841d-f6466c0156eb	84e0a480-9385-47b0-a1a5-a91ea29ce1b3	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
23854a40-4fdc-4caf-977c-73fafdac45d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	a37e2efd-c356-4b7e-855b-7820d518e740	e758a177-f0c8-4a34-9af8-841a4012b902	67947426-91c6-4529-b76f-b6843bae0495	\N	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32	2019-10-29 19:26:32
c112e1af-e68c-4957-90f5-7a4c296ec50f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	beb52866-067c-4257-aa11-ac304217924c	85f5df18-a1ee-4823-90f3-0a769e06470a	\N	2019-12-06 16:14:39	2019-12-06 17:36:36	2019-12-06 17:36:36	2019-12-06 17:32:34
1aad24b8-ca14-43fb-9d39-5889e532901a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	79325645-1812-4733-a6de-0598c750a68c	\N	2019-12-06 16:14:39	2019-12-06 17:36:26	2019-12-06 17:36:26	2019-12-06 17:32:34
d6eb59a2-75ac-4877-8f04-37e999936d41	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	91317e32-9ec9-468c-bf5b-ef891856d180	05b3236f-2b05-4b17-be84-0a423cb941b6	\N	2019-10-29 19:26:22	2019-11-15 18:27:30	2019-11-15 18:27:30	2019-10-31 17:53:06
a29afaf0-62cb-4d47-9fa1-172e1bf6ec5c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	5dabb656-2ddc-4da4-9fd7-00f051c889ee	\N	2019-12-06 16:14:39	2019-12-06 17:36:13	2019-12-06 17:36:13	2019-12-06 17:32:34
c6cc5c24-cbab-49a6-b4e8-57d4d97b120f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	8ab2a07c-7003-4ee7-8d16-dc8c015871de	8462527e-862e-4b54-b09b-a9c99a9f276d	c6cc5c24-cbab-49a6-b4e8-57d4d97b120f	\N	2019-10-29 19:26:22	2022-12-01 10:22:48	\N	2019-12-19 08:08:24
c2dba60c-dcdb-4d52-bdfc-510134d07a1e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	ff07bc11-35f4-4ff1-a749-78e30f56e52c	c2dba60c-dcdb-4d52-bdfc-510134d07a1e	\N	2019-10-29 19:26:23	2022-12-01 10:22:50	\N	2019-12-19 08:08:25
550b881e-d654-4689-96f1-f1eff6b94723	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	f9496132-3b0c-11e5-a92d-b7a7850016b8	550b881e-d654-4689-96f1-f1eff6b94723	\N	2019-10-29 19:26:22	2022-12-01 10:22:51	\N	2019-12-19 08:08:24
15f71897-3df3-495b-bb1a-6cda95677f05	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	f4241e37-70b6-4e48-91c1-08dcd7996be0	540161f2-51dc-11e5-ada1-57cb00fd65d6	15f71897-3df3-495b-bb1a-6cda95677f05	\N	2019-12-03 11:34:11	2022-12-01 10:22:52	\N	2019-12-19 08:08:24
efd3523b-5d91-47cd-a566-09d52852e528	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	4c42f155-3a8b-4690-b9c4-f92f8d413990	efd3523b-5d91-47cd-a566-09d52852e528	\N	2019-12-06 16:14:39	2022-12-01 10:23:08	\N	2020-03-07 18:38:30
5a1a5544-95fc-4252-8c12-e21d5d4fc35c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	250c0b5f-0e2c-e211-864c-79233e4c0063	5a1a5544-95fc-4252-8c12-e21d5d4fc35c	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
6693c98a-7771-4e85-b85d-46bb359e80c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	de80e2b4-e4fe-4c39-b3ac-00c56a811f3a	6693c98a-7771-4e85-b85d-46bb359e80c2	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
8b210590-75df-487d-9f7f-d82db4e1937e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	0c6a002f-208e-4340-9276-5ddf8c3c7931	8b210590-75df-487d-9f7f-d82db4e1937e	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
2d9cce28-3181-4f0f-9986-325a396454b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	7df870be-f674-4ed1-bf50-340cbfdc845a	2d9cce28-3181-4f0f-9986-325a396454b9	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
252c3715-fc9d-4800-adca-cfaf1f1588f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	9adb667d-8acd-e211-b8a0-d12bb761bc4d	252c3715-fc9d-4800-adca-cfaf1f1588f0	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
7a428044-9622-4c87-9497-568ac9cbf565	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	bf147454-3d40-11e4-bd52-dfaac3a0de5c	7a428044-9622-4c87-9497-568ac9cbf565	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
37753380-b27c-4fc8-be6c-be42879ef1c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	0a72bba4-4a47-11e5-ba01-1f889a42b431	37753380-b27c-4fc8-be6c-be42879ef1c9	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
0de8d24b-f40b-4300-824f-8ec2f615f6dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	d22b4808-88b2-11e3-8cc6-27bf35192807	0de8d24b-f40b-4300-824f-8ec2f615f6dc	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
37e29a1a-df99-40aa-ba43-8782f68e0eec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	074f93b5-b14c-43a4-9b32-ffa1f94d5238	37e29a1a-df99-40aa-ba43-8782f68e0eec	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
cab9bd70-f3cb-4719-a1c8-72c56d611f45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	4f34ea70-781e-11e3-af88-8738a490246c	cab9bd70-f3cb-4719-a1c8-72c56d611f45	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
4ccf445b-9ce0-446f-8227-667869612309	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	9e6521bc-0a02-e211-8442-77d6f35b44ad	4ccf445b-9ce0-446f-8227-667869612309	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
e6ab1490-6ffd-44cf-8663-fdae50d1a67a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	087c218d-0643-48d4-86ff-7c8017578e03	e6ab1490-6ffd-44cf-8663-fdae50d1a67a	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
ea101f87-6fa9-425c-9256-206ad5253d40	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	4697a155-d7d0-438e-8447-e684bde0b0c0	ea101f87-6fa9-425c-9256-206ad5253d40	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
e87881ef-f7dd-4094-aa64-01faff675204	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	fcc5677d-8acd-e211-b8be-d12bb761bc4d	e87881ef-f7dd-4094-aa64-01faff675204	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
a266556a-6980-4c3e-b223-6dfce9f13315	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	17e8de1b-c527-e211-963e-ffbc9c164446	a266556a-6980-4c3e-b223-6dfce9f13315	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
e88e82ba-6fc1-4634-93a9-c411a7c77d76	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	e88e82ba-6fc1-4634-93a9-c411a7c77d76	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
c1b39bb7-af75-40f4-bb3c-24b670d377f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	de4c9890-94d7-11e3-87b3-bf380a55277f	c1b39bb7-af75-40f4-bb3c-24b670d377f8	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
9cef0bc4-5303-49e7-a36b-079194a44def	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	b9b3e453-5f83-4976-91c2-cb4c8b272a0c	9cef0bc4-5303-49e7-a36b-079194a44def	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
efb5792f-0790-4a52-bf2c-30a0c4a7e3a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	0e3ca3aa-8e03-e211-8560-17962475f905	efb5792f-0790-4a52-bf2c-30a0c4a7e3a8	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
1edf6aa6-f2c7-4a4a-a573-b479d4c0675b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	1edf6aa6-f2c7-4a4a-a573-b479d4c0675b	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e053fec6-57a9-41c5-8dc4-3f7416996ede	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	a162a212-58ef-41b2-b66d-93490bd5fafc	e053fec6-57a9-41c5-8dc4-3f7416996ede	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
c61ed105-41d9-4ce6-80b6-8bafc82a081b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	7150b495-1628-e211-b4b8-6bfa6b3aea03	c61ed105-41d9-4ce6-80b6-8bafc82a081b	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
63ef8577-c88e-4e93-b0cb-ae1cf5aaeead	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	11273a50-662d-11e4-a36e-136788f6ba2a	63ef8577-c88e-4e93-b0cb-ae1cf5aaeead	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
bdb8e92b-2aa2-495f-8b2a-af809eefc996	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	ef8b39a6-5b64-11e3-b441-f77bcf353f34	bdb8e92b-2aa2-495f-8b2a-af809eefc996	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
b28c8bfa-b6aa-4492-9918-24afb12fadd5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	2fb17dee-c9a5-4e06-873d-d0441f792754	b28c8bfa-b6aa-4492-9918-24afb12fadd5	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
c8a7f936-6b49-468a-b8ff-67873e02e77d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	7c4b00f2-9516-11e3-bed6-135f4d27544f	c8a7f936-6b49-468a-b8ff-67873e02e77d	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
af8d5f45-ff7f-4a77-8111-cb9be2798a9a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	0b393f58-f019-e211-908e-59971fa3877e	af8d5f45-ff7f-4a77-8111-cb9be2798a9a	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
9e204e5d-432e-4486-8dca-49899646c07d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	d0abbada-ad01-11e3-988b-efec9c361a76	9e204e5d-432e-4486-8dca-49899646c07d	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
a6a751ea-848e-4541-9d6b-c3c38d27cc23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	09246708-1717-e211-9018-65b25eca14b5	a6a751ea-848e-4541-9d6b-c3c38d27cc23	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
869aa4c9-a49e-443e-9651-5dc78daa7596	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	9b503152-3a3e-11e4-9ad4-0b38bfc34a57	869aa4c9-a49e-443e-9651-5dc78daa7596	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
6d61544f-6e12-4a05-9e04-1f9b8a994aea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	72cfdfda-231c-e211-b5fb-9d36c7d7cb09	6d61544f-6e12-4a05-9e04-1f9b8a994aea	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e56eb682-9fd5-42a4-bae5-ed2850574f22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	6df32bef-552b-4207-aa57-7d7bada64586	e56eb682-9fd5-42a4-bae5-ed2850574f22	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ff73247f-4b79-474e-b068-2226c0d02908	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	6ec00c9f-1bf3-4a69-b131-8401a0fbe519	ff73247f-4b79-474e-b068-2226c0d02908	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
46048ab5-9b85-4764-9e87-65ce497d03d2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	7bd0404c-9603-e211-b291-0143ed05e022	46048ab5-9b85-4764-9e87-65ce497d03d2	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
d8aeeb73-373c-4d30-abef-cff0d5abbb24	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	483046d6-87b2-4164-9247-49c073789a31	d8aeeb73-373c-4d30-abef-cff0d5abbb24	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
dfdcb53b-ca42-4f44-a154-e035a297f73a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	ca99dedb-11fb-e111-88dd-91f29105d9d3	dfdcb53b-ca42-4f44-a154-e035a297f73a	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
a595eaad-995a-413a-8ab0-746de49a62c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	1c94fedd-9703-e211-b291-0143ed05e022	a595eaad-995a-413a-8ab0-746de49a62c0	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
c0607767-2788-4dc3-954d-1738e7cb94e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	94440896-8c99-11e3-ac3f-a3e636726f74	c0607767-2788-4dc3-954d-1738e7cb94e8	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
9404c9c4-19cb-4a15-9e7d-76c29eb131ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	d9c6af96-777e-43b9-9bca-58c1300af26f	9404c9c4-19cb-4a15-9e7d-76c29eb131ec	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
552b2c74-5286-411a-8180-d48fb4dddc52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	feedc192-f1f1-4ed6-bbaf-ff4c44f2d97b	552b2c74-5286-411a-8180-d48fb4dddc52	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e845595b-4a6f-4bff-83d7-df2e139df86c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	89a07b97-5c4f-4984-82d1-1254eb1c86af	e845595b-4a6f-4bff-83d7-df2e139df86c	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
4b91eb40-1625-435a-bae1-4540f341f938	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	61a5fafc-5b11-11e3-8587-9b9c0e536ccd	4b91eb40-1625-435a-bae1-4540f341f938	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
f1375aff-6437-4985-a869-555c5cf2fafd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	bf5484e0-8d85-4fb7-a34b-fd3b105e481e	b7636c46-2593-4792-968d-5432f3f28fa7	f1375aff-6437-4985-a869-555c5cf2fafd	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
46c4769c-8306-482e-94a5-3c39b31a6eeb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	57ce637d-8acd-e211-b850-d12bb761bc4d	46c4769c-8306-482e-94a5-3c39b31a6eeb	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
108cefab-a667-41cd-a3a0-4ec487560262	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	14438df8-6630-11e4-8fc8-5721c0138d72	108cefab-a667-41cd-a3a0-4ec487560262	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
0a7145e2-8e42-4958-967a-666e6081c612	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	6ef941cd-f503-e211-a8c9-8de20f7d3878	0a7145e2-8e42-4958-967a-666e6081c612	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
34065438-900b-4690-9a82-7fd4000b0a10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	a091930a-1616-468a-861e-0a2e079f2b58	34065438-900b-4690-9a82-7fd4000b0a10	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
5d8572b2-942a-4840-9995-30efa0922b03	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	fd19ac6d-b727-e211-963e-ffbc9c164446	5d8572b2-942a-4840-9995-30efa0922b03	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
39e34332-975a-4039-8f6a-e4db6f095ce8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	38ceb9f3-db02-e211-b4b6-b3231a53305c	39e34332-975a-4039-8f6a-e4db6f095ce8	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
65b51730-cf4c-4621-a7bb-69844eb0d25f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	bed2e326-06e7-4698-94d5-d46efc825014	65b51730-cf4c-4621-a7bb-69844eb0d25f	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
01310d24-c3c1-45a6-ba68-27ae157f000b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	b1245957-0802-e211-8442-77d6f35b44ad	01310d24-c3c1-45a6-ba68-27ae157f000b	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
19a6911b-a2c2-49d1-8fd7-a8e8b191e104	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	19a6911b-a2c2-49d1-8fd7-a8e8b191e104	\N	2019-12-06 16:14:40	2022-12-01 10:23:24	\N	2020-03-07 18:38:31
8b412381-8cf6-4c03-ac56-5ad7ab95a84b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	374d54fa-9d39-4cec-99c8-b405824d8696	8b412381-8cf6-4c03-ac56-5ad7ab95a84b	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
0d8aa366-d1a3-4c02-9856-f3fd9bcd2a5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	2f274181-6333-4dad-af2b-b26b48362d9f	0d8aa366-d1a3-4c02-9856-f3fd9bcd2a5a	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
534a1cf4-c57a-4235-8d7b-e126877d306a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	7bc4be4e-94d9-11e3-bb8e-af0feebc548b	534a1cf4-c57a-4235-8d7b-e126877d306a	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
f19e00d3-5957-41f6-9601-64ffc7177ac8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	f19e00d3-5957-41f6-9601-64ffc7177ac8	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
438cf0a0-1b7c-4057-8692-8566bda05858	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	617d0298-7806-11e3-a360-3b79dafbb6d8	438cf0a0-1b7c-4057-8692-8566bda05858	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
72aa262d-d7f0-499b-b162-a510b4eb266e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	7b907bc1-e927-e211-86f7-79cd2fac9006	72aa262d-d7f0-499b-b162-a510b4eb266e	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ae181f9c-ca81-417d-a06c-cf2c58d34955	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	bede3706-7809-11e3-acc7-b7cb53fe2add	ae181f9c-ca81-417d-a06c-cf2c58d34955	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
f7876e01-9ed8-43b7-931a-6b077ad042d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	b4b12980-d435-43ee-af2d-fed372080d2f	f7876e01-9ed8-43b7-931a-6b077ad042d1	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
89c5cb92-06fd-435d-9ffb-6f703ae1bfe1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	b186ad12-8e0d-11e3-9179-078762557c01	89c5cb92-06fd-435d-9ffb-6f703ae1bfe1	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
3167b032-149e-401c-acea-562caccfe870	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	3b0b4884-726c-4551-9f8c-3db4d502c5f4	3167b032-149e-401c-acea-562caccfe870	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
f8c1d77b-858e-4ccd-a206-89dcdc718347	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	eb492e22-77fd-e111-8da8-f1648fe48442	f8c1d77b-858e-4ccd-a206-89dcdc718347	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e334e8cf-a4df-4d91-a666-3647b9fef268	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	58ee4cfb-ee19-e211-908e-59971fa3877e	e334e8cf-a4df-4d91-a666-3647b9fef268	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
369bf026-cadc-4179-9189-6ef5603aed34	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	ba02677d-8acd-e211-b8a5-d12bb761bc4d	369bf026-cadc-4179-9189-6ef5603aed34	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
f158cb18-af47-46c3-a180-e3f2d18eade1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	accdf25c-06f9-4e7b-9678-a1acd1331088	f158cb18-af47-46c3-a180-e3f2d18eade1	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
33dcb521-d219-4d61-9c4c-a7d9b4c1d542	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	6bcf1e8c-6f7f-11e3-8895-3357dd36639d	33dcb521-d219-4d61-9c4c-a7d9b4c1d542	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
3e67c494-1805-48ad-a77a-378f2912d2fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	842392af-953c-e211-8e89-9908d75a8f4c	3e67c494-1805-48ad-a77a-378f2912d2fb	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
9fa13caa-8fc1-4d7d-a590-4a3b7a59ef2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	0ed24a94-592d-11e5-8142-4f45aea730e6	9fa13caa-8fc1-4d7d-a590-4a3b7a59ef2e	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ec0da555-594e-4f45-a42b-1b213bed6761	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	a990755d-db89-48e1-9e88-fbff0e01d35c	ec0da555-594e-4f45-a42b-1b213bed6761	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
33fcb1e9-39f7-4baa-bbe6-556ecc1ff536	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	180801b9-9103-e211-8560-17962475f905	33fcb1e9-39f7-4baa-bbe6-556ecc1ff536	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
1ce93b5f-0b15-4370-be1b-4123a84b9a4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	06a67ac1-e927-e211-86f3-79cd2fac9006	1ce93b5f-0b15-4370-be1b-4123a84b9a4e	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
0602b171-ac03-41a7-97bc-458b3b3f6a7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	63a8490b-068c-45da-92b9-da3c07470b9a	0602b171-ac03-41a7-97bc-458b3b3f6a7b	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
6822be09-acf6-4153-b084-63a549ef4cfc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	00d9161a-94d6-11e3-8e07-6bfd6236e395	6822be09-acf6-4153-b084-63a549ef4cfc	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
c546f8c8-005a-4dd5-a15b-8fce68a75abb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	a5197a21-450c-4b9d-a2b7-5e5f76982fd2	c546f8c8-005a-4dd5-a15b-8fce68a75abb	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
b43e2e1a-cbac-4761-97e3-6049f6c5a760	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	12ce8e21-0d8f-e211-8adf-a5d1cdfc52ac	b43e2e1a-cbac-4761-97e3-6049f6c5a760	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
8518abcd-909b-4ecd-a022-c815597a4924	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	c8585e32-5bae-11e3-812d-37a32636c770	8518abcd-909b-4ecd-a022-c815597a4924	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
8d75985c-fef8-4f23-b8b3-49e0b6e3ba6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	03421a06-1a10-4a1f-b7ed-1d087ed17e95	8d75985c-fef8-4f23-b8b3-49e0b6e3ba6c	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
53cf5186-95ab-488c-bd47-6da98cbf342b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	cfb2d151-6b27-47f1-b699-63b669f81910	53cf5186-95ab-488c-bd47-6da98cbf342b	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
4c4af849-4227-4013-96b6-fdfae260ed16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	29e9ea54-df02-e211-b4b6-b3231a53305c	4c4af849-4227-4013-96b6-fdfae260ed16	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
52b63f30-799a-430f-a3d7-1580b41b9503	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	bf5484e0-8d85-4fb7-a34b-fd3b105e481e	f4dc7769-10f3-474c-9bad-a7f651d71321	52b63f30-799a-430f-a3d7-1580b41b9503	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
7747a9d6-84c0-4bea-bb16-0facb1ccded8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	9373c4ae-71e3-11e3-8d00-a3618c7b2ae5	7747a9d6-84c0-4bea-bb16-0facb1ccded8	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
eb569d15-8d04-40e6-bb4e-ea6ef5349b26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	210fde58-74aa-4ea9-a4e4-ab32b37448b1	eb569d15-8d04-40e6-bb4e-ea6ef5349b26	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
80e23567-8a07-4b4b-bb4c-0db549b0f0da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	489e1454-e4ac-47cc-b7d0-51c8ff56abbf	80e23567-8a07-4b4b-bb4c-0db549b0f0da	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
be9be5b8-6e65-4812-a729-acf380ce3180	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	b68d69d6-0502-e211-8442-77d6f35b44ad	be9be5b8-6e65-4812-a729-acf380ce3180	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
6d91ffad-be49-4ee6-a2a4-611d2e489755	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	c3a53678-d7a7-4c1b-807f-3034b37ec04a	6d91ffad-be49-4ee6-a2a4-611d2e489755	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
b0b60f50-44b5-472f-850b-13a35cf38a37	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	2e1ffdef-a176-4b92-a196-a4e28455403d	b0b60f50-44b5-472f-850b-13a35cf38a37	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
eb4331bd-96e1-4952-89c4-19c14be74bc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	667a149e-7929-e211-ab63-417b9cc965f1	eb4331bd-96e1-4952-89c4-19c14be74bc7	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
88f781f2-8832-4232-a87a-234bd770aee4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	67ee6efb-ca29-e211-82ed-4bf89d6bb6ec	88f781f2-8832-4232-a87a-234bd770aee4	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
aa509d1d-4d07-4d79-82f9-b50c5cb3646e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	c5fdbd10-8585-40b5-9cd2-83dde161d8c8	aa509d1d-4d07-4d79-82f9-b50c5cb3646e	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ac6a708e-0e82-4e2a-b1a9-d4b468fa933c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	62bf4771-c092-434d-8e93-0260891de1ff	ac6a708e-0e82-4e2a-b1a9-d4b468fa933c	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
0ad71217-aafa-47b7-abdb-8d43965c5b85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	d17acbd0-7f5c-4fb0-9fa7-bd34886d0788	0ad71217-aafa-47b7-abdb-8d43965c5b85	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
46761e53-8456-4047-a99f-5c135ef3290c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	bfc8b844-394c-48b0-b8a5-27643ae71c6f	46761e53-8456-4047-a99f-5c135ef3290c	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
12ed4787-6483-4bec-9019-1f2f3c5501ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	2ddac1d3-c129-e211-82ed-4bf89d6bb6ec	12ed4787-6483-4bec-9019-1f2f3c5501ab	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
745003b4-cf24-4d60-a517-414ddc0deba8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	0c563131-c129-e211-b674-55b8a5daa5db	745003b4-cf24-4d60-a517-414ddc0deba8	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
2dae4b04-de03-45c3-b1d7-8376d65886b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	34fc02aa-8c88-11e3-8f45-97026e699162	2dae4b04-de03-45c3-b1d7-8376d65886b2	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
cb92d4b2-ee0f-4a60-ac67-bfe5e63ac985	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	872b669d-a706-e211-b032-b1f1b004bcca	cb92d4b2-ee0f-4a60-ac67-bfe5e63ac985	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
24e61328-e776-4c05-aff6-80c77b2bda2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	54c1ab04-63b9-4bf3-8d0b-55359bf1a7b2	24e61328-e776-4c05-aff6-80c77b2bda2c	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e8788747-9604-4357-aebb-2f9941303f6a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	2e383874-7f7e-11e3-b87c-131c0087c0c4	e8788747-9604-4357-aebb-2f9941303f6a	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
158bec49-30f2-40a4-9559-1d83b5279ed3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	a80be64e-5393-49df-a6f7-8a18736444a1	158bec49-30f2-40a4-9559-1d83b5279ed3	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
8a4eaec0-143d-4abe-9ee2-d4b7bfb4420f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	480ab734-94d9-11e3-af34-afde42cffeec	8a4eaec0-143d-4abe-9ee2-d4b7bfb4420f	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
b2d73dbb-a17a-4a69-b9f3-6e20861f0a19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	330c1f39-a513-4841-88ce-6bbdbb912d1c	b2d73dbb-a17a-4a69-b9f3-6e20861f0a19	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ba126572-b716-4e6e-a619-7ae7f0d9e6f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	ae2a025b-c727-e211-963e-ffbc9c164446	ba126572-b716-4e6e-a619-7ae7f0d9e6f2	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
69852e22-f1e1-489a-926a-8fd1f94342b5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	c7a20e10-51e9-11e5-9503-af6d1e3f4589	69852e22-f1e1-489a-926a-8fd1f94342b5	\N	2019-12-06 16:14:40	2022-12-01 10:23:18	\N	2020-03-07 18:38:31
7c1177d4-5e53-41f6-8c26-bda8dbff9a6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	56fbd12f-009d-4448-b9ce-76e42ea92a41	7c1177d4-5e53-41f6-8c26-bda8dbff9a6c	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
8712ad61-d2b1-4ef9-b491-bc8045c00410	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	fcb1333e-564a-11e3-8a8e-ab90d2049a72	8712ad61-d2b1-4ef9-b491-bc8045c00410	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
7eed2d76-ebcc-49ea-a54f-7c2f3a1dbb06	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	9433b08e-fac0-4a20-9d42-684e7aced3c6	7eed2d76-ebcc-49ea-a54f-7c2f3a1dbb06	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ff3fee62-67f5-4599-812f-df612f432832	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	e98a52c9-013b-4a3d-aeaa-a3738ed9ec63	ff3fee62-67f5-4599-812f-df612f432832	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
479c567e-d8ad-4ac5-9b85-b30207508fef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	49b646f0-5bb5-11e3-a96d-e7586c796b63	479c567e-d8ad-4ac5-9b85-b30207508fef	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
d181d871-01b5-4d37-801f-629138e6cd39	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	91a30c77-bf27-e211-963e-ffbc9c164446	d181d871-01b5-4d37-801f-629138e6cd39	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
1c030b28-6f0d-457e-97e5-6876621aa485	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	8314bc86-f503-e211-a8c9-8de20f7d3878	1c030b28-6f0d-457e-97e5-6876621aa485	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
0eb90868-fa3d-4405-8dbc-30222c7e1319	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	7a13c707-8f03-e211-8560-17962475f905	0eb90868-fa3d-4405-8dbc-30222c7e1319	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
617e2b65-1c86-4031-bac0-e12663e3cf7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	7c15fbb2-33c9-4ba2-93a4-b9d988e939b4	617e2b65-1c86-4031-bac0-e12663e3cf7c	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
1840b4f3-7b46-4939-a438-0dcd47b05306	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	fae6a1c2-8e0a-11e3-8141-7f4802cb1e93	1840b4f3-7b46-4939-a438-0dcd47b05306	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
961a92c7-ca4b-4bf6-bc06-687cd5eb9c7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	ea95c523-7a1a-e211-8842-a9f06a07ae1b	961a92c7-ca4b-4bf6-bc06-687cd5eb9c7d	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
17d4a529-e819-4988-ba4a-4649f70c023f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	99153600-e522-442f-994e-45c3cb038980	17d4a529-e819-4988-ba4a-4649f70c023f	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
3bb14e1f-2101-44be-b31c-da33c7d21611	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	33bce156-94d6-11e3-9dfa-1b9f2c131c25	3bb14e1f-2101-44be-b31c-da33c7d21611	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
8c8fec38-b6b4-4fae-a437-ddf5a67174fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	d6da0950-f65b-47d2-9965-579b90b08ffd	8c8fec38-b6b4-4fae-a437-ddf5a67174fe	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
fffcb05f-baa4-4999-a8ec-8298e7425bd2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	bf5484e0-8d85-4fb7-a34b-fd3b105e481e	ea745b98-c427-e211-963e-ffbc9c164446	fffcb05f-baa4-4999-a8ec-8298e7425bd2	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
39633cee-231a-4305-afa6-056f0e9dc796	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	b0c37ebb-2fd5-4fc2-883e-267cdb7c8942	39633cee-231a-4305-afa6-056f0e9dc796	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
79932047-80eb-4dad-aa87-9c6b9e8a9beb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	539c2dbe-5e22-11e3-97a4-6b60c900259e	79932047-80eb-4dad-aa87-9c6b9e8a9beb	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
832d85ca-aaab-4918-9b6d-03a672698c44	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	8166568f-7b1a-e211-8842-a9f06a07ae1b	832d85ca-aaab-4918-9b6d-03a672698c44	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
7d675113-5a86-4ee5-b9e0-853663fd2cbb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	6149e37c-57ea-11e3-8a63-0bad90edf22e	7d675113-5a86-4ee5-b9e0-853663fd2cbb	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
3b73adad-ddd5-484c-941f-4a453799f666	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	0110eb45-f503-e211-a8c9-8de20f7d3878	3b73adad-ddd5-484c-941f-4a453799f666	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
4e54d03c-e9fb-42c7-bfdb-3e180daf4eb2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	b3d74216-101c-e211-af82-4f62965233f9	4e54d03c-e9fb-42c7-bfdb-3e180daf4eb2	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
c6f8e325-4737-4dcd-a4fe-4ac3d97a9d0f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	14f34d04-bb92-4cf1-bb11-5e424fa98ae7	c6f8e325-4737-4dcd-a4fe-4ac3d97a9d0f	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
4d6000b7-18a9-4bd0-b34b-b9054770daf8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	1efebede-0f12-4c19-ab53-2090b7359148	4d6000b7-18a9-4bd0-b34b-b9054770daf8	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
223b480b-3e00-463f-ab02-2596f407036e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	46b37dc1-e927-e211-86f9-79cd2fac9006	223b480b-3e00-463f-ab02-2596f407036e	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
ad6ff014-3313-48bc-810a-899cfc55fb19	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	c9068942-6600-11e3-b6a4-b3567bd3f846	ad6ff014-3313-48bc-810a-899cfc55fb19	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
45001eda-2278-4666-b1b4-ecdc45d55a69	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	9bc7beac-4b5a-11e4-aa6c-b370cd9de552	45001eda-2278-4666-b1b4-ecdc45d55a69	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
f5b4522a-a3e2-42ab-98b9-ce923d55909c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	27b447d0-3aba-11e3-b5d7-b386a69aa207	f5b4522a-a3e2-42ab-98b9-ce923d55909c	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
cb2814f4-d850-4453-8db2-9e75e54c2e76	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	26764428-43b9-11e4-a664-b3a38f27b498	cb2814f4-d850-4453-8db2-9e75e54c2e76	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
5d839cf8-d3c1-4501-987c-38558fa07099	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	0445992f-bbd4-4dbc-92cb-b4c70b090bff	5d839cf8-d3c1-4501-987c-38558fa07099	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
f3bc4e9a-c2f3-4fd8-b507-518771909f49	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	3d96a888-2743-11e4-871a-b71e982fd996	f3bc4e9a-c2f3-4fd8-b507-518771909f49	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
0d981ee0-be41-406b-aeec-27394ca5b1aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	fd2e81be-ca4c-4320-9549-82c37f311556	0d981ee0-be41-406b-aeec-27394ca5b1aa	\N	2019-12-06 16:14:39	2022-12-01 10:22:54	\N	2020-03-07 18:38:30
5aa0dbbd-0b6f-4a88-ae07-b8585b7ba7be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	900ffa20-46cc-11e5-8abe-0337176d8d23	5aa0dbbd-0b6f-4a88-ae07-b8585b7ba7be	\N	2019-12-06 17:32:35	2022-12-01 10:22:59	\N	2020-03-07 18:38:38
29bf56f3-7fec-434d-a984-3c685b2609ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	2819b86b-4d06-499d-a0c9-af1a3e711ecf	29bf56f3-7fec-434d-a984-3c685b2609ef	\N	2019-12-06 17:32:36	2022-12-01 10:23:02	\N	2020-03-07 18:38:37
951d74cb-bbf1-4d26-b4a5-95e2bbdc293a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	951d74cb-bbf1-4d26-b4a5-95e2bbdc293a	\N	2019-12-06 17:32:35	2022-12-01 10:23:04	\N	2020-03-07 18:38:38
87ca6a17-3112-4451-9d0c-0013962fa91c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	d313aa86-3092-4ceb-8e53-fabcecc2a37a	87ca6a17-3112-4451-9d0c-0013962fa91c	\N	2019-12-06 17:32:35	2022-12-01 10:23:04	\N	2020-03-07 18:38:37
09b1346f-e390-46e8-81fe-41faf658af7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	c60e92a2-99c2-4394-a48b-251540c8b96f	09b1346f-e390-46e8-81fe-41faf658af7f	\N	2019-12-06 17:32:36	2022-12-01 10:23:04	\N	2020-03-07 18:38:37
9382f46f-1c5a-4c4b-96ff-cc7180ccefcb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	0494c011-fd20-411c-b6f3-022d10cfb1b4	9382f46f-1c5a-4c4b-96ff-cc7180ccefcb	\N	2019-12-06 17:32:35	2022-12-01 10:23:05	\N	2020-03-07 18:38:38
6c23dcf1-ea33-41dc-bc56-2c53d81580a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	7b6763fc-6f9f-11e3-b017-03efaa0c94af	6c23dcf1-ea33-41dc-bc56-2c53d81580a4	\N	2019-12-06 17:32:35	2022-12-01 10:23:11	\N	2020-03-07 18:38:37
7f026a66-20d6-4408-900a-2c5f47968b7a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	7f026a66-20d6-4408-900a-2c5f47968b7a	\N	2019-12-06 17:32:36	2022-12-01 10:23:13	\N	2020-03-07 18:38:37
42a2b4e6-9212-4781-b842-ea5aafddae96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	d0dca4af-4472-4232-af75-aaabf7ca88e7	42a2b4e6-9212-4781-b842-ea5aafddae96	\N	2019-12-06 17:32:36	2022-12-01 10:23:16	\N	2020-03-07 18:38:39
b71787cb-d9cd-4f93-a8f4-3c052fb9a878	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	8cf66883-ebc1-473e-a01c-37925b2b2150	b71787cb-d9cd-4f93-a8f4-3c052fb9a878	\N	2019-12-06 17:32:36	2022-12-01 10:23:17	\N	2020-03-07 18:38:37
bc9e6941-9d9f-423f-abb6-065787c46a44	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	1f6639a7-562e-44f9-b1c8-a98935a9193c	bc9e6941-9d9f-423f-abb6-065787c46a44	\N	2019-12-06 17:32:36	2022-12-01 10:23:18	\N	2020-03-07 18:38:37
766154db-1d34-4f15-acbe-0eafea662ebd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	d28672c2-c5a5-4238-a802-fd30f1f8341d	766154db-1d34-4f15-acbe-0eafea662ebd	\N	2019-12-06 17:32:36	2022-12-01 10:23:19	\N	2020-03-07 18:38:37
86209fd6-7e3c-45e8-bb79-0959207bea3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	304a3c38-bda8-4b1f-b2ef-087817e35993	86209fd6-7e3c-45e8-bb79-0959207bea3a	\N	2019-12-06 17:32:35	2022-12-01 10:23:23	\N	2020-03-07 18:38:37
a58f94e9-da64-4487-b456-0521b0ffcf3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	f59b1bb2-1e58-4760-b504-5ee5de14aba7	a58f94e9-da64-4487-b456-0521b0ffcf3a	\N	2019-12-06 17:32:35	2022-12-01 10:23:24	\N	2020-03-07 18:38:37
029c2e23-9db3-4955-9dbd-a3720dc7d9e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	029c2e23-9db3-4955-9dbd-a3720dc7d9e0	\N	2019-12-06 17:32:36	2022-12-01 10:23:24	\N	2020-03-07 18:38:38
1bca396b-4a32-456e-b33d-24d430967365	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	d85e860f-35a9-4406-8bc6-0e4051153600	1bca396b-4a32-456e-b33d-24d430967365	\N	2019-12-06 17:32:36	2022-12-01 10:23:25	\N	2020-03-07 18:38:37
3f359ce7-f7e8-4eb8-98c9-38692138cc7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	bd3a2d69-e9b5-4462-9057-eb4b035b297d	3f359ce7-f7e8-4eb8-98c9-38692138cc7f	\N	2019-12-06 17:32:36	2022-12-01 10:23:26	\N	2020-03-07 18:38:37
8ab6b58f-ffba-499b-ba15-e62095eef1c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	e9cef568-2ada-4e64-b69f-00c23c5d8604	8ab6b58f-ffba-499b-ba15-e62095eef1c3	\N	2019-12-06 17:32:35	2022-12-01 10:23:26	\N	2020-03-07 18:38:39
e7191717-d460-48ac-95c1-84784f04e4ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	78027dc1-f7e5-434a-b0c3-767f331840bb	e7191717-d460-48ac-95c1-84784f04e4ac	\N	2019-12-06 17:32:36	2022-12-01 10:23:29	\N	2020-03-07 18:38:38
a755965e-13c1-42bd-88b4-54fe17866157	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	5a4a1960-fbb7-481a-9990-7ba60842b16a	d081c069-65b7-4bf5-866a-423def103d81	a755965e-13c1-42bd-88b4-54fe17866157	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
84ec4320-a074-4214-94b2-1059f8048066	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	ab6417da-ec15-496a-938b-3d116b961a9f	84ec4320-a074-4214-94b2-1059f8048066	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
c853bb0a-9fb3-4d6d-aef1-74d090b8975b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	f007d956-6934-4b9b-9c9b-62c009e1cce4	9c53d522-5752-4556-82d0-660186bcecdc	c853bb0a-9fb3-4d6d-aef1-74d090b8975b	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
b4ec9948-b293-4a35-9165-4d20a4da221c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	95836ed6-c129-e211-82ed-4bf89d6bb6ec	b4ec9948-b293-4a35-9165-4d20a4da221c	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
fa230ba7-d524-427a-89a9-327e79896378	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	6253c8d6-9fc6-11e3-8528-1b2276645f8d	fa230ba7-d524-427a-89a9-327e79896378	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
42d475bf-ea03-454e-8e35-d7ca4ebd6b0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	f972d46f-e46f-43c1-a19d-51ba1e14ef57	42d475bf-ea03-454e-8e35-d7ca4ebd6b0d	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
9f7f2fc2-7b63-49d7-b161-5e261fb16ebe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	db1334ab-aa9b-441b-b980-302e272dd599	236327ac-5d63-11e3-be13-0fc0a62c8be5	9f7f2fc2-7b63-49d7-b161-5e261fb16ebe	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
af8812a3-e433-4ae3-ba61-6d6c3d990289	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	c581fdd6-9a1a-e211-978e-3b930968aceb	af8812a3-e433-4ae3-ba61-6d6c3d990289	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
574356c0-2ec1-456a-a180-123edbcff569	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	5e9f903f-a22b-43f7-b220-b2ef84ce5f82	574356c0-2ec1-456a-a180-123edbcff569	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
2cdf0241-1ba8-4366-9111-c18ed2518540	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	e72ca094-e2f1-481c-bb17-e5250d93dfab	2cdf0241-1ba8-4366-9111-c18ed2518540	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
ae8c15b9-04e8-406f-8451-33abdc5b3978	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	d338d2a0-a5ff-43ea-a12f-7abf13709383	e9c2db63-6ef7-4099-bcfb-256a68e7481e	ae8c15b9-04e8-406f-8451-33abdc5b3978	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
cd097dbe-1330-44c9-b950-29fb46b2cd3f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	1aaf7fc1-e927-e211-8700-79cd2fac9006	cd097dbe-1330-44c9-b950-29fb46b2cd3f	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
12292e63-4558-4c46-9a65-acdb31bf6442	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	df569573-384a-4150-8931-a7fda92c44f7	12292e63-4558-4c46-9a65-acdb31bf6442	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
19291bae-519d-4922-ad8d-ecf6285baab6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	660fba7b-08e9-47fa-be7b-ffaef1150339	19291bae-519d-4922-ad8d-ecf6285baab6	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
26381621-9d70-4ea7-9e67-68e9847ba350	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	8e2a4c82-0e8f-e211-8adf-a5d1cdfc52ac	26381621-9d70-4ea7-9e67-68e9847ba350	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
e2135793-6555-4ce2-8cb9-d60d94bfd74f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	b5751d3c-9506-11e3-b1b0-1fa0d442b945	e2135793-6555-4ce2-8cb9-d60d94bfd74f	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
76c75bba-3107-44dd-a18f-ed29b15e91e7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	2818cea6-60f4-11e4-b17d-bb07c1f9979f	76c75bba-3107-44dd-a18f-ed29b15e91e7	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
38e7ec60-34ef-4382-92e3-e248d5bd666c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	0090c438-bcd9-4ac3-b903-1954f7040e22	38e7ec60-34ef-4382-92e3-e248d5bd666c	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
799b55d6-5f6c-4e52-9de6-991e9a561e7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	52697bc1-e927-e211-86f6-79cd2fac9006	799b55d6-5f6c-4e52-9de6-991e9a561e7c	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
64bc8740-3d49-42e6-a5f1-292dd26466af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	cfd97a28-4fdb-4859-8156-9a13dff8c9f2	2b9527fa-b827-e211-963e-ffbc9c164446	64bc8740-3d49-42e6-a5f1-292dd26466af	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
9ccd21d3-1349-45db-b0f5-7d629ecddd56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	9a52a3f6-c727-e211-963e-ffbc9c164446	9ccd21d3-1349-45db-b0f5-7d629ecddd56	\N	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01	2022-12-01 10:38:01
635c7295-57e3-4e88-bd18-5a2d6b0471df	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	e626140c-48d1-11e4-a419-b7592f1968d2	635c7295-57e3-4e88-bd18-5a2d6b0471df	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
f57fd750-9c53-4598-8d0a-57196ea7ceb5	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	6906fe76-eb09-e211-aa7f-b78bdc6cd124	f57fd750-9c53-4598-8d0a-57196ea7ceb5	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
052b8541-b8aa-4995-a1d3-02bb34acd9e4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	461dc41b-ee09-e211-aa7f-b78bdc6cd124	052b8541-b8aa-4995-a1d3-02bb34acd9e4	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
de92ecdf-90bf-42ce-b93f-4cfabb8f58a7	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	71d428c5-ee09-e211-aa7f-b78bdc6cd124	de92ecdf-90bf-42ce-b93f-4cfabb8f58a7	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
aa738e69-c7b8-4887-a174-645c7d906fe5	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	5032bf46-5204-11e3-ad86-b79f919324da	aa738e69-c7b8-4887-a174-645c7d906fe5	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
debd5223-7fe8-4dbb-916a-297886de1398	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	a51167e6-9cc8-467b-b35f-b7a73855062a	debd5223-7fe8-4dbb-916a-297886de1398	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
81c87ce8-82b0-40d8-9fc3-4bc7b8bd27ad	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	3f3739d1-80e2-4a16-97b5-b96314461b7c	81c87ce8-82b0-40d8-9fc3-4bc7b8bd27ad	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
2f6b3193-77ea-400d-a6d4-b53cc4fce960	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	28dfd9d4-2746-11e4-9283-bb2b80554aa6	2f6b3193-77ea-400d-a6d4-b53cc4fce960	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
cd081a74-3b05-437f-9fed-fa9930848ca5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	72d18334-3b06-11e4-a3a4-13507c2a0677	cd081a74-3b05-437f-9fed-fa9930848ca5	\N	2019-12-06 17:32:36	2022-12-01 10:22:50	\N	2020-03-07 18:38:39
52e056a4-a948-4c8e-bcb3-0b5049e16df8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	02c9180a-0b24-4ac4-b544-24d968340f61	52e056a4-a948-4c8e-bcb3-0b5049e16df8	\N	2019-12-06 17:32:35	2022-12-01 10:22:50	\N	2020-03-07 18:38:37
7df41429-d5ab-4526-be57-bea6f40e408a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	d0e162da-59c3-4a74-83a0-c20ea34cc761	06555036-10af-41b8-b767-260f6d366218	7df41429-d5ab-4526-be57-bea6f40e408a	\N	2019-10-29 19:26:22	2022-12-01 10:22:51	\N	2019-12-19 08:08:23
1b093fef-f124-4ae7-bad8-9f24225aae3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	fa092490-4b74-11e5-a33d-db9868dda03f	1b093fef-f124-4ae7-bad8-9f24225aae3d	\N	2019-12-06 16:14:40	2022-12-01 10:23:09	\N	2020-03-07 18:38:32
ed852004-9d60-4bc6-9b93-c85269a2b5ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	243b6119-e39f-4849-8fd0-218155575c5a	ed852004-9d60-4bc6-9b93-c85269a2b5ac	\N	2019-12-06 17:32:36	2022-12-01 10:23:12	\N	2020-03-07 18:38:38
937dfb46-b74e-4a0b-8fbd-a1e6c3efc788	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	079a34b8-4b76-11e5-814d-b3ab2368e254	937dfb46-b74e-4a0b-8fbd-a1e6c3efc788	\N	2019-12-17 15:14:40	2022-12-01 10:23:26	\N	2019-12-19 08:08:23
f6c34644-93d6-44df-8ccb-4e42a92c5a9d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	ecacd4b6-e824-e211-878a-097421c03879	f6c34644-93d6-44df-8ccb-4e42a92c5a9d	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
2a71eb38-b151-4fb5-bb1f-cf3e62d43f1d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	8366667d-8acd-e211-b897-d12bb761bc4d	2a71eb38-b151-4fb5-bb1f-cf3e62d43f1d	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
3a72bd49-6285-418b-ba71-1150e596c6d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	cc5df9fa-60ae-11e4-a528-2326bffd6759	3a72bd49-6285-418b-ba71-1150e596c6d1	\N	2022-12-01 10:37:38	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
01ca3a51-8af7-4b67-97ee-49b5575ed5bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	b35adc45-db41-4c7b-a7ab-8c742cb436fe	51c7d610-b758-4f28-9f99-9196229ba893	01ca3a51-8af7-4b67-97ee-49b5575ed5bd	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
b2e0b1d0-b419-4986-a09c-703ba7a0357f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	d861e66d-279b-41ba-9f4b-f32031a86a79	b2e0b1d0-b419-4986-a09c-703ba7a0357f	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
330d3c93-b8c1-42a1-b90e-5699a593fc44	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	474904eb-a9b7-41c3-bbf2-283b844874a6	5e200dc4-4b76-483f-8e7f-e26c92431c3e	330d3c93-b8c1-42a1-b90e-5699a593fc44	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
783c0d8f-8e03-4bfc-bfc2-0cfff0de9dd9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	06ad47da-457f-4146-98d2-d5677894fe09	3d9a3222-1539-4af6-bc16-54a57990650c	783c0d8f-8e03-4bfc-bfc2-0cfff0de9dd9	\N	2022-12-01 10:37:39	2022-12-14 08:11:08	\N	2022-12-14 08:11:08
3b85c640-0251-4b34-ae59-4b997daf6354	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	71e323b7-071a-4e5b-9d0d-6768eff3dd79	ee092c2a-fd8c-4323-96a0-7d44f36451de	3b85c640-0251-4b34-ae59-4b997daf6354	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
12023e2a-2e5f-40f3-b3a7-233dbd7dc8b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	025eaa03-a234-4c1d-b166-ee1714b6b792	eea51330-4df7-49dc-a58b-7e7fc6cf26ac	12023e2a-2e5f-40f3-b3a7-233dbd7dc8b3	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
e6c83d1c-a661-48f0-b3f5-1ed8563f9fb6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	15cd7ac1-e927-e211-86f3-79cd2fac9006	e6c83d1c-a661-48f0-b3f5-1ed8563f9fb6	\N	2022-12-01 10:37:39	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
6d8c517b-db7d-4f9b-adf7-272a3895b331	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20221	9c895e9c-bddc-4570-a00a-6f459104ee00	1a4e610e-0b02-e211-8442-77d6f35b44ad	6d8c517b-db7d-4f9b-adf7-272a3895b331	\N	2022-12-01 10:37:40	2022-12-14 08:11:09	\N	2022-12-14 08:11:09
31723438-4678-464e-ba0d-2f6c91fb5a1d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	ecacd4b6-e824-e211-878a-097421c03879	31723438-4678-464e-ba0d-2f6c91fb5a1d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
4414f5ae-c1f5-479f-954e-503f4ec66dd2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	6632892c-82c9-445d-af7d-94cabbfdd363	73c986dd-4bfe-4a05-844b-00d385e21864	4414f5ae-c1f5-479f-954e-503f4ec66dd2	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3c5163c7-6d38-4ed9-aae5-c69ca7168210	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	cd0efc86-2a0e-11e4-bc41-7bdce17446f2	3c5163c7-6d38-4ed9-aae5-c69ca7168210	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
78766ea7-87e1-4e4c-8653-62ba5dbe85c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	8366667d-8acd-e211-b897-d12bb761bc4d	78766ea7-87e1-4e4c-8653-62ba5dbe85c2	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a37fef51-b2a2-4c07-9e5a-0cd05971b4b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	71e270b7-10e5-40cd-af79-1b5d07c2d9ab	a37fef51-b2a2-4c07-9e5a-0cd05971b4b9	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
aba63010-f484-4f1d-8a5a-3418dab0c073	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	edf2c1a4-2d1f-471d-8e72-eb63959b5b64	aba63010-f484-4f1d-8a5a-3418dab0c073	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
08957d9d-fa88-482c-88cc-4fa40eac4907	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	b8597d0a-533b-11e5-af98-8f68bbe85388	08957d9d-fa88-482c-88cc-4fa40eac4907	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
826345a5-b1d8-4fff-8e73-0676d4ecf2d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	80b4667d-8acd-e211-b89c-d12bb761bc4d	826345a5-b1d8-4fff-8e73-0676d4ecf2d1	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
8276cac1-c661-4935-97a0-3aa4fd70a57b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	b4745045-5baf-416a-9da6-ec039566537b	8276cac1-c661-4935-97a0-3aa4fd70a57b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
72e597ed-fff8-45d8-a4dc-9b670dda55dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	6c136cf3-8b03-e211-8560-17962475f905	72e597ed-fff8-45d8-a4dc-9b670dda55dd	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
54c0c1b2-d622-4c33-9577-7236702ed389	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	cc5df9fa-60ae-11e4-a528-2326bffd6759	54c0c1b2-d622-4c33-9577-7236702ed389	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
9dd4dfaf-14ec-417e-adc7-f033e0742fc2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	5d81ded5-cf07-e211-9482-ab4b6567f9f7	9dd4dfaf-14ec-417e-adc7-f033e0742fc2	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a3ba5365-89b7-4f4b-8eeb-ddc83102e0f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	2bfe543e-2a1f-11e4-bc2d-cb05e5722fa8	a3ba5365-89b7-4f4b-8eeb-ddc83102e0f4	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
846038d6-1be0-404a-9663-cb5225bf62a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	1043eb6a-a5c9-4e29-92ec-e5a3eea29247	846038d6-1be0-404a-9663-cb5225bf62a0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
63ea25d5-6902-4e63-b731-dfb114ee86c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	3c1ceee8-8105-11e3-833a-9bdba6d1ca50	63ea25d5-6902-4e63-b731-dfb114ee86c6	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
d23ab404-0bf1-4a75-b1f7-beba8fe5e4cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	84f52c40-b361-11e4-97f5-07149f66330b	d23ab404-0bf1-4a75-b1f7-beba8fe5e4cf	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
6a93bd13-dbdb-443b-bab0-403016b2fc3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	51c7d610-b758-4f28-9f99-9196229ba893	6a93bd13-dbdb-443b-bab0-403016b2fc3d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f1b9689f-15d5-4f89-8c4e-c7e5ee5c79de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	1f59f4f2-9003-e211-8560-17962475f905	f1b9689f-15d5-4f89-8c4e-c7e5ee5c79de	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a710eb4d-9aa4-4a97-8f3e-5fe22a067784	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	0769190c-5d64-11e3-8b30-dffbe206ec8a	a710eb4d-9aa4-4a97-8f3e-5fe22a067784	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
e445bcad-ead6-42f8-b3c6-8fb448194d80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	4e3df8d9-0602-e211-8442-77d6f35b44ad	e445bcad-ead6-42f8-b3c6-8fb448194d80	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
041c9780-774b-4717-8bf9-fca629c04600	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	b1e79070-5e22-11e3-9c6d-233c893822c5	041c9780-774b-4717-8bf9-fca629c04600	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
c365d5db-6cf8-45af-89ef-ed59164168b5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	ffa42521-4f5a-4d0a-8efd-f4dc24fe7f45	c365d5db-6cf8-45af-89ef-ed59164168b5	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a92884db-4ccb-437b-af7b-71d70d7af83d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	d861e66d-279b-41ba-9f4b-f32031a86a79	a92884db-4ccb-437b-af7b-71d70d7af83d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f10b8bb2-e3a9-4b52-8c5b-2a91dd894672	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	4110f12e-94d8-11e3-9d19-577073295bc5	f10b8bb2-e3a9-4b52-8c5b-2a91dd894672	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
234cbf8e-0589-40a5-b434-79b28d949b20	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	a8fda9da-6d1e-11e3-970c-93ebf835240a	234cbf8e-0589-40a5-b434-79b28d949b20	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
910b66ce-3d16-4b66-b8e5-d21721f68632	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	542df659-4377-411d-9fa8-1f5ce8878479	910b66ce-3d16-4b66-b8e5-d21721f68632	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f4a75e2d-878e-4fe2-9be4-60382452e9e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	912be006-94d8-11e3-9fbf-ef2adf253ed7	f4a75e2d-878e-4fe2-9be4-60382452e9e0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3cd0e283-5578-4430-8cc1-ef975322b86f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	6a459348-f991-4498-b483-82078efe1e29	3cd0e283-5578-4430-8cc1-ef975322b86f	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f6093cd9-5e50-42ae-ad3f-adc88339c19f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	f5599d4e-2520-e211-ac85-4fdce694eced	f6093cd9-5e50-42ae-ad3f-adc88339c19f	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
e0075ba2-8de9-4501-8d6d-46f124571444	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	e4cf82c4-67df-11e3-a0f5-c792454ff412	e0075ba2-8de9-4501-8d6d-46f124571444	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3e9670bf-18a9-40f9-ba34-3693d6c96eaa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	475ba4bd-cedf-4ba4-976b-d7a2ef695594	3e9670bf-18a9-40f9-ba34-3693d6c96eaa	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
7c424f64-e897-46cd-acd0-932ccb3fc53b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	d29324b0-6ef3-11e3-a4d4-23ef5f321119	7c424f64-e897-46cd-acd0-932ccb3fc53b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
2a41c48f-db61-4ba4-9c63-bb6a67b2227d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	185763fc-94d9-11e3-86ab-4b04feeb706c	2a41c48f-db61-4ba4-9c63-bb6a67b2227d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
89a4acb7-94e0-486a-a50f-06da09b63acd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	7adea11a-561c-11e5-900a-eb2673a1373b	89a4acb7-94e0-486a-a50f-06da09b63acd	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
92b4ac78-3856-4726-8ecb-47c253c462a7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	f530a57f-1b10-e211-9570-4d846480b264	92b4ac78-3856-4726-8ecb-47c253c462a7	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
83b33a07-a43f-44a6-b6cc-08fae8233c10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	d06848d7-c129-e211-82ed-4bf89d6bb6ec	83b33a07-a43f-44a6-b6cc-08fae8233c10	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
488fdb06-2e3f-4119-a51d-a367d909ea52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	217aabe8-662e-11e4-8763-376fcef79753	488fdb06-2e3f-4119-a51d-a367d909ea52	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
d880f96c-6719-4fbb-ad3a-a6546a510f49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	724ef4b0-3f1e-e211-ad21-a3a026533b4a	d880f96c-6719-4fbb-ad3a-a6546a510f49	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
d392c815-fbd2-4258-ab02-98ca8b9b1bf5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	a4195ffe-991a-e211-978e-3b930968aceb	d392c815-fbd2-4258-ab02-98ca8b9b1bf5	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
eefc87c9-1e1b-4f51-8ea3-b586d5fd81c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	fc887591-cc90-441b-ab14-7f04d4488c3b	eefc87c9-1e1b-4f51-8ea3-b586d5fd81c0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
183e39fb-aa47-45d4-978e-d669e8d635ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	250c0b5f-0e2c-e211-864c-79233e4c0063	183e39fb-aa47-45d4-978e-d669e8d635ad	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a708ea51-b39d-42bc-b2cb-bb2f274551d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	7363a404-46e9-11e5-8413-7fabf05ee1fd	a708ea51-b39d-42bc-b2cb-bb2f274551d7	\N	2019-12-06 17:32:36	2022-12-01 10:23:02	\N	2020-03-07 18:38:38
66237a8b-34b3-4bbc-b624-138163bdc419	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	de80e2b4-e4fe-4c39-b3ac-00c56a811f3a	66237a8b-34b3-4bbc-b624-138163bdc419	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
0d194de2-463d-4742-a234-dc3918ffcbaf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	0c6a002f-208e-4340-9276-5ddf8c3c7931	0d194de2-463d-4742-a234-dc3918ffcbaf	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
227beda3-7639-435d-b9e2-8b924ff8fbe3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	7df870be-f674-4ed1-bf50-340cbfdc845a	227beda3-7639-435d-b9e2-8b924ff8fbe3	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
6035f294-0755-4c50-bb87-3d709dd2a328	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	9adb667d-8acd-e211-b8a0-d12bb761bc4d	6035f294-0755-4c50-bb87-3d709dd2a328	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
160fff65-5686-4414-99c6-d0f50e4a09ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	0a72bba4-4a47-11e5-ba01-1f889a42b431	160fff65-5686-4414-99c6-d0f50e4a09ad	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
e4084bee-ca27-4181-82e4-dd87cc6f40af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	3d9a3222-1539-4af6-bc16-54a57990650c	e4084bee-ca27-4181-82e4-dd87cc6f40af	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
2c48fedd-4063-41d4-b815-db6b52ccf455	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	d22b4808-88b2-11e3-8cc6-27bf35192807	2c48fedd-4063-41d4-b815-db6b52ccf455	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
e064cfd4-b0f2-41ff-95a7-4e006606d93f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	074f93b5-b14c-43a4-9b32-ffa1f94d5238	e064cfd4-b0f2-41ff-95a7-4e006606d93f	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
1f885466-b905-4e79-9a53-b62de3ae0109	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	4f34ea70-781e-11e3-af88-8738a490246c	1f885466-b905-4e79-9a53-b62de3ae0109	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
35f958c2-c9be-4ac8-8096-31d9aadcece0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	9e6521bc-0a02-e211-8442-77d6f35b44ad	35f958c2-c9be-4ac8-8096-31d9aadcece0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
fc68d5e3-54ae-4fc1-8557-01e8394125c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	4697a155-d7d0-438e-8447-e684bde0b0c0	fc68d5e3-54ae-4fc1-8557-01e8394125c0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
ce6673cf-2030-4b41-b936-9ac8b6fb5e46	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	fcc5677d-8acd-e211-b8be-d12bb761bc4d	ce6673cf-2030-4b41-b936-9ac8b6fb5e46	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
5875b442-7a10-4ad3-9b26-cb8075e4789f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	17e8de1b-c527-e211-963e-ffbc9c164446	5875b442-7a10-4ad3-9b26-cb8075e4789f	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
28746849-5ae3-4eee-88ee-c66b78162f12	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	28746849-5ae3-4eee-88ee-c66b78162f12	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
629995b1-d39c-4c93-8c64-61bbf12677e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	de4c9890-94d7-11e3-87b3-bf380a55277f	629995b1-d39c-4c93-8c64-61bbf12677e4	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
2e2de310-881d-4803-a8d5-70283392cf5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	b9b3e453-5f83-4976-91c2-cb4c8b272a0c	2e2de310-881d-4803-a8d5-70283392cf5d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
d6e7894e-bac9-4040-8afb-2bb8c2360dc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	0e3ca3aa-8e03-e211-8560-17962475f905	d6e7894e-bac9-4040-8afb-2bb8c2360dc0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
d4f12650-1d26-4283-8cbe-535f9a163b1e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	d4f12650-1d26-4283-8cbe-535f9a163b1e	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
e983984d-3d5c-4e04-aa69-3c02478b0973	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	a162a212-58ef-41b2-b66d-93490bd5fafc	e983984d-3d5c-4e04-aa69-3c02478b0973	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
9bc2ca12-fd18-4496-93f1-223d260c1a0b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	7150b495-1628-e211-b4b8-6bfa6b3aea03	9bc2ca12-fd18-4496-93f1-223d260c1a0b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
5ef4bff6-0e53-4fe3-b0d3-4fa84e4fe696	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	11273a50-662d-11e4-a36e-136788f6ba2a	5ef4bff6-0e53-4fe3-b0d3-4fa84e4fe696	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3c99ea3e-bb24-40be-89e5-2dbd2dab2be2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	ef8b39a6-5b64-11e3-b441-f77bcf353f34	3c99ea3e-bb24-40be-89e5-2dbd2dab2be2	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f2cb9fff-be0c-465b-906b-44f8e0c6591c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	2fb17dee-c9a5-4e06-873d-d0441f792754	f2cb9fff-be0c-465b-906b-44f8e0c6591c	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
8b64e775-2f7b-47b7-8ab7-121c35b4e56a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	7c4b00f2-9516-11e3-bed6-135f4d27544f	8b64e775-2f7b-47b7-8ab7-121c35b4e56a	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
93050f3c-14b7-46e5-a5d6-9d39ec311a1b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	0b393f58-f019-e211-908e-59971fa3877e	93050f3c-14b7-46e5-a5d6-9d39ec311a1b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
527185ea-079b-4760-b442-1413d9bf8788	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	d0abbada-ad01-11e3-988b-efec9c361a76	527185ea-079b-4760-b442-1413d9bf8788	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
8bfaa9a7-024b-413c-9aee-b1ad436612ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	09246708-1717-e211-9018-65b25eca14b5	8bfaa9a7-024b-413c-9aee-b1ad436612ee	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
69d9615b-3aec-433e-a9ed-b9f45fccce35	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	9b503152-3a3e-11e4-9ad4-0b38bfc34a57	69d9615b-3aec-433e-a9ed-b9f45fccce35	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f349a56a-fb24-4603-81e1-a73e205f9a49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	72cfdfda-231c-e211-b5fb-9d36c7d7cb09	f349a56a-fb24-4603-81e1-a73e205f9a49	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
607dd6f2-26e9-40a5-a91a-51e4237aa8c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	6df32bef-552b-4207-aa57-7d7bada64586	607dd6f2-26e9-40a5-a91a-51e4237aa8c7	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
f6fa610a-3ab3-4a3e-b024-e738e8c13ec0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	6ec00c9f-1bf3-4a69-b131-8401a0fbe519	f6fa610a-3ab3-4a3e-b024-e738e8c13ec0	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3f298a13-0ab5-4572-82f7-0fa1b2691f07	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	7bd0404c-9603-e211-b291-0143ed05e022	3f298a13-0ab5-4572-82f7-0fa1b2691f07	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
232e4d9a-b106-4c52-a404-868264044e8b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	483046d6-87b2-4164-9247-49c073789a31	232e4d9a-b106-4c52-a404-868264044e8b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
288da187-ad92-4e0f-bc89-32f8922eaf06	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	ca99dedb-11fb-e111-88dd-91f29105d9d3	288da187-ad92-4e0f-bc89-32f8922eaf06	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
aad1f448-4080-4067-b4b6-ccb36d8b2fb3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	1c94fedd-9703-e211-b291-0143ed05e022	aad1f448-4080-4067-b4b6-ccb36d8b2fb3	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
5a8c9cb3-583c-4f24-b6ff-064c50f2672f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	94440896-8c99-11e3-ac3f-a3e636726f74	5a8c9cb3-583c-4f24-b6ff-064c50f2672f	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
7ecde80f-fee9-45fa-899a-c0c3bc7b8d96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	d9c6af96-777e-43b9-9bca-58c1300af26f	7ecde80f-fee9-45fa-899a-c0c3bc7b8d96	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
a6b110f8-8267-4ca2-80c0-b3a3985ec75d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	feedc192-f1f1-4ed6-bbaf-ff4c44f2d97b	a6b110f8-8267-4ca2-80c0-b3a3985ec75d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
b265af95-3379-4aa1-a7da-eac5f626208a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	89a07b97-5c4f-4984-82d1-1254eb1c86af	b265af95-3379-4aa1-a7da-eac5f626208a	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
b147e09a-1879-4aa9-8262-21b2537e8364	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	61a5fafc-5b11-11e3-8587-9b9c0e536ccd	b147e09a-1879-4aa9-8262-21b2537e8364	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
9ea111fe-8d20-4025-9b8e-bdcc4b7d0930	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	6632892c-82c9-445d-af7d-94cabbfdd363	b7636c46-2593-4792-968d-5432f3f28fa7	9ea111fe-8d20-4025-9b8e-bdcc4b7d0930	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
c7cd7639-6de6-476e-b824-f9786c26105a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	ee092c2a-fd8c-4323-96a0-7d44f36451de	c7cd7639-6de6-476e-b824-f9786c26105a	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
421ab3f5-8b77-4133-b86d-ee68aaa9edcc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	57ce637d-8acd-e211-b850-d12bb761bc4d	421ab3f5-8b77-4133-b86d-ee68aaa9edcc	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
12625b52-7bfb-487d-8cbb-897410e4179a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	14438df8-6630-11e4-8fc8-5721c0138d72	12625b52-7bfb-487d-8cbb-897410e4179a	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
85094bdd-e4fc-4284-9342-9495446502e3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	6ef941cd-f503-e211-a8c9-8de20f7d3878	85094bdd-e4fc-4284-9342-9495446502e3	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
2429f5c6-b2bc-4628-b00c-0694044d79fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	a091930a-1616-468a-861e-0a2e079f2b58	2429f5c6-b2bc-4628-b00c-0694044d79fd	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
5cf5ca1f-29ca-4780-80fe-93c8f97e887b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	fd19ac6d-b727-e211-963e-ffbc9c164446	5cf5ca1f-29ca-4780-80fe-93c8f97e887b	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
302f9937-91fd-4cd4-bc6d-3246de32bf62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	38ceb9f3-db02-e211-b4b6-b3231a53305c	302f9937-91fd-4cd4-bc6d-3246de32bf62	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
19c251f4-0d10-4eb1-8b7e-c74654bc97c8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	bed2e326-06e7-4698-94d5-d46efc825014	19c251f4-0d10-4eb1-8b7e-c74654bc97c8	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
45bfd013-b8ca-447f-a756-c1bbfe4783fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	b1245957-0802-e211-8442-77d6f35b44ad	45bfd013-b8ca-447f-a756-c1bbfe4783fe	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
df8caa2b-0de9-4a80-883d-011d945c412d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	eea51330-4df7-49dc-a58b-7e7fc6cf26ac	df8caa2b-0de9-4a80-883d-011d945c412d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
9b3b5eca-c6d9-43d7-8b99-80d130a7b2fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	374d54fa-9d39-4cec-99c8-b405824d8696	9b3b5eca-c6d9-43d7-8b99-80d130a7b2fa	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
bea13f1b-6651-49ad-b704-94edd6e5d7c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	2f274181-6333-4dad-af2b-b26b48362d9f	bea13f1b-6651-49ad-b704-94edd6e5d7c6	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
2aeb8f46-5cf3-4566-857f-b293ff088608	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	7bc4be4e-94d9-11e3-bb8e-af0feebc548b	2aeb8f46-5cf3-4566-857f-b293ff088608	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
3cf3e423-4977-4797-ae03-051fe4b554d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	4d40bb00-9c7b-43a0-a0ee-8c3c3ed1ba2a	3cf3e423-4977-4797-ae03-051fe4b554d9	\N	2019-12-06 17:37:55	2022-12-01 10:22:57	\N	2020-03-07 18:38:29
ca315f9b-42f5-4556-8d88-2b308b2ca1ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	079a34b8-4b76-11e5-814d-b3ab2368e254	ca315f9b-42f5-4556-8d88-2b308b2ca1ed	\N	2019-12-06 17:32:36	2022-12-01 10:22:57	\N	2020-03-07 18:38:37
1ec21efd-ae6b-4ad9-b9e8-f4e024a763a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	1ec21efd-ae6b-4ad9-b9e8-f4e024a763a9	\N	2019-12-06 17:32:36	2022-12-01 10:22:59	\N	2020-03-07 18:38:39
8d5fb309-a7ad-4dad-b10e-dd98ed4fe4e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	7ab0ba14-a17f-4ecd-8201-a673cc87846c	8d5fb309-a7ad-4dad-b10e-dd98ed4fe4e6	\N	2019-12-06 17:32:36	2022-12-01 10:22:59	\N	2020-03-07 18:38:39
1f273c53-ed15-4327-81ad-8e3913425982	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	0ea06995-f218-4530-9b63-0b499a11b034	1f273c53-ed15-4327-81ad-8e3913425982	\N	2019-12-10 08:09:12	2022-12-01 10:23:01	\N	2020-03-07 18:38:14
dfda3562-08b4-4feb-9100-f459716b4534	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	daa07555-dd3d-44da-856b-28f08ecd474e	dfda3562-08b4-4feb-9100-f459716b4534	\N	2019-12-06 17:32:36	2022-12-01 10:23:01	\N	2020-03-07 18:38:39
85f5df18-a1ee-4823-90f3-0a769e06470a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	beb52866-067c-4257-aa11-ac304217924c	85f5df18-a1ee-4823-90f3-0a769e06470a	\N	2019-12-06 17:37:55	2022-12-01 10:23:01	\N	2020-03-07 18:38:30
c60e813c-6c6c-4479-b25f-72dd73e774c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	7661d6a5-1907-41fd-8c82-a5fea385fef8	c60e813c-6c6c-4479-b25f-72dd73e774c2	\N	2019-12-06 17:32:36	2022-12-01 10:23:01	\N	2020-03-07 18:38:38
2f525f05-9fc7-4a22-94f5-483257fdc0ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	2f627335-3b69-4db3-94e3-0a43968e23e9	2f525f05-9fc7-4a22-94f5-483257fdc0ee	\N	2019-12-10 08:09:12	2022-12-01 10:23:05	\N	2020-03-07 18:38:14
15fea23f-b2fb-433c-ad80-0ae4dcd90006	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	b35c01a3-37d8-4b9c-921d-65a382a1ca70	15fea23f-b2fb-433c-ad80-0ae4dcd90006	\N	2019-12-06 17:37:55	2022-12-01 10:23:06	\N	2020-03-07 18:38:30
bca2cdd8-0037-4257-b626-affd513b2218	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	906376c2-1463-4361-897e-a7ef5a19239d	bca2cdd8-0037-4257-b626-affd513b2218	\N	2019-12-06 17:32:36	2022-12-01 10:23:07	\N	2020-03-07 18:38:38
e86d261b-eb43-4dd2-aba8-e6446cb81e5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	43995feb-8d7d-4f37-9a8b-b2ab3ff70ac2	e86d261b-eb43-4dd2-aba8-e6446cb81e5b	\N	2019-12-06 17:32:36	2022-12-01 10:23:10	\N	2020-03-07 18:38:39
46f83ed1-3270-4246-8f45-117e0dc259a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	a83c363b-c56d-49b3-9d37-61d51488daab	46f83ed1-3270-4246-8f45-117e0dc259a4	\N	2019-12-06 17:37:55	2022-12-01 10:23:10	\N	2020-03-07 18:38:30
518d1d53-ffd1-42f1-903b-8e2851e5c475	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	518d1d53-ffd1-42f1-903b-8e2851e5c475	\N	2019-12-06 17:32:36	2022-12-01 10:23:10	\N	2020-03-07 18:38:38
be49ce15-6aad-4a23-8e48-7c5d79537eb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	6b031760-aef5-4dbb-b520-01e6685a54d1	be49ce15-6aad-4a23-8e48-7c5d79537eb4	\N	2019-12-10 08:09:11	2022-12-01 10:23:21	\N	2020-03-07 18:38:14
898a6889-3c6d-40dd-a153-cd1217679bd5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	472d73e3-2d2f-488f-8e2f-cd3d22418632	898a6889-3c6d-40dd-a153-cd1217679bd5	\N	2019-12-06 17:32:36	2022-12-01 10:23:21	\N	2020-03-07 18:38:39
1918088b-da6b-4b32-8b6a-d8b58706bcbf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	1a68049f-e368-4766-8709-c7b9920f5e90	1918088b-da6b-4b32-8b6a-d8b58706bcbf	\N	2019-12-06 17:32:36	2022-12-01 10:23:25	\N	2020-03-07 18:38:39
f7da32c5-633a-4396-8103-0bd6d1179bcf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	f7da32c5-633a-4396-8103-0bd6d1179bcf	\N	2019-12-10 08:09:12	2022-12-01 10:23:25	\N	2020-03-07 18:38:20
6165aa4a-de21-4aff-a20b-153c822ed772	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	eb76ddaa-0c43-46c8-95da-50b0a7ab8108	6165aa4a-de21-4aff-a20b-153c822ed772	\N	2019-12-06 17:37:55	2022-12-01 10:23:26	\N	2020-03-07 18:38:30
6fd91ef6-32f2-42dd-893f-6a56a098fec7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	6fd91ef6-32f2-42dd-893f-6a56a098fec7	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
4cccc90a-0292-458c-a051-0fa6f36a8abc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	617d0298-7806-11e3-a360-3b79dafbb6d8	4cccc90a-0292-458c-a051-0fa6f36a8abc	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
acae61d9-9697-4f8a-b026-d4655e596610	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	7b907bc1-e927-e211-86f7-79cd2fac9006	acae61d9-9697-4f8a-b026-d4655e596610	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
1e1fbb90-4bca-4507-a707-f3045a2bb020	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	bede3706-7809-11e3-acc7-b7cb53fe2add	1e1fbb90-4bca-4507-a707-f3045a2bb020	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
dd3c2a4e-29a0-4e37-9384-de1a5262eb2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	15cd7ac1-e927-e211-86f3-79cd2fac9006	dd3c2a4e-29a0-4e37-9384-de1a5262eb2d	\N	2023-02-14 08:52:14	2023-02-14 08:52:14	\N	2023-02-14 08:52:14
df95e5b4-c761-4d15-ac42-3849a4613c98	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	b4b12980-d435-43ee-af2d-fed372080d2f	df95e5b4-c761-4d15-ac42-3849a4613c98	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
ddf79fd4-ad52-49cb-b4c1-d3a781badeb5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	b186ad12-8e0d-11e3-9179-078762557c01	ddf79fd4-ad52-49cb-b4c1-d3a781badeb5	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
ee7c13e7-8f5d-4389-96f4-435ab5ad9dae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	3b0b4884-726c-4551-9f8c-3db4d502c5f4	ee7c13e7-8f5d-4389-96f4-435ab5ad9dae	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
8ce4b6f2-1f65-4d2f-8696-5dd3d45c3fac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	eb492e22-77fd-e111-8da8-f1648fe48442	8ce4b6f2-1f65-4d2f-8696-5dd3d45c3fac	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
acdc9e7b-32a8-4ff0-bdf5-c72a10155834	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	58ee4cfb-ee19-e211-908e-59971fa3877e	acdc9e7b-32a8-4ff0-bdf5-c72a10155834	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
53699f03-e8ed-4322-bfb1-811001436b70	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	2c745a77-520e-e211-88dd-fd84abc6dc9a	53699f03-e8ed-4322-bfb1-811001436b70	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
f19a7cef-c3b0-41e1-8e68-f4d215ab2493	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	ba02677d-8acd-e211-b8a5-d12bb761bc4d	f19a7cef-c3b0-41e1-8e68-f4d215ab2493	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
c0ee36f3-5ae1-479f-b2c3-359dc05c9f44	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	accdf25c-06f9-4e7b-9678-a1acd1331088	c0ee36f3-5ae1-479f-b2c3-359dc05c9f44	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
127b9f65-d032-41e7-90b0-dae50ca69ec0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	6bcf1e8c-6f7f-11e3-8895-3357dd36639d	127b9f65-d032-41e7-90b0-dae50ca69ec0	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
94567c79-c8c7-4caf-8fb7-a080ffb6bb5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	842392af-953c-e211-8e89-9908d75a8f4c	94567c79-c8c7-4caf-8fb7-a080ffb6bb5e	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
88ab3010-7797-40d2-b93e-1f9cc7d379c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	0ed24a94-592d-11e5-8142-4f45aea730e6	88ab3010-7797-40d2-b93e-1f9cc7d379c2	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
5a9db177-22d1-4cfb-ba5c-f249aab3f8db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	a990755d-db89-48e1-9e88-fbff0e01d35c	5a9db177-22d1-4cfb-ba5c-f249aab3f8db	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
8ed919f9-0e10-4fc6-b217-463408d9468c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	180801b9-9103-e211-8560-17962475f905	8ed919f9-0e10-4fc6-b217-463408d9468c	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
51e57961-5d7d-4090-9626-420695d04873	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	06a67ac1-e927-e211-86f3-79cd2fac9006	51e57961-5d7d-4090-9626-420695d04873	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
2f0abed1-20b6-4d62-8891-4853e1fec2dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	63a8490b-068c-45da-92b9-da3c07470b9a	2f0abed1-20b6-4d62-8891-4853e1fec2dc	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
6e3d5e54-b781-411a-a37b-bfc26112186f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	bf147454-3d40-11e4-bd52-dfaac3a0de5c	6e3d5e54-b781-411a-a37b-bfc26112186f	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
360e9a44-8dbd-46ef-93fa-daa62b908f72	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	00d9161a-94d6-11e3-8e07-6bfd6236e395	360e9a44-8dbd-46ef-93fa-daa62b908f72	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
9d36e642-c088-4629-b98b-28fd0161fba5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	a5197a21-450c-4b9d-a2b7-5e5f76982fd2	9d36e642-c088-4629-b98b-28fd0161fba5	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
47fd761b-6bdc-4044-b625-52282eb29656	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	12ce8e21-0d8f-e211-8adf-a5d1cdfc52ac	47fd761b-6bdc-4044-b625-52282eb29656	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
b23a1f01-2e50-49aa-a358-11039b709f78	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	c8585e32-5bae-11e3-812d-37a32636c770	b23a1f01-2e50-49aa-a358-11039b709f78	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
3721c6b0-8a78-4408-8591-8e03246c9388	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	03421a06-1a10-4a1f-b7ed-1d087ed17e95	3721c6b0-8a78-4408-8591-8e03246c9388	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
8f35f4eb-3ea9-4749-affd-00763ce77f26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	cfb2d151-6b27-47f1-b699-63b669f81910	8f35f4eb-3ea9-4749-affd-00763ce77f26	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
6ba41b67-6f09-4043-8207-7a3c175e2e91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	29e9ea54-df02-e211-b4b6-b3231a53305c	6ba41b67-6f09-4043-8207-7a3c175e2e91	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
80d9b4c3-269e-4364-8d3c-78d602f39465	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	6632892c-82c9-445d-af7d-94cabbfdd363	f4dc7769-10f3-474c-9bad-a7f651d71321	80d9b4c3-269e-4364-8d3c-78d602f39465	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
627f0c8c-2711-4d5c-b3b9-c47a1206cb03	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	9373c4ae-71e3-11e3-8d00-a3618c7b2ae5	627f0c8c-2711-4d5c-b3b9-c47a1206cb03	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
6dce73ab-d82a-4b6b-a7c4-05d0d5db695e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	60d57fc7-076a-4434-be11-d769682a2631	\N	2019-12-06 17:32:36	2020-03-07 18:38:39	\N	2020-03-07 18:38:39
ccc3d679-a93b-40da-9d0f-3ae309dc8f8f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	ccc3d679-a93b-40da-9d0f-3ae309dc8f8f	\N	2019-12-06 17:32:36	2022-12-01 10:22:49	\N	2020-03-07 18:38:37
83828a9a-c1e6-4a00-9690-16abe76b7800	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	0c57cc9c-4c32-11e5-858c-afbc5904667e	83828a9a-c1e6-4a00-9690-16abe76b7800	\N	2019-12-06 17:32:36	2022-12-01 10:22:50	\N	2020-03-07 18:38:37
da2613c9-df17-413d-ba9a-1be23a037708	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	010a4695-214e-4efb-a13b-83ab9a7e5a9a	da2613c9-df17-413d-ba9a-1be23a037708	\N	2019-12-06 17:32:36	2022-12-01 10:22:51	\N	2020-03-07 18:38:37
aec40a70-4d54-4caf-8e10-de072e7c4d7a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	994e91c4-854b-4fe0-946c-0133e4582398	aec40a70-4d54-4caf-8e10-de072e7c4d7a	\N	2019-12-10 08:09:12	2022-12-01 10:22:53	\N	2020-03-07 18:38:14
a771dff1-28d2-4462-9129-b377d53d7618	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	5899f113-d963-4965-9245-1f6222f5bbc1	a771dff1-28d2-4462-9129-b377d53d7618	\N	2019-12-10 08:09:13	2022-12-01 10:22:54	\N	2020-03-07 18:38:14
44178305-fbb3-428c-ba74-ec20ab8d2f86	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	44178305-fbb3-428c-ba74-ec20ab8d2f86	\N	2019-12-06 17:32:36	2022-12-01 10:22:56	\N	2020-03-07 18:38:39
36a0831b-75c1-4996-951a-535b21506631	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	d5b3a578-1613-474e-865b-0a47f3a64167	36a0831b-75c1-4996-951a-535b21506631	\N	2019-12-10 08:09:12	2022-12-01 10:23:04	\N	2020-03-07 18:38:21
78b32b8b-5a46-430d-b20f-7339f9598a21	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	78b32b8b-5a46-430d-b20f-7339f9598a21	\N	2019-12-10 08:09:13	2022-12-01 10:23:04	\N	2020-03-07 18:38:14
d105557c-d749-47b5-92b6-565cc02c9767	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	d105557c-d749-47b5-92b6-565cc02c9767	\N	2019-12-10 08:09:13	2022-12-01 10:23:04	\N	2020-03-07 18:38:14
c73eec05-aca6-48e0-8e65-a0257beb764c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	eb76ddaa-0c43-46c8-95da-50b0a7ab8108	c73eec05-aca6-48e0-8e65-a0257beb764c	\N	2019-12-10 08:09:12	2022-12-01 10:23:06	\N	2020-03-07 18:38:14
2c54e125-175a-4cc1-b3b9-1a36d4c52203	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	d1de7680-727c-4931-a9c8-1cc3a384a7c5	2c54e125-175a-4cc1-b3b9-1a36d4c52203	\N	2019-12-10 08:09:13	2022-12-01 10:23:07	\N	2020-03-07 18:38:14
79325645-1812-4733-a6de-0598c750a68c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	79325645-1812-4733-a6de-0598c750a68c	\N	2019-12-06 17:37:55	2022-12-01 10:23:11	\N	2020-03-07 18:38:29
5dabb656-2ddc-4da4-9fd7-00f051c889ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	5dabb656-2ddc-4da4-9fd7-00f051c889ee	\N	2019-12-06 17:37:55	2022-12-01 10:23:12	\N	2020-03-07 18:38:29
1e8d6d90-d035-4437-ad48-7154679b46c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	5ae837e8-4a02-11e5-9a00-2bca72a8469e	1e8d6d90-d035-4437-ad48-7154679b46c5	\N	2019-12-10 08:09:13	2022-12-01 10:23:21	\N	2020-03-07 18:38:14
ffee45f2-d068-4b3d-a550-f61af3fb2dc9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	7a426c49-48eb-473c-9779-47a65a92d954	ffee45f2-d068-4b3d-a550-f61af3fb2dc9	\N	2019-12-10 08:09:13	2022-12-01 10:23:24	\N	2020-03-07 18:38:14
5a5514b0-7c11-4913-b964-2c01857e5c4f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	5a5514b0-7c11-4913-b964-2c01857e5c4f	\N	2019-12-10 08:09:12	2022-12-01 10:23:24	\N	2020-03-07 18:38:14
866de040-6674-4b7f-bb14-2912bc7fd586	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	cae987c8-810a-4d95-a5fb-27e3108961de	866de040-6674-4b7f-bb14-2912bc7fd586	\N	2019-12-10 08:09:13	2022-12-01 10:23:24	\N	2020-03-07 18:38:14
6347cfa0-4439-4a2f-9ef3-960d842a410f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	e7692714-42a9-11e5-a70e-2322869c051b	6347cfa0-4439-4a2f-9ef3-960d842a410f	\N	2019-12-10 08:09:13	2022-12-01 10:23:26	\N	2020-03-07 18:38:14
a12bf6da-e256-4d9f-ae84-8ff289c3c6bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	210fde58-74aa-4ea9-a4e4-ab32b37448b1	a12bf6da-e256-4d9f-ae84-8ff289c3c6bd	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
164df781-30cb-4309-a8a3-3002cda445fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	489e1454-e4ac-47cc-b7d0-51c8ff56abbf	164df781-30cb-4309-a8a3-3002cda445fc	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
ff74f02b-5076-40b5-b3a2-8c660eb11093	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	b68d69d6-0502-e211-8442-77d6f35b44ad	ff74f02b-5076-40b5-b3a2-8c660eb11093	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
d7ebb3df-ffda-47fe-afca-8d527fdbe5a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	c3a53678-d7a7-4c1b-807f-3034b37ec04a	d7ebb3df-ffda-47fe-afca-8d527fdbe5a6	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
12633227-6b19-4c6c-9db1-fb275053b5eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	2e1ffdef-a176-4b92-a196-a4e28455403d	12633227-6b19-4c6c-9db1-fb275053b5eb	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
f2d6bcda-bc2d-411c-b599-6a79381c5214	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	667a149e-7929-e211-ab63-417b9cc965f1	f2d6bcda-bc2d-411c-b599-6a79381c5214	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
73619d63-029d-4d29-821e-25788d1a1003	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	67ee6efb-ca29-e211-82ed-4bf89d6bb6ec	73619d63-029d-4d29-821e-25788d1a1003	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
eee8c62b-3808-4b30-9720-dccb8335c75d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	c5fdbd10-8585-40b5-9cd2-83dde161d8c8	eee8c62b-3808-4b30-9720-dccb8335c75d	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
c8a6271c-d96f-44c6-988a-c6c125c4713d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	62bf4771-c092-434d-8e93-0260891de1ff	c8a6271c-d96f-44c6-988a-c6c125c4713d	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
a7772058-1bcc-42d6-a058-98fc4c206856	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	d17acbd0-7f5c-4fb0-9fa7-bd34886d0788	a7772058-1bcc-42d6-a058-98fc4c206856	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
82db6ea1-8882-47f9-8dad-8ba8c694db86	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	bfc8b844-394c-48b0-b8a5-27643ae71c6f	82db6ea1-8882-47f9-8dad-8ba8c694db86	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
ff9fe6d2-d2c9-49f9-9dcc-fc1f155396bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	2ddac1d3-c129-e211-82ed-4bf89d6bb6ec	ff9fe6d2-d2c9-49f9-9dcc-fc1f155396bf	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
bdb8f02e-a173-44f6-8446-084472c0415a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	0c563131-c129-e211-b674-55b8a5daa5db	bdb8f02e-a173-44f6-8446-084472c0415a	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
0ec2f949-62f7-4399-b712-1ed7831a04d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	1a4e610e-0b02-e211-8442-77d6f35b44ad	0ec2f949-62f7-4399-b712-1ed7831a04d4	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
b985fccd-06d2-4f73-9167-3af20f23d4d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	34fc02aa-8c88-11e3-8f45-97026e699162	b985fccd-06d2-4f73-9167-3af20f23d4d0	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
1b640fa9-adb5-4957-b837-a4df764b4514	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	872b669d-a706-e211-b032-b1f1b004bcca	1b640fa9-adb5-4957-b837-a4df764b4514	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
be32aeef-26bf-47df-b728-c364c6002ab5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	54c1ab04-63b9-4bf3-8d0b-55359bf1a7b2	be32aeef-26bf-47df-b728-c364c6002ab5	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
de24ab9e-abda-4185-a135-1dc2f8ad02c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	2e383874-7f7e-11e3-b87c-131c0087c0c4	de24ab9e-abda-4185-a135-1dc2f8ad02c1	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
cba5dc56-c8e7-4347-9ee5-2dd16a223201	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	a80be64e-5393-49df-a6f7-8a18736444a1	cba5dc56-c8e7-4347-9ee5-2dd16a223201	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
f2898d4d-9a78-420c-baba-8cb8a35df98c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	480ab734-94d9-11e3-af34-afde42cffeec	f2898d4d-9a78-420c-baba-8cb8a35df98c	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
cda39757-e153-40be-8207-9d8b9e4e462b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	330c1f39-a513-4841-88ce-6bbdbb912d1c	cda39757-e153-40be-8207-9d8b9e4e462b	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
952eced5-4e55-4c91-9e72-998e5fe8b1a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	ae2a025b-c727-e211-963e-ffbc9c164446	952eced5-4e55-4c91-9e72-998e5fe8b1a4	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
0074a785-7875-4dc6-9b82-50cdef3d5df6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	56fbd12f-009d-4448-b9ce-76e42ea92a41	0074a785-7875-4dc6-9b82-50cdef3d5df6	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
51990103-d1f3-4951-ac4b-57bd287c4971	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	fcb1333e-564a-11e3-8a8e-ab90d2049a72	51990103-d1f3-4951-ac4b-57bd287c4971	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
97eaef97-2290-43e0-a00a-06bfee86e858	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	9433b08e-fac0-4a20-9d42-684e7aced3c6	97eaef97-2290-43e0-a00a-06bfee86e858	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
428e0eba-36b2-46eb-8e20-94f6d397d2df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	e98a52c9-013b-4a3d-aeaa-a3738ed9ec63	428e0eba-36b2-46eb-8e20-94f6d397d2df	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
a585ff4a-ef86-48e9-90ad-dd34d05f15ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	49b646f0-5bb5-11e3-a96d-e7586c796b63	a585ff4a-ef86-48e9-90ad-dd34d05f15ed	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
7aa7729c-ed90-4140-b251-e39cab7dea9a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	cb8b1fce-24e3-4b52-a592-0d344bbf9481	91a30c77-bf27-e211-963e-ffbc9c164446	7aa7729c-ed90-4140-b251-e39cab7dea9a	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
6ab0ce25-9b02-4f7b-ae76-666c21d18341	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	8314bc86-f503-e211-a8c9-8de20f7d3878	6ab0ce25-9b02-4f7b-ae76-666c21d18341	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
67ed0dd2-3052-41d1-a1ca-82a80e255362	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	7a13c707-8f03-e211-8560-17962475f905	67ed0dd2-3052-41d1-a1ca-82a80e255362	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
e78fb3db-53d0-4e71-be84-1ebbc449cdcf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	7c15fbb2-33c9-4ba2-93a4-b9d988e939b4	e78fb3db-53d0-4e71-be84-1ebbc449cdcf	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
59ac45f0-dc0f-4e29-a6b9-ac62fe1e95f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	35f61c84-f7a1-46ab-b330-cdd8040281e6	fae6a1c2-8e0a-11e3-8141-7f4802cb1e93	59ac45f0-dc0f-4e29-a6b9-ac62fe1e95f7	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
4cbef572-d9ea-4d5f-9906-e738be75adeb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	ea95c523-7a1a-e211-8842-a9f06a07ae1b	4cbef572-d9ea-4d5f-9906-e738be75adeb	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
fcf5248d-736e-4155-9c83-aa33e0bce781	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e173e389-a6ea-4b41-bf56-a821ed92271a	99153600-e522-442f-994e-45c3cb038980	fcf5248d-736e-4155-9c83-aa33e0bce781	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
9d9b4ee5-9025-4532-a1a0-0a503a6e739c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	13dddfb3-d073-4ea5-8d4b-42110bae1c8f	087c218d-0643-48d4-86ff-7c8017578e03	9d9b4ee5-9025-4532-a1a0-0a503a6e739c	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
3fa04e6c-8f11-4e00-b31d-d12af3bd84ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	33bce156-94d6-11e3-9dfa-1b9f2c131c25	3fa04e6c-8f11-4e00-b31d-d12af3bd84ab	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
d5886e27-b17b-4f69-ae8f-d195c6753b0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	53280181-9866-46c3-9c66-9356a404553c	d6da0950-f65b-47d2-9965-579b90b08ffd	d5886e27-b17b-4f69-ae8f-d195c6753b0e	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
b660bca8-177f-4eed-8e16-d155b0dac82e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	6632892c-82c9-445d-af7d-94cabbfdd363	ea745b98-c427-e211-963e-ffbc9c164446	b660bca8-177f-4eed-8e16-d155b0dac82e	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
72e82ec3-5579-4e99-bbb7-a636ce28f6f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	a6aa8d10-6443-4b31-882e-ecf96e45a52c	b0c37ebb-2fd5-4fc2-883e-267cdb7c8942	72e82ec3-5579-4e99-bbb7-a636ce28f6f1	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
73f36a7f-54e5-4969-af1c-07913f5c0504	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	73f36a7f-54e5-4969-af1c-07913f5c0504	\N	2019-12-10 08:09:14	2022-12-01 10:22:57	\N	2020-03-07 18:38:14
48fa2918-9e2e-4f1b-990d-191e9c0d8b50	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	645aba46-378c-11e4-a83f-afbd60abf5c3	48fa2918-9e2e-4f1b-990d-191e9c0d8b50	\N	2019-12-10 08:09:13	2022-12-01 10:22:58	\N	2020-03-07 18:38:14
55213892-c36d-4781-ba52-5a6721baeb80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	14fba9a1-6ca4-4937-84e7-2a845d02897a	55213892-c36d-4781-ba52-5a6721baeb80	\N	2019-12-10 08:09:13	2022-12-01 10:23:01	\N	2020-03-07 18:38:21
087c0b48-537b-4225-b688-61c4964bac55	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	6402418c-54f9-11e5-9e54-5397b782050d	087c0b48-537b-4225-b688-61c4964bac55	\N	2019-12-10 08:09:14	2022-12-01 10:23:04	\N	2020-03-07 18:38:14
3cfefffd-349e-4bb5-a094-ef3218970b95	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	3cfefffd-349e-4bb5-a094-ef3218970b95	\N	2019-12-06 17:32:36	2022-12-01 10:23:16	\N	2020-03-07 18:38:39
83c130ab-55da-491c-be92-c8e932803ec8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	f80b678d-bb43-4915-9ef0-22b1d2320638	83c130ab-55da-491c-be92-c8e932803ec8	\N	2019-12-06 17:32:36	2022-12-01 10:23:17	\N	2020-03-07 18:38:38
e034a114-4f5a-44c6-b767-76021b3bb4e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	00e6f0c6-c214-4588-90c0-4a271deaa2c9	e034a114-4f5a-44c6-b767-76021b3bb4e4	\N	2019-12-06 17:32:36	2022-12-01 10:23:17	\N	2020-03-07 18:38:38
c11a6f1a-0db6-4117-89e3-948a4d40ac77	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	11558ce2-46ca-11e5-8ba3-b7381d40fb27	c11a6f1a-0db6-4117-89e3-948a4d40ac77	\N	2019-12-06 16:14:40	2022-12-01 10:23:19	\N	2020-03-07 18:38:31
e614d68b-f267-446f-b740-130110eac86a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	679c6691-5977-4188-b9cb-15090b3fb85f	e614d68b-f267-446f-b740-130110eac86a	\N	2019-12-06 17:32:36	2022-12-01 10:23:26	\N	2020-03-07 18:38:37
47e49d87-5d8a-42d1-ac21-b8c894fcb830	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	47e49d87-5d8a-42d1-ac21-b8c894fcb830	\N	2019-12-10 08:09:13	2022-12-01 10:23:29	\N	2020-03-07 18:38:14
a9225272-43c9-4c68-95a2-38490f3e7d7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	539c2dbe-5e22-11e3-97a4-6b60c900259e	a9225272-43c9-4c68-95a2-38490f3e7d7f	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
0030ee27-cfbd-445c-99a2-1eab37cd703d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	8166568f-7b1a-e211-8842-a9f06a07ae1b	0030ee27-cfbd-445c-99a2-1eab37cd703d	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
5411f97c-e2c6-45a4-84d4-9c814908c5e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	89a2b237-608e-45bd-8493-cfb3ea0df277	6149e37c-57ea-11e3-8a63-0bad90edf22e	5411f97c-e2c6-45a4-84d4-9c814908c5e5	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
f26856c1-eb2d-4ad9-8f1e-8f9a5f9e52a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	e80c4ca3-b36b-4879-9103-e1baa1a40865	0110eb45-f503-e211-a8c9-8de20f7d3878	f26856c1-eb2d-4ad9-8f1e-8f9a5f9e52a2	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
bb9986c6-75af-41ee-bfd8-e9514cfa99a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	45415dd0-4621-47ed-a8db-e46c5ea08f8d	b3d74216-101c-e211-af82-4f62965233f9	bb9986c6-75af-41ee-bfd8-e9514cfa99a4	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
65fac330-24d1-4384-84cc-778d28ac68eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	14f34d04-bb92-4cf1-bb11-5e424fa98ae7	65fac330-24d1-4384-84cc-778d28ac68eb	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
f872f6d9-6b9d-47be-99b6-872bd13660f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	c6f92ad8-49d5-4eb0-8dc4-263a1803956d	1efebede-0f12-4c19-ab53-2090b7359148	f872f6d9-6b9d-47be-99b6-872bd13660f0	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
7ed14d0c-d980-45aa-879d-4b66d9b96d19	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20222	fce581f0-08a6-4ab5-bbab-b0c8c43b5847	46b37dc1-e927-e211-86f9-79cd2fac9006	7ed14d0c-d980-45aa-879d-4b66d9b96d19	\N	2023-02-14 08:52:15	2023-02-14 08:52:15	\N	2023-02-14 08:52:15
71ffee79-cf55-4700-9733-e0d6c431b42b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	5972d13a-3896-11e4-91bd-bf146bb118a2	71ffee79-cf55-4700-9733-e0d6c431b42b	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
222da5b6-50f9-49e8-a2dd-699c97d702cf	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	86d00f80-3a94-11e4-9522-bf7b23e63d2f	222da5b6-50f9-49e8-a2dd-699c97d702cf	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
3208d4de-64b1-45b5-a9e4-1c854c295159	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	a8049614-3d18-11e3-9781-bfe88f28ee97	3208d4de-64b1-45b5-a9e4-1c854c295159	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
def73c49-aac1-4ed0-9cf5-6b2bdb0375af	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	5e45060c-3813-11e4-badd-bfe978d41668	def73c49-aac1-4ed0-9cf5-6b2bdb0375af	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
a10603aa-0ee0-4fca-92f7-d868b6c739eb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	6675bca8-3463-4861-a699-c28ee0f399ec	a10603aa-0ee0-4fca-92f7-d868b6c739eb	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
49d7ea67-aeb9-4bad-a37d-b040b422829c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	27a3d6e8-404b-11e3-96bd-c35830637d89	49d7ea67-aeb9-4bad-a37d-b040b422829c	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
d3456a14-a0d5-4822-be81-bdc879956e0e	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	e5c9f034-2fca-47f6-8bcf-c36c4604c691	d3456a14-a0d5-4822-be81-bdc879956e0e	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
08f52cae-7d02-42e1-a5ae-500fb10a7e42	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	32c2d75e-520c-11e3-af85-c3f421335de8	08f52cae-7d02-42e1-a5ae-500fb10a7e42	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
89e5f650-33ff-4850-bd0a-2d4151d22f08	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	7b5bb12d-be25-4251-b1e5-c4c872f99c2e	89e5f650-33ff-4850-bd0a-2d4151d22f08	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
5d1f0962-cada-4cba-afff-0f356b734aa0	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c1e7f994-e0c0-478d-aff3-6774262fe03f	f9647867-6009-e211-84c8-c73867db8fbc	5d1f0962-cada-4cba-afff-0f356b734aa0	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
07befa16-b869-4aad-ad02-64919a2f5f76	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	9220e30d-6209-e211-84c8-c73867db8fbc	07befa16-b869-4aad-ad02-64919a2f5f76	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
1b5cc036-d392-441d-8b4c-35f07fa77018	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	d037584f-6309-e211-84c8-c73867db8fbc	1b5cc036-d392-441d-8b4c-35f07fa77018	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
47f531db-3cf6-4e99-9b7d-b2a4e1aa85b4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	11bf9ed7-6809-e211-84c8-c73867db8fbc	47f531db-3cf6-4e99-9b7d-b2a4e1aa85b4	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
7144cedf-0736-42a8-a449-e4706d4c1c58	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	11a3e119-6909-e211-84c8-c73867db8fbc	7144cedf-0736-42a8-a449-e4706d4c1c58	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
190873d3-58f0-4d28-b6c7-608bca177b21	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	eae9a7b8-a278-41b3-9d23-c784fae8f504	190873d3-58f0-4d28-b6c7-608bca177b21	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
735e73bd-bf83-4f40-959c-e4f1bb5a24bb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	441b8cbe-31a7-11e4-b649-c7cac0f21c4b	735e73bd-bf83-4f40-959c-e4f1bb5a24bb	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
667c2ca5-18e9-456b-98fd-56cc47730595	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	3d303841-4911-4bab-8de2-c8c6b76e5922	667c2ca5-18e9-456b-98fd-56cc47730595	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
0a1bf12e-0551-4fc1-80d8-1c228595f553	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	6092a7a2-490c-11e4-a03b-cb183bfc5046	0a1bf12e-0551-4fc1-80d8-1c228595f553	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
9791b48f-039c-48c2-b9ff-38b5b5bd1e46	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	c1cddfae-3d1f-11e3-ad9a-cb8b73a73013	9791b48f-039c-48c2-b9ff-38b5b5bd1e46	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
15c4b477-28c1-4d68-928a-1ba7ba453455	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	6adc41ed-ab90-e211-aeef-cd5133f6d471	15c4b477-28c1-4d68-928a-1ba7ba453455	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
7f5da216-9655-45c6-bf3a-63ed9133d4fa	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	cac97a5e-917b-11e3-b959-cf0fd834cfd2	7f5da216-9655-45c6-bf3a-63ed9133d4fa	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
b92bfec8-6557-48fa-b16f-7b1966d0e906	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	feba850c-d707-e211-ba84-cf1376f63472	b92bfec8-6557-48fa-b16f-7b1966d0e906	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
dad925b8-be93-4fcd-84e4-3ad1f86db00f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	4ad6349e-988f-e211-b053-cf5c364a1193	dad925b8-be93-4fcd-84e4-3ad1f86db00f	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
3ead80b9-c4ac-4afb-96a5-a2c6fa2ec472	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	1c414fb6-20ff-11e4-855d-cf810a81999e	3ead80b9-c4ac-4afb-96a5-a2c6fa2ec472	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
cf4a11d7-252f-44ea-83c1-a978dfa15602	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	c1c84e22-35d5-11e4-a943-cfc7579b14fe	cf4a11d7-252f-44ea-83c1-a978dfa15602	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
2ca07e92-eb00-40a7-b293-9623d3ca478f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	1dcfc7fa-2f4f-11e4-8b45-d32356cc58d7	2ca07e92-eb00-40a7-b293-9623d3ca478f	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
09f0bb5c-1ae6-4ef2-8fa6-bc2c960ae5ac	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	f52c6d98-3f3f-11e4-ae29-d34b3ca5f7d4	09f0bb5c-1ae6-4ef2-8fa6-bc2c960ae5ac	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
c8095c63-8290-422d-b0e2-c65fe34a04de	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	8ee8a3e0-bdc9-4334-8595-d39aeddc1ecc	c8095c63-8290-422d-b0e2-c65fe34a04de	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
ddd1d0e0-55d2-477e-9697-9c3ed4bebe13	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	6d5119b6-43fc-11e4-8782-d3af44bc007c	ddd1d0e0-55d2-477e-9697-9c3ed4bebe13	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
52bbb273-263b-4e33-afa2-cca9e799352c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	704207c6-48ed-11e3-b9b9-d3fae4df43d9	52bbb273-263b-4e33-afa2-cca9e799352c	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
ad576655-119a-4c10-9952-2c7ea0f2074f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	f14cb829-431f-4303-8cf2-d4820924daf7	ad576655-119a-4c10-9952-2c7ea0f2074f	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
f31d2ba3-43c5-4dc2-ab5f-01976bbb1069	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	eced1bad-380d-49a1-b3bb-d57ccecbecd8	f31d2ba3-43c5-4dc2-ab5f-01976bbb1069	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
80f32cea-c4f2-439c-a57d-493022cd8d6c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	25741122-d497-4a34-b99f-d5f69745563f	80f32cea-c4f2-439c-a57d-493022cd8d6c	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
5217d572-529b-48c3-9362-d5910b3c84ac	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	60ed1f83-3808-47fb-bff2-d64c247bfdb2	5217d572-529b-48c3-9362-d5910b3c84ac	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
e38f474b-58af-4a37-a5c5-a2b717788b49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	ae5c71e9-252b-4467-8805-fadddbaf89c4	4bc78175-fa8f-4d29-a640-ee815ba9883b	\N	2019-12-10 08:09:13	2020-02-20 15:02:16	2020-02-20 15:02:16	2019-12-19 08:08:38
117bddb1-2c00-4364-a500-b1a3a6a40065	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	e3549675-96bb-4c36-9d4e-b034c5de4b80	117bddb1-2c00-4364-a500-b1a3a6a40065	\N	2019-12-10 08:09:13	2022-12-01 10:22:48	\N	2020-03-07 18:38:14
28a68095-5d64-4def-9e7a-e71062f2652f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	31d87dba-8af0-48a5-a609-901bda9031d3	28a68095-5d64-4def-9e7a-e71062f2652f	\N	2019-12-06 17:32:36	2022-12-01 10:22:52	\N	2020-03-07 18:38:39
52b11a35-82da-4d0e-892b-b1c017ef773d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	54894cf6-ecf9-44c5-87e8-b87e6bf62120	52b11a35-82da-4d0e-892b-b1c017ef773d	\N	2019-12-10 08:09:15	2022-12-01 10:22:53	\N	2020-03-07 18:38:14
a9358ff2-6394-4f54-a74f-8ef6ef684cbc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	4d40bb00-9c7b-43a0-a0ee-8c3c3ed1ba2a	a9358ff2-6394-4f54-a74f-8ef6ef684cbc	\N	2019-12-10 08:09:15	2022-12-01 10:23:01	\N	2020-03-07 18:38:14
3931baf9-0597-40bc-9bed-0ef91038b0e7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	3931baf9-0597-40bc-9bed-0ef91038b0e7	\N	2019-12-06 17:32:36	2022-12-01 10:23:06	\N	2020-03-07 18:38:37
30ac389b-f84d-47c9-9615-7459d21b5744	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	c593fef2-46d2-11e5-b14e-8fa23f386b5a	30ac389b-f84d-47c9-9615-7459d21b5744	\N	2019-12-10 08:09:15	2022-12-01 10:23:11	\N	2020-03-07 18:38:14
d60865b2-19b9-4a32-99f4-a3ea551fd4c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	ad705d8a-429e-11e5-a989-af44a02d940a	d60865b2-19b9-4a32-99f4-a3ea551fd4c6	\N	2019-12-10 08:09:13	2022-12-01 10:23:16	\N	2020-03-07 18:38:23
8103d47e-6173-4a98-b326-408a7dbe7be0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	8103d47e-6173-4a98-b326-408a7dbe7be0	\N	2019-12-10 08:09:14	2022-12-01 10:23:24	\N	2020-03-07 18:38:14
f2e39767-2733-4515-802f-1ef320068850	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	3ad03a6a-9caa-40e4-a060-62e1680cd17b	f2e39767-2733-4515-802f-1ef320068850	\N	2019-12-10 08:09:14	2022-12-01 10:23:26	\N	2020-03-07 18:38:14
ca00e1a7-e41b-4755-ba96-d95a80832d8d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	ca00e1a7-e41b-4755-ba96-d95a80832d8d	\N	2019-12-10 08:09:15	2022-12-01 10:23:28	\N	2020-03-07 18:38:14
c83c372f-d4f4-40b0-8c3c-6b0c07bcb1bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	a83c363b-c56d-49b3-9d37-61d51488daab	c83c372f-d4f4-40b0-8c3c-6b0c07bcb1bd	\N	2019-12-10 08:09:14	2022-12-01 10:23:29	\N	2020-03-07 18:38:14
99fdcafd-54d3-42e5-bff4-a7635418d7e6	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	e3f31c93-7a1d-e211-b449-0140ee5adb18	99fdcafd-54d3-42e5-bff4-a7635418d7e6	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
bb97a99d-2f9d-4cc0-b226-a4e415097e09	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	af2fdc1e-9a24-11e3-ac7b-030dd648c0c6	bb97a99d-2f9d-4cc0-b226-a4e415097e09	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
932e8e4e-6853-401b-93c1-52e5175af715	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	f4198eb4-3f9e-11e3-b275-0387a763688a	932e8e4e-6853-401b-93c1-52e5175af715	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
f27423e2-09be-4135-a42a-45cf4d3de12c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	97e618d8-31dd-11e4-9229-039285ec44a6	f27423e2-09be-4135-a42a-45cf4d3de12c	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
79aae313-6097-47ca-9482-a829a10d8aa1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	fc1ba44e-4ff2-11e3-855d-07b3cdf40144	79aae313-6097-47ca-9482-a829a10d8aa1	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
61fdd226-7fb6-491c-840a-30189d2eeee0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	a583ca72-369b-11e4-bc3b-07c591e2c18a	61fdd226-7fb6-491c-840a-30189d2eeee0	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
0f1dbdef-66d2-4588-ae67-b2b2ccf6f0f3	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	5c860a62-d128-482a-bc6f-08072cf031de	0f1dbdef-66d2-4588-ae67-b2b2ccf6f0f3	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
cc15e7fd-33e2-4530-9281-4ad577ef19bf	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	b9af12d0-2486-11e4-ae36-0b04d81c1e4c	cc15e7fd-33e2-4530-9281-4ad577ef19bf	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
1f34cede-56d5-4ea3-bcaf-1135d6218f9a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	aac77ee8-d9e6-e111-b504-0bc59d4c2008	1f34cede-56d5-4ea3-bcaf-1135d6218f9a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
339142e9-e9d5-41bc-874f-c100f446cf88	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	109064da-dde6-e111-b504-0bc59d4c2008	339142e9-e9d5-41bc-874f-c100f446cf88	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
d877aa07-7b9b-4a9b-a7a2-847c2e1ce21c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	529662e7-e6e6-e111-b504-0bc59d4c2008	d877aa07-7b9b-4a9b-a7a2-847c2e1ce21c	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
4c6ecfcc-4b8c-415e-9daf-1b21d5dca0e9	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	d6f94a44-9567-11e3-b5fd-0bd771d0bf98	4c6ecfcc-4b8c-415e-9daf-1b21d5dca0e9	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
50e76476-d161-4b97-af1d-a820ceebb3cb	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	4083f5c2-25eb-11e4-813b-0f6f98a76319	50e76476-d161-4b97-af1d-a820ceebb3cb	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
6fa3615a-3807-4630-89c7-b50141e53c8d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	7e5348e4-551c-11e3-a690-13482e435e94	6fa3615a-3807-4630-89c7-b50141e53c8d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
e6cd8f1d-cabb-4e73-b2ab-8f7433b4dbe6	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	bbfb782f-c946-441c-93d8-169637fabfd6	e6cd8f1d-cabb-4e73-b2ab-8f7433b4dbe6	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
fb821cf7-8ba4-47c0-84fa-ae819db19613	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	317779ea-954b-11e3-b6a7-1731ba9b364f	fb821cf7-8ba4-47c0-84fa-ae819db19613	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
ea21d8a2-6a12-4a60-96bb-58833fb8608a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	dc93705a-2b5e-11e4-a0d6-174ace55191f	ea21d8a2-6a12-4a60-96bb-58833fb8608a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
3ae875dc-25eb-468b-9f0d-be2d2a47ca52	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	877d45f6-2554-11e4-9544-1b4b031c0b97	3ae875dc-25eb-468b-9f0d-be2d2a47ca52	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
2c87afc4-836c-4319-8cf9-5660b0fc99bc	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	0b647e62-460f-11e5-a3e6-1bb7e3f2ff9c	2c87afc4-836c-4319-8cf9-5660b0fc99bc	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
c15f1c8b-6da7-4043-80e9-fd6dbf15b617	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	34b752a2-5512-11e3-bcd4-1fa71ad87ecb	c15f1c8b-6da7-4043-80e9-fd6dbf15b617	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b95c7037-1306-42b0-8407-52adc35990b1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	a35bf8a8-a7eb-e111-860f-1fc9695efd9f	b95c7037-1306-42b0-8407-52adc35990b1	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
93ec2b22-e9dc-4972-a913-1d8ef1af7d18	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	e59a5da2-d9d4-4cad-be5d-219380b86a03	93ec2b22-e9dc-4972-a913-1d8ef1af7d18	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a473b171-e900-439a-bb56-7a80d44a6291	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	1acd5df2-328c-11e4-9265-232a0c001256	a473b171-e900-439a-bb56-7a80d44a6291	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
e34ef3b5-1a8f-480f-9e9f-ba44affbe26a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	27ae98e0-3289-11e4-8da4-23510cec4fa9	e34ef3b5-1a8f-480f-9e9f-ba44affbe26a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
8f2c372c-8406-4612-bb85-c9ca5e5e4d61	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	bcf13cc0-551a-11e3-afde-236b2dbfc43b	8f2c372c-8406-4612-bb85-c9ca5e5e4d61	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
489389b1-4734-484f-8f23-b5f52249fa4c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	331c4224-32af-11e4-92c1-237541c2865c	489389b1-4734-484f-8f23-b5f52249fa4c	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
e887d333-ba08-48ca-b499-cbf0054ad60d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	7e3b794c-550f-11e3-b83d-2376b33bd3da	e887d333-ba08-48ca-b499-cbf0054ad60d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
9a77c4df-4e7f-4c55-9f7e-d07f8ae4262a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	572c8c1a-751c-11e3-8495-238f09c7f62e	9a77c4df-4e7f-4c55-9f7e-d07f8ae4262a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
ab29e777-6a8b-4ae4-8dce-2910e987cc62	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	160833ba-583e-11e3-b1eb-23beafda216b	ab29e777-6a8b-4ae4-8dce-2910e987cc62	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
2ac0b446-98cc-47ae-9fe7-0cfea5da8718	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	8ee545ee-2b50-11e4-b0f4-23ee580517b5	2ac0b446-98cc-47ae-9fe7-0cfea5da8718	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b1d05647-c856-441b-8f2b-ef71613492c7	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	12fed447-6643-493e-ab0b-246358bd1063	b1d05647-c856-441b-8f2b-ef71613492c7	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b4a7f1b2-bdf2-4651-a9d2-27eac693b3c6	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	603d0abe-2b51-11e4-ade8-2719cd2069e9	b4a7f1b2-bdf2-4651-a9d2-27eac693b3c6	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
5b8228f0-05c7-4aae-9e44-b1b89f83dbff	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	7f8dfab6-3fe5-11e3-b5b3-27956e210c2c	5b8228f0-05c7-4aae-9e44-b1b89f83dbff	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
666136f6-ed26-4a8b-a152-1a95adbecc7f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	5bd9cf10-3fe3-11e4-a912-27fc6bf5848b	666136f6-ed26-4a8b-a152-1a95adbecc7f	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
8dbe57b5-f1f2-4852-846e-0407bdea7d3f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	e0591510-328d-11e4-87f0-2b001d600b4b	8dbe57b5-f1f2-4852-846e-0407bdea7d3f	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
2b6c23e7-ae5a-40a4-9d7a-5e1fcab6cd7d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	84242892-2456-11e4-970d-2b4710a175f0	2b6c23e7-ae5a-40a4-9d7a-5e1fcab6cd7d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
8072f0aa-cff8-46ab-86a3-85eaa00c241a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	62996708-911b-4ccb-94fd-2b71acda8b88	8072f0aa-cff8-46ab-86a3-85eaa00c241a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
521d1698-2d12-432d-abf0-32e54e7c92bb	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	93142433-a81d-e211-827c-2f564f42a4a8	521d1698-2d12-432d-abf0-32e54e7c92bb	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
3225b1fb-3352-452f-b083-73838955d4fc	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	c472f746-350b-11e4-9ec2-2ffe7b0516ea	3225b1fb-3352-452f-b083-73838955d4fc	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
97caed1c-5fb4-41e2-b772-7fbb125b9bf3	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	e8d5277e-9283-11e3-9725-33442801a96a	97caed1c-5fb4-41e2-b772-7fbb125b9bf3	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
739ae1b8-6aea-4253-a6c7-09956868b3a3	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	875cadc4-3f94-11e3-8f3d-338418845760	739ae1b8-6aea-4253-a6c7-09956868b3a3	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a6193aa0-3c93-4e02-aa6e-64275db5f07d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	6b332356-2b59-11e4-93c7-33ac87e28603	a6193aa0-3c93-4e02-aa6e-64275db5f07d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b6abb3a7-5c27-466b-9815-315946c3fa1c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	388d8376-5515-11e3-9dcd-33bbfef8aec7	b6abb3a7-5c27-466b-9815-315946c3fa1c	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a45b2c24-6738-46aa-9505-b214c3f2d946	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	beb52866-067c-4257-aa11-ac304217924c	a45b2c24-6738-46aa-9505-b214c3f2d946	\N	2019-12-10 08:09:15	2022-12-01 10:22:49	\N	2020-03-07 18:38:14
09a8cde6-8b5d-4845-ba9a-647b9067b6b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	2a0784f4-94ee-435b-8fb3-8c798d15d817	09a8cde6-8b5d-4845-ba9a-647b9067b6b7	\N	2019-12-10 08:09:16	2022-12-01 10:22:53	\N	2020-03-07 18:38:14
4caf5904-3942-49ed-957f-fd6c0c424963	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	8b4ea31e-4aa0-427e-a65f-928b232d7f14	4caf5904-3942-49ed-957f-fd6c0c424963	\N	2019-12-10 08:09:16	2022-12-01 10:22:54	\N	2020-03-07 18:38:14
87fd5fac-5397-4689-8103-bf920f996619	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	91317e32-9ec9-468c-bf5b-ef891856d180	87fd5fac-5397-4689-8103-bf920f996619	\N	2019-12-10 08:09:15	2022-12-01 10:22:54	\N	2020-03-07 18:38:14
c898bd9c-372b-48ab-917b-354aebd31af4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	99f38034-4a28-11e5-a3b9-ff498a91b449	c898bd9c-372b-48ab-917b-354aebd31af4	\N	2019-12-10 08:09:15	2022-12-01 10:22:58	\N	2020-03-07 18:38:14
b035a31a-10b7-403e-92e9-8501c8917418	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	1f87026c-1601-4eb9-9b82-64289bded8ed	b035a31a-10b7-403e-92e9-8501c8917418	\N	2019-12-10 08:09:14	2022-12-01 10:23:00	\N	2020-03-07 18:38:21
74212562-1f01-405f-8ee3-173fc1d864e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	021d11bc-3d8a-11e5-b1d1-733403640dea	74212562-1f01-405f-8ee3-173fc1d864e6	\N	2019-12-06 17:32:36	2022-12-01 10:23:05	\N	2020-03-07 18:38:37
b429b51e-c7d4-4448-ab46-c4519da07ebd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	ff732935-72e5-4865-bb47-f3e0cb79d9fa	b429b51e-c7d4-4448-ab46-c4519da07ebd	\N	2019-12-10 08:09:15	2022-12-01 10:23:12	\N	2020-03-07 18:38:14
b0d6170d-eec1-4c08-81cf-403c13eb5408	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	60c2ff20-4b6c-11e5-958c-b39420b5676f	b0d6170d-eec1-4c08-81cf-403c13eb5408	\N	2019-12-10 08:09:15	2022-12-01 10:23:13	\N	2020-03-07 18:38:14
59204837-aeac-4191-ae63-9756ff4441b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	59204837-aeac-4191-ae63-9756ff4441b6	\N	2019-12-10 08:09:16	2022-12-01 10:23:19	\N	2020-03-07 18:38:14
8c8817e9-9c9a-4fd2-838a-5e07f93c313f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	162955a4-43dc-4ee3-85f2-b4b602c72400	8c8817e9-9c9a-4fd2-838a-5e07f93c313f	\N	2019-12-10 08:09:16	2022-12-01 10:23:22	\N	2020-03-07 18:38:14
79ee56fe-2ae8-45d3-98f1-7d1dfdb1f3c5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	1e7fd8fe-32a4-11e4-93e2-37acba0a524b	79ee56fe-2ae8-45d3-98f1-7d1dfdb1f3c5	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
536a40d7-c594-4797-bf7f-f107c6e6ba0c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	5ee4821c-2464-11e4-a5ad-37bc93bcd4a8	536a40d7-c594-4797-bf7f-f107c6e6ba0c	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
049ea93c-b52d-4a2b-aad1-a0e688246280	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	e4f8c01a-32b1-11e4-a542-3b19b496e9f6	049ea93c-b52d-4a2b-aad1-a0e688246280	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
5bbdf2cc-b5bc-4ebb-a524-5424a41aa224	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	80ef53a3-a816-e211-8a2a-3b22110807e2	5bbdf2cc-b5bc-4ebb-a524-5424a41aa224	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b00a5f85-c657-4bf7-9f24-083151c838de	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	f40ab798-954a-11e3-ae0e-3bb00d50bd20	b00a5f85-c657-4bf7-9f24-083151c838de	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
fa046002-4a78-4fa9-ae6c-c4b008e0be57	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	09cf4984-5510-11e3-8e62-4327aca13af0	fa046002-4a78-4fa9-ae6c-c4b008e0be57	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
8b4477e9-24e2-49d5-ac59-bfe7ad954e27	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	1c59072c-3f83-11e3-b6d6-43376463112d	8b4477e9-24e2-49d5-ac59-bfe7ad954e27	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
825ed82c-ee6c-4216-9b6c-017055f5a64e	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	6e778374-4ff2-11e3-8078-43b77f6458aa	825ed82c-ee6c-4216-9b6c-017055f5a64e	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
696db7cb-ba95-4a2f-a88e-1cb4cbfa4302	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	1e1536ae-2a05-11e4-b47d-43c30bca96ab	696db7cb-ba95-4a2f-a88e-1cb4cbfa4302	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
382021f9-eedf-4d2d-844f-9fe23951fe4f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	0be1aad4-9307-11e3-8e08-4707f5a31050	382021f9-eedf-4d2d-844f-9fe23951fe4f	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
4796931e-de98-43e3-89a2-5e827902f91a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	d462b1dc-2b56-11e4-bee9-473ff7c22c3c	4796931e-de98-43e3-89a2-5e827902f91a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
43700d79-b1ec-496a-a08a-50a4fc536926	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	669b79aa-3f8d-11e3-b47f-4745472945bf	43700d79-b1ec-496a-a08a-50a4fc536926	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
d8251e96-a989-4748-a5bd-9df62b548d6d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	b0fc8036-3f9f-11e3-b9c6-477550ac3ed6	d8251e96-a989-4748-a5bd-9df62b548d6d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
05ba9306-6d65-4f1b-bf13-ceab4c4ba538	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	7f7f95e6-954b-11e3-845b-479790cbcdb6	05ba9306-6d65-4f1b-bf13-ceab4c4ba538	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
4bfad136-65d1-4df9-b651-790a885dd9ce	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	fa5bace4-5515-11e3-b820-4b27437283c2	4bfad136-65d1-4df9-b651-790a885dd9ce	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
1cb5a212-17ef-48b2-99a4-d4f0202fdc87	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	3e42926c-5514-11e3-a5a5-4b6d95091f86	1cb5a212-17ef-48b2-99a4-d4f0202fdc87	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
c90af615-aae7-4956-a637-1061b99a1753	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	d7ec2960-5513-11e3-bfa4-4bc8cb1757f5	c90af615-aae7-4956-a637-1061b99a1753	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
4a37d7ea-e649-4422-bf38-004ed57cf630	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	1458c97e-2612-11e4-8c0f-4f47e0f0e9c6	4a37d7ea-e649-4422-bf38-004ed57cf630	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
c6b8800a-3812-45a7-b1ca-814563995f62	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	d71d5ea6-954a-11e3-abe7-537b013fa85b	c6b8800a-3812-45a7-b1ca-814563995f62	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
0739e505-23e8-455a-9649-d1ee0299d21f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	bb9c5c8c-4c0b-11e3-b2b0-53e2f48711f8	0739e505-23e8-455a-9649-d1ee0299d21f	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
fbb1b3a6-f3bc-4002-867a-854085e17834	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	3b2a460a-3f9e-11e3-b5f5-53ee31f50a21	fbb1b3a6-f3bc-4002-867a-854085e17834	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
d1edcafd-fb8c-4e0b-8fa1-a1ef8d644b96	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	924a52f6-954b-11e3-8033-53fca57667b4	d1edcafd-fb8c-4e0b-8fa1-a1ef8d644b96	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a91d80c8-0e49-4324-b3bb-bf9a14185459	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	5d8a9086-2b6d-11e4-9d64-571b32c2e1b0	a91d80c8-0e49-4324-b3bb-bf9a14185459	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a7de24b7-6abc-497a-94cf-bd9d8284b743	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	ea125014-2b6f-11e4-9d54-5b49fa0fe74e	a7de24b7-6abc-497a-94cf-bd9d8284b743	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
7b5c9597-ce8f-40ed-862f-477454cd53c7	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	ed420e54-3f85-11e3-85f9-5b69a5f709c0	7b5c9597-ce8f-40ed-862f-477454cd53c7	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
ecb777fb-0a31-44f4-a6b7-974637b6632a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	329fef4e-2486-11e4-87bf-5baf91c951d9	ecb777fb-0a31-44f4-a6b7-974637b6632a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
11008e63-7c83-4545-aa91-a41858e1016d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	cb338c3e-9656-11e3-9d28-5bb7fd0fc285	11008e63-7c83-4545-aa91-a41858e1016d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
1d9bcd0d-cd89-4a90-b4c8-f0446dc7c555	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	51bb9618-2f2a-11e4-bb80-5f126acd0ffd	1d9bcd0d-cd89-4a90-b4c8-f0446dc7c555	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
b5bf4ffa-70df-4e91-8733-31c67e142fb0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	2d486520-7816-11e3-9a2e-5fbff0a4bb77	b5bf4ffa-70df-4e91-8733-31c67e142fb0	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
f9c6bc98-9cdd-4d6f-9f09-990980ea2e0e	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	55346ce2-3570-11e4-827b-636efd003ab9	f9c6bc98-9cdd-4d6f-9f09-990980ea2e0e	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
0a4ba912-2ee4-41a3-9b12-f33f6b545db1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	9fbc0b4a-5519-11e3-91c5-63e4a5abb64e	0a4ba912-2ee4-41a3-9b12-f33f6b545db1	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
cf023805-1c56-4593-b7dd-bd2c2362745d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	d176f452-4a82-11e3-8e32-63e611a0e8ac	cf023805-1c56-4593-b7dd-bd2c2362745d	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
6fd1fa94-0bf3-4cbd-91d0-1ae4c4c89622	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	8f95ea68-8707-11e3-9b8f-675043d89547	6fd1fa94-0bf3-4cbd-91d0-1ae4c4c89622	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
84365993-32c0-4f86-bc72-c069258492d1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	4e13a522-3f17-11e3-a0e3-676163fbedc1	84365993-32c0-4f86-bc72-c069258492d1	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
c3ae5807-0dd6-4b41-8c7c-7498b5d4231a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	5c0c54c8-350f-11e4-92cb-676f31e5ba82	c3ae5807-0dd6-4b41-8c7c-7498b5d4231a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
ac3364a2-54b5-47f6-b380-22dba3ea1d18	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	040fb91c-550f-11e3-9e79-6b70ab493af4	ac3364a2-54b5-47f6-b380-22dba3ea1d18	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
0d7343ab-744e-48a0-8602-a6efc2b5927b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	62c4a3d2-410f-11e3-b212-6b70ddfb3165	0d7343ab-744e-48a0-8602-a6efc2b5927b	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
f9bda587-0bcf-4fed-a389-3d5e1aaf7f31	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	129f510a-2538-11e4-bebe-6b8da78a49d5	f9bda587-0bcf-4fed-a389-3d5e1aaf7f31	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
d01b5c0e-ea72-4408-9694-3686db9adab7	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	40d22ed8-07e7-e111-b862-6b8ebd1bf04b	d01b5c0e-ea72-4408-9694-3686db9adab7	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
50989ea9-6800-41ff-a384-6bdf5185fc94	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	05bc40d0-0de7-e111-b862-6b8ebd1bf04b	50989ea9-6800-41ff-a384-6bdf5185fc94	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
2481efb5-91c7-444d-a52a-cc4ffc466e49	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	d3c65c5e-9652-11e3-b54b-6be8efff19ba	2481efb5-91c7-444d-a52a-cc4ffc466e49	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
970d8d16-37cd-4784-975e-3f4e621b9a21	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	be186d6f-8458-bd11-b4e6-6bfc6b8ae9e7	970d8d16-37cd-4784-975e-3f4e621b9a21	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
dfa39c74-fbcb-48ec-b9f2-7c7adbffcc62	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	afa7f1d0-6ce6-e111-8273-6d956bf74235	dfa39c74-fbcb-48ec-b9f2-7c7adbffcc62	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
6dd87627-e8f5-4700-859a-ede51c04edbe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	0fe246e8-04b1-40fc-a6ce-aa23445ab6c4	\N	2019-12-11 13:50:35	2019-12-18 18:47:25	2019-12-18 18:47:25	2019-12-11 22:37:10
e1474f9a-b4c2-4c6d-90cd-3d597759e86c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	c60e92a2-99c2-4394-a48b-251540c8b96f	e1474f9a-b4c2-4c6d-90cd-3d597759e86c	\N	2020-02-17 14:00:48	2022-12-01 10:22:53	\N	2020-06-17 19:43:08
19d62621-0648-45ec-8ea5-ab784efae7c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	54976902-8866-4627-a970-0abcb6abb6f9	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	2019-12-19 08:08:24	2022-12-01 10:22:54	\N	2019-12-19 08:08:24
7a7b1158-34fe-4eb0-9664-e6cefd5ccc88	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	9e8380ef-47fb-4968-add6-6aaebdebb939	7a7b1158-34fe-4eb0-9664-e6cefd5ccc88	\N	2020-02-17 14:00:48	2022-12-01 10:22:54	\N	2020-06-17 19:43:08
7b188169-3f39-40dc-82bf-9cb2201edd4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	9c4c0c10-b8da-414e-8da3-ea55711fb000	7b188169-3f39-40dc-82bf-9cb2201edd4d	\N	2020-02-17 14:00:48	2022-12-01 10:22:57	\N	2020-06-17 19:43:08
04901207-48a8-4d9a-8369-2b21b6740b54	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	021d11bc-3d8a-11e5-b1d1-733403640dea	04901207-48a8-4d9a-8369-2b21b6740b54	\N	2020-02-17 14:00:48	2022-12-01 10:22:58	\N	2020-06-17 19:43:08
c6c985e7-0051-4994-bbf0-4a269cb3cabb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	c6c985e7-0051-4994-bbf0-4a269cb3cabb	\N	2019-12-19 08:08:38	2022-12-01 10:22:58	\N	2020-03-07 18:38:14
4f6249e5-4f74-41f6-8282-0601513c4909	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	0494c011-fd20-411c-b6f3-022d10cfb1b4	4f6249e5-4f74-41f6-8282-0601513c4909	\N	2020-02-17 14:00:48	2022-12-01 10:23:00	\N	2020-06-17 19:43:08
b249e428-28f4-4835-ad5f-9eeb42b731ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	4667c5f3-944d-4a83-9694-fea9cd76f848	6402418c-54f9-11e5-9e54-5397b782050d	b249e428-28f4-4835-ad5f-9eeb42b731ac	\N	2019-12-10 08:09:14	2022-12-01 10:23:01	\N	2020-03-07 18:38:23
d97c149d-f149-4d0c-9eae-b879134b8016	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	097f5676-e6b8-4033-9b17-43eb6a4145bf	d97c149d-f149-4d0c-9eae-b879134b8016	\N	2020-02-17 14:00:48	2022-12-01 10:23:01	\N	2020-06-17 19:43:08
2a0c299b-fdbf-49be-948a-39162be1c8d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	a6fed8b4-950c-4621-9932-ba8a45b84935	2a0c299b-fdbf-49be-948a-39162be1c8d8	\N	2019-12-06 16:14:40	2022-12-01 10:23:07	\N	2020-03-07 18:38:31
3f1de059-08bc-4292-b909-458cb9006939	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	ad705d8a-429e-11e5-a989-af44a02d940a	3f1de059-08bc-4292-b909-458cb9006939	\N	2020-02-17 14:00:48	2022-12-01 10:23:08	\N	2020-06-17 19:43:08
efa343b4-969e-4162-919a-b892722f675c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	efa343b4-969e-4162-919a-b892722f675c	\N	2019-12-19 08:08:38	2022-12-01 10:23:10	\N	2020-03-07 18:38:14
a6a5f91a-9ae7-4a82-abd7-ca9fea646e8e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	079a34b8-4b76-11e5-814d-b3ab2368e254	a6a5f91a-9ae7-4a82-abd7-ca9fea646e8e	\N	2020-02-17 14:00:48	2022-12-01 10:23:11	\N	2020-06-17 19:43:08
b4a5b786-0c4c-47cd-adc4-02183ee94201	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	c7a20e10-51e9-11e5-9503-af6d1e3f4589	b4a5b786-0c4c-47cd-adc4-02183ee94201	\N	2019-12-06 17:32:35	2022-12-01 10:23:12	\N	2020-03-07 18:38:37
19988e51-bc33-489b-9391-ff35627a49a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	2c1847a5-ae44-40e2-836e-cc566e0ed984	19988e51-bc33-489b-9391-ff35627a49a2	\N	2019-12-10 08:09:15	2022-12-01 10:23:12	\N	2020-03-07 18:38:14
fbfe391b-796a-4238-a522-3bd80b3d3e0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	fbfe391b-796a-4238-a522-3bd80b3d3e0a	\N	2019-12-19 08:08:39	2022-12-01 10:23:13	\N	2020-03-07 18:38:37
fae93b31-eee5-4616-9e02-0b42925f8d74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	b35c01a3-37d8-4b9c-921d-65a382a1ca70	fae93b31-eee5-4616-9e02-0b42925f8d74	\N	2019-12-10 08:09:13	2022-12-01 10:23:13	\N	2020-03-07 18:38:14
b6eb0005-2846-4217-a095-6934e336b7da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	b6eb0005-2846-4217-a095-6934e336b7da	\N	2019-12-19 08:08:40	2022-12-01 10:23:13	\N	2020-03-07 18:38:38
8bad7206-24fd-4da4-b5f3-b1b9d1878cc3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	7dbbb577-7b93-48ef-b139-db84e9163597	8bad7206-24fd-4da4-b5f3-b1b9d1878cc3	\N	2019-12-10 08:09:16	2022-12-01 10:23:16	\N	2020-03-07 18:38:14
1886d81b-ba50-4ce9-9694-12fc5c63170b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	7661d6a5-1907-41fd-8c82-a5fea385fef8	1886d81b-ba50-4ce9-9694-12fc5c63170b	\N	2019-12-19 08:08:25	2022-12-01 10:23:17	\N	2019-12-19 08:08:25
960ca305-7fde-4708-8721-9dde6dccade0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	3b0bdfc7-2566-4278-9da7-872654bfac5b	52d5486a-4544-11e5-b3ea-131ef06916b5	960ca305-7fde-4708-8721-9dde6dccade0	\N	2019-12-19 08:08:39	2022-12-01 10:23:24	\N	2020-03-07 18:38:38
68b77682-9adf-4000-b96c-770b5a5f036f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	079a34b8-4b76-11e5-814d-b3ab2368e254	68b77682-9adf-4000-b96c-770b5a5f036f	\N	2019-12-06 16:14:30	2022-12-01 10:23:24	\N	2020-03-07 18:38:31
cf3b8a76-692a-444e-985a-2c1139b2ffbc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	cae987c8-810a-4d95-a5fb-27e3108961de	cf3b8a76-692a-444e-985a-2c1139b2ffbc	\N	2020-02-17 14:00:48	2022-12-01 10:23:25	\N	2020-06-17 19:43:08
273097f8-b4d4-47d7-9fbe-769e342eaafa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	74b1c647-0142-4355-a2af-d5a15f1d2358	273097f8-b4d4-47d7-9fbe-769e342eaafa	\N	2020-02-17 14:00:48	2022-12-01 10:23:25	\N	2020-06-17 19:43:08
33888ba1-713f-446b-91ef-c23cc401df70	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	11aea642-466b-11e5-886c-1b8856809555	33888ba1-713f-446b-91ef-c23cc401df70	\N	2019-12-06 16:14:40	2022-12-01 10:23:29	\N	2020-03-07 18:38:32
b5d73526-1dd7-46bb-b7e0-69b47295c2a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	ad705d8a-429e-11e5-a989-af44a02d940a	b5d73526-1dd7-46bb-b7e0-69b47295c2a6	\N	2019-12-10 08:09:13	2022-12-01 10:23:29	\N	2020-03-07 18:38:14
abecc36f-0b40-4d02-ac46-7ecf8b360976	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	1f6639a7-562e-44f9-b1c8-a98935a9193c	abecc36f-0b40-4d02-ac46-7ecf8b360976	\N	2020-02-17 14:00:48	2022-12-01 10:23:29	\N	2020-06-17 19:43:08
dfe0ccb0-69b6-449e-b0db-8f03d08d6e93	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	68d0ff9c-25ec-11e4-bb32-738daa60e9ea	dfe0ccb0-69b6-449e-b0db-8f03d08d6e93	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
a64e8ef1-f39b-43de-ba5d-82c16c3902fe	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	c0e32918-5454-11e3-b36e-73a9536527bf	a64e8ef1-f39b-43de-ba5d-82c16c3902fe	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
0f073890-cf0e-4ccd-8581-09489fad3c72	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	9afe16ce-3381-11e4-94bb-779eeea0fd08	0f073890-cf0e-4ccd-8581-09489fad3c72	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
671d2cbf-facf-4ee6-81bb-326af782b3f0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	f720ced2-dcec-e111-9b19-7d37f0a6d50b	671d2cbf-facf-4ee6-81bb-326af782b3f0	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
450c7e7c-40f2-4871-87e5-4eaaa93ad00a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	a9f3b9da-deec-e111-9b19-7d37f0a6d50b	450c7e7c-40f2-4871-87e5-4eaaa93ad00a	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
66fdab0e-e9d2-4eef-b836-38f38454fe6b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	9bb14ed9-e3ec-e111-9b19-7d37f0a6d50b	66fdab0e-e9d2-4eef-b836-38f38454fe6b	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
390ab30b-7f49-4c22-8b35-6def083c119f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	e47236ed-e5ec-e111-9b19-7d37f0a6d50b	390ab30b-7f49-4c22-8b35-6def083c119f	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
748c4f9d-a34f-494f-85e2-ed4c00bc4805	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	6c0b25f6-eeec-e111-9b19-7d37f0a6d50b	748c4f9d-a34f-494f-85e2-ed4c00bc4805	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
86c399d2-05c3-4c64-9378-6f2fd4fdadc3	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	b63538d6-12e3-e111-956e-7d70f21de5e1	86c399d2-05c3-4c64-9378-6f2fd4fdadc3	\N	2023-09-19 12:19:51	2023-09-19 12:19:51	\N	2023-08-20 12:19:51
9c034e29-5184-4afe-8c32-c89b400bc664	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	aefa7014-7df1-11e3-b0c5-7f0e6bc9f6f8	9c034e29-5184-4afe-8c32-c89b400bc664	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d961a15f-671f-464d-8e8e-58d2c12b02a6	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	48982004-b191-487d-88de-816c20909509	d961a15f-671f-464d-8e8e-58d2c12b02a6	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
5cb2dbe9-f5b6-4474-b8fa-a988e89b4f8a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	a231079c-ca66-4f30-ad22-81f6226e6687	5cb2dbe9-f5b6-4474-b8fa-a988e89b4f8a	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
6d83ea43-4b01-4199-bdc4-550c24d927d8	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	9ec0ac4e-2612-11e4-aeea-83aefaf65bf4	6d83ea43-4b01-4199-bdc4-550c24d927d8	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1b19496d-941a-4c7a-9599-b23e730e46c8	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	67478865-f787-4b02-a5d3-88f6e7e17d53	1b19496d-941a-4c7a-9599-b23e730e46c8	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
85676983-2409-4023-9720-d149ca011734	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	625f5a62-03e6-4066-8186-2fd7a0189797	84c1e5f8-b31b-4e55-b069-72e3e9d06ccc	\N	2020-02-17 14:00:48	2022-04-05 06:43:18	2022-04-05 06:43:18	2020-06-17 19:43:08
4624b566-6341-4e71-bcc8-8d1d18a27580	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	e8ef366f-330c-4326-9272-e1e341cf8d58	82a96812-204b-40c7-ba1b-9df405e70465	7ff0a433-25db-4d32-8bfb-64ffad30c8ab	\N	2019-12-19 08:08:23	2020-03-14 16:46:10	2020-03-14 16:46:10	2019-12-19 08:08:23
ecd729e4-49b2-4efd-bba2-d6955c6457f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	82a96812-204b-40c7-ba1b-9df405e70465	60d9edad-5cf5-4531-b57c-1d5d158b990c	\N	2020-02-17 14:00:48	2020-03-14 16:46:10	2020-03-14 16:46:10	2020-03-06 22:00:48
0e8447d8-5434-40f2-8a1f-aba3e826db00	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	0fe246e8-04b1-40fc-a6ce-aa23445ab6c4	\N	2019-12-11 09:46:45	2019-12-11 10:04:08	2019-12-11 10:04:08	2019-12-11 09:46:45
f5cd5f5e-fec9-4fc4-9a01-211aafa2ddc5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	7661d6a5-1907-41fd-8c82-a5fea385fef8	1886d81b-ba50-4ce9-9694-12fc5c63170b	\N	2019-12-11 09:46:45	2019-12-18 18:47:33	2019-12-18 18:47:33	2019-12-11 22:37:10
07ae4ed8-b62b-4238-9c0a-a6cdaae961b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	37574861-bbb9-409c-bdfd-38c4f3048653	\N	2019-12-11 09:46:45	2019-12-18 18:47:41	2019-12-18 18:47:41	2019-12-11 22:37:10
74c7c8d9-a0e1-4590-a2d5-e7b4176964e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	54976902-8866-4627-a970-0abcb6abb6f9	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	2019-12-11 22:36:08	2019-12-18 18:47:45	2019-12-18 18:47:45	2019-12-11 22:37:09
69e090cb-ff98-4208-859a-d91dd70da8e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	54976902-8866-4627-a970-0abcb6abb6f9	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	2019-12-11 09:46:45	2019-12-11 10:00:52	2019-12-11 10:00:52	2019-12-11 09:46:45
852cd2ec-5ca1-4e20-84df-251f337ed79e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	43c4dd03-c277-4fca-ad46-efe58db83b89	54976902-8866-4627-a970-0abcb6abb6f9	19d62621-0648-45ec-8ea5-ab784efae7c6	\N	2019-12-11 13:50:34	2019-12-11 22:35:11	2019-12-11 22:35:11	2019-12-11 14:28:03
06d24d5f-26e4-42cd-a7f9-083e589328e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	699a87cc-dd67-47fc-98f8-8b8f641c1fa6	52d5486a-4544-11e5-b3ea-131ef06916b5	06d24d5f-26e4-42cd-a7f9-083e589328e8	\N	2019-12-19 08:08:38	2022-12-01 10:22:51	\N	2020-03-07 18:38:14
522a777f-d780-48d6-801e-c1db11608e5c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20191	486f47de-dd56-4d02-9edc-6962a4062ed2	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	522a777f-d780-48d6-801e-c1db11608e5c	\N	2019-12-06 16:14:40	2022-12-01 10:22:51	\N	2020-03-07 18:38:33
53b37163-6a2c-41f5-8e89-a026c32f9de7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	53b37163-6a2c-41f5-8e89-a026c32f9de7	\N	2020-02-17 14:00:48	2022-12-01 10:22:53	\N	2020-06-17 19:43:08
4c5f269a-5e8e-4f83-a01b-fd951637d49b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	c593fef2-46d2-11e5-b14e-8fa23f386b5a	4c5f269a-5e8e-4f83-a01b-fd951637d49b	\N	2020-02-17 14:00:48	2022-12-01 10:22:56	\N	2020-06-17 19:43:08
a7ec28e9-fd33-4905-b767-d09eb49cc310	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	a7ec28e9-fd33-4905-b767-d09eb49cc310	\N	2020-02-17 14:00:48	2022-12-01 10:22:56	\N	2020-06-17 19:43:08
722ec605-0099-470d-b4e4-89369ec70af2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	91317e32-9ec9-468c-bf5b-ef891856d180	722ec605-0099-470d-b4e4-89369ec70af2	\N	2020-02-17 14:00:49	2022-12-01 10:22:56	\N	2020-06-17 19:43:09
c08f5c4b-01ae-48d8-abb3-e68e65b5cec2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	60c2ff20-4b6c-11e5-958c-b39420b5676f	c08f5c4b-01ae-48d8-abb3-e68e65b5cec2	\N	2020-02-17 14:00:48	2022-12-01 10:22:57	\N	2020-06-17 19:43:08
f741f5e8-2213-4608-8aaa-1e96b5a7b203	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	d993ad11-d98a-4803-85a4-a446d7b9d4c7	f741f5e8-2213-4608-8aaa-1e96b5a7b203	\N	2020-02-17 14:00:49	2022-12-01 10:22:58	\N	2020-06-17 19:43:09
2984c342-131b-4bdc-a5ab-3e2cf3cea9a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	2984c342-131b-4bdc-a5ab-3e2cf3cea9a0	\N	2020-02-17 14:00:49	2022-12-01 10:22:58	\N	2020-06-17 19:43:09
f9178927-0d05-47e4-99a2-63ef19128cb0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	81ed9f12-dc17-4947-aeaa-5105be4af095	f9178927-0d05-47e4-99a2-63ef19128cb0	\N	2020-02-17 14:00:48	2022-12-01 10:22:59	\N	2020-06-17 19:43:08
fd99938b-7e9a-4bfb-bd5a-e3c8607dde80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	906376c2-1463-4361-897e-a7ef5a19239d	fd99938b-7e9a-4bfb-bd5a-e3c8607dde80	\N	2020-02-17 14:00:49	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
81da7909-3588-4b45-95e9-3625c1de28bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	81da7909-3588-4b45-95e9-3625c1de28bf	\N	2020-02-17 14:00:49	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
6d07a868-4bb0-491f-8804-f451924e5aa3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	6d07a868-4bb0-491f-8804-f451924e5aa3	\N	2020-02-17 14:00:49	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
2c58cebe-8304-4ae5-b656-947bde27822d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	c8ee9713-6348-4525-ac7a-27b373d312df	2c58cebe-8304-4ae5-b656-947bde27822d	\N	2020-02-17 14:00:49	2022-12-01 10:23:01	\N	2020-06-17 19:43:09
c40086cb-50a8-4900-9651-23be2465b7d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	26925a68-aab1-11e5-bde5-bb0a0689b68c	c40086cb-50a8-4900-9651-23be2465b7d5	\N	2020-02-17 14:00:48	2022-12-01 10:23:02	\N	2020-06-17 19:43:08
fdd1a684-ff3c-431f-aaa7-5dc82e378027	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	f59b1bb2-1e58-4760-b504-5ee5de14aba7	fdd1a684-ff3c-431f-aaa7-5dc82e378027	\N	2020-02-17 14:00:49	2022-12-01 10:23:02	\N	2020-06-17 19:43:09
eb0f1741-4db9-4c4e-be3f-8a57cfdc9a88	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	f9496132-3b0c-11e5-a92d-b7a7850016b8	eb0f1741-4db9-4c4e-be3f-8a57cfdc9a88	\N	2020-02-17 14:00:49	2022-12-01 10:23:04	\N	2020-06-17 19:43:09
f012a6a8-f107-4b72-b03b-273d8009943a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	607b1b72-46d2-11e5-ba50-1375139e8458	f012a6a8-f107-4b72-b03b-273d8009943a	\N	2020-02-17 14:00:49	2022-12-01 10:23:04	\N	2020-06-17 19:43:09
61a6e8d7-0b58-4311-986a-c981eab451dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	e131badd-15c9-4911-8c81-1d30249b7d73	61a6e8d7-0b58-4311-986a-c981eab451dd	\N	2020-02-17 14:00:49	2022-12-01 10:23:04	\N	2020-06-17 19:43:09
232e202f-e7ad-495a-9b7c-d53c10a3b208	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	a6fed8b4-950c-4621-9932-ba8a45b84935	232e202f-e7ad-495a-9b7c-d53c10a3b208	\N	2020-02-17 14:00:48	2022-12-01 10:23:05	\N	2020-06-17 19:43:08
dd7af1af-a9aa-4756-bb84-6dd35853d854	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	54894cf6-ecf9-44c5-87e8-b87e6bf62120	dd7af1af-a9aa-4756-bb84-6dd35853d854	\N	2020-02-17 14:00:49	2022-12-01 10:23:06	\N	2020-06-17 19:43:09
8bf99333-bf50-4034-b4c7-b7c15f78d883	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	5ae837e8-4a02-11e5-9a00-2bca72a8469e	8bf99333-bf50-4034-b4c7-b7c15f78d883	\N	2020-02-17 14:00:49	2022-12-01 10:23:07	\N	2020-06-17 19:43:09
91f87ffd-a2cc-451a-92dd-32a66c89d3ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	91f87ffd-a2cc-451a-92dd-32a66c89d3ae	\N	2020-02-17 14:00:49	2022-12-01 10:23:07	\N	2020-06-17 19:43:09
907d3257-c2a4-4acd-bcd6-460a33b2837e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	907d3257-c2a4-4acd-bcd6-460a33b2837e	\N	2020-02-17 14:00:49	2022-12-01 10:23:08	\N	2020-06-17 19:43:09
31a3e533-cb6e-4660-a084-0dae7fb8c10a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	31a3e533-cb6e-4660-a084-0dae7fb8c10a	\N	2020-02-17 14:00:48	2022-12-01 10:23:10	\N	2020-06-17 19:43:08
994db613-5c11-49b9-a412-49beeb04c494	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	7363a404-46e9-11e5-8413-7fabf05ee1fd	994db613-5c11-49b9-a412-49beeb04c494	\N	2020-02-17 14:00:48	2022-12-01 10:23:10	\N	2020-06-17 19:43:08
417ffaa0-bb3c-4ea7-87f7-8d2d2e946be0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	ff732935-72e5-4865-bb47-f3e0cb79d9fa	417ffaa0-bb3c-4ea7-87f7-8d2d2e946be0	\N	2020-02-17 14:00:49	2022-12-01 10:23:11	\N	2020-06-17 19:43:09
e4a93761-c59e-46a4-bf9a-dc9b77935bf1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	b35c01a3-37d8-4b9c-921d-65a382a1ca70	e4a93761-c59e-46a4-bf9a-dc9b77935bf1	\N	2020-02-17 14:00:49	2022-12-01 10:23:12	\N	2020-06-17 19:43:09
5b692b2e-2f9a-4d6c-9999-655ff111a322	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	26daca7f-056a-4e55-a49a-4469004944ec	5b692b2e-2f9a-4d6c-9999-655ff111a322	\N	2020-02-17 14:00:48	2022-12-01 10:23:12	\N	2020-06-17 19:43:08
e776c4cd-1ae7-482c-a0b1-43704a1ee271	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	8a5395ea-c758-4eb7-b436-571f527789a2	e776c4cd-1ae7-482c-a0b1-43704a1ee271	\N	2020-02-17 14:00:49	2022-12-01 10:23:13	\N	2020-06-17 19:43:09
a0990a00-ca01-4838-9b85-d2713f90223b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	4dbcf03d-8516-4f9c-a25f-679ac14e766f	a0990a00-ca01-4838-9b85-d2713f90223b	\N	2020-02-17 14:00:49	2022-12-01 10:23:16	\N	2020-06-17 19:43:09
bdbe7153-335e-474f-bb5e-a0a4c8bbb141	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	bdbe7153-335e-474f-bb5e-a0a4c8bbb141	\N	2020-02-17 14:00:48	2022-12-01 10:23:16	\N	2020-06-17 19:43:08
b420a210-57fb-44b7-b72c-91ee239ec8bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	52d5486a-4544-11e5-b3ea-131ef06916b5	b420a210-57fb-44b7-b72c-91ee239ec8bc	\N	2020-02-17 14:00:49	2022-12-01 10:23:16	\N	2020-06-17 19:43:09
4f05515a-36ea-4572-a146-80c8d96b1420	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	4f05515a-36ea-4572-a146-80c8d96b1420	\N	2020-02-17 14:00:48	2022-12-01 10:23:16	\N	2020-06-17 19:43:08
1170755c-e0ab-49fc-8002-32f56128b062	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	1170755c-e0ab-49fc-8002-32f56128b062	\N	2020-02-17 14:00:49	2022-12-01 10:23:17	\N	2020-06-17 19:43:09
a0ef06ea-af35-4c9a-9896-541026a115d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	a83c363b-c56d-49b3-9d37-61d51488daab	a0ef06ea-af35-4c9a-9896-541026a115d7	\N	2020-02-17 14:00:49	2022-12-01 10:23:17	\N	2020-06-17 19:43:09
7a07d871-c4e6-436a-8fde-9a484d151340	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	7a07d871-c4e6-436a-8fde-9a484d151340	\N	2020-02-17 14:00:48	2022-12-01 10:23:21	\N	2020-06-17 19:43:09
bff9e421-bc3c-4b1a-b87b-56b5b2f5f48b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	fa092490-4b74-11e5-a33d-db9868dda03f	bff9e421-bc3c-4b1a-b87b-56b5b2f5f48b	\N	2020-02-17 14:00:49	2022-12-01 10:23:22	\N	2020-06-17 19:43:09
41b80e27-84a1-4491-bdd1-3f6ceb4eabb9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	9b057256-628e-4516-a951-a78bd3651d4b	41b80e27-84a1-4491-bdd1-3f6ceb4eabb9	\N	2020-02-17 14:00:48	2022-12-01 10:23:22	\N	2020-06-17 19:43:08
47d88237-af7d-4238-bb79-27f027d498af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	47d88237-af7d-4238-bb79-27f027d498af	\N	2020-02-17 14:00:48	2022-12-01 10:23:23	\N	2020-06-17 19:43:08
d29890eb-33c4-4757-9d1a-0e451871ecab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	3ee043f8-9893-11e5-911a-5f12b6406080	d29890eb-33c4-4757-9d1a-0e451871ecab	\N	2020-02-17 14:00:49	2022-12-01 10:23:24	\N	2020-06-17 19:43:09
754e8589-5363-4c30-9872-a69e85e3c7c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	754e8589-5363-4c30-9872-a69e85e3c7c5	\N	2020-02-17 14:00:48	2022-12-01 10:23:25	\N	2020-06-17 19:43:08
3df74f4e-536d-4f37-b3e6-4ea029ad78c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	cc30617c-14a9-478b-83d4-b0e836aa69c0	3df74f4e-536d-4f37-b3e6-4ea029ad78c3	\N	2020-02-17 14:00:48	2022-12-01 10:23:25	\N	2020-06-17 19:43:08
4ac29f6c-2123-42ac-b4f4-5d11e6570546	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	9833a660-4b73-11e5-934e-37a2f6ed830d	4ac29f6c-2123-42ac-b4f4-5d11e6570546	\N	2020-02-17 14:00:49	2022-12-01 10:23:26	\N	2020-06-17 19:43:09
32017c89-d2e8-4a25-979f-bd58d325d0e0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	3bbd9968-551b-11e3-9eca-8ba90fe27e0d	32017c89-d2e8-4a25-979f-bd58d325d0e0	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d2597207-d260-43f1-9c21-da70e3c5add3	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	c27d59ee-2f58-11e4-bca1-8bc1f528dc5f	d2597207-d260-43f1-9c21-da70e3c5add3	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
9c47a1d4-4655-4ede-9c2d-09b028a6ef2d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	b7544412-5518-11e3-9deb-8bc22f77c63d	9c47a1d4-4655-4ede-9c2d-09b028a6ef2d	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c7af74b2-a3a8-4f59-88dc-f02370b02fb9	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	9b153623-333e-4fe1-bda9-9020ecef6159	c7af74b2-a3a8-4f59-88dc-f02370b02fb9	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
4099a95e-6c3f-4c3d-be69-08984b4a20fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	ae5c71e9-252b-4467-8805-fadddbaf89c4	af62f7b1-2b33-44ce-b6bc-ebdbb37e9a32	\N	2020-02-17 14:00:49	2020-02-20 15:02:16	2020-02-20 15:02:16	2020-02-17 14:00:49
37a6204a-4e02-488c-9d88-b1f48e020e32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	72d18334-3b06-11e4-a3a4-13507c2a0677	6a9086a3-a24a-42de-a86a-93b4e7fb67f3	\N	2020-02-17 14:00:50	2020-04-22 11:57:49	2020-04-22 11:57:49	2020-03-06 22:00:51
c2fa021a-68e6-4c30-87e3-8c72485801cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	5b61121a-264f-490f-86b1-551372be86d1	c2fa021a-68e6-4c30-87e3-8c72485801cb	\N	2020-02-17 14:00:48	2022-12-01 10:22:48	\N	2020-06-17 19:43:08
39712b83-edaa-4e1f-9826-465f668f23bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	99f38034-4a28-11e5-a3b9-ff498a91b449	39712b83-edaa-4e1f-9826-465f668f23bf	\N	2020-02-17 14:00:48	2022-12-01 10:22:49	\N	2020-06-17 19:43:08
1a48ff81-25b2-4ff1-8aa5-d334a827fbe6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	1a48ff81-25b2-4ff1-8aa5-d334a827fbe6	\N	2020-02-17 14:00:49	2022-12-01 10:22:49	\N	2020-06-17 19:43:09
7725c916-6710-47d7-be78-ead58b45765d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	8e480efa-b4ae-4ecb-8b21-1ad77d82eb6d	7725c916-6710-47d7-be78-ead58b45765d	\N	2020-02-17 14:00:49	2022-12-01 10:22:52	\N	2020-06-17 19:43:09
1aded10b-e5f9-4e09-8350-d5d2ef424320	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	162955a4-43dc-4ee3-85f2-b4b602c72400	1aded10b-e5f9-4e09-8350-d5d2ef424320	\N	2020-02-17 14:00:49	2022-12-01 10:22:53	\N	2020-06-17 19:43:09
c638d6a7-6457-48b2-b371-eb49579848cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	f159319f-2b97-4744-95ff-edb8466a656f	c638d6a7-6457-48b2-b371-eb49579848cf	\N	2020-02-17 14:00:50	2022-12-01 10:22:53	\N	2020-06-17 19:43:10
89350a7e-47ce-45fb-b475-ae82b75bb387	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	4e3a22a4-98e9-4024-a519-7a05be9167c8	89350a7e-47ce-45fb-b475-ae82b75bb387	\N	2020-02-17 14:00:49	2022-12-01 10:22:56	\N	2020-06-17 19:43:09
fb554f48-59a0-4b1a-bf47-2488a936d01b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	52ae8172-5750-4387-badd-79b17d2081aa	fb554f48-59a0-4b1a-bf47-2488a936d01b	\N	2020-02-17 14:00:50	2022-12-01 10:22:57	\N	2020-06-17 19:43:10
8e0bfaa3-858c-4763-b69a-ee3fffab2421	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	bd4085a1-82ec-450b-9507-7924581dc0fc	8e0bfaa3-858c-4763-b69a-ee3fffab2421	\N	2020-02-17 14:00:50	2022-12-01 10:22:58	\N	2020-06-17 19:43:09
bd40027f-b5d3-4937-b1dd-09283b07e6e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	8b4ea31e-4aa0-427e-a65f-928b232d7f14	bd40027f-b5d3-4937-b1dd-09283b07e6e4	\N	2020-02-17 14:00:50	2022-12-01 10:23:00	\N	2020-06-17 19:43:10
ddf6414b-79c3-4772-8729-1c26f70cda96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	54976902-8866-4627-a970-0abcb6abb6f9	ddf6414b-79c3-4772-8729-1c26f70cda96	\N	2020-02-17 14:00:49	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
b7e0f007-6f12-446e-8f8a-b500ec02d595	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	540161f2-51dc-11e5-ada1-57cb00fd65d6	b7e0f007-6f12-446e-8f8a-b500ec02d595	\N	2020-02-17 14:00:49	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
282c7c49-ef14-4cd6-b1a0-fdd1ee0e8238	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	282c7c49-ef14-4cd6-b1a0-fdd1ee0e8238	\N	2020-02-17 14:00:50	2022-12-01 10:23:00	\N	2020-06-17 19:43:10
29877ca5-eb46-471a-8e90-638ad8179c95	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	a5f73eaf-350d-41c0-8c11-6cba998499e3	29877ca5-eb46-471a-8e90-638ad8179c95	\N	2020-02-17 14:00:50	2022-12-01 10:23:00	\N	2020-06-17 19:43:09
8326c098-8b6b-412b-8381-9cd7b62c8247	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	8326c098-8b6b-412b-8381-9cd7b62c8247	\N	2020-02-17 14:00:50	2022-12-01 10:23:00	\N	2020-06-17 19:43:10
d50ddede-66b9-4477-b9a6-513d9a1b9b80	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	994e91c4-854b-4fe0-946c-0133e4582398	d50ddede-66b9-4477-b9a6-513d9a1b9b80	\N	2020-02-17 14:00:49	2022-12-01 10:23:04	\N	2020-06-17 19:43:09
5bddf49d-93d4-4f2d-b41f-09b92bfd674e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	2819b86b-4d06-499d-a0c9-af1a3e711ecf	5bddf49d-93d4-4f2d-b41f-09b92bfd674e	\N	2020-02-17 14:00:49	2022-12-01 10:23:05	\N	2020-06-17 19:43:09
236c12fb-975c-4819-9c4a-990ba5b800f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	e7692714-42a9-11e5-a70e-2322869c051b	236c12fb-975c-4819-9c4a-990ba5b800f1	\N	2020-02-17 14:00:49	2022-12-01 10:23:05	\N	2020-06-17 19:43:09
78bfc23d-0e20-4550-b385-bece7da6c0da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	78bfc23d-0e20-4550-b385-bece7da6c0da	\N	2020-02-17 14:00:50	2022-12-01 10:23:06	\N	2020-06-17 19:43:09
0bfebd85-0aa4-4030-97be-d14f7be1d828	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	0bfebd85-0aa4-4030-97be-d14f7be1d828	\N	2020-02-17 14:00:49	2022-12-01 10:23:06	\N	2020-06-17 19:43:09
19ac1fbd-9b84-4259-a4e3-f775e6d2e5fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	5132bbaa-b74f-4719-86b7-5cfe82b86531	19ac1fbd-9b84-4259-a4e3-f775e6d2e5fd	\N	2020-02-17 14:00:49	2022-12-01 10:23:06	\N	2020-06-17 19:43:09
c42c397a-7a13-431f-be15-742c1320fb69	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	7ab0ba14-a17f-4ecd-8201-a673cc87846c	c42c397a-7a13-431f-be15-742c1320fb69	\N	2020-02-17 14:00:50	2022-12-01 10:23:07	\N	2020-06-17 19:43:09
ace229f6-debf-41aa-b0b8-7359b9c0e86a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	ff07bc11-35f4-4ff1-a749-78e30f56e52c	ace229f6-debf-41aa-b0b8-7359b9c0e86a	\N	2020-02-17 14:00:50	2022-12-01 10:23:07	\N	2020-06-17 19:43:10
a1a9ce3a-39d3-4915-b607-1593cd4830c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	d90d0294-59e6-4283-a821-c9b6aaae536b	a1a9ce3a-39d3-4915-b607-1593cd4830c3	\N	2020-02-17 14:00:50	2022-12-01 10:23:09	\N	2020-06-17 19:43:10
f8cb7fb2-543f-4b01-93cf-e941d6a1bad3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	31d87dba-8af0-48a5-a609-901bda9031d3	f8cb7fb2-543f-4b01-93cf-e941d6a1bad3	\N	2020-02-17 14:00:50	2022-12-01 10:23:10	\N	2020-06-17 19:43:09
0a57d9fe-c960-492d-9638-acf578ae1402	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	010a4695-214e-4efb-a13b-83ab9a7e5a9a	0a57d9fe-c960-492d-9638-acf578ae1402	\N	2020-02-17 14:00:50	2022-12-01 10:23:11	\N	2020-06-17 19:43:09
36aed1bc-f2ba-498b-911b-3613bc3c2b53	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	7a426c49-48eb-473c-9779-47a65a92d954	36aed1bc-f2ba-498b-911b-3613bc3c2b53	\N	2020-02-17 14:00:49	2022-12-01 10:23:11	\N	2020-06-17 19:43:09
506e00cf-65d0-4bff-82c8-42b8b6f4a908	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	ea363a5f-9119-468b-8fea-9187ba92c13e	506e00cf-65d0-4bff-82c8-42b8b6f4a908	\N	2020-02-17 14:00:50	2022-12-01 10:23:12	\N	2020-06-17 19:43:09
b3a131b6-d738-49ac-8ec7-ce6abdadc97f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	a16778e6-fe58-40af-a29b-6c47664d4064	b3a131b6-d738-49ac-8ec7-ce6abdadc97f	\N	2020-02-17 14:00:49	2022-12-01 10:23:12	\N	2020-06-17 19:43:09
bd3cc20a-2d6a-4ba5-a8b9-91e3c5732b1e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	bd3cc20a-2d6a-4ba5-a8b9-91e3c5732b1e	\N	2020-02-17 14:00:49	2022-12-01 10:23:15	\N	2020-06-17 19:43:09
583fd70c-bb94-4714-ae3f-57d3db5cae52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	4f8e0696-ebb4-406b-a15d-10ddcaa85487	583fd70c-bb94-4714-ae3f-57d3db5cae52	\N	2020-02-17 14:00:49	2022-12-01 10:23:15	\N	2020-06-17 19:43:09
7628390b-e4ad-4057-bf1c-96eb092f5b3f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	6402418c-54f9-11e5-9e54-5397b782050d	7628390b-e4ad-4057-bf1c-96eb092f5b3f	\N	2020-02-17 14:00:49	2022-12-01 10:23:15	\N	2020-06-17 19:43:09
dad2ea2f-71cb-45e3-b7c4-f0ea8fc27c5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	43995feb-8d7d-4f37-9a8b-b2ab3ff70ac2	dad2ea2f-71cb-45e3-b7c4-f0ea8fc27c5b	\N	2020-02-17 14:00:50	2022-12-01 10:23:16	\N	2020-06-17 19:43:10
ce411f8c-68e6-465e-b6a5-433212b51761	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	edbf1ed9-b137-4d28-8af1-a22ab23be53b	ce411f8c-68e6-465e-b6a5-433212b51761	\N	2020-02-17 14:00:50	2022-12-01 10:23:17	\N	2020-06-17 19:43:10
6226f3f1-d27f-404b-b3d0-89a12c8cdd5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	6226f3f1-d27f-404b-b3d0-89a12c8cdd5a	\N	2020-02-17 14:00:49	2022-12-01 10:23:17	\N	2020-06-17 19:43:09
bc9abe57-2628-4789-8cd8-3be86440fc8d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	f80b678d-bb43-4915-9ef0-22b1d2320638	bc9abe57-2628-4789-8cd8-3be86440fc8d	\N	2020-02-17 14:00:50	2022-12-01 10:23:17	\N	2020-06-17 19:43:10
c161f035-e875-45d1-aca5-a4c73e99fab1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	8462527e-862e-4b54-b09b-a9c99a9f276d	c161f035-e875-45d1-aca5-a4c73e99fab1	\N	2020-02-17 14:00:49	2022-12-01 10:23:18	\N	2020-06-17 19:43:09
cf8f2aff-b9e9-4b3e-b6b5-3cfff0ae6911	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	7dbbb577-7b93-48ef-b139-db84e9163597	cf8f2aff-b9e9-4b3e-b6b5-3cfff0ae6911	\N	2020-02-17 14:00:49	2022-12-01 10:23:21	\N	2020-06-17 19:43:09
4371c459-b2a8-4b80-9d0f-15add171a8a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	5fb28ec2-45dd-45c4-8021-0e597172c690	4371c459-b2a8-4b80-9d0f-15add171a8a0	\N	2020-02-17 14:00:50	2022-12-01 10:23:22	\N	2020-06-17 19:43:09
c730494d-5401-45b4-a84f-2aaeeb2c57ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	679c6691-5977-4188-b9cb-15090b3fb85f	c730494d-5401-45b4-a84f-2aaeeb2c57ee	\N	2020-02-17 14:00:50	2022-12-01 10:23:26	\N	2020-06-17 19:43:09
357a2837-cd7c-4a7c-927f-d2b2eecf95cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	11558ce2-46ca-11e5-8ba3-b7381d40fb27	357a2837-cd7c-4a7c-927f-d2b2eecf95cc	\N	2020-02-17 14:00:49	2022-12-01 10:23:29	\N	2020-06-17 19:43:09
b78f1d3e-dee5-4e07-8666-fb7f026880bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	7661d6a5-1907-41fd-8c82-a5fea385fef8	b78f1d3e-dee5-4e07-8666-fb7f026880bb	\N	2020-02-17 14:00:50	2022-12-01 10:23:29	\N	2020-06-17 19:43:09
2e8d7082-009f-47eb-a435-4790a0a45ea5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	3ad03a6a-9caa-40e4-a060-62e1680cd17b	2e8d7082-009f-47eb-a435-4790a0a45ea5	\N	2020-02-17 14:00:49	2022-12-01 10:23:30	\N	2020-06-17 19:43:09
bcb83eea-1ccf-412e-8698-fd4758bc5e05	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	9a620eee-29e7-11e4-ae49-9347b0b34e1b	bcb83eea-1ccf-412e-8698-fd4758bc5e05	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
2929a0fd-f35e-463e-b0d6-64a2f68d37a5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	4e17dbe4-5513-11e3-80d2-93b52d015860	2929a0fd-f35e-463e-b0d6-64a2f68d37a5	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
fa9c976b-56f2-4b4c-ad90-2edef8da397b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	5d0df4f7-0fe6-e111-b726-95f5c2f10141	fa9c976b-56f2-4b4c-ad90-2edef8da397b	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
eb6ff0e5-dbe2-4cde-b057-0219e1b73195	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	7e01ed73-60e9-e111-8aad-9717d5fcd8bc	eb6ff0e5-dbe2-4cde-b057-0219e1b73195	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1ace9575-06ab-4665-b751-0d6f66d9dbdd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	2cb2e98a-3aff-11e4-969b-9749e9eb7f3b	1ace9575-06ab-4665-b751-0d6f66d9dbdd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b6d657dd-0b6d-4d40-b103-7dfad437f552	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	0b29331b-e31b-e211-af7c-974c050d9b7b	b6d657dd-0b6d-4d40-b103-7dfad437f552	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
5f960ade-66ea-457a-8780-d02e89e2cc7c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	1681eda8-2b5c-11e4-9bdb-97e5ac80f69d	5f960ade-66ea-457a-8780-d02e89e2cc7c	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
5ee89dd8-7872-4807-8d3e-0510448d0821	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	9513195e-7df5-11e3-816c-9b416ddfdbe4	5ee89dd8-7872-4807-8d3e-0510448d0821	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
da9dc3b5-60de-4980-ac92-8932ae6b259e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	b7d6d3f4-77ae-41df-8c21-56e8731513a1	5a94a1fd-f803-4a19-ad1b-bf07ae73f583	\N	2020-02-17 14:00:49	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-06-17 19:43:09
f6848f2d-d266-45ee-a33b-951a5c25bb6a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	f6848f2d-d266-45ee-a33b-951a5c25bb6a	\N	2020-02-17 14:00:50	2022-12-01 10:22:48	\N	2020-06-17 19:43:09
6925e102-203b-4ec1-b96e-beeb493ff1fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	6925e102-203b-4ec1-b96e-beeb493ff1fe	\N	2020-02-17 14:00:50	2022-12-01 10:22:50	\N	2020-06-17 19:43:10
e27f408d-ba1c-4d11-9c47-26bbe2d7a20c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	6b031760-aef5-4dbb-b520-01e6685a54d1	e27f408d-ba1c-4d11-9c47-26bbe2d7a20c	\N	2020-02-17 14:00:49	2022-12-01 10:22:50	\N	2020-06-17 19:43:09
a836bf2e-0bf5-4c3a-8a7f-19b9f149b716	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	7b6763fc-6f9f-11e3-b017-03efaa0c94af	a836bf2e-0bf5-4c3a-8a7f-19b9f149b716	\N	2020-02-17 14:00:50	2022-12-01 10:22:51	\N	2020-06-17 19:43:09
fb1e2f6b-3834-41f5-a0aa-cf3df2c3b046	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	fb1e2f6b-3834-41f5-a0aa-cf3df2c3b046	\N	2020-02-17 14:00:50	2022-12-01 10:22:52	\N	2020-06-17 19:43:10
338a73c3-b8ad-4780-8388-bc533a8259f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	338a73c3-b8ad-4780-8388-bc533a8259f1	\N	2020-02-17 14:00:51	2022-12-01 10:22:54	\N	2020-06-17 19:43:10
39712509-e8bc-4617-a660-7fe3f4a82a08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	8c54af21-d3fa-4eba-b89f-b628ab9fa013	39712509-e8bc-4617-a660-7fe3f4a82a08	\N	2020-02-17 14:00:51	2022-12-01 10:22:54	\N	2020-06-17 19:43:10
483e2989-283b-41ab-80fd-7edb010ced07	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	501e0d46-a3a8-4538-9bd0-33892dbc8140	483e2989-283b-41ab-80fd-7edb010ced07	\N	2020-02-17 14:00:51	2022-12-01 10:22:56	\N	2020-06-17 19:43:10
254b4845-a832-40a3-8dca-b486f7eae938	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	254b4845-a832-40a3-8dca-b486f7eae938	\N	2020-02-17 14:00:50	2022-12-01 10:22:57	\N	2020-06-17 19:43:10
ef12de60-1f62-48d1-981d-17cf6877cb38	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	4e27de9b-f65a-489f-8db8-7a6cb724fa6f	ef12de60-1f62-48d1-981d-17cf6877cb38	\N	2020-02-17 14:00:50	2022-12-01 10:22:57	\N	2020-06-17 19:43:10
9978d614-9e59-4339-967d-80191ce6f58d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	8cf66883-ebc1-473e-a01c-37925b2b2150	9978d614-9e59-4339-967d-80191ce6f58d	\N	2020-02-17 14:00:50	2022-12-01 10:22:58	\N	2020-06-17 19:43:10
39694c7e-ea8e-4d22-8f87-4fafdccabdeb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	2d18bbb3-fd39-46c5-98e0-19c1a9a240db	39694c7e-ea8e-4d22-8f87-4fafdccabdeb	\N	2020-02-17 14:00:50	2022-12-01 10:22:58	\N	2020-06-17 19:43:09
fdacddc3-9743-457c-b418-3ffa95108568	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	d1de7680-727c-4931-a9c8-1cc3a384a7c5	fdacddc3-9743-457c-b418-3ffa95108568	\N	2020-02-17 14:00:51	2022-12-01 10:22:59	\N	2020-06-17 19:43:10
2f5991b7-b02f-441f-abfe-3d3771c4a36b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	36aa6f27-73dc-4d6c-98e8-cb7a01d1f686	2f5991b7-b02f-441f-abfe-3d3771c4a36b	\N	2020-02-17 14:00:50	2022-12-01 10:22:59	\N	2020-06-17 19:43:10
07d82fb7-5e2a-4f2a-a906-206ff3e13661	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	808f4853-72f6-44e9-8555-4e07f494c8cf	07d82fb7-5e2a-4f2a-a906-206ff3e13661	\N	2020-02-17 14:00:50	2022-12-01 10:22:59	\N	2020-06-17 19:43:10
4ead1a85-6c93-4a74-b9cf-fe25980f56e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	2e534eee-4290-11e5-9525-d72625153a3d	4ead1a85-6c93-4a74-b9cf-fe25980f56e8	\N	2020-02-17 14:00:51	2022-12-01 10:23:01	\N	2020-06-17 19:43:10
6c6a25f1-9a5f-4597-9f32-8e57ba949f27	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	cf3761de-7aae-48d8-aec8-088c3e87e8ed	6c6a25f1-9a5f-4597-9f32-8e57ba949f27	\N	2020-02-17 14:00:50	2022-12-01 10:23:01	\N	2020-06-17 19:43:10
94fe06c7-7c0c-4e65-96fd-1b565636e29a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	14fba9a1-6ca4-4937-84e7-2a845d02897a	94fe06c7-7c0c-4e65-96fd-1b565636e29a	\N	2020-02-17 14:00:51	2022-12-01 10:23:04	\N	2020-06-17 19:43:10
a20b28ba-5ac1-4521-89dc-0e4b22dc2a0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	645aba46-378c-11e4-a83f-afbd60abf5c3	a20b28ba-5ac1-4521-89dc-0e4b22dc2a0d	\N	2020-02-17 14:00:51	2022-12-01 10:23:05	\N	2020-06-17 19:43:10
547071c0-a968-444f-a613-37945a72d166	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	1d2b0b00-23c4-4c1b-a956-a85ff7deb40b	547071c0-a968-444f-a613-37945a72d166	\N	2020-02-17 14:00:50	2022-12-01 10:23:06	\N	2020-06-17 19:43:10
c41838f5-d77e-4d47-8a1e-39384727f296	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	c7a20e10-51e9-11e5-9503-af6d1e3f4589	c41838f5-d77e-4d47-8a1e-39384727f296	\N	2020-02-17 14:00:51	2022-12-01 10:23:07	\N	2020-06-17 19:43:10
4a488c1e-2241-4fa5-b17c-2e59c43e1ead	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	1438adc2-38fc-11e4-b641-3f0b3de385b4	4a488c1e-2241-4fa5-b17c-2e59c43e1ead	\N	2020-02-17 14:00:50	2022-12-01 10:23:07	\N	2020-06-17 19:43:10
0b70484f-ad2b-4847-a106-a4180fb947d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	5899f113-d963-4965-9245-1f6222f5bbc1	0b70484f-ad2b-4847-a106-a4180fb947d0	\N	2020-02-17 14:00:50	2022-12-01 10:23:07	\N	2020-06-17 19:43:10
429dfaef-d176-4fda-b22f-656d531c0516	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	02c9180a-0b24-4ac4-b544-24d968340f61	429dfaef-d176-4fda-b22f-656d531c0516	\N	2020-02-17 14:00:50	2022-12-01 10:23:08	\N	2020-06-17 19:43:10
a76e25d6-ee93-4b2f-b8f7-bd94c5ddee48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	a76e25d6-ee93-4b2f-b8f7-bd94c5ddee48	\N	2020-02-17 14:00:51	2022-12-01 10:23:09	\N	2020-06-17 19:43:10
dd5b616a-625b-47a9-aa73-27d52fcf40f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	37dd7c39-5a77-4fb3-8bf4-31fe5f545da1	dd5b616a-625b-47a9-aa73-27d52fcf40f7	\N	2020-02-17 14:00:51	2022-12-01 10:23:11	\N	2020-06-17 19:43:10
d570c395-7482-4268-9922-384ec61d674c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	2a0784f4-94ee-435b-8fb3-8c798d15d817	d570c395-7482-4268-9922-384ec61d674c	\N	2020-02-17 14:00:50	2022-12-01 10:23:11	\N	2020-06-17 19:43:10
78ffc917-ec8a-49c3-9faf-0346ebda3887	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	daa07555-dd3d-44da-856b-28f08ecd474e	78ffc917-ec8a-49c3-9faf-0346ebda3887	\N	2020-02-17 14:00:50	2022-12-01 10:23:12	\N	2020-06-17 19:43:10
64e41df4-d52b-403f-b4f8-ac0f5f14c164	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	64e41df4-d52b-403f-b4f8-ac0f5f14c164	\N	2020-02-17 14:00:51	2022-12-01 10:23:13	\N	2020-06-17 19:43:10
d62e0584-1183-420d-9839-f6d6f81647a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	b7b48546-4541-11e5-b9f9-e7e850efd101	d62e0584-1183-420d-9839-f6d6f81647a1	\N	2020-02-17 14:00:50	2022-12-01 10:23:13	\N	2020-06-17 19:43:09
73eb7de3-0717-434a-8355-3299c57bf0a3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	4c42f155-3a8b-4690-b9c4-f92f8d413990	73eb7de3-0717-434a-8355-3299c57bf0a3	\N	2020-02-17 14:00:50	2022-12-01 10:23:15	\N	2020-06-17 19:43:10
1359a8f6-4a1f-4676-90ed-989ddf4a74dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	2f627335-3b69-4db3-94e3-0a43968e23e9	1359a8f6-4a1f-4676-90ed-989ddf4a74dd	\N	2020-02-17 14:00:50	2022-12-01 10:23:15	\N	2020-06-17 19:43:10
0fd1396f-9ae7-4344-bd63-80df18376ecc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	d85e860f-35a9-4406-8bc6-0e4051153600	0fd1396f-9ae7-4344-bd63-80df18376ecc	\N	2020-02-17 14:00:49	2022-12-01 10:23:15	\N	2020-06-17 19:43:09
53e9cdf5-911e-4e45-812e-66cabac517dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	d57f4561-8cb1-42ae-940e-7943cdae287b	53e9cdf5-911e-4e45-812e-66cabac517dc	\N	2020-02-17 14:00:51	2022-12-01 10:23:16	\N	2020-06-17 19:43:10
4083d5fb-98ca-422c-8419-92d061e31f8a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	243b6119-e39f-4849-8fd0-218155575c5a	4083d5fb-98ca-422c-8419-92d061e31f8a	\N	2020-02-17 14:00:50	2022-12-01 10:23:17	\N	2020-06-17 19:43:10
2b4d0e31-1431-418b-9d59-1d440fad6792	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	42d0f133-d66c-4ae9-a769-9547b1482539	2b4d0e31-1431-418b-9d59-1d440fad6792	\N	2020-02-17 14:00:51	2022-12-01 10:23:19	\N	2020-06-17 19:43:10
29bdce04-8166-4191-b519-f09e1482c696	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	d6276643-bada-4ca6-a7d6-27f02efbd2c2	29bdce04-8166-4191-b519-f09e1482c696	\N	2020-02-17 14:00:51	2022-12-01 10:23:22	\N	2020-06-17 19:43:10
3b6a90ec-8a07-4975-8c43-47eeebc29c32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	3b6a90ec-8a07-4975-8c43-47eeebc29c32	\N	2020-02-17 14:00:50	2022-12-01 10:23:22	\N	2020-06-17 19:43:10
c7d8890c-edd9-4f47-b366-c4742412c912	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	e0e38c52-da5a-44a8-ac92-411718cd6332	c7d8890c-edd9-4f47-b366-c4742412c912	\N	2020-02-17 14:00:50	2022-12-01 10:23:24	\N	2020-06-17 19:43:10
967b9ff7-7a71-4a4c-bcba-d78c2bae6f3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	04a45a78-7f1b-4cad-a70f-732efa5f7985	967b9ff7-7a71-4a4c-bcba-d78c2bae6f3d	\N	2020-02-17 14:00:51	2022-12-01 10:23:25	\N	2020-06-17 19:43:10
65303137-0a95-4dc8-b60e-768096255b36	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	bd3a2d69-e9b5-4462-9057-eb4b035b297d	65303137-0a95-4dc8-b60e-768096255b36	\N	2020-02-17 14:00:50	2022-12-01 10:23:25	\N	2020-06-17 19:43:10
1ec70f17-2cc8-4a60-9a59-305f4293835b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	1ec70f17-2cc8-4a60-9a59-305f4293835b	\N	2020-02-17 14:00:50	2022-12-01 10:23:25	\N	2020-06-17 19:43:10
521c8c51-b0ec-4e90-a5f5-110062a5a9db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	698259da-b323-4524-92e3-706ec09179bd	521c8c51-b0ec-4e90-a5f5-110062a5a9db	\N	2020-02-17 14:00:51	2022-12-01 10:23:25	\N	2020-06-17 19:43:10
f2619e22-8cb9-414e-aaa0-a9448e44835a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	57ebd7a0-e7fc-4ace-a174-a19d2eca240e	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	f2619e22-8cb9-414e-aaa0-a9448e44835a	\N	2020-02-17 14:00:51	2022-12-01 10:23:26	\N	2020-06-17 19:43:10
52c6a7d1-89fd-4b81-af5b-f0f3a46ed7ce	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	88c6acc3-882c-418e-b96e-f83ccccd7f79	52c6a7d1-89fd-4b81-af5b-f0f3a46ed7ce	\N	2020-02-17 14:00:50	2022-12-01 10:23:29	\N	2020-06-17 19:43:09
265ce0a8-1d19-467e-9d5a-b619159cfb79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	2704f9d0-22fc-11e4-859d-e78b145c39c9	265ce0a8-1d19-467e-9d5a-b619159cfb79	\N	2020-02-17 14:00:50	2022-12-01 10:23:29	\N	2020-06-17 19:43:10
2ca8dd40-6b66-4f02-b4dc-61f5fe98a6a0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	8c594fba-3f91-11e3-9537-9bc9857fe6ed	2ca8dd40-6b66-4f02-b4dc-61f5fe98a6a0	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1c027c2b-a811-4919-bdd7-4bb3e09788fd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	f1d007d2-5510-11e3-b6b9-9f1ff279b7f0	1c027c2b-a811-4919-bdd7-4bb3e09788fd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
609bfa2e-7403-4fb7-aec0-ba492bd96799	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	7d53b748-2461-11e4-8bbd-9fae97654387	609bfa2e-7403-4fb7-aec0-ba492bd96799	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
112a97c5-9a74-4bfd-9d7b-dca48f5933a5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	679104ba-337f-11e4-85b9-9ff0ea6fccea	112a97c5-9a74-4bfd-9d7b-dca48f5933a5	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c73d7ac5-004a-4ffd-9b27-224c3ca77182	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	1adabd36-35d8-11e4-a4f4-a386d57542c3	c73d7ac5-004a-4ffd-9b27-224c3ca77182	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
dde94edc-3d77-459c-a09c-d8ef1ce1b8e1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	08e85ce8-9658-11e3-9030-a3a089f9edfb	dde94edc-3d77-459c-a09c-d8ef1ce1b8e1	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c21895b4-ce63-458b-8941-e8956005e7cd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	da147220-5841-11e3-9d82-a3d5a6cd6ef4	c21895b4-ce63-458b-8941-e8956005e7cd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
8a5c9f19-9a6d-409f-8b6c-ff22b4ae4816	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	dd2adab5-bbce-4c7d-8cbd-01a872b3d516	73f05354-e4d2-4edb-b071-55f4d419e77c	\N	2020-02-17 14:00:50	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-06-17 19:43:10
d2b2bcd6-c4da-4584-b914-d0cc6eab942a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	1d64c4a6-b263-441e-82e2-763c790c3c05	c6beded5-0b58-4187-ae4e-78cdcbd522e2	\N	2020-02-17 14:00:51	2020-04-22 11:58:01	2020-04-22 11:58:01	2020-03-06 22:00:54
7f41d88e-5168-4b3d-a34c-94453a126dd7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	900ffa20-46cc-11e5-8abe-0337176d8d23	7f41d88e-5168-4b3d-a34c-94453a126dd7	\N	2020-02-17 14:00:51	2022-12-01 10:22:50	\N	2020-06-17 19:43:10
fcd8dd0e-7fd3-4a14-b322-c0866c893441	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	06b71793-3a86-4c6b-9000-717dca267295	fcd8dd0e-7fd3-4a14-b322-c0866c893441	\N	2020-02-17 14:00:51	2022-12-01 10:22:58	\N	2020-06-17 19:43:10
eaee3741-98db-4a70-b68a-075cf735eebc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	00e6f0c6-c214-4588-90c0-4a271deaa2c9	eaee3741-98db-4a70-b68a-075cf735eebc	\N	2020-02-17 14:00:51	2022-12-01 10:23:01	\N	2020-06-17 19:43:10
3a825227-f130-4e29-9a2d-27b3298d989a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	ac0343f2-09a5-4b95-b38f-cd379433d96c	3a825227-f130-4e29-9a2d-27b3298d989a	\N	2020-02-17 14:00:51	2022-12-01 10:23:01	\N	2020-06-17 19:43:10
758d2347-9e38-47e0-870e-07dd9747ccdd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	758d2347-9e38-47e0-870e-07dd9747ccdd	\N	2020-02-17 14:00:48	2022-12-01 10:23:04	\N	2020-06-17 19:43:08
1907408b-0202-42b0-8fa2-48e2fe67cac7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ae2ca5d2-b015-41b1-9f4d-7dfde24b06eb	d313aa86-3092-4ceb-8e53-fabcecc2a37a	1907408b-0202-42b0-8fa2-48e2fe67cac7	\N	2020-02-17 14:00:48	2022-12-01 10:23:08	\N	2020-06-17 19:43:08
ef9e0015-549e-4005-af3b-3e4f79e6144e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	d0dca4af-4472-4232-af75-aaabf7ca88e7	ef9e0015-549e-4005-af3b-3e4f79e6144e	\N	2020-02-17 14:00:51	2022-12-01 10:23:08	\N	2020-06-17 19:43:10
472ac69b-7383-4252-b82d-d24b834a7d37	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	1f87026c-1601-4eb9-9b82-64289bded8ed	472ac69b-7383-4252-b82d-d24b834a7d37	\N	2020-02-17 14:00:51	2022-12-01 10:23:12	\N	2020-06-17 19:43:10
2cbf77e1-cccd-46b0-971b-6b052ae8e998	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	1f2744a1-b44f-4781-b64e-fd5946fa9e25	b5b764d4-4c3f-11e5-9257-b3688b89f32b	2cbf77e1-cccd-46b0-971b-6b052ae8e998	\N	2020-02-17 14:00:51	2022-12-01 10:23:12	\N	2020-06-17 19:43:10
090c3ebd-d18b-474c-b5d5-b051c6bd3556	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	8e47faed-6b87-4baf-8d94-d778345455f3	090c3ebd-d18b-474c-b5d5-b051c6bd3556	\N	2020-02-17 14:00:51	2022-12-01 10:23:12	\N	2020-06-17 19:43:10
13e16d36-0fab-469b-8ff7-d5130f95eae4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	22278151-6aec-4b87-bfab-3bf8d1810468	13e16d36-0fab-469b-8ff7-d5130f95eae4	\N	2020-02-17 14:00:51	2022-12-01 10:23:13	\N	2020-06-17 19:43:10
8ba48fca-4e81-454a-84bb-a431893721f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	93853854-479a-11e5-8f29-97b6ab3d09e1	8ba48fca-4e81-454a-84bb-a431893721f5	\N	2020-02-17 14:00:51	2022-12-01 10:23:17	\N	2020-06-17 19:43:10
f6afe343-27f8-40f4-bde6-07bca18f3773	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	540161f2-51dc-11e5-ada1-57cb00fd65d6	f6afe343-27f8-40f4-bde6-07bca18f3773	\N	2020-03-14 16:46:24	2022-12-01 10:23:17	\N	2020-04-28 06:37:41
1e957d32-1dc4-413e-b2d5-51bb2176ba3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7690b34c-a528-4b80-9493-d7e105906b58	1a68049f-e368-4766-8709-c7b9920f5e90	1e957d32-1dc4-413e-b2d5-51bb2176ba3d	\N	2020-02-17 14:00:51	2022-12-01 10:23:17	\N	2020-06-17 19:43:10
62df26d9-81d3-414f-9110-01fa5406a681	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	04a45a78-7f1b-4cad-a70f-732efa5f7985	62df26d9-81d3-414f-9110-01fa5406a681	\N	2020-03-14 16:46:24	2022-12-01 10:23:19	\N	2020-04-28 06:37:41
ec866564-317f-4cc6-bf0e-478e97045a22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	472d73e3-2d2f-488f-8e2f-cd3d22418632	ec866564-317f-4cc6-bf0e-478e97045a22	\N	2020-02-17 14:00:51	2022-12-01 10:23:22	\N	2020-06-17 19:43:10
d24ca60d-94c4-4ac8-8f91-ccb49e635216	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	d24ca60d-94c4-4ac8-8f91-ccb49e635216	\N	2020-02-17 14:00:51	2022-12-01 10:23:22	\N	2020-06-17 19:43:10
fa9541cb-ee23-4e8c-b194-b888a0e9efa9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	cb1c73b6-32ac-43ab-bfb1-fa5c9b14687d	0c57cc9c-4c32-11e5-858c-afbc5904667e	fa9541cb-ee23-4e8c-b194-b888a0e9efa9	\N	2020-02-17 14:00:51	2022-12-01 10:23:24	\N	2020-06-17 19:43:10
d1650afd-6835-4b12-896d-00d85515830f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d5b3a578-1613-474e-865b-0a47f3a64167	d1650afd-6835-4b12-896d-00d85515830f	\N	2020-03-14 16:46:24	2022-12-01 10:23:29	\N	2020-04-28 06:37:41
3d8f82ea-5c30-459b-bade-79114a282f9a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	fa0ad946-9650-11e3-bd6d-a7584e28e706	3d8f82ea-5c30-459b-bade-79114a282f9a	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b3d8eee3-d89f-44ac-8ce1-7259504d81ce	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	68eb2962-550e-11e3-b91d-a7ed0c733799	b3d8eee3-d89f-44ac-8ce1-7259504d81ce	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f2053c2b-f0cf-42ad-869c-3f2cb9da13aa	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	3865d208-3382-11e4-ab3f-ab8bc8cfd6c6	f2053c2b-f0cf-42ad-869c-3f2cb9da13aa	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
8ad4667e-2230-449d-acc6-59a5cc4747ab	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	ddfad7db-5ce6-e111-bca4-adc9dcf502a0	8ad4667e-2230-449d-acc6-59a5cc4747ab	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
4d9cd75b-14d7-419d-9147-07946f4682aa	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	f86c66aa-4fe6-11e3-a577-afa240899cad	4d9cd75b-14d7-419d-9147-07946f4682aa	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f39f77ce-3cde-4032-b7dc-5dc6eee427bf	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	04892bf2-32a5-11e4-b928-afe768f182d3	f39f77ce-3cde-4032-b7dc-5dc6eee427bf	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
ac1fb4fd-539f-4565-910f-92eb46840d4a	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	cf2ca285-314b-4bb8-983d-b2b4b27a1d0c	ac1fb4fd-539f-4565-910f-92eb46840d4a	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
89969456-0542-44e3-bd9f-e613851a33cd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	123d523e-4616-11e5-8b7b-b3c2222b8ab2	89969456-0542-44e3-bd9f-e613851a33cd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b9bc4a06-1739-4073-9d65-fbeb6e3021be	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	6e8364a0-642a-4bf4-9408-b408e912a3da	b9bc4a06-1739-4073-9d65-fbeb6e3021be	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
60881f84-cc33-434e-bb01-c06ea0d8ba14	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	02cd4e66-2534-430c-a6c9-b7495ce2cfd2	60881f84-cc33-434e-bb01-c06ea0d8ba14	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
2e4fa6aa-07b8-487c-bbd0-b1e67ff8cb02	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	e7336b46-954a-11e3-90eb-b79b250c8111	2e4fa6aa-07b8-487c-bbd0-b1e67ff8cb02	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
dbbae0b4-9d13-4e98-a747-e9fbb93608b1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	05850c34-6481-442d-8683-b8f58fd41f74	dbbae0b4-9d13-4e98-a747-e9fbb93608b1	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
e23bf257-db91-4dc5-891e-312694c714ee	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	80997a1b-c636-4aa7-8011-b977011beb7c	e23bf257-db91-4dc5-891e-312694c714ee	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d8f1f6e7-73c7-4472-a884-87b548148246	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	989231ae-2f67-11e4-a4e4-bb2d8e03f40b	d8f1f6e7-73c7-4472-a884-87b548148246	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
746f4a44-30b2-43dc-967a-1936f6589de0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	c0b29c44-3fdc-11e3-a52a-bb3330a177e0	746f4a44-30b2-43dc-967a-1936f6589de0	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
001e0346-ab0d-4029-8633-1093cb04a843	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	192afe4a-35da-11e4-a16a-bb65a9bcf52f	001e0346-ab0d-4029-8633-1093cb04a843	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
9d1d5603-6943-4e06-a68f-21f605d54d04	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	3178781c-aaf4-4966-8e9f-be3cc888c83f	9d1d5603-6943-4e06-a68f-21f605d54d04	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
86a1d43d-3f27-49cd-9b3f-0699375f84ab	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	ed6f82d0-2675-11e4-a56a-bf84c339e43d	86a1d43d-3f27-49cd-9b3f-0699375f84ab	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
503aa42a-731d-476d-9095-47fa95d9357e	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	096296a0-2f94-e211-af76-c1f8aca8c90f	503aa42a-731d-476d-9095-47fa95d9357e	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
7f739c92-8e58-4d02-b96f-1fa8b9126ee5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	557c2c9f-3094-e211-af76-c1f8aca8c90f	7f739c92-8e58-4d02-b96f-1fa8b9126ee5	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1a581b8b-c459-41e2-8ca8-91b32373c7f5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	5554a579-3294-e211-af76-c1f8aca8c90f	1a581b8b-c459-41e2-8ca8-91b32373c7f5	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
34dcd4d0-3d5e-42de-a2fb-091b5a7b170d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	25c89288-3394-e211-af76-c1f8aca8c90f	34dcd4d0-3d5e-42de-a2fb-091b5a7b170d	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
dcd64197-1f6d-42d6-8dc2-95340cfb6694	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	35c5b0fa-50b5-11e3-b6c2-c35271e84700	dcd64197-1f6d-42d6-8dc2-95340cfb6694	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c2367816-807f-4c2a-8b65-9e5d6a6da095	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	514fc4e0-34a4-11e4-b0ca-c70e0e0738fb	c2367816-807f-4c2a-8b65-9e5d6a6da095	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
a4c2ed14-31a5-4a6f-a1e0-3b01d33fdcb8	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	b4c58b72-2545-11e4-9e44-c721249f1235	a4c2ed14-31a5-4a6f-a1e0-3b01d33fdcb8	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
0c7e3b1a-1645-4945-956b-2d11fa283a18	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	f515e18e-9307-11e3-b9c3-c7cb2d62d0dc	0c7e3b1a-1645-4945-956b-2d11fa283a18	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b722d8c7-db28-456b-9357-92ba481521e0	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	f164e4f3-e2e8-e111-8e9c-c93e31fbf38d	b722d8c7-db28-456b-9357-92ba481521e0	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b6960f37-fa32-4bba-bc8d-22dae9636e37	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	bb7f9fe9-e3e8-e111-8e9c-c93e31fbf38d	b6960f37-fa32-4bba-bc8d-22dae9636e37	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
e6e9c009-56ed-4a8a-9a99-491d39e745fd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	735c93db-e8e8-e111-8e9c-c93e31fbf38d	e6e9c009-56ed-4a8a-9a99-491d39e745fd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
cb53261b-f023-4e5a-b9fd-4d92a0362265	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	1c546c6e-eae8-e111-8e9c-c93e31fbf38d	cb53261b-f023-4e5a-b9fd-4d92a0362265	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
01a4aeef-e75e-4d5c-8ef1-77777542ff4b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	a774b65c-ede8-e111-8e9c-c93e31fbf38d	01a4aeef-e75e-4d5c-8ef1-77777542ff4b	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
225fe3e9-5bff-4530-9ff5-5fd5eac8f7ba	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	087b3cca-ede8-e111-8e9c-c93e31fbf38d	225fe3e9-5bff-4530-9ff5-5fd5eac8f7ba	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f093e6fa-dc2c-4a42-b735-2bd147fffdf1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	129584a7-eee8-e111-8e9c-c93e31fbf38d	f093e6fa-dc2c-4a42-b735-2bd147fffdf1	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1bbea34a-2e5e-4e20-b968-f271bec8b2ad	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	2fdb7a45-f0e8-e111-8e9c-c93e31fbf38d	1bbea34a-2e5e-4e20-b968-f271bec8b2ad	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
7b379088-0d74-4eb2-b4ad-9180e704e5b2	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	c41866ce-f3e8-e111-8e9c-c93e31fbf38d	7b379088-0d74-4eb2-b4ad-9180e704e5b2	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
96312f22-869f-4c91-8774-b236688bcb52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	efadf950-9060-45d1-a065-ddd9c87cd53f	96312f22-869f-4c91-8774-b236688bcb52	\N	2020-02-17 14:00:51	2022-12-01 10:22:51	\N	2020-06-17 19:43:10
98e49929-729d-4f1b-adc6-86759f1151a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	3ee043f8-9893-11e5-911a-5f12b6406080	98e49929-729d-4f1b-adc6-86759f1151a4	\N	2020-03-14 16:46:25	2022-12-01 10:22:56	\N	2020-04-28 06:37:42
2eee05b5-fc35-4c18-872d-52ce76a58eef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	5ae837e8-4a02-11e5-9a00-2bca72a8469e	2eee05b5-fc35-4c18-872d-52ce76a58eef	\N	2020-03-14 16:46:25	2022-12-01 10:23:04	\N	2020-04-28 06:37:42
b219b1b4-a38d-4bb9-ba1d-64d18cebf68e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	06b71793-3a86-4c6b-9000-717dca267295	b219b1b4-a38d-4bb9-ba1d-64d18cebf68e	\N	2020-03-14 16:46:25	2022-12-01 10:23:05	\N	2020-04-28 06:37:42
bad2bdb0-0f60-4975-91e4-7b3578b6d0f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7a426c49-48eb-473c-9779-47a65a92d954	bad2bdb0-0f60-4975-91e4-7b3578b6d0f2	\N	2020-03-14 16:46:25	2022-12-01 10:23:10	\N	2020-04-28 06:37:42
5015f204-43a8-4749-b224-5285b788f143	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	568a2d30-3a78-43fd-81ea-2c98ec3d3865	5015f204-43a8-4749-b224-5285b788f143	\N	2020-03-14 16:46:25	2022-12-01 10:23:10	\N	2020-04-28 06:37:42
3bd2cf3a-250c-4235-aa06-7dc8665fde0a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	a83c363b-c56d-49b3-9d37-61d51488daab	3bd2cf3a-250c-4235-aa06-7dc8665fde0a	\N	2020-03-14 16:46:25	2022-12-01 10:23:10	\N	2020-04-28 06:37:42
bcdaf825-9828-420d-9339-5f119c6c1c43	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	93853854-479a-11e5-8f29-97b6ab3d09e1	bcdaf825-9828-420d-9339-5f119c6c1c43	\N	2020-03-14 16:46:25	2022-12-01 10:23:10	\N	2020-04-28 06:37:42
69beba3a-430f-4645-a872-5c84890c527f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d57f4561-8cb1-42ae-940e-7943cdae287b	69beba3a-430f-4645-a872-5c84890c527f	\N	2020-03-14 16:46:25	2022-12-01 10:23:11	\N	2020-04-28 06:37:42
22270c48-8103-4bed-8f2e-594cfa1255e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	22270c48-8103-4bed-8f2e-594cfa1255e0	\N	2020-03-14 16:46:25	2022-12-01 10:23:15	\N	2020-04-28 06:37:42
68a6534b-16e9-48f3-bf0e-8686e0c2c468	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	68a6534b-16e9-48f3-bf0e-8686e0c2c468	\N	2020-03-14 16:46:25	2022-12-01 10:23:19	\N	2020-04-28 06:37:42
4f90dc8b-b823-4ebd-aeac-3949cad9c839	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ad705d8a-429e-11e5-a989-af44a02d940a	4f90dc8b-b823-4ebd-aeac-3949cad9c839	\N	2020-03-14 16:46:25	2022-12-01 10:23:23	\N	2020-04-28 06:37:42
f0f6fcf3-b1f9-424e-a0b5-36033f46c963	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	bbb87b7d-f4e8-e111-8e9c-c93e31fbf38d	f0f6fcf3-b1f9-424e-a0b5-36033f46c963	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
a16165e4-1831-4678-a66d-a66794acc349	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	742b1169-f5e8-e111-8e9c-c93e31fbf38d	a16165e4-1831-4678-a66d-a66794acc349	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f2038175-c8af-413a-84b4-9a6b25cd2395	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	e241d9c4-3310-11e4-9987-cb03d863bbbc	f2038175-c8af-413a-84b4-9a6b25cd2395	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
92926a73-fe08-4b90-b06c-c82e715fcc79	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	424835da-550d-11e3-b743-cbb8d3bddec3	92926a73-fe08-4b90-b06c-c82e715fcc79	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f966c1bd-5d17-4820-9b27-9083f45c9d1d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	3555f2aa-501b-11e3-9516-cbf3faec3375	f966c1bd-5d17-4820-9b27-9083f45c9d1d	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
cb52c359-2e86-4bbc-879f-f95ad46cf665	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	26102166-50c1-11e3-a270-cf0bcf1bdce8	cb52c359-2e86-4bbc-879f-f95ad46cf665	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
209c5da6-3c4d-419e-a2cb-375421346485	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	bba11db6-2541-11e4-b3b9-cf30e3c87459	209c5da6-3c4d-419e-a2cb-375421346485	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
edff09a8-452d-416b-9520-00b89b5de7a2	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	7d02d24e-350d-11e4-9713-cff687f6568e	edff09a8-452d-416b-9520-00b89b5de7a2	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
413a5a24-4872-43c7-9e02-e6d9f3a3dd7c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	133ca928-328a-11e4-8633-d312a79d92bb	413a5a24-4872-43c7-9e02-e6d9f3a3dd7c	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
68f6092d-71d0-4d09-8bb4-5cf7cc6bdab9	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	75d48a12-5516-11e3-aa50-d32642ceea3d	68f6092d-71d0-4d09-8bb4-5cf7cc6bdab9	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
806b89b0-5490-4c0f-8808-4a7af9151e17	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	4d8b436a-25f0-11e4-8865-d3b443dd7c3b	806b89b0-5490-4c0f-8808-4a7af9151e17	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
8d4dff1a-00ce-4269-af77-15f1b8d4626f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	bc59d28e-4fe5-11e3-bc27-d77d7332c420	8d4dff1a-00ce-4269-af77-15f1b8d4626f	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
6824da32-5790-4c2f-8989-593673ac7e0c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	02c1a954-503b-11e3-b937-d7a8308ce494	6824da32-5790-4c2f-8989-593673ac7e0c	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
43b80bd5-0291-46fe-bb18-a21307d554dc	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	01d123d4-4ced-e111-b7f4-d7fe344e7035	43b80bd5-0291-46fe-bb18-a21307d554dc	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
7c3df70d-02d1-41bc-98ea-1d426cf060bf	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	0f8e2ae1-4eed-e111-b7f4-d7fe344e7035	7c3df70d-02d1-41bc-98ea-1d426cf060bf	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
712da6a2-66f1-4f90-91b6-cf0873313e2b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	2b9c7320-21c0-11e4-b186-db55d2e223bb	712da6a2-66f1-4f90-91b6-cf0873313e2b	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
86aacd74-0944-4af8-b779-d1b5c63415dd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	3790ca4a-3f95-11e3-baca-db8a4221c75c	86aacd74-0944-4af8-b779-d1b5c63415dd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d84e15d4-0be4-4fdd-b402-63d453d06543	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	5fa55ca8-25ef-11e4-8ac4-dba37192a3fa	d84e15d4-0be4-4fdd-b402-63d453d06543	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
a674198f-7bc5-4b97-958c-e4bb0636e607	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	f5b698b0-450d-11e3-b468-dbb546ea0612	a674198f-7bc5-4b97-958c-e4bb0636e607	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c374b9fe-9abd-4ffa-ac44-c985ca29587f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	ea67a814-964d-11e3-9d6b-dff39c17d85d	c374b9fe-9abd-4ffa-ac44-c985ca29587f	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c3277fab-e730-4ea2-8e2e-86c60d36ecc2	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	756352e9-d01d-e211-a769-e1bdd4fe3a3b	c3277fab-e730-4ea2-8e2e-86c60d36ecc2	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
a93e03e5-a9d8-42ee-b1f9-1c1e76f1f825	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	b5e198e7-d21d-e211-a769-e1bdd4fe3a3b	a93e03e5-a9d8-42ee-b1f9-1c1e76f1f825	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
e127b9f0-3b48-4894-89fe-78030ba85b90	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	c26ef87b-d31d-e211-a769-e1bdd4fe3a3b	e127b9f0-3b48-4894-89fe-78030ba85b90	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
df69d44e-2bf8-4d04-8e12-192af548b865	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	50579fd4-d81d-e211-a769-e1bdd4fe3a3b	df69d44e-2bf8-4d04-8e12-192af548b865	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d26fdee7-da0b-49d1-81fe-18a2d39dec43	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	58577c42-d91d-e211-a769-e1bdd4fe3a3b	d26fdee7-da0b-49d1-81fe-18a2d39dec43	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
0d09ec17-704e-421d-b3b8-6c4e7243e894	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	1e780d76-2a03-11e4-b83f-e3571ad1d1e1	0d09ec17-704e-421d-b3b8-6c4e7243e894	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
20abfbe5-e02b-4ff8-87b6-a47e110798d4	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	0894f75a-954b-11e3-ba31-e36afe937891	20abfbe5-e02b-4ff8-87b6-a47e110798d4	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
0c2ee533-6f0e-4959-a252-d376864a170d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	3f287138-2502-11e4-97eb-e378ca1a38b2	0c2ee533-6f0e-4959-a252-d376864a170d	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
ca6bcffa-e521-444d-9f3c-f0a2ec2adc9b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	cb33f27e-3fd4-11e3-ad67-e3b4cc32a6d1	ca6bcffa-e521-444d-9f3c-f0a2ec2adc9b	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
fa592054-17bc-472e-9a20-94dfcf4e1d86	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	a17fdbde-9563-11e3-99b0-e7408ba019b5	fa592054-17bc-472e-9a20-94dfcf4e1d86	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
54e24825-00cc-4fb4-8ded-017c73801e64	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	360fd774-2487-11e4-a915-e7cc050b0b78	54e24825-00cc-4fb4-8ded-017c73801e64	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
04966fcf-3d51-4f98-9a9a-c406df67e624	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	e6d1fe14-4da7-11e3-b3e0-eb863fc29eda	04966fcf-3d51-4f98-9a9a-c406df67e624	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
6d166ccd-9030-4afc-9163-8e4faff4502b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	729f6454-33e9-e111-8116-eb9206453624	6d166ccd-9030-4afc-9163-8e4faff4502b	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
9ade2184-64f6-46c7-b932-7f9e6c9f0932	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	8653a91b-224c-4d71-9949-61751b30fd60	598bb179-36e9-e111-8116-eb9206453624	9ade2184-64f6-46c7-b932-7f9e6c9f0932	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
e6d8cbc6-b575-4872-84f7-a5e02654daa1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	71bcb1cc-32ae-11e4-bdba-ebad0f8fe833	e6d8cbc6-b575-4872-84f7-a5e02654daa1	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b247d937-ac26-4636-8b15-a5d860966a38	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	7b1cf612-c8f0-e111-8abf-ed009c591d13	b247d937-ac26-4636-8b15-a5d860966a38	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
de2db04d-aa8a-491c-a02c-a0148f40672f	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	9343f612-c8f0-e111-8ac4-ed009c591d13	de2db04d-aa8a-491c-a02c-a0148f40672f	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
7dff24a5-959e-48fc-a984-779e8ed15a93	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	ae91f612-c8f0-e111-8acf-ed009c591d13	7dff24a5-959e-48fc-a984-779e8ed15a93	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
67c3b657-f9f9-46de-9308-c587be50af93	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	be91f612-c8f0-e111-8acf-ed009c591d13	67c3b657-f9f9-46de-9308-c587be50af93	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
cabf6fba-b2fc-479b-bde9-9cc60289de86	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	ca91f612-c8f0-e111-8acf-ed009c591d13	cabf6fba-b2fc-479b-bde9-9cc60289de86	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
6cb68bf1-91a4-4260-bf8d-8c061a5bbda2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	645aba46-378c-11e4-a83f-afbd60abf5c3	6fa16cf2-90b5-4d0e-a34e-4ab038d8122d	\N	2020-03-14 16:46:25	2020-04-28 06:37:42	\N	2020-04-28 06:37:42
f6f8fae3-4be8-4244-9681-25b5ec0e9303	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	542df659-4377-411d-9fa8-1f5ce8878479	f6f8fae3-4be8-4244-9681-25b5ec0e9303	\N	2020-03-14 16:46:26	2022-12-01 10:22:48	\N	2020-04-28 06:37:42
7c69d020-14ed-430c-8357-5344726b2c2b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	26daca7f-056a-4e55-a49a-4469004944ec	7c69d020-14ed-430c-8357-5344726b2c2b	\N	2020-03-14 16:46:25	2022-12-01 10:22:52	\N	2020-04-28 06:37:42
d03425dc-b092-4da3-9b87-493b570c968e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	542df659-4377-411d-9fa8-1f5ce8878479	d03425dc-b092-4da3-9b87-493b570c968e	\N	2020-03-14 16:46:27	2022-12-01 10:22:57	\N	2020-04-28 06:37:43
e119cffd-6d54-4b8c-8c6b-ae3ae36f73bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	0312c3d7-fde1-47cf-96ce-1f87a4228787	e119cffd-6d54-4b8c-8c6b-ae3ae36f73bf	\N	2020-03-14 16:46:26	2022-12-01 10:23:05	\N	2020-04-28 06:37:43
5fdc2ff5-c9df-4ea9-a28d-497dbbf8fddd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	31d87dba-8af0-48a5-a609-901bda9031d3	5fdc2ff5-c9df-4ea9-a28d-497dbbf8fddd	\N	2020-03-14 16:46:27	2022-12-01 10:23:10	\N	2020-04-28 06:37:43
5233fa8a-e2c9-4a44-857a-0ec8e5c68a36	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	14fba9a1-6ca4-4937-84e7-2a845d02897a	5233fa8a-e2c9-4a44-857a-0ec8e5c68a36	\N	2020-03-14 16:46:26	2022-12-01 10:23:13	\N	2020-04-28 06:37:43
a04b9609-bc71-4219-a5e3-6d61815cb405	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	4e3a22a4-98e9-4024-a519-7a05be9167c8	a04b9609-bc71-4219-a5e3-6d61815cb405	\N	2020-03-14 16:46:27	2022-12-01 10:23:16	\N	2020-04-28 06:37:43
5fec0244-e530-4afb-989c-4ea0eed0b2d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d85e860f-35a9-4406-8bc6-0e4051153600	5fec0244-e530-4afb-989c-4ea0eed0b2d8	\N	2020-03-14 16:46:26	2022-12-01 10:23:17	\N	2020-04-28 06:37:43
ad9b4337-cf91-4cff-bdea-4f25042b061b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9e8380ef-47fb-4968-add6-6aaebdebb939	ad9b4337-cf91-4cff-bdea-4f25042b061b	\N	2020-03-14 16:46:27	2022-12-01 10:23:21	\N	2020-04-28 06:37:43
882ccb47-9e44-46bb-a2f6-6c5a221f3802	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	882ccb47-9e44-46bb-a2f6-6c5a221f3802	\N	2020-03-14 16:46:27	2022-12-01 10:23:24	\N	2020-04-28 06:37:43
a04bfd33-b85f-4661-a712-709f3d233dde	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	cc30617c-14a9-478b-83d4-b0e836aa69c0	a04bfd33-b85f-4661-a712-709f3d233dde	\N	2020-03-14 16:46:27	2022-12-01 10:23:24	\N	2020-04-28 06:37:43
d11e2587-6053-413f-ac58-3c6d0a21dc25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	fd2e81be-ca4c-4320-9549-82c37f311556	d11e2587-6053-413f-ac58-3c6d0a21dc25	\N	2020-03-14 16:46:27	2022-12-01 10:23:24	\N	2020-04-28 06:37:43
5c301a15-728d-4141-9114-52a906cc0afd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	a16778e6-fe58-40af-a29b-6c47664d4064	5c301a15-728d-4141-9114-52a906cc0afd	\N	2020-03-14 16:46:27	2022-12-01 10:23:26	\N	2020-04-28 06:37:43
1b488a1d-9e0a-42e9-aec1-8ab3830c11cd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	4e27de9b-f65a-489f-8db8-7a6cb724fa6f	1b488a1d-9e0a-42e9-aec1-8ab3830c11cd	\N	2020-03-14 16:46:27	2022-12-01 10:23:28	\N	2020-04-28 06:37:43
801ea689-7ef7-47c2-9656-1b364f237571	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	ca91f612-c8f0-e111-8ad0-ed009c591d13	801ea689-7ef7-47c2-9656-1b364f237571	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
cc317e1c-122f-44d0-bb23-6422ea452f11	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	d191f612-c8f0-e111-8ad0-ed009c591d13	cc317e1c-122f-44d0-bb23-6422ea452f11	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
80590db8-7ee0-4478-80e6-f578b484e8a7	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	beb8f612-c8f0-e111-8ad1-ed009c591d13	80590db8-7ee0-4478-80e6-f578b484e8a7	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
98d3ef34-6c9e-4bc1-b822-c6a1bc945157	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	c6b8f612-c8f0-e111-8ad2-ed009c591d13	98d3ef34-6c9e-4bc1-b822-c6a1bc945157	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
b6245563-3c27-4b99-afcb-72007e2d7293	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	cbb8f612-c8f0-e111-8ad4-ed009c591d13	b6245563-3c27-4b99-afcb-72007e2d7293	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
96a10691-0b56-498e-be91-c56fa2e86d26	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	c1dff612-c8f0-e111-8ad5-ed009c591d13	96a10691-0b56-498e-be91-c56fa2e86d26	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
2f78e313-6457-4836-b5f6-9bd9da7f7f91	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	cddff612-c8f0-e111-8ad6-ed009c591d13	2f78e313-6457-4836-b5f6-9bd9da7f7f91	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
1ed82496-5aa4-4407-b087-b44ee4e44d0d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	d5dff612-c8f0-e111-8ad6-ed009c591d13	1ed82496-5aa4-4407-b087-b44ee4e44d0d	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
2f87a593-c3e4-42ab-9bac-be2e625e0977	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	e2dff612-c8f0-e111-8ad7-ed009c591d13	2f87a593-c3e4-42ab-9bac-be2e625e0977	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
84f9bb60-0515-428d-9867-b4517d4514bd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	e2dff612-c8f0-e111-8ad9-ed009c591d13	84f9bb60-0515-428d-9867-b4517d4514bd	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
49d42089-e1e6-4aa2-ae55-7681ad075d24	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	e2dff612-c8f0-e111-8ada-ed009c591d13	49d42089-e1e6-4aa2-ae55-7681ad075d24	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
d9f95377-2031-4241-9b30-36a2327b6001	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	de06f712-c8f0-e111-8ada-ed009c591d13	d9f95377-2031-4241-9b30-36a2327b6001	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
bb5b05a0-d211-4241-8700-c1a70c4fb41c	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	de06f712-c8f0-e111-8adc-ed009c591d13	bb5b05a0-d211-4241-8700-c1a70c4fb41c	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
7014c759-d558-4477-aa25-6fabd7440870	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	e006f712-c8f0-e111-8adc-ed009c591d13	7014c759-d558-4477-aa25-6fabd7440870	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
5127ee50-11b9-4d92-8bc8-63e8a193deac	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	e006f712-c8f0-e111-8add-ed009c591d13	5127ee50-11b9-4d92-8bc8-63e8a193deac	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
f1cbad1e-95f5-4d8d-b35b-83c599157b2e	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	01e4d2fe-955f-11e3-a768-ef448a6dff6c	f1cbad1e-95f5-4d8d-b35b-83c599157b2e	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
455ea123-8ed9-4318-bc1d-4254fb589369	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	23a4a150-e39f-4678-a0dc-80276c71e2e1	cd5fb568-5016-11e3-a476-ef4a7788f5d8	455ea123-8ed9-4318-bc1d-4254fb589369	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
c3516f77-1886-4ac2-a5fa-b0d2a601de05	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	6ec71de4-3507-11e4-be04-ef585e0b2e6f	c3516f77-1886-4ac2-a5fa-b0d2a601de05	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
0f7eed75-baac-45a9-87e3-3b2e0b56d738	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	79c0517e-2b5d-11e4-83b0-ef771d37da3e	0f7eed75-baac-45a9-87e3-3b2e0b56d738	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
52542caa-f962-4426-8e12-783f64c09233	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	0496f53c-32b1-11e4-8216-ef9284464dc7	52542caa-f962-4426-8e12-783f64c09233	\N	2023-09-19 12:19:52	2023-09-19 12:19:52	\N	2023-08-20 12:19:52
270cbf86-a3bc-44ca-9ea0-af010dadb165	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	3c911808-59eb-e111-9024-f1ea1f6b0b7c	270cbf86-a3bc-44ca-9ea0-af010dadb165	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
231fe6d6-191e-4189-abb6-b22358df07fd	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	ea31a02e-5aeb-e111-9024-f1ea1f6b0b7c	231fe6d6-191e-4189-abb6-b22358df07fd	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
b387a7b8-4e38-4cca-bc06-bc6e45ec36f1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	c3b00616-5517-11e3-9f7c-f32914d362b6	b387a7b8-4e38-4cca-bc06-bc6e45ec36f1	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
37f80c56-a233-4534-a70d-c618ad29b965	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	31ced3c6-3f87-11e3-8bf3-f37e2b7d6e6f	37f80c56-a233-4534-a70d-c618ad29b965	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
ae051042-1c7a-4901-a661-6d3d7d0b9809	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1a599053-e705-4ae8-a972-c2ca1f5e2dd7	101549aa-3508-11e4-a017-f3cb378c2879	ae051042-1c7a-4901-a661-6d3d7d0b9809	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
f33b848c-f9c0-4619-8f6d-5433fce5c632	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	4098a8bb-ad52-4a3d-8c2e-1788fb9e5572	30d958a4-3fe3-11e3-81ee-f3d63365e198	f33b848c-f9c0-4619-8f6d-5433fce5c632	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
c58cd223-f5bd-43ca-be53-5a57cca2c035	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	878541cb-4688-4cd9-916c-f694e6d0ae1e	c58cd223-f5bd-43ca-be53-5a57cca2c035	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
7d41f7cf-de5a-477e-b654-8da9743f54f9	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	65eceb62-3512-11e4-816e-f7e2b7eea91d	7d41f7cf-de5a-477e-b654-8da9743f54f9	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
cbc71729-4b83-4461-b726-b068a61af3d4	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	819e8920-f8ec-e111-9cc8-f9609896ec71	cbc71729-4b83-4461-b726-b068a61af3d4	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
1911407e-0fb5-4a8a-91c6-9fc285b041f1	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	819e8920-f8ec-e111-9cc9-f9609896ec71	1911407e-0fb5-4a8a-91c6-9fc285b041f1	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
7a61f2c1-71df-487d-88d6-63f78ef524c7	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	98c58920-f8ec-e111-9ccb-f9609896ec71	7a61f2c1-71df-487d-88d6-63f78ef524c7	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
c365ce4c-65fd-4b03-be71-0cd52e307114	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	9cc58920-f8ec-e111-9ccb-f9609896ec71	c365ce4c-65fd-4b03-be71-0cd52e307114	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
f1423973-e6f8-4cb4-9858-a737bcfdfb7e	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	c23a8a20-f8ec-e111-9cd2-f9609896ec71	f1423973-e6f8-4cb4-9858-a737bcfdfb7e	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
47099b8f-68b8-467c-ae33-d04ba361ae5b	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	c43a8a20-f8ec-e111-9cd5-f9609896ec71	47099b8f-68b8-467c-ae33-d04ba361ae5b	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
6dc5df92-b905-4a92-b16c-aa5a46c9bf12	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	906376c2-1463-4361-897e-a7ef5a19239d	1a883b38-e97c-403c-b2d4-5ccd13443726	\N	2020-03-14 16:46:27	2020-04-28 06:37:43	\N	2020-04-28 06:37:43
b8048a6e-413a-47b0-aa65-01ebab122a09	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	c60e92a2-99c2-4394-a48b-251540c8b96f	b8048a6e-413a-47b0-aa65-01ebab122a09	\N	2020-03-14 16:46:26	2022-12-01 10:22:48	\N	2020-04-28 06:37:43
01399f10-43ce-4de6-b312-543dcb9245c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	6a26772d-e188-455a-8bd8-9c8d729a618e	01399f10-43ce-4de6-b312-543dcb9245c9	\N	2020-03-14 16:46:27	2022-12-01 10:22:48	\N	2020-04-28 06:37:43
3f4525cc-245a-49ac-8e47-df93c04f0e55	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	2d18bbb3-fd39-46c5-98e0-19c1a9a240db	3f4525cc-245a-49ac-8e47-df93c04f0e55	\N	2020-03-14 16:46:26	2022-12-01 10:22:50	\N	2020-04-28 06:37:43
2eab05f2-210e-4512-a682-bdf70d4788f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	2eab05f2-210e-4512-a682-bdf70d4788f8	\N	2020-03-14 16:46:26	2022-12-01 10:22:51	\N	2020-04-28 06:37:43
04b40935-d469-467c-abcd-4b67f72edd91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	02c9180a-0b24-4ac4-b544-24d968340f61	04b40935-d469-467c-abcd-4b67f72edd91	\N	2020-03-14 16:46:26	2022-12-01 10:22:51	\N	2020-04-28 06:37:43
b46a900a-8d77-4160-a64f-81ae8ea0b23d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	4dbcf03d-8516-4f9c-a25f-679ac14e766f	b46a900a-8d77-4160-a64f-81ae8ea0b23d	\N	2020-03-14 16:46:27	2022-12-01 10:22:51	\N	2020-04-28 06:37:43
d3b7a9c8-683f-4c5b-8cc1-5bccd38fc94d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	d3b7a9c8-683f-4c5b-8cc1-5bccd38fc94d	\N	2020-03-14 16:46:28	2022-12-01 10:22:55	\N	2020-04-28 06:37:43
36716230-c8a7-4424-a823-e63a3bfded9b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	22278151-6aec-4b87-bfab-3bf8d1810468	36716230-c8a7-4424-a823-e63a3bfded9b	\N	2020-03-14 16:46:29	2022-12-01 10:22:58	\N	2020-04-28 06:37:43
682500d3-945e-4695-b3c7-4fd0b09d3630	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	682500d3-945e-4695-b3c7-4fd0b09d3630	\N	2020-03-14 16:46:28	2022-12-01 10:23:00	\N	2020-04-28 06:37:43
17652741-8650-4732-83bb-64f512501868	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	010a4695-214e-4efb-a13b-83ab9a7e5a9a	17652741-8650-4732-83bb-64f512501868	\N	2020-03-14 16:46:28	2022-12-01 10:23:00	\N	2020-04-28 06:37:43
ec77ec8f-583e-4a8b-aad4-60a23796a407	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	22160fc9-321a-40b5-849f-f8db354b9185	ec77ec8f-583e-4a8b-aad4-60a23796a407	\N	2020-03-14 16:46:28	2022-12-01 10:23:01	\N	2020-04-28 06:37:43
d11c2455-84ff-4ffb-9dac-cbc3e8b6929b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	607b1b72-46d2-11e5-ba50-1375139e8458	d11c2455-84ff-4ffb-9dac-cbc3e8b6929b	\N	2020-03-14 16:46:28	2022-12-01 10:23:01	\N	2020-04-28 06:37:44
1644e2b2-0459-4b1d-bed7-9e93e935e3b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	1644e2b2-0459-4b1d-bed7-9e93e935e3b3	\N	2020-03-14 16:46:28	2022-12-01 10:23:01	\N	2020-04-28 06:37:43
08c1b18a-bcca-4cae-9dc5-be15861776d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d0dca4af-4472-4232-af75-aaabf7ca88e7	08c1b18a-bcca-4cae-9dc5-be15861776d7	\N	2020-03-14 16:46:28	2022-12-01 10:23:02	\N	2020-04-28 06:37:43
10e2e0cc-e974-49d6-9d5a-98c4a8fd648a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	dff2a0f4-5123-11e5-8831-73515c7ac634	10e2e0cc-e974-49d6-9d5a-98c4a8fd648a	\N	2020-03-14 16:46:29	2022-12-01 10:23:03	\N	2020-04-28 06:37:43
5fde1a33-fc7f-415a-876e-1c1cc925a233	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7b6763fc-6f9f-11e3-b017-03efaa0c94af	5fde1a33-fc7f-415a-876e-1c1cc925a233	\N	2020-03-14 16:46:28	2022-12-01 10:23:07	\N	2020-04-28 06:37:43
8780de98-d4dd-43a6-bea0-221518260ce3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	900ffa20-46cc-11e5-8abe-0337176d8d23	8780de98-d4dd-43a6-bea0-221518260ce3	\N	2020-03-14 16:46:28	2022-12-01 10:23:10	\N	2020-04-28 06:37:43
20e378ff-470e-4906-beef-a5220438e6dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	20e378ff-470e-4906-beef-a5220438e6dc	\N	2020-03-14 16:46:28	2022-12-01 10:23:10	\N	2020-04-28 06:37:45
dd1a63a8-3eef-42d4-8c60-21faffdaf7cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	dd1a63a8-3eef-42d4-8c60-21faffdaf7cf	\N	2020-03-14 16:46:28	2022-12-01 10:23:11	\N	2020-04-28 06:37:43
b296d1ca-0752-4623-90e7-fb2ed45bcfb7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	6b031760-aef5-4dbb-b520-01e6685a54d1	b296d1ca-0752-4623-90e7-fb2ed45bcfb7	\N	2020-03-14 16:46:28	2022-12-01 10:23:11	\N	2020-04-28 06:37:43
282ad56e-1cd5-4872-ab11-9c3b187876ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9833a660-4b73-11e5-934e-37a2f6ed830d	282ad56e-1cd5-4872-ab11-9c3b187876ed	\N	2020-03-14 16:46:29	2022-12-01 10:23:11	\N	2020-04-28 06:37:43
c7691806-74c3-4d00-8612-b4385a625d13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	0312c3d7-fde1-47cf-96ce-1f87a4228787	c7691806-74c3-4d00-8612-b4385a625d13	\N	2020-03-14 16:46:28	2022-12-01 10:23:12	\N	2020-04-28 06:37:44
348200d4-6b31-4fd4-9b24-cfc484bd81bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d5b3a578-1613-474e-865b-0a47f3a64167	348200d4-6b31-4fd4-9b24-cfc484bd81bd	\N	2020-03-14 16:46:28	2022-12-01 10:23:13	\N	2020-04-28 06:37:43
291e5cab-d66e-44e9-81cf-71331b622204	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	14fba9a1-6ca4-4937-84e7-2a845d02897a	291e5cab-d66e-44e9-81cf-71331b622204	\N	2020-03-14 16:46:28	2022-12-01 10:23:13	\N	2020-04-28 06:37:44
b57f1353-ed65-4163-8937-e14bfb3b2640	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	b57f1353-ed65-4163-8937-e14bfb3b2640	\N	2020-03-14 16:46:28	2022-12-01 10:23:16	\N	2020-04-28 06:37:43
4becf6fd-f1ee-4317-8d5b-c23ccb455a6b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	8a5395ea-c758-4eb7-b436-571f527789a2	4becf6fd-f1ee-4317-8d5b-c23ccb455a6b	\N	2020-03-14 16:46:28	2022-12-01 10:23:16	\N	2020-04-28 06:37:43
acb32ddf-3ae7-4108-a8e8-7777ae2826cd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	8b4ea31e-4aa0-427e-a65f-928b232d7f14	acb32ddf-3ae7-4108-a8e8-7777ae2826cd	\N	2020-03-14 16:46:28	2022-12-01 10:23:18	\N	2020-04-28 06:37:43
16f98c8a-5ca5-46f4-bfb3-60e082b04f73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	2d18bbb3-fd39-46c5-98e0-19c1a9a240db	16f98c8a-5ca5-46f4-bfb3-60e082b04f73	\N	2020-03-14 16:46:28	2022-12-01 10:23:23	\N	2020-04-28 06:37:44
b4b7e047-e9d1-4362-bec5-06160de32dcf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	8e10391f-07fe-41b9-84c7-106974b83db3	b4b7e047-e9d1-4362-bec5-06160de32dcf	\N	2020-03-14 16:46:28	2022-12-01 10:23:24	\N	2020-04-28 06:37:43
72d762e5-7bb7-415a-8846-de97d8cc638a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	54976902-8866-4627-a970-0abcb6abb6f9	72d762e5-7bb7-415a-8846-de97d8cc638a	\N	2020-03-14 16:46:28	2022-12-01 10:23:24	\N	2020-04-28 06:37:42
ffc6556b-1484-4389-8aa9-7822bb72c064	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	52d5486a-4544-11e5-b3ea-131ef06916b5	ffc6556b-1484-4389-8aa9-7822bb72c064	\N	2020-03-14 16:46:28	2022-12-01 10:23:25	\N	2020-04-28 06:37:43
f394ba80-e441-4a84-87f2-47c6e9df7bfa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	f394ba80-e441-4a84-87f2-47c6e9df7bfa	\N	2020-03-14 16:46:28	2022-12-01 10:23:25	\N	2020-04-28 06:37:43
43622fb3-addd-4e74-8af2-e88882c96049	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	3ad03a6a-9caa-40e4-a060-62e1680cd17b	43622fb3-addd-4e74-8af2-e88882c96049	\N	2020-03-14 16:46:27	2022-12-01 10:23:26	\N	2020-04-28 06:37:44
c41c17b4-025d-48ec-961e-dc122e81b2ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	2344b81a-f727-41d0-bdcf-b4fbc2557e5b	c41c17b4-025d-48ec-961e-dc122e81b2ef	\N	2020-03-14 16:46:28	2022-12-01 10:23:29	\N	2020-04-28 06:37:43
9b3edb89-5622-4ebf-bf2b-a9541c9ebe46	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	c43a8a20-f8ec-e111-9cd6-f9609896ec71	9b3edb89-5622-4ebf-bf2b-a9541c9ebe46	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
c087055c-147f-4f39-a7d6-b0d0dada0c57	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	d2618a20-f8ec-e111-9cd9-f9609896ec71	c087055c-147f-4f39-a7d6-b0d0dada0c57	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
cd54212c-f4fb-4dcd-8297-2e696634d5de	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	9f409306-6423-49dd-99d3-4dfb34f77520	28258b20-f8ec-e111-9ce6-f9609896ec71	cd54212c-f4fb-4dcd-8297-2e696634d5de	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
62c33258-da9e-4b87-911c-9735c070a3e5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a867c6b0-179a-4c85-b534-4ce74d72c343	0c9dcb16-46f8-11e3-912c-fb6a44e8051d	62c33258-da9e-4b87-911c-9735c070a3e5	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
49c47dbe-7e1d-4b24-b703-3337a7f374b2	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	66ee95cc-2f7e-11e4-9a8e-ffb612b47c1b	49c47dbe-7e1d-4b24-b703-3337a7f374b2	\N	2023-09-19 12:19:53	2023-09-19 12:19:53	\N	2023-08-20 12:19:53
e8ffcc20-13cf-47ce-b552-436a4a5d3c3b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	d9267e77-220c-4668-8911-845797905234	7d771dd9-0b9a-4620-97f3-d672403f3110	e8ffcc20-13cf-47ce-b552-436a4a5d3c3b	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
e15e49de-a8c5-49cb-b933-0e72768f073f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	f46fb88c-f4be-413e-af46-d7052e6835cb	e15e49de-a8c5-49cb-b933-0e72768f073f	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
83d0cc95-fb61-42ea-8cb5-e8bf94e22200	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	a93e50ad-f710-e211-90d3-d74a76476707	83d0cc95-fb61-42ea-8cb5-e8bf94e22200	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
a55c4263-41d8-477c-b5a1-ce5e79cc8499	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	60d0839f-0047-4750-a338-d86075d8c54a	a55c4263-41d8-477c-b5a1-ce5e79cc8499	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
c268941b-69bb-404d-bfb2-269e1b0e1c1c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	75582d3c-5a50-452c-9e6f-d867d676690d	c268941b-69bb-404d-bfb2-269e1b0e1c1c	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
eee4a4ee-4415-410e-9e84-3f95077b7ec2	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	c22c12c6-5260-11e3-ae41-dba3fdcb8ddd	eee4a4ee-4415-410e-9e84-3f95077b7ec2	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
29b2b076-47b6-44ee-ab65-3ec924e6555b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	b301f3d8-660b-11e3-98f4-dba96959f560	29b2b076-47b6-44ee-ab65-3ec924e6555b	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
118563c8-4092-44a0-9a43-fa2d0647742d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	95453e8a-9461-4ad3-84c1-dca061771d89	118563c8-4092-44a0-9a43-fa2d0647742d	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
013649fc-691b-4d4a-b263-ec44d7cd5c71	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	9f1c8f9f-7a0b-4948-ad19-ddbd4d6dc1d7	013649fc-691b-4d4a-b263-ec44d7cd5c71	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
ff3e3447-8539-452f-9ccb-3fa93eca3830	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	171f81bf-d5dc-4d29-955a-e0cd162b6575	ff3e3447-8539-452f-9ccb-3fa93eca3830	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
4cdfab61-e978-406d-856e-d6fec38fd9a1	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	c9d1591d-4f67-4828-b180-e1c49a6cc7e0	4cdfab61-e978-406d-856e-d6fec38fd9a1	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
8b623f4f-deb9-4156-b071-92bba8fbcc6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9cebf2d1-99f6-4b81-a7e7-d3fd26767c59	de6afe0f-6efe-41ea-a48e-ba033411340a	\N	2020-03-14 16:46:28	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-04-28 06:37:43
a6f3e3dc-a48a-4ba5-af7f-f48bf02fdd8d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	b7d6d3f4-77ae-41df-8c21-56e8731513a1	0832f0cf-5db5-4966-b3e8-f0813ed5bde5	\N	2020-03-14 16:46:28	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-04-28 06:37:45
6e3f4b6d-df97-43ec-a34a-32c15a1f651c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	4a251997-80ef-44d2-a07a-277acc531e90	\N	2020-03-14 16:46:28	2020-04-28 06:37:44	\N	2020-04-28 06:37:44
d05f2b54-78e0-4ec7-9da8-b58c91d1132b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	d05f2b54-78e0-4ec7-9da8-b58c91d1132b	\N	2020-03-14 16:46:28	2022-12-01 10:22:49	\N	2020-04-28 06:37:43
bebc281b-b13c-445f-8372-f1c10bcda9d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	bebc281b-b13c-445f-8372-f1c10bcda9d4	\N	2020-03-14 16:46:28	2022-12-01 10:22:50	\N	2020-04-28 06:37:43
8855c954-68f8-41db-9eb0-7fd11f243c73	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	e131badd-15c9-4911-8c81-1d30249b7d73	8855c954-68f8-41db-9eb0-7fd11f243c73	\N	2020-03-14 16:46:28	2022-12-01 10:22:51	\N	2020-04-28 06:37:44
345d3d0c-c498-4fc6-84da-f586cef21789	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7033d6a0-a087-4922-a949-32763edc8bc4	345d3d0c-c498-4fc6-84da-f586cef21789	\N	2020-03-14 16:46:28	2022-12-01 10:22:51	\N	2020-04-28 06:37:43
84bb71c0-54f7-42fd-8dc6-b3ad9a6e9bed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	5fb28ec2-45dd-45c4-8021-0e597172c690	84bb71c0-54f7-42fd-8dc6-b3ad9a6e9bed	\N	2020-03-14 16:46:27	2022-12-01 10:22:52	\N	2020-04-28 06:37:43
1b3df97f-1255-497a-ba6d-289d9d921f06	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	edbf1ed9-b137-4d28-8af1-a22ab23be53b	1b3df97f-1255-497a-ba6d-289d9d921f06	\N	2020-03-14 16:46:29	2022-12-01 10:22:54	\N	2020-04-28 06:37:44
851d4fcf-0da8-4801-bb8a-d86e9637be52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	8e480efa-b4ae-4ecb-8b21-1ad77d82eb6d	851d4fcf-0da8-4801-bb8a-d86e9637be52	\N	2020-03-14 16:46:28	2022-12-01 10:22:54	\N	2020-04-28 06:37:44
e21eb99d-cce9-4f63-ab3f-f7e511d67494	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	52ae8172-5750-4387-badd-79b17d2081aa	e21eb99d-cce9-4f63-ab3f-f7e511d67494	\N	2020-03-14 16:46:29	2022-12-01 10:22:54	\N	2020-04-28 06:37:44
9158d9e2-b570-4b93-b209-d0f510c8b6bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d6276643-bada-4ca6-a7d6-27f02efbd2c2	9158d9e2-b570-4b93-b209-d0f510c8b6bc	\N	2020-03-14 16:46:29	2022-12-01 10:22:58	\N	2020-04-28 06:37:44
a895b068-d0b5-4d3b-b149-fcc9b2748271	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	698259da-b323-4524-92e3-706ec09179bd	a895b068-d0b5-4d3b-b149-fcc9b2748271	\N	2020-03-14 16:46:29	2022-12-01 10:22:59	\N	2020-04-28 06:37:44
eab074ec-97a7-4ff0-ab13-d1f1ff862865	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	e0e38c52-da5a-44a8-ac92-411718cd6332	eab074ec-97a7-4ff0-ab13-d1f1ff862865	\N	2020-03-14 16:46:29	2022-12-01 10:22:59	\N	2020-04-28 06:37:44
ab8056dc-f21c-4244-8599-b0155b8eaea1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	5b61121a-264f-490f-86b1-551372be86d1	ab8056dc-f21c-4244-8599-b0155b8eaea1	\N	2020-03-14 16:46:29	2022-12-01 10:22:59	\N	2020-04-28 06:37:44
eb945cdb-6292-4add-89af-d3b9ed17baee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	eb945cdb-6292-4add-89af-d3b9ed17baee	\N	2020-03-14 16:46:28	2022-12-01 10:23:00	\N	2020-04-28 06:37:44
59407d7f-3dae-463a-a835-fb595aa467ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ff07bc11-35f4-4ff1-a749-78e30f56e52c	59407d7f-3dae-463a-a835-fb595aa467ba	\N	2020-03-14 16:46:29	2022-12-01 10:23:00	\N	2020-04-28 06:37:44
30870803-d9d8-40c8-a77b-e4b01c609c71	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	b35c01a3-37d8-4b9c-921d-65a382a1ca70	30870803-d9d8-40c8-a77b-e4b01c609c71	\N	2020-03-14 16:46:29	2022-12-01 10:23:06	\N	2020-04-28 06:37:44
58088b15-ab2a-4589-a3ee-5dfb441b9e99	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	c8ee9713-6348-4525-ac7a-27b373d312df	58088b15-ab2a-4589-a3ee-5dfb441b9e99	\N	2020-03-14 16:46:29	2022-12-01 10:23:08	\N	2020-04-28 06:37:44
48a2a65e-fdc4-4c54-9577-b935ea83289e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	afab5d0b-c4da-455e-bd0a-8644da49ab0f	48a2a65e-fdc4-4c54-9577-b935ea83289e	\N	2020-03-14 16:46:29	2022-12-01 10:23:11	\N	2020-04-28 06:37:44
af618755-58b8-4505-a310-d8d75468ec17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	6402418c-54f9-11e5-9e54-5397b782050d	af618755-58b8-4505-a310-d8d75468ec17	\N	2020-03-14 16:46:29	2022-12-01 10:23:13	\N	2020-04-28 06:37:44
db3cc79b-341f-46b0-89a0-a0eaf178b2b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	db3cc79b-341f-46b0-89a0-a0eaf178b2b9	\N	2020-03-14 16:46:29	2022-12-01 10:23:13	\N	2020-04-28 06:37:44
ddb6eaaa-34c4-4051-8714-7b783fb71af8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d57f4561-8cb1-42ae-940e-7943cdae287b	ddb6eaaa-34c4-4051-8714-7b783fb71af8	\N	2020-03-14 16:46:29	2022-12-01 10:23:15	\N	2020-04-28 06:37:44
abca4011-910a-4f68-b12d-49258cf73b5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	f80b678d-bb43-4915-9ef0-22b1d2320638	abca4011-910a-4f68-b12d-49258cf73b5a	\N	2020-03-14 16:46:29	2022-12-01 10:23:16	\N	2020-04-28 06:37:44
f18d1e9f-ec24-42f2-ad1d-8287159428b1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	f18d1e9f-ec24-42f2-ad1d-8287159428b1	\N	2020-03-14 16:46:29	2022-12-01 10:23:16	\N	2020-04-28 06:37:44
7677d363-6f19-441e-a5b5-cc24d5bbc727	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	c795df6e-a22f-478f-9005-76d13d30bab4	7677d363-6f19-441e-a5b5-cc24d5bbc727	\N	2020-03-14 16:46:29	2022-12-01 10:23:16	\N	2020-04-28 06:37:44
221cabb1-658f-4f2b-80d0-a44bdb234e1a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	1d64c4a6-b263-441e-82e2-763c790c3c05	221cabb1-658f-4f2b-80d0-a44bdb234e1a	\N	2020-03-14 16:46:29	2022-12-01 10:23:17	\N	2020-04-28 06:37:44
6b0a8893-6460-4345-a79d-b460db405e50	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	06555036-10af-41b8-b767-260f6d366218	6b0a8893-6460-4345-a79d-b460db405e50	\N	2020-03-14 16:46:29	2022-12-01 10:23:21	\N	2020-04-28 06:37:44
989846b1-2d9d-49d7-a1bd-0ac9b8da2f6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	04a45a78-7f1b-4cad-a70f-732efa5f7985	989846b1-2d9d-49d7-a1bd-0ac9b8da2f6d	\N	2020-03-14 16:46:29	2022-12-01 10:23:25	\N	2020-04-28 06:37:44
c317ec51-b50c-4c5f-98f0-1472b31a8bc9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	bd4085a1-82ec-450b-9507-7924581dc0fc	c317ec51-b50c-4c5f-98f0-1472b31a8bc9	\N	2020-03-14 16:46:29	2022-12-01 10:23:29	\N	2020-04-28 06:37:44
c19bb984-0534-4788-aaa9-9e6fdfcc3efa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	c593fef2-46d2-11e5-b14e-8fa23f386b5a	c19bb984-0534-4788-aaa9-9e6fdfcc3efa	\N	2020-03-14 16:46:29	2022-12-01 10:23:29	\N	2020-04-28 06:37:44
614650ed-1993-4130-a38e-0d091073adc5	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	66733d54-6740-4d08-a8a1-4bb29930b058	6342d594-b0f0-e111-866b-370f0c648e74	614650ed-1993-4130-a38e-0d091073adc5	\N	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-08-20 12:20:11
102438ca-15b7-4e2d-9e9b-ddc25034fccb	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	1c0df766-8ecd-4e28-b603-8fd0517cce25	aeded594-b0f0-e111-8671-370f0c648e74	102438ca-15b7-4e2d-9e9b-ddc25034fccb	\N	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-08-20 12:20:11
db9b86b5-b22b-4b98-8c79-f581a32b5b0d	3fc1bd47-f7d8-48a2-bfd0-50584ee95b6e	20231	a994d615-2067-4e33-babf-1f8acd0d2e3e	cd4cb471-8858-bd11-a48d-97539b3a7bd9	db9b86b5-b22b-4b98-8c79-f581a32b5b0d	\N	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-09-19 12:20:11	2023-08-20 12:20:11
19f5e372-09cd-46b8-a5bc-2cbfc52a1aca	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	d95a2f78-33d8-11e4-b8b7-e30c44cc6934	19f5e372-09cd-46b8-a5bc-2cbfc52a1aca	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
30e2a309-dd0d-42f3-9f8c-1f209ae116e3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	56ed7cf8-475b-11e3-8e07-e3a3837e26e3	30e2a309-dd0d-42f3-9f8c-1f209ae116e3	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
f5cb7dbb-a59a-4381-b059-03767ccac596	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	d16559d0-3042-11e4-ab96-e3c0bba99530	f5cb7dbb-a59a-4381-b059-03767ccac596	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
042020bd-f0c5-4656-9707-4dd9ec9c04ed	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	1fc6fa32-a3a8-42d1-b98e-e506a05f3488	042020bd-f0c5-4656-9707-4dd9ec9c04ed	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
2a27d58b-7b5e-4941-9f7a-f6183356b376	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	383bd0df-cd09-4b64-930d-e585ab1d5879	2a27d58b-7b5e-4941-9f7a-f6183356b376	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
18768ec5-4a31-4e90-9679-e075876b8f8a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	ffe113ff-49d9-4487-8aed-e5a141f57fdb	18768ec5-4a31-4e90-9679-e075876b8f8a	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
77777b9c-1de6-40f6-87f8-c6ca500b15f2	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	9a6b690a-3ae4-11e3-8a6e-e70a81c72246	77777b9c-1de6-40f6-87f8-c6ca500b15f2	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
58c7978f-772c-4915-8265-35d180a5edd2	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	485868c8-6854-11e3-9e70-e763be17e640	58c7978f-772c-4915-8265-35d180a5edd2	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
7ce89f5e-5335-4290-bef4-36deac0d3682	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	0af1cdaa-3052-11e4-8ca2-e79899bb9b06	7ce89f5e-5335-4290-bef4-36deac0d3682	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
dabac374-3dcf-4dc0-83e6-61db99b5359b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	3613ef24-bbf5-44a2-828b-eb065c0997c6	dabac374-3dcf-4dc0-83e6-61db99b5359b	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
17b56d7d-8f64-429a-9a4e-1abe156da156	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	d8eca9f8-4810-11e3-b969-eb22e99eaac7	17b56d7d-8f64-429a-9a4e-1abe156da156	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
d16ccc1a-0414-4e81-8f40-12319d128937	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	b722daea-41f2-11e4-a54c-ebbfbd7fdf8b	d16ccc1a-0414-4e81-8f40-12319d128937	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
98e32539-2448-4785-86a9-7f3c8ced4a35	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	03af691c-5ce5-11e3-9c11-ebf502352b2f	98e32539-2448-4785-86a9-7f3c8ced4a35	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
94188ad5-ae1f-455f-9246-a6c356b0de6f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	f12ac0d8-3a84-11e4-ae85-ebfaa75b50c3	94188ad5-ae1f-455f-9246-a6c356b0de6f	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
82d23e73-b817-496f-8115-7be95cb58bd4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	ce13f5d1-953f-45c7-b063-ee802a6922af	82d23e73-b817-496f-8115-7be95cb58bd4	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
40ca9477-0842-48cf-b564-c9532a5242b7	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	ac4a6490-33af-46c9-8214-eecab8687800	40ca9477-0842-48cf-b564-c9532a5242b7	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
f695262d-18ac-473a-a497-c5e09520ebbd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	777d9a08-2517-4adf-a008-70c0d006b0a5	35502492-feb7-438d-b02e-fbc4510d3fd5	\N	2020-03-14 16:46:29	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-04-28 06:37:44
0c58906b-a87f-4a32-bc5a-f3754bf87ade	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	097f5676-e6b8-4033-9b17-43eb6a4145bf	0c58906b-a87f-4a32-bc5a-f3754bf87ade	\N	2020-03-14 16:46:29	2022-12-01 10:22:48	\N	2020-04-28 06:37:44
17f25564-47b5-436f-85cc-9a23a745d99a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	a968b612-4bac-11e5-bce0-9f0e431a474f	17f25564-47b5-436f-85cc-9a23a745d99a	\N	2020-03-14 16:46:29	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
4f76f935-80ff-4f24-b95b-314f0a3e78de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	4f76f935-80ff-4f24-b95b-314f0a3e78de	\N	2020-03-14 16:46:29	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
b76b18f7-23ef-4ab0-a0cc-f6727ff353fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	67390022-7626-4bf5-a07f-1f5dd137f72e	b76b18f7-23ef-4ab0-a0cc-f6727ff353fa	\N	2020-03-14 16:46:28	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
a794a4df-d979-4b04-b46f-d803d83f5e9a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	568a2d30-3a78-43fd-81ea-2c98ec3d3865	a794a4df-d979-4b04-b46f-d803d83f5e9a	\N	2020-03-14 16:46:29	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
f4caa4aa-10ee-4231-bd9c-8d6d9b9890f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d993ad11-d98a-4803-85a4-a446d7b9d4c7	f4caa4aa-10ee-4231-bd9c-8d6d9b9890f7	\N	2020-03-14 16:46:29	2022-12-01 10:22:49	\N	2020-04-28 06:37:43
6014f55d-a0f6-4fb0-924d-4e3077fcc0ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	00e6f0c6-c214-4588-90c0-4a271deaa2c9	6014f55d-a0f6-4fb0-924d-4e3077fcc0ba	\N	2020-03-14 16:46:29	2022-12-01 10:22:50	\N	2020-04-28 06:37:44
8e76c007-79e6-4d1f-8fb8-e187f3eb8ef8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	808f4853-72f6-44e9-8555-4e07f494c8cf	8e76c007-79e6-4d1f-8fb8-e187f3eb8ef8	\N	2020-03-14 16:46:29	2022-12-01 10:22:50	\N	2020-04-28 06:37:44
b2bdc5c4-e4bd-497a-90b6-dca2c37d145a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	81ed9f12-dc17-4947-aeaa-5105be4af095	b2bdc5c4-e4bd-497a-90b6-dca2c37d145a	\N	2020-03-14 16:46:29	2022-12-01 10:22:50	\N	2020-04-28 06:37:44
64034f60-5097-4b98-9d63-aa08ad8c9326	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9b057256-628e-4516-a951-a78bd3651d4b	64034f60-5097-4b98-9d63-aa08ad8c9326	\N	2020-03-14 16:46:29	2022-12-01 10:22:52	\N	2020-04-28 06:37:44
24ac64b0-053d-43ff-9fe5-b3445e0c1718	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	88c6acc3-882c-418e-b96e-f83ccccd7f79	24ac64b0-053d-43ff-9fe5-b3445e0c1718	\N	2020-03-14 16:46:30	2022-12-01 10:22:53	\N	2020-04-28 06:37:45
708a6328-79a6-4cc3-8440-93be3434e0d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	36aa6f27-73dc-4d6c-98e8-cb7a01d1f686	708a6328-79a6-4cc3-8440-93be3434e0d9	\N	2020-03-14 16:46:30	2022-12-01 10:22:56	\N	2020-04-28 06:37:44
ff30af49-4645-4dbf-94ff-e1b1f62306ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	645aba46-378c-11e4-a83f-afbd60abf5c3	ff30af49-4645-4dbf-94ff-e1b1f62306ae	\N	2020-03-14 16:46:29	2022-12-01 10:22:56	\N	2020-04-28 06:37:44
20bbe4c0-e356-41a7-bde1-70cf212b22e2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	20bbe4c0-e356-41a7-bde1-70cf212b22e2	\N	2020-03-14 16:46:30	2022-12-01 10:22:57	\N	2020-04-28 06:37:44
8288571f-356b-4d18-bbe4-b0aa0cfb0b4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	60c2ff20-4b6c-11e5-958c-b39420b5676f	8288571f-356b-4d18-bbe4-b0aa0cfb0b4d	\N	2020-03-14 16:46:30	2022-12-01 10:22:58	\N	2020-04-28 06:37:44
97761d73-193d-49d8-a447-c59a216f62ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	97761d73-193d-49d8-a447-c59a216f62ef	\N	2020-03-14 16:46:31	2022-12-01 10:22:58	\N	2020-04-28 06:37:43
152afc25-ee84-42f4-b706-c940ba465ec9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ff732935-72e5-4865-bb47-f3e0cb79d9fa	152afc25-ee84-42f4-b706-c940ba465ec9	\N	2020-03-14 16:46:30	2022-12-01 10:23:00	\N	2020-04-28 06:37:45
40d00548-0b26-40ff-9eed-950143e5490e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	91317e32-9ec9-468c-bf5b-ef891856d180	40d00548-0b26-40ff-9eed-950143e5490e	\N	2020-03-14 16:46:30	2022-12-01 10:23:01	\N	2020-04-28 06:37:43
1a21112f-a370-4ada-839c-bc0c5e66f642	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	fa092490-4b74-11e5-a33d-db9868dda03f	1a21112f-a370-4ada-839c-bc0c5e66f642	\N	2020-03-14 16:46:30	2022-12-01 10:23:05	\N	2020-04-28 06:37:44
4b2c202d-7789-41e1-858b-dd24f04a9883	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d313aa86-3092-4ceb-8e53-fabcecc2a37a	4b2c202d-7789-41e1-858b-dd24f04a9883	\N	2020-03-14 16:46:30	2022-12-01 10:23:10	\N	2020-04-28 06:37:45
28146129-5039-4711-a7d4-f20ee29ab151	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ac0343f2-09a5-4b95-b38f-cd379433d96c	28146129-5039-4711-a7d4-f20ee29ab151	\N	2020-03-14 16:46:30	2022-12-01 10:23:11	\N	2020-04-28 06:37:44
7266b115-36b1-42ea-abb9-85753028edac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	cf3761de-7aae-48d8-aec8-088c3e87e8ed	7266b115-36b1-42ea-abb9-85753028edac	\N	2020-03-14 16:46:30	2022-12-01 10:23:15	\N	2020-04-28 06:37:45
ca9a620e-e173-4e76-8d09-e1343dc9cd4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	06b71793-3a86-4c6b-9000-717dca267295	ca9a620e-e173-4e76-8d09-e1343dc9cd4d	\N	2020-03-14 16:46:29	2022-12-01 10:23:16	\N	2020-04-28 06:37:44
3f02aee9-a839-4575-87e6-9326dff2fcff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	74b1c647-0142-4355-a2af-d5a15f1d2358	3f02aee9-a839-4575-87e6-9326dff2fcff	\N	2020-03-14 16:46:30	2022-12-01 10:23:19	\N	2020-04-28 06:37:43
a2619721-3417-47db-bb14-b394d6c98f09	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	54894cf6-ecf9-44c5-87e8-b87e6bf62120	a2619721-3417-47db-bb14-b394d6c98f09	\N	2020-03-14 16:46:30	2022-12-01 10:23:22	\N	2020-04-28 06:37:44
aa8867bf-051e-417f-82c7-bfa1ec118c34	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	ad705d8a-429e-11e5-a989-af44a02d940a	aa8867bf-051e-417f-82c7-bfa1ec118c34	\N	2020-03-14 16:46:30	2022-12-01 10:23:22	\N	2020-04-28 06:37:44
46d9b26d-f6a5-4b2a-8b3d-965c7a716eb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	e3549675-96bb-4c36-9d4e-b034c5de4b80	46d9b26d-f6a5-4b2a-8b3d-965c7a716eb4	\N	2020-03-14 16:46:30	2022-12-01 10:23:24	\N	2020-04-28 06:37:44
5c9e828d-1a63-4e56-a0f1-99773ef32675	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	2704f9d0-22fc-11e4-859d-e78b145c39c9	5c9e828d-1a63-4e56-a0f1-99773ef32675	\N	2020-03-14 16:46:30	2022-12-01 10:23:24	\N	2020-04-28 06:37:44
f8fdbdfd-4938-4b92-ae0c-d90fd877f689	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	29d04843-7d39-48d9-9720-ea6c03d77e52	f8fdbdfd-4938-4b92-ae0c-d90fd877f689	\N	2020-03-14 16:46:30	2022-12-01 10:23:24	\N	2020-04-28 06:37:44
b0cdd7d6-2574-472d-ad27-d2d9ad6079f9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	8c54af21-d3fa-4eba-b89f-b628ab9fa013	b0cdd7d6-2574-472d-ad27-d2d9ad6079f9	\N	2020-03-14 16:46:30	2022-12-01 10:23:25	\N	2020-04-28 06:37:44
c2da23f9-718e-44fd-bc26-d3cc8841878c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	6e12f9fd-e106-472d-8364-ce7da552e702	c2da23f9-718e-44fd-bc26-d3cc8841878c	\N	2020-03-14 16:46:30	2022-12-01 10:23:26	\N	2020-04-28 06:37:44
1e93c756-f578-44ed-9b2c-a5fe8e822168	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	beb52866-067c-4257-aa11-ac304217924c	1e93c756-f578-44ed-9b2c-a5fe8e822168	\N	2020-03-14 16:46:30	2022-12-01 10:23:28	\N	2020-04-28 06:37:44
130e5c17-e77e-4c55-8d19-797b18431a30	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	95d9a4a0-3a99-11e4-bc7d-ef8e2a7335bf	130e5c17-e77e-4c55-8d19-797b18431a30	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
37c9165f-553b-4057-8f07-55d19ebad8be	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	77eb1816-b320-11e4-846c-efbf3a59bbb1	37c9165f-553b-4057-8f07-55d19ebad8be	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
efb5182e-d979-4cae-b3d9-834f87bdf54a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	778a0612-3954-11e3-a9a4-f3960ab41375	efb5182e-d979-4cae-b3d9-834f87bdf54a	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
e3e3efcd-7b05-413d-a9c7-d4a2f4733e5c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c1e7f994-e0c0-478d-aff3-6774262fe03f	61c652c2-43a4-470e-8c31-f3fa00cc70fa	e3e3efcd-7b05-413d-a9c7-d4a2f4733e5c	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
0f74a25c-70dd-45a4-8721-9d8413e310b8	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c1e7f994-e0c0-478d-aff3-6774262fe03f	95bf6b55-3701-e211-a519-f5c59280c082	0f74a25c-70dd-45a4-8721-9d8413e310b8	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
091a5ec1-5b25-469e-9738-a7221c99dc67	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	dcac5c36-3a9b-11e4-9d66-f7136444afcf	091a5ec1-5b25-469e-9738-a7221c99dc67	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
4e6549ea-9957-45da-81a8-85292a405630	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	bb7866bc-3051-11e4-a2e2-f7583835c4ca	4e6549ea-9957-45da-81a8-85292a405630	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
c49ea7b3-49b0-4d01-8e6c-74ece56b666a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	133aeb4e-3a8a-11e4-a80c-f76c78ee85bf	c49ea7b3-49b0-4d01-8e6c-74ece56b666a	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
7063a39c-6840-4fb0-8653-2121c3a1dcaa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	1f59f4f2-9003-e211-8560-17962475f905	7063a39c-6840-4fb0-8653-2121c3a1dcaa	\N	2023-10-03 11:14:41	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
63567015-82da-47fa-9c26-c7d21ce1461a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	180801b9-9103-e211-8560-17962475f905	63567015-82da-47fa-9c26-c7d21ce1461a	\N	2023-10-03 11:14:41	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
cba7edb9-7144-4d62-ad05-c22cf94cdc72	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	d29324b0-6ef3-11e3-a4d4-23ef5f321119	cba7edb9-7144-4d62-ad05-c22cf94cdc72	\N	2023-10-03 11:14:41	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
847a007b-e4ef-43d8-a8fc-b7e19f34dac1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	a4195ffe-991a-e211-978e-3b930968aceb	847a007b-e4ef-43d8-a8fc-b7e19f34dac1	\N	2023-10-03 11:14:41	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
092b5af0-438d-4c4b-ade2-00cd15bf4312	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	7150b495-1628-e211-b4b8-6bfa6b3aea03	092b5af0-438d-4c4b-ade2-00cd15bf4312	\N	2023-10-03 11:14:41	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
60e69c68-95b1-46f2-8e7d-1a204cbfed53	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	8b619c5b-c7e2-47f1-9718-888937f9084c	60e69c68-95b1-46f2-8e7d-1a204cbfed53	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
ae00d63e-a24e-43c7-b15f-3a055ec4a075	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	34fc02aa-8c88-11e3-8f45-97026e699162	ae00d63e-a24e-43c7-b15f-3a055ec4a075	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
d5866fb2-0e90-40a2-a97a-a27fc8ad1a50	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	a97a07ba-3fe0-11e4-89a5-a76914e7eb49	d5866fb2-0e90-40a2-a97a-a27fc8ad1a50	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
5ccf5a5d-bde3-432a-a07b-2bb509bd2be8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	2f274181-6333-4dad-af2b-b26b48362d9f	5ccf5a5d-bde3-432a-a07b-2bb509bd2be8	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
7a9dde55-019d-4873-ac9a-4abc18600a70	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	2bfe543e-2a1f-11e4-bc2d-cb05e5722fa8	7a9dde55-019d-4873-ac9a-4abc18600a70	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
1c696c31-5e88-4d1a-a644-50ef24bfb023	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	475ba4bd-cedf-4ba4-976b-d7a2ef695594	1c696c31-5e88-4d1a-a644-50ef24bfb023	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
8ea186b6-5187-4bbd-8a8a-ccbda9f830b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	d0abbada-ad01-11e3-988b-efec9c361a76	8ea186b6-5187-4bbd-8a8a-ccbda9f830b6	\N	2023-10-03 11:14:42	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
9cadfaae-17a3-4f89-ac27-a5e5d0ec8ff4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	9cadfaae-17a3-4f89-ac27-a5e5d0ec8ff4	\N	2020-03-14 16:46:30	2022-12-01 10:22:48	\N	2020-04-28 06:37:44
47c5f37e-ad4b-4e73-84e3-a0959eaf7811	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	47c5f37e-ad4b-4e73-84e3-a0959eaf7811	\N	2020-03-14 16:46:30	2022-12-01 10:22:48	\N	2020-04-28 06:37:44
6dc4ffef-b6b1-4e6e-84e9-c443ead7d65f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	42d0f133-d66c-4ae9-a769-9547b1482539	6dc4ffef-b6b1-4e6e-84e9-c443ead7d65f	\N	2020-03-14 16:46:29	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
7f6a7f9a-f5b4-4f07-85b7-2262a5d17b43	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	f159319f-2b97-4744-95ff-edb8466a656f	7f6a7f9a-f5b4-4f07-85b7-2262a5d17b43	\N	2020-03-14 16:46:30	2022-12-01 10:22:49	\N	2020-04-28 06:37:45
3fabd341-3a75-40da-8dfe-e88ab8468c1d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d90d0294-59e6-4283-a821-c9b6aaae536b	3fabd341-3a75-40da-8dfe-e88ab8468c1d	\N	2020-03-14 16:46:30	2022-12-01 10:22:49	\N	2020-04-28 06:37:44
3fb9e5fc-9da5-4e63-b60a-f0909f09b835	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	3fb9e5fc-9da5-4e63-b60a-f0909f09b835	\N	2020-03-14 16:46:30	2022-12-01 10:22:50	\N	2020-04-28 06:37:44
31b43c25-250f-4fab-be0e-8d0daf6eec3c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	edbf1ed9-b137-4d28-8af1-a22ab23be53b	31b43c25-250f-4fab-be0e-8d0daf6eec3c	\N	2020-03-14 16:46:29	2022-12-01 10:22:50	\N	2020-04-28 06:37:44
cc9d19f2-a267-4dae-84af-e51b056b5f3e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	cc9d19f2-a267-4dae-84af-e51b056b5f3e	\N	2020-03-14 16:46:30	2022-12-01 10:22:51	\N	2020-04-28 06:37:44
ce95a768-970b-44ac-8875-c2234f0f9d9e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7ab0ba14-a17f-4ecd-8201-a673cc87846c	ce95a768-970b-44ac-8875-c2234f0f9d9e	\N	2020-03-14 16:46:31	2022-12-01 10:22:52	\N	2020-04-28 06:37:45
6ede26f7-da8b-475b-a24d-6f9335482143	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	6ede26f7-da8b-475b-a24d-6f9335482143	\N	2020-03-14 16:46:31	2022-12-01 10:22:53	\N	2020-04-28 06:37:44
f075e3b1-5804-4975-82e1-be03f855b5bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	021d11bc-3d8a-11e5-b1d1-733403640dea	f075e3b1-5804-4975-82e1-be03f855b5bb	\N	2020-03-14 16:46:31	2022-12-01 10:22:53	\N	2020-04-28 06:37:45
9085076b-6c2b-4705-80ce-a63c7bcfdad5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	5132bbaa-b74f-4719-86b7-5cfe82b86531	9085076b-6c2b-4705-80ce-a63c7bcfdad5	\N	2020-03-14 16:46:31	2022-12-01 10:22:54	\N	2020-04-28 06:37:45
eb6824f1-e2fc-42d7-9be8-d9638a3cffd6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	e9cef568-2ada-4e64-b69f-00c23c5d8604	eb6824f1-e2fc-42d7-9be8-d9638a3cffd6	\N	2020-03-14 16:46:31	2022-12-01 10:22:56	\N	2020-04-28 06:37:43
c9e2b82d-a1c7-4f4b-be43-a6e13991a454	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	c9e2b82d-a1c7-4f4b-be43-a6e13991a454	\N	2020-03-14 16:46:30	2022-12-01 10:22:57	\N	2020-04-28 06:37:45
f29f67bf-905e-482c-9b35-772d3cc68e98	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	f29f67bf-905e-482c-9b35-772d3cc68e98	\N	2020-03-14 16:46:31	2022-12-01 10:22:58	\N	2020-04-28 06:37:44
3a4f2c03-abb2-4cc8-93e7-e3860ae95f5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	2a0784f4-94ee-435b-8fb3-8c798d15d817	3a4f2c03-abb2-4cc8-93e7-e3860ae95f5a	\N	2020-03-14 16:46:31	2022-12-01 10:22:58	\N	2020-04-28 06:37:45
17020d3c-e5c0-43c4-b9e9-c426e878d111	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	17020d3c-e5c0-43c4-b9e9-c426e878d111	\N	2020-03-14 16:46:31	2022-12-01 10:23:02	\N	2020-04-28 06:37:45
f4719edf-bb7d-44f2-a445-ad9ac67f3d5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	b32063b6-462b-11e5-9585-133f160aafbb	f4719edf-bb7d-44f2-a445-ad9ac67f3d5e	\N	2020-03-14 16:46:31	2022-12-01 10:23:04	\N	2020-04-28 06:37:45
4cc98a47-3fb4-4f25-8da7-beb3f5d6e8bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	6ba43a51-d4b8-4b42-a964-915453deb56a	4cc98a47-3fb4-4f25-8da7-beb3f5d6e8bb	\N	2020-03-14 16:46:31	2022-12-01 10:23:04	\N	2020-04-28 06:37:45
40352991-9973-45b7-b9f6-990194c8717d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	40352991-9973-45b7-b9f6-990194c8717d	\N	2020-03-14 16:46:31	2022-12-01 10:23:04	\N	2020-04-28 06:37:45
622f7232-d918-4c60-8134-f38ba9ce85f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	72d18334-3b06-11e4-a3a4-13507c2a0677	622f7232-d918-4c60-8134-f38ba9ce85f1	\N	2020-03-14 16:46:31	2022-12-01 10:23:05	\N	2020-04-28 06:37:43
e2acf155-ef02-40da-8c51-e8f814ca4d7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	0494c011-fd20-411c-b6f3-022d10cfb1b4	e2acf155-ef02-40da-8c51-e8f814ca4d7b	\N	2020-03-14 16:46:31	2022-12-01 10:23:06	\N	2020-04-28 06:37:43
70c44911-5451-4272-aa5b-3fe50d0f0333	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	4f8e0696-ebb4-406b-a15d-10ddcaa85487	70c44911-5451-4272-aa5b-3fe50d0f0333	\N	2020-03-14 16:46:30	2022-12-01 10:23:09	\N	2020-04-28 06:37:45
d5812587-ee1e-496b-ba1b-d2093c2e98f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7dbbb577-7b93-48ef-b139-db84e9163597	d5812587-ee1e-496b-ba1b-d2093c2e98f4	\N	2020-03-14 16:46:31	2022-12-01 10:23:10	\N	2020-04-28 06:37:45
79e489bb-f377-4242-b507-dd15d21d6cb8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	0c57cc9c-4c32-11e5-858c-afbc5904667e	79e489bb-f377-4242-b507-dd15d21d6cb8	\N	2020-03-14 16:46:31	2022-12-01 10:23:10	\N	2020-04-28 06:37:45
3c9fd777-e73b-49fc-8099-ba7f90b02a08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	304a3c38-bda8-4b1f-b2ef-087817e35993	3c9fd777-e73b-49fc-8099-ba7f90b02a08	\N	2020-03-14 16:46:30	2022-12-01 10:23:12	\N	2020-04-28 06:37:45
8713276b-e585-4c1c-bd2c-82013e3cfa94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	8a5395ea-c758-4eb7-b436-571f527789a2	8713276b-e585-4c1c-bd2c-82013e3cfa94	\N	2020-03-14 16:46:31	2022-12-01 10:23:13	\N	2020-04-28 06:37:45
aef0d037-f50b-4c06-b2be-4b703e2270ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	aef0d037-f50b-4c06-b2be-4b703e2270ad	\N	2020-03-14 16:46:31	2022-12-01 10:23:15	\N	2020-04-28 06:37:45
2ea7f7ea-78f3-4fe7-b832-ac492ab0a008	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	1f6639a7-562e-44f9-b1c8-a98935a9193c	2ea7f7ea-78f3-4fe7-b832-ac492ab0a008	\N	2020-03-14 16:46:31	2022-12-01 10:23:16	\N	2020-04-28 06:37:45
e3c7c4fd-a323-4e43-be58-b4c79ceeb0a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	1d2b0b00-23c4-4c1b-a956-a85ff7deb40b	e3c7c4fd-a323-4e43-be58-b4c79ceeb0a4	\N	2020-03-14 16:46:31	2022-12-01 10:23:17	\N	2020-04-28 06:37:45
b2bdafae-52cc-4aa0-8d28-03cc9bbcf42b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	9833a660-4b73-11e5-934e-37a2f6ed830d	b2bdafae-52cc-4aa0-8d28-03cc9bbcf42b	\N	2020-03-14 16:46:32	2022-12-01 10:23:17	\N	2020-04-28 06:37:44
40e34717-3ba5-435b-aa6f-e630a0c2008d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	40e34717-3ba5-435b-aa6f-e630a0c2008d	\N	2020-03-14 16:46:31	2022-12-01 10:23:19	\N	2020-04-28 06:37:45
1450cdb7-f436-43bf-90b3-a646b6ef6a82	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	11aea642-466b-11e5-886c-1b8856809555	1450cdb7-f436-43bf-90b3-a646b6ef6a82	\N	2020-03-14 16:46:31	2022-12-01 10:23:20	\N	2020-04-28 06:37:45
10964d61-0d8d-45bb-a918-a93ba9973e08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	304a3c38-bda8-4b1f-b2ef-087817e35993	10964d61-0d8d-45bb-a918-a93ba9973e08	\N	2020-03-14 16:46:30	2022-12-01 10:23:21	\N	2020-04-28 06:37:45
1707feec-2706-4320-9191-d0bd21cf644b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	26925a68-aab1-11e5-bde5-bb0a0689b68c	1707feec-2706-4320-9191-d0bd21cf644b	\N	2020-03-14 16:46:31	2022-12-01 10:23:22	\N	2020-04-28 06:37:45
6e054232-8c91-4bde-8fec-decb7b1dfd5a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	6e054232-8c91-4bde-8fec-decb7b1dfd5a	\N	2020-03-14 16:46:31	2022-12-01 10:23:26	\N	2020-04-28 06:37:45
42a2e6cd-a73f-4c13-884c-76c02f4df136	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	d1de7680-727c-4931-a9c8-1cc3a384a7c5	42a2e6cd-a73f-4c13-884c-76c02f4df136	\N	2020-03-14 16:46:31	2022-12-01 10:23:26	\N	2020-04-28 06:37:44
7241ae4b-db06-4789-814a-5354100423cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	62bf4771-c092-434d-8e93-0260891de1ff	7241ae4b-db06-4789-814a-5354100423cc	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
d36f35cc-5a1e-47c6-93f7-33dcbf661097	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	84f52c40-b361-11e4-97f5-07149f66330b	d36f35cc-5a1e-47c6-93f7-33dcbf661097	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
25f45dce-046e-4962-bab9-7da17734c5d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	840ff838-4001-11e4-bf78-07281b97a7c6	25f45dce-046e-4962-bab9-7da17734c5d3	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
f3b7919c-be45-48a5-bf12-0bff5e901692	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	b186ad12-8e0d-11e3-9179-078762557c01	f3b7919c-be45-48a5-bf12-0bff5e901692	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
85ee6930-1353-4602-a02a-50e12139915e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	82f55162-408f-11e4-987c-07fccbd7a9d6	85ee6930-1353-4602-a02a-50e12139915e	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
582fc4f8-1551-4f22-8dc2-05f585b8bee5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	ecacd4b6-e824-e211-878a-097421c03879	582fc4f8-1551-4f22-8dc2-05f585b8bee5	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
07cb21da-e231-4491-b38b-43b05d542145	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	9b503152-3a3e-11e4-9ad4-0b38bfc34a57	07cb21da-e231-4491-b38b-43b05d542145	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
4c08fd3d-2a0e-4ee2-8b4d-25cb4c3053e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	6149e37c-57ea-11e3-8a63-0bad90edf22e	4c08fd3d-2a0e-4ee2-8b4d-25cb4c3053e9	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
b854c1ea-412e-4bb1-9e51-97f8a8183884	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	89a07b97-5c4f-4984-82d1-1254eb1c86af	b854c1ea-412e-4bb1-9e51-97f8a8183884	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
87d0442d-5e0c-41d7-95f1-d13e41b3bc89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	2e383874-7f7e-11e3-b87c-131c0087c0c4	87d0442d-5e0c-41d7-95f1-d13e41b3bc89	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
5b1e0f2b-ab1f-4729-ba27-873bf858e7ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	7c4b00f2-9516-11e3-bed6-135f4d27544f	5b1e0f2b-ab1f-4729-ba27-873bf858e7ed	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
43bcdf43-26eb-488f-a160-ddca76dfecb8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	11273a50-662d-11e4-a36e-136788f6ba2a	43bcdf43-26eb-488f-a160-ddca76dfecb8	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
fd3b9ca2-0819-48b9-b561-ab54c877add6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	85c76db0-48a7-11e4-8146-178a618d3874	fd3b9ca2-0819-48b9-b561-ab54c877add6	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
f05a08e4-77bf-494b-948b-1f4eb1edf22a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	71e270b7-10e5-40cd-af79-1b5d07c2d9ab	f05a08e4-77bf-494b-948b-1f4eb1edf22a	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
488c48e8-2536-450b-900c-05972ca2e6e3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	33bce156-94d6-11e3-9dfa-1b9f2c131c25	488c48e8-2536-450b-900c-05972ca2e6e3	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
e434b00a-f378-4cb5-8a7b-94d025e5068c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	9cebf2d1-99f6-4b81-a7e7-d3fd26767c59	b91d4930-8010-4fd0-a217-d282dafba85e	\N	2020-03-14 16:46:31	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-04-28 06:37:45
91d81066-e85b-4d77-92d2-41b4e13e56f9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	22278151-6aec-4b87-bfab-3bf8d1810468	91d81066-e85b-4d77-92d2-41b4e13e56f9	\N	2020-03-14 16:46:32	2022-12-01 10:22:48	\N	2020-04-28 06:37:44
99f445ea-a7b9-40c5-af95-7ead2f3eb486	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	bd3a2d69-e9b5-4462-9057-eb4b035b297d	99f445ea-a7b9-40c5-af95-7ead2f3eb486	\N	2020-03-14 16:46:31	2022-12-01 10:22:49	\N	2020-04-28 06:37:45
db689276-72f8-4f60-9cf2-93e3cf2e8ff7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	78027dc1-f7e5-434a-b0c3-767f331840bb	db689276-72f8-4f60-9cf2-93e3cf2e8ff7	\N	2020-03-14 16:46:31	2022-12-01 10:22:50	\N	2020-04-28 06:37:45
9f1fe452-e9a0-45e1-8337-4718b19febc0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	9f1fe452-e9a0-45e1-8337-4718b19febc0	\N	2020-03-14 16:46:31	2022-12-01 10:22:50	\N	2020-04-28 06:37:45
5b6ca35e-2da0-44fe-bfd7-99e61edfb3f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	5b6ca35e-2da0-44fe-bfd7-99e61edfb3f8	\N	2020-03-14 16:46:31	2022-12-01 10:22:51	\N	2020-04-28 06:37:45
663dd19a-2986-4dee-9e84-d9c6897ab94d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	663dd19a-2986-4dee-9e84-d9c6897ab94d	\N	2020-03-14 16:46:31	2022-12-01 10:22:51	\N	2020-04-28 06:37:45
291dccf7-1798-49bf-8b68-fc8d982a5055	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	2ed4dbb2-6627-11e4-a396-57d9cb5b0f00	291dccf7-1798-49bf-8b68-fc8d982a5055	\N	2023-10-03 11:14:47	2023-10-03 11:14:47	\N	2023-09-03 11:14:47
98c524cb-d7ce-4413-82c6-22cb888d45fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	e21689e2-9516-11e3-8d5f-1f8023e8ca9e	98c524cb-d7ce-4413-82c6-22cb888d45fc	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
0c001e85-fafb-4817-95c2-3efa5e5ce7ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	0a72bba4-4a47-11e5-ba01-1f889a42b431	0c001e85-fafb-4817-95c2-3efa5e5ce7ed	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
26b21597-327c-4192-b5d9-d3d160c9a4fd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	1efebede-0f12-4c19-ab53-2090b7359148	26b21597-327c-4192-b5d9-d3d160c9a4fd	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
9fb349cf-f5ce-48fa-8559-51c5e8f64d3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	cc5df9fa-60ae-11e4-a528-2326bffd6759	9fb349cf-f5ce-48fa-8559-51c5e8f64d3d	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
9c9207f3-55e2-4e59-82bb-af7a6b37c911	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	b1e79070-5e22-11e3-9c6d-233c893822c5	9c9207f3-55e2-4e59-82bb-af7a6b37c911	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
1eeac4dc-3ba0-4680-a47f-2d8a9a5e5d79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	d22b4808-88b2-11e3-8cc6-27bf35192807	1eeac4dc-3ba0-4680-a47f-2d8a9a5e5d79	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
61481835-26bc-413a-a003-8b3810995830	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	7ef72c9c-3532-4899-8029-2cea3812faa4	61481835-26bc-413a-a003-8b3810995830	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
b252ba82-8127-43f2-977e-a8ef1a30c169	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	c3a53678-d7a7-4c1b-807f-3034b37ec04a	b252ba82-8127-43f2-977e-a8ef1a30c169	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
cefa8705-64ef-4a1e-b19d-bc16f62959af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	6bcf1e8c-6f7f-11e3-8895-3357dd36639d	cefa8705-64ef-4a1e-b19d-bc16f62959af	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
8bd35f7d-d6f3-4cbe-88ba-f97fd01aaf57	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	217aabe8-662e-11e4-8763-376fcef79753	8bd35f7d-d6f3-4cbe-88ba-f97fd01aaf57	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
730dc7db-54ab-4068-be95-5076e9dfb9cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	c8585e32-5bae-11e3-812d-37a32636c770	730dc7db-54ab-4068-be95-5076e9dfb9cb	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
66275238-d149-4672-9368-06027cfab941	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	82258dfe-8bf9-11e5-ad93-37d367e86351	66275238-d149-4672-9368-06027cfab941	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
05b0908f-464d-40ed-a92e-021f9d6a56b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	617d0298-7806-11e3-a360-3b79dafbb6d8	05b0908f-464d-40ed-a92e-021f9d6a56b4	\N	2023-10-03 11:14:46	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
c871be4f-7f0b-410c-bd02-e75b85036ac0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	bd9c2f1a-2bff-11e4-8d20-3b9b356b1912	c871be4f-7f0b-410c-bd02-e75b85036ac0	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
5f4fef0e-8234-485a-be02-7fcfa621652b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	99153600-e522-442f-994e-45c3cb038980	5f4fef0e-8234-485a-be02-7fcfa621652b	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
610f2464-197d-4e8c-a6c7-e525a6564579	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	483046d6-87b2-4164-9247-49c073789a31	610f2464-197d-4e8c-a6c7-e525a6564579	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
a0290da3-c2f9-494d-961d-d12697969686	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	185763fc-94d9-11e3-86ab-4b04feeb706c	a0290da3-c2f9-494d-961d-d12697969686	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
c63387c1-5f5d-4b6c-baf2-09a445838fe0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	2ddac1d3-c129-e211-82ed-4bf89d6bb6ec	c63387c1-5f5d-4b6c-baf2-09a445838fe0	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
a3ce6666-879c-412b-9f46-18a8ef568041	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	d06848d7-c129-e211-82ed-4bf89d6bb6ec	a3ce6666-879c-412b-9f46-18a8ef568041	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
0dbe4738-aa1e-4f68-a232-dc83437e6b99	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	67ee6efb-ca29-e211-82ed-4bf89d6bb6ec	0dbe4738-aa1e-4f68-a232-dc83437e6b99	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
b5ecded5-192d-4817-8a0f-b46ec7efa98b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	8ff0ed33-b9f4-4f73-a77a-4cf388f1a3cb	b5ecded5-192d-4817-8a0f-b46ec7efa98b	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
e52617bf-3760-459c-a704-1ea8c4974775	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	b3d74216-101c-e211-af82-4f62965233f9	e52617bf-3760-459c-a704-1ea8c4974775	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
fa965f60-f3dc-4c0a-9c4c-625438d5a4a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	f5599d4e-2520-e211-ac85-4fdce694eced	fa965f60-f3dc-4c0a-9c4c-625438d5a4a4	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
f0ce0684-623b-4d15-8f7a-c9d43714b638	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	489e1454-e4ac-47cc-b7d0-51c8ff56abbf	f0ce0684-623b-4d15-8f7a-c9d43714b638	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
5fcdeaad-ba12-4855-982d-3aa0a0488af8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	3d9a3222-1539-4af6-bc16-54a57990650c	5fcdeaad-ba12-4855-982d-3aa0a0488af8	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
915cd0da-34a3-4a3a-9a91-b44939696285	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	54c1ab04-63b9-4bf3-8d0b-55359bf1a7b2	915cd0da-34a3-4a3a-9a91-b44939696285	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
cda6b007-2e12-4e86-89d1-e1a8360c99c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	0c563131-c129-e211-b674-55b8a5daa5db	cda6b007-2e12-4e86-89d1-e1a8360c99c3	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
ad6137ef-1d6c-4f91-a612-bc162e1cff9e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	14438df8-6630-11e4-8fc8-5721c0138d72	ad6137ef-1d6c-4f91-a612-bc162e1cff9e	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
5ced1cd4-0baf-4a88-8185-817d00449225	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	4110f12e-94d8-11e3-9d19-577073295bc5	5ced1cd4-0baf-4a88-8185-817d00449225	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
2d59c51a-691a-4afc-89e4-7bde1d6d9725	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	d9c6af96-777e-43b9-9bca-58c1300af26f	2d59c51a-691a-4afc-89e4-7bde1d6d9725	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
6f2ec9c1-4315-4064-ac25-95a8abe46100	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	2f627335-3b69-4db3-94e3-0a43968e23e9	6f2ec9c1-4315-4064-ac25-95a8abe46100	\N	2020-03-14 16:46:31	2022-12-01 10:22:49	\N	2020-04-28 06:37:45
7b0a423e-4ba0-4123-b032-996c3bd5f94c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	f59b1bb2-1e58-4760-b504-5ee5de14aba7	7b0a423e-4ba0-4123-b032-996c3bd5f94c	\N	2020-03-14 16:46:32	2022-12-01 10:22:49	\N	2020-04-28 06:37:45
46916a2e-efce-455a-ab56-fcf203110ddb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	52d5486a-4544-11e5-b3ea-131ef06916b5	46916a2e-efce-455a-ab56-fcf203110ddb	\N	2020-03-14 16:46:31	2022-12-01 10:22:50	\N	2020-04-28 06:37:45
75a4703b-df11-48d3-80fd-fecfcdfd931e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	794d3765-1d66-4ac8-a5b8-0a7e4822eec5	75a4703b-df11-48d3-80fd-fecfcdfd931e	\N	2020-03-14 16:46:31	2022-12-01 10:22:52	\N	2020-04-28 06:37:45
0b27d9c9-5f73-4fd5-977e-64b17ef92d23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	26daca7f-056a-4e55-a49a-4469004944ec	0b27d9c9-5f73-4fd5-977e-64b17ef92d23	\N	2020-03-14 16:46:32	2022-12-01 10:22:52	\N	2020-04-28 06:37:45
9226ab99-ca67-4978-88bd-b8996d6ca61e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	da2e3e30-22ee-11e4-90f6-53330a5cd670	9226ab99-ca67-4978-88bd-b8996d6ca61e	\N	2020-03-14 16:46:32	2022-12-01 10:22:56	\N	2020-04-28 06:37:45
c25258c2-331a-48ae-a089-fba4457f38f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	c25258c2-331a-48ae-a089-fba4457f38f3	\N	2020-03-14 16:46:31	2022-12-01 10:22:58	\N	2020-04-28 06:37:45
2df67eb1-fd22-4afc-86c3-d25f37bb5b99	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	5899f113-d963-4965-9245-1f6222f5bbc1	2df67eb1-fd22-4afc-86c3-d25f37bb5b99	\N	2020-03-14 16:46:31	2022-12-01 10:22:58	\N	2020-04-28 06:37:45
2154b356-f5ee-438a-9dfe-36ac12df49a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d28672c2-c5a5-4238-a802-fd30f1f8341d	2154b356-f5ee-438a-9dfe-36ac12df49a1	\N	2020-03-14 16:46:31	2022-12-01 10:22:59	\N	2020-04-28 06:37:45
1c19c501-3406-4181-b5b4-c6511d6cea94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	cae987c8-810a-4d95-a5fb-27e3108961de	1c19c501-3406-4181-b5b4-c6511d6cea94	\N	2020-03-14 16:46:31	2022-12-01 10:23:04	\N	2020-04-28 06:37:45
b16a569e-2dfe-4bad-98d5-a1c31a56fd0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	a83c363b-c56d-49b3-9d37-61d51488daab	b16a569e-2dfe-4bad-98d5-a1c31a56fd0d	\N	2020-03-14 16:46:32	2022-12-01 10:23:04	\N	2020-04-28 06:37:45
facac317-b093-4cd4-ae9d-75dc94cf6ae4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	808f4853-72f6-44e9-8555-4e07f494c8cf	facac317-b093-4cd4-ae9d-75dc94cf6ae4	\N	2020-03-14 16:46:32	2022-12-01 10:23:06	\N	2020-04-28 06:37:45
e8dc0c5d-774a-476e-a335-f26c6e61ea85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	e8dc0c5d-774a-476e-a335-f26c6e61ea85	\N	2020-03-14 16:46:31	2022-12-01 10:23:09	\N	2020-04-28 06:37:45
4453a30f-ee1b-46c1-ba98-f5a689092486	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	1438adc2-38fc-11e4-b641-3f0b3de385b4	4453a30f-ee1b-46c1-ba98-f5a689092486	\N	2020-03-14 16:46:32	2022-12-01 10:23:12	\N	2020-04-28 06:37:45
e0e64275-4b40-4589-a957-1bfe061ac2d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	e0e64275-4b40-4589-a957-1bfe061ac2d7	\N	2020-03-14 16:46:32	2022-12-01 10:23:13	\N	2020-04-28 06:37:45
f34bf50b-7c36-4176-a80e-dddc8de310dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	540161f2-51dc-11e5-ada1-57cb00fd65d6	f34bf50b-7c36-4176-a80e-dddc8de310dc	\N	2020-03-14 16:46:32	2022-12-01 10:23:15	\N	2020-04-28 06:37:45
4eee1105-3d47-48f1-8fc1-3456d92b4c96	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	81ed9f12-dc17-4947-aeaa-5105be4af095	4eee1105-3d47-48f1-8fc1-3456d92b4c96	\N	2020-03-14 16:46:32	2022-12-01 10:23:16	\N	2020-04-28 06:37:45
e17da3cb-c7a8-42b4-8e77-b6aa93822ae8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	e7692714-42a9-11e5-a70e-2322869c051b	e17da3cb-c7a8-42b4-8e77-b6aa93822ae8	\N	2020-03-14 16:46:31	2022-12-01 10:23:17	\N	2020-04-28 06:37:45
faf88db6-bb77-4165-bc6f-ac463578d0e0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	e0e38c52-da5a-44a8-ac92-411718cd6332	faf88db6-bb77-4165-bc6f-ac463578d0e0	\N	2020-03-14 16:46:32	2022-12-01 10:23:24	\N	2020-04-28 06:37:45
d6967c6d-4af2-460c-9e58-969391ac04cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	6402418c-54f9-11e5-9e54-5397b782050d	d6967c6d-4af2-460c-9e58-969391ac04cb	\N	2020-03-14 16:46:32	2022-12-01 10:23:24	\N	2020-04-28 06:37:45
e8effe24-09c5-481d-80c2-1492d1933c7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	2819b86b-4d06-499d-a0c9-af1a3e711ecf	e8effe24-09c5-481d-80c2-1492d1933c7b	\N	2020-03-14 16:46:31	2022-12-01 10:23:24	\N	2020-04-28 06:37:45
9883173a-2e1c-44f5-9b6d-52d233aa60db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7363a404-46e9-11e5-8413-7fabf05ee1fd	9883173a-2e1c-44f5-9b6d-52d233aa60db	\N	2020-03-14 16:46:32	2022-12-01 10:22:53	\N	2020-04-28 06:37:46
38acded1-e2fe-4c3c-895d-5769216d8709	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	3e20af19-c84c-4fb4-9326-a47a5a8087c1	38acded1-e2fe-4c3c-895d-5769216d8709	\N	2020-03-14 16:46:32	2022-12-01 10:22:56	\N	2020-04-28 06:37:46
c23a8734-5f38-4180-8281-675fd28a4438	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	60c2ff20-4b6c-11e5-958c-b39420b5676f	c23a8734-5f38-4180-8281-675fd28a4438	\N	2020-03-14 16:46:32	2022-12-01 10:23:03	\N	2020-04-28 06:37:46
f2c48f88-c5c0-40f6-94ad-2f3a61d5a84d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	f2c48f88-c5c0-40f6-94ad-2f3a61d5a84d	\N	2020-03-14 16:46:32	2022-12-01 10:23:04	\N	2020-04-28 06:37:46
472590cc-135b-48f0-a7bb-e74bbd668000	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	4e3a22a4-98e9-4024-a519-7a05be9167c8	472590cc-135b-48f0-a7bb-e74bbd668000	\N	2020-03-14 16:46:32	2022-12-01 10:23:04	\N	2020-04-28 06:37:46
396d0647-9903-4956-89b0-ca035cd971b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	a968b612-4bac-11e5-bce0-9f0e431a474f	396d0647-9903-4956-89b0-ca035cd971b8	\N	2020-03-14 16:46:32	2022-12-01 10:23:05	\N	2020-04-28 06:37:46
2d3d6ccb-60d8-434e-bacd-39909cd44c4c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	beb52866-067c-4257-aa11-ac304217924c	2d3d6ccb-60d8-434e-bacd-39909cd44c4c	\N	2020-03-14 16:46:32	2022-12-01 10:23:06	\N	2020-04-28 06:37:46
57981c1c-0b64-4bbc-a967-91d2e4f41c3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	d993ad11-d98a-4803-85a4-a446d7b9d4c7	57981c1c-0b64-4bbc-a967-91d2e4f41c3d	\N	2020-03-14 16:46:32	2022-12-01 10:23:10	\N	2020-04-28 06:37:46
0a35b34d-a1a9-4e26-b3c8-96c6c69b1fbc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	0a35b34d-a1a9-4e26-b3c8-96c6c69b1fbc	\N	2020-03-14 16:46:32	2022-12-01 10:23:16	\N	2020-04-28 06:37:46
e73adb0c-b3cf-4aae-a32b-8486e9a4b92a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	afab5d0b-c4da-455e-bd0a-8644da49ab0f	e73adb0c-b3cf-4aae-a32b-8486e9a4b92a	\N	2020-03-14 16:46:32	2022-12-01 10:23:17	\N	2020-04-28 06:37:45
bc267b7d-f1d4-4f2f-b7af-6ef49613b13f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	ea363a5f-9119-468b-8fea-9187ba92c13e	bc267b7d-f1d4-4f2f-b7af-6ef49613b13f	\N	2020-03-14 16:46:32	2022-12-01 10:23:22	\N	2020-04-28 06:37:46
a08ce608-d6a7-47af-8cf9-76ebb19dbc3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	c593fef2-46d2-11e5-b14e-8fa23f386b5a	a08ce608-d6a7-47af-8cf9-76ebb19dbc3a	\N	2020-03-14 16:46:32	2022-12-01 10:23:22	\N	2020-04-28 06:37:46
7b51326c-61ea-4521-ba18-a863d1fb76ce	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	6a26772d-e188-455a-8bd8-9c8d729a618e	7b51326c-61ea-4521-ba18-a863d1fb76ce	\N	2020-03-14 16:46:32	2022-12-01 10:23:25	\N	2020-04-28 06:37:46
1f2a6a85-6de5-4e69-b1d3-4673f6125899	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	1f2a6a85-6de5-4e69-b1d3-4673f6125899	\N	2020-03-14 16:46:32	2022-12-01 10:23:29	\N	2020-04-28 06:37:46
9395be4a-a3a6-4f68-a5f7-12cfbb8769bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	9b057256-628e-4516-a951-a78bd3651d4b	9395be4a-a3a6-4f68-a5f7-12cfbb8769bc	\N	2020-03-14 16:46:32	2022-12-01 10:23:30	\N	2020-04-28 06:37:46
0e2b3004-ebcc-41a9-8070-0789c40d256d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	d8e37a78-4935-11e4-8211-6bd4672775fd	0e2b3004-ebcc-41a9-8070-0789c40d256d	\N	2023-10-03 11:14:47	2023-10-03 11:14:47	\N	2023-09-03 11:14:47
d2aa8e59-fa11-47cb-bb4f-40165179509b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	e977cdbc-6218-e211-b42b-59de279d6e5f	d2aa8e59-fa11-47cb-bb4f-40165179509b	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
00f30eee-60f6-46b0-8cfb-cc20195b068e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	0c6a002f-208e-4340-9276-5ddf8c3c7931	00f30eee-60f6-46b0-8cfb-cc20195b068e	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
101507eb-172a-4d70-a84f-51fbb89fab1e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	a5197a21-450c-4b9d-a2b7-5e5f76982fd2	101507eb-172a-4d70-a84f-51fbb89fab1e	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
480d72a6-760a-41c8-b2ee-34a757d4ada6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	6f6a984a-49d2-11e4-84c7-6355f4b21338	480d72a6-760a-41c8-b2ee-34a757d4ada6	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
b17f0131-f0a3-4611-b7ee-5dc239f2f3d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	09246708-1717-e211-9018-65b25eca14b5	b17f0131-f0a3-4611-b7ee-5dc239f2f3d8	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
9e4e829b-2195-4bba-993e-4c1911a55417	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	539c2dbe-5e22-11e3-97a4-6b60c900259e	9e4e829b-2195-4bba-993e-4c1911a55417	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
b73f64c1-bf7d-4c65-9a52-61526b2a0948	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	330c1f39-a513-4841-88ce-6bbdbb912d1c	b73f64c1-bf7d-4c65-9a52-61526b2a0948	\N	2023-10-03 11:14:47	2023-12-05 09:39:45	\N	2023-11-05 09:39:45
c3edfe69-481a-43b1-832f-c613e4b6e55e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	00d9161a-94d6-11e3-8e07-6bfd6236e395	c3edfe69-481a-43b1-832f-c613e4b6e55e	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
cd8c68cb-9e0f-4343-b0f7-b679635f29db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	b68d69d6-0502-e211-8442-77d6f35b44ad	cd8c68cb-9e0f-4343-b0f7-b679635f29db	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
7baf894a-e8b3-43ae-af4a-63ec5e17b3c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	4e3df8d9-0602-e211-8442-77d6f35b44ad	7baf894a-e8b3-43ae-af4a-63ec5e17b3c0	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
bc4c2e21-43bd-4e4a-b9c7-212d27eb0553	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	b1245957-0802-e211-8442-77d6f35b44ad	bc4c2e21-43bd-4e4a-b9c7-212d27eb0553	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
f1227f9d-b15d-40a5-a318-3747d4ac4068	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	9e6521bc-0a02-e211-8442-77d6f35b44ad	f1227f9d-b15d-40a5-a318-3747d4ac4068	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
3747f889-7934-43da-8431-1889e4426fdb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	1a4e610e-0b02-e211-8442-77d6f35b44ad	3747f889-7934-43da-8431-1889e4426fdb	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
45c5b3e3-a994-4273-9a95-cc9266a1ec4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	9a7aee38-4089-11e4-838c-77f18ad3941b	45c5b3e3-a994-4273-9a95-cc9266a1ec4b	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
8b3fc16e-28ab-4cb7-ad1a-b8f765d9bcd4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	250c0b5f-0e2c-e211-864c-79233e4c0063	8b3fc16e-28ab-4cb7-ad1a-b8f765d9bcd4	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
e316817e-6c59-4df1-85d2-74531eee3922	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	06a67ac1-e927-e211-86f3-79cd2fac9006	e316817e-6c59-4df1-85d2-74531eee3922	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
752bd091-b52d-4dfd-9876-aec5867fa8da	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	15cd7ac1-e927-e211-86f3-79cd2fac9006	752bd091-b52d-4dfd-9876-aec5867fa8da	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
9992c6f1-af7c-4fb3-bd2a-50a49f9d81fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	7b907bc1-e927-e211-86f7-79cd2fac9006	9992c6f1-af7c-4fb3-bd2a-50a49f9d81fb	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
8971dbcc-ff27-4b32-bf2c-b7ecf1dd50c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	38babd1a-3be1-11e4-9cff-7b0d7994cf0b	8971dbcc-ff27-4b32-bf2c-b7ecf1dd50c5	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
449ae141-55eb-4462-b6e1-58e11d3d5d4c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	777d9a08-2517-4adf-a008-70c0d006b0a5	d07db20c-5cb8-43bb-9f85-f95968979d87	\N	2020-03-14 16:46:32	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-04-28 06:37:46
d71b03af-391f-475c-a098-88eb22793855	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	39d012b6-b00a-4aaa-b389-0e15e420ad3a	d35ec3e4-2896-47c6-aa0b-5d8d895d7336	\N	2020-03-14 16:46:32	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-04-28 06:37:46
5f934a02-315d-408d-bdab-90a4eeb56901	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	cd0efc86-2a0e-11e4-bc41-7bdce17446f2	5f934a02-315d-408d-bdab-90a4eeb56901	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
26f77946-b224-45da-92f2-7e8ad0e1d1e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	495e7608-92c6-11e3-8b1d-7bfea52853f1	26f77946-b224-45da-92f2-7e8ad0e1d1e1	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
ab212d6d-77f3-4867-ae7c-b7a78d2dd622	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	087c218d-0643-48d4-86ff-7c8017578e03	ab212d6d-77f3-4867-ae7c-b7a78d2dd622	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
90ceda75-b26f-4a61-bad3-2a60e1a10b08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	ee092c2a-fd8c-4323-96a0-7d44f36451de	90ceda75-b26f-4a61-bad3-2a60e1a10b08	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
f7812284-b28d-4d18-9501-8d5957f3e894	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	eea51330-4df7-49dc-a58b-7e7fc6cf26ac	f7812284-b28d-4d18-9501-8d5957f3e894	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
c20d9c53-402d-4429-9498-9d3669dfd5f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	6a459348-f991-4498-b483-82078efe1e29	c20d9c53-402d-4429-9498-9d3669dfd5f8	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
c03b888b-b20f-422a-a2b3-4b30e9944839	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	c5fdbd10-8585-40b5-9cd2-83dde161d8c8	c03b888b-b20f-422a-a2b3-4b30e9944839	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
a38da9e3-2a2b-4e8d-80e7-da327f90ea3b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	6ec00c9f-1bf3-4a69-b131-8401a0fbe519	a38da9e3-2a2b-4e8d-80e7-da327f90ea3b	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
fbf73026-ec79-4f03-a5c3-51d8ba5482a7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	4f34ea70-781e-11e3-af88-8738a490246c	fbf73026-ec79-4f03-a5c3-51d8ba5482a7	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
2d364171-8b21-4182-a201-a277ba58168e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	5dd3beda-a90a-11e4-8be4-878764d69847	2d364171-8b21-4182-a201-a277ba58168e	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
1595605f-c9c8-47d0-a32c-8c66c78ca4f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	fae6a1c2-8e0a-11e3-8141-7f4802cb1e93	1595605f-c9c8-47d0-a32c-8c66c78ca4f5	\N	2023-10-03 11:14:47	2023-12-05 09:39:50	2023-12-05 09:39:50	2023-11-05 09:39:50
65e1d25a-58f4-4103-a718-cc74349cbd6b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	65e1d25a-58f4-4103-a718-cc74349cbd6b	\N	2020-03-14 16:46:32	2022-12-01 10:22:49	\N	2020-04-28 06:37:46
1bcfa930-b30d-4d60-86cd-bd602196550a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	8b4ea31e-4aa0-427e-a65f-928b232d7f14	1bcfa930-b30d-4d60-86cd-bd602196550a	\N	2020-03-14 16:46:34	2022-12-01 10:22:49	\N	2020-04-28 06:37:45
6298ddef-6987-4d97-9171-1bf381be73f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	54894cf6-ecf9-44c5-87e8-b87e6bf62120	6298ddef-6987-4d97-9171-1bf381be73f2	\N	2020-03-14 16:46:32	2022-12-01 10:22:49	\N	2020-04-28 06:37:46
c652848a-8726-461d-a8cb-64d5287275d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	afab5d0b-c4da-455e-bd0a-8644da49ab0f	c652848a-8726-461d-a8cb-64d5287275d7	\N	2020-03-14 16:46:32	2022-12-01 10:22:50	\N	2020-04-28 06:37:46
97b52836-f151-4a0b-a91f-08762cd1b1cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	7a426c49-48eb-473c-9779-47a65a92d954	97b52836-f151-4a0b-a91f-08762cd1b1cc	\N	2020-03-14 16:46:32	2022-12-01 10:22:57	\N	2020-04-28 06:37:45
ea1472f7-20b2-4873-8bb5-6bfee728207e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	efadf950-9060-45d1-a065-ddd9c87cd53f	ea1472f7-20b2-4873-8bb5-6bfee728207e	\N	2020-03-14 16:46:33	2022-12-01 10:22:58	\N	2020-04-28 06:37:46
c1ddf983-0d12-4efb-9129-4de2428d5c07	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	fa092490-4b74-11e5-a33d-db9868dda03f	c1ddf983-0d12-4efb-9129-4de2428d5c07	\N	2020-03-14 16:46:33	2022-12-01 10:22:58	\N	2020-04-28 06:37:46
a3af7999-0c62-4adf-9bcb-130b19f87031	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	ac0343f2-09a5-4b95-b38f-cd379433d96c	a3af7999-0c62-4adf-9bcb-130b19f87031	\N	2020-03-14 16:46:33	2022-12-01 10:22:58	\N	2020-04-28 06:37:46
1e15dba0-d630-48ff-b2ec-01e897033965	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	2c1847a5-ae44-40e2-836e-cc566e0ed984	1e15dba0-d630-48ff-b2ec-01e897033965	\N	2020-03-14 16:46:32	2022-12-01 10:23:05	\N	2020-04-28 06:37:46
a4662d5a-c318-46fa-a79b-7886ae6111e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	994e91c4-854b-4fe0-946c-0133e4582398	a4662d5a-c318-46fa-a79b-7886ae6111e9	\N	2020-03-14 16:46:28	2022-12-01 10:23:11	\N	2020-04-28 06:37:43
84bcc63e-e8a5-4d8b-9a8e-270be38c55fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	91317e32-9ec9-468c-bf5b-ef891856d180	84bcc63e-e8a5-4d8b-9a8e-270be38c55fa	\N	2020-03-14 16:46:33	2022-12-01 10:23:11	\N	2020-04-28 06:37:46
f9d3a7e6-12e5-47cf-b2b2-4148f0dfe9c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	4c42f155-3a8b-4690-b9c4-f92f8d413990	f9d3a7e6-12e5-47cf-b2b2-4148f0dfe9c6	\N	2020-03-14 16:46:33	2022-12-01 10:23:16	\N	2020-04-28 06:37:45
6deb81a6-4a41-4125-a47f-f38848719323	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	2a0784f4-94ee-435b-8fb3-8c798d15d817	6deb81a6-4a41-4125-a47f-f38848719323	\N	2020-03-14 16:46:34	2022-12-01 10:23:16	\N	2020-04-28 06:37:46
9bbf0ff3-6e53-48f6-8563-5c4906bad040	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	162955a4-43dc-4ee3-85f2-b4b602c72400	9bbf0ff3-6e53-48f6-8563-5c4906bad040	\N	2020-03-14 16:46:34	2022-12-01 10:23:21	\N	2020-04-28 06:37:46
2598ddb9-50af-460c-8fbb-180c1bd3d8fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	2598ddb9-50af-460c-8fbb-180c1bd3d8fa	\N	2020-03-14 16:46:31	2022-12-01 10:23:22	\N	2020-04-28 06:37:44
3af8166d-8e2c-4730-bd72-9734560dbbf7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	3af8166d-8e2c-4730-bd72-9734560dbbf7	\N	2020-03-14 16:46:32	2022-12-01 10:23:22	\N	2020-04-28 06:37:46
4a6b399c-ef15-425b-8ce0-46bc0b2aa10d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	99f38034-4a28-11e5-a3b9-ff498a91b449	4a6b399c-ef15-425b-8ce0-46bc0b2aa10d	\N	2020-03-14 16:46:33	2022-12-01 10:23:22	\N	2020-04-28 06:37:46
b05dc73b-c150-41b5-9280-bc12db3fe0c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	b05dc73b-c150-41b5-9280-bc12db3fe0c5	\N	2020-03-14 16:46:33	2022-12-01 10:23:26	\N	2020-04-28 06:37:46
98ea2de9-6802-4e3c-85b1-377bcf3d5360	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	ff732935-72e5-4865-bb47-f3e0cb79d9fa	98ea2de9-6802-4e3c-85b1-377bcf3d5360	\N	2020-03-14 16:46:33	2022-12-01 10:23:26	\N	2020-04-28 06:37:46
be83af6b-cd54-4a79-b894-49e54d2a510f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	3ad03a6a-9caa-40e4-a060-62e1680cd17b	be83af6b-cd54-4a79-b894-49e54d2a510f	\N	2020-03-14 16:46:29	2022-12-01 10:23:30	\N	2020-04-28 06:37:44
121f5a9e-a3c4-4411-a068-9a1c32f48544	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bd6a30cd-c782-4db5-8904-211db920f710	a77bbee8-3fba-11e4-9190-c7120430447f	121f5a9e-a3c4-4411-a068-9a1c32f48544	\N	2023-10-03 11:14:47	2023-10-03 11:14:47	\N	2023-09-03 11:14:47
9d0ad033-f2c5-4b26-9278-1234dcd31e87	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	8314bc86-f503-e211-a8c9-8de20f7d3878	9d0ad033-f2c5-4b26-9278-1234dcd31e87	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
635943d3-094a-47fb-a0ed-ec1e5de8d06e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	b8597d0a-533b-11e5-af98-8f68bbe85388	635943d3-094a-47fb-a0ed-ec1e5de8d06e	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
029ba572-69a7-481f-954c-b7a8fec19f92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	51c7d610-b758-4f28-9f99-9196229ba893	029ba572-69a7-481f-954c-b7a8fec19f92	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
ce87e3b3-368f-4cca-9384-ce05f0b6596a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	ca99dedb-11fb-e111-88dd-91f29105d9d3	ce87e3b3-368f-4cca-9384-ce05f0b6596a	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
2e55dc9e-0d89-4a88-9a61-082a89b42661	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	3ebfbdc0-4be2-11e5-9342-930322c83a67	2e55dc9e-0d89-4a88-9a61-082a89b42661	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
cc051ceb-3cd4-479e-ba91-ff0f36839786	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	6d682e7e-3bd9-11e4-8f80-932c2914e8fb	cc051ceb-3cd4-479e-ba91-ff0f36839786	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
fda0df58-5104-4817-a7ce-752d6d884904	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	a8fda9da-6d1e-11e3-970c-93ebf835240a	fda0df58-5104-4817-a7ce-752d6d884904	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
1248065f-03b1-4c65-bb8f-09794c4badf4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	842392af-953c-e211-8e89-9908d75a8f4c	1248065f-03b1-4c65-bb8f-09794c4badf4	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
fbb50b58-6282-4cb8-a984-f529a9a20e8c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	3c1ceee8-8105-11e3-833a-9bdba6d1ca50	fbb50b58-6282-4cb8-a984-f529a9a20e8c	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
d5051812-df3f-40e3-97ae-542057f73f47	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	72cfdfda-231c-e211-b5fb-9d36c7d7cb09	d5051812-df3f-40e3-97ae-542057f73f47	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
4907cd60-4fe6-43fb-a1b4-fd5f9cc8e2ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	accdf25c-06f9-4e7b-9678-a1acd1331088	4907cd60-4fe6-43fb-a1b4-fd5f9cc8e2ae	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
9f21e389-a75e-4483-b723-cfc9cf50d3b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	9373c4ae-71e3-11e3-8d00-a3618c7b2ae5	9f21e389-a75e-4483-b723-cfc9cf50d3b6	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
768be97b-eea1-4cfd-958b-76eca9836363	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	724ef4b0-3f1e-e211-ad21-a3a026533b4a	768be97b-eea1-4cfd-958b-76eca9836363	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
9f153b3f-5427-436b-901b-9c63d3122702	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	94440896-8c99-11e3-ac3f-a3e636726f74	9f153b3f-5427-436b-901b-9c63d3122702	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
1884f3e1-bb3c-463f-a62f-01a8bd8560ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	2e1ffdef-a176-4b92-a196-a4e28455403d	1884f3e1-bb3c-463f-a62f-01a8bd8560ae	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
656d0f32-e3be-4445-a002-e2374ed9fa1b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	12ce8e21-0d8f-e211-8adf-a5d1cdfc52ac	656d0f32-e3be-4445-a002-e2374ed9fa1b	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
2e5a5e4d-8845-4e03-9ad0-e08616152701	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	ea95c523-7a1a-e211-8842-a9f06a07ae1b	2e5a5e4d-8845-4e03-9ad0-e08616152701	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
3940f556-208b-4d92-bbaa-17e5b1009d8c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	8166568f-7b1a-e211-8842-a9f06a07ae1b	3940f556-208b-4d92-bbaa-17e5b1009d8c	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
4ea813ea-6604-48b0-bf01-5fa55c9f2b8b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	0b4ceeec-3c96-11e4-84b3-ab002f41a8b8	4ea813ea-6604-48b0-bf01-5fa55c9f2b8b	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
f592a0bc-f13e-4297-b2d5-6727105721a9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	5d81ded5-cf07-e211-9482-ab4b6567f9f7	f592a0bc-f13e-4297-b2d5-6727105721a9	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
580538b3-236f-4cd6-9c55-2104b8f8c4ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	fcb1333e-564a-11e3-8a8e-ab90d2049a72	580538b3-236f-4cd6-9c55-2104b8f8c4ae	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
e497c017-84ce-4dab-8495-bb5c6aeab564	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	7bc4be4e-94d9-11e3-bb8e-af0feebc548b	e497c017-84ce-4dab-8495-bb5c6aeab564	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
422061b2-064b-4e7e-8022-fa66bcae4154	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	480ab734-94d9-11e3-af34-afde42cffeec	422061b2-064b-4e7e-8022-fa66bcae4154	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
7303ec90-1531-46f0-ac98-34071aa03700	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	00892e3c-bf90-412d-a2dd-b1615ea2c6f2	7303ec90-1531-46f0-ac98-34071aa03700	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
d2e43f7d-4192-47f2-8396-6f0615aa7ab7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	872b669d-a706-e211-b032-b1f1b004bcca	d2e43f7d-4192-47f2-8396-6f0615aa7ab7	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
ffb4a1cb-6c0f-4e94-8d10-5cad682c0c25	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	5d16430e-fc2c-4850-bbd6-dda5bfdae36f	6ee5bc34-5427-42bf-827d-ef0786c4d886	\N	2020-03-14 16:46:34	2022-04-05 06:43:18	2022-04-05 06:43:18	2020-04-28 06:37:45
9d579adb-101f-435f-80d4-99c93980447c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	38ceb9f3-db02-e211-b4b6-b3231a53305c	9d579adb-101f-435f-80d4-99c93980447c	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
89191a3b-1356-4cce-997c-070cb6007f23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	29e9ea54-df02-e211-b4b6-b3231a53305c	89191a3b-1356-4cce-997c-070cb6007f23	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
b8d113d8-7e31-4191-b9ee-49c5253e6b7c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	bede3706-7809-11e3-acc7-b7cb53fe2add	b8d113d8-7e31-4191-b9ee-49c5253e6b7c	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
48dfc108-2325-4135-937c-9cb1153d14ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	de4c9890-94d7-11e3-87b3-bf380a55277f	48dfc108-2325-4135-937c-9cb1153d14ef	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
e011b73e-ac5d-40e1-af40-82a7a828e88d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	e4cf82c4-67df-11e3-a0f5-c792454ff412	e011b73e-ac5d-40e1-af40-82a7a828e88d	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
8f91be44-986a-42cf-9536-7ad553f5c78f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	b9b3e453-5f83-4976-91c2-cb4c8b272a0c	8f91be44-986a-42cf-9536-7ad553f5c78f	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
6f272330-8aa7-43a2-88c9-ec146cd7e812	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	0ea06995-f218-4530-9b63-0b499a11b034	b4b1af2a-3bf8-4205-bb8b-e4adc5e47da7	\N	2020-03-14 16:46:31	2020-04-28 06:37:45	\N	2020-04-28 06:37:45
5c6191aa-cfc6-45ab-9fb6-d50244818a51	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7033d6a0-a087-4922-a949-32763edc8bc4	5c6191aa-cfc6-45ab-9fb6-d50244818a51	\N	2020-03-14 16:46:34	2022-12-01 10:22:50	\N	2020-04-28 06:37:45
07130a25-eb22-45a2-8442-3e82ed0f9ce3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	07130a25-eb22-45a2-8442-3e82ed0f9ce3	\N	2020-03-14 16:46:30	2022-12-01 10:22:52	\N	2020-04-28 06:37:44
044f90c0-bef0-40d5-aa9f-18a42fc8950e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	a6fed8b4-950c-4621-9932-ba8a45b84935	044f90c0-bef0-40d5-aa9f-18a42fc8950e	\N	2020-03-14 16:46:34	2022-12-01 10:22:54	\N	2020-04-28 06:37:46
13a0a8dd-1d4b-4a6c-b97b-24bc2aba5cab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	13a0a8dd-1d4b-4a6c-b97b-24bc2aba5cab	\N	2020-03-14 16:46:25	2022-12-01 10:22:54	\N	2020-04-28 06:37:42
16e0774e-ec53-40d0-a623-49ede7e10d9c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	16e0774e-ec53-40d0-a623-49ede7e10d9c	\N	2020-03-14 16:46:25	2022-12-01 10:22:57	\N	2020-04-28 06:37:42
22548b76-f34e-4eef-b75b-1f204f98c250	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	079a34b8-4b76-11e5-814d-b3ab2368e254	22548b76-f34e-4eef-b75b-1f204f98c250	\N	2020-03-14 16:46:31	2022-12-01 10:22:57	\N	2020-04-28 06:37:45
2ac616b3-d06a-4d5a-a05e-17fa5c7810b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d28672c2-c5a5-4238-a802-fd30f1f8341d	2ac616b3-d06a-4d5a-a05e-17fa5c7810b4	\N	2020-03-14 16:46:24	2022-12-01 10:22:59	\N	2020-04-28 06:37:41
ed3b4079-71a0-4dea-8dac-493df0aa6f63	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7ab0ba14-a17f-4ecd-8201-a673cc87846c	ed3b4079-71a0-4dea-8dac-493df0aa6f63	\N	2020-03-14 16:46:34	2022-12-01 10:22:59	\N	2020-04-28 06:37:46
76fe5cc4-6e1b-4f83-a1be-245fc3ac6b91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ea363a5f-9119-468b-8fea-9187ba92c13e	76fe5cc4-6e1b-4f83-a1be-245fc3ac6b91	\N	2020-03-14 16:46:25	2022-12-01 10:23:00	\N	2020-04-28 06:37:42
85d01539-d32e-447f-a474-cb56aefe1d05	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	85d01539-d32e-447f-a474-cb56aefe1d05	\N	2020-03-14 16:46:34	2022-12-01 10:23:01	\N	2020-04-28 06:37:46
2d2288df-ec63-47b3-9457-0fe02cf40aa4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	1f6639a7-562e-44f9-b1c8-a98935a9193c	2d2288df-ec63-47b3-9457-0fe02cf40aa4	\N	2020-03-14 16:46:34	2022-12-01 10:23:01	\N	2020-04-28 06:37:46
1febd06e-4d9b-46d0-8612-7f83f432df5c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	1febd06e-4d9b-46d0-8612-7f83f432df5c	\N	2020-03-14 16:46:34	2022-12-01 10:23:01	\N	2020-04-28 06:37:46
ccc988ba-3b44-437e-82d6-91a1b17d1b93	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7661d6a5-1907-41fd-8c82-a5fea385fef8	ccc988ba-3b44-437e-82d6-91a1b17d1b93	\N	2020-03-14 16:46:34	2022-12-01 10:23:02	\N	2020-04-28 06:37:46
afc5b2e2-033c-4a35-8157-2cd3944c65b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	542df659-4377-411d-9fa8-1f5ce8878479	afc5b2e2-033c-4a35-8157-2cd3944c65b9	\N	2020-03-14 16:46:25	2022-12-01 10:23:04	\N	2020-04-28 06:37:42
dce8452d-9aa6-4982-9b27-2734118b0f2f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	dce8452d-9aa6-4982-9b27-2734118b0f2f	\N	2020-03-14 16:46:26	2022-12-01 10:23:05	\N	2020-04-28 06:37:42
1398f25b-3f8c-4a15-90a3-9e4ff0d67499	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	679c6691-5977-4188-b9cb-15090b3fb85f	1398f25b-3f8c-4a15-90a3-9e4ff0d67499	\N	2020-03-14 16:46:28	2022-12-01 10:23:05	\N	2020-04-28 06:37:43
32b6928b-ffad-4277-b74a-8b56bfc835ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	243b6119-e39f-4849-8fd0-218155575c5a	32b6928b-ffad-4277-b74a-8b56bfc835ee	\N	2020-03-14 16:46:28	2022-12-01 10:23:07	\N	2020-04-28 06:37:44
e4b4e3d0-44fe-4490-a5ff-97e4702e190b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	26925a68-aab1-11e5-bde5-bb0a0689b68c	e4b4e3d0-44fe-4490-a5ff-97e4702e190b	\N	2020-03-14 16:46:34	2022-12-01 10:23:08	\N	2020-04-28 06:37:46
93329679-233d-4645-ab6a-434a1e846520	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	93329679-233d-4645-ab6a-434a1e846520	\N	2020-03-14 16:46:34	2022-12-01 10:23:09	\N	2020-04-28 06:37:46
9fe98b92-4049-4ab0-9ee9-4523b869fc9f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	5899f113-d963-4965-9245-1f6222f5bbc1	9fe98b92-4049-4ab0-9ee9-4523b869fc9f	\N	2020-03-14 16:46:25	2022-12-01 10:23:13	\N	2020-04-28 06:37:42
729f8f8b-27d9-4285-bf45-22332582228b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	b255e348-4b76-11e5-8241-13af4f7fae26	729f8f8b-27d9-4285-bf45-22332582228b	\N	2020-03-14 16:46:25	2022-12-01 10:23:13	\N	2020-04-28 06:37:41
0b94aa0f-5378-479c-8c9a-48f29bf5528f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	8462527e-862e-4b54-b09b-a9c99a9f276d	0b94aa0f-5378-479c-8c9a-48f29bf5528f	\N	2020-03-14 16:46:34	2022-12-01 10:23:17	\N	2020-04-28 06:37:46
5f430a42-930d-4222-b15a-2cad6b7207b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	162955a4-43dc-4ee3-85f2-b4b602c72400	5f430a42-930d-4222-b15a-2cad6b7207b7	\N	2020-03-14 16:46:25	2022-12-01 10:23:17	\N	2020-04-28 06:37:42
83a49eda-7444-437f-8be3-34ec8035ad23	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	93853854-479a-11e5-8f29-97b6ab3d09e1	83a49eda-7444-437f-8be3-34ec8035ad23	\N	2020-03-14 16:46:29	2022-12-01 10:23:21	\N	2020-04-28 06:37:44
3e98fe10-5de9-4da3-bca4-263192dbbdf5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7661d6a5-1907-41fd-8c82-a5fea385fef8	3e98fe10-5de9-4da3-bca4-263192dbbdf5	\N	2020-03-14 16:46:26	2022-12-01 10:23:22	\N	2020-04-28 06:37:42
a2cb519a-c097-4383-8ec4-1c60d3c3c715	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	0c57cc9c-4c32-11e5-858c-afbc5904667e	a2cb519a-c097-4383-8ec4-1c60d3c3c715	\N	2020-03-14 16:46:34	2022-12-01 10:23:24	\N	2020-04-28 06:37:46
be85427e-a12c-4438-90bc-2ae06bcc4a26	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	43995feb-8d7d-4f37-9a8b-b2ab3ff70ac2	be85427e-a12c-4438-90bc-2ae06bcc4a26	\N	2020-03-14 16:46:34	2022-12-01 10:23:24	\N	2020-04-28 06:37:46
1d023451-cc5c-405c-a507-77b5ddc65e02	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	7ab0ba14-a17f-4ecd-8201-a673cc87846c	1d023451-cc5c-405c-a507-77b5ddc65e02	\N	2020-03-14 16:46:34	2022-12-01 10:23:24	\N	2020-04-28 06:37:46
c6473992-d8d8-4dd0-9237-4b2962565e2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	d85e860f-35a9-4406-8bc6-0e4051153600	c6473992-d8d8-4dd0-9237-4b2962565e2e	\N	2020-03-14 16:46:25	2022-12-01 10:23:26	\N	2020-04-28 06:37:42
13ae2c87-7e64-4d6c-a932-441bdfdc4559	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	8e10391f-07fe-41b9-84c7-106974b83db3	13ae2c87-7e64-4d6c-a932-441bdfdc4559	\N	2020-03-14 16:46:25	2022-12-01 10:23:26	\N	2020-04-28 06:37:41
6c590d18-339c-4e4a-9b77-204d511dbc0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	6c590d18-339c-4e4a-9b77-204d511dbc0d	\N	2020-03-14 16:46:25	2022-12-01 10:23:30	\N	2020-04-28 06:37:42
29bd5eba-0c03-4c24-9114-845735c82e5f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	7938fa3c-d367-11e4-9fd3-cf08d3096732	29bd5eba-0c03-4c24-9114-845735c82e5f	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
c6e3030d-956f-4158-99fc-720e8914685d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	c1b3fff9-1e1c-4ebb-9332-a681f844167c	3d2787cc-f76b-4ce2-a350-cffecfc2216a	c6e3030d-956f-4158-99fc-720e8914685d	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
7c23f514-7be2-4c01-bb39-09ebcf79a785	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	2fb17dee-c9a5-4e06-873d-d0441f792754	7c23f514-7be2-4c01-bb39-09ebcf79a785	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
085b47fa-6078-4e50-9799-c5b1e913d648	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	57ce637d-8acd-e211-b850-d12bb761bc4d	085b47fa-6078-4e50-9799-c5b1e913d648	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
054f362a-0c75-4ed9-bcd1-0af09a0f0325	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	8366667d-8acd-e211-b897-d12bb761bc4d	054f362a-0c75-4ed9-bcd1-0af09a0f0325	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
58e31e4a-0e4a-4513-9fa1-70f5c9bdfcee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	80b4667d-8acd-e211-b89c-d12bb761bc4d	58e31e4a-0e4a-4513-9fa1-70f5c9bdfcee	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
233a5072-8c30-495b-9a35-2a6e59ed4d5f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	9adb667d-8acd-e211-b8a0-d12bb761bc4d	233a5072-8c30-495b-9a35-2a6e59ed4d5f	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
04603b62-725c-4c16-a24a-28464b1b6774	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	fcc5677d-8acd-e211-b8be-d12bb761bc4d	04603b62-725c-4c16-a24a-28464b1b6774	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
c7b9ccd1-2bc8-408b-b639-e7019bd0b6cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	63a8490b-068c-45da-92b9-da3c07470b9a	c7b9ccd1-2bc8-408b-b639-e7019bd0b6cb	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
7d88f24b-beeb-4405-a46e-c91eef296aae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	bf147454-3d40-11e4-bd52-dfaac3a0de5c	7d88f24b-beeb-4405-a46e-c91eef296aae	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
ed42238b-f71e-42bb-be77-d0ec9e69f75b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	0769190c-5d64-11e3-8b30-dffbe206ec8a	ed42238b-f71e-42bb-be77-d0ec9e69f75b	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
febe6a77-80e1-4d83-b5be-04f844f97120	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	1183643b-91b2-4d5c-b16c-6e9fbd714943	1043eb6a-a5c9-4e29-92ec-e5a3eea29247	febe6a77-80e1-4d83-b5be-04f844f97120	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
70bb2870-e4b4-4a6a-aa2f-b05c7e1e19cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	49b646f0-5bb5-11e3-a96d-e7586c796b63	70bb2870-e4b4-4a6a-aa2f-b05c7e1e19cf	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
716c8b78-d17b-42af-9254-2d5d89271182	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	b6535f4d-aa3a-4c05-9caa-5046cda60c8c	20214244-2a0f-11e4-a2a9-eb1809ae2b35	716c8b78-d17b-42af-9254-2d5d89271182	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
1273b8f7-a4e2-455c-b0a5-6e586b4076f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	bded16da-7c0d-4e26-85b9-c7820460e8a9	7adea11a-561c-11e5-900a-eb2673a1373b	1273b8f7-a4e2-455c-b0a5-6e586b4076f1	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
56a9828b-3881-4970-9bd7-bcc288994ea0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	b4745045-5baf-416a-9da6-ec039566537b	56a9828b-3881-4970-9bd7-bcc288994ea0	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
6fe35a70-c37b-4d3e-b796-cc40be61f102	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	07895c42-92c7-11e3-a5fe-ef12f41a2222	6fe35a70-c37b-4d3e-b796-cc40be61f102	\N	2023-10-03 11:14:47	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
0ad6129b-ed2f-4a57-a9e9-87a2d84d74b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	912be006-94d8-11e3-9fbf-ef2adf253ed7	0ad6129b-ed2f-4a57-a9e9-87a2d84d74b8	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
fd989134-8967-41d2-a5de-abf273003fea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	7fb034f2-23fc-46ff-b0d3-bcb87e77cac1	ef8b39a6-5b64-11e3-b441-f77bcf353f34	fd989134-8967-41d2-a5de-abf273003fea	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
2a2b8542-d609-4ed3-aab6-b15137ddf5b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	08efcb44-3dbd-47bf-8a59-28790fab4609	3e7374e8-2bf3-11e4-af70-f7c93647854e	2a2b8542-d609-4ed3-aab6-b15137ddf5b8	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
6e82933e-093c-4b42-b49c-8a320e32a411	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	0494c011-fd20-411c-b6f3-022d10cfb1b4	d01ebf2d-9956-4c18-9daf-48a69b35019b	\N	2020-03-14 16:46:25	2020-04-28 06:37:42	\N	2020-04-28 06:37:42
34dd3059-2963-44c2-bb70-551f43c65e2a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	7dbbb577-7b93-48ef-b139-db84e9163597	34dd3059-2963-44c2-bb70-551f43c65e2a	\N	2020-03-14 16:46:34	2022-12-01 10:22:50	\N	2020-04-28 06:37:46
133fc8e7-1f90-4887-be09-27b9c96b2350	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	e3549675-96bb-4c36-9d4e-b034c5de4b80	133fc8e7-1f90-4887-be09-27b9c96b2350	\N	2020-03-14 16:46:25	2022-12-01 10:22:51	\N	2020-04-28 06:37:42
b44bbbf8-fad5-4d2e-aaf6-ac2bcb28adb0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	b44bbbf8-fad5-4d2e-aaf6-ac2bcb28adb0	\N	2020-03-14 16:46:34	2022-12-01 10:22:52	\N	2020-04-28 06:37:46
24653598-562f-46a3-901c-634c057d8759	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	24653598-562f-46a3-901c-634c057d8759	\N	2020-04-16 13:31:35	2022-12-01 10:22:52	\N	2020-04-16 13:31:35
b948d66c-2360-4c70-8908-fafeda904646	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	b948d66c-2360-4c70-8908-fafeda904646	\N	2020-03-14 16:46:35	2022-12-01 10:22:54	\N	2020-04-28 06:37:46
78eb256b-2740-4885-a1cd-c391277bf9dc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	9b057256-628e-4516-a951-a78bd3651d4b	78eb256b-2740-4885-a1cd-c391277bf9dc	\N	2020-04-16 13:31:35	2022-12-01 10:22:56	\N	2020-04-16 13:31:35
f403b6ef-1f8a-4940-b68d-45854823c3ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	99f38034-4a28-11e5-a3b9-ff498a91b449	f403b6ef-1f8a-4940-b68d-45854823c3ab	\N	2020-04-16 13:31:35	2022-12-01 10:22:57	\N	2020-04-16 13:31:35
edac20c3-2e38-4ccf-9a79-47ae03b12686	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	edac20c3-2e38-4ccf-9a79-47ae03b12686	\N	2020-04-16 13:31:35	2022-12-01 10:22:57	\N	2020-04-16 13:31:35
fd8ed8cc-5c09-4a31-a431-92416852642f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	ea78c435-c2ca-4ef0-a6d8-2c536a12f7ff	fd8ed8cc-5c09-4a31-a431-92416852642f	\N	2020-04-16 13:31:35	2022-12-01 10:22:59	\N	2020-04-16 13:31:35
9301febf-bd1e-46bc-9d8a-278d87fb93f6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	9301febf-bd1e-46bc-9d8a-278d87fb93f6	\N	2020-03-14 16:46:34	2022-12-01 10:23:00	\N	2020-04-28 06:37:46
935123ca-6d80-4f3c-9e6d-6cbe4e1de986	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	06555036-10af-41b8-b767-260f6d366218	935123ca-6d80-4f3c-9e6d-6cbe4e1de986	\N	2020-04-16 13:31:35	2022-12-01 10:23:02	\N	2020-04-16 13:31:35
e81a40db-3d50-432b-9e30-2e9b0414650c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	ad705d8a-429e-11e5-a989-af44a02d940a	e81a40db-3d50-432b-9e30-2e9b0414650c	\N	2020-04-16 13:31:35	2022-12-01 10:23:05	\N	2020-04-16 13:31:35
a1e8f419-2b10-4ac6-b67f-0a9c4985e89d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	a1e8f419-2b10-4ac6-b67f-0a9c4985e89d	\N	2020-04-16 13:31:35	2022-12-01 10:23:06	\N	2020-04-16 13:31:35
b645b462-28d8-42dd-acfd-3036aa7f074b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	f9496132-3b0c-11e5-a92d-b7a7850016b8	b645b462-28d8-42dd-acfd-3036aa7f074b	\N	2020-04-16 13:31:35	2022-12-01 10:23:10	\N	2020-04-16 13:31:35
bf5d1d74-b8f5-4e5b-b34c-1725b09569d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	079a34b8-4b76-11e5-814d-b3ab2368e254	bf5d1d74-b8f5-4e5b-b34c-1725b09569d3	\N	2020-04-16 13:31:35	2022-12-01 10:23:10	\N	2020-04-16 13:31:35
2ed78aa0-b18b-432e-9da6-482dfc6835a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	5b61121a-264f-490f-86b1-551372be86d1	2ed78aa0-b18b-432e-9da6-482dfc6835a4	\N	2020-04-16 13:31:35	2022-12-01 10:23:10	\N	2020-04-16 13:31:35
51f0f22e-28a2-407d-8bd1-a59c5967be45	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	9e8380ef-47fb-4968-add6-6aaebdebb939	51f0f22e-28a2-407d-8bd1-a59c5967be45	\N	2020-04-16 13:31:35	2022-12-01 10:23:11	\N	2020-04-16 13:31:35
afcb26b0-defd-4086-8f94-319762985810	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	74b1c647-0142-4355-a2af-d5a15f1d2358	afcb26b0-defd-4086-8f94-319762985810	\N	2020-04-16 13:31:35	2022-12-01 10:23:11	\N	2020-04-16 13:31:35
fa8185d6-4ad4-4643-aadd-254ab8890e2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	52d5486a-4544-11e5-b3ea-131ef06916b5	fa8185d6-4ad4-4643-aadd-254ab8890e2d	\N	2020-04-16 13:31:35	2022-12-01 10:23:13	\N	2020-04-16 13:31:35
65a6df2b-7070-4ac8-926e-caf492c52d6d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	7363a404-46e9-11e5-8413-7fabf05ee1fd	65a6df2b-7070-4ac8-926e-caf492c52d6d	\N	2020-04-16 13:31:35	2022-12-01 10:23:13	\N	2020-04-16 13:31:35
05670e89-0dde-45bc-8e32-50ec657fb23a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	05670e89-0dde-45bc-8e32-50ec657fb23a	\N	2020-04-16 13:31:35	2022-12-01 10:23:15	\N	2020-04-16 13:31:35
861dd65f-37c2-4702-9f78-fd8e47a181d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	9833a660-4b73-11e5-934e-37a2f6ed830d	861dd65f-37c2-4702-9f78-fd8e47a181d7	\N	2020-04-16 13:31:35	2022-12-01 10:23:15	\N	2020-04-16 13:31:35
011070c5-4c18-4ae0-9390-d053f9b4368b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	67390022-7626-4bf5-a07f-1f5dd137f72e	011070c5-4c18-4ae0-9390-d053f9b4368b	\N	2020-04-16 13:31:35	2022-12-01 10:23:15	\N	2020-04-16 13:31:35
be786899-9d46-4b09-9cf0-c6fa94ed142c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	8a5395ea-c758-4eb7-b436-571f527789a2	be786899-9d46-4b09-9cf0-c6fa94ed142c	\N	2020-04-16 13:31:35	2022-12-01 10:23:15	\N	2020-04-16 13:31:35
f09f1e16-57cf-477f-b855-0512fe27837e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	22160fc9-321a-40b5-849f-f8db354b9185	f09f1e16-57cf-477f-b855-0512fe27837e	\N	2020-03-14 16:46:35	2022-12-01 10:23:16	\N	2020-04-28 06:37:46
4da62a45-341d-4af9-a62f-b2fe85bfc88d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	60c2ff20-4b6c-11e5-958c-b39420b5676f	4da62a45-341d-4af9-a62f-b2fe85bfc88d	\N	2020-04-16 13:31:35	2022-12-01 10:23:17	\N	2020-04-16 13:31:35
9bd2fd95-90f7-462e-a1da-12456c7ca51f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	da2e3e30-22ee-11e4-90f6-53330a5cd670	9bd2fd95-90f7-462e-a1da-12456c7ca51f	\N	2020-04-16 13:31:36	2022-12-01 10:23:17	\N	2020-04-16 13:31:36
ee7fe056-727e-45d4-87e6-1bd059e7dff1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	fbf89e5d-fe1e-4c14-afdc-c73e917a52ba	ee7fe056-727e-45d4-87e6-1bd059e7dff1	\N	2020-04-16 13:31:35	2022-12-01 10:23:18	\N	2020-04-16 13:31:35
e8a03c2e-e2ed-4987-ac88-95b89a3d5268	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	c8ee9713-6348-4525-ac7a-27b373d312df	e8a03c2e-e2ed-4987-ac88-95b89a3d5268	\N	2020-04-16 13:31:36	2022-12-01 10:23:19	\N	2020-04-16 13:31:36
516fdaac-ecff-4ec0-be68-0abf6f214c17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	b255e348-4b76-11e5-8241-13af4f7fae26	516fdaac-ecff-4ec0-be68-0abf6f214c17	\N	2020-04-16 13:31:36	2022-12-01 10:23:22	\N	2020-04-16 13:31:36
641b9e76-04c2-4cfc-9e56-88adc066963e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	26925a68-aab1-11e5-bde5-bb0a0689b68c	641b9e76-04c2-4cfc-9e56-88adc066963e	\N	2020-04-16 13:31:35	2022-12-01 10:23:22	\N	2020-04-16 13:31:35
403c65c7-c3f0-4f17-8b77-b98977a8b05f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	fa092490-4b74-11e5-a33d-db9868dda03f	403c65c7-c3f0-4f17-8b77-b98977a8b05f	\N	2020-04-16 13:31:36	2022-12-01 10:23:24	\N	2020-04-16 13:31:36
93b501ac-c783-4d1c-9a81-abfdc45a9e74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	d313aa86-3092-4ceb-8e53-fabcecc2a37a	93b501ac-c783-4d1c-9a81-abfdc45a9e74	\N	2020-04-16 13:31:35	2022-12-01 10:23:25	\N	2020-04-16 13:31:35
39da362d-81eb-4462-9da2-2983a24fd795	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	39da362d-81eb-4462-9da2-2983a24fd795	\N	2020-03-14 16:46:35	2022-12-01 10:23:25	\N	2020-04-28 06:37:46
33c5c0e4-c594-4436-967d-d7a05db20847	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	e131badd-15c9-4911-8c81-1d30249b7d73	33c5c0e4-c594-4436-967d-d7a05db20847	\N	2020-04-16 13:31:36	2022-12-01 10:23:25	\N	2020-04-16 13:31:36
c1384b13-7eb9-43f3-bab0-d6e3f91015d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	22160fc9-321a-40b5-849f-f8db354b9185	c1384b13-7eb9-43f3-bab0-d6e3f91015d8	\N	2020-03-14 16:46:35	2022-12-01 10:23:26	\N	2020-04-28 06:37:46
ea75ef66-acf1-4de1-a103-a4d53e5134f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	54894cf6-ecf9-44c5-87e8-b87e6bf62120	ea75ef66-acf1-4de1-a103-a4d53e5134f8	\N	2020-04-16 13:31:35	2022-12-01 10:23:26	\N	2020-04-16 13:31:35
e6ab200a-26d8-41af-bd2d-ee97ba09ee29	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	e6ab200a-26d8-41af-bd2d-ee97ba09ee29	\N	2020-04-16 13:31:35	2022-12-01 10:23:29	\N	2020-04-16 13:31:35
7b089d2e-9167-4d67-9de0-9af8a75fef16	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	7b089d2e-9167-4d67-9de0-9af8a75fef16	\N	2020-03-14 16:46:35	2022-12-01 10:23:29	\N	2020-04-28 06:37:46
4aba8d40-6acb-44bd-b301-e95cf64b3f66	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	83fc2461-48fa-4ea5-b705-f77593d9a90f	4aba8d40-6acb-44bd-b301-e95cf64b3f66	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
b07b30f0-50fb-4fc4-865a-cdb4fe559c0c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	bd3a0c44-e22e-4d41-8a5f-faa202d55704	b07b30f0-50fb-4fc4-865a-cdb4fe559c0c	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
4285dfe2-e5bc-4b38-a8cb-4f037b57bf2d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	c3a6bc57-6e00-e211-80cc-fb6620ab7282	4285dfe2-e5bc-4b38-a8cb-4f037b57bf2d	\N	2023-11-20 07:50:45	2023-11-20 07:50:45	\N	2023-10-21 07:50:45
79ee4891-590c-4783-ae1e-65b3222cc70d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	03338f11-6364-4371-91b8-b0ca39b25a80	a990755d-db89-48e1-9e88-fbff0e01d35c	79ee4891-590c-4783-ae1e-65b3222cc70d	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
1dfca763-3b2f-4e3f-8976-04095eaeaf48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	2c745a77-520e-e211-88dd-fd84abc6dc9a	1dfca763-3b2f-4e3f-8976-04095eaeaf48	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
4eea22b8-339d-4a9d-9663-0bff11f25d37	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	64b4f09b-53c7-45f1-83a2-225d27162b3c	b4b12980-d435-43ee-af2d-fed372080d2f	4eea22b8-339d-4a9d-9663-0bff11f25d37	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
9406a5cc-9b8f-4e1d-9a56-701b3f27cdf3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	86549ef3-f49b-492c-8f52-48c22f7050eb	feedc192-f1f1-4ed6-bbaf-ff4c44f2d97b	9406a5cc-9b8f-4e1d-9a56-701b3f27cdf3	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
70405026-7b48-435a-aa11-2dd6031d7baa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	00964ff7-97a3-441a-ad5e-871420b6f11b	fd19ac6d-b727-e211-963e-ffbc9c164446	70405026-7b48-435a-aa11-2dd6031d7baa	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
8d8fa7f3-bb6e-4d8d-9fe1-6c1e5efd2b61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20231	436ac214-dd0c-437a-bbba-7bbe481603bf	91a30c77-bf27-e211-963e-ffbc9c164446	8d8fa7f3-bb6e-4d8d-9fe1-6c1e5efd2b61	\N	2023-10-03 11:14:48	2023-12-05 09:39:46	\N	2023-11-05 09:39:46
6e19aa0b-94df-4578-a87d-b5a35fbb47c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	a6fed8b4-950c-4621-9932-ba8a45b84935	b8ce4e69-0a03-44c0-9728-38b9279f0eaa	\N	2020-04-16 13:31:35	2020-04-16 13:31:35	\N	2020-04-16 13:31:35
6e28c0f7-837e-456f-8670-84604eac3924	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	8c84bc7b-c3ff-4645-9428-0e71923a7eb3	\N	2020-04-16 13:31:35	2020-04-16 13:31:35	\N	2020-04-16 13:31:35
5a5176dd-a63a-4634-b57b-c869775749d7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	c593fef2-46d2-11e5-b14e-8fa23f386b5a	5a5176dd-a63a-4634-b57b-c869775749d7	\N	2020-04-16 13:31:35	2022-12-01 10:22:49	\N	2020-04-16 13:31:35
9da006ae-e74b-48a5-8b98-08e3a432ded7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	021d11bc-3d8a-11e5-b1d1-733403640dea	9da006ae-e74b-48a5-8b98-08e3a432ded7	\N	2020-04-16 13:31:35	2022-12-01 10:22:52	\N	2020-04-16 13:31:35
47d58abe-103d-4019-a455-6f051863fc57	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	47d58abe-103d-4019-a455-6f051863fc57	\N	2020-04-16 13:31:35	2022-12-01 10:22:52	\N	2020-04-16 13:31:35
acaab308-0c9f-4d7a-ba6d-8a2a2d9894b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	c795df6e-a22f-478f-9005-76d13d30bab4	acaab308-0c9f-4d7a-ba6d-8a2a2d9894b8	\N	2020-04-16 13:31:36	2022-12-01 10:22:53	\N	2020-04-16 13:31:36
54e4ec15-9a9d-482f-993b-565c07009eae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	ff07bc11-35f4-4ff1-a749-78e30f56e52c	54e4ec15-9a9d-482f-993b-565c07009eae	\N	2020-04-16 13:31:36	2022-12-01 10:22:53	\N	2020-04-16 13:31:36
da5c233b-9535-43f2-840c-7dc8d02e350d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	607b1b72-46d2-11e5-ba50-1375139e8458	da5c233b-9535-43f2-840c-7dc8d02e350d	\N	2020-04-16 13:31:36	2022-12-01 10:22:54	\N	2020-04-16 13:31:36
09328135-d17b-4d1b-8e99-ba9478b0cc66	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	679c6691-5977-4188-b9cb-15090b3fb85f	09328135-d17b-4d1b-8e99-ba9478b0cc66	\N	2020-04-16 13:31:36	2022-12-01 10:22:55	\N	2020-04-16 13:31:36
18d82ab4-13e8-41f0-b1ec-54b2e9af14b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	18d82ab4-13e8-41f0-b1ec-54b2e9af14b0	\N	2020-03-14 16:46:34	2022-12-01 10:22:56	\N	2020-04-28 06:37:46
31827a9c-64fb-4ea6-ba36-9d00d78874d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	568a2d30-3a78-43fd-81ea-2c98ec3d3865	31827a9c-64fb-4ea6-ba36-9d00d78874d8	\N	2020-04-16 13:31:36	2022-12-01 10:22:58	\N	2020-04-16 13:31:36
3b971323-63e2-45ac-8000-bedc6dee5516	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	7b6763fc-6f9f-11e3-b017-03efaa0c94af	3b971323-63e2-45ac-8000-bedc6dee5516	\N	2020-04-16 13:31:36	2022-12-01 10:22:59	\N	2020-04-16 13:31:36
51f3c922-d936-4663-9baf-03fae3863976	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	d8c7e3dd-208a-4729-95fe-33e6c423a9ef	51f3c922-d936-4663-9baf-03fae3863976	\N	2020-04-16 13:31:36	2022-12-01 10:23:00	\N	2020-04-16 13:31:36
e8e03dd1-3965-4a07-8223-b8ba1f4901e3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	e8e03dd1-3965-4a07-8223-b8ba1f4901e3	\N	2020-04-16 13:31:36	2022-12-01 10:23:01	\N	2020-04-16 13:31:36
70b0bc33-d704-4989-960c-a9a39589e8dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	70b0bc33-d704-4989-960c-a9a39589e8dd	\N	2020-04-16 13:31:36	2022-12-01 10:23:02	\N	2020-04-16 13:31:36
7a6e2c89-e076-4d8e-af60-e6176b01747b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	fd2e81be-ca4c-4320-9549-82c37f311556	7a6e2c89-e076-4d8e-af60-e6176b01747b	\N	2020-04-16 13:31:36	2022-12-01 10:23:04	\N	2020-04-16 13:31:36
b8ecc3f0-b9a3-4b4a-bedf-337b3238676a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	3e20af19-c84c-4fb4-9326-a47a5a8087c1	b8ecc3f0-b9a3-4b4a-bedf-337b3238676a	\N	2020-04-16 13:31:36	2022-12-01 10:23:04	\N	2020-04-16 13:31:36
e242dd64-0ff6-4ee6-b840-6df88058a6aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	e242dd64-0ff6-4ee6-b840-6df88058a6aa	\N	2020-04-16 13:31:36	2022-12-01 10:23:04	\N	2020-04-16 13:31:36
6ae26047-40a2-446f-b3e2-3f5e2b046fde	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	e7692714-42a9-11e5-a70e-2322869c051b	6ae26047-40a2-446f-b3e2-3f5e2b046fde	\N	2020-04-16 13:31:36	2022-12-01 10:23:04	\N	2020-04-16 13:31:36
2c5a56f6-61d7-420c-80b0-e5be4e156bc3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	2c5a56f6-61d7-420c-80b0-e5be4e156bc3	\N	2020-04-16 13:31:36	2022-12-01 10:23:05	\N	2020-04-16 13:31:36
f7cd557b-182f-4f68-b25b-e29cff149a2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	6b031760-aef5-4dbb-b520-01e6685a54d1	f7cd557b-182f-4f68-b25b-e29cff149a2c	\N	2020-04-16 13:31:36	2022-12-01 10:23:06	\N	2020-04-16 13:31:36
107a444c-5933-43ec-bbcb-7250bf83c82e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	3ad03a6a-9caa-40e4-a060-62e1680cd17b	107a444c-5933-43ec-bbcb-7250bf83c82e	\N	2020-04-16 13:31:36	2022-12-01 10:23:06	\N	2020-04-16 13:31:36
580a0a02-9e78-4a40-ad72-3d307c8cd65f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	580a0a02-9e78-4a40-ad72-3d307c8cd65f	\N	2020-04-16 13:31:36	2022-12-01 10:23:07	\N	2020-04-16 13:31:36
a23545fe-16a1-4177-bcfd-0d981d349543	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	a23545fe-16a1-4177-bcfd-0d981d349543	\N	2020-04-16 13:31:36	2022-12-01 10:23:07	\N	2020-04-16 13:31:36
8b2c80e8-dbfb-41ef-a6e6-2f674cb94c33	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	e2312114-93a0-4f51-a478-a7330f29cffe	7ab0ba14-a17f-4ecd-8201-a673cc87846c	8b2c80e8-dbfb-41ef-a6e6-2f674cb94c33	\N	2020-04-16 13:31:36	2022-12-01 10:23:08	\N	2020-04-16 13:31:36
6725b731-97d9-4349-8b07-0f9910f7527e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	b35c01a3-37d8-4b9c-921d-65a382a1ca70	6725b731-97d9-4349-8b07-0f9910f7527e	\N	2020-04-16 13:31:36	2022-12-01 10:23:09	\N	2020-04-16 13:31:36
b0a66598-d413-4448-a738-b5a64ad6f1a5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	3ee043f8-9893-11e5-911a-5f12b6406080	b0a66598-d413-4448-a738-b5a64ad6f1a5	\N	2020-04-16 13:31:36	2022-12-01 10:23:09	\N	2020-04-16 13:31:36
cd1dea82-54cc-4ea4-8d85-6133bd254ed2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	e3549675-96bb-4c36-9d4e-b034c5de4b80	cd1dea82-54cc-4ea4-8d85-6133bd254ed2	\N	2020-04-16 13:31:36	2022-12-01 10:23:10	\N	2020-04-16 13:31:36
a813ad70-bbe6-45c8-9b0d-66f7545a2776	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	a813ad70-bbe6-45c8-9b0d-66f7545a2776	\N	2020-03-14 16:46:32	2022-12-01 10:23:10	\N	2020-04-28 06:37:46
5775d2ed-f514-4fb0-9616-66dc1840dfd3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	7a426c49-48eb-473c-9779-47a65a92d954	5775d2ed-f514-4fb0-9616-66dc1840dfd3	\N	2020-04-16 13:31:36	2022-12-01 10:23:10	\N	2020-04-16 13:31:36
011447b2-c7cb-41e0-9528-e1401407e32b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	6a26772d-e188-455a-8bd8-9c8d729a618e	011447b2-c7cb-41e0-9528-e1401407e32b	\N	2020-04-16 13:31:36	2022-12-01 10:23:10	\N	2020-04-16 13:31:36
0c0f5c50-062c-424f-8eb3-353a5df0c053	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	80f581e0-deeb-4b41-84ca-9b4bca6e6da1	0c0f5c50-062c-424f-8eb3-353a5df0c053	\N	2020-04-16 13:31:36	2022-12-01 10:23:10	\N	2020-04-16 13:31:36
f5150fc1-35b0-4077-8392-4387c7864f2a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	36aa6f27-73dc-4d6c-98e8-cb7a01d1f686	f5150fc1-35b0-4077-8392-4387c7864f2a	\N	2020-04-16 13:31:36	2022-12-01 10:23:12	\N	2020-04-16 13:31:36
7914f3bb-f2aa-4b29-9782-0363c03c177e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	54976902-8866-4627-a970-0abcb6abb6f9	7914f3bb-f2aa-4b29-9782-0363c03c177e	\N	2020-04-16 13:31:36	2022-12-01 10:23:12	\N	2020-04-16 13:31:36
10fbfcd8-3e5a-4e48-a220-3af6db4781b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	d90d0294-59e6-4283-a821-c9b6aaae536b	10fbfcd8-3e5a-4e48-a220-3af6db4781b4	\N	2020-04-16 13:31:36	2022-12-01 10:23:15	\N	2020-04-16 13:31:36
495e1b39-5ebe-43e3-92ff-0e16f6a2383e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	b7b48546-4541-11e5-b9f9-e7e850efd101	495e1b39-5ebe-43e3-92ff-0e16f6a2383e	\N	2020-04-16 13:31:36	2022-12-01 10:23:15	\N	2020-04-16 13:31:36
99d28db1-cf2d-4a04-8b56-b553c0cd29c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	31d87dba-8af0-48a5-a609-901bda9031d3	99d28db1-cf2d-4a04-8b56-b553c0cd29c7	\N	2020-04-16 13:31:36	2022-12-01 10:23:15	\N	2020-04-16 13:31:36
00de2989-3f98-4355-b638-9cc4cc0573ce	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	88c6acc3-882c-418e-b96e-f83ccccd7f79	00de2989-3f98-4355-b638-9cc4cc0573ce	\N	2020-04-16 13:31:36	2022-12-01 10:23:16	\N	2020-04-16 13:31:36
0ecdfbbb-b538-484c-8b96-deb27ac547a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	a968b612-4bac-11e5-bce0-9f0e431a474f	0ecdfbbb-b538-484c-8b96-deb27ac547a6	\N	2020-04-16 13:31:36	2022-12-01 10:23:17	\N	2020-04-16 13:31:36
90b9a380-0a97-4b40-8839-f14706648879	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	8b4ea31e-4aa0-427e-a65f-928b232d7f14	90b9a380-0a97-4b40-8839-f14706648879	\N	2020-04-16 13:31:36	2022-12-01 10:23:17	\N	2020-04-16 13:31:36
ebb1a23d-48b9-4d41-8ceb-be40a53ad8a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	097f5676-e6b8-4033-9b17-43eb6a4145bf	ebb1a23d-48b9-4d41-8ceb-be40a53ad8a0	\N	2020-03-14 16:46:32	2022-12-01 10:23:22	\N	2020-04-28 06:37:45
84e3cd06-938b-4c44-8963-3590aca485a7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	1a51ebac-521e-4169-adbe-cbd3a9bae2f0	84e3cd06-938b-4c44-8963-3590aca485a7	\N	2020-04-16 13:31:36	2022-12-01 10:23:23	\N	2020-04-16 13:31:36
a3351667-9beb-4467-8057-c0f6dfc7e99d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	4e27de9b-f65a-489f-8db8-7a6cb724fa6f	a3351667-9beb-4467-8057-c0f6dfc7e99d	\N	2020-04-16 13:31:36	2022-12-01 10:23:24	\N	2020-04-16 13:31:36
9af8574e-1266-45d7-9523-b085f77d204f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	edbf1ed9-b137-4d28-8af1-a22ab23be53b	9af8574e-1266-45d7-9523-b085f77d204f	\N	2020-04-16 13:31:36	2022-12-01 10:23:25	\N	2020-04-16 13:31:36
9478f52c-2a05-485a-bf44-4f014eeb9b27	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	72d18334-3b06-11e4-a3a4-13507c2a0677	9478f52c-2a05-485a-bf44-4f014eeb9b27	\N	2020-04-16 13:31:36	2022-12-01 10:23:25	\N	2020-04-16 13:31:36
21de0563-3668-48f7-b521-d77fd058f0a4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	50bf4b2e-cb21-e211-a1ba-0181a3c0d372	21de0563-3668-48f7-b521-d77fd058f0a4	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d3e2af36-1dcd-4ea8-af1f-fd11d878fece	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	74718817-9b33-4780-832a-02a30a0700ac	d3e2af36-1dcd-4ea8-af1f-fd11d878fece	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
70712ae6-5b5d-472f-b890-3ba5c99c22e0	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	1b27da06-3fd0-11e4-aafd-0302119fea1b	70712ae6-5b5d-472f-b890-3ba5c99c22e0	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
019d50c2-86f4-4eb3-b657-1c6eabaa9bca	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	83f64d04-319f-11e4-9c52-03475f2290ff	019d50c2-86f4-4eb3-b657-1c6eabaa9bca	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
ac76ae2d-d4f1-4d49-ab33-082b5d95ba17	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	5205fb64-3325-11e4-9113-0374e2c7198b	ac76ae2d-d4f1-4d49-ab33-082b5d95ba17	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
2a2253e7-9e50-41a6-ab1b-0ee1f905687b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	1622eb4a-4a76-11e3-8148-03e6617a0870	2a2253e7-9e50-41a6-ab1b-0ee1f905687b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
6ec29301-64be-451e-b588-ba79a1db8f6c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	7f396bb5-2fdc-48f6-acf8-05b63cd23975	6ec29301-64be-451e-b588-ba79a1db8f6c	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
986225a4-2ff5-45a5-94d2-60078dbe5e00	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	6486e837-1d8f-4549-ad86-066c5c5557a7	986225a4-2ff5-45a5-94d2-60078dbe5e00	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c2d4b32d-0d9a-46f9-819a-c22824a53b11	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	7661d6a5-1907-41fd-8c82-a5fea385fef8	c2d4b32d-0d9a-46f9-819a-c22824a53b11	\N	2020-04-16 13:31:36	2022-12-01 10:22:48	\N	2020-04-16 13:31:36
bac624a2-8d9c-4dc1-97c7-ef9e4a6f6c6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	6402418c-54f9-11e5-9e54-5397b782050d	bac624a2-8d9c-4dc1-97c7-ef9e4a6f6c6c	\N	2020-04-16 13:31:36	2022-12-01 10:22:49	\N	2020-04-16 13:31:36
9274a0b6-576f-45ee-8ecb-fb5ff93f90ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	9274a0b6-576f-45ee-8ecb-fb5ff93f90ed	\N	2020-04-16 13:31:36	2022-12-01 10:22:50	\N	2020-04-16 13:31:36
43191177-b59c-4ad2-ae43-63d5ec908b49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	11558ce2-46ca-11e5-8ba3-b7381d40fb27	43191177-b59c-4ad2-ae43-63d5ec908b49	\N	2020-04-16 13:31:36	2022-12-01 10:22:51	\N	2020-04-16 13:31:36
fa7cd081-6d50-4d67-91bc-02cd418bada4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	fa7cd081-6d50-4d67-91bc-02cd418bada4	\N	2020-04-16 13:31:36	2022-12-01 10:22:53	\N	2020-04-16 13:31:36
5a4ff7f3-ff14-48be-88b9-93dd248edf37	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	1f87026c-1601-4eb9-9b82-64289bded8ed	5a4ff7f3-ff14-48be-88b9-93dd248edf37	\N	2020-04-16 13:31:37	2022-12-01 10:22:57	\N	2020-04-16 13:31:37
32d33d24-ba46-475d-8793-f8290afc6192	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	1d64c4a6-b263-441e-82e2-763c790c3c05	32d33d24-ba46-475d-8793-f8290afc6192	\N	2020-04-16 13:31:37	2022-12-01 10:22:57	\N	2020-04-16 13:31:37
15d7619f-a6ba-48a2-b0b2-1b1de0f316c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	15d7619f-a6ba-48a2-b0b2-1b1de0f316c9	\N	2020-04-16 13:31:37	2022-12-01 10:22:57	\N	2020-04-16 13:31:37
b19b8ec8-215a-41b8-a638-732ae6215255	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	5899f113-d963-4965-9245-1f6222f5bbc1	b19b8ec8-215a-41b8-a638-732ae6215255	\N	2020-04-16 13:31:36	2022-12-01 10:22:58	\N	2020-04-16 13:31:36
c56d8c12-703b-412c-b514-5a417e84f930	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	b5b764d4-4c3f-11e5-9257-b3688b89f32b	c56d8c12-703b-412c-b514-5a417e84f930	\N	2020-04-16 13:31:37	2022-12-01 10:22:58	\N	2020-04-16 13:31:37
8b0da9a7-97c9-4c75-ab1b-51037a91f6d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	93853854-479a-11e5-8f29-97b6ab3d09e1	8b0da9a7-97c9-4c75-ab1b-51037a91f6d1	\N	2020-04-16 13:31:37	2022-12-01 10:22:58	\N	2020-04-16 13:31:37
aaf48671-1381-4a38-8f3b-32835baba69a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	8e47faed-6b87-4baf-8d94-d778345455f3	aaf48671-1381-4a38-8f3b-32835baba69a	\N	2020-04-16 13:31:36	2022-12-01 10:23:04	\N	2020-04-16 13:31:36
a903bd1d-880a-4176-84a6-e6f1c8e59788	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	22278151-6aec-4b87-bfab-3bf8d1810468	a903bd1d-880a-4176-84a6-e6f1c8e59788	\N	2020-04-16 13:31:36	2022-12-01 10:23:05	\N	2020-04-16 13:31:36
84accb05-0deb-4358-b39a-918d043fa49e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	04a45a78-7f1b-4cad-a70f-732efa5f7985	84accb05-0deb-4358-b39a-918d043fa49e	\N	2020-04-16 13:31:37	2022-12-01 10:23:06	\N	2020-04-16 13:31:37
f43f4f2c-cd09-4828-8000-29c70986fe75	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	c7a20e10-51e9-11e5-9503-af6d1e3f4589	f43f4f2c-cd09-4828-8000-29c70986fe75	\N	2020-04-16 13:31:36	2022-12-01 10:23:06	\N	2020-04-16 13:31:36
b7497144-d906-4ccf-9c85-eaef8e7d8566	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	cf3761de-7aae-48d8-aec8-088c3e87e8ed	b7497144-d906-4ccf-9c85-eaef8e7d8566	\N	2020-04-16 13:31:36	2022-12-01 10:23:06	\N	2020-04-16 13:31:36
2e14215d-3df8-412e-9b85-f9c35c3424b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	1438adc2-38fc-11e4-b641-3f0b3de385b4	2e14215d-3df8-412e-9b85-f9c35c3424b7	\N	2020-04-16 13:31:36	2022-12-01 10:23:10	\N	2020-04-16 13:31:36
d4ec92d2-5e4b-46de-ba69-312475ed972e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	ac0343f2-09a5-4b95-b38f-cd379433d96c	d4ec92d2-5e4b-46de-ba69-312475ed972e	\N	2020-04-16 13:31:37	2022-12-01 10:23:10	\N	2020-04-16 13:31:37
bfad17a0-a8ea-4504-bf2c-4e21b5134766	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	0c57cc9c-4c32-11e5-858c-afbc5904667e	bfad17a0-a8ea-4504-bf2c-4e21b5134766	\N	2020-04-16 13:31:37	2022-12-01 10:23:11	\N	2020-04-16 13:31:37
697e3f49-5b80-438f-b23c-e8c21a35aa10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	a1168685-f62f-4f3f-87e4-aa5f19f7a6d0	697e3f49-5b80-438f-b23c-e8c21a35aa10	\N	2020-04-16 13:31:36	2022-12-01 10:23:14	\N	2020-04-16 13:31:36
75c9719b-4c85-404d-bfd4-20de7a0ae231	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	900ffa20-46cc-11e5-8abe-0337176d8d23	75c9719b-4c85-404d-bfd4-20de7a0ae231	\N	2020-04-16 13:31:36	2022-12-01 10:23:15	\N	2020-04-16 13:31:36
5f18b65d-c8a5-4400-ac16-a8bc56df9ea8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	5f18b65d-c8a5-4400-ac16-a8bc56df9ea8	\N	2020-04-16 13:31:37	2022-12-01 10:23:16	\N	2020-04-16 13:31:37
54bfb3c1-b8d5-407c-85bf-c22b3cb721bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	37dd7c39-5a77-4fb3-8bf4-31fe5f545da1	54bfb3c1-b8d5-407c-85bf-c22b3cb721bd	\N	2020-04-16 13:31:36	2022-12-01 10:23:17	\N	2020-04-16 13:31:36
1fb8675b-a49a-407e-ae78-ee99d0859407	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	2e534eee-4290-11e5-9525-d72625153a3d	1fb8675b-a49a-407e-ae78-ee99d0859407	\N	2020-04-16 13:31:37	2022-12-01 10:23:17	\N	2020-04-16 13:31:37
aa2d9927-7ede-41c6-8b4a-cecaba33db61	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	e2312114-93a0-4f51-a478-a7330f29cffe	e0e38c52-da5a-44a8-ac92-411718cd6332	aa2d9927-7ede-41c6-8b4a-cecaba33db61	\N	2020-04-16 13:31:36	2022-12-01 10:23:19	\N	2020-04-16 13:31:36
15ede297-a1d1-4736-b28b-bc0f7155f5be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	d6276643-bada-4ca6-a7d6-27f02efbd2c2	15ede297-a1d1-4736-b28b-bc0f7155f5be	\N	2020-04-16 13:31:36	2022-12-01 10:23:22	\N	2020-04-16 13:31:36
ca90a172-1d25-4737-965f-0e6bea697fb2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	472d73e3-2d2f-488f-8e2f-cd3d22418632	ca90a172-1d25-4737-965f-0e6bea697fb2	\N	2020-04-16 13:31:36	2022-12-01 10:23:24	\N	2020-04-16 13:31:36
36cfcd29-e00d-47b7-9a89-05d05b2044ce	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	8c54af21-d3fa-4eba-b89f-b628ab9fa013	36cfcd29-e00d-47b7-9a89-05d05b2044ce	\N	2020-04-16 13:31:36	2022-12-01 10:23:26	\N	2020-04-16 13:31:36
662b0056-697e-45b7-b7c6-e43c6fc360b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	02e6573c-b367-439c-80a9-521704d18dbe	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	662b0056-697e-45b7-b7c6-e43c6fc360b4	\N	2020-04-16 13:31:37	2022-12-01 10:23:29	\N	2020-04-16 13:31:37
42305f8f-bd78-4e12-b30f-f2a1814b5f47	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	732a24a6-3f9f-11e4-bb15-07986adef913	42305f8f-bd78-4e12-b30f-f2a1814b5f47	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c7b29d19-7572-4afe-b244-f7301c530828	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	da63a277-eba3-41a2-b3df-0aeb3a146e7c	c7b29d19-7572-4afe-b244-f7301c530828	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
e09f06d1-7780-4da6-8171-86171dcf08c2	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	86edb5a8-3085-11e4-b9cc-0b28c4e7f74e	e09f06d1-7780-4da6-8171-86171dcf08c2	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
4f4f4522-8018-46c2-b008-c89992bdaa05	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	594e87cc-2c10-11e4-b1ce-0b64f63cc0ce	4f4f4522-8018-46c2-b008-c89992bdaa05	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
2c33d514-07d1-4321-b842-f2a153915eae	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	56f13ef3-8065-4241-9aaa-7bc90b1eb3f0	9e03eb6a-bdac-4a3f-bc0e-0b95594bcf0e	2c33d514-07d1-4321-b842-f2a153915eae	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
fe5e65ec-8adc-483a-8fbd-48894e6664e8	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	a936bd80-4ae3-11e4-8969-0bbec047f612	fe5e65ec-8adc-483a-8fbd-48894e6664e8	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
15a9caa9-01d2-472e-9b45-e2ed25432f1d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	688ded76-740a-e211-8d98-0dc1747958fc	15a9caa9-01d2-472e-9b45-e2ed25432f1d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
face6d3d-fe0f-4114-ab08-dfa989bdfb3f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	79b7fc73-4f02-e211-b732-0dca1f0bdcd0	face6d3d-fe0f-4114-ab08-dfa989bdfb3f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
aea690de-6cd0-4c8f-a9a0-8ebc097920b3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	b85434a0-1a01-481e-a418-0dd37001153d	aea690de-6cd0-4c8f-a9a0-8ebc097920b3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
af5b8953-fbfb-4c4b-9207-69fe4f300dcb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	56f13ef3-8065-4241-9aaa-7bc90b1eb3f0	a4ba0614-4601-e211-9fde-0dd4a562f157	af5b8953-fbfb-4c4b-9207-69fe4f300dcb	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d1436e79-9148-481c-b688-2d3ee54fc476	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	b1bf60a2-76f3-498a-aeb5-2531ae5318ca	d40d977b-b300-458c-8082-1c697bf1d25a	2f43e176-5efa-4880-95d9-842aa3e25d25	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
d5973f99-cab9-4d03-9d66-959bac7b7ca5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	b1bf60a2-76f3-498a-aeb5-2531ae5318ca	7685a6a6-e768-4be8-b3b3-67c5a7da2eda	4cea7ffe-cce0-408e-a7fc-68c32120c0e6	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
da07c4e3-683d-48d4-a939-cdd5eea1857e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	142fe450-711d-4fa8-afb3-143656668377	df125859-45c2-47cd-ad78-31b05f86f072	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
dededd31-c59d-4b37-b508-99e4c1840d13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	8f802f20-bc53-4767-8c6b-71f0a4766d40	7873cb1b-c27b-4668-8120-3a9d713c48e5	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
b561b9a9-20c2-4e23-b41b-2d01c723a3e1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	80ef3ff3-ba36-4d50-a94d-14f73e210115	e46db600-f08e-41c8-b456-c04739dbeb3e	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
f9f4ed34-5d9d-4a83-9648-d4d9e9979595	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	ba4c4be1-11c9-4977-b20e-2b612e3b9122	25037fa4-4e11-4354-926c-9d9274052882	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
01bc74c7-e707-4318-b07b-bc5a40a5d42c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	82a96812-204b-40c7-ba1b-9df405e70465	95875a60-80ac-4d7d-a53f-555450394ef0	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
b5a2cbf0-caeb-461d-8b0f-87d4b4117ce0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	809cc787-3fd3-432e-a2ff-60869b73270a	70124f9c-3718-44a3-ad65-d9b825e43e69	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
e0bf78a6-eb16-4f20-97de-c2e9f5b153e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	d44edb29-4d93-4db9-bdb7-849461531973	5f594523-6a8e-4b1d-a6bf-6cb43b03be76	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
5ef88549-77e3-47b0-b48e-5f862d7ab2c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	904839e9-4121-49ea-9a54-036853ea01a4	688dcfa3-682b-4995-aa17-5edd0435c3e5	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
397c7e96-df4b-46c4-b869-460a0164b85e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	d98d7796-81c1-414e-a059-1887f7d8dc71	457e86d2-bc60-4110-9e0c-e923e5d49534	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
b2d26240-5f12-4f39-b0cf-ed84aa3b049a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	c2f4c658-848c-4201-8721-aa3046f4c9a3	5a5cebd8-6a4a-45ed-8bca-500984e7b984	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
40ed8326-7071-49a6-8df3-f8e2be8d6794	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	0b3ae94b-a64c-4439-8b0e-f97136c67316	7dada911-5029-4eda-aeb4-2e89b789bfbf	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
1c20fc90-9d30-4857-addc-35c866035568	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	2ce2d78d-c08f-4bc0-ad14-5839f5e3e971	b2b183e7-6f70-4519-b1a2-5f9520a83b77	\N	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38	2020-04-16 13:31:38
0531e669-a6cd-421f-b48e-7fc30908803c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	4c42f155-3a8b-4690-b9c4-f92f8d413990	0531e669-a6cd-421f-b48e-7fc30908803c	\N	2020-04-16 13:31:36	2022-12-01 10:22:50	\N	2020-04-16 13:31:36
4fc1dbf5-78a0-4abc-9665-2ffbadbebe92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	501e0d46-a3a8-4538-9bd0-33892dbc8140	4fc1dbf5-78a0-4abc-9665-2ffbadbebe92	\N	2020-04-16 13:31:37	2022-12-01 10:22:50	\N	2020-04-16 13:31:37
b6893df5-9193-440d-80d0-6dc8f2edc627	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	a70f3372-1493-4ad4-b53d-149a2233e31f	efadf950-9060-45d1-a065-ddd9c87cd53f	b6893df5-9193-440d-80d0-6dc8f2edc627	\N	2020-04-16 13:31:37	2022-12-01 10:22:52	\N	2020-04-16 13:31:37
d7de3739-792b-4c9d-8b52-d2777c239899	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	b24bc64a-3d42-11e3-aab6-0f6d7aed451a	d7de3739-792b-4c9d-8b52-d2777c239899	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7f1f6327-ec7a-46e7-b925-7f2cc2c0f654	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	f3527826-50d5-4223-aca8-0f8a6d48cf01	7f1f6327-ec7a-46e7-b925-7f2cc2c0f654	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
e3dca58d-91c1-4f7e-a24f-b26426ca8375	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	9cbce426-37f1-11e4-ba4c-0ff0d3bb48f0	e3dca58d-91c1-4f7e-a24f-b26426ca8375	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
90351f5f-2636-4909-ba60-26f817eacfb5	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	fb890c4c-575e-11e3-9ed3-131c13df82f7	90351f5f-2636-4909-ba60-26f817eacfb5	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
cd83e5a0-d016-47e5-81a8-711ec7a600ef	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	97ecedfe-337a-11e4-883a-13b1b8153a78	cd83e5a0-d016-47e5-81a8-711ec7a600ef	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
779a7719-7ad0-405b-ba18-7a7a43ff5af1	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	c53a4356-6bdc-11e5-9ed3-13b66bc67485	779a7719-7ad0-405b-ba18-7a7a43ff5af1	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5a1b97e9-cd82-46a5-9838-c6d90a6cec57	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	f958d1c2-3fe0-11e3-a0c1-13f0df14e8fb	5a1b97e9-cd82-46a5-9838-c6d90a6cec57	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
8aaf341c-90d1-49a7-91a0-0386e46779b9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	9f4ec502-4a75-11e3-9cb9-1711bc1354be	8aaf341c-90d1-49a7-91a0-0386e46779b9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c3ddd5cb-8076-4f72-ba3c-434a77bf7729	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	c946c1da-33da-11e4-b897-17233cfa8317	c3ddd5cb-8076-4f72-ba3c-434a77bf7729	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
451e577a-84a4-4ec2-9c4e-fece27f8bb94	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	f161f0c2-2b2e-11e4-957d-176f6108ac79	451e577a-84a4-4ec2-9c4e-fece27f8bb94	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
36057243-8ef7-45ea-a004-0b274a2eb439	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	f950d3fe-0e09-e211-8669-195837bc0bc7	36057243-8ef7-45ea-a004-0b274a2eb439	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5fffda24-efef-49a9-bfca-9105f8ca276b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	ca4cd5fe-0e09-e211-8692-195837bc0bc7	5fffda24-efef-49a9-bfca-9105f8ca276b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7fdf860d-4a30-4ef6-b14e-e1e152a2cceb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	7b9137f0-d85a-4252-b14a-1a53150d4d5f	7fdf860d-4a30-4ef6-b14e-e1e152a2cceb	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
852ac7d7-adaa-412b-bd60-c957c7e105d2	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	56f13ef3-8065-4241-9aaa-7bc90b1eb3f0	8a70bfb3-950e-e211-b3f3-1b8f7162af5c	852ac7d7-adaa-412b-bd60-c957c7e105d2	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c9e96ba1-e179-4daf-9b4b-7555329321ec	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	b1d6eb53-a926-482e-bd65-1bb64892447f	c9e96ba1-e179-4daf-9b4b-7555329321ec	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
a93c9f1d-4188-4734-8c18-28ec62fa270d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	b1bf60a2-76f3-498a-aeb5-2531ae5318ca	6284ec39-06a6-421b-a64f-c49e54f2002f	87017ad8-94f8-4c98-b9c1-c6f4ce6e132b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
d48aed06-0f79-422b-ac2b-c3b5fbddf8f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	d418de8e-2423-4ff1-887a-7963fdcc6002	da0812de-8221-47ed-b8c1-3fb4da5f505e	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
34f8a705-8ff7-469c-9b5b-676d46a1c587	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	582a30ab-0877-44a8-a0c5-314a2c72cf02	34ce4d13-e2aa-4a40-bf65-5a86b8e68931	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
80ceb787-207d-4375-95fb-759f9b07e233	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	caa2c416-55c7-47bf-aaac-e8ed45734f23	34a65e5b-9072-4f36-b71a-9281d938abeb	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
5b5fec89-de82-4500-93e6-1678bdd1887b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	4481b1cd-ec5c-4f49-84bf-0186d79d9036	31e68e46-6b58-4b6f-b22d-c46a59c0fa19	4c7fa673-f5a7-412b-b3a5-619032619988	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
72dca868-25cd-480f-b764-3f2d289a1ac3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	1ca43a09-807b-41b4-be2a-c46027be07fc	0a7238c1-4ef7-4d45-b36b-5004755ca88b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
786c7fad-9054-4105-8055-8fb625aff4e8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	5c15beb1-461c-45d3-860e-1b0e0818228d	61ff533d-a792-4ce6-abb4-89b1f5cac352	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
72cbc788-4117-445b-8fd0-62366ec8c070	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	c1b9c50b-2f0c-4cd5-a664-0bfa77156728	50446db0-0c24-420b-8253-16dcd7d84c8b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
3a66dc99-a9e7-4744-8832-53635c38b074	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	9bedb953-afb5-4f86-bcdb-2a2d2b5de767	11562f07-b520-46b3-8546-ccc9e9821318	fdeaa7d7-c19a-4c0f-9716-d0f4f638264a	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
13722ce7-f5d2-49bf-b1b2-55c70861294a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	94e3a835-6bcd-4974-8ed6-280f6f6ab49c	bf91eda7-9a91-4a66-98de-cff2aa191351	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
0e1a0a11-9860-42c6-b249-33a8420b3504	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	378db71b-697c-4e86-9c03-af534deae0b5	46fbe4de-9a8a-44d5-9af7-1b3eb2bcd1e9	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
5cf41f0c-6627-444b-a275-6c31f357bbbd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	370cd1cb-3ca6-45f3-a6f9-41054b7b00ce	5d18243e-834b-42e0-a832-9259842313a7	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
00ca5971-a338-4a0a-8c12-09a796e6a79e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	abd3dc01-b4a5-482a-83cd-e59414b755e3	9467a1d1-3eec-4b04-80df-3fd2860a7234	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
c0d4b6f3-8027-4468-a680-b755a16ab2ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	16af35c3-d85d-4eff-8dd1-42a1512b5f98	354d3eb1-85cc-4455-b614-d6478c5728c6	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
946733b2-17fd-432f-846a-8e0d0c81a6db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	b7817d76-5e53-4e4c-9210-6bbd77b73030	8993eeeb-f375-471b-b1f8-b1214a1ff6d0	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
67ec852d-8451-499e-acb6-009bc659837a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	5ccc30ba-c3f3-43b8-9027-03c3d296f87e	b5fed074-743d-4a04-87b6-a36c26d0919c	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
e5d38211-7151-478c-85d2-50a368f63c2d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	586fdef5-1a9e-4e6b-82df-3da32f424629	8397cb65-b5eb-496a-99d9-824d000a4675	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
8f2a1957-cd47-484f-9f57-813b43b7b9ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	f953b955-181c-45a2-9b12-025939a5b928	b85d2006-eb05-4b10-8c33-4173e7d515ba	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
57511d89-d0e0-4632-97cb-8462304c418e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	10f92f00-ce52-467a-a9e0-df2775338f42	a4c363f2-c57a-4488-9f76-8ffeb4ce3a14	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
37745102-9666-467c-a9ac-6f5c2f8ea24b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	7cd24fd3-6a9f-4562-9f20-9b06947a78b8	a98590c4-e19b-4c53-847e-45d314d3245f	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
2222074d-78fb-4e37-ac00-8bf089725138	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	c2ccd165-0d65-4ce3-b466-a4ea2ce232d8	3bb75064-1a0c-404c-b249-a10d449d34ab	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
1a119736-18de-4f01-8782-7500c129c370	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	aee2fc25-b8e4-4e4f-a537-843963698b12	4bbfea3e-1ca4-4ce0-8942-7b12bb650fcc	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
64fe6a0b-7c29-4300-8d4f-b6a3ad0c5fdc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	74c969af-9fef-49b5-9997-6696527d90f2	a72c4804-c114-4480-b128-9ec07d2c979f	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
1617c13c-7477-4af1-bd70-474ab8094ec7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	39c52dbc-95c3-437b-b206-4bf5105b8709	5e249310-c802-41f2-9517-fd039d86e247	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
d782eb98-f2cf-4137-ab6f-844b508e4fd9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	1dd1ea4d-92b0-45e7-9e5f-cddde692188a	985f3f82-cdfe-41e7-b832-e73986128c97	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
b67fcd5b-24b9-4321-b4fd-9572d0b1125f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	398b5b98-7e35-4bdc-a189-427509c412da	5da0511c-3db9-4a4d-a811-f850adeee045	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
a7737f02-2215-4073-a229-d40d872fd7ad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	d8b7a945-d326-46ae-8dd3-d11b9e3d2e59	c00762e8-f07d-421a-b60f-74dc2e45daed	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
fcd42227-657a-44b4-b4db-18da9801abf1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	213baa67-ce71-4226-ae52-1cc2081e5d27	1bd3dc54-2ee4-4b13-957d-e41ae833746b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
9254efb0-0f38-418f-bda0-3050711d204d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	419877e1-8215-49f2-83d8-ab7e88cbdd27	d1ef1c2b-d3cf-48d8-adbe-ae6031015870	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
9c1de8cd-4474-47a5-a400-7a111f2cfc4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	264c669f-2019-45e1-8c44-b47084f0d1ba	6880c6a4-edf4-41d3-9d3b-dba2a5e7133b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
5050d15e-8a34-41d7-9ca8-fbbe373d9e33	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	4155bb97-32cf-42ee-9de4-9e51caadd76c	43969f79-d50c-4866-8f9e-e12e1dc8ec03	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
530e16a3-91d2-4d06-bfae-53da07e5d307	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	bd469689-6f9a-4b29-8e73-d74630e3984b	bea7dc3f-336d-4f8d-a273-a159ae720fc7	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
9e9f71d4-2de7-45e0-b19a-e7a42b285043	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	1ad5d1b9-7243-4d6d-b1b8-7d52534ad3d9	d48413b3-54da-40ed-8179-1d535139079e	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
75464311-c988-4a40-8306-9ea9d315c7e7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	8ab6bd00-6969-4219-a22c-185039306f49	6e86e91a-2f7a-4e08-943a-c8646611a840	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
4f3f3269-e3ee-4425-8f02-f53d75d031cb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	3e4a24a8-e3ee-4490-bf7d-95b78da12418	93d5640d-44e8-4426-8bc0-a98fa5297983	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
0b58b94b-697d-4b69-a98a-c2559166212f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	b763c7ff-1a60-46f2-9e0b-df3e8b3ff8b7	411340f8-f4d7-431e-8703-7ee16f43e39a	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
a1c276e2-970f-4189-85c9-df2cba5cb983	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	c718b28e-fce5-45ab-aaf6-7dd7f603fb2a	ddb82ed1-1893-4043-9c3e-ac077ebd579b	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
6c7a6f3a-c3df-4673-9a4e-f7d3f1736a05	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	6c7a6f3a-c3df-4673-9a4e-f7d3f1736a05	\N	2020-03-14 16:46:28	2022-12-01 10:22:52	\N	2020-04-28 06:37:42
1e6b7f7a-f889-4100-a294-f7970bd61acb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	ff7c4f81-88e6-4b4b-8b91-f7cad43bcb5f	da2e3e30-22ee-11e4-90f6-53330a5cd670	1e6b7f7a-f889-4100-a294-f7970bd61acb	\N	2020-02-17 14:00:49	2022-12-01 10:22:53	\N	2020-06-17 19:43:09
77e0641a-9fa5-4def-a16c-7de4380d7210	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	3e20af19-c84c-4fb4-9326-a47a5a8087c1	77e0641a-9fa5-4def-a16c-7de4380d7210	\N	2020-04-22 11:59:03	2022-12-01 10:22:54	\N	2020-06-17 19:43:09
95bb6b05-1b04-4617-8f5d-f0870559aa90	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	95bb6b05-1b04-4617-8f5d-f0870559aa90	\N	2020-02-17 14:00:51	2022-12-01 10:22:56	\N	2020-06-17 19:43:10
1307d4ca-dd32-41e4-bf20-040a39d51f30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	767f4d7f-2677-4630-81ab-cf02d4646520	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	1307d4ca-dd32-41e4-bf20-040a39d51f30	\N	2020-02-17 14:00:50	2022-12-01 10:22:59	\N	2020-06-17 19:43:10
1a4f690d-f600-4020-8383-5bb60d88d108	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	c795df6e-a22f-478f-9005-76d13d30bab4	1a4f690d-f600-4020-8383-5bb60d88d108	\N	2020-04-22 11:59:05	2022-12-01 10:23:04	\N	2020-06-17 19:43:10
9e993fe3-161f-496c-982a-00aaf8ee5bbd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7363a404-46e9-11e5-8413-7fabf05ee1fd	9e993fe3-161f-496c-982a-00aaf8ee5bbd	\N	2020-03-14 16:46:24	2022-12-01 10:23:06	\N	2020-04-28 06:37:41
ee87f4a9-b606-468a-929b-59dd1c6ab372	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	22160fc9-321a-40b5-849f-f8db354b9185	ee87f4a9-b606-468a-929b-59dd1c6ab372	\N	2020-02-17 14:00:49	2022-12-01 10:23:07	\N	2020-06-17 19:43:09
bac1ac53-bf22-41c6-94de-f13910d038c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	b255e348-4b76-11e5-8241-13af4f7fae26	bac1ac53-bf22-41c6-94de-f13910d038c2	\N	2020-02-17 14:00:49	2022-12-01 10:23:07	\N	2020-06-17 19:43:09
1bf8b894-9da0-4256-a42e-74b052025ace	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	542df659-4377-411d-9fa8-1f5ce8878479	1bf8b894-9da0-4256-a42e-74b052025ace	\N	2020-02-17 14:00:48	2022-12-01 10:23:10	\N	2020-06-17 19:43:08
f52434d8-4ed0-4a84-a724-4a87649ca29d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	30de1458-7e5e-489a-9ec0-b459cc822a56	dff2a0f4-5123-11e5-8831-73515c7ac634	f52434d8-4ed0-4a84-a724-4a87649ca29d	\N	2020-02-17 14:00:49	2022-12-01 10:23:13	\N	2020-06-17 19:43:09
7490ae36-f2a5-497f-9b0b-f48fc03724f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	b255e348-4b76-11e5-8241-13af4f7fae26	7490ae36-f2a5-497f-9b0b-f48fc03724f8	\N	2020-03-14 16:46:28	2022-12-01 10:23:17	\N	2020-04-28 06:37:43
946c39a0-ba91-4155-9353-1b46bb5aec57	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	946c39a0-ba91-4155-9353-1b46bb5aec57	\N	2020-03-14 16:46:24	2022-12-01 10:23:19	\N	2020-04-28 06:37:41
6b6f0faf-9b91-42ea-a613-d0b097696ed1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	daed26de-c29b-4a62-9929-936d9ee105a7	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	6b6f0faf-9b91-42ea-a613-d0b097696ed1	\N	2020-02-17 14:00:48	2022-12-01 10:23:19	\N	2020-06-17 19:43:08
4a5896a3-60c6-4edb-afdc-5d70732d81fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	fd2e81be-ca4c-4320-9549-82c37f311556	4a5896a3-60c6-4edb-afdc-5d70732d81fe	\N	2020-04-22 11:59:03	2022-12-01 10:23:22	\N	2020-06-17 19:43:09
51702b5f-fb26-4aa0-af37-3251bdc9a978	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	67390022-7626-4bf5-a07f-1f5dd137f72e	51702b5f-fb26-4aa0-af37-3251bdc9a978	\N	2020-04-22 11:59:02	2022-12-01 10:23:26	\N	2020-06-17 19:43:08
2e24181f-7234-4eb7-8b88-d748db2b3748	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	daa07555-dd3d-44da-856b-28f08ecd474e	2e24181f-7234-4eb7-8b88-d748db2b3748	\N	2020-03-14 16:46:27	2022-12-01 10:23:26	\N	2020-04-28 06:37:43
6a9086a3-a24a-42de-a86a-93b4e7fb67f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	72d18334-3b06-11e4-a3a4-13507c2a0677	6a9086a3-a24a-42de-a86a-93b4e7fb67f3	\N	2020-04-22 11:59:04	2022-12-01 10:23:26	\N	2020-06-17 19:43:09
6ce4db54-5b1e-4474-99b1-1ed881e8568a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	6ce4db54-5b1e-4474-99b1-1ed881e8568a	\N	2020-03-14 16:46:25	2022-12-01 10:23:28	\N	2020-04-28 06:37:42
125e8803-6700-4917-bc59-56ec9c953134	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	d85e860f-35a9-4406-8bc6-0e4051153600	125e8803-6700-4917-bc59-56ec9c953134	\N	2020-03-14 16:46:26	2022-12-01 10:23:29	\N	2020-04-28 06:37:42
d265d606-05e4-4f03-90c6-88bcdde2f04f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	d265d606-05e4-4f03-90c6-88bcdde2f04f	\N	2020-03-14 16:46:25	2022-12-01 10:23:30	\N	2020-04-28 06:37:41
c3d43ef7-06c5-4c16-802f-d24334ae091d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	ec0b8a22-4b62-11e3-b59b-1bd3aab0d8af	c3d43ef7-06c5-4c16-802f-d24334ae091d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
aae9a811-ad2f-4e72-bfbc-16cbfa2947dd	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	774a828b-5ec3-4208-a62a-1c046cb36234	aae9a811-ad2f-4e72-bfbc-16cbfa2947dd	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
0d335775-46dd-423e-b725-85ef06a9ebd1	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	171f49a0-2b29-11e4-ab51-1f279480e7d7	0d335775-46dd-423e-b725-85ef06a9ebd1	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
88ca7494-643b-487e-afc5-1f27e6b2d8bd	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	1b01923e-9539-11e3-809a-1f4e0b70b89d	88ca7494-643b-487e-afc5-1f27e6b2d8bd	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
39e994a2-a518-42c7-8d0a-72a89c77bb9d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	9f352e1a-5793-e211-b65c-1f516a54adbc	39e994a2-a518-42c7-8d0a-72a89c77bb9d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5c95cebb-2098-4701-85c1-42245dae4e60	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	ed6c8746-3950-11e3-9ffc-23bc71409bdf	5c95cebb-2098-4701-85c1-42245dae4e60	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7c97c46b-36fc-4e6f-938b-78d23626adc0	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	043e7f72-2a75-11e4-a2e4-23de51ce9dc3	7c97c46b-36fc-4e6f-938b-78d23626adc0	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
368d16e6-4e7b-4f01-8ae0-0a40882d9438	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	7142a372-867b-4bed-a21c-2535fbd43b05	368d16e6-4e7b-4f01-8ae0-0a40882d9438	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
b8d18b37-acbd-439b-bbcd-37e5874f1828	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	6bf2be5e-bc1e-4684-a7a9-25f2206a5a80	b8d18b37-acbd-439b-bbcd-37e5874f1828	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
bfbddff7-2f7e-4585-ba94-f75168190a86	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	b1bf60a2-76f3-498a-aeb5-2531ae5318ca	ab1f24f9-01d4-4b64-9392-ec48fe4304c0	ba06802b-c230-4f08-b545-1594c7925438	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
075ba70d-f1cc-4974-9d8f-278f24c0b426	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	65b64ede-3e20-492f-982c-cdf3d487d496	05676f50-bcc4-435b-941a-c9d87aadbf9f	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
4f9333c6-8902-4ace-b3d9-8438da73ff22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	96fa948b-4390-4e3b-a55a-3aaaa33f7381	79c18f7f-21e1-483c-9714-754e1f05f2e5	2792a9c2-348f-4b99-b7e6-8a65ae24f021	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
17b10119-79f2-4061-ac3f-de7aa5ce30ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	6bd257e4-ab69-4649-bbfb-e7c83eb083e3	01826ec4-ef19-4926-ac5c-ede37641771c	4ea2cd89-72d5-4457-a994-4f7677ca1f92	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
b6e16783-b820-42ec-b1dd-b92278368d30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	76857cbe-25f6-402c-ba0a-126a48dfe922	e7849308-f2f5-49bd-9be9-4480496ee2fb	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
e40c03be-1ab0-497d-aaef-88ef8917c8a4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	5384298f-0016-462d-9521-2cf9fe7c79be	09c402f0-6a46-4c36-9e9c-c43cf645759c	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
475a394a-5e1d-4e59-a367-e8f645482b74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	64b3f5ca-1cd6-4648-a396-14b920f1313f	f0981b27-c959-4d54-841d-f6466c0156eb	475e1c2c-cb5a-45d4-957b-24daa750601a	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
eede4d07-41c4-483f-981e-f2316695df4a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	c5d773af-5b27-4edb-b6f1-52d0bb8718c9	38e153ac-a714-4bae-829f-ab03c1bbbea6	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
bea421aa-0690-495e-8a0d-ed0a37219bec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	d411fd4b-85a4-4fb6-8d5e-318affb8a950	23de8176-8923-4958-9b64-441571fcb2bd	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
e383f343-5c69-4de9-a1a3-3029b0032ba4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	04448320-d527-401d-a6d5-ade63b6f37a3	cc0356bc-ba6d-4023-a14d-26062d584f11	8671bd0d-0f57-42d1-830a-846f36ac6af5	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
30b37075-2bae-4e4e-9fa2-987affaeb888	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	fcbc357e-e236-44fd-91d3-e6396ef77880	669c65b4-6063-4452-a857-9f2b5e0c0e0e	\N	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39	2020-04-16 13:31:39
0edd65ab-dcd0-4a4d-881d-15f535455484	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	0209bbd7-f72f-4c6a-b9b4-3ad1bededa01	6ebdbeb3-2808-44bb-99b2-15b9fbda5217	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
9e00269f-fceb-4463-8fa9-a1eb4fc8417a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	7cbcc334-1dd3-4eaf-a779-f80bb217876e	f090e912-0abe-46f4-9d41-236da65d30a9	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
99a78c9f-17fb-4e4c-be38-be104f52b22b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20182	888c96ee-756c-46ca-b826-118bc93eb995	7505ac56-204e-4e39-8840-bc272100eb8f	3b66368e-b1b1-407a-8ee1-6f6e1b94f339	\N	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40	2020-04-16 13:31:40
6e27e757-96f4-442e-8a45-e7b7bdf257bd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	1d64c4a6-b263-441e-82e2-763c790c3c05	c6beded5-0b58-4187-ae4e-78cdcbd522e2	\N	2020-04-22 11:59:06	2020-06-17 19:43:11	\N	2020-06-17 19:43:11
1e01fbc4-66c0-436e-a83d-d66361021bc2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	fd2e81be-ca4c-4320-9549-82c37f311556	4a5896a3-60c6-4edb-afdc-5d70732d81fe	\N	2020-02-17 14:00:49	2020-04-22 11:57:39	2020-04-22 11:57:39	2020-03-06 22:00:50
b26a48ac-a485-43a2-bd1b-839fd1216ab0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	3e20af19-c84c-4fb4-9326-a47a5a8087c1	77e0641a-9fa5-4def-a16c-7de4380d7210	\N	2020-02-17 14:00:49	2020-04-22 11:57:57	2020-04-22 11:57:57	2020-03-06 22:00:50
1e671faa-0bc9-47fc-9be4-158e58287e92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	c795df6e-a22f-478f-9005-76d13d30bab4	1a4f690d-f600-4020-8383-5bb60d88d108	\N	2020-02-17 14:00:50	2020-04-22 11:57:53	2020-04-22 11:57:53	2020-03-06 22:00:52
3afcd78e-edd5-4723-9a97-43075e563663	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	7da509e8-6463-4563-a097-b784aaf90a6f	67390022-7626-4bf5-a07f-1f5dd137f72e	51702b5f-fb26-4aa0-af37-3251bdc9a978	\N	2020-02-17 14:00:48	2020-04-22 11:57:43	2020-04-22 11:57:43	2020-03-06 22:00:49
ed9ff05c-8d43-429d-84db-75a480a82fd8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	7b6763fc-6f9f-11e3-b017-03efaa0c94af	ed9ff05c-8d43-429d-84db-75a480a82fd8	\N	2020-03-14 16:46:25	2022-12-01 10:22:49	\N	2020-04-28 06:37:42
40514d39-e021-463e-9ffc-3b4d78988516	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	33fb5d60-ec52-4c27-89a5-bd878d00e994	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	40514d39-e021-463e-9ffc-3b4d78988516	\N	2020-02-17 14:00:50	2022-12-01 10:22:50	\N	2020-06-17 19:43:09
91c581d0-c8f7-4f47-a209-73486e8700be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	0ea06995-f218-4530-9b63-0b499a11b034	91c581d0-c8f7-4f47-a209-73486e8700be	\N	2020-02-17 14:00:49	2022-12-01 10:22:51	\N	2020-06-17 19:43:09
a6492675-f8d9-4d2c-92e8-590f7a3fca63	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	2c1847a5-ae44-40e2-836e-cc566e0ed984	a6492675-f8d9-4d2c-92e8-590f7a3fca63	\N	2020-03-14 16:46:32	2022-12-01 10:22:53	\N	2020-04-28 06:37:44
8895849b-de0c-4b31-b850-38ee53155dca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	8cf66883-ebc1-473e-a01c-37925b2b2150	8895849b-de0c-4b31-b850-38ee53155dca	\N	2020-03-14 16:46:31	2022-12-01 10:22:53	\N	2020-04-28 06:37:43
8e8a63e3-d96f-48a2-b6b8-533d164208c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	304a3c38-bda8-4b1f-b2ef-087817e35993	8e8a63e3-d96f-48a2-b6b8-533d164208c3	\N	2020-12-07 09:32:44	2022-12-01 10:22:56	\N	2020-12-16 07:52:59
97df4bb0-4fe1-4dd5-ac7d-067855eae24c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	a0ad0205-bc97-43f6-bbe7-5a9771a2fbbb	97df4bb0-4fe1-4dd5-ac7d-067855eae24c	\N	2020-12-07 09:32:44	2022-12-01 10:22:57	\N	2020-12-16 07:52:59
af22a6cd-9a35-4f41-a919-bd6dd5230d85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	ebf7f6a9-dd0c-4993-8dd7-dbd7ca546c07	af22a6cd-9a35-4f41-a919-bd6dd5230d85	\N	2020-12-07 09:32:44	2022-12-01 10:22:57	\N	2020-12-16 07:52:59
43418149-251f-4618-91d7-2339eb634579	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	5ee6d9c4-d499-4a4b-99ca-f97d181d7000	5ae837e8-4a02-11e5-9a00-2bca72a8469e	43418149-251f-4618-91d7-2339eb634579	\N	2020-03-14 16:46:31	2022-12-01 10:22:57	\N	2020-04-28 06:37:44
ffe59209-3163-4c86-b09c-9bf7cdc1c9b1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	7df870be-f674-4ed1-bf50-340cbfdc845a	ffe59209-3163-4c86-b09c-9bf7cdc1c9b1	\N	2020-12-07 09:32:44	2022-12-01 10:22:57	\N	2020-12-16 07:52:59
ac918cc5-2590-4fd2-994a-f1b6c9b974dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	ac0343f2-09a5-4b95-b38f-cd379433d96c	ac918cc5-2590-4fd2-994a-f1b6c9b974dd	\N	2020-12-07 09:32:44	2022-12-01 10:22:58	\N	2020-12-16 07:52:59
76dacd9f-551a-4d85-ac1b-614532c8cde8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	8462527e-862e-4b54-b09b-a9c99a9f276d	76dacd9f-551a-4d85-ac1b-614532c8cde8	\N	2020-12-07 09:32:44	2022-12-01 10:22:58	\N	2020-12-16 07:52:59
0f9fcca1-7d4c-4d65-9e59-a26eb99305ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	501e0d46-a3a8-4538-9bd0-33892dbc8140	0f9fcca1-7d4c-4d65-9e59-a26eb99305ff	\N	2020-03-14 16:46:31	2022-12-01 10:22:59	\N	2020-04-28 06:37:44
1aef0921-3b6c-4509-9556-b06d3811602e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	d57f4561-8cb1-42ae-940e-7943cdae287b	1aef0921-3b6c-4509-9556-b06d3811602e	\N	2020-12-07 09:32:44	2022-12-01 10:23:01	\N	2020-12-16 07:52:59
6d84ba55-1b54-4a1f-99e9-a9172728c7ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	6d84ba55-1b54-4a1f-99e9-a9172728c7ab	\N	2020-12-07 09:32:44	2022-12-01 10:23:03	\N	2020-12-16 07:52:59
363480bc-e468-48b6-b3c2-88d872aa65d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	22160fc9-321a-40b5-849f-f8db354b9185	363480bc-e468-48b6-b3c2-88d872aa65d0	\N	2020-12-07 09:32:44	2022-12-01 10:23:04	\N	2020-12-16 07:52:59
ebcfdf94-ce30-4494-b1ea-27cafbbf1ad6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	60c2ff20-4b6c-11e5-958c-b39420b5676f	ebcfdf94-ce30-4494-b1ea-27cafbbf1ad6	\N	2020-12-07 09:32:44	2022-12-01 10:23:04	\N	2020-12-16 07:52:59
ec0581bd-ba50-4265-bd52-cc429d972b3d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	d081c069-65b7-4bf5-866a-423def103d81	ec0581bd-ba50-4265-bd52-cc429d972b3d	\N	2020-12-07 09:32:44	2022-12-01 10:23:05	\N	2020-12-16 07:52:59
35d7a45c-4e45-436b-89b5-2ed8e1f8511c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	58aae1a1-edb7-4f35-91f2-60b447ddb05f	1e02ae8a-1e69-4e9c-a8c2-084b208eb8fb	35d7a45c-4e45-436b-89b5-2ed8e1f8511c	\N	2020-06-17 19:37:33	2022-12-01 10:23:06	\N	2020-06-17 19:43:09
5efa325d-ae6c-4b37-91a7-9b10504bb9f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	3056804e-5c1e-4863-9c38-0f70f3397c1a	ec8e677e-bc78-4e1d-9ae9-9130a1babb01	5efa325d-ae6c-4b37-91a7-9b10504bb9f3	\N	2020-03-14 16:46:31	2022-12-01 10:23:09	\N	2020-04-28 06:37:45
3a7bb237-51f0-46d8-a9c2-115edf907e4c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	3a7bb237-51f0-46d8-a9c2-115edf907e4c	\N	2020-03-14 16:46:29	2022-12-01 10:23:09	\N	2020-04-28 06:37:44
8f1a5bc3-fa70-4e8c-8cb3-4fd3622e1c2b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	7dbbb577-7b93-48ef-b139-db84e9163597	8f1a5bc3-fa70-4e8c-8cb3-4fd3622e1c2b	\N	2020-12-07 09:32:44	2022-12-01 10:23:11	\N	2020-12-16 07:52:59
f6784b5f-4083-42c9-80d7-61b2e72d4783	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	2c1847a5-ae44-40e2-836e-cc566e0ed984	f6784b5f-4083-42c9-80d7-61b2e72d4783	\N	2020-12-07 09:32:44	2022-12-01 10:23:11	\N	2020-12-16 07:52:59
ec8f07bb-0902-42be-8ece-bd047a27fd52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	b32063b6-462b-11e5-9585-133f160aafbb	ec8f07bb-0902-42be-8ece-bd047a27fd52	\N	2020-12-07 09:32:44	2022-12-01 10:23:11	\N	2020-12-16 07:52:59
94dd355c-0ed0-40a9-b95e-811c71b70670	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	472d73e3-2d2f-488f-8e2f-cd3d22418632	94dd355c-0ed0-40a9-b95e-811c71b70670	\N	2020-03-14 16:46:30	2022-12-01 10:23:13	\N	2020-04-28 06:37:44
1d17975e-2331-40ab-a041-21bdd18d5c42	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	1d17975e-2331-40ab-a041-21bdd18d5c42	\N	2020-12-07 09:32:44	2022-12-01 10:23:14	\N	2020-12-16 07:52:59
f76e6bc0-7ab1-436d-adc9-bfdc1a623f74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	4f7f486c-b671-473a-9f49-b8e2a8e05c4c	b255e348-4b76-11e5-8241-13af4f7fae26	f76e6bc0-7ab1-436d-adc9-bfdc1a623f74	\N	2020-12-07 09:32:44	2022-12-01 10:23:15	\N	2020-12-16 07:52:59
7d891292-ffdc-40ae-8278-f6ab4f25f3cf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	2ba58834-4278-4d6b-9ee8-6a6f53ce40ab	900ffa20-46cc-11e5-8abe-0337176d8d23	7d891292-ffdc-40ae-8278-f6ab4f25f3cf	\N	2020-03-14 16:46:28	2022-12-01 10:23:15	\N	2020-04-28 06:37:43
8319eab1-63f4-49c7-aecc-bfef92d1870b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	6ef941cd-f503-e211-a8c9-8de20f7d3878	8319eab1-63f4-49c7-aecc-bfef92d1870b	\N	2020-12-07 09:32:44	2022-12-01 10:23:17	\N	2020-12-16 07:52:59
02e8b3cc-d588-4294-8a0f-76acd8ef9cca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	02e8b3cc-d588-4294-8a0f-76acd8ef9cca	\N	2020-12-07 09:32:44	2022-12-01 10:23:19	\N	2020-12-16 07:52:59
aab99eaa-e9b8-4148-b590-7c716d4120de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	11558ce2-46ca-11e5-8ba3-b7381d40fb27	aab99eaa-e9b8-4148-b590-7c716d4120de	\N	2020-03-14 16:46:30	2022-12-01 10:23:22	\N	2020-04-28 06:37:44
53820e93-3638-4179-987a-03f7bdd263a1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	eb492e22-77fd-e111-8da8-f1648fe48442	53820e93-3638-4179-987a-03f7bdd263a1	\N	2020-12-07 09:32:44	2022-12-01 10:23:23	\N	2020-12-16 07:52:59
8de876e0-b6f3-423b-9c8b-2b5e14041461	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	4f8e0696-ebb4-406b-a15d-10ddcaa85487	8de876e0-b6f3-423b-9c8b-2b5e14041461	\N	2020-12-07 09:32:44	2022-12-01 10:23:24	\N	2020-12-16 07:52:59
87e7203f-8c45-43a0-8ff5-41bbcf597270	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	c593fef2-46d2-11e5-b14e-8fa23f386b5a	87e7203f-8c45-43a0-8ff5-41bbcf597270	\N	2020-12-07 09:32:44	2022-12-01 10:23:25	\N	2020-12-16 07:52:59
5ccc54f9-1872-486f-a085-8bff09ea442e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	906376c2-1463-4361-897e-a7ef5a19239d	5ccc54f9-1872-486f-a085-8bff09ea442e	\N	2020-12-07 09:32:44	2022-12-01 10:23:25	\N	2020-12-16 07:52:59
ea011dc1-c519-452c-86c5-d36a4bb4bd08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20192	580b387c-4abf-41d5-8efb-b86066ad0a01	37dd7c39-5a77-4fb3-8bf4-31fe5f545da1	ea011dc1-c519-452c-86c5-d36a4bb4bd08	\N	2020-03-14 16:46:29	2022-12-01 10:23:25	\N	2020-04-28 06:37:44
65c0c15f-8622-48fd-b86d-161e5de93eec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	65c0c15f-8622-48fd-b86d-161e5de93eec	\N	2020-12-07 09:32:44	2022-12-01 10:23:27	\N	2020-12-16 07:52:59
b85ca89f-eeff-4e57-9cf6-7a5a50949b8f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	7bd0404c-9603-e211-b291-0143ed05e022	b85ca89f-eeff-4e57-9cf6-7a5a50949b8f	\N	2020-12-07 09:32:44	2022-12-01 10:23:29	\N	2020-12-16 07:52:59
f3c4443f-47f0-49bd-8331-0c4295161da9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	acd687cc-662c-4ac2-8175-2800e02d91cd	f3c4443f-47f0-49bd-8331-0c4295161da9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7b34e044-f75d-4cd5-8d93-4d28f1774ce4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	d41bdb8c-2da8-11e4-abd1-2b1e135e4269	7b34e044-f75d-4cd5-8d93-4d28f1774ce4	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
152e44e8-e37a-434f-8e02-5c8e574cd4b1	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	2334dccc-7ec0-465b-bb69-2bb6fa28f29f	152e44e8-e37a-434f-8e02-5c8e574cd4b1	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
4de61434-4156-4d87-baa6-3a4efabac82b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	b327c148-92bc-11e3-a710-2be0475c8faf	4de61434-4156-4d87-baa6-3a4efabac82b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
22d209cc-fff5-4bcf-96d5-9ae5ae61f5d3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	a94f1105-6c2d-4274-9531-2ea77471a1c8	22d209cc-fff5-4bcf-96d5-9ae5ae61f5d3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
3f2b5259-1705-44a9-a8d8-c57bbdd5340d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	4aa35460-317d-11e4-919f-2f11c8a6b386	3f2b5259-1705-44a9-a8d8-c57bbdd5340d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
1eac1cf9-b2fd-4d2d-ad75-62bee4154c31	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	0cfc5e18-3881-11e3-bf6c-2f20f0d6aeea	1eac1cf9-b2fd-4d2d-ad75-62bee4154c31	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
50174816-b3a5-4bd9-91c8-d45eaf402c09	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	5568c372-3f96-11e4-9165-2f37cb61e7eb	50174816-b3a5-4bd9-91c8-d45eaf402c09	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f4ba171d-f62a-4d11-8fa6-231497713468	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	7963cdea-3cde-11e4-8eda-2fad91ed221f	f4ba171d-f62a-4d11-8fa6-231497713468	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
a52418e0-98ed-4312-b23c-3407434691ee	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	0edd9f0c-48e5-11e3-8e77-2fde6c50fb0a	a52418e0-98ed-4312-b23c-3407434691ee	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
1dcd091d-2dba-4513-b01f-9de7412c2a6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	23388d39-245f-475d-8fb1-d47b55962e23	af585d55-465c-4e5e-b4e1-a3be55c4cd63	\N	2020-12-07 09:32:44	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:52:59
a478f1f2-2a66-4af6-ba33-ceb8141e511c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	074f93b5-b14c-43a4-9b32-ffa1f94d5238	a478f1f2-2a66-4af6-ba33-ceb8141e511c	\N	2020-12-07 09:32:44	2022-12-01 10:22:49	\N	2020-12-16 07:52:59
72c8e187-d101-46b0-8b1c-70cebb09c9d3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	52ae8172-5750-4387-badd-79b17d2081aa	72c8e187-d101-46b0-8b1c-70cebb09c9d3	\N	2020-12-07 09:32:44	2022-12-01 10:22:50	\N	2020-12-16 07:52:59
b9c65799-3447-49ed-972b-fb89dd3eb13d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	b9c65799-3447-49ed-972b-fb89dd3eb13d	\N	2020-12-07 09:32:44	2022-12-01 10:22:50	\N	2020-12-16 07:52:59
f145e265-46de-4517-9e05-745a2038a808	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	210fde58-74aa-4ea9-a4e4-ab32b37448b1	f145e265-46de-4517-9e05-745a2038a808	\N	2020-12-07 09:32:44	2022-12-01 10:22:51	\N	2020-12-16 07:52:59
5fe41b97-5412-4cae-9ee1-fce416b7194f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	f530a57f-1b10-e211-9570-4d846480b264	5fe41b97-5412-4cae-9ee1-fce416b7194f	\N	2020-12-07 09:32:44	2022-12-01 10:22:51	\N	2020-12-16 07:52:59
90081b00-8b1e-465d-ace4-777d3c704d85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	ff732935-72e5-4865-bb47-f3e0cb79d9fa	90081b00-8b1e-465d-ace4-777d3c704d85	\N	2020-12-07 09:32:44	2022-12-01 10:22:51	\N	2020-12-16 07:52:59
9368a1f8-aa60-490a-9dbb-474271d698e9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	8314bc86-f503-e211-a8c9-8de20f7d3878	9368a1f8-aa60-490a-9dbb-474271d698e9	\N	2020-12-07 09:32:45	2022-12-01 10:22:52	\N	2020-12-16 07:52:59
279c153a-87e3-4696-b084-e8b1ad160279	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	ea543c35-e3d7-484c-b472-6d5a88afd4eb	279c153a-87e3-4696-b084-e8b1ad160279	\N	2020-12-07 09:32:45	2022-12-01 10:22:55	\N	2020-12-16 07:52:59
c0ebd54e-9c58-4054-8ac1-d70478876955	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	d0dca4af-4472-4232-af75-aaabf7ca88e7	c0ebd54e-9c58-4054-8ac1-d70478876955	\N	2020-12-07 09:32:45	2022-12-01 10:22:56	\N	2020-12-16 07:52:59
45925aa2-ceba-4905-bed8-1ea3f129f02b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	c7a20e10-51e9-11e5-9503-af6d1e3f4589	45925aa2-ceba-4905-bed8-1ea3f129f02b	\N	2020-12-07 09:32:45	2022-12-01 10:22:57	\N	2020-12-16 07:52:59
de3e4ed2-a602-453a-bcd5-5af41f118fa1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	de3e4ed2-a602-453a-bcd5-5af41f118fa1	\N	2020-12-07 09:32:45	2022-12-01 10:22:58	\N	2020-12-16 07:53:00
65e46910-7fd5-4a82-8253-8e8bb41bbfc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	65e46910-7fd5-4a82-8253-8e8bb41bbfc7	\N	2020-12-07 09:32:45	2022-12-01 10:22:59	\N	2020-12-16 07:52:59
043185a5-987b-49fc-a409-3847a7e25476	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	0312c3d7-fde1-47cf-96ce-1f87a4228787	043185a5-987b-49fc-a409-3847a7e25476	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:52:59
962e31f2-3248-45aa-9d55-3d6af6ad8cc7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	93a0916b-c127-4476-b0f8-55aa7f4c3e80	962e31f2-3248-45aa-9d55-3d6af6ad8cc7	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:52:59
0b7c4b25-2024-4388-88c0-fbe01a9831ee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	ff07bc11-35f4-4ff1-a749-78e30f56e52c	0b7c4b25-2024-4388-88c0-fbe01a9831ee	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:52:59
a467979d-4cfc-46b8-b68a-9f9d34c1f9eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	9c53d522-5752-4556-82d0-660186bcecdc	a467979d-4cfc-46b8-b68a-9f9d34c1f9eb	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:53:00
3732438e-42ea-4ea4-8c50-ddd02c8253ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	7a13c707-8f03-e211-8560-17962475f905	3732438e-42ea-4ea4-8c50-ddd02c8253ca	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:53:00
3106ecbb-6dca-4597-9666-6619c1a66486	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	74b1c647-0142-4355-a2af-d5a15f1d2358	3106ecbb-6dca-4597-9666-6619c1a66486	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:52:59
a3331497-b8eb-4dcd-9851-27701e30ebe9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	a3331497-b8eb-4dcd-9851-27701e30ebe9	\N	2020-12-07 09:32:45	2022-12-01 10:23:07	\N	2020-12-16 07:52:59
e403df7a-a8d6-4176-b6b1-3743818c9976	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	ba02677d-8acd-e211-b8a5-d12bb761bc4d	e403df7a-a8d6-4176-b6b1-3743818c9976	\N	2020-12-07 09:32:45	2022-12-01 10:23:08	\N	2020-12-16 07:53:00
ae2676cc-e766-417a-a1ec-b9c5edb80197	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	ae2676cc-e766-417a-a1ec-b9c5edb80197	\N	2020-12-07 09:32:45	2022-12-01 10:23:08	\N	2020-12-16 07:52:59
a28fe10d-ccf0-4d45-9a2a-4e0174467b48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	e2213614-223e-44e1-ae21-f210949b0689	a28fe10d-ccf0-4d45-9a2a-4e0174467b48	\N	2020-12-07 09:32:45	2022-12-01 10:23:08	\N	2020-12-16 07:52:59
4448529a-5e04-4713-8422-2acab1b87f3c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	3b0b4884-726c-4551-9f8c-3db4d502c5f4	4448529a-5e04-4713-8422-2acab1b87f3c	\N	2020-12-07 09:32:45	2022-12-01 10:23:10	\N	2020-12-16 07:52:59
c7a158f3-2fd1-484f-abe7-dcd46de203d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	a80be64e-5393-49df-a6f7-8a18736444a1	c7a158f3-2fd1-484f-abe7-dcd46de203d5	\N	2020-12-07 09:32:45	2022-12-01 10:23:10	\N	2020-12-16 07:53:00
7db73651-2bf5-4c84-b567-3e794e5b29b3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	374d54fa-9d39-4cec-99c8-b405824d8696	7db73651-2bf5-4c84-b567-3e794e5b29b3	\N	2020-12-07 09:32:45	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
6798ecf0-86ce-45ad-bbe3-b17eed17f37a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	a162a212-58ef-41b2-b66d-93490bd5fafc	6798ecf0-86ce-45ad-bbe3-b17eed17f37a	\N	2020-12-07 09:32:45	2022-12-01 10:23:13	\N	2020-12-16 07:52:59
90e6da58-dd52-4d84-8dc8-9e00a08e4742	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	0494c011-fd20-411c-b6f3-022d10cfb1b4	90e6da58-dd52-4d84-8dc8-9e00a08e4742	\N	2020-12-07 09:32:45	2022-12-01 10:23:13	\N	2020-12-16 07:52:59
42d09da4-eb61-4092-a1f0-e10f01d2f066	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	beb52866-067c-4257-aa11-ac304217924c	42d09da4-eb61-4092-a1f0-e10f01d2f066	\N	2020-12-07 09:32:45	2022-12-01 10:23:14	\N	2020-12-16 07:52:59
85f7520a-d2d7-4e1a-b6fb-6829b9c26ed6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	e7692714-42a9-11e5-a70e-2322869c051b	85f7520a-d2d7-4e1a-b6fb-6829b9c26ed6	\N	2020-12-07 09:32:45	2022-12-01 10:23:16	\N	2020-12-16 07:52:59
ba03a2f8-d969-40fb-a990-369537d98c65	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	d5b3a578-1613-474e-865b-0a47f3a64167	ba03a2f8-d969-40fb-a990-369537d98c65	\N	2020-12-07 09:32:45	2022-12-01 10:23:19	\N	2020-12-16 07:52:59
f407428b-0e02-41f3-8878-7a453c5590b6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	06555036-10af-41b8-b767-260f6d366218	f407428b-0e02-41f3-8878-7a453c5590b6	\N	2020-12-07 09:32:45	2022-12-01 10:23:24	\N	2020-12-16 07:52:59
911699e6-e259-438e-b5d1-a31c6e98bc7a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	7033d6a0-a087-4922-a949-32763edc8bc4	911699e6-e259-438e-b5d1-a31c6e98bc7a	\N	2020-12-07 09:32:45	2022-12-01 10:23:24	\N	2020-12-16 07:52:59
499b9da2-ad72-4d78-b1d1-7f3fa87bc928	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	2f627335-3b69-4db3-94e3-0a43968e23e9	499b9da2-ad72-4d78-b1d1-7f3fa87bc928	\N	2020-12-07 09:32:45	2022-12-01 10:23:25	\N	2020-12-16 07:53:00
a111948f-59e1-431a-ad24-badd6a3bb245	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	2704f9d0-22fc-11e4-859d-e78b145c39c9	a111948f-59e1-431a-ad24-badd6a3bb245	\N	2020-12-07 09:32:45	2022-12-01 10:23:26	\N	2020-12-16 07:52:59
3a5d2efd-33f8-4153-b719-9e231578640d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	bfc8b844-394c-48b0-b8a5-27643ae71c6f	3a5d2efd-33f8-4153-b719-9e231578640d	\N	2020-12-07 09:32:45	2022-12-01 10:23:26	\N	2020-12-16 07:52:59
ea9cbe95-0927-49a1-b3cb-e59cd72fe16b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	29d04843-7d39-48d9-9720-ea6c03d77e52	ea9cbe95-0927-49a1-b3cb-e59cd72fe16b	\N	2020-12-07 09:32:45	2022-12-01 10:23:29	\N	2020-12-16 07:53:00
261fae3a-017b-45c4-8a71-9d67c000bc10	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	b5b764d4-4c3f-11e5-9257-b3688b89f32b	261fae3a-017b-45c4-8a71-9d67c000bc10	\N	2020-12-07 09:32:45	2022-12-01 10:23:29	\N	2020-12-16 07:53:00
90b6b887-7e58-474e-9891-7d2ce2b049ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	6402418c-54f9-11e5-9e54-5397b782050d	90b6b887-7e58-474e-9891-7d2ce2b049ed	\N	2020-12-07 09:32:45	2022-12-01 10:23:29	\N	2020-12-16 07:53:00
a32c11a2-794b-4aef-af50-621b63fce0ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	4f7f486c-b671-473a-9f49-b8e2a8e05c4c	f9496132-3b0c-11e5-a92d-b7a7850016b8	a32c11a2-794b-4aef-af50-621b63fce0ca	\N	2020-12-07 09:32:45	2022-12-01 10:23:29	\N	2020-12-16 07:52:59
f918a5d9-492b-4e60-82cd-c07b0ffdd077	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	56f13ef3-8065-4241-9aaa-7bc90b1eb3f0	e42f9faa-a893-4fbc-9433-305e53d01f40	f918a5d9-492b-4e60-82cd-c07b0ffdd077	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
728a5362-579f-4a73-ad13-2ea57d36d81b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	55382ebe-26b5-11e4-ac14-33644fca18ea	728a5362-579f-4a73-ad13-2ea57d36d81b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f98c0cab-66e5-439c-977e-7b3d7a849ba0	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	c7cd5e24-580a-11e3-a6eb-336f4404f5ef	f98c0cab-66e5-439c-977e-7b3d7a849ba0	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f43afcfb-40dc-49fc-a85f-69d1b0c2dfce	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	9e46ea30-6d26-11e3-8f5c-3382ff04f0de	f43afcfb-40dc-49fc-a85f-69d1b0c2dfce	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f1a42727-5074-4f5f-baf2-23ad7cca5a34	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	082e7ea8-6b75-11e3-b05e-3390bcf8a458	f1a42727-5074-4f5f-baf2-23ad7cca5a34	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
55119086-bedf-42f4-997c-d3e6ad9bc9ae	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	01a15ccf-0585-4659-9e40-35310c87e0c8	55119086-bedf-42f4-997c-d3e6ad9bc9ae	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
4472022a-bc7e-4fdf-a257-b8eb1357a494	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	6fc84202-6a4c-4618-a1db-359cc58cf815	4472022a-bc7e-4fdf-a257-b8eb1357a494	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
67a0f77d-7b1d-48b6-af90-065aaad7ab8f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	fa219c55-9c12-e211-baa1-35b0d1b1befe	67a0f77d-7b1d-48b6-af90-065aaad7ab8f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
37209eae-1805-4feb-ba27-01cc51f68ec3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	7f72387b-3b40-408c-b302-36cc9d1d85e1	37209eae-1805-4feb-ba27-01cc51f68ec3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
09d89529-6b84-4951-9156-9a853a276514	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	28112615-3e2e-47ca-9b59-e79467179426	02af8a26-a5e3-44cf-ad27-cf7d5607955b	\N	2020-12-07 09:32:45	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:52:59
dc2a9b23-815b-4e82-a9ff-3bbc70ec7d0f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	6207cf97-0d01-4dd6-ad87-d4327e455902	18ce12b8-1df7-44b2-b7e6-6482c20de6d2	\N	2020-12-07 09:32:45	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-12-16 07:52:59
2cae2791-4792-475c-aada-02e0726800dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	c5a32162-91b5-44af-bad0-031cb2cfa8e9	9b0740d0-5d23-4bed-b309-486f0ac76c84	\N	2020-12-07 09:32:45	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:52:59
a38290dd-3965-43da-b5ff-e2cbe96a37f1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	777d9a08-2517-4adf-a008-70c0d006b0a5	c89bce13-0fcd-40cc-9861-1aecafd210b9	\N	2020-12-07 09:32:45	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:53:00
6c7db7dc-1340-4b15-bc53-d7f19b15ec79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	df0b2378-9654-4f61-82dc-068b0a04404f	\N	2020-12-07 09:32:45	2020-12-16 07:52:59	\N	2020-12-16 07:52:59
6ddcfe00-83ef-4eba-b4a2-54806be4a89a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	fc887591-cc90-441b-ab14-7f04d4488c3b	6496997f-20e0-46c4-a9b1-731b6a5a8e4d	\N	2020-12-07 09:32:45	2020-12-16 07:52:59	\N	2020-12-16 07:52:59
6edea0ba-058e-404e-868c-9193dc5d0d92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	667a149e-7929-e211-ab63-417b9cc965f1	960fd9bc-b4e2-4819-90bf-99bd660f0e24	\N	2020-12-07 09:32:45	2020-12-16 07:53:00	\N	2020-12-16 07:53:00
31b6ff8d-6a6a-4136-ad15-2578ec74b202	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	11558ce2-46ca-11e5-8ba3-b7381d40fb27	31b6ff8d-6a6a-4136-ad15-2578ec74b202	\N	2020-12-07 09:32:45	2022-12-01 10:22:49	\N	2020-12-16 07:52:59
072aabd9-937a-4b98-a075-4b55847af0af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	072aabd9-937a-4b98-a075-4b55847af0af	\N	2020-12-07 09:32:45	2022-12-01 10:22:51	\N	2020-12-16 07:52:59
06daa5d2-14ae-4819-b21e-4e59b820eca5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	99f38034-4a28-11e5-a3b9-ff498a91b449	06daa5d2-14ae-4819-b21e-4e59b820eca5	\N	2020-12-07 09:32:45	2022-12-01 10:22:51	\N	2020-12-16 07:52:59
466d0765-6a6d-4c16-a6c0-fffa37b7f8c4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	ffa42521-4f5a-4d0a-8efd-f4dc24fe7f45	466d0765-6a6d-4c16-a6c0-fffa37b7f8c4	\N	2020-12-07 09:32:45	2022-12-01 10:22:52	\N	2020-12-16 07:53:00
943c02d7-9cd1-43ee-acbe-f2a6eb814009	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	a968b612-4bac-11e5-bce0-9f0e431a474f	943c02d7-9cd1-43ee-acbe-f2a6eb814009	\N	2020-12-07 09:32:45	2022-12-01 10:22:52	\N	2020-12-16 07:53:00
0aec9ba6-a1a4-41a0-8a95-d695aee10f4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	6b031760-aef5-4dbb-b520-01e6685a54d1	0aec9ba6-a1a4-41a0-8a95-d695aee10f4d	\N	2020-12-07 09:32:45	2022-12-01 10:22:54	\N	2020-12-16 07:53:00
17bb8349-d8ab-4558-bf4c-bc2a71a77ab1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	9a2404f7-9299-444f-b56e-2f3bcad3b930	17bb8349-d8ab-4558-bf4c-bc2a71a77ab1	\N	2020-12-07 09:32:45	2022-12-01 10:22:57	\N	2020-12-16 07:53:00
d911554e-992b-47ca-ba0a-8dcfdf9e7cb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	d911554e-992b-47ca-ba0a-8dcfdf9e7cb4	\N	2020-12-07 09:32:45	2022-12-01 10:22:57	\N	2020-12-16 07:53:00
82a74345-f3cf-4bce-ba57-c59536a44db0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	82a74345-f3cf-4bce-ba57-c59536a44db0	\N	2020-12-07 09:32:45	2022-12-01 10:22:59	\N	2020-12-16 07:53:00
1ade998c-9535-43cd-aa61-f4a6ac50f9f0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	4dbcf03d-8516-4f9c-a25f-679ac14e766f	1ade998c-9535-43cd-aa61-f4a6ac50f9f0	\N	2020-12-07 09:32:45	2022-12-01 10:22:59	\N	2020-12-16 07:53:00
d69ce18f-b1c9-455b-a34b-6de894af9fd1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	0110eb45-f503-e211-a8c9-8de20f7d3878	d69ce18f-b1c9-455b-a34b-6de894af9fd1	\N	2020-12-07 09:32:45	2022-12-01 10:22:59	\N	2020-12-16 07:53:00
7f051115-b806-4a00-abf6-90545deb9e20	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	7f051115-b806-4a00-abf6-90545deb9e20	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:53:00
2f2e3f50-d146-4bd8-bf64-bf98011da880	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	dff2a0f4-5123-11e5-8831-73515c7ac634	2f2e3f50-d146-4bd8-bf64-bf98011da880	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:53:00
347f1387-6e12-4842-8215-a2657255b6c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	347f1387-6e12-4842-8215-a2657255b6c3	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:53:00
e789c546-9a92-40ea-8629-3769de85637b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	5ae837e8-4a02-11e5-9a00-2bca72a8469e	e789c546-9a92-40ea-8629-3769de85637b	\N	2020-12-07 09:32:45	2022-12-01 10:23:02	\N	2020-12-16 07:53:00
d03eff6c-0f33-4387-966f-bfaabb9b3b92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	2cbe7cbe-cd98-e211-96b7-81cc7dc9a550	d03eff6c-0f33-4387-966f-bfaabb9b3b92	\N	2020-12-07 09:32:45	2022-12-01 10:23:02	\N	2020-12-16 07:53:00
362c7e37-c8a4-45f7-abfe-52468919445c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	021d11bc-3d8a-11e5-b1d1-733403640dea	362c7e37-c8a4-45f7-abfe-52468919445c	\N	2020-12-07 09:32:45	2022-12-01 10:23:04	\N	2020-12-16 07:53:00
1340c121-5279-4231-b7c9-ba6bb7552ac9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	26925a68-aab1-11e5-bde5-bb0a0689b68c	1340c121-5279-4231-b7c9-ba6bb7552ac9	\N	2020-12-07 09:32:45	2022-12-01 10:23:04	\N	2020-12-16 07:53:00
6aababad-e7e2-43ed-9c59-1fb5427380c6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	6aababad-e7e2-43ed-9c59-1fb5427380c6	\N	2020-12-07 09:32:45	2022-12-01 10:23:04	\N	2020-12-16 07:53:00
681d22da-2534-4012-a8be-da7231d0f082	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	681d22da-2534-4012-a8be-da7231d0f082	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:53:00
106b7c72-ec8e-4bd5-8a69-d5d466df4f42	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	bd4085a1-82ec-450b-9507-7924581dc0fc	106b7c72-ec8e-4bd5-8a69-d5d466df4f42	\N	2020-12-07 09:32:45	2022-12-01 10:23:06	\N	2020-12-16 07:53:00
bd7a5360-d718-4652-adb5-5c420bbacaf0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	bd7a5360-d718-4652-adb5-5c420bbacaf0	\N	2020-12-07 09:32:45	2022-12-01 10:23:07	\N	2020-12-16 07:53:00
ed96598b-7c77-4234-a4dd-b7da09d8c70a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	645aba46-378c-11e4-a83f-afbd60abf5c3	ed96598b-7c77-4234-a4dd-b7da09d8c70a	\N	2020-12-07 09:32:45	2022-12-01 10:23:08	\N	2020-12-16 07:53:00
d2f72c91-b9af-4ad5-a8ae-42a4215299db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	679c6691-5977-4188-b9cb-15090b3fb85f	d2f72c91-b9af-4ad5-a8ae-42a4215299db	\N	2020-12-07 09:32:45	2022-12-01 10:23:08	\N	2020-12-16 07:53:00
8c5ef7bb-1ef5-4834-bedf-083b466eacf9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	1aaf7fc1-e927-e211-8700-79cd2fac9006	8c5ef7bb-1ef5-4834-bedf-083b466eacf9	\N	2020-12-07 09:32:45	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
973cf9df-9d01-4180-aa4c-61b403d5a848	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	994e91c4-854b-4fe0-946c-0133e4582398	973cf9df-9d01-4180-aa4c-61b403d5a848	\N	2020-12-07 09:32:45	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
f1fbcb6b-08d7-480b-b538-1ba10021b66c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	f4e8d5dc-4f04-e211-83c8-1907f08b3f41	f1fbcb6b-08d7-480b-b538-1ba10021b66c	\N	2020-12-07 09:32:45	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
097ff6dc-ff65-49d7-a657-ad7888c2fb28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	4f7f486c-b671-473a-9f49-b8e2a8e05c4c	1f87026c-1601-4eb9-9b82-64289bded8ed	097ff6dc-ff65-49d7-a657-ad7888c2fb28	\N	2020-12-07 09:32:45	2022-12-01 10:23:16	\N	2020-12-16 07:53:00
237b8037-1203-4181-9be1-1f634b5dc599	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	e9c2db63-6ef7-4099-bcfb-256a68e7481e	237b8037-1203-4181-9be1-1f634b5dc599	\N	2020-12-07 09:32:45	2022-12-01 10:23:16	\N	2020-12-16 07:53:00
ce5eaea2-1440-492a-9bec-521c19266b62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	5a86ab5d-2ad4-4c4d-9361-0c905df38639	ce5eaea2-1440-492a-9bec-521c19266b62	\N	2020-12-07 09:32:45	2022-12-01 10:23:16	\N	2020-12-16 07:53:00
6368c97d-35fa-4af6-8b7e-54c058bd432a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	6368c97d-35fa-4af6-8b7e-54c058bd432a	\N	2020-12-07 09:32:45	2022-12-01 10:23:17	\N	2020-12-16 07:53:00
c4bd0db6-6c3c-4183-865d-6029fc2e3373	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	88c6acc3-882c-418e-b96e-f83ccccd7f79	c4bd0db6-6c3c-4183-865d-6029fc2e3373	\N	2020-12-07 09:32:45	2022-12-01 10:23:18	\N	2020-12-16 07:53:00
fe46f127-dd46-4470-a57a-1fba7de136df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	5e200dc4-4b76-483f-8e7f-e26c92431c3e	fe46f127-dd46-4470-a57a-1fba7de136df	\N	2020-12-07 09:32:45	2022-12-01 10:23:22	\N	2020-12-16 07:53:00
3c3797e2-b4b7-4bd6-9ce3-721ea937c9a0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	3c3797e2-b4b7-4bd6-9ce3-721ea937c9a0	\N	2020-12-07 09:32:45	2022-12-01 10:23:23	\N	2020-12-16 07:53:00
8de0988b-8f0d-4a79-9f05-0c769df4e484	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	7363a404-46e9-11e5-8413-7fabf05ee1fd	8de0988b-8f0d-4a79-9f05-0c769df4e484	\N	2020-12-07 09:32:45	2022-12-01 10:23:24	\N	2020-12-16 07:53:00
1eeb114b-f6a1-4988-97d4-a0e7a6824b14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	1eeb114b-f6a1-4988-97d4-a0e7a6824b14	\N	2020-12-07 09:32:45	2022-12-01 10:23:26	\N	2020-12-16 07:53:00
763ac232-2eab-43f2-b626-2ee4177d904a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	2390012c-3b9a-11e3-ab32-377a93386c06	763ac232-2eab-43f2-b626-2ee4177d904a	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
9007dbf3-7925-43b9-b878-c9acbd6273d5	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	ce8bb8ac-a11d-11e4-93c3-37be7f57efb7	9007dbf3-7925-43b9-b878-c9acbd6273d5	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
735f448b-1d0c-4f38-ace6-897808c51db4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	69217b56-44a3-4ae2-83a7-3937f6d1bde4	735f448b-1d0c-4f38-ace6-897808c51db4	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
dcc1eae2-f9e4-435d-9a6f-183891ce4595	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	6869e8f4-3fe0-11e3-b014-3b9ec9bd99dd	dcc1eae2-f9e4-435d-9a6f-183891ce4595	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
9590309c-7fe8-4408-a5a1-c6e8e4c0141b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	fa3ac988-ace0-11e4-91b4-3b9f9d736f94	9590309c-7fe8-4408-a5a1-c6e8e4c0141b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
e4d8aab6-5f95-44fc-9919-de8a2c964da3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c1e7f994-e0c0-478d-aff3-6774262fe03f	ccb3c758-00fb-e111-a051-3ba959090250	e4d8aab6-5f95-44fc-9919-de8a2c964da3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
20faf0cc-8f4c-48da-9472-7b85711fb552	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	73949094-4836-11e4-b2ea-3f502d8ef01b	20faf0cc-8f4c-48da-9472-7b85711fb552	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
442a0d57-fa46-40de-8ab2-acc76b020bbd	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	c2418312-3c7b-11e4-a21f-3f54bbd2557c	442a0d57-fa46-40de-8ab2-acc76b020bbd	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5c2528b4-fe8d-4a3b-9caa-15d950c4b9b3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	fe8c39f2-467c-11e3-80df-3faaef61ba71	5c2528b4-fe8d-4a3b-9caa-15d950c4b9b3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
3fe8f7cf-ac72-4689-9011-ff1f657e1106	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	82d9f7e4-5640-11e3-967b-43fa16355d5e	3fe8f7cf-ac72-4689-9011-ff1f657e1106	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
043bdc91-b0b5-44c9-a7c6-d69f33a12fe3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	2ed58e58-ba42-4296-9b46-449de60bd4e7	043bdc91-b0b5-44c9-a7c6-d69f33a12fe3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f85343ff-1e4d-44fa-97fd-abd692a5dd12	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	7974ee38-74c9-4af8-8b30-3839e0449e51	e3000665-6e08-4521-9d4d-d0d2b9f87da2	\N	2020-12-07 09:32:45	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-12-16 07:53:00
6cb96df8-e977-4adf-b36f-2d0658f1df9f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	d28672c2-c5a5-4238-a802-fd30f1f8341d	93797865-4e5e-4c9b-b0f0-9e400f51dda3	\N	2020-12-07 09:32:45	2020-12-16 07:53:00	\N	2020-12-16 07:53:00
6f00755a-0d1e-40ba-8fcd-659a38d51ddd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	bac27d78-b93b-49d7-bc03-f5aabdd424bb	\N	2020-12-07 09:32:45	2020-12-16 07:53:00	\N	2020-12-16 07:53:00
d83e4b39-ed08-4385-b4a6-164f6ca87d85	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	dd2adab5-bbce-4c7d-8cbd-01a872b3d516	b16236ea-dcbb-4175-9785-6e0033b1e2d7	\N	2020-12-07 09:32:45	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:53:00
6ce92b17-2a36-4a45-b156-5a8d94d8a410	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	9c09886a-f4d0-47b8-bbae-1dda023e7f45	\N	2020-12-07 09:32:45	2020-12-16 07:53:00	\N	2020-12-16 07:53:00
99358098-ffcc-41df-a821-39e1ddc5ca14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	daa07555-dd3d-44da-856b-28f08ecd474e	99358098-ffcc-41df-a821-39e1ddc5ca14	\N	2020-12-07 09:32:45	2022-12-01 10:22:48	\N	2020-12-16 07:53:00
24d8fcf5-8a80-4fbd-8584-d825f8e002d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	4e3a22a4-98e9-4024-a519-7a05be9167c8	24d8fcf5-8a80-4fbd-8584-d825f8e002d5	\N	2020-12-07 09:32:45	2022-12-01 10:22:49	\N	2020-12-16 07:53:00
25d49df3-bd7f-46ee-a7e1-a2f286ef0804	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	14fba9a1-6ca4-4937-84e7-2a845d02897a	25d49df3-bd7f-46ee-a7e1-a2f286ef0804	\N	2020-12-07 09:32:45	2022-12-01 10:22:51	\N	2020-12-16 07:53:00
47d21759-81d7-475b-901d-ed932aaf191d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	5132bbaa-b74f-4719-86b7-5cfe82b86531	47d21759-81d7-475b-901d-ed932aaf191d	\N	2020-12-07 09:32:46	2022-12-01 10:22:52	\N	2020-12-16 07:53:01
272a2dd3-7745-489c-829c-53728977fedb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	edf2c1a4-2d1f-471d-8e72-eb63959b5b64	272a2dd3-7745-489c-829c-53728977fedb	\N	2020-12-07 09:32:46	2022-12-01 10:22:53	\N	2020-12-16 07:53:00
b19613c9-8834-4631-bdc6-cf480305f960	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	540161f2-51dc-11e5-ada1-57cb00fd65d6	b19613c9-8834-4631-bdc6-cf480305f960	\N	2020-12-07 09:32:45	2022-12-01 10:22:53	\N	2020-12-16 07:53:00
c0c3e10b-7d4d-4ecc-9002-dee6e506a3a8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	78027dc1-f7e5-434a-b0c3-767f331840bb	c0c3e10b-7d4d-4ecc-9002-dee6e506a3a8	\N	2020-12-07 09:32:46	2022-12-01 10:22:54	\N	2020-12-16 07:53:01
54697f80-2bf6-4d1d-8424-420a9999bd56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	91317e32-9ec9-468c-bf5b-ef891856d180	54697f80-2bf6-4d1d-8424-420a9999bd56	\N	2020-12-07 09:32:45	2022-12-01 10:22:54	\N	2020-12-16 07:53:00
6e01051b-c002-4fd4-b245-ef25e2be04c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	d17acbd0-7f5c-4fb0-9fa7-bd34886d0788	6e01051b-c002-4fd4-b245-ef25e2be04c3	\N	2020-12-07 09:32:45	2022-12-01 10:22:54	\N	2020-12-16 07:53:00
bab8f026-6a06-452f-b556-d4f862347d39	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	efadf950-9060-45d1-a065-ddd9c87cd53f	bab8f026-6a06-452f-b556-d4f862347d39	\N	2020-12-07 09:32:46	2022-12-01 10:22:55	\N	2020-12-16 07:53:00
f79a9ca0-4612-466e-aa77-30ac20090989	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	f79a9ca0-4612-466e-aa77-30ac20090989	\N	2020-12-07 09:32:46	2022-12-01 10:22:56	\N	2020-12-16 07:53:00
4c925709-3bfb-4a1d-b0f7-d5d501745176	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	4c925709-3bfb-4a1d-b0f7-d5d501745176	\N	2020-12-07 09:32:45	2022-12-01 10:22:57	\N	2020-12-16 07:53:00
721d6218-fe71-40b7-ab0e-a13f33c95028	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	93853854-479a-11e5-8f29-97b6ab3d09e1	721d6218-fe71-40b7-ab0e-a13f33c95028	\N	2020-12-07 09:32:46	2022-12-01 10:22:58	\N	2020-12-16 07:53:01
55404301-3387-4e48-8293-5e2b88654f13	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	2e534eee-4290-11e5-9525-d72625153a3d	55404301-3387-4e48-8293-5e2b88654f13	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:01
6780aa54-81e4-4a58-98fb-6aa1a280c6b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	b0c37ebb-2fd5-4fc2-883e-267cdb7c8942	6780aa54-81e4-4a58-98fb-6aa1a280c6b4	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:00
47092d4b-e4bc-4ea1-846b-103451b98bca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	afab5d0b-c4da-455e-bd0a-8644da49ab0f	47092d4b-e4bc-4ea1-846b-103451b98bca	\N	2020-12-07 09:32:45	2022-12-01 10:22:59	\N	2020-12-16 07:53:00
4267f65c-5d1d-4926-b2ec-d155efb21c91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	a16778e6-fe58-40af-a29b-6c47664d4064	4267f65c-5d1d-4926-b2ec-d155efb21c91	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:01
cd066bd2-9fad-4542-9350-a49254da144a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	3ee043f8-9893-11e5-911a-5f12b6406080	cd066bd2-9fad-4542-9350-a49254da144a	\N	2020-12-07 09:32:46	2022-12-01 10:23:00	\N	2020-12-16 07:53:01
952d2894-ed39-4542-9c29-573d9a586e17	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	952d2894-ed39-4542-9c29-573d9a586e17	\N	2020-12-07 09:32:45	2022-12-01 10:23:00	\N	2020-12-16 07:53:00
0144d00d-9b39-4f7d-866f-cc520f4e54d1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	1e02ae8a-1e69-4e9c-a8c2-084b208eb8fb	0144d00d-9b39-4f7d-866f-cc520f4e54d1	\N	2020-12-07 09:32:46	2022-12-01 10:23:02	\N	2020-12-16 07:53:01
688ddb26-0337-4bca-a751-67749ebce77d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	472d73e3-2d2f-488f-8e2f-cd3d22418632	688ddb26-0337-4bca-a751-67749ebce77d	\N	2020-12-07 09:32:46	2022-12-01 10:23:02	\N	2020-12-16 07:53:01
6971199e-6d25-400f-b3ce-55daf73cd441	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	f59b1bb2-1e58-4760-b504-5ee5de14aba7	6971199e-6d25-400f-b3ce-55daf73cd441	\N	2020-12-07 09:32:45	2022-12-01 10:23:02	\N	2020-12-16 07:53:00
62fc0607-8914-4b57-999f-c9ed0eb7f3bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	2819b86b-4d06-499d-a0c9-af1a3e711ecf	62fc0607-8914-4b57-999f-c9ed0eb7f3bb	\N	2020-12-07 09:32:46	2022-12-01 10:23:06	\N	2020-12-16 07:53:00
9990791f-66a3-47be-bdc5-eb66a2a8c243	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	a091930a-1616-468a-861e-0a2e079f2b58	9990791f-66a3-47be-bdc5-eb66a2a8c243	\N	2020-12-07 09:32:45	2022-12-01 10:23:09	\N	2020-12-16 07:53:00
e4d0ddca-66e8-4a54-86c3-be3404f95822	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	73c986dd-4bfe-4a05-844b-00d385e21864	e4d0ddca-66e8-4a54-86c3-be3404f95822	\N	2020-12-07 09:32:46	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
102c9d5f-aa15-4b76-80fc-fe9db06f4791	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	ae2a025b-c727-e211-963e-ffbc9c164446	102c9d5f-aa15-4b76-80fc-fe9db06f4791	\N	2020-12-07 09:32:45	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
71a3abbf-1391-475e-998a-bc9259e57b54	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	b7636c46-2593-4792-968d-5432f3f28fa7	71a3abbf-1391-475e-998a-bc9259e57b54	\N	2020-12-07 09:32:46	2022-12-01 10:23:12	\N	2020-12-16 07:53:00
6213eaf1-4937-45d2-9e06-c70e67300218	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	d6da0950-f65b-47d2-9965-579b90b08ffd	6213eaf1-4937-45d2-9e06-c70e67300218	\N	2020-12-07 09:32:45	2022-12-01 10:23:14	\N	2020-12-16 07:53:00
81fb1ffe-1d8f-4319-ae90-bb3fcf776cb8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	7c15fbb2-33c9-4ba2-93a4-b9d988e939b4	81fb1ffe-1d8f-4319-ae90-bb3fcf776cb8	\N	2020-12-07 09:32:45	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
a2454e55-8b7b-473e-adcd-a78f448c62c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	0c57cc9c-4c32-11e5-858c-afbc5904667e	a2454e55-8b7b-473e-adcd-a78f448c62c5	\N	2020-12-07 09:32:46	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
1dfbc8d0-a6ed-4b34-a2dc-aeb4450e3f0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	162955a4-43dc-4ee3-85f2-b4b602c72400	1dfbc8d0-a6ed-4b34-a2dc-aeb4450e3f0e	\N	2020-12-07 09:32:46	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
ee12181b-b2fe-4725-bd46-714eb647fdb2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	14f34d04-bb92-4cf1-bb11-5e424fa98ae7	ee12181b-b2fe-4725-bd46-714eb647fdb2	\N	2020-12-07 09:32:45	2022-12-01 10:23:15	\N	2020-12-16 07:53:00
7ca740fa-cde2-486b-b6b4-7d0d80a60fed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	5fb28ec2-45dd-45c4-8021-0e597172c690	7ca740fa-cde2-486b-b6b4-7d0d80a60fed	\N	2020-12-07 09:32:45	2022-12-01 10:23:17	\N	2020-12-16 07:53:00
9317c108-c18f-493d-b59e-932b7be6020f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	8cf66883-ebc1-473e-a01c-37925b2b2150	9317c108-c18f-493d-b59e-932b7be6020f	\N	2020-12-07 09:32:45	2022-12-01 10:23:19	\N	2020-12-16 07:53:00
cbc203c0-e7e8-4411-8514-190d26fe1de5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	04a45a78-7f1b-4cad-a70f-732efa5f7985	cbc203c0-e7e8-4411-8514-190d26fe1de5	\N	2020-12-07 09:32:46	2022-12-01 10:23:22	\N	2020-12-16 07:53:00
bba077f5-a684-401b-8d7d-7b04a22a9b5e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	1438adc2-38fc-11e4-b641-3f0b3de385b4	bba077f5-a684-401b-8d7d-7b04a22a9b5e	\N	2020-12-07 09:32:46	2022-12-01 10:23:24	\N	2020-12-16 07:53:00
b507d07f-b995-421d-9ef3-32d44fd03ef0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	ea745b98-c427-e211-963e-ffbc9c164446	b507d07f-b995-421d-9ef3-32d44fd03ef0	\N	2020-12-07 09:32:45	2022-12-01 10:23:25	\N	2020-12-16 07:53:00
aaa92560-8fae-417c-834d-f4fddc2895a6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	9433b08e-fac0-4a20-9d42-684e7aced3c6	aaa92560-8fae-417c-834d-f4fddc2895a6	\N	2020-12-07 09:32:45	2022-12-01 10:23:26	\N	2020-12-16 07:53:00
0c20136d-5245-4d99-9ce7-6c6a909bed32	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	edbf1ed9-b137-4d28-8af1-a22ab23be53b	0c20136d-5245-4d99-9ce7-6c6a909bed32	\N	2020-12-07 09:32:46	2022-12-01 10:23:26	\N	2020-12-16 07:53:01
4cbb298c-97db-482a-8341-d02f736034ed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	df5d382f-ab4e-4767-a540-3e4240916784	4cbb298c-97db-482a-8341-d02f736034ed	\N	2020-12-07 09:32:46	2022-12-01 10:23:26	\N	2020-12-16 07:53:00
b0df2283-ea2a-47ef-a781-08eca2de1bf0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	11aea642-466b-11e5-886c-1b8856809555	b0df2283-ea2a-47ef-a781-08eca2de1bf0	\N	2020-12-07 09:32:45	2022-12-01 10:23:29	\N	2020-12-16 07:53:00
3745be53-a30c-4f5d-aa9a-e4703dff9197	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	ad705d8a-429e-11e5-a989-af44a02d940a	3745be53-a30c-4f5d-aa9a-e4703dff9197	\N	2020-12-07 09:32:46	2022-12-01 10:23:29	\N	2020-12-16 07:53:01
e39ed7b8-d114-47ac-b31a-cb807f33ebd1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	7b6763fc-6f9f-11e3-b017-03efaa0c94af	e39ed7b8-d114-47ac-b31a-cb807f33ebd1	\N	2020-12-07 09:32:46	2022-12-01 10:23:30	\N	2020-12-16 07:53:00
f0b51c7a-eb77-4abb-944c-17114cfd9a20	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	0e9d20fe-3907-11e4-8c40-471c39e32bc7	f0b51c7a-eb77-4abb-944c-17114cfd9a20	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
a4178a3c-fa79-4c2c-86e4-21522f3a8afe	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	511cc604-5538-11e3-8cae-474a1b9e26e1	a4178a3c-fa79-4c2c-86e4-21522f3a8afe	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
bb487ee5-c268-494e-afcf-0de2469c5d91	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	2f823776-a2f2-45b7-98bf-476290697f45	bb487ee5-c268-494e-afcf-0de2469c5d91	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
19f1d068-001f-4df1-bf9c-d9be546686a6	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	f1facbe2-9880-4e12-8dab-4793fd26a6b1	19f1d068-001f-4df1-bf9c-d9be546686a6	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d42c514f-8de0-427e-b7a9-3a5bd74b12cb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	dd61d05b-1814-e211-b31d-49799ca82997	d42c514f-8de0-427e-b7a9-3a5bd74b12cb	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d436561c-3fa6-400d-9b9d-a09f7ffcdfe9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	4073d15b-1814-e211-b334-49799ca82997	d436561c-3fa6-400d-9b9d-a09f7ffcdfe9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c6bffe0b-e2bf-42a3-8dfa-578cf46ce3c8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	0ed24a94-592d-11e5-8142-4f45aea730e6	b990420b-112e-4b8e-84e9-0694dcd2d29f	\N	2020-12-07 09:32:46	2020-12-16 07:53:01	2020-12-16 07:53:01	2020-12-07 09:32:46
e35c1db4-079c-41a8-9553-0731c2078c9c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	0ebedf1f-df57-45e0-90ab-070e67bba4db	cb506667-7028-456c-8f6a-42886c471106	\N	2020-12-07 09:32:45	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-12-16 07:53:00
c6d42ef7-6152-4ca2-971b-3878dd43bfbf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	6a5acada-8f36-4e1c-abc4-73bb22b53cdd	29cae5b1-a87c-4dbf-9b9f-cbd6cc9f0ad8	\N	2020-12-07 09:32:46	2022-04-05 06:43:18	2022-04-05 06:43:18	2020-12-16 07:53:00
6d68ba4d-4b8c-4763-bd7f-581b744f229e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	4f7f486c-b671-473a-9f49-b8e2a8e05c4c	607b1b72-46d2-11e5-ba50-1375139e8458	85b5c822-9b96-41f9-bca0-f95b1805f16a	\N	2020-12-07 09:32:45	2020-12-16 07:53:00	\N	2020-12-16 07:53:00
9bb0c82d-c6c9-4af0-b020-f9f019f4dd63	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	e9cef568-2ada-4e64-b69f-00c23c5d8604	9bb0c82d-c6c9-4af0-b020-f9f019f4dd63	\N	2020-12-07 09:32:45	2022-12-01 10:22:48	\N	2020-12-16 07:53:00
3ad4cf2b-fc16-4de5-90f6-50314385b28c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	b7b48546-4541-11e5-b9f9-e7e850efd101	3ad4cf2b-fc16-4de5-90f6-50314385b28c	\N	2020-12-07 09:32:46	2022-12-01 10:22:51	\N	2020-12-16 07:53:00
dc213f5e-18a2-484d-95f4-1314aaf94425	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	f80b678d-bb43-4915-9ef0-22b1d2320638	dc213f5e-18a2-484d-95f4-1314aaf94425	\N	2020-12-07 09:32:46	2022-12-01 10:22:52	\N	2020-12-16 07:53:01
8c614442-e6af-487c-9cf4-47e1bf324252	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	d993ad11-d98a-4803-85a4-a446d7b9d4c7	8c614442-e6af-487c-9cf4-47e1bf324252	\N	2020-12-07 09:32:46	2022-12-01 10:22:53	\N	2020-12-16 07:53:01
1508ce84-d0b1-4416-ab02-5df906142dad	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	243b6119-e39f-4849-8fd0-218155575c5a	1508ce84-d0b1-4416-ab02-5df906142dad	\N	2020-12-07 09:32:46	2022-12-01 10:22:54	\N	2020-12-16 07:53:01
805e08b5-a2d4-4c9c-997a-7f532b2e1c82	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	d081c069-65b7-4bf5-866a-423def103d81	805e08b5-a2d4-4c9c-997a-7f532b2e1c82	\N	2021-03-30 09:19:29	2022-12-01 10:22:56	\N	2021-05-19 12:39:11
f9ce40a2-bbeb-49d5-af21-bc57802497e4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	f530a57f-1b10-e211-9570-4d846480b264	f9ce40a2-bbeb-49d5-af21-bc57802497e4	\N	2021-03-30 09:19:30	2022-12-01 10:22:57	\N	2021-05-19 12:39:11
88edb722-66e7-4e8c-86b4-9483f5a12939	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	06b71793-3a86-4c6b-9000-717dca267295	88edb722-66e7-4e8c-86b4-9483f5a12939	\N	2020-12-07 09:32:46	2022-12-01 10:22:58	\N	2020-12-16 07:53:01
1adc0f69-7b5e-4801-9c77-d5177de2d82e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	1adc0f69-7b5e-4801-9c77-d5177de2d82e	\N	2020-12-07 09:32:45	2022-12-01 10:22:58	\N	2020-12-16 07:53:00
adf8c906-8099-4747-ad2f-6519470de971	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	cae987c8-810a-4d95-a5fb-27e3108961de	adf8c906-8099-4747-ad2f-6519470de971	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:01
a7b1dcf2-8cc0-449b-89b2-a26520e028ea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	a7b1dcf2-8cc0-449b-89b2-a26520e028ea	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:01
3159a28c-59ef-428b-a0ec-ea11c2994828	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	cd878984-6a47-450b-b517-326167975212	a83c363b-c56d-49b3-9d37-61d51488daab	3159a28c-59ef-428b-a0ec-ea11c2994828	\N	2020-12-07 09:32:46	2022-12-01 10:22:59	\N	2020-12-16 07:53:01
ca589217-2960-4e5e-8413-5dcde37884ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	4cfe6fe6-3bd2-11e5-8102-9bf1fe8e31c5	ca589217-2960-4e5e-8413-5dcde37884ba	\N	2021-03-30 09:19:29	2022-12-01 10:23:01	\N	2021-05-19 12:39:10
0bd1ebc8-db2f-48f4-b069-8b96c3982f90	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	6ba43a51-d4b8-4b42-a964-915453deb56a	0bd1ebc8-db2f-48f4-b069-8b96c3982f90	\N	2020-12-07 09:32:46	2022-12-01 10:23:02	\N	2020-12-16 07:53:01
ee2be826-0fc4-44d9-8538-b60989982c67	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	2ebf3924-3b29-11e5-a61b-1bd2cb4c4fb8	ee2be826-0fc4-44d9-8538-b60989982c67	\N	2021-03-30 09:19:29	2022-12-01 10:23:02	\N	2021-05-19 12:39:11
e3ad880c-cf92-46dc-8531-754b1b3c65cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	52ae8172-5750-4387-badd-79b17d2081aa	e3ad880c-cf92-46dc-8531-754b1b3c65cc	\N	2021-03-30 09:19:29	2022-12-01 10:23:04	\N	2021-05-19 12:39:11
1689d0ea-0530-44b5-af3f-c4680c12c9c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	4f7f486c-b671-473a-9f49-b8e2a8e05c4c	e131badd-15c9-4911-8c81-1d30249b7d73	1689d0ea-0530-44b5-af3f-c4680c12c9c9	\N	2020-12-07 09:32:46	2022-12-01 10:23:07	\N	2020-12-16 07:53:01
25d49ac7-72c3-4399-b48b-3f752fcdac1c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	5e27af4e-b6be-4489-8c7f-1b35d6d06056	25d49ac7-72c3-4399-b48b-3f752fcdac1c	\N	2020-12-07 09:32:46	2022-12-01 10:23:10	\N	2020-12-16 07:53:01
9d52e3ae-9081-4ed4-ba90-4212142050a5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	f4dc7769-10f3-474c-9bad-a7f651d71321	9d52e3ae-9081-4ed4-ba90-4212142050a5	\N	2020-12-07 09:32:46	2022-12-01 10:23:10	\N	2020-12-16 07:53:01
1ffe4920-fc49-4c58-b0c4-106918145f54	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	98488e79-c327-e211-963e-ffbc9c164446	1ffe4920-fc49-4c58-b0c4-106918145f54	\N	2020-12-07 09:32:45	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
ca0d4b43-ead1-4709-9c61-40cee801e203	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	695dda2d-4408-e211-b6ed-d1aec8947609	ca0d4b43-ead1-4709-9c61-40cee801e203	\N	2020-12-07 09:32:45	2022-12-01 10:23:11	\N	2020-12-16 07:53:00
5a69d764-248b-4d43-b019-8a95c06529d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	8462527e-862e-4b54-b09b-a9c99a9f276d	5a69d764-248b-4d43-b019-8a95c06529d9	\N	2021-03-30 09:19:29	2022-12-01 10:23:13	\N	2021-05-19 12:39:11
9bf05962-b687-4be6-9d8e-ebd0df63b32e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	9bf05962-b687-4be6-9d8e-ebd0df63b32e	\N	2021-03-30 09:19:29	2022-12-01 10:23:13	\N	2021-05-19 12:39:11
c16befb6-bbd1-4fad-9a61-940c6d6f8894	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	1d2b0b00-23c4-4c1b-a956-a85ff7deb40b	c16befb6-bbd1-4fad-9a61-940c6d6f8894	\N	2020-12-07 09:32:46	2022-12-01 10:23:13	\N	2020-12-16 07:53:01
146efff1-6e6d-49c9-9921-0246510ee17a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	c60e92a2-99c2-4394-a48b-251540c8b96f	146efff1-6e6d-49c9-9921-0246510ee17a	\N	2020-12-07 09:32:46	2022-12-01 10:23:17	\N	2020-12-16 07:53:01
4833c306-75c3-4592-bae7-0f9e114d6245	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	b255e348-4b76-11e5-8241-13af4f7fae26	4833c306-75c3-4592-bae7-0f9e114d6245	\N	2021-03-30 09:19:29	2022-12-01 10:23:17	\N	2021-05-19 12:39:11
1ba23d82-7b75-4559-9926-c09f35a1197a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	5a74651c-287f-49e7-a790-836afd34108f	9397e666-ef98-e211-9c3d-bd33617080df	1ba23d82-7b75-4559-9926-c09f35a1197a	\N	2020-12-07 09:32:46	2022-12-01 10:23:17	\N	2020-12-16 07:53:01
4efd8e24-180b-4177-911f-d6dacebd7ffd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	52d5486a-4544-11e5-b3ea-131ef06916b5	4efd8e24-180b-4177-911f-d6dacebd7ffd	\N	2020-12-07 09:32:45	2022-12-01 10:23:19	\N	2020-12-16 07:53:00
77f9c50c-a942-4a5f-bfb6-72771f562aac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	41d8d02b-68d7-4fd1-aaa1-0977b7444c63	77f9c50c-a942-4a5f-bfb6-72771f562aac	\N	2021-03-30 09:19:29	2022-12-01 10:23:19	\N	2021-05-19 12:39:11
038745a5-3818-4a0d-ad59-09ea6c4e1d2e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	bed2e326-06e7-4698-94d5-d46efc825014	038745a5-3818-4a0d-ad59-09ea6c4e1d2e	\N	2020-12-07 09:32:46	2022-12-01 10:23:22	\N	2020-12-16 07:53:01
f005606a-ac2e-4596-b313-80bd3a4d1bec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	60c2ff20-4b6c-11e5-958c-b39420b5676f	f005606a-ac2e-4596-b313-80bd3a4d1bec	\N	2021-03-30 09:19:29	2022-12-01 10:23:24	\N	2021-05-19 12:39:10
e6f062a3-f44d-4689-a2e0-9869230db156	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	159400d8-7511-4433-83b9-28dadb4d6183	542df659-4377-411d-9fa8-1f5ce8878479	e6f062a3-f44d-4689-a2e0-9869230db156	\N	2020-12-07 09:32:46	2022-12-01 10:23:24	\N	2020-12-16 07:53:01
55176c8e-4fcf-42ca-904f-a25720c49182	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	55176c8e-4fcf-42ca-904f-a25720c49182	\N	2020-12-07 09:32:44	2022-12-01 10:23:24	\N	2020-12-16 07:52:59
6e55be11-f523-4560-b1a3-38dfd6b08078	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	ff732935-72e5-4865-bb47-f3e0cb79d9fa	6e55be11-f523-4560-b1a3-38dfd6b08078	\N	2021-03-30 09:19:29	2022-12-01 10:23:24	\N	2021-05-19 12:39:10
76e605a9-ce4f-41bd-9961-667511bd40db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ada5e155-12c9-43f9-b653-aabfe0894f7a	d85e860f-35a9-4406-8bc6-0e4051153600	76e605a9-ce4f-41bd-9961-667511bd40db	\N	2020-12-07 09:32:46	2022-12-01 10:23:25	\N	2020-12-16 07:53:01
91c5272d-82e6-4f16-a83d-041088cb6c58	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	1c94fedd-9703-e211-b291-0143ed05e022	91c5272d-82e6-4f16-a83d-041088cb6c58	\N	2020-12-07 09:32:46	2022-12-01 10:23:25	\N	2020-12-16 07:53:01
9c1af666-8a8b-47dd-9248-f1441ef01c4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	ab2a7a6d-767e-4c34-8fdd-e430657d1478	097f5676-e6b8-4033-9b17-43eb6a4145bf	9c1af666-8a8b-47dd-9248-f1441ef01c4e	\N	2020-12-07 09:32:46	2022-12-01 10:23:26	\N	2020-12-16 07:53:01
fa462966-aa11-4031-8f2e-a1ea2eac02bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	8e10391f-07fe-41b9-84c7-106974b83db3	fa462966-aa11-4031-8f2e-a1ea2eac02bb	\N	2020-12-07 09:32:46	2022-12-01 10:23:29	\N	2020-12-16 07:53:01
f03b51f9-3586-4f47-8dea-56af2c83b4e7	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	851ae868-3602-4e12-8a64-4989b6625583	f03b51f9-3586-4f47-8dea-56af2c83b4e7	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
2e8c9205-ceda-4226-a2f2-9b85c40baf1d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	a9c230d8-3321-11e4-8bd5-4f2b10fbc4d3	2e8c9205-ceda-4226-a2f2-9b85c40baf1d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
35dbd260-4eaf-472c-baf7-d2a99dfdb4d0	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	2e62bece-7f35-4437-9ab4-4f8159e028e5	35dbd260-4eaf-472c-baf7-d2a99dfdb4d0	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
b0765fb2-a19c-438f-bcae-cdb680d2945f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	5fc2e65b-9d83-e211-bd60-51ae90ff7c64	b0765fb2-a19c-438f-bcae-cdb680d2945f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
b7321133-c2f8-499e-a462-d485d06b3f5d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	7b4a9f3d-6f72-482c-8ccc-79f04cc087f4	39a4f904-9b04-44ea-9164-b69ddf6a7199	5b4c4f9f-40df-4c32-9de2-2c5d65e9b71b	\N	2020-12-07 09:32:46	2021-10-26 09:36:52	2021-10-26 09:36:52	2020-12-16 07:53:01
8fa8d31c-f6f9-4085-9b56-c1176f2d6cfc	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	13088d7f-91f0-42b9-ae76-b38a25c169ee	9725d61d-8b66-4aa9-85f3-5340d70b52ed	8fa8d31c-f6f9-4085-9b56-c1176f2d6cfc	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
793d919b-8412-46c7-bc94-5a1329db448e	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	fb55d64f-b782-4314-b77e-537a3c61cd1c	793d919b-8412-46c7-bc94-5a1329db448e	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
8dd60f52-d660-44bf-be29-5f2eb5e01179	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	d14e2782-7c64-4919-87e5-55f89caff42a	8dd60f52-d660-44bf-be29-5f2eb5e01179	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
a73a6df3-52a1-41e0-98d4-7dced3dbc1e7	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	a1a5f7a8-2756-11e4-a127-571a04d8996f	a73a6df3-52a1-41e0-98d4-7dced3dbc1e7	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
4f0ef01e-312b-4260-907c-881d093ad78b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	b7d6d3f4-77ae-41df-8c21-56e8731513a1	1fadc10a-c46c-4ded-a2ad-703b6addf659	\N	2020-12-07 09:32:46	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-12-16 07:53:01
d06823eb-0bf0-47da-81c4-cea99e302ba3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	3c2f7a94-e74c-470d-99aa-9948b3c95b0d	39d012b6-b00a-4aaa-b389-0e15e420ad3a	24b5e12e-fd9f-4ac6-9393-980f739e1ee9	\N	2020-12-07 09:32:46	2021-12-15 08:21:07	2021-12-15 08:21:07	2020-12-16 07:53:01
fb8a268f-016e-479a-8433-7de69592f540	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	8256af89-92ab-4b06-9069-e1f23c9c9556	625f5a62-03e6-4066-8186-2fd7a0189797	bee06f73-205f-425d-b7f1-c63f95ae1689	\N	2020-12-07 09:32:46	2022-04-05 06:43:18	2022-04-05 06:43:18	2020-12-16 07:53:01
3dd2abac-fd09-4b0a-a086-8f5e420bfb89	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	69e28726-8c18-44df-86de-f66f84692b3c	9833a660-4b73-11e5-934e-37a2f6ed830d	3dd2abac-fd09-4b0a-a086-8f5e420bfb89	\N	2020-12-07 09:32:46	2022-12-01 10:22:49	\N	2020-12-16 07:53:01
714e743d-f585-47a5-a1b2-a43a342d8bf9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	2c1847a5-ae44-40e2-836e-cc566e0ed984	714e743d-f585-47a5-a1b2-a43a342d8bf9	\N	2021-03-30 09:19:29	2022-12-01 10:22:49	\N	2021-05-19 12:39:11
384d9ff0-b040-4590-8920-9d0c0182690e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	58f0cec9-2df4-4c8e-bec8-9bb1d6a66fa9	ab6417da-ec15-496a-938b-3d116b961a9f	384d9ff0-b040-4590-8920-9d0c0182690e	\N	2020-12-07 09:32:46	2022-12-01 10:22:50	\N	2020-12-16 07:53:01
a34eefd4-82f7-4d83-ab17-3cfea8953b15	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20201	d02d2d53-ccee-42d2-bf10-dafdda817315	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	a34eefd4-82f7-4d83-ab17-3cfea8953b15	\N	2020-12-07 09:32:46	2022-12-01 10:22:52	\N	2020-12-16 07:53:01
ef1fe8c1-5b9b-43d9-bdd7-2826af8c7e4d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	ac0343f2-09a5-4b95-b38f-cd379433d96c	ef1fe8c1-5b9b-43d9-bdd7-2826af8c7e4d	\N	2021-03-30 09:19:30	2022-12-01 10:22:54	\N	2021-05-19 12:39:11
93ea3e81-632c-4085-ae88-9e1126067fa0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	210fde58-74aa-4ea9-a4e4-ab32b37448b1	93ea3e81-632c-4085-ae88-9e1126067fa0	\N	2021-03-30 09:19:30	2022-12-01 10:22:54	\N	2021-05-19 12:39:11
c01851d1-9b45-4900-a556-97349fa2b1d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	7170e1e4-3bd5-11e5-b6d7-17ebb1495aaf	c01851d1-9b45-4900-a556-97349fa2b1d9	\N	2021-03-30 09:19:31	2022-12-01 10:22:56	\N	2021-05-19 12:39:11
6232c70d-87a6-4fbb-87af-44ddd4015529	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	dfc19fd5-08ef-47d0-82f0-051152d6bfdf	6232c70d-87a6-4fbb-87af-44ddd4015529	\N	2021-03-30 09:19:32	2022-12-01 10:22:57	\N	2021-05-19 12:39:11
47e0aefc-6a02-477e-8699-173efce34c7a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	b32063b6-462b-11e5-9585-133f160aafbb	47e0aefc-6a02-477e-8699-173efce34c7a	\N	2021-03-30 09:19:30	2022-12-01 10:22:58	\N	2021-05-19 12:39:11
c334e6ec-2732-42a9-887b-2b7b05068916	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	d0dca4af-4472-4232-af75-aaabf7ca88e7	c334e6ec-2732-42a9-887b-2b7b05068916	\N	2021-03-30 09:19:31	2022-12-01 10:22:59	\N	2021-05-19 12:39:11
0b101d1c-b0cf-42a6-bcc0-b5f9056f9442	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	f9496132-3b0c-11e5-a92d-b7a7850016b8	0b101d1c-b0cf-42a6-bcc0-b5f9056f9442	\N	2021-03-30 09:19:31	2022-12-01 10:22:59	\N	2021-05-19 12:39:11
abcf368a-0964-435c-b11d-37e01ea46992	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	7df870be-f674-4ed1-bf50-340cbfdc845a	abcf368a-0964-435c-b11d-37e01ea46992	\N	2021-03-30 09:19:30	2022-12-01 10:23:00	\N	2021-05-19 12:39:11
7f67e364-885d-46d1-aa93-2aa8e2888e14	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	7bd0404c-9603-e211-b291-0143ed05e022	7f67e364-885d-46d1-aa93-2aa8e2888e14	\N	2021-03-30 09:19:30	2022-12-01 10:23:00	\N	2021-05-19 12:39:11
2af72b11-5333-437e-8d93-610fd385d6bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	808f4853-72f6-44e9-8555-4e07f494c8cf	2af72b11-5333-437e-8d93-610fd385d6bc	\N	2021-03-30 09:19:32	2022-12-01 10:23:00	\N	2021-05-19 12:39:11
c2dad4b5-b786-4e7d-aca9-cda09e3c17ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	eaf8c75b-a70c-4502-9ee2-9bafa8ea53d7	c2dad4b5-b786-4e7d-aca9-cda09e3c17ae	\N	2021-03-30 09:19:31	2022-12-01 10:23:01	\N	2021-05-19 12:39:11
e56b60e8-eae4-4c33-b0e3-7fe0c3c4c7b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	c7a20e10-51e9-11e5-9503-af6d1e3f4589	e56b60e8-eae4-4c33-b0e3-7fe0c3c4c7b4	\N	2021-03-30 09:19:31	2022-12-01 10:23:04	\N	2021-05-19 12:39:11
95cb1622-f72b-43b7-bc68-7f685a758fe8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	beb52866-067c-4257-aa11-ac304217924c	95cb1622-f72b-43b7-bc68-7f685a758fe8	\N	2021-03-30 09:19:31	2022-12-01 10:23:05	\N	2021-05-19 12:39:11
0b99c6f5-c468-4d59-94f6-707c92737995	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	22160fc9-321a-40b5-849f-f8db354b9185	0b99c6f5-c468-4d59-94f6-707c92737995	\N	2021-03-30 09:19:30	2022-12-01 10:23:06	\N	2021-05-19 12:39:11
d4befe46-e182-42be-94e5-43def498ba92	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	c6a9bf46-4c3d-11e5-a5b5-cf466c53f4c1	d4befe46-e182-42be-94e5-43def498ba92	\N	2021-03-30 09:19:31	2022-12-01 10:23:06	\N	2021-05-19 12:39:11
e43d254a-2e45-4c42-b2c5-62e073fe17df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	e2213614-223e-44e1-ae21-f210949b0689	e43d254a-2e45-4c42-b2c5-62e073fe17df	\N	2021-03-30 09:19:32	2022-12-01 10:23:06	\N	2021-05-19 12:39:11
618994b4-03e8-4b1d-8c8f-e3236848b6fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	99f38034-4a28-11e5-a3b9-ff498a91b449	618994b4-03e8-4b1d-8c8f-e3236848b6fe	\N	2021-03-30 09:19:31	2022-12-01 10:23:10	\N	2021-05-19 12:39:11
5881f698-7fe3-496f-abd1-bc742df14a38	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	7033d6a0-a087-4922-a949-32763edc8bc4	5881f698-7fe3-496f-abd1-bc742df14a38	\N	2021-03-30 09:19:31	2022-12-01 10:23:12	\N	2021-05-19 12:39:11
fe8b8895-5f7b-4614-94df-eef4b3239074	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	e7692714-42a9-11e5-a70e-2322869c051b	fe8b8895-5f7b-4614-94df-eef4b3239074	\N	2021-03-30 09:19:31	2022-12-01 10:23:12	\N	2021-05-19 12:39:11
1a3b32bc-cc44-491a-b196-456d452bcb08	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	54976902-8866-4627-a970-0abcb6abb6f9	1a3b32bc-cc44-491a-b196-456d452bcb08	\N	2021-03-30 09:19:32	2022-12-01 10:23:12	\N	2021-05-19 12:39:11
de984c96-eb9e-4771-8fea-a2c1d53fc5fb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	6e12f9fd-e106-472d-8364-ce7da552e702	de984c96-eb9e-4771-8fea-a2c1d53fc5fb	\N	2021-03-30 09:19:31	2022-12-01 10:23:12	\N	2021-05-19 12:39:11
c956c1ac-079b-427d-b5a9-b78523e00bda	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	906376c2-1463-4361-897e-a7ef5a19239d	c956c1ac-079b-427d-b5a9-b78523e00bda	\N	2021-03-30 09:19:30	2022-12-01 10:23:12	\N	2021-05-19 12:39:11
57176af2-fbcd-4a3e-9cd2-cd49c6cdb161	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	391a7e1a-82bb-11e3-9dab-eb22ccd76f80	57176af2-fbcd-4a3e-9cd2-cd49c6cdb161	\N	2021-03-30 09:19:31	2022-12-01 10:23:13	\N	2021-05-19 12:39:11
bfc4e1bf-3b53-4c4d-8b6b-461a7c46fea1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	2f01ff42-4ba1-11e5-b3aa-1f640eaab9a5	bfc4e1bf-3b53-4c4d-8b6b-461a7c46fea1	\N	2021-03-30 09:19:30	2022-12-01 10:23:16	\N	2021-05-19 12:39:11
9857e936-2f87-453b-baef-7508b97c15b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	268ca679-ea35-4e6d-9a9b-9c73d09bd8d3	9857e936-2f87-453b-baef-7508b97c15b0	\N	2021-03-30 09:19:31	2022-12-01 10:23:16	\N	2021-05-19 12:39:11
54fb8cd1-3551-4e92-a08c-2f880d3dcb5b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	7c1dce1f-2cd6-4be9-9c6e-2f7840e164e1	54fb8cd1-3551-4e92-a08c-2f880d3dcb5b	\N	2021-03-30 09:19:30	2022-12-01 10:23:16	\N	2021-05-19 12:39:11
ed41dd5f-a8ac-4f6f-9e77-0fcf2f46765c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	74b1c647-0142-4355-a2af-d5a15f1d2358	ed41dd5f-a8ac-4f6f-9e77-0fcf2f46765c	\N	2021-03-30 09:19:31	2022-12-01 10:23:18	\N	2021-05-19 12:39:11
9d4f5e6f-8f67-4efd-a5db-68eeb72e09ff	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	7dbbb577-7b93-48ef-b139-db84e9163597	9d4f5e6f-8f67-4efd-a5db-68eeb72e09ff	\N	2021-03-30 09:19:30	2022-12-01 10:23:18	\N	2021-05-19 12:39:11
a2820310-369e-44b2-9507-e230c6f45007	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	9f500ca4-4ba0-11e5-a463-d3e2823fa8ef	a2820310-369e-44b2-9507-e230c6f45007	\N	2021-03-30 09:19:31	2022-12-01 10:23:19	\N	2021-05-19 12:39:11
3efd2487-eaf9-49f1-bf4a-c4759ddc1d09	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	d5b3a578-1613-474e-865b-0a47f3a64167	3efd2487-eaf9-49f1-bf4a-c4759ddc1d09	\N	2021-03-30 09:19:31	2022-12-01 10:23:21	\N	2021-05-19 12:39:11
8ba2d4d9-0e61-4ce4-8ce9-37f60c441cee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	c593fef2-46d2-11e5-b14e-8fa23f386b5a	8ba2d4d9-0e61-4ce4-8ce9-37f60c441cee	\N	2021-03-30 09:19:30	2022-12-01 10:23:21	\N	2021-05-19 12:39:11
44bf6b90-6222-4cab-a609-58387bb46680	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	ff07bc11-35f4-4ff1-a749-78e30f56e52c	44bf6b90-6222-4cab-a609-58387bb46680	\N	2021-03-30 09:19:31	2022-12-01 10:23:22	\N	2021-05-19 12:39:11
bf856e39-7e7c-481f-ab5f-bcb422a25ccd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	06555036-10af-41b8-b767-260f6d366218	bf856e39-7e7c-481f-ab5f-bcb422a25ccd	\N	2021-03-30 09:19:31	2022-12-01 10:23:22	\N	2021-05-19 12:39:11
889b017a-d94f-418b-9c06-035906af1fab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	304a3c38-bda8-4b1f-b2ef-087817e35993	889b017a-d94f-418b-9c06-035906af1fab	\N	2021-03-30 09:19:30	2022-12-01 10:23:24	\N	2021-05-19 12:39:11
ce2ce143-7ed6-4a87-919a-634276c7baa2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	ea543c35-e3d7-484c-b472-6d5a88afd4eb	ce2ce143-7ed6-4a87-919a-634276c7baa2	\N	2021-03-30 09:19:31	2022-12-01 10:23:25	\N	2021-05-19 12:39:11
ed9cd7b5-4f6f-49df-8b39-a0176cdf15ae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	f5f39244-4d56-11e5-8ec5-7f16a3e49b78	ed9cd7b5-4f6f-49df-8b39-a0176cdf15ae	\N	2021-03-30 09:19:31	2022-12-01 10:23:29	\N	2021-05-19 12:39:11
3e961c61-9501-4e24-b419-353c1d4540f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	11558ce2-46ca-11e5-8ba3-b7381d40fb27	3e961c61-9501-4e24-b419-353c1d4540f8	\N	2021-03-30 09:19:31	2022-12-01 10:23:30	\N	2021-05-19 12:39:11
bb118bbf-5631-42a9-bc88-9728605127e3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	3de110c0-2fe1-11e4-a8ff-57505ee4d1d8	bb118bbf-5631-42a9-bc88-9728605127e3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
48dad27f-022a-4625-bf87-5e53c827a817	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	02e9222a-180a-e211-852d-5952e6affd31	48dad27f-022a-4625-bf87-5e53c827a817	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
3e8497bc-eec8-40e7-9c9b-a45fbbe2d830	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	1410232a-180a-e211-8531-5952e6affd31	3e8497bc-eec8-40e7-9c9b-a45fbbe2d830	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
8312c6fe-8866-4b96-844a-d6c8b8919553	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	281c1507-7627-4b3f-8d97-6a13edd74645	3e5e232a-180a-e211-853a-5952e6affd31	8312c6fe-8866-4b96-844a-d6c8b8919553	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
29bd60be-d78c-47df-8246-d2d165cb63af	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	d1afe4ca-bfa3-43c0-85fd-5adc1f0ffe3c	29bd60be-d78c-47df-8246-d2d165cb63af	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
efc17b14-da9e-41ca-8032-b513fa0d0cc4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	793d825c-37e8-11e4-ba82-5b1598077215	efc17b14-da9e-41ca-8032-b513fa0d0cc4	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
b864f8ef-6bff-4071-93e0-95e70316e85f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	0fa22811-7c2b-4f31-a712-5b4993e62cb1	b864f8ef-6bff-4071-93e0-95e70316e85f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5b88d815-dfb4-4b03-ae25-a0421201935e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	28112615-3e2e-47ca-9b59-e79467179426	150b9cae-317e-4c1b-8aaa-46c43574014f	\N	2021-03-30 09:19:31	2021-10-26 09:36:52	2021-10-26 09:36:52	2021-05-19 12:39:11
821da089-12f0-4049-a9d0-d08cc8027297	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	6207cf97-0d01-4dd6-ad87-d4327e455902	a5f5008c-5122-4f2e-b29d-5b6085dfd753	\N	2021-03-30 09:19:31	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-05-19 12:39:11
6d505599-fb83-4fb2-ac98-ce989a504a7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	0312c3d7-fde1-47cf-96ce-1f87a4228787	d5a64e0f-8c8f-49d8-bc86-24184f952873	\N	2021-03-30 09:19:31	2021-05-19 12:39:11	\N	2021-05-19 12:39:11
6e7602cc-8819-454d-9b1e-14313d6c5641	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	0ea06995-f218-4530-9b63-0b499a11b034	909a1aa9-6eb5-4de6-8ea8-8ea6843d0d28	\N	2021-03-30 09:19:31	2021-05-19 12:39:11	\N	2021-05-19 12:39:11
1478f2cf-2010-4cbf-9f5a-47f74e65bde1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	074f93b5-b14c-43a4-9b32-ffa1f94d5238	1478f2cf-2010-4cbf-9f5a-47f74e65bde1	\N	2021-03-30 09:19:30	2022-12-01 10:22:49	\N	2021-05-19 12:39:11
0ab73ede-3bc5-424d-844b-41a07dd10434	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	0ab73ede-3bc5-424d-844b-41a07dd10434	\N	2021-03-30 09:19:31	2022-12-01 10:22:50	\N	2021-05-19 12:39:11
4768dbb6-83d4-4df4-ae63-ca7a568a9574	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	eb492e22-77fd-e111-8da8-f1648fe48442	4768dbb6-83d4-4df4-ae63-ca7a568a9574	\N	2021-03-30 09:19:30	2022-12-01 10:22:50	\N	2021-05-19 12:39:11
527580cb-ddc4-467d-88e6-3fc685a411a5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	d57f4561-8cb1-42ae-940e-7943cdae287b	527580cb-ddc4-467d-88e6-3fc685a411a5	\N	2021-03-30 09:19:30	2022-12-01 10:22:51	\N	2021-05-19 12:39:11
25c8a9eb-5e9b-4878-a436-e81891d002d5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	a1a4855a-4ba2-11e5-ad6a-7fe5906b4155	25c8a9eb-5e9b-4878-a436-e81891d002d5	\N	2021-03-30 09:19:33	2022-12-01 10:22:53	\N	2021-05-19 12:39:12
6966643e-d49d-435c-92ae-ad102e408088	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	079a34b8-4b76-11e5-814d-b3ab2368e254	6966643e-d49d-435c-92ae-ad102e408088	\N	2021-03-30 09:19:32	2022-12-01 10:22:53	\N	2021-05-19 12:39:12
33b2634b-bec8-4ba3-b6c4-f9b1dea3b76f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	ab6417da-ec15-496a-938b-3d116b961a9f	33b2634b-bec8-4ba3-b6c4-f9b1dea3b76f	\N	2021-03-30 09:19:33	2022-12-01 10:22:53	\N	2021-05-19 12:39:12
0037ca33-f6b3-45ab-a2d5-af5f4240621b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	9c53d522-5752-4556-82d0-660186bcecdc	0037ca33-f6b3-45ab-a2d5-af5f4240621b	\N	2021-03-30 09:19:32	2022-12-01 10:22:54	\N	2021-05-19 12:39:12
749224f7-5ebe-4ea2-bc05-0d5ce1d841c5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	4e3a22a4-98e9-4024-a519-7a05be9167c8	749224f7-5ebe-4ea2-bc05-0d5ce1d841c5	\N	2021-03-30 09:19:33	2022-12-01 10:22:56	\N	2021-05-19 12:39:12
9336c9a2-45cd-4b5d-9ff3-d75687f6583d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	667a149e-7929-e211-ab63-417b9cc965f1	9336c9a2-45cd-4b5d-9ff3-d75687f6583d	\N	2021-03-30 09:19:32	2022-12-01 10:22:57	\N	2021-05-19 12:39:12
be5aa85c-7c59-49fd-9bd9-76f75ad13113	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	ffa42521-4f5a-4d0a-8efd-f4dc24fe7f45	be5aa85c-7c59-49fd-9bd9-76f75ad13113	\N	2021-03-30 09:19:33	2022-12-01 10:22:58	\N	2021-05-19 12:39:12
2666d38a-c8d8-4c83-8b6c-195686e8fe1c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	29d04843-7d39-48d9-9720-ea6c03d77e52	2666d38a-c8d8-4c83-8b6c-195686e8fe1c	\N	2021-03-30 09:19:32	2022-12-01 10:22:59	\N	2021-05-19 12:39:12
9f67a8f8-bb7e-44f1-9f54-095f71aa5516	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	695dda2d-4408-e211-b6ed-d1aec8947609	9f67a8f8-bb7e-44f1-9f54-095f71aa5516	\N	2021-03-30 09:19:33	2022-12-01 10:22:59	\N	2021-05-19 12:39:12
bfacdd9e-8291-48f8-9487-8321ca753dae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	ba02677d-8acd-e211-b8a5-d12bb761bc4d	bfacdd9e-8291-48f8-9487-8321ca753dae	\N	2021-03-30 09:19:32	2022-12-01 10:22:59	\N	2021-05-19 12:39:12
4f6858bd-e0db-4495-878e-82e5c998275b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	2f627335-3b69-4db3-94e3-0a43968e23e9	4f6858bd-e0db-4495-878e-82e5c998275b	\N	2021-03-30 09:19:32	2022-12-01 10:23:00	\N	2021-05-19 12:39:12
f28d9a13-aa81-4e80-b484-e8d7012c522c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	e98a52c9-013b-4a3d-aeaa-a3738ed9ec63	f28d9a13-aa81-4e80-b484-e8d7012c522c	\N	2021-03-30 09:19:32	2022-12-01 10:23:00	\N	2021-05-19 12:39:12
f7418480-ba79-434e-823b-83eb2fcb375a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	dff2a0f4-5123-11e5-8831-73515c7ac634	f7418480-ba79-434e-823b-83eb2fcb375a	\N	2021-03-30 09:19:33	2022-12-01 10:23:00	\N	2021-05-19 12:39:12
77c6ceec-8781-4525-8753-e83589d8a014	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	77c6ceec-8781-4525-8753-e83589d8a014	\N	2021-03-30 09:19:33	2022-12-01 10:23:01	\N	2021-05-19 12:39:12
0cc7a3b2-2323-4e1b-bcd6-b82757c10209	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	2704f9d0-22fc-11e4-859d-e78b145c39c9	0cc7a3b2-2323-4e1b-bcd6-b82757c10209	\N	2021-03-30 09:19:32	2022-12-01 10:23:01	\N	2021-05-19 12:39:11
d3426298-f7b4-4e62-9078-c7b90067ebdb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	6402418c-54f9-11e5-9e54-5397b782050d	d3426298-f7b4-4e62-9078-c7b90067ebdb	\N	2021-03-30 09:19:32	2022-12-01 10:23:04	\N	2021-05-19 12:39:12
2359c802-f1f8-48f4-9c75-0a87d1dfb562	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	fa092490-4b74-11e5-a33d-db9868dda03f	2359c802-f1f8-48f4-9c75-0a87d1dfb562	\N	2021-03-30 09:19:33	2022-12-01 10:23:04	\N	2021-05-19 12:39:12
13cb8e65-4d9b-4774-81bf-e7da3df1316d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	5ae837e8-4a02-11e5-9a00-2bca72a8469e	13cb8e65-4d9b-4774-81bf-e7da3df1316d	\N	2021-03-30 09:19:33	2022-12-01 10:23:04	\N	2021-05-19 12:39:12
1cac9867-1b93-4258-b7f0-2bdd9f230a7d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	806e1e57-7ea2-42e5-8e95-bde4cfef4c28	1cac9867-1b93-4258-b7f0-2bdd9f230a7d	\N	2021-03-30 09:19:33	2022-12-01 10:23:05	\N	2021-05-19 12:39:12
c7c28839-f77c-4939-a4f1-ab3ae5ddf81d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	14fba9a1-6ca4-4937-84e7-2a845d02897a	c7c28839-f77c-4939-a4f1-ab3ae5ddf81d	\N	2021-03-30 09:19:33	2022-12-01 10:23:06	\N	2021-05-19 12:39:12
f4a53e03-68f0-4d18-95a0-161079097e49	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	f4a53e03-68f0-4d18-95a0-161079097e49	\N	2021-03-30 09:19:33	2022-12-01 10:23:06	\N	2021-05-19 12:39:12
39c08716-2eb6-4b56-851d-cef04fa8164f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	2b392bf0-d1ad-44be-b9b5-c20f8ff36746	39c08716-2eb6-4b56-851d-cef04fa8164f	\N	2021-03-30 09:19:33	2022-12-01 10:23:06	\N	2021-05-19 12:39:12
c3bda365-58cf-4496-80ba-b7b8b83ef16c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	e69398c4-8a47-4d33-aa9e-c992acd5ec31	c3bda365-58cf-4496-80ba-b7b8b83ef16c	\N	2021-03-30 09:19:32	2022-12-01 10:23:06	\N	2021-05-19 12:39:12
febc107a-2436-46f6-9472-f8e6635fd4f4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	27ef1dfc-6e95-4d0e-93f5-58f9702c39a5	febc107a-2436-46f6-9472-f8e6635fd4f4	\N	2021-03-30 09:19:32	2022-12-01 10:23:07	\N	2021-05-19 12:39:12
dbee4228-063e-4af2-9171-1ba0ac47f76b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	dbee4228-063e-4af2-9171-1ba0ac47f76b	\N	2021-03-30 09:19:33	2022-12-01 10:23:07	\N	2021-05-19 12:39:12
f6c26087-d846-48e6-b820-8a222af9e409	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	7363a404-46e9-11e5-8413-7fabf05ee1fd	f6c26087-d846-48e6-b820-8a222af9e409	\N	2021-03-30 09:19:33	2022-12-01 10:23:10	\N	2021-05-19 12:39:12
c745510d-1da5-4f48-9f19-f87492b221b0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	7a13c707-8f03-e211-8560-17962475f905	c745510d-1da5-4f48-9f19-f87492b221b0	\N	2021-03-30 09:19:33	2022-12-01 10:23:11	\N	2021-05-19 12:39:12
45d2ce78-e4f8-4c10-ad4c-3f4a4487b2b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	98488e79-c327-e211-963e-ffbc9c164446	45d2ce78-e4f8-4c10-ad4c-3f4a4487b2b7	\N	2021-03-30 09:19:33	2022-12-01 10:23:11	\N	2021-05-19 12:39:12
939966e4-d879-46cf-9e3c-9c974bfa4826	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	d28672c2-c5a5-4238-a802-fd30f1f8341d	939966e4-d879-46cf-9e3c-9c974bfa4826	\N	2021-03-30 09:19:33	2022-12-01 10:23:13	\N	2021-05-19 12:39:12
df31236c-bde5-4e94-96dd-e6ea78f70c22	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	994e91c4-854b-4fe0-946c-0133e4582398	df31236c-bde5-4e94-96dd-e6ea78f70c22	\N	2021-03-30 09:19:34	2022-12-01 10:23:18	\N	2021-05-19 12:39:12
67c80011-1231-4e0f-8b58-4f9e88ef4c91	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	679c6691-5977-4188-b9cb-15090b3fb85f	67c80011-1231-4e0f-8b58-4f9e88ef4c91	\N	2021-03-30 09:19:33	2022-12-01 10:23:19	\N	2021-05-19 12:39:12
f1636bf6-2304-46de-be36-b4844ea009c1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	18af6193-69a7-45a3-ba4d-d4e3b7df1bdc	f1636bf6-2304-46de-be36-b4844ea009c1	\N	2021-03-30 09:19:33	2022-12-01 10:23:21	\N	2021-05-19 12:39:12
19aa96c0-1405-4c23-871c-34497aa4f978	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	b5b764d4-4c3f-11e5-9257-b3688b89f32b	19aa96c0-1405-4c23-871c-34497aa4f978	\N	2021-03-30 09:19:32	2022-12-01 10:23:22	\N	2021-05-19 12:39:11
9b86315e-8e9f-4858-9527-ede2961ac4b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	0494c011-fd20-411c-b6f3-022d10cfb1b4	9b86315e-8e9f-4858-9527-ede2961ac4b9	\N	2021-03-30 09:19:32	2022-12-01 10:23:22	\N	2021-05-19 12:39:11
49459870-b794-499f-b45c-dfa22814ff35	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	7cbb1e3a-bd21-4b1c-977b-ba09be08a090	49459870-b794-499f-b45c-dfa22814ff35	\N	2021-03-30 09:19:33	2022-12-01 10:23:24	\N	2021-05-19 12:39:12
b6ae27a8-a9b2-4cba-b9aa-676deefe5773	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	021d11bc-3d8a-11e5-b1d1-733403640dea	b6ae27a8-a9b2-4cba-b9aa-676deefe5773	\N	2021-03-30 09:19:33	2022-12-01 10:23:26	\N	2021-05-19 12:39:12
7df84076-bf0a-4ad9-91e0-8537189ad930	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	1aaf7fc1-e927-e211-8700-79cd2fac9006	7df84076-bf0a-4ad9-91e0-8537189ad930	\N	2021-03-30 09:19:33	2022-12-01 10:23:26	\N	2021-05-19 12:39:12
2d5b09b3-839f-4630-9fd5-35689dfae6ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	5a86ab5d-2ad4-4c4d-9361-0c905df38639	2d5b09b3-839f-4630-9fd5-35689dfae6ba	\N	2021-03-30 09:19:33	2022-12-01 10:23:29	\N	2021-05-19 12:39:12
3b33edf5-da17-4e47-aff5-2a136d13aff5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	3b33edf5-da17-4e47-aff5-2a136d13aff5	\N	2021-03-30 09:19:33	2022-12-01 10:23:29	\N	2021-05-19 12:39:12
8981e975-ba5f-4e1a-a945-a83ce0f84668	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	1f87026c-1601-4eb9-9b82-64289bded8ed	8981e975-ba5f-4e1a-a945-a83ce0f84668	\N	2021-03-30 09:19:33	2022-12-01 10:23:30	\N	2021-05-19 12:39:12
eb39af4c-478c-4dcb-8d97-9c7df0f4f1f3	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	99908de8-c82f-11e3-afa8-5b932c69e723	eb39af4c-478c-4dcb-8d97-9c7df0f4f1f3	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
abedfcd1-faa9-485b-95d9-9151fecb446a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c1e7f994-e0c0-478d-aff3-6774262fe03f	decaa4c2-7a7e-450c-b535-5ba0f51e1935	abedfcd1-faa9-485b-95d9-9151fecb446a	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f6661a82-9375-4006-841a-f49503a06ec4	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	8b9d84ac-3b52-11e4-a025-5bd0dd0d84ea	f6661a82-9375-4006-841a-f49503a06ec4	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7291e4cd-64d5-43b6-9e99-9419fa19cd1c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	d9267e77-220c-4668-8911-845797905234	04ac577a-6b78-11e3-9b1d-5f5ff9abdb5c	7291e4cd-64d5-43b6-9e99-9419fa19cd1c	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
5aac7f00-778d-40f6-a33d-495b79e107a9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	9d639b9d-9624-44ed-89a4-582734c6512d	dae569ce-33de-11e4-ba21-5f9f30ff7de4	5aac7f00-778d-40f6-a33d-495b79e107a9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
89466683-377e-4741-a749-befff19d1348	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	69b4dea8-959e-4337-8a15-8e02cd0e4df7	6ecfd508-2a47-11e4-9293-5fe886fbea5f	89466683-377e-4741-a749-befff19d1348	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d1c75846-8fa3-49e5-b097-f7834969831f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	7c266540-37e5-11e4-b2f6-5ff114c758ed	d1c75846-8fa3-49e5-b097-f7834969831f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
ea3a6a60-795e-49a8-8457-1016e185950b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	777d9a08-2517-4adf-a008-70c0d006b0a5	cdba51ea-6d79-4ab3-991c-4e82de43a9c5	\N	2021-03-30 09:19:32	2021-10-26 09:36:52	2021-10-26 09:36:52	2021-05-19 12:39:12
01e5872e-36ff-4cb3-8ce0-d349514999a2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	dd2adab5-bbce-4c7d-8cbd-01a872b3d516	3983d08a-1bfb-4352-b4de-159c6ac36ca4	\N	2021-03-30 09:19:33	2021-10-26 09:36:52	2021-10-26 09:36:52	2021-05-19 12:39:12
bb135679-ac75-45fc-baf8-60e81843bc02	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	e9c2db63-6ef7-4099-bcfb-256a68e7481e	bb135679-ac75-45fc-baf8-60e81843bc02	\N	2021-03-30 09:19:34	2022-12-01 10:22:48	\N	2021-05-19 12:39:12
03d05be5-56eb-46f4-9408-6d87ed4737ab	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	2cbe7cbe-cd98-e211-96b7-81cc7dc9a550	03d05be5-56eb-46f4-9408-6d87ed4737ab	\N	2021-03-30 09:19:33	2022-12-01 10:22:49	\N	2021-05-19 12:39:12
c9b1a412-5919-4fe3-9eae-4b3271d43272	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	374d54fa-9d39-4cec-99c8-b405824d8696	c9b1a412-5919-4fe3-9eae-4b3271d43272	\N	2021-03-30 09:19:32	2022-12-01 10:22:52	\N	2021-05-19 12:39:12
e8243165-b97b-4d49-8fd9-e2edfd8830f2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	d6da0950-f65b-47d2-9965-579b90b08ffd	e8243165-b97b-4d49-8fd9-e2edfd8830f2	\N	2021-03-30 09:19:34	2022-12-01 10:22:53	\N	2021-05-19 12:39:13
7986b0d7-f34f-4889-947d-d6aabf22c025	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	afab5d0b-c4da-455e-bd0a-8644da49ab0f	7986b0d7-f34f-4889-947d-d6aabf22c025	\N	2021-03-30 09:19:35	2022-12-01 10:22:55	\N	2021-05-19 12:39:13
89e14352-9837-4149-8f7c-b5a816f8e725	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	199b8c08-4fd3-4f34-97ca-cc0546ac1d1d	89e14352-9837-4149-8f7c-b5a816f8e725	\N	2021-03-30 09:19:34	2022-12-01 10:22:58	\N	2021-05-19 12:39:12
4ae77377-8b5f-4cc7-8933-118212cdf3c2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	e9cef568-2ada-4e64-b69f-00c23c5d8604	4ae77377-8b5f-4cc7-8933-118212cdf3c2	\N	2021-03-30 09:19:34	2022-12-01 10:22:59	\N	2021-05-19 12:39:13
1ab5c8f5-a67c-4efb-a860-3121bd9c1029	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	bd3a2d69-e9b5-4462-9057-eb4b035b297d	1ab5c8f5-a67c-4efb-a860-3121bd9c1029	\N	2021-03-30 09:19:34	2022-12-01 10:23:00	\N	2021-05-19 12:39:12
6c556cec-65d3-49a2-a221-28a95fdbe01b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	daa07555-dd3d-44da-856b-28f08ecd474e	6c556cec-65d3-49a2-a221-28a95fdbe01b	\N	2021-03-30 09:19:34	2022-12-01 10:23:02	\N	2021-05-19 12:39:12
0d32b76e-b3e9-491e-b67c-ac5b68371c0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	a968b612-4bac-11e5-bce0-9f0e431a474f	0d32b76e-b3e9-491e-b67c-ac5b68371c0e	\N	2021-03-30 09:19:34	2022-12-01 10:23:04	\N	2021-05-19 12:39:12
e678d13f-bf26-49a5-aabb-1d669d682a30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	ea363a5f-9119-468b-8fea-9187ba92c13e	e678d13f-bf26-49a5-aabb-1d669d682a30	\N	2021-03-30 09:19:34	2022-12-01 10:23:04	\N	2021-05-19 12:39:13
8aa7edad-a7d2-40ef-850d-fdb1e0c2cf35	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	364c498c-4cb0-11e5-b9f9-e77bbfa6cbff	8aa7edad-a7d2-40ef-850d-fdb1e0c2cf35	\N	2021-03-30 09:19:34	2022-12-01 10:23:06	\N	2021-05-19 12:39:13
3cc69ddb-07a5-486b-a396-bfa31213fb82	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	ea745b98-c427-e211-963e-ffbc9c164446	3cc69ddb-07a5-486b-a396-bfa31213fb82	\N	2021-03-30 09:19:35	2022-12-01 10:23:07	\N	2021-05-19 12:39:13
335fe412-afb8-4e5d-b6af-a6a41e842111	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	48c6ee93-b17d-4225-a2ea-ea19c570e2c0	335fe412-afb8-4e5d-b6af-a6a41e842111	\N	2021-03-30 09:19:34	2022-12-01 10:23:07	\N	2021-05-19 12:39:13
b1a673ea-f835-4efd-afab-47f3ca5f1106	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	0c57cc9c-4c32-11e5-858c-afbc5904667e	b1a673ea-f835-4efd-afab-47f3ca5f1106	\N	2021-03-30 09:19:35	2022-12-01 10:23:08	\N	2021-05-19 12:39:13
3f5eafc8-2697-401f-b795-a3412d0c38f5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	7661d6a5-1907-41fd-8c82-a5fea385fef8	3f5eafc8-2697-401f-b795-a3412d0c38f5	\N	2021-03-30 09:19:34	2022-12-01 10:23:08	\N	2021-05-19 12:39:12
1e692d52-4abe-455a-a07a-fc82c06217d9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	f59b1bb2-1e58-4760-b504-5ee5de14aba7	1e692d52-4abe-455a-a07a-fc82c06217d9	\N	2021-03-30 09:19:34	2022-12-01 10:23:09	\N	2021-05-19 12:39:13
f1c90b9e-0b71-4e7d-9c1f-603967b621cc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	8e47faed-6b87-4baf-8d94-d778345455f3	f1c90b9e-0b71-4e7d-9c1f-603967b621cc	\N	2021-03-30 09:19:34	2022-12-01 10:23:09	\N	2021-05-19 12:39:12
ab2a7d94-12a8-40ee-818c-5dd03682c7c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	edf2c1a4-2d1f-471d-8e72-eb63959b5b64	ab2a7d94-12a8-40ee-818c-5dd03682c7c0	\N	2021-03-30 09:19:35	2022-12-01 10:23:10	\N	2021-05-19 12:39:13
56149761-9c17-4956-9557-a33d8bca828b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	11aea642-466b-11e5-886c-1b8856809555	56149761-9c17-4956-9557-a33d8bca828b	\N	2021-03-30 09:19:34	2022-12-01 10:23:10	\N	2021-05-19 12:39:13
b50e46c2-713e-4021-8709-a5bc67cff79c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	900ffa20-46cc-11e5-8abe-0337176d8d23	b50e46c2-713e-4021-8709-a5bc67cff79c	\N	2021-03-30 09:19:34	2022-12-01 10:23:11	\N	2021-05-19 12:39:13
c6d37a27-fc0a-4a12-990f-a8612f2a71d4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	8cf66883-ebc1-473e-a01c-37925b2b2150	c6d37a27-fc0a-4a12-990f-a8612f2a71d4	\N	2021-03-30 09:19:34	2022-12-01 10:23:11	\N	2021-05-19 12:39:13
3ebad66f-fee9-4a7e-92d0-1b52ecff90b4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	645aba46-378c-11e4-a83f-afbd60abf5c3	3ebad66f-fee9-4a7e-92d0-1b52ecff90b4	\N	2021-03-30 09:19:34	2022-12-01 10:23:11	\N	2021-05-19 12:39:12
c46e764d-147e-45ad-ae5c-d50caf75b7f3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	540161f2-51dc-11e5-ada1-57cb00fd65d6	c46e764d-147e-45ad-ae5c-d50caf75b7f3	\N	2021-03-30 09:19:34	2022-12-01 10:23:12	\N	2021-05-19 12:39:13
299e5113-dabe-4ba1-ad97-d6e6cda6d873	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	14f34d04-bb92-4cf1-bb11-5e424fa98ae7	299e5113-dabe-4ba1-ad97-d6e6cda6d873	\N	2021-03-30 09:19:34	2022-12-01 10:23:12	\N	2021-05-19 12:39:13
1c08ac8b-9dfa-471f-bd8f-9f57b52d6112	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	6b031760-aef5-4dbb-b520-01e6685a54d1	1c08ac8b-9dfa-471f-bd8f-9f57b52d6112	\N	2021-03-30 09:19:34	2022-12-01 10:23:15	\N	2021-05-19 12:39:13
3a0bd44a-e701-4433-8a67-c4a73869e068	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	56fbd12f-009d-4448-b9ce-76e42ea92a41	3a0bd44a-e701-4433-8a67-c4a73869e068	\N	2021-03-30 09:19:35	2022-12-01 10:23:15	\N	2021-05-19 12:39:13
59223f41-1b47-42f9-bf8e-77cb026a1dfa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	efadf950-9060-45d1-a065-ddd9c87cd53f	59223f41-1b47-42f9-bf8e-77cb026a1dfa	\N	2021-03-30 09:19:35	2022-12-01 10:23:15	\N	2021-05-19 12:39:13
81b2c090-376c-4171-9060-f22bbc1451d0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	4dbcf03d-8516-4f9c-a25f-679ac14e766f	81b2c090-376c-4171-9060-f22bbc1451d0	\N	2021-03-30 09:19:34	2022-12-01 10:23:16	\N	2021-05-19 12:39:12
7cd0be52-bcbc-494c-9a38-54d2678c6512	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	162955a4-43dc-4ee3-85f2-b4b602c72400	7cd0be52-bcbc-494c-9a38-54d2678c6512	\N	2021-03-30 09:19:35	2022-12-01 10:23:16	\N	2021-05-19 12:39:13
eec941c4-21aa-495a-a0ee-23add8587bd0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	d1de7680-727c-4931-a9c8-1cc3a384a7c5	eec941c4-21aa-495a-a0ee-23add8587bd0	\N	2021-03-30 09:19:34	2022-12-01 10:23:17	\N	2021-05-19 12:39:12
890f7574-f25f-498f-8a0e-33d28499cefe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	2fb6ecc8-5518-4db0-9f94-64e9131b2b96	890f7574-f25f-498f-8a0e-33d28499cefe	\N	2021-03-30 09:19:34	2022-12-01 10:23:17	\N	2021-05-19 12:39:12
2b6a25ce-0970-49f4-b170-34b6dd1c45c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	0ed24a94-592d-11e5-8142-4f45aea730e6	2b6a25ce-0970-49f4-b170-34b6dd1c45c0	\N	2021-03-30 09:19:35	2022-12-01 10:23:19	\N	2021-05-19 12:39:13
1174586a-9511-4235-a501-df7bf4c5530d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	607b1b72-46d2-11e5-ba50-1375139e8458	1174586a-9511-4235-a501-df7bf4c5530d	\N	2021-03-30 09:19:34	2022-12-01 10:23:21	\N	2021-05-19 12:39:13
7cf3abf4-6c06-45f9-814d-68c86a593d2c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	9433b08e-fac0-4a20-9d42-684e7aced3c6	7cf3abf4-6c06-45f9-814d-68c86a593d2c	\N	2021-03-30 09:19:34	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
d633cd39-d975-4064-a253-95632e90c8ba	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	5fb28ec2-45dd-45c4-8021-0e597172c690	d633cd39-d975-4064-a253-95632e90c8ba	\N	2021-03-30 09:19:34	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
b3574592-0205-4f7b-b696-3c210f0e7ef6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	b3574592-0205-4f7b-b696-3c210f0e7ef6	\N	2021-03-30 09:19:34	2022-12-01 10:23:25	\N	2021-05-19 12:39:12
2ff612ac-a995-49bd-8e8c-85880ec5458b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	52d5486a-4544-11e5-b3ea-131ef06916b5	2ff612ac-a995-49bd-8e8c-85880ec5458b	\N	2021-03-30 09:19:34	2022-12-01 10:23:25	\N	2021-05-19 12:39:13
224b61d3-6f8a-4fa3-bf0c-20f650316505	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	8c54af21-d3fa-4eba-b89f-b628ab9fa013	224b61d3-6f8a-4fa3-bf0c-20f650316505	\N	2021-03-30 09:19:34	2022-12-01 10:23:26	\N	2021-05-19 12:39:13
1f8c5ddf-d4d2-42eb-b54c-b8bc1bf59d3f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	36f9b0ec-4b73-11e5-95e2-d791112ee5fe	1f8c5ddf-d4d2-42eb-b54c-b8bc1bf59d3f	\N	2021-03-30 09:19:34	2022-12-01 10:23:26	\N	2021-05-19 12:39:12
df1f9941-522c-4fa1-be23-d2b140959ba6	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	6100b23c-bf3e-44b6-880f-6197ef1f0be2	df1f9941-522c-4fa1-be23-d2b140959ba6	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
fa53d445-b730-4f0a-8e3d-adcacd5a88e8	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	3749dbbc-4cad-49bc-882d-6301b4520e6a	fa53d445-b730-4f0a-8e3d-adcacd5a88e8	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
3a661b71-f821-4e2c-9515-9f30ec1262f1	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	1e9608b0-617e-11e3-a7ba-63349d0a8e13	3a661b71-f821-4e2c-9515-9f30ec1262f1	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
82b902cd-7e22-440e-89db-10818fb8045f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	4c7b9e56-f480-11e5-bd9f-633f114b2ce8	82b902cd-7e22-440e-89db-10818fb8045f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
672a1a12-985d-47f0-827a-84b930bfe216	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	b3ae26fa-2206-e211-ba18-6340b791e37e	672a1a12-985d-47f0-827a-84b930bfe216	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
71e4f1f3-c09d-48fd-b356-5a05702c7c28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	9cebf2d1-99f6-4b81-a7e7-d3fd26767c59	245a888e-7212-4eea-a26d-bbacf301876f	\N	2021-03-30 09:19:34	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-05-19 12:39:12
a417721b-7324-4530-9f00-32ca9c5e3044	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	6a5acada-8f36-4e1c-abc4-73bb22b53cdd	128d1ad6-6d13-4013-874e-f0f9b5dcbbda	\N	2021-03-30 09:19:35	2022-04-05 06:43:18	2022-04-05 06:43:18	2021-05-19 12:39:13
739af006-5fd4-4815-8245-f51033b3eb77	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	73c986dd-4bfe-4a05-844b-00d385e21864	739af006-5fd4-4815-8245-f51033b3eb77	\N	2021-03-30 09:19:35	2022-12-01 10:22:48	\N	2021-05-19 12:39:13
e9319161-7940-4291-b239-a4dd13dc8e56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	a091930a-1616-468a-861e-0a2e079f2b58	e9319161-7940-4291-b239-a4dd13dc8e56	\N	2021-03-30 09:19:34	2022-12-01 10:22:49	\N	2021-05-19 12:39:13
10eae6d9-0340-4161-8ff9-3ff2561bfbc6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	88c6acc3-882c-418e-b96e-f83ccccd7f79	10eae6d9-0340-4161-8ff9-3ff2561bfbc6	\N	2021-03-30 09:19:34	2022-12-01 10:22:49	\N	2021-05-19 12:39:12
39819b97-484d-4fd8-af12-e409a02d14d6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	39819b97-484d-4fd8-af12-e409a02d14d6	\N	2021-03-30 09:19:34	2022-12-01 10:22:49	\N	2021-05-19 12:39:13
718ac70c-2fe9-416b-ab3e-7805c7b9d62a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	91317e32-9ec9-468c-bf5b-ef891856d180	718ac70c-2fe9-416b-ab3e-7805c7b9d62a	\N	2021-03-30 09:19:35	2022-12-01 10:22:51	\N	2021-05-19 12:39:13
4e1ab961-37f8-438f-98a3-4276c76eddb4	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	bd4085a1-82ec-450b-9507-7924581dc0fc	4e1ab961-37f8-438f-98a3-4276c76eddb4	\N	2021-03-30 09:19:34	2022-12-01 10:22:51	\N	2021-05-19 12:39:12
2d09c16f-4290-46ce-940c-72523ea81414	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	04a45a78-7f1b-4cad-a70f-732efa5f7985	2d09c16f-4290-46ce-940c-72523ea81414	\N	2021-03-30 09:19:35	2022-12-01 10:22:52	\N	2021-05-19 12:39:13
00108ba7-3d35-470f-9a21-79241a47eb86	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	46b37dc1-e927-e211-86f9-79cd2fac9006	00108ba7-3d35-470f-9a21-79241a47eb86	\N	2021-03-30 09:19:34	2022-12-01 10:22:52	\N	2021-05-19 12:39:13
52c798fd-85f1-4eb6-854e-505dd297b86e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	5132bbaa-b74f-4719-86b7-5cfe82b86531	52c798fd-85f1-4eb6-854e-505dd297b86e	\N	2021-03-30 09:19:35	2022-12-01 10:22:53	\N	2021-05-19 12:39:13
c2c1ad90-05eb-4fcc-bb93-74e02fa73d6f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	2b355164-17de-4001-ae8e-bd479a301b50	c2c1ad90-05eb-4fcc-bb93-74e02fa73d6f	\N	2021-03-30 09:19:35	2022-12-01 10:22:57	\N	2021-05-19 12:39:13
60074c0d-2cab-42e3-8306-ccb1efff2be3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	2be8003c-4baa-11e5-89bc-6bbd87a41e7a	60074c0d-2cab-42e3-8306-ccb1efff2be3	\N	2021-03-30 09:19:36	2022-12-01 10:22:57	\N	2021-05-19 12:39:14
9e1fb770-bbc3-44e8-a7f6-3817d352fdd7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	9833a660-4b73-11e5-934e-37a2f6ed830d	9e1fb770-bbc3-44e8-a7f6-3817d352fdd7	\N	2021-03-30 09:19:36	2022-12-01 10:22:58	\N	2021-05-19 12:39:14
6b0552e3-f7b8-44a7-a805-1bb460cf11db	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	edbf1ed9-b137-4d28-8af1-a22ab23be53b	6b0552e3-f7b8-44a7-a805-1bb460cf11db	\N	2021-03-30 09:19:35	2022-12-01 10:23:04	\N	2021-05-19 12:39:13
0f9b1210-7845-4773-8c33-f849e5a53a27	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	7305bad9-38e6-43d8-8eac-e7b8d6b9d17f	0f9b1210-7845-4773-8c33-f849e5a53a27	\N	2021-03-30 09:19:36	2022-12-01 10:23:05	\N	2021-05-19 12:39:13
059e4eee-f596-4c7c-84ab-6261e32d0fdc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	c60e92a2-99c2-4394-a48b-251540c8b96f	059e4eee-f596-4c7c-84ab-6261e32d0fdc	\N	2021-03-30 09:19:36	2022-12-01 10:23:07	\N	2021-05-19 12:39:14
b339b760-2355-40c6-aa44-86c7138fd7f7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	8e10391f-07fe-41b9-84c7-106974b83db3	b339b760-2355-40c6-aa44-86c7138fd7f7	\N	2021-03-30 09:19:36	2022-12-01 10:23:07	\N	2021-05-19 12:39:13
15fb13cf-a8e8-4960-9bd8-4cff6819db1b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	f4dc7769-10f3-474c-9bad-a7f651d71321	15fb13cf-a8e8-4960-9bd8-4cff6819db1b	\N	2021-03-30 09:19:36	2022-12-01 10:23:09	\N	2021-05-19 12:39:14
5a55ad68-98f1-4a95-a2b6-b1256dd0ac3a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	06b71793-3a86-4c6b-9000-717dca267295	5a55ad68-98f1-4a95-a2b6-b1256dd0ac3a	\N	2021-03-30 09:19:36	2022-12-01 10:23:10	\N	2021-05-19 12:39:14
843e5fa3-1169-482b-abff-d28685921b79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	542df659-4377-411d-9fa8-1f5ce8878479	843e5fa3-1169-482b-abff-d28685921b79	\N	2021-03-30 09:19:36	2022-12-01 10:23:10	\N	2021-05-19 12:39:14
f14d6e87-7db5-46d6-a7e9-70553e581a0d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	472d73e3-2d2f-488f-8e2f-cd3d22418632	f14d6e87-7db5-46d6-a7e9-70553e581a0d	\N	2021-03-30 09:19:35	2022-12-01 10:23:11	\N	2021-05-19 12:39:13
f7346133-1490-48d4-a3b0-4fc6264a3b7b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	d861e66d-279b-41ba-9f4b-f32031a86a79	f7346133-1490-48d4-a3b0-4fc6264a3b7b	\N	2021-03-30 09:19:35	2022-12-01 10:23:12	\N	2021-05-19 12:39:13
3d30f153-b134-4a8f-b9b5-70730518ee47	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	bed2e326-06e7-4698-94d5-d46efc825014	3d30f153-b134-4a8f-b9b5-70730518ee47	\N	2021-03-30 09:19:36	2022-12-01 10:23:12	\N	2021-05-19 12:39:14
82543d07-061c-4c34-bf87-2dad0b6d6ca3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	a80be64e-5393-49df-a6f7-8a18736444a1	82543d07-061c-4c34-bf87-2dad0b6d6ca3	\N	2021-03-30 09:19:32	2022-12-01 10:23:13	\N	2021-05-19 12:39:12
435ef1b6-b895-4412-b6b6-db6a2e9a57fc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	243b6119-e39f-4849-8fd0-218155575c5a	435ef1b6-b895-4412-b6b6-db6a2e9a57fc	\N	2021-03-30 09:19:36	2022-12-01 10:23:13	\N	2021-05-19 12:39:13
3f2284eb-56b5-4a3e-bc9a-e1f6f0538c21	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	3ee043f8-9893-11e5-911a-5f12b6406080	3f2284eb-56b5-4a3e-bc9a-e1f6f0538c21	\N	2021-03-30 09:19:35	2022-12-01 10:23:14	\N	2021-05-19 12:39:13
5e5aef70-d9b7-447c-bcfd-2c8f3613f121	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	d993ad11-d98a-4803-85a4-a446d7b9d4c7	5e5aef70-d9b7-447c-bcfd-2c8f3613f121	\N	2021-03-30 09:19:36	2022-12-01 10:23:15	\N	2021-05-19 12:39:14
bc368b58-1c69-45ae-aa7b-086dc1c43268	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	db62bae3-fc18-4ba5-9043-508670433fd6	17e8de1b-c527-e211-963e-ffbc9c164446	bc368b58-1c69-45ae-aa7b-086dc1c43268	\N	2021-03-30 09:19:35	2022-12-01 10:23:16	\N	2021-05-19 12:39:13
0d8e3d3c-229b-4706-88d6-815ab78d7853	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	cae987c8-810a-4d95-a5fb-27e3108961de	0d8e3d3c-229b-4706-88d6-815ab78d7853	\N	2021-03-30 09:19:36	2022-12-01 10:23:16	\N	2021-05-19 12:39:14
0c831264-32d5-4f84-b602-19a39e1265ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	a83c363b-c56d-49b3-9d37-61d51488daab	0c831264-32d5-4f84-b602-19a39e1265ef	\N	2021-03-30 09:19:36	2022-12-01 10:23:19	\N	2021-05-19 12:39:13
a2cce435-af12-45fd-b22b-7f0ce615dcea	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	1438adc2-38fc-11e4-b641-3f0b3de385b4	a2cce435-af12-45fd-b22b-7f0ce615dcea	\N	2021-03-30 09:19:35	2022-12-01 10:23:21	\N	2021-05-19 12:39:13
d01fc15b-ed98-43da-b5df-62ac62e97721	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	b7b48546-4541-11e5-b9f9-e7e850efd101	d01fc15b-ed98-43da-b5df-62ac62e97721	\N	2021-03-30 09:19:35	2022-12-01 10:23:22	\N	2021-05-19 12:39:13
cfb80aac-509d-4af9-8ff5-5a4878ddf3e6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	78027dc1-f7e5-434a-b0c3-767f331840bb	cfb80aac-509d-4af9-8ff5-5a4878ddf3e6	\N	2021-03-30 09:19:35	2022-12-01 10:23:22	\N	2021-05-19 12:39:13
97436b81-0d1e-43be-a71e-b79a66356bee	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	2e534eee-4290-11e5-9525-d72625153a3d	97436b81-0d1e-43be-a71e-b79a66356bee	\N	2021-03-30 09:19:35	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
9e4c84ed-c944-4227-8c82-836bd1acceb6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	93853854-479a-11e5-8f29-97b6ab3d09e1	9e4c84ed-c944-4227-8c82-836bd1acceb6	\N	2021-03-30 09:19:35	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
cb60303e-a1f7-4015-b48a-34abfaa5d37b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	9397e666-ef98-e211-9c3d-bd33617080df	cb60303e-a1f7-4015-b48a-34abfaa5d37b	\N	2021-03-30 09:19:36	2022-12-01 10:23:24	\N	2021-05-19 12:39:14
331d81e3-075b-4fcf-8bcb-6b8d1b6954af	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	bf147454-3d40-11e4-bd52-dfaac3a0de5c	331d81e3-075b-4fcf-8bcb-6b8d1b6954af	\N	2021-03-30 09:19:35	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
3d26991e-4743-4767-8d99-3e69182da319	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	d85e860f-35a9-4406-8bc6-0e4051153600	3d26991e-4743-4767-8d99-3e69182da319	\N	2021-03-30 09:19:36	2022-12-01 10:23:24	\N	2021-05-19 12:39:13
6d8faf67-c189-49d5-ad71-8d70aed4a092	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	1d2b0b00-23c4-4c1b-a956-a85ff7deb40b	6d8faf67-c189-49d5-ad71-8d70aed4a092	\N	2021-03-30 09:19:36	2022-12-01 10:23:25	\N	2021-05-19 12:39:13
407983f3-9466-45bd-a1f7-b381eb52f235	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	b7636c46-2593-4792-968d-5432f3f28fa7	407983f3-9466-45bd-a1f7-b381eb52f235	\N	2021-03-30 09:19:35	2022-12-01 10:23:25	\N	2021-05-19 12:39:13
dd66f04f-b9c1-4cf4-ae24-b641755df376	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	2819b86b-4d06-499d-a0c9-af1a3e711ecf	dd66f04f-b9c1-4cf4-ae24-b641755df376	\N	2021-03-30 09:19:35	2022-12-01 10:23:26	\N	2021-05-19 12:39:13
8d13d8bf-35a1-4d76-8d76-f26b7c0f19b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	6fd21df7-6c4e-47cc-a56c-bbab8c48e04e	4f8e0696-ebb4-406b-a15d-10ddcaa85487	8d13d8bf-35a1-4d76-8d76-f26b7c0f19b7	\N	2021-03-30 09:19:30	2022-12-01 10:23:29	\N	2021-05-19 12:39:11
ac24a19b-b4e8-46a4-b2e2-5d74b77d2a94	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b8c5fde5-2441-46ab-ba4b-30ba84e090c4	5e27af4e-b6be-4489-8c7f-1b35d6d06056	ac24a19b-b4e8-46a4-b2e2-5d74b77d2a94	\N	2021-03-30 09:19:36	2022-12-01 10:23:30	\N	2021-05-19 12:39:14
868a6a4c-37a2-4665-9368-0dcf4bf372b9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	c6a140f3-c600-e211-a28f-635c273d5ab3	868a6a4c-37a2-4665-9368-0dcf4bf372b9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
962695f6-55eb-4f8e-9599-aeb48489b626	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	56f13ef3-8065-4241-9aaa-7bc90b1eb3f0	e8c840f3-c600-e211-a293-635c273d5ab3	962695f6-55eb-4f8e-9599-aeb48489b626	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
dbf3b68e-b53d-42b2-8aac-9c20bd59a5be	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	868b0a2a-2e32-11e4-b751-63ad7c3f421e	dbf3b68e-b53d-42b2-8aac-9c20bd59a5be	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
3aa0d1ff-3267-4b2f-92b7-9cc46485af42	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	64fbb29b-e69a-e211-9d3b-652f37c93c28	3aa0d1ff-3267-4b2f-92b7-9cc46485af42	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
dc77a629-452c-4320-8f2d-731d95733b3e	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	fdbd342c-627d-40af-9826-66748e5cfcad	dc77a629-452c-4320-8f2d-731d95733b3e	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
c44713f5-da89-4ec9-bfb1-07ea32541b9d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	e3fda682-524a-11e3-9eaa-670177637338	c44713f5-da89-4ec9-bfb1-07ea32541b9d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
4bbdfda8-806b-48b7-9c20-cbad1fbde401	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	83c2ce44-23c5-11e4-b44a-6734c1903430	4bbdfda8-806b-48b7-9c20-cbad1fbde401	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
ebdf1750-7bf4-424c-9c6c-bbcf81c2eefd	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	518121b5-93fd-46cd-8e57-b3bf6100147f	6e734f22-54ab-11d8-91ff-6762d78e05d6	ebdf1750-7bf4-424c-9c6c-bbcf81c2eefd	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
f308588d-5d59-4923-84e0-36eb88f1e090	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	5d16430e-fc2c-4850-bbd6-dda5bfdae36f	0849119d-214c-4224-97a5-233265292fe8	\N	2021-03-30 09:19:35	2022-04-05 06:43:18	2022-04-05 06:43:18	2021-05-19 12:39:13
12a4c358-1a25-4eeb-84c8-1afc5959e347	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	32012988-6e51-4117-bb8f-0886146e3b81	625f5a62-03e6-4066-8186-2fd7a0189797	ab2391f8-5c0e-4cb7-b4fc-21035dacb759	\N	2021-03-30 09:19:36	2022-04-05 06:43:18	2022-04-05 06:43:18	2021-05-19 12:39:14
9b389ad8-8815-4a09-8848-f4fa0c84af62	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	b7d6d3f4-77ae-41df-8c21-56e8731513a1	1fa6a2de-9677-4984-a284-880c1c31f608	\N	2021-03-30 09:19:36	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-05-19 12:39:14
773d02f2-d8a4-4005-8702-12142c26bf71	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	39d012b6-b00a-4aaa-b389-0e15e420ad3a	a27f5049-9e4f-45c6-a037-f3ba70c1b06c	\N	2021-03-30 09:19:36	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-05-19 12:39:13
9d76282a-14e9-4231-b8e7-004fd5a594ca	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	0bb618a3-7521-4328-b36b-fe6ce0ce7752	ad705d8a-429e-11e5-a989-af44a02d940a	9d76282a-14e9-4231-b8e7-004fd5a594ca	\N	2021-03-30 09:19:35	2022-12-01 10:22:50	\N	2021-05-19 12:39:13
6770e2ae-766b-48a7-aa28-0da9b0f42757	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	7b6763fc-6f9f-11e3-b017-03efaa0c94af	6770e2ae-766b-48a7-aa28-0da9b0f42757	\N	2021-03-30 09:19:35	2022-12-01 10:22:51	\N	2021-05-19 12:39:13
e15462d6-93ff-4731-a15a-4c578e34430b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	f80b678d-bb43-4915-9ef0-22b1d2320638	e15462d6-93ff-4731-a15a-4c578e34430b	\N	2021-03-30 09:19:36	2022-12-01 10:22:51	\N	2021-05-19 12:39:13
9d8a10b0-5eee-46c9-bb32-cc7f4aaa142d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b95d9b8b-9aee-4c6b-822d-3dd8857d9f49	1e02ae8a-1e69-4e9c-a8c2-084b208eb8fb	9d8a10b0-5eee-46c9-bb32-cc7f4aaa142d	\N	2021-03-30 09:19:35	2022-12-01 10:22:51	\N	2021-05-19 12:39:13
af12a8b6-4a15-44dd-8d8f-180d29136e6c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	4ce44b92-99e3-42c0-96c5-1490f5622aae	e131badd-15c9-4911-8c81-1d30249b7d73	af12a8b6-4a15-44dd-8d8f-180d29136e6c	\N	2021-03-30 09:19:36	2022-12-01 10:22:51	\N	2021-05-19 12:39:13
f94e6e1c-956f-4f14-9a48-78ebb0976ae2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	f94e6e1c-956f-4f14-9a48-78ebb0976ae2	\N	2021-03-30 09:19:29	2022-12-01 10:22:52	\N	2021-05-19 12:39:10
f4000f99-92b5-4eb3-8503-9ac8049ed6bb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	304a3c38-bda8-4b1f-b2ef-087817e35993	f4000f99-92b5-4eb3-8503-9ac8049ed6bb	\N	2021-10-26 09:36:45	2022-12-01 10:22:52	\N	2021-12-15 08:21:55
ad92ece4-82cf-4001-bd17-271cabc9f18c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	ca99dedb-11fb-e111-88dd-91f29105d9d3	ad92ece4-82cf-4001-bd17-271cabc9f18c	\N	2021-10-26 09:36:45	2022-12-01 10:22:53	\N	2021-12-15 08:21:54
22ba2ec6-d099-463a-bcb2-eafb1358821e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	9f3821bf-4b7f-4227-bcb8-e099c34ee92c	22ba2ec6-d099-463a-bcb2-eafb1358821e	\N	2021-10-26 09:36:45	2022-12-01 10:22:54	\N	2021-12-15 08:21:54
051c1cf9-cfc1-4f6c-9671-220c65ad35ec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	26925a68-aab1-11e5-bde5-bb0a0689b68c	051c1cf9-cfc1-4f6c-9671-220c65ad35ec	\N	2021-03-30 09:19:34	2022-12-01 10:22:54	\N	2021-05-19 12:39:12
e19c89ea-fc0b-4f35-b784-407bf8770d05	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	2818cea6-60f4-11e4-b17d-bb07c1f9979f	e19c89ea-fc0b-4f35-b784-407bf8770d05	\N	2021-10-26 09:36:46	2022-12-01 10:22:57	\N	2021-12-15 08:21:55
6d9f3dfb-4b82-467a-9f4d-dbf0722059b8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	d06848d7-c129-e211-82ed-4bf89d6bb6ec	6d9f3dfb-4b82-467a-9f4d-dbf0722059b8	\N	2021-10-26 09:36:45	2022-12-01 10:22:59	\N	2021-12-15 08:21:53
8b582220-5f03-4266-8e0b-69ab9989e0c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	ebf7f6a9-dd0c-4993-8dd7-dbd7ca546c07	8b582220-5f03-4266-8e0b-69ab9989e0c0	\N	2021-10-26 09:36:45	2022-12-01 10:23:00	\N	2021-12-15 08:21:53
b62ea9ea-e416-4938-af8f-0dffff950731	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	22160fc9-321a-40b5-849f-f8db354b9185	b62ea9ea-e416-4938-af8f-0dffff950731	\N	2021-10-26 09:36:45	2022-12-01 10:23:00	\N	2021-12-15 08:21:54
cdfbb5dc-f01d-4f60-9cb5-bee0130d1528	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	c6d43526-455f-4bdd-b177-803c70cd489a	b3e5989c-42e9-11e5-8808-b3cd19f2d1f7	cdfbb5dc-f01d-4f60-9cb5-bee0130d1528	\N	2021-03-30 09:19:35	2022-12-01 10:23:01	\N	2021-05-19 12:39:13
ad034929-885d-4edb-98b9-133aaf0aedcc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	0ea06995-f218-4530-9b63-0b499a11b034	ad034929-885d-4edb-98b9-133aaf0aedcc	\N	2021-10-26 09:36:45	2022-12-01 10:23:01	\N	2021-12-15 08:21:53
2d307ba0-a14e-47d0-aa6b-cf97035c0e4b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	cc5df9fa-60ae-11e4-a528-2326bffd6759	2d307ba0-a14e-47d0-aa6b-cf97035c0e4b	\N	2021-10-26 09:36:45	2022-12-01 10:23:01	\N	2021-12-15 08:21:53
cd793bf6-2d85-4fd7-afc9-af3edcbca25d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	d081c069-65b7-4bf5-866a-423def103d81	cd793bf6-2d85-4fd7-afc9-af3edcbca25d	\N	2021-10-26 09:36:45	2022-12-01 10:23:04	\N	2021-12-15 08:21:53
b957d4a1-0334-4339-bb6a-b6246615f8bc	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	eb492e22-77fd-e111-8da8-f1648fe48442	b957d4a1-0334-4339-bb6a-b6246615f8bc	\N	2021-10-26 09:36:45	2022-12-01 10:23:05	\N	2021-12-15 08:21:54
ab8176f8-fe64-404b-a100-80d0e5eb93c0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	6e12f9fd-e106-472d-8364-ce7da552e702	ab8176f8-fe64-404b-a100-80d0e5eb93c0	\N	2021-10-26 09:36:45	2022-12-01 10:23:05	\N	2021-12-15 08:21:55
c7f1a82d-97bb-41b4-89e2-e038a6b4d05e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	abb4b529-3a86-4003-9319-167b20113312	a16778e6-fe58-40af-a29b-6c47664d4064	c7f1a82d-97bb-41b4-89e2-e038a6b4d05e	\N	2021-03-30 09:19:35	2022-12-01 10:23:07	\N	2021-05-19 12:39:13
6fd8c2f3-f2c9-498b-aa72-616cba6bf895	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	906376c2-1463-4361-897e-a7ef5a19239d	6fd8c2f3-f2c9-498b-aa72-616cba6bf895	\N	2021-10-26 09:36:45	2022-12-01 10:23:08	\N	2021-12-15 08:21:53
62f7be27-4fe8-48be-8329-53008a068dae	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	d57f4561-8cb1-42ae-940e-7943cdae287b	62f7be27-4fe8-48be-8329-53008a068dae	\N	2021-10-26 09:36:45	2022-12-01 10:23:10	\N	2021-12-15 08:21:55
fd8db7e4-7110-49d4-b311-70e0d7f72e7f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	5e9f903f-a22b-43f7-b220-b2ef84ce5f82	fd8db7e4-7110-49d4-b311-70e0d7f72e7f	\N	2021-10-26 09:36:45	2022-12-01 10:23:11	\N	2021-12-15 08:21:54
3185dd53-bcd1-402b-bb89-c976565327c7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	27304008-f2e2-4b4b-b502-f08b37f89175	09246708-1717-e211-9018-65b25eca14b5	3185dd53-bcd1-402b-bb89-c976565327c7	\N	2021-10-26 09:36:45	2022-12-01 10:23:11	\N	2021-12-15 08:21:54
5b5cbcba-35c6-49ad-9bd3-83aa876018fa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	12ce8e21-0d8f-e211-8adf-a5d1cdfc52ac	5b5cbcba-35c6-49ad-9bd3-83aa876018fa	\N	2021-10-26 09:36:45	2022-12-01 10:23:12	\N	2021-12-15 08:21:55
acb43d20-c1d9-4a95-8499-deb83833208c	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	1e7148ea-524c-11e3-a294-67f5c370e4c6	acb43d20-c1d9-4a95-8499-deb83833208c	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
76bc4800-5696-453a-8d1f-abbc0904221d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	ea27d0c4-1ae2-44d7-bdf7-14fe24008d9c	76bc4800-5696-453a-8d1f-abbc0904221d	\N	2021-10-26 09:36:45	2022-12-01 10:23:12	\N	2021-12-15 08:21:54
40ccb5b2-b62c-459d-a7d3-9f8d0fdbbe48	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	7b907bc1-e927-e211-86f7-79cd2fac9006	40ccb5b2-b62c-459d-a7d3-9f8d0fdbbe48	\N	2021-10-26 09:36:45	2022-12-01 10:23:12	\N	2021-12-15 08:21:54
2c9f9200-d035-479d-acab-8023222b3224	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	93a0916b-c127-4476-b0f8-55aa7f4c3e80	2c9f9200-d035-479d-acab-8023222b3224	\N	2021-10-26 09:36:45	2022-12-01 10:23:13	\N	2021-12-15 08:21:54
dd28ec66-2a03-42b8-ab04-90ca40ecc2fe	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	d5b3a578-1613-474e-865b-0a47f3a64167	dd28ec66-2a03-42b8-ab04-90ca40ecc2fe	\N	2021-10-26 09:36:45	2022-12-01 10:23:13	\N	2021-12-15 08:21:55
1a8ede31-eecd-4504-ac4f-796c996ec29a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	de9dec8d-4f93-e211-994f-07e46219013e	1a8ede31-eecd-4504-ac4f-796c996ec29a	\N	2021-10-26 09:36:45	2022-12-01 10:23:13	\N	2021-12-15 08:21:55
8f614e9c-5fb0-49eb-936e-1e6ada54dd0e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	074f93b5-b14c-43a4-9b32-ffa1f94d5238	8f614e9c-5fb0-49eb-936e-1e6ada54dd0e	\N	2021-10-26 09:36:45	2022-12-01 10:23:15	\N	2021-12-15 08:21:53
91f2c038-2d6f-4661-b5ec-5f532f9b35ac	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	210fde58-74aa-4ea9-a4e4-ab32b37448b1	91f2c038-2d6f-4661-b5ec-5f532f9b35ac	\N	2021-10-26 09:36:45	2022-12-01 10:23:16	\N	2021-12-15 08:21:55
3c4a923b-8abc-4971-9831-5bb99d562723	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	9a52a3f6-c727-e211-963e-ffbc9c164446	3c4a923b-8abc-4971-9831-5bb99d562723	\N	2021-10-26 09:36:45	2022-12-01 10:23:16	\N	2021-12-15 08:21:55
22eefc82-0c69-4528-b0f0-7d51facd97b2	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	7dbbb577-7b93-48ef-b139-db84e9163597	22eefc82-0c69-4528-b0f0-7d51facd97b2	\N	2021-10-26 09:36:45	2022-12-01 10:23:16	\N	2021-12-15 08:21:54
29fcfa71-609c-42fd-99c1-b87c23bf80d8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	ea543c35-e3d7-484c-b472-6d5a88afd4eb	29fcfa71-609c-42fd-99c1-b87c23bf80d8	\N	2021-10-26 09:36:45	2022-12-01 10:23:16	\N	2021-12-15 08:21:54
5d02aaca-01a9-421f-a40a-6cabd2791163	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	330c1f39-a513-4841-88ce-6bbdbb912d1c	5d02aaca-01a9-421f-a40a-6cabd2791163	\N	2021-10-26 09:36:45	2022-12-01 10:23:17	\N	2021-12-15 08:21:55
c6cefc01-70ec-4965-b9e2-4965cf05ae20	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	0312c3d7-fde1-47cf-96ce-1f87a4228787	c6cefc01-70ec-4965-b9e2-4965cf05ae20	\N	2021-10-26 09:36:45	2022-12-01 10:23:19	\N	2021-12-15 08:21:54
30373932-fa49-4847-94bb-ba972206eed7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	1241af67-55ab-4f95-bb4a-3232166b1551	097f5676-e6b8-4033-9b17-43eb6a4145bf	30373932-fa49-4847-94bb-ba972206eed7	\N	2021-03-30 09:19:36	2022-12-01 10:23:22	\N	2021-05-19 12:39:14
27f47461-e62f-4e8d-9cbb-1659c4e0ea56	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	7bd0404c-9603-e211-b291-0143ed05e022	27f47461-e62f-4e8d-9cbb-1659c4e0ea56	\N	2021-10-26 09:36:45	2022-12-01 10:23:22	\N	2021-12-15 08:21:54
4a195b4b-0e05-4883-aefd-23654b8470df	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	b8597d0a-533b-11e5-af98-8f68bbe85388	4a195b4b-0e05-4883-aefd-23654b8470df	\N	2021-10-26 09:36:45	2022-12-01 10:23:24	\N	2021-12-15 08:21:53
3ca4fbb8-7477-4343-b4f6-ccb90afd846f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	b16d2e16-b656-42e0-b339-9af32b3bc87f	9a2404f7-9299-444f-b56e-2f3bcad3b930	3ca4fbb8-7477-4343-b4f6-ccb90afd846f	\N	2021-03-30 09:19:33	2022-12-01 10:23:24	\N	2021-05-19 12:39:12
401ace32-00c1-452f-8426-3ebffc6aa861	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	7c1dce1f-2cd6-4be9-9c6e-2f7840e164e1	401ace32-00c1-452f-8426-3ebffc6aa861	\N	2021-10-26 09:36:45	2022-12-01 10:23:24	\N	2021-12-15 08:21:54
5e4f57ad-d57e-45ab-b41b-05bdca1f31b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	7df870be-f674-4ed1-bf50-340cbfdc845a	5e4f57ad-d57e-45ab-b41b-05bdca1f31b7	\N	2021-10-26 09:36:45	2022-12-01 10:23:26	\N	2021-12-15 08:21:53
02c4d453-9623-4cd0-938a-f18b12d8620a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	8462527e-862e-4b54-b09b-a9c99a9f276d	02c4d453-9623-4cd0-938a-f18b12d8620a	\N	2021-10-26 09:36:45	2022-12-01 10:23:26	\N	2021-12-15 08:21:54
af952af6-6974-4b75-9768-22e39b04bfec	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	99f38034-4a28-11e5-a3b9-ff498a91b449	af952af6-6974-4b75-9768-22e39b04bfec	\N	2021-10-26 09:36:45	2022-12-01 10:23:29	\N	2021-12-15 08:21:53
76f38a8e-3c2e-40e3-9a03-2a2e115baf7a	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	fb87b96f-09f8-4d63-b7fd-69dcc5b773ec	76f38a8e-3c2e-40e3-9a03-2a2e115baf7a	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
7c9870e5-13f7-4ae6-bf4a-62de61694fa7	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	908d3144-1488-45c1-b6b0-03c9467478a2	3c03a4be-e8d5-4e2a-8cc0-69f036d03c40	7c9870e5-13f7-4ae6-bf4a-62de61694fa7	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d1325211-cfb9-4de9-8657-478700047e1b	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	9f0563d6-3812-423e-bb7f-6af29c5fe4a8	d1325211-cfb9-4de9-8657-478700047e1b	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
34c0219b-9dd7-46f0-b1f8-fc784966cc8f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	6b386d16-ac7e-4c9b-98ec-6b739202b490	34c0219b-9dd7-46f0-b1f8-fc784966cc8f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
50b55537-47da-4238-9fbc-bbc05a7c12d8	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	2ebac5a2-7e8b-49af-a036-25c445fcfcce	ddafc7c0-50ea-11e4-be84-6b7b63e80b96	50b55537-47da-4238-9fbc-bbc05a7c12d8	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
0b5ef3bd-4770-431f-871a-53eb9ed5bff5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	4d9b2ae1-1eee-4a86-a1d9-c49c9bd26eda	35132721-6c88-4402-93f8-f0d9a58f5155	\N	2021-10-26 09:36:45	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-11-03 09:43:03
ef18b1d4-10b0-48ea-835a-91ee78e1d71f	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	27304008-f2e2-4b4b-b502-f08b37f89175	8976a7e5-aebb-4b27-8011-ba1ba5bfb509	eb0a4da4-809c-498a-8255-569b22253f03	\N	2021-10-26 09:36:45	2022-04-05 07:37:46	2022-04-05 07:37:46	2021-12-15 08:21:53
c3451146-9d56-4df7-973f-e568f6479716	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20202	530e611d-9696-4b57-9b94-20cc1075bd50	7974ee38-74c9-4af8-8b30-3839e0449e51	730f5853-1a6c-4f75-82b5-fbea9c951310	\N	2021-03-30 09:19:34	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-05-19 12:39:12
cdb8d25f-df51-405a-ba05-fa7b37e9129a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	6ef941cd-f503-e211-a8c9-8de20f7d3878	cdb8d25f-df51-405a-ba05-fa7b37e9129a	\N	2021-10-26 09:36:45	2022-12-01 10:22:48	\N	2021-12-15 08:21:54
c54baecc-6bc9-44a3-b503-077a49fa09ef	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	f530a57f-1b10-e211-9570-4d846480b264	c54baecc-6bc9-44a3-b503-077a49fa09ef	\N	2021-10-26 09:36:45	2022-12-01 10:22:50	\N	2021-12-15 08:21:53
290e970d-7cbf-4dcf-8cef-8e00adb76e4e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	724ef4b0-3f1e-e211-ad21-a3a026533b4a	290e970d-7cbf-4dcf-8cef-8e00adb76e4e	\N	2021-10-26 09:36:46	2022-12-01 10:22:52	\N	2021-12-15 08:21:53
cdf642f3-c01c-4b44-8e07-0010ee7b86a3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	0e3ca3aa-8e03-e211-8560-17962475f905	cdf642f3-c01c-4b44-8e07-0010ee7b86a3	\N	2021-10-26 09:36:46	2022-12-01 10:22:53	\N	2021-12-15 08:21:54
10d45efa-cd31-4714-853a-07c776b4f2a7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	667a149e-7929-e211-ab63-417b9cc965f1	10d45efa-cd31-4714-853a-07c776b4f2a7	\N	2021-10-26 09:36:46	2022-12-01 10:22:56	\N	2021-12-15 08:21:55
8d20bce1-ae7f-480d-8126-a596d8f9bc03	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	8fc2228e-db1c-40eb-ba6c-d38d2ebe88f1	8d20bce1-ae7f-480d-8126-a596d8f9bc03	\N	2021-10-26 09:36:46	2022-12-01 10:22:56	\N	2021-12-15 08:21:54
08427320-06f6-4d4f-81b4-0a10a2d8a6bf	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	6c136cf3-8b03-e211-8560-17962475f905	08427320-06f6-4d4f-81b4-0a10a2d8a6bf	\N	2021-10-26 09:36:46	2022-12-01 10:22:56	\N	2021-12-15 08:21:53
372454dd-ab3c-481b-b9cb-fc7b170e7776	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	e2213614-223e-44e1-ae21-f210949b0689	372454dd-ab3c-481b-b9cb-fc7b170e7776	\N	2021-10-26 09:36:46	2022-12-01 10:22:57	\N	2021-12-15 08:21:55
dd62b435-2fd2-4bb4-b756-14bd986c8d74	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	ee6c19ac-dab6-4724-b4a4-d743f9ab3197	dd62b435-2fd2-4bb4-b756-14bd986c8d74	\N	2021-10-26 09:36:46	2022-12-01 10:22:57	\N	2021-12-15 08:21:54
1187408e-8342-4b58-8e88-d2d749f4d2be	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	daa07555-dd3d-44da-856b-28f08ecd474e	1187408e-8342-4b58-8e88-d2d749f4d2be	\N	2021-10-26 09:36:46	2022-12-01 10:22:58	\N	2021-12-15 08:21:55
f3df02f9-068a-4aa7-b42c-49ffb29dc25a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	e69398c4-8a47-4d33-aa9e-c992acd5ec31	f3df02f9-068a-4aa7-b42c-49ffb29dc25a	\N	2021-10-26 09:36:46	2022-12-01 10:22:59	\N	2021-12-15 08:21:53
827f175d-0ca2-4959-b236-4bb944838353	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	c5a8400a-c2c6-4bff-9a5f-eed513cc6701	827f175d-0ca2-4959-b236-4bb944838353	\N	2021-10-26 09:36:46	2022-12-01 10:22:59	\N	2021-12-15 08:21:53
a7eb275e-4814-43db-aea9-89aed5da91b7	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	a968b612-4bac-11e5-bce0-9f0e431a474f	a7eb275e-4814-43db-aea9-89aed5da91b7	\N	2021-10-26 09:36:46	2022-12-01 10:23:00	\N	2021-12-15 08:21:55
de26e26b-aaee-47cb-9314-3aa44ed6047c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	670f6887-1fa8-427e-bd1a-7b02ee2d3d3b	de26e26b-aaee-47cb-9314-3aa44ed6047c	\N	2021-10-26 09:36:46	2022-12-01 10:23:02	\N	2021-12-15 08:21:55
6adb583e-b4de-4c1c-a139-896a9953870b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	63a8490b-068c-45da-92b9-da3c07470b9a	6adb583e-b4de-4c1c-a139-896a9953870b	\N	2021-10-26 09:36:46	2022-12-01 10:23:02	\N	2021-12-15 08:21:55
d1d7ac9c-2b3d-4aae-97f9-a0e4a0d209b9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	27304008-f2e2-4b4b-b502-f08b37f89175	38ceb9f3-db02-e211-b4b6-b3231a53305c	d1d7ac9c-2b3d-4aae-97f9-a0e4a0d209b9	\N	2021-10-26 09:36:46	2022-12-01 10:23:04	\N	2021-12-15 08:21:54
0b5dc5ff-adae-488c-91f3-82010b2d32c3	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	2f627335-3b69-4db3-94e3-0a43968e23e9	0b5dc5ff-adae-488c-91f3-82010b2d32c3	\N	2021-10-26 09:36:46	2022-12-01 10:23:05	\N	2021-12-15 08:21:55
67b27e86-3031-42b2-af40-691b40455977	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	7a13c707-8f03-e211-8560-17962475f905	67b27e86-3031-42b2-af40-691b40455977	\N	2021-10-26 09:36:46	2022-12-01 10:23:06	\N	2021-12-15 08:21:55
e708247e-1dd6-4558-8a45-61443b00efb6	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	00e6f0c6-c214-4588-90c0-4a271deaa2c9	e708247e-1dd6-4558-8a45-61443b00efb6	\N	2021-10-26 09:36:46	2022-12-01 10:23:08	\N	2021-12-15 08:21:55
9e2fa97e-1c73-4f27-83bc-d082bc641bc5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	a80be64e-5393-49df-a6f7-8a18736444a1	9e2fa97e-1c73-4f27-83bc-d082bc641bc5	\N	2021-10-26 09:36:46	2022-12-01 10:23:11	\N	2021-12-15 08:21:55
8a5eb999-8bf8-4a2a-94a9-87090a38da77	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	489e1454-e4ac-47cc-b7d0-51c8ff56abbf	8a5eb999-8bf8-4a2a-94a9-87090a38da77	\N	2021-10-26 09:36:46	2022-12-01 10:23:11	\N	2021-12-15 08:21:55
1ffa37bc-9384-435b-a020-5fc855e1d393	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	72cfdfda-231c-e211-b5fb-9d36c7d7cb09	1ffa37bc-9384-435b-a020-5fc855e1d393	\N	2021-10-26 09:36:46	2022-12-01 10:23:12	\N	2021-12-15 08:21:54
76bddf2e-c52b-4551-8ef2-fe0056fbd84b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	4697a155-d7d0-438e-8447-e684bde0b0c0	76bddf2e-c52b-4551-8ef2-fe0056fbd84b	\N	2021-10-26 09:36:46	2022-12-01 10:23:13	\N	2021-12-15 08:21:53
d7ccb2a7-fecc-4beb-ad60-a80451ff501a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	57ce637d-8acd-e211-b850-d12bb761bc4d	d7ccb2a7-fecc-4beb-ad60-a80451ff501a	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:54
852b03ea-b00d-4251-b11d-910457f49407	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	14fba9a1-6ca4-4937-84e7-2a845d02897a	852b03ea-b00d-4251-b11d-910457f49407	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:55
7b25500f-6d4d-4288-bd3c-d8d7c67c7860	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	39ad86b6-8d4d-41a9-8d48-b0e453c692d7	7b25500f-6d4d-4288-bd3c-d8d7c67c7860	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:54
941faf0a-40f3-403a-9e6d-18c483e78f28	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	ba02677d-8acd-e211-b8a5-d12bb761bc4d	941faf0a-40f3-403a-9e6d-18c483e78f28	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:54
a4f9d5c8-9950-4367-9bd7-eee086cc0016	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	9adb667d-8acd-e211-b8a0-d12bb761bc4d	a4f9d5c8-9950-4367-9bd7-eee086cc0016	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:53
8bd2434d-7a20-4c78-a742-5479515a9b52	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	060b637d-8acd-e211-b83a-d12bb761bc4d	8bd2434d-7a20-4c78-a742-5479515a9b52	\N	2021-10-26 09:36:46	2022-12-01 10:23:15	\N	2021-12-15 08:21:54
b5e7670c-e56e-4d4b-b720-b484849393e5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	30f08dcb-62b7-45b1-94d3-8587dc71f5a6	29d04843-7d39-48d9-9720-ea6c03d77e52	b5e7670c-e56e-4d4b-b720-b484849393e5	\N	2021-10-26 09:36:46	2022-12-01 10:23:16	\N	2021-12-15 08:21:54
8003a901-17e6-44ec-914f-7d423b26a6b1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	660fba7b-08e9-47fa-be7b-ffaef1150339	8003a901-17e6-44ec-914f-7d423b26a6b1	\N	2021-10-26 09:36:46	2022-12-01 10:23:22	\N	2021-12-15 08:21:55
ee71b195-efad-4793-acad-4553d799792d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	3b0b4884-726c-4551-9f8c-3db4d502c5f4	ee71b195-efad-4793-acad-4553d799792d	\N	2021-10-26 09:36:46	2022-12-01 10:23:22	\N	2021-12-15 08:21:55
dcc40278-1828-4b2c-a3f1-25453511ff1e	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	91a30c77-bf27-e211-963e-ffbc9c164446	dcc40278-1828-4b2c-a3f1-25453511ff1e	\N	2021-10-26 09:36:46	2022-12-01 10:23:24	\N	2021-12-15 08:21:55
ded0c60c-8518-4dd0-8c22-d45daa752708	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	9c53d522-5752-4556-82d0-660186bcecdc	ded0c60c-8518-4dd0-8c22-d45daa752708	\N	2021-10-26 09:36:46	2022-12-01 10:23:25	\N	2021-12-15 08:21:53
6568cdb1-69ca-40a4-8a4d-fa7e947df607	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	374d54fa-9d39-4cec-99c8-b405824d8696	6568cdb1-69ca-40a4-8a4d-fa7e947df607	\N	2021-10-26 09:36:46	2022-12-01 10:23:25	\N	2021-12-15 08:21:54
7f14b542-ecdf-483c-83e2-dc6b2cfdc73b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	645aba46-378c-11e4-a83f-afbd60abf5c3	7f14b542-ecdf-483c-83e2-dc6b2cfdc73b	\N	2021-10-26 09:36:46	2022-12-01 10:23:26	\N	2021-12-15 08:21:55
8dc1f1f0-4a95-46f8-b597-20d57812a0c9	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	4e3a22a4-98e9-4024-a519-7a05be9167c8	8dc1f1f0-4a95-46f8-b597-20d57812a0c9	\N	2021-10-26 09:36:46	2022-12-01 10:23:26	\N	2021-12-15 08:21:54
718952c2-1012-4f03-9452-60596b0d788b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	bfc8b844-394c-48b0-b8a5-27643ae71c6f	718952c2-1012-4f03-9452-60596b0d788b	\N	2021-10-26 09:36:46	2022-12-01 10:23:26	\N	2021-12-15 08:21:55
51a3020f-72c7-4445-8448-8fcec820fff1	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	feedc192-f1f1-4ed6-bbaf-ff4c44f2d97b	51a3020f-72c7-4445-8448-8fcec820fff1	\N	2021-10-26 09:36:46	2022-12-01 10:23:29	\N	2021-12-15 08:21:54
4be2e1f3-3af5-4965-9028-fd53089ae13b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	e98a52c9-013b-4a3d-aeaa-a3738ed9ec63	4be2e1f3-3af5-4965-9028-fd53089ae13b	\N	2021-10-26 09:36:46	2022-12-01 10:23:30	\N	2021-12-15 08:21:55
7ce7e08a-f543-430c-98f7-171080207906	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	300fc42e-da78-4471-a106-c103a9ad6672	aed304bd-da2c-4118-86a2-6b8b725b1d35	7ce7e08a-f543-430c-98f7-171080207906	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
6b823dd5-1cc3-4664-8d98-741cd2e0752f	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3f6854dc-951c-4394-863a-6af4bfbfbd16	e3835c35-ab19-4184-b7eb-6bc0e467e171	6b823dd5-1cc3-4664-8d98-741cd2e0752f	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
96a20f5f-dc31-41ad-887b-2035a59931e9	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	d9267e77-220c-4668-8911-845797905234	2d889d97-430b-4588-b7d0-6caff201c1f1	96a20f5f-dc31-41ad-887b-2035a59931e9	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
d612e060-d156-4548-a590-1a90d509434d	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c16a4b50-c261-4969-9282-a6217f6b3956	9e2936fd-c013-e211-bad6-6f82fde22940	d612e060-d156-4548-a590-1a90d509434d	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
6dbb2277-c088-47b0-96bf-25a0d51a5235	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	3cf0fcee-b76e-46e8-b586-960f17255e83	c6575554-2732-4275-acd1-7011970a177d	6dbb2277-c088-47b0-96bf-25a0d51a5235	\N	2023-11-20 07:50:43	2023-11-20 07:50:43	\N	2023-10-21 07:50:43
e025d08d-8742-48d0-8915-78b646917f35	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	c15e0484-2e98-49d8-8c55-6eace3315fe7	2322a987-1791-e211-9df0-7344bb5475f7	e025d08d-8742-48d0-8915-78b646917f35	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
e3b12ccd-74d5-4120-8328-a4bcc29077bb	dd1c2167-17dc-405f-b909-2d41e686d6a8	20231	99c1e6b2-f5df-4808-97f4-6e6ef04b8819	832074e6-cef0-11e5-817c-734f9b1a9437	e3b12ccd-74d5-4120-8328-a4bcc29077bb	\N	2023-11-20 07:50:44	2023-11-20 07:50:44	\N	2023-10-21 07:50:44
4f8476e8-5dd7-411b-84a4-9ab84b404226	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	7abb5fc8-521d-4533-b63e-d83778b215f5	2a7f9380-3df4-4e45-8c46-99a3b6f76aa9	\N	2021-10-26 09:36:46	2021-12-15 08:21:07	2021-12-15 08:21:07	2021-11-03 09:43:04
b7d35684-1608-4c48-8ab1-1c092d329a83	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	27304008-f2e2-4b4b-b502-f08b37f89175	52697bc1-e927-e211-86f6-79cd2fac9006	b7d35684-1608-4c48-8ab1-1c092d329a83	\N	2021-10-26 09:36:46	2022-12-01 10:22:49	\N	2021-12-15 08:21:55
dd972f80-00a9-4e26-91d5-c88be43282dd	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	d4df8310-5179-4fcd-9e3f-a88c42cffb8f	0494c011-fd20-411c-b6f3-022d10cfb1b4	dd972f80-00a9-4e26-91d5-c88be43282dd	\N	2021-10-26 09:36:46	2022-12-01 10:22:50	\N	2021-12-15 08:21:53
9b8317a7-73b6-44a2-8ce4-de179fc98176	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	fc887591-cc90-441b-ab14-7f04d4488c3b	9b8317a7-73b6-44a2-8ce4-de179fc98176	\N	2021-10-26 09:36:46	2022-12-01 10:22:50	\N	2021-12-15 08:21:53
ba47c0dd-8926-4fb6-826e-fc5e4ee6c2eb	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	4e3df8d9-0602-e211-8442-77d6f35b44ad	ba47c0dd-8926-4fb6-826e-fc5e4ee6c2eb	\N	2021-10-26 09:36:46	2022-12-01 10:22:51	\N	2021-12-15 08:21:53
232cc7da-cf12-4daa-9600-e30d6094c52b	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	7363a404-46e9-11e5-8413-7fabf05ee1fd	232cc7da-cf12-4daa-9600-e30d6094c52b	\N	2021-10-26 09:36:46	2022-12-01 10:22:51	\N	2021-12-15 08:21:53
a96bd176-bd72-4b69-bf0f-bf08e268de8a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	f4b623a3-5e45-4f41-b23f-dc61a368d038	b3d74216-101c-e211-af82-4f62965233f9	a96bd176-bd72-4b69-bf0f-bf08e268de8a	\N	2021-10-26 09:36:46	2022-12-01 10:22:51	\N	2021-12-15 08:21:55
c164ea3c-0fae-44e9-9688-1186a02295ce	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	9afa5a3c-dcdd-4f8d-a1f7-d205c0eded05	c164ea3c-0fae-44e9-9688-1186a02295ce	\N	2021-10-26 09:36:46	2022-12-01 10:22:52	\N	2021-12-15 08:21:53
6647d34e-9662-487c-8991-7102e96e3324	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	27304008-f2e2-4b4b-b502-f08b37f89175	e4c87cc1-e927-e211-86f7-79cd2fac9006	6647d34e-9662-487c-8991-7102e96e3324	\N	2021-10-26 09:36:46	2022-12-01 10:22:53	\N	2021-12-15 08:21:53
57f212d3-ec04-4732-bff2-39fb09623bed	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	09e41ace-60f6-11e4-ad9d-9f60a68fe678	57f212d3-ec04-4732-bff2-39fb09623bed	\N	2021-10-26 09:36:47	2022-12-01 10:22:53	\N	2021-12-15 08:21:53
b0ffce47-0e34-4f0c-bc15-356b01da7425	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	de17712a-5a19-4e75-a46b-b35e1eadf244	56fbd12f-009d-4448-b9ce-76e42ea92a41	b0ffce47-0e34-4f0c-bc15-356b01da7425	\N	2021-10-26 09:36:47	2022-12-01 10:22:55	\N	2021-12-15 08:21:55
a194cf18-80e0-45ec-98b6-58a3100af11c	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	0fbf3e21-f403-e211-a8c9-8de20f7d3878	a194cf18-80e0-45ec-98b6-58a3100af11c	\N	2021-10-26 09:36:46	2022-12-01 10:22:55	\N	2021-12-15 08:21:53
b2bc94a7-3f81-476d-b9a6-f17bc5d80630	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c6a2d411-8d43-41bb-9cbe-5f169b9241cd	d6da0950-f65b-47d2-9965-579b90b08ffd	b2bc94a7-3f81-476d-b9a6-f17bc5d80630	\N	2021-10-26 09:36:46	2022-12-01 10:22:56	\N	2021-12-15 08:21:55
3458c08e-d732-4c3b-bc88-4754d716d2de	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	8fcaf4c9-7bff-4768-9863-f0778ed68017	3458c08e-d732-4c3b-bc88-4754d716d2de	\N	2021-10-26 09:36:46	2022-12-01 10:22:57	\N	2021-12-15 08:21:54
7d088f7d-6427-418f-8e70-974eb2010c1a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	3da4d2df-44a1-4444-85d6-cf168782c8c7	ea363a5f-9119-468b-8fea-9187ba92c13e	7d088f7d-6427-418f-8e70-974eb2010c1a	\N	2021-10-26 09:36:46	2022-12-01 10:22:58	\N	2021-12-15 08:21:54
0e332344-a578-4a65-9416-d4936dba9c79	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c0c2351d-0d16-4f91-b613-b65a40eeeee8	8366667d-8acd-e211-b897-d12bb761bc4d	0e332344-a578-4a65-9416-d4936dba9c79	\N	2021-10-26 09:36:46	2022-12-01 10:22:58	\N	2021-12-15 08:21:53
f460a2a3-d70f-4265-9620-56956148ba30	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	7150b495-1628-e211-b4b8-6bfa6b3aea03	f460a2a3-d70f-4265-9620-56956148ba30	\N	2021-10-26 09:36:47	2022-12-01 10:23:00	\N	2021-12-15 08:21:54
d55b9eb7-3253-4f16-96a0-4195a5e4a17d	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	f59b1bb2-1e58-4760-b504-5ee5de14aba7	d55b9eb7-3253-4f16-96a0-4195a5e4a17d	\N	2021-10-26 09:36:46	2022-12-01 10:23:02	\N	2021-12-15 08:21:53
a45421e9-27be-4322-b2ab-ffdaaea01fb0	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	e18f573f-1bf4-471c-9710-459d90fbe50a	2ddac1d3-c129-e211-82ed-4bf89d6bb6ec	a45421e9-27be-4322-b2ab-ffdaaea01fb0	\N	2021-10-26 09:36:47	2022-12-01 10:23:04	\N	2021-12-15 08:21:55
7d93ed1a-617b-41e7-98ef-86ae4addd6aa	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	30f08dcb-62b7-45b1-94d3-8587dc71f5a6	ea745b98-c427-e211-963e-ffbc9c164446	7d93ed1a-617b-41e7-98ef-86ae4addd6aa	\N	2021-10-26 09:36:47	2022-12-01 10:23:05	\N	2021-12-15 08:21:55
cbc485ab-f429-4e2c-9107-1968b614959a	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	1108e32d-0d3f-422f-b7a4-d58f8626a0bc	4b4f5a76-9080-40c6-9a32-0ee2fd7023b0	cbc485ab-f429-4e2c-9107-1968b614959a	\N	2021-10-26 09:36:46	2022-12-01 10:23:07	\N	2021-12-15 08:21:53
4416b4dd-65ea-4861-8c9d-7aba4b271cf5	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	8025c46b-4b49-4795-a74a-401a5658674f	78027dc1-f7e5-434a-b0c3-767f331840bb	4416b4dd-65ea-4861-8c9d-7aba4b271cf5	\N	2021-10-26 09:36:47	2022-12-01 10:23:07	\N	2021-12-15 08:21:55
c86bb09d-a066-47c4-bf71-daba3e5ec7f8	39f5eb74-4722-4aaf-a6af-2c6e972e5885	20211	c2ff6cac-087e-44ba-ad85-230e0f025214	7c15fbb2-33c9-4ba2-93a4-b9d988e939b4	c86bb09d-a066-47c4-bf71-daba3e5ec7f8	\N	2021-10-26 09:36:47	2022-12-01 10:23:07	\N	2021-12-15 08:21:55
ad0aeff3-7eb4-4081-bf5f-e0ce93996044	39f5eb74-472